/** @type {import("tailwindcss").Config} */


module.exports = {
  mode: "jit",
  content: [
    "./components/**/*.{js,vue,ts}",
    "./layouts/**/*.vue",
    "./pages/**/*.vue",
    "./plugins/**/*.{js,ts}",
    "./nuxt.config.{js,ts}",
    "./app.vue"

  ],
  safelist: ["w-container, max-w-container"],
  theme: {
    extend: {
      transitionProperty: {
        width: "width"
      },
      width: {
        container: "73.125rem"
      },
      maxWidth: {
        container: "73.125rem"
      },
      fontFamily: {
        sans: ["Poppins", "sans-serif"],
        serif: ["Poppins", "serif"]
      },

      colors: {
        primary: {
          DEFAULT: "#002055", // La teinte "normale" ou "de base"
          light: "#4C6287", // Une teinte légèrement plus claire
          lighter: "#A1A9C2", // Une teinte encore plus claire
          lightest: "#E7E9EF" // La teinte la plus claire
        },
        secondary: {
          DEFAULT: "#96B938", // La teinte "normale" ou "de base"
          light: "#BBD17E", // Une teinte légèrement plus claire
          lighter: "#D5E3AF", // Une teinte encore plus claire
          lightest: "#EAF1D7" // La teinte la plus claire
        },
        ternary: {
          DEFAULT: "#00A2B3", // La teinte "normale" ou "de base"
          light: "#58C2CD", // Une teinte légèrement plus claire
          lighter: "#9ADAE1", // Une teinte encore plus claire
          lightest: "#CCECF0" // La teinte la plus claire
        },
        neutral: {
          DEFAULT: "#202020", // La teinte "normale" ou "de base"
          light: "#585858", // Une teinte légèrement plus claire
          lighter: "#9A9A9A", // Une teinte encore plus claire
          lightest: "#E8E8E8" // La teinte la plus claire
        },
        fire: "#DBA511",
        background: {
          1: "#F0F2F5",
          2: "#CACFDC",
          3: "#F3F4F7"
        }
      },
      typography: ({ theme }) => ({
        funargos: {
          css: {
            "--tw-prose-body": theme("colors.neutral[lighter]"),
            "--tw-prose-headings": theme("colors.pink[900]"),
            "--tw-prose-lead": theme("colors.pink[700]"),
            "--tw-prose-links": theme("colors.pink[900]"),
            "--tw-prose-bold": theme("colors.pink[900]"),
            "--tw-prose-counters": theme("colors.pink[600]"),
            "--tw-prose-bullets": theme("colors.pink[400]"),
            "--tw-prose-hr": theme("colors.pink[300]"),
            "--tw-prose-quotes": theme("colors.pink[900]"),
            "--tw-prose-quote-borders": theme("colors.pink[300]"),
            "--tw-prose-captions": theme("colors.pink[700]"),
            "--tw-prose-code": theme("colors.pink[900]"),
            "--tw-prose-pre-code": theme("colors.pink[100]"),
            "--tw-prose-pre-bg": theme("colors.pink[900]"),
            "--tw-prose-th-borders": theme("colors.pink[300]"),
            "--tw-prose-td-borders": theme("colors.pink[200]")
          }
        }
      })
    }
  },
  plugins: [require("@tailwindcss/typography")]
};
