// https://nuxt.com/docs/api/configuration/nuxt-config

export default defineNuxtConfig({
  vite: {
    server: {
      hmr: {
        port: Number(process.env.FRONTEND_VITE_HMR_PORT),
        clientPort: Number(process.env.FRONTEND_VITE_HMR_PORT),
      },
    },
  },
  runtimeConfig: {
    public: {
      baseUrl: process.env.BACKEND_BASE_URL,
    },
  },

  css: [
    "~/assets/css/main.css",
    "animate.css",
    "primeicons/primeicons.css",
    "primevue/resources/primevue.css",
    "~/assets/css/primevue-theme.css",
    "~/assets/css/popper-theme.css",
  ],
  postcss: {
    plugins: {
      tailwindcss: {},
      autoprefixer: {},
    },
  },
  components: [
    { path: "~/components/form" },
    { path: "~/components/layout" },
    { path: "~/components/cards" },
    { path: "~/components/cards/routes" },
    { path: "~/components/modals" },
    "~/components",
  ],
  modules: ["@pinia/nuxt", "dayjs-nuxt", "nuxt-gtag"],
  gtag: {
    id: "G-6SYFTJ34Q5",
    initialConsent: false,
  },
  pinia: {
    autoImports: [
      // automatically imports `defineStore`
      "defineStore", // import { defineStore } from 'pinia'
      ["defineStore", "definePiniaStore"], // import { defineStore as definePiniaStore } from 'pinia'
    ],
  },
  dayjs: {
    locales: ["fr"],
    plugins: ["relativeTime", "utc", "timezone"],
    defaultLocale: "fr",
    defaultTimezone: "Europe/Paris",
  },

  build: {
    transpile: ["primevue"],
  },
  sourcemap: {
    server: true,
    client: true,
  },
});
