'use strict';

const babel = require('@babel/standalone/babel.min.js');
const loader_babel = require('./babel.cjs');
require('@babel/types');
require('../shared/untyped.84362cee.cjs');
require('scule');

function _interopNamespaceCompat(e) {
  if (e && typeof e === 'object' && 'default' in e) return e;
  const n = Object.create(null);
  if (e) {
    for (const k in e) {
      n[k] = e[k];
    }
  }
  n.default = e;
  return n;
}

const babel__namespace = /*#__PURE__*/_interopNamespaceCompat(babel);

const { transform: babelTransform } = babel__namespace.default || babel__namespace;
function transform(src, opts = {}) {
  const res = babelTransform(src, {
    filename: "src.ts",
    presets: ["typescript"],
    plugins: [[loader_babel, opts]]
  });
  return res.code;
}

exports.transform = transform;
