import * as _unhead_schema from '@unhead/schema';
import { HeadTag, TemplateParams, Head, HeadEntryOptions, ActiveHeadEntry, HeadSafe, MetaFlatInput, Title, TitleTemplate, Base, Meta, Link, Script, Style, Noscript, HtmlAttributes, BodyAttributes, Unhead, HeadPlugin, CreateHeadOptions, HeadEntry, MaybeArray } from '@unhead/schema';
import { Arrayable } from '@unhead/shared';

declare const TAG_WEIGHTS: {
    readonly critical: 2;
    readonly high: 9;
    readonly low: 12;
    readonly base: -1;
    readonly title: 1;
    readonly meta: 10;
};
declare function tagWeight<T extends HeadTag>(tag: T): any;
declare const SortModifiers: {
    prefix: string;
    offset: number;
}[];
declare function SortTagsPlugin(): _unhead_schema.HeadPlugin;

declare function TitleTemplatePlugin(): _unhead_schema.HeadPlugin;

declare function DeprecatedTagAttrPlugin(): _unhead_schema.HeadPlugin;

declare function ProvideTagHashPlugin(): _unhead_schema.HeadPlugin;

/**
 * Supports DOM event handlers (i.e `onload`) as functions.
 *
 * When SSR we need to strip out these values. On CSR we
 */
declare function EventHandlersPlugin(): _unhead_schema.HeadPlugin;

declare function DedupesTagsPlugin(): _unhead_schema.HeadPlugin;

declare function processTemplateParams(s: string, config: TemplateParams): string;
declare function TemplateParamsPlugin(): _unhead_schema.HeadPlugin;

declare function useHead<T extends Head>(input: T, options?: HeadEntryOptions): ActiveHeadEntry<T> | void;

declare function useHeadSafe(input: HeadSafe, options?: HeadEntryOptions): ActiveHeadEntry<HeadSafe> | void;

declare function useServerHead<T extends Head>(input: T, options?: HeadEntryOptions): ActiveHeadEntry<T> | void;

declare function useServerHeadSafe<T extends HeadSafe>(input: T, options?: HeadEntryOptions): ActiveHeadEntry<T> | void;

type UseSeoMetaInput = MetaFlatInput & {
    title?: Title;
    titleTemplate?: TitleTemplate;
};
declare function useSeoMeta(input: UseSeoMetaInput, options?: HeadEntryOptions): ActiveHeadEntry<any> | void;

declare function useServerSeoMeta(input: UseSeoMetaInput, options?: HeadEntryOptions): ActiveHeadEntry<any> | void;

/**
 * @deprecated Use `useHead`
 */
declare function useTagTitle(title: Title): ActiveHeadEntry<any> | void;
/**
 * @deprecated Use `useHead`
 */
declare function useTagBase(base: Base): ActiveHeadEntry<any> | void;
/**
 * @deprecated Use `useHead`
 */
declare function useTagMeta(meta: Arrayable<Meta>): ActiveHeadEntry<any> | void;
/**
 * @deprecated Use `useHead`
 */
declare function useTagMetaFlat(meta: MetaFlatInput): ActiveHeadEntry<any> | void;
/**
 * @deprecated Use `useHead`
 */
declare function useTagLink(link: Arrayable<Link>): ActiveHeadEntry<any> | void;
/**
 * @deprecated Use `useHead`
 */
declare function useTagScript(script: Arrayable<Script>): ActiveHeadEntry<any> | void;
/**
 * @deprecated Use `useHead`
 */
declare function useTagStyle(style: Arrayable<Style>): ActiveHeadEntry<any> | void;
/**
 * @deprecated Use `useHead`
 */
declare function useTagNoscript(noscript: Arrayable<Noscript>): ActiveHeadEntry<any> | void;
/**
 * @deprecated Use `useHead`
 */
declare function useHtmlAttrs(attrs: HtmlAttributes): ActiveHeadEntry<any> | void;
/**
 * @deprecated Use `useHead`
 */
declare function useBodyAttrs(attrs: BodyAttributes): ActiveHeadEntry<any> | void;
/**
 * @deprecated Use `useHead`
 */
declare function useTitleTemplate(titleTemplate: TitleTemplate): ActiveHeadEntry<any> | void;
/**
 * @deprecated Use `useHead`
 */
declare function useServerTagTitle(title: Title): ActiveHeadEntry<any> | void;
/**
 * @deprecated Use `useServerHead`
 */
declare function useServerTagBase(base: Base): ActiveHeadEntry<any> | void;
/**
 * @deprecated Use `useServerHead`
 */
declare function useServerTagMeta(meta: Arrayable<Meta>): ActiveHeadEntry<any> | void;
/**
 * @deprecated Use `useServerHead`
 */
declare function useServerTagMetaFlat(meta: MetaFlatInput): ActiveHeadEntry<any> | void;
/**
 * @deprecated Use `useServerHead`
 */
declare function useServerTagLink(link: Arrayable<Link>): ActiveHeadEntry<any> | void;
/**
 * @deprecated Use `useServerHead`
 */
declare function useServerTagScript(script: Arrayable<Script>): ActiveHeadEntry<any> | void;
/**
 * @deprecated Use `useServerHead`
 */
declare function useServerTagStyle(style: Arrayable<Style>): ActiveHeadEntry<any> | void;
/**
 * @deprecated Use `useServerHead`
 */
declare function useServerTagNoscript(noscript: Arrayable<Noscript>): ActiveHeadEntry<any> | void;
/**
 * @deprecated Use `useServerHead`
 */
declare function useServerHtmlAttrs(attrs: HtmlAttributes): ActiveHeadEntry<any> | void;
/**
 * @deprecated Use `useServerHead`
 */
declare function useServerBodyAttrs(attrs: BodyAttributes): ActiveHeadEntry<any> | void;
/**
 * @deprecated Use `useServerHead`
 */
declare function useServerTitleTemplate(titleTemplate: TitleTemplate): ActiveHeadEntry<any> | void;

declare let activeHead: Unhead<any> | undefined;
declare function setActiveHead(head: Unhead<any> | undefined): Unhead<any> | undefined;
declare function getActiveHead(): Unhead<any> | undefined;

declare function CorePlugins(): HeadPlugin[];
declare function DOMPlugins(options?: CreateHeadOptions): HeadPlugin[];
declare function createHead<T extends {} = Head>(options?: CreateHeadOptions): Unhead<T>;
declare function createServerHead<T extends {} = Head>(options?: CreateHeadOptions): Unhead<T>;
/**
 * Creates a core instance of unhead. Does not provide a global ctx for composables to work
 * and does not register DOM plugins.
 *
 * @param options
 */
declare function createHeadCore<T extends {} = Head>(options?: CreateHeadOptions): Unhead<T>;

declare const composableNames: string[];
declare const unheadComposablesImports: {
    from: string;
    imports: string[];
}[];

/**
 * Convert an array of meta entries to a flat object.
 * @param inputs
 */
declare function packMeta<T extends Required<Head>['meta']>(inputs: T): MetaFlatInput;

declare function resolveMetaKeyType(key: string): string;
declare function resolveMetaKeyValue(key: string): string;
/**
 * Converts a flat meta object into an array of meta entries.
 * @param input
 */
declare function unpackMeta<T extends MetaFlatInput>(input: T): Required<Head>['meta'];
declare function resolvePackedMetaObjectValue(value: string, key: string): string;

declare function normaliseTag<T extends HeadTag>(tagName: T['tag'], input: HeadTag['props'] | string): Promise<T | T[] | false>;
declare function normaliseClassProp(v: Required<Required<Head>['htmlAttrs']['class']>): string;
declare function normaliseProps<T extends HeadTag>(tagName: T['tag'], props: T['props']): Promise<T['props']>;
declare const TagEntityBits = 10;
declare function normaliseEntryTags<T extends {} = Head>(e: HeadEntry<T>): Promise<HeadTag[]>;

declare function whitelistSafeInput(input: Record<string, MaybeArray<Record<string, string>>>): HeadSafe;

export { CorePlugins, DOMPlugins, DedupesTagsPlugin, DeprecatedTagAttrPlugin, EventHandlersPlugin, ProvideTagHashPlugin, SortModifiers, SortTagsPlugin, TAG_WEIGHTS, TagEntityBits, TemplateParamsPlugin, TitleTemplatePlugin, UseSeoMetaInput, activeHead, composableNames, createHead, createHeadCore, createServerHead, getActiveHead, normaliseClassProp, normaliseEntryTags, normaliseProps, normaliseTag, packMeta, processTemplateParams, resolveMetaKeyType, resolveMetaKeyValue, resolvePackedMetaObjectValue, setActiveHead, tagWeight, unheadComposablesImports, unpackMeta, useBodyAttrs, useHead, useHeadSafe, useHtmlAttrs, useSeoMeta, useServerBodyAttrs, useServerHead, useServerHeadSafe, useServerHtmlAttrs, useServerSeoMeta, useServerTagBase, useServerTagLink, useServerTagMeta, useServerTagMetaFlat, useServerTagNoscript, useServerTagScript, useServerTagStyle, useServerTagTitle, useServerTitleTemplate, useTagBase, useTagLink, useTagMeta, useTagMetaFlat, useTagNoscript, useTagScript, useTagStyle, useTagTitle, useTitleTemplate, whitelistSafeInput };
