const webcrypto = globalThis.crypto;
export const subtle = webcrypto.subtle;
const MAX_BYTES = 65536;
export const randomUUID = () => {
  return webcrypto.randomUUID();
};
export const getRandomValues = (array) => {
  return webcrypto.getRandomValues(array);
};
export const randomBytes = (size, cb) => {
  const bytes = Buffer.alloc(size, 0, void 0);
  for (let generated = 0; generated < size; generated += MAX_BYTES) {
    getRandomValues(
      Uint8Array.prototype.slice.call(bytes, generated, generated + MAX_BYTES)
    );
  }
  if (typeof cb === "function") {
    cb(null, bytes);
    return;
  }
  return bytes;
};
export default {
  randomUUID,
  getRandomValues,
  randomBytes,
  subtle,
  webcrypto
};
