"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.subtle = exports.randomUUID = exports.randomBytes = exports.getRandomValues = exports.default = void 0;
const webcrypto = globalThis.crypto;
const subtle = webcrypto.subtle;
exports.subtle = subtle;
const MAX_BYTES = 65536;
const randomUUID = () => {
  return webcrypto.randomUUID();
};
exports.randomUUID = randomUUID;
const getRandomValues = array => {
  return webcrypto.getRandomValues(array);
};
exports.getRandomValues = getRandomValues;
const randomBytes = (size, cb) => {
  const bytes = Buffer.alloc(size, 0, void 0);
  for (let generated = 0; generated < size; generated += MAX_BYTES) {
    getRandomValues(Uint8Array.prototype.slice.call(bytes, generated, generated + MAX_BYTES));
  }
  if (typeof cb === "function") {
    cb(null, bytes);
    return;
  }
  return bytes;
};
exports.randomBytes = randomBytes;
var _default = {
  randomUUID,
  getRandomValues,
  randomBytes,
  subtle,
  webcrypto
};
module.exports = _default;