"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createCall = createCall;
var _request = require("../node/http/_request.cjs");
var _response = require("../node/http/_response.cjs");
function createCall(handle) {
  return function callHandle(context) {
    const req = new _request.IncomingMessage();
    const res = new _response.ServerResponse(req);
    req.url = context.url || "/";
    req.method = context.method || "GET";
    req.headers = {};
    if (context.headers) {
      const headerEntries = typeof context.headers.entries === "function" ? context.headers.entries() : Object.entries(context.headers);
      for (const [name, value] of headerEntries) {
        if (!value) {
          continue;
        }
        req.headers[name.toLowerCase()] = value;
      }
    }
    req.headers.host = req.headers.host || context.host || "localhost";
    req.connection.encrypted =
    // @ts-ignore
    req.connection.encrypted || context.protocol === "https";
    req.body = context.body || null;
    req.__unenv__ = context.context;
    return handle(req, res).then(() => {
      const r = {
        body: res._data || "",
        headers: res._headers,
        status: res.statusCode,
        statusText: res.statusMessage
      };
      req.destroy();
      res.destroy();
      return r;
    });
  };
}