"use strict";var e=require("primevue/basecomponent"),t=require("primevue/portal"),s=require("primevue/toasteventbus"),o=require("primevue/utils"),n=require("primevue/icons/check"),i=require("primevue/icons/exclamationtriangle"),a=require("primevue/icons/infocircle"),r=require("primevue/icons/times"),l=require("primevue/icons/timescircle"),c=require("primevue/ripple"),m=require("vue");function p(e){return e&&"object"==typeof e&&"default"in e?e:{default:e}}var u=p(e),d=p(t),f=p(s),g=p(n),h=p(i),v=p(a),y=p(r),I=p(l),b=p(c),x={name:"ToastMessage",extends:u.default,emits:["close"],props:{message:{type:null,default:null},templates:{type:Object,default:null},closeIcon:{type:String,default:null},infoIcon:{type:String,default:null},warnIcon:{type:String,default:null},errorIcon:{type:String,default:null},successIcon:{type:String,default:null},closeButtonProps:{type:null,default:null}},closeTimeout:null,mounted(){this.message.life&&(this.closeTimeout=setTimeout((()=>{this.close({message:this.message,type:"life-end"})}),this.message.life))},beforeUnmount(){this.clearCloseTimeout()},methods:{close(e){this.$emit("close",e)},onCloseClick(){this.clearCloseTimeout(),this.close({message:this.message,type:"close"})},clearCloseTimeout(){this.closeTimeout&&(clearTimeout(this.closeTimeout),this.closeTimeout=null)}},computed:{containerClass(){return["p-toast-message",this.message.styleClass,{"p-toast-message-info":"info"===this.message.severity,"p-toast-message-warn":"warn"===this.message.severity,"p-toast-message-error":"error"===this.message.severity,"p-toast-message-success":"success"===this.message.severity}]},iconComponent(){return{info:!this.infoIcon&&v.default,success:!this.successIcon&&g.default,warn:!this.warnIcon&&h.default,error:!this.errorIcon&&I.default}[this.message.severity]},iconClass(){return[{[this.infoIcon]:"info"===this.message.severity,[this.warnIcon]:"warn"===this.message.severity,[this.errorIcon]:"error"===this.message.severity,[this.successIcon]:"success"===this.message.severity}]},closeAriaLabel(){return this.$primevue.config.locale.aria?this.$primevue.config.locale.aria.close:void 0}},components:{TimesIcon:y.default,InfoCircleIcon:v.default,CheckIcon:g.default,ExclamationTriangleIcon:h.default,TimesCircleIcon:I.default},directives:{ripple:b.default}};const k=["aria-label"];x.render=function(e,t,s,o,n,i){const a=m.resolveDirective("ripple");return m.openBlock(),m.createElementBlock("div",m.mergeProps({class:i.containerClass,role:"alert","aria-live":"assertive","aria-atomic":"true"},e.ptm("container")),[m.createElementVNode("div",m.mergeProps({class:["p-toast-message-content",s.message.contentStyleClass]},e.ptm("content")),[s.templates.message?(m.openBlock(),m.createBlock(m.resolveDynamicComponent(s.templates.message),{key:1,message:s.message},null,8,["message"])):(m.openBlock(),m.createElementBlock(m.Fragment,{key:0},[(m.openBlock(),m.createBlock(m.resolveDynamicComponent(s.templates.icon?s.templates.icon:i.iconComponent.name?i.iconComponent:"span"),m.mergeProps({class:[i.iconClass,"p-toast-message-icon"]},e.ptm("icon")),null,16,["class"])),m.createElementVNode("div",m.mergeProps({class:"p-toast-message-text"},e.ptm("text")),[m.createElementVNode("span",m.mergeProps({class:"p-toast-summary"},e.ptm("summary")),m.toDisplayString(s.message.summary),17),m.createElementVNode("div",m.mergeProps({class:"p-toast-detail"},e.ptm("detail")),m.toDisplayString(s.message.detail),17)],16)],64)),!1!==s.message.closable?(m.openBlock(),m.createElementBlock("div",m.normalizeProps(m.mergeProps({key:2},e.ptm("buttonContainer"))),[m.withDirectives((m.openBlock(),m.createElementBlock("button",m.mergeProps({class:"p-toast-icon-close p-link",type:"button","aria-label":i.closeAriaLabel,onClick:t[0]||(t[0]=(...e)=>i.onCloseClick&&i.onCloseClick(...e)),autofocus:""},{...s.closeButtonProps,...e.ptm("button")}),[(m.openBlock(),m.createBlock(m.resolveDynamicComponent(s.templates.closeicon||"TimesIcon"),m.mergeProps({class:["p-toast-icon-close-icon",s.closeIcon]},e.ptm("buttonIcon")),null,16,["class"]))],16,k)),[[a]])],16)):m.createCommentVNode("",!0)],16)],16)};var C=0,B={name:"Toast",extends:u.default,inheritAttrs:!1,emits:["close","life-end"],props:{group:{type:String,default:null},position:{type:String,default:"top-right"},autoZIndex:{type:Boolean,default:!0},baseZIndex:{type:Number,default:0},breakpoints:{type:Object,default:null},closeIcon:{type:String,default:void 0},infoIcon:{type:String,default:void 0},warnIcon:{type:String,default:void 0},errorIcon:{type:String,default:void 0},successIcon:{type:String,default:void 0},closeButtonProps:{type:null,default:null}},data:()=>({messages:[]}),styleElement:null,mounted(){f.default.on("add",this.onAdd),f.default.on("remove-group",this.onRemoveGroup),f.default.on("remove-all-groups",this.onRemoveAllGroups),this.breakpoints&&this.createStyle()},beforeUnmount(){this.destroyStyle(),this.$refs.container&&this.autoZIndex&&o.ZIndexUtils.clear(this.$refs.container),f.default.off("add",this.onAdd),f.default.off("remove-group",this.onRemoveGroup),f.default.off("remove-all-groups",this.onRemoveAllGroups)},methods:{add(e){null==e.id&&(e.id=C++),this.messages=[...this.messages,e]},remove(e){let t=-1;for(let s=0;s<this.messages.length;s++)if(this.messages[s]===e.message){t=s;break}this.messages.splice(t,1),this.$emit(e.type,{message:e.message})},onAdd(e){this.group==e.group&&this.add(e)},onRemoveGroup(e){this.group===e&&(this.messages=[])},onRemoveAllGroups(){this.messages=[]},onEnter(){this.$refs.container.setAttribute(this.attributeSelector,""),this.autoZIndex&&o.ZIndexUtils.set("modal",this.$refs.container,this.baseZIndex||this.$primevue.config.zIndex.modal)},onLeave(){this.$refs.container&&this.autoZIndex&&o.ObjectUtils.isEmpty(this.messages)&&setTimeout((()=>{o.ZIndexUtils.clear(this.$refs.container)}),200)},createStyle(){if(!this.styleElement){this.styleElement=document.createElement("style"),this.styleElement.type="text/css",document.head.appendChild(this.styleElement);let e="";for(let t in this.breakpoints){let s="";for(let e in this.breakpoints[t])s+=e+":"+this.breakpoints[t][e]+"!important;";e+=`\n                        @media screen and (max-width: ${t}) {\n                            .p-toast[${this.attributeSelector}] {\n                                ${s}\n                            }\n                        }\n                    `}this.styleElement.innerHTML=e}},destroyStyle(){this.styleElement&&(document.head.removeChild(this.styleElement),this.styleElement=null)}},computed:{containerClass(){return["p-toast p-component p-toast-"+this.position,{"p-input-filled":"filled"===this.$primevue.config.inputStyle,"p-ripple-disabled":!1===this.$primevue.config.ripple}]},attributeSelector:()=>o.UniqueComponentId()},components:{ToastMessage:x,Portal:d.default}};!function(e,t){void 0===t&&(t={});var s=t.insertAt;if(e&&"undefined"!=typeof document){var o=document.head||document.getElementsByTagName("head")[0],n=document.createElement("style");n.type="text/css","top"===s&&o.firstChild?o.insertBefore(n,o.firstChild):o.appendChild(n),n.styleSheet?n.styleSheet.cssText=e:n.appendChild(document.createTextNode(e))}}("\n.p-toast {\n    position: fixed;\n    width: 25rem;\n}\n.p-toast-message-content {\n    display: flex;\n    align-items: flex-start;\n}\n.p-toast-message-text {\n    flex: 1 1 auto;\n}\n.p-toast-top-right {\n    top: 20px;\n    right: 20px;\n}\n.p-toast-top-left {\n    top: 20px;\n    left: 20px;\n}\n.p-toast-bottom-left {\n    bottom: 20px;\n    left: 20px;\n}\n.p-toast-bottom-right {\n    bottom: 20px;\n    right: 20px;\n}\n.p-toast-top-center {\n    top: 20px;\n    left: 50%;\n    transform: translateX(-50%);\n}\n.p-toast-bottom-center {\n    bottom: 20px;\n    left: 50%;\n    transform: translateX(-50%);\n}\n.p-toast-center {\n    left: 50%;\n    top: 50%;\n    min-width: 20vw;\n    transform: translate(-50%, -50%);\n}\n.p-toast-icon-close {\n    display: flex;\n    align-items: center;\n    justify-content: center;\n    overflow: hidden;\n    position: relative;\n}\n.p-toast-icon-close.p-link {\n    cursor: pointer;\n}\n\n/* Animations */\n.p-toast-message-enter-from {\n    opacity: 0;\n    -webkit-transform: translateY(50%);\n    -ms-transform: translateY(50%);\n    transform: translateY(50%);\n}\n.p-toast-message-leave-from {\n    max-height: 1000px;\n}\n.p-toast .p-toast-message.p-toast-message-leave-to {\n    max-height: 0;\n    opacity: 0;\n    margin-bottom: 0;\n    overflow: hidden;\n}\n.p-toast-message-enter-active {\n    -webkit-transition: transform 0.3s, opacity 0.3s;\n    transition: transform 0.3s, opacity 0.3s;\n}\n.p-toast-message-leave-active {\n    -webkit-transition: max-height 0.45s cubic-bezier(0, 1, 0, 1), opacity 0.3s, margin-bottom 0.3s;\n    transition: max-height 0.45s cubic-bezier(0, 1, 0, 1), opacity 0.3s, margin-bottom 0.3s;\n}\n"),B.render=function(e,t,s,o,n,i){const a=m.resolveComponent("ToastMessage"),r=m.resolveComponent("Portal");return m.openBlock(),m.createBlock(r,null,{default:m.withCtx((()=>[m.createElementVNode("div",m.mergeProps({ref:"container",class:i.containerClass},{...e.$attrs,...e.ptm("root")}),[m.createVNode(m.TransitionGroup,m.mergeProps({name:"p-toast-message",tag:"div",onEnter:i.onEnter,onLeave:i.onLeave},e.ptm("message")),{default:m.withCtx((()=>[(m.openBlock(!0),m.createElementBlock(m.Fragment,null,m.renderList(n.messages,(o=>(m.openBlock(),m.createBlock(a,{key:o.id,message:o,templates:e.$slots,closeIcon:s.closeIcon,infoIcon:s.infoIcon,warnIcon:s.warnIcon,errorIcon:s.errorIcon,successIcon:s.successIcon,closeButtonProps:s.closeButtonProps,onClose:t[0]||(t[0]=e=>i.remove(e)),pt:e.pt},null,8,["message","templates","closeIcon","infoIcon","warnIcon","errorIcon","successIcon","closeButtonProps","pt"])))),128))])),_:1},16,["onEnter","onLeave"])],16)])),_:1})},module.exports=B;
