import e from"primevue/basecomponent";import{openBlock as t,createElementBlock as a,mergeProps as i,createElementVNode as s,toDisplayString as n,createCommentVNode as o}from"vue";var d={name:"Knob",extends:e,emits:["update:modelValue","change"],props:{modelValue:{type:Number,default:null},size:{type:Number,default:100},disabled:{type:Boolean,default:!1},readonly:{type:Boolean,default:!1},step:{type:Number,default:1},min:{type:Number,default:0},max:{type:Number,default:100},valueColor:{type:String,default:"var(--primary-color, Black)"},rangeColor:{type:String,default:"var(--surface-border, LightGray)"},textColor:{type:String,default:"var(--text-color-secondary, Black)"},strokeWidth:{type:Number,default:14},showValue:{type:Boolean,default:!0},valueTemplate:{type:String,default:"{value}"},tabindex:{type:Number,default:0},"aria-labelledby":{type:String,default:null},"aria-label":{type:String,default:null}},data:()=>({radius:40,midX:50,midY:50,minRadians:4*Math.PI/3,maxRadians:-Math.PI/3}),methods:{updateValue(e,t){let a=e-this.size/2,i=this.size/2-t,s=Math.atan2(i,a),n=-Math.PI/2-Math.PI/6;this.updateModel(s,n)},updateModel(e,t){let a;if(e>this.maxRadians)a=this.mapRange(e,this.minRadians,this.maxRadians,this.min,this.max);else{if(!(e<t))return;a=this.mapRange(e+2*Math.PI,this.minRadians,this.maxRadians,this.min,this.max)}let i=Math.round((a-this.min)/this.step)*this.step+this.min;this.$emit("update:modelValue",i),this.$emit("change",i)},updateModelValue(e){e>this.max?this.$emit("update:modelValue",this.max):e<this.min?this.$emit("update:modelValue",this.min):this.$emit("update:modelValue",e)},mapRange:(e,t,a,i,s)=>(e-t)*(s-i)/(a-t)+i,onClick(e){this.disabled||this.readonly||this.updateValue(e.offsetX,e.offsetY)},onMouseDown(e){this.disabled||this.readonly||(window.addEventListener("mousemove",this.onMouseMove),window.addEventListener("mouseup",this.onMouseUp),e.preventDefault())},onMouseUp(e){this.disabled||this.readonly||(window.removeEventListener("mousemove",this.onMouseMove),window.removeEventListener("mouseup",this.onMouseUp),e.preventDefault())},onTouchStart(e){this.disabled||this.readonly||(window.addEventListener("touchmove",this.onTouchMove),window.addEventListener("touchend",this.onTouchEnd),e.preventDefault())},onTouchEnd(e){this.disabled||this.readonly||(window.removeEventListener("touchmove",this.onTouchMove),window.removeEventListener("touchend",this.onTouchEnd),e.preventDefault())},onMouseMove(e){this.disabled||this.readonly||(this.updateValue(e.offsetX,e.offsetY),e.preventDefault())},onTouchMove(e){if(!this.disabled&&!this.readonly&&1==e.touches.length){const t=this.$el.getBoundingClientRect(),a=e.targetTouches.item(0),i=a.clientX-t.left,s=a.clientY-t.top;this.updateValue(i,s)}},onKeyDown(e){if(!this.disabled&&!this.readonly)switch(e.code){case"ArrowRight":case"ArrowUp":e.preventDefault(),this.updateModelValue(this.modelValue+1);break;case"ArrowLeft":case"ArrowDown":e.preventDefault(),this.updateModelValue(this.modelValue-1);break;case"Home":e.preventDefault(),this.$emit("update:modelValue",this.min);break;case"End":e.preventDefault(),this.$emit("update:modelValue",this.max);break;case"PageUp":e.preventDefault(),this.updateModelValue(this.modelValue+10);break;case"PageDown":e.preventDefault(),this.updateModelValue(this.modelValue-10)}}},computed:{containerClass(){return["p-knob p-component",{"p-disabled":this.disabled}]},rangePath(){return`M ${this.minX} ${this.minY} A ${this.radius} ${this.radius} 0 1 1 ${this.maxX} ${this.maxY}`},valuePath(){return`M ${this.zeroX} ${this.zeroY} A ${this.radius} ${this.radius} 0 ${this.largeArc} ${this.sweep} ${this.valueX} ${this.valueY}`},zeroRadians(){return this.min>0&&this.max>0?this.mapRange(this.min,this.min,this.max,this.minRadians,this.maxRadians):this.mapRange(0,this.min,this.max,this.minRadians,this.maxRadians)},valueRadians(){return this.mapRange(this.modelValue,this.min,this.max,this.minRadians,this.maxRadians)},minX(){return this.midX+Math.cos(this.minRadians)*this.radius},minY(){return this.midY-Math.sin(this.minRadians)*this.radius},maxX(){return this.midX+Math.cos(this.maxRadians)*this.radius},maxY(){return this.midY-Math.sin(this.maxRadians)*this.radius},zeroX(){return this.midX+Math.cos(this.zeroRadians)*this.radius},zeroY(){return this.midY-Math.sin(this.zeroRadians)*this.radius},valueX(){return this.midX+Math.cos(this.valueRadians)*this.radius},valueY(){return this.midY-Math.sin(this.valueRadians)*this.radius},largeArc(){return Math.abs(this.zeroRadians-this.valueRadians)<Math.PI?0:1},sweep(){return this.valueRadians>this.zeroRadians?0:1},valueToDisplay(){return this.valueTemplate.replace(/{value}/g,this.modelValue)}}};const l=["width","height","tabindex","aria-valuemin","aria-valuemax","aria-valuenow","aria-labelledby","aria-label"],r=["d","stroke-width","stroke"],h=["d","stroke-width","stroke"],u=["fill"];!function(e,t){void 0===t&&(t={});var a=t.insertAt;if(e&&"undefined"!=typeof document){var i=document.head||document.getElementsByTagName("head")[0],s=document.createElement("style");s.type="text/css","top"===a&&i.firstChild?i.insertBefore(s,i.firstChild):i.appendChild(s),s.styleSheet?s.styleSheet.cssText=e:s.appendChild(document.createTextNode(e))}}("\n@keyframes dash-frame {\n100% {\n        stroke-dashoffset: 0;\n}\n}\n.p-knob-range {\n    fill: none;\n    transition: stroke 0.1s ease-in;\n}\n.p-knob-value {\n    animation-name: dash-frame;\n    animation-fill-mode: forwards;\n    fill: none;\n}\n.p-knob-text {\n    font-size: 1.3rem;\n    text-align: center;\n}\n"),d.render=function(e,d,m,p,c,v){return t(),a("div",i({class:v.containerClass},e.ptm("root")),[(t(),a("svg",i({viewBox:"0 0 100 100",role:"slider",width:m.size,height:m.size,tabindex:m.readonly||m.disabled?-1:m.tabindex,"aria-valuemin":m.min,"aria-valuemax":m.max,"aria-valuenow":m.modelValue,"aria-labelledby":e.ariaLabelledby,"aria-label":e.ariaLabel,onClick:d[0]||(d[0]=(...e)=>v.onClick&&v.onClick(...e)),onKeydown:d[1]||(d[1]=(...e)=>v.onKeyDown&&v.onKeyDown(...e)),onMousedown:d[2]||(d[2]=(...e)=>v.onMouseDown&&v.onMouseDown(...e)),onMouseup:d[3]||(d[3]=(...e)=>v.onMouseUp&&v.onMouseUp(...e)),onTouchstart:d[4]||(d[4]=(...e)=>v.onTouchStart&&v.onTouchStart(...e)),onTouchend:d[5]||(d[5]=(...e)=>v.onTouchEnd&&v.onTouchEnd(...e))},e.ptm("svg")),[s("path",i({d:v.rangePath,"stroke-width":m.strokeWidth,stroke:m.rangeColor,class:"p-knob-range"},e.ptm("range")),null,16,r),s("path",i({d:v.valuePath,"stroke-width":m.strokeWidth,stroke:m.valueColor,class:"p-knob-value"},e.ptm("value")),null,16,h),m.showValue?(t(),a("text",i({key:0,x:50,y:57,"text-anchor":"middle",fill:m.textColor,class:"p-knob-text"},e.ptm("label")),n(v.valueToDisplay),17,u)):o("",!0)],16,l))],16)};export{d as default};
