/// <reference types="node" resolution-mode="require"/>
/// <reference types="node" resolution-mode="require"/>
import type { Fetch, GlobalContext, ParameterObject, Subschema } from "./types.js";
import { Readable } from "node:stream";
import { URL } from "node:url";
interface SchemaMap {
    [id: string]: Subschema;
}
export declare const VIRTUAL_JSON_URL = "file:///_json";
export declare function resolveSchema(filename: string): URL;
export interface LoadOptions extends GlobalContext {
    hint?: Subschema["hint"];
    auth?: string;
    rootURL: URL;
    schemas: SchemaMap;
    urlCache: Set<string>;
    httpHeaders?: Record<string, any>;
    httpMethod?: string;
    fetch: Fetch;
    parameters: Record<string, ParameterObject>;
}
export default function load(schema: URL | Subschema | Readable, options: LoadOptions): Promise<{
    [url: string]: Subschema;
}>;
export declare function getHint(path: (string | number)[], startFrom?: Subschema["hint"]): Subschema["hint"] | undefined;
export {};
