type PackageManagerName = "npm" | "yarn" | "pnpm";
interface PackageManager {
    name: PackageManagerName;
    command: string;
    version?: string;
    majorVersion?: string;
    lockFile?: string;
    files?: string[];
}

type DetectPackageManagerOptions = {
    /**
     * Whether to ignore the lock file
     *
     * @default false
     */
    ignoreLockFile?: boolean;
    /**
     * Whether to ignore the package.json file
     *
     * @default false
     */
    ignorePackageJSON?: boolean;
};
declare function detectPackageManager(cwd: string, options?: DetectPackageManagerOptions): Promise<PackageManager | undefined>;

type OperationOptions = {
    /**
     * The directory to run the command in
     *
     * @default process.cwd()
     */
    cwd?: string;
    /**
     * Whether to run the command in silent mode
     *
     * @default false
     */
    silent?: boolean;
    /**
     * The package manager info to use (auto detected)
     */
    packageManager?: PackageManager;
    /**
     * Whether to add the dependency as a dev dependency
     *
     * @default false
     */
    dev?: boolean;
    /**
     * Whether to use the workspace package manager
     * Only works only with yarn@2+, pnpm and npm
     *
     * @default false
     */
    workspace?: boolean;
};
/**
 * Add Dependency to the project
 *
 * @param name- Name of the dependency to add
 * @param _options - Options to pass to the API call
 */
declare function addDependency(name: string, _options?: OperationOptions): Promise<{}>;
/**
 * Add a dev dependency to the project
 *
 * @param name - Name of the dependency to add
 * @param _options - Options to pass to the API call
 */
declare function addDevDependency(name: string, _options?: Exclude<OperationOptions, "dev">): Promise<{}>;
/**
 * This function removes a dependency from the project
 *
 * @param name - Name of the dependency to remove
 * @param _options - Options to pass to the API call
 */
declare function removeDependency(name: string, _options?: Exclude<OperationOptions, "workspace">): Promise<{}>;

export { DetectPackageManagerOptions, OperationOptions, PackageManager, PackageManagerName, addDependency, addDevDependency, detectPackageManager, removeDependency };
