import { useRouter } from "#app/composables/router";
import { defineNuxtPlugin } from "#app/nuxt";
export default defineNuxtPlugin((nuxtApp) => {
  if (!document.startViewTransition) {
    return;
  }
  let finishTransition;
  let abortTransition;
  const router = useRouter();
  router.beforeResolve((to) => {
    if (to.meta.pageTransition === false) {
      return;
    }
    const promise = new Promise((resolve, reject) => {
      finishTransition = resolve;
      abortTransition = reject;
    });
    let changeRoute;
    const ready = new Promise((resolve) => changeRoute = resolve);
    const transition = document.startViewTransition(() => {
      changeRoute();
      return promise;
    });
    transition.finished.then(() => {
      abortTransition = void 0;
      finishTransition = void 0;
    });
    return ready;
  });
  nuxtApp.hook("vue:error", () => {
    abortTransition?.();
    abortTransition = void 0;
  });
  nuxtApp.hook("page:finish", () => {
    finishTransition?.();
    finishTransition = void 0;
  });
});
