import { createError as _createError } from "h3";
import { toRef } from "vue";
import { useNuxtApp } from "../nuxt.js";
import { useRouter } from "./router.js";
export const useError = () => toRef(useNuxtApp().payload, "error");
export const showError = (_err) => {
  const err = createError(_err);
  try {
    const nuxtApp = useNuxtApp();
    const error = useError();
    if (process.client) {
      nuxtApp.hooks.callHook("app:error", err);
    }
    error.value = error.value || err;
  } catch {
    throw err;
  }
  return err;
};
export const clearError = async (options = {}) => {
  const nuxtApp = useNuxtApp();
  const error = useError();
  nuxtApp.callHook("app:error:cleared", options);
  if (options.redirect) {
    await useRouter().replace(options.redirect);
  }
  error.value = null;
};
export const isNuxtError = (err) => !!(err && typeof err === "object" && "__nuxt_error" in err);
export const createError = (err) => {
  const _err = _createError(err);
  _err.__nuxt_error = true;
  return _err;
};
