import { withQuery } from "ufo";
import { initGtag } from "./gtag.mjs";
import { resolveTags } from "./utils.mjs";
import { defineNuxtPlugin, useHead, useRuntimeConfig } from "#imports";
export default defineNuxtPlugin({
  parallel: true,
  setup() {
    const options = useRuntimeConfig().public.gtag;
    const tags = resolveTags(options);
    if (!tags.length)
      return;
    initGtag({ tags });
    if (!options.initialConsent)
      return;
    const strategy = options.loadingStrategy === "async" ? "async" : "defer";
    useHead({
      script: [
        {
          src: withQuery(options.url, { id: tags[0].id }),
          [strategy]: true
        }
      ]
    });
  }
});
