export function gtag(command, ...args) {
  window.dataLayer?.push(arguments);
}
export function initGtag({ tags }) {
  window.dataLayer = window.dataLayer || [];
  gtag("js", /* @__PURE__ */ new Date());
  for (const tag of tags)
    gtag("config", tag.id, tag.config);
}
export function disableGtag(id) {
  window[`ga-disable-${id}`] = true;
}
export function enableGtag(id) {
  const key = `ga-disable-${id}`;
  if (key in window)
    delete window[key];
}
