import type { GoogleTagOptions } from './types';
export declare function gtag(command: string, ...args: any[]): void;
/**
 * Initialize the Google tag.
 */
export declare function initGtag({ tags }: {
    tags: GoogleTagOptions[];
}): void;
/**
 * Disable the Google tag if it is a Google Analytics property.
 *
 * @remarks
 * The Google tag library includes a `window['ga-disable-GA_MEASUREMENT_ID']`
 * property that, when set to `true`, turns off the Google tag from sending data.
 *
 * @see https://developers.google.com/analytics/devguides/collection/gtagjs/user-opt-out
 */
export declare function disableGtag(id: string): void;
/**
 * Enable Google Analytics if it was disabled before.
 */
export declare function enableGtag(id: string): void;
