import { defu } from 'defu';
import { defineNuxtModule, createResolver, addImports, addPlugin } from '@nuxt/kit';

const name = "nuxt-gtag";
const version = "1.2.1";

const module = defineNuxtModule({
  meta: {
    name,
    version,
    configKey: "gtag",
    compatibility: {
      nuxt: "^3"
    }
  },
  defaults: {
    id: "",
    config: {},
    tags: [],
    initialConsent: true,
    loadingStrategy: "defer",
    url: "https://www.googletagmanager.com/gtag/js"
  },
  setup(options, nuxt) {
    const { resolve } = createResolver(import.meta.url);
    nuxt.options.runtimeConfig.public.gtag = defu(
      nuxt.options.runtimeConfig.public.gtag,
      options
    );
    nuxt.options.build.transpile.push(resolve("runtime"));
    addImports([
      "useGtag",
      "useTrackEvent"
    ].map((name2) => ({
      name: name2,
      as: name2,
      from: resolve(`runtime/composables/${name2}`)
    })));
    addPlugin({
      src: resolve("runtime/plugin.client"),
      mode: "client"
    });
  }
});

export { module as default };
