import { t as tryResolveModule, i as importModule } from './nuxi.bd22f1f6.mjs';

const loadKit = async (rootDir) => {
  try {
    const localKit = await tryResolveModule("@nuxt/kit", rootDir);
    const rootURL = localKit ? rootDir : await tryResolveNuxt() || rootDir;
    return await importModule("@nuxt/kit", rootURL);
  } catch (e) {
    if (e.toString().includes("Cannot find module '@nuxt/kit'")) {
      throw new Error("nuxi requires `@nuxt/kit` to be installed in your project. Try installing `nuxt` v3 or `@nuxt/bridge` first.");
    }
    throw e;
  }
};
async function tryResolveNuxt() {
  for (const pkg of ["nuxt3", "nuxt", "nuxt-edge"]) {
    const path = await tryResolveModule(pkg);
    if (path) {
      return path;
    }
  }
  return null;
}

export { loadKit as l };
