import { promises } from 'node:fs';
import { d as defu } from './nuxi.a685c563.mjs';
import { g as getModulePaths, a as getNearestPackage } from './nuxi.602e8160.mjs';
import { j as join, a as relative, r as resolve, i as isAbsolute } from './nuxi.ffb4843d.mjs';

const writeTypes = async (nuxt) => {
  const modulePaths = getModulePaths(nuxt.options.modulesDir);
  const tsConfig = defu(nuxt.options.typescript?.tsConfig, {
    compilerOptions: {
      forceConsistentCasingInFileNames: true,
      jsx: "preserve",
      target: "ESNext",
      module: "ESNext",
      moduleResolution: "Node",
      skipLibCheck: true,
      strict: nuxt.options.typescript?.strict ?? false,
      allowJs: true,
      // TODO: remove by default in 3.7
      baseUrl: nuxt.options.srcDir,
      noEmit: true,
      resolveJsonModule: true,
      allowSyntheticDefaultImports: true,
      types: ["node"],
      paths: {}
    },
    include: [
      "./nuxt.d.ts",
      join(relative(nuxt.options.buildDir, nuxt.options.rootDir), "**/*"),
      ...nuxt.options.srcDir !== nuxt.options.rootDir ? [join(relative(nuxt.options.buildDir, nuxt.options.srcDir), "**/*")] : [],
      ...nuxt.options.typescript.includeWorkspace && nuxt.options.workspaceDir !== nuxt.options.rootDir ? [join(relative(nuxt.options.buildDir, nuxt.options.workspaceDir), "**/*")] : []
    ],
    exclude: [
      // nitro generate output: https://github.com/nuxt/nuxt/blob/main/packages/nuxt/src/core/nitro.ts#L186
      relative(nuxt.options.buildDir, resolve(nuxt.options.rootDir, "dist"))
    ]
  });
  const aliases = {
    ...nuxt.options.alias,
    "#build": nuxt.options.buildDir
  };
  const excludedAlias = [/^@vue\/.*$/];
  const basePath = tsConfig.compilerOptions.baseUrl ? resolve(nuxt.options.buildDir, tsConfig.compilerOptions.baseUrl) : nuxt.options.buildDir;
  tsConfig.compilerOptions = tsConfig.compilerOptions || {};
  for (const alias in aliases) {
    if (excludedAlias.some((re) => re.test(alias))) {
      continue;
    }
    const absolutePath = resolve(basePath, aliases[alias]);
    const stats = await promises.stat(absolutePath).catch(
      () => null
      /* file does not exist */
    );
    if (stats?.isDirectory()) {
      tsConfig.compilerOptions.paths[alias] = [absolutePath];
      tsConfig.compilerOptions.paths[`${alias}/*`] = [`${absolutePath}/*`];
    } else {
      tsConfig.compilerOptions.paths[alias] = [absolutePath.replace(/(?<=\w)\.\w+$/g, "")];
    }
  }
  const references = [
    ...nuxt.options.modules,
    ...nuxt.options._modules
  ].filter((f) => typeof f === "string").map((id) => ({ types: getNearestPackage(id, modulePaths)?.name || id }));
  if (nuxt.options.experimental?.reactivityTransform) {
    references.push({ types: "vue/macros-global" });
  }
  const declarations = [];
  await nuxt.callHook("prepare:types", { references, declarations, tsConfig });
  const declaration = [
    ...references.map((ref) => {
      if ("path" in ref && isAbsolute(ref.path)) {
        ref.path = relative(nuxt.options.buildDir, ref.path);
      }
      return `/// <reference ${renderAttrs(ref)} />`;
    }),
    ...declarations,
    "",
    "export {}",
    ""
  ].join("\n");
  async function writeFile() {
    const GeneratedBy = "// Generated by nuxi";
    const tsConfigPath = resolve(nuxt.options.buildDir, "tsconfig.json");
    await promises.mkdir(nuxt.options.buildDir, { recursive: true });
    await promises.writeFile(tsConfigPath, GeneratedBy + "\n" + JSON.stringify(tsConfig, null, 2));
    const declarationPath = resolve(nuxt.options.buildDir, "nuxt.d.ts");
    await promises.writeFile(declarationPath, GeneratedBy + "\n" + declaration);
  }
  nuxt.hook("builder:prepared", writeFile);
  await writeFile();
};
function renderAttrs(obj) {
  return Object.entries(obj).map((e) => renderAttr(e[0], e[1])).join(" ");
}
function renderAttr(key, value) {
  return value ? `${key}="${value}"` : "";
}

export { writeTypes as w };
