import { fileURLToPath } from 'node:url';
import { fork } from 'node:child_process';

const cliEntry = new URL("../dist/cli-run.mjs", import.meta.url);
if (process.argv[2] === "dev") {
  process.env.__CLI_ARGV__ = JSON.stringify(process.argv);
  startSubprocess();
} else {
  import(cliEntry.href);
}
function startSubprocess() {
  let childProc;
  const onShutdown = () => {
    if (childProc) {
      childProc.kill();
      childProc = void 0;
    }
  };
  process.on("exit", onShutdown);
  process.on("SIGTERM", onShutdown);
  process.on("SIGINT", onShutdown);
  process.on("SIGQUIT", onShutdown);
  start();
  function start() {
    childProc = fork(fileURLToPath(cliEntry));
    childProc.on("close", (code) => {
      if (code) {
        process.exit(code);
      }
    });
    childProc.on("message", (message) => {
      if (message?.type === "nuxt:restart") {
        childProc?.kill();
        startSubprocess();
      }
    });
  }
}
