import { e as execa } from '../shared/nuxi.e25041ef.mjs';
import { t as tryResolveModule } from '../shared/nuxi.bd22f1f6.mjs';
import { l as loadKit } from '../shared/nuxi.60154167.mjs';
import { w as writeTypes } from '../shared/nuxi.1006786a.mjs';
import { d as defineNuxtCommand } from '../shared/nuxi.c68ce99d.mjs';
import { r as resolve } from '../shared/nuxi.ffb4843d.mjs';
import 'node:buffer';
import 'node:path';
import 'node:child_process';
import 'node:process';
import '../shared/nuxi.7ccb0fe2.mjs';
import '../shared/nuxi.24198af3.mjs';
import 'child_process';
import 'path';
import 'fs';
import 'assert';
import 'events';
import 'buffer';
import 'stream';
import 'util';
import 'node:url';
import 'node:os';
import 'node:fs';
import 'node:util';
import '../shared/nuxi.f03591c1.mjs';
import 'node:module';
import 'node:assert';
import 'node:v8';
import '../shared/nuxi.a685c563.mjs';
import '../shared/nuxi.602e8160.mjs';

const typecheck = defineNuxtCommand({
  meta: {
    name: "typecheck",
    usage: "npx nuxi typecheck [--log-level] [rootDir]",
    description: "Runs `vue-tsc` to check types throughout your app."
  },
  async invoke(args, options = {}) {
    process.env.NODE_ENV = process.env.NODE_ENV || "production";
    const rootDir = resolve(args._[0] || ".");
    const { loadNuxt, buildNuxt } = await loadKit(rootDir);
    const nuxt = await loadNuxt({
      rootDir,
      overrides: {
        _prepare: true,
        logLevel: args["log-level"],
        ...options?.overrides || {}
      }
    });
    await writeTypes(nuxt);
    await buildNuxt(nuxt);
    await nuxt.close();
    const hasLocalInstall = await tryResolveModule("typescript", rootDir) && await tryResolveModule("vue-tsc/package.json", rootDir);
    if (hasLocalInstall) {
      await execa("vue-tsc", ["--noEmit"], { preferLocal: true, stdio: "inherit", cwd: rootDir });
    } else {
      await execa("npx", "-p vue-tsc -p typescript vue-tsc --noEmit".split(" "), { stdio: "inherit", cwd: rootDir });
    }
  }
});

export { typecheck as default };
