import { c as consola } from '../shared/nuxi.114b1a98.mjs';
import 'node:util';
import 'node:path';
import 'node:process';
import 'tty';
import { c as clearBuildDir } from '../shared/nuxi.04a0178b.mjs';
import { l as loadKit } from '../shared/nuxi.60154167.mjs';
import { w as writeTypes } from '../shared/nuxi.1006786a.mjs';
import { d as defineNuxtCommand } from '../shared/nuxi.c68ce99d.mjs';
import { r as resolve, a as relative } from '../shared/nuxi.ffb4843d.mjs';
import 'node:fs';
import '../shared/nuxi.bd22f1f6.mjs';
import 'node:url';
import '../shared/nuxi.f03591c1.mjs';
import 'node:module';
import 'node:assert';
import 'node:v8';
import '../shared/nuxi.a685c563.mjs';
import '../shared/nuxi.602e8160.mjs';

const prepare = defineNuxtCommand({
  meta: {
    name: "prepare",
    usage: "npx nuxi prepare [--log-level] [rootDir]",
    description: "Prepare nuxt for development/build"
  },
  async invoke(args, options = {}) {
    process.env.NODE_ENV = process.env.NODE_ENV || "production";
    const rootDir = resolve(args._[0] || ".");
    const { loadNuxt, buildNuxt } = await loadKit(rootDir);
    const nuxt = await loadNuxt({
      rootDir,
      overrides: {
        _prepare: true,
        logLevel: args["log-level"],
        ...options.overrides || {}
      }
    });
    await clearBuildDir(nuxt.options.buildDir);
    await buildNuxt(nuxt);
    await writeTypes(nuxt);
    consola.success("Types generated in", relative(process.cwd(), nuxt.options.buildDir));
  }
});

export { prepare as default };
