import { s as setupDotenv, c as chokidar } from '../shared/nuxi.1c5e9a65.mjs';
import { c as consola } from '../shared/nuxi.114b1a98.mjs';
import 'node:util';
import 'node:path';
import 'node:process';
import 'tty';
import { w as withTrailingSlash } from '../shared/nuxi.f03591c1.mjs';
import { a as showVersions, s as showBanner } from '../shared/nuxi.9ca7cc10.mjs';
import { w as writeTypes } from '../shared/nuxi.1006786a.mjs';
import { l as loadKit } from '../shared/nuxi.60154167.mjs';
import { i as importModule } from '../shared/nuxi.bd22f1f6.mjs';
import { o as overrideEnv } from '../shared/nuxi.d21ab543.mjs';
import { l as loadNuxtManifest, w as writeNuxtManifest } from '../shared/nuxi.18aa8f90.mjs';
import { c as clearBuildDir } from '../shared/nuxi.04a0178b.mjs';
import { d as defineNuxtCommand } from '../shared/nuxi.c68ce99d.mjs';
import { r as resolve, a as relative } from '../shared/nuxi.ffb4843d.mjs';
import 'node:fs';
import 'fs';
import 'path';
import 'os';
import 'crypto';
import '../shared/nuxi.24198af3.mjs';
import 'node:fs/promises';
import 'node:os';
import 'module';
import 'perf_hooks';
import 'vm';
import 'url';
import 'assert';
import 'process';
import 'v8';
import 'util';
import 'events';
import 'stream';
import 'node:module';
import 'node:url';
import 'node:assert';
import 'node:v8';
import '../shared/nuxi.a3b9dacd.mjs';
import '../shared/nuxi.602e8160.mjs';
import '../shared/nuxi.a685c563.mjs';

const DEBOUNCE_DEFAULTS = {
  trailing: true
};
function debounce(fn, wait = 25, options = {}) {
  options = { ...DEBOUNCE_DEFAULTS, ...options };
  if (!Number.isFinite(wait)) {
    throw new TypeError("Expected `wait` to be a finite number");
  }
  let leadingValue;
  let timeout;
  let resolveList = [];
  let currentPromise;
  let trailingArgs;
  const applyFn = (_this, args) => {
    currentPromise = _applyPromised(fn, _this, args);
    currentPromise.finally(() => {
      currentPromise = null;
      if (options.trailing && trailingArgs && !timeout) {
        const promise = applyFn(_this, trailingArgs);
        trailingArgs = null;
        return promise;
      }
    });
    return currentPromise;
  };
  return function(...args) {
    if (currentPromise) {
      if (options.trailing) {
        trailingArgs = args;
      }
      return currentPromise;
    }
    return new Promise((resolve) => {
      const shouldCallNow = !timeout && options.leading;
      clearTimeout(timeout);
      timeout = setTimeout(() => {
        timeout = null;
        const promise = options.leading ? leadingValue : applyFn(this, args);
        for (const _resolve of resolveList) {
          _resolve(promise);
        }
        resolveList = [];
      }, wait);
      if (shouldCallNow) {
        leadingValue = applyFn(this, args);
        resolve(leadingValue);
      } else {
        resolveList.push(resolve);
      }
    });
  };
}
async function _applyPromised(fn, _this, args) {
  return await fn.apply(_this, args);
}

const dev = defineNuxtCommand({
  meta: {
    name: "dev",
    usage: "npx nuxi dev [rootDir] [--dotenv] [--log-level] [--clipboard] [--open, -o] [--port, -p] [--host, -h] [--https] [--ssl-cert] [--ssl-key]",
    description: "Run nuxt development server"
  },
  async invoke(args, options = {}) {
    overrideEnv("development");
    const { listen } = await import('./index.mjs');
    const { toNodeListener } = await import('./index2.mjs');
    let currentHandler;
    let loadingMessage = "Nuxt is starting...";
    const loadingHandler = async (_req, res) => {
      const { loading: loadingTemplate } = await importModule("@nuxt/ui-templates");
      res.setHeader("Content-Type", "text/html; charset=UTF-8");
      res.statusCode = 503;
      res.end(loadingTemplate({ loading: loadingMessage }));
    };
    const serverHandler = (req, res) => {
      return currentHandler ? currentHandler(req, res) : loadingHandler(req, res);
    };
    const rootDir = resolve(args._[0] || ".");
    showVersions(rootDir);
    await setupDotenv({ cwd: rootDir, fileName: args.dotenv });
    const { loadNuxt, loadNuxtConfig, buildNuxt } = await loadKit(rootDir);
    const config = await loadNuxtConfig({
      cwd: rootDir,
      overrides: {
        dev: true,
        logLevel: args["log-level"],
        ...options.overrides || {}
      }
    });
    const listener = await listen(serverHandler, {
      showURL: false,
      clipboard: args.clipboard,
      open: args.open || args.o,
      port: args.port || args.p || process.env.NUXT_PORT || config.devServer.port,
      hostname: args.host || args.h || process.env.NUXT_HOST || config.devServer.host,
      https: args.https !== false && (args.https || config.devServer.https) ? {
        cert: args["ssl-cert"] || typeof config.devServer.https !== "boolean" && config.devServer.https.cert || void 0,
        key: args["ssl-key"] || typeof config.devServer.https !== "boolean" && config.devServer.https.key || void 0
      } : false
    });
    let currentNuxt;
    let distWatcher;
    const showURL = () => {
      listener.showURL({
        // TODO: Normalize URL with trailing slash within schema
        baseURL: withTrailingSlash(currentNuxt?.options.app.baseURL) || "/"
      });
    };
    async function hardRestart(reason) {
      if (process.send) {
        await listener.close().catch(() => {
        });
        await currentNuxt.close().catch(() => {
        });
        await watcher.close().catch(() => {
        });
        await distWatcher.close().catch(() => {
        });
        if (reason) {
          consola.info(`${reason ? reason + ". " : ""}Restarting nuxt...`);
        }
        process.send({ type: "nuxt:restart" });
      } else {
        await load(true, reason);
      }
    }
    const load = async (isRestart, reason) => {
      try {
        loadingMessage = `${reason ? reason + ". " : ""}${isRestart ? "Restarting" : "Starting"} nuxt...`;
        currentHandler = void 0;
        if (isRestart) {
          consola.info(loadingMessage);
        }
        if (currentNuxt) {
          await currentNuxt.close();
        }
        if (distWatcher) {
          await distWatcher.close();
        }
        currentNuxt = await loadNuxt({
          rootDir,
          dev: true,
          ready: false,
          overrides: {
            logLevel: args["log-level"],
            vite: {
              clearScreen: args.clear
            },
            ...options.overrides || {}
          }
        });
        if (!isRestart) {
          showURL();
        }
        if (!isRestart) {
          const previousManifest = await loadNuxtManifest(currentNuxt.options.buildDir);
          const newManifest = await writeNuxtManifest(currentNuxt);
          if (previousManifest && newManifest && previousManifest._hash !== newManifest._hash) {
            await clearBuildDir(currentNuxt.options.buildDir);
          }
        }
        await currentNuxt.ready();
        distWatcher = chokidar.watch(resolve(currentNuxt.options.buildDir, "dist"), { ignoreInitial: true, depth: 0 });
        distWatcher.on("unlinkDir", () => {
          dLoad(true, ".nuxt/dist directory has been removed");
        });
        const unsub = currentNuxt.hooks.hook("restart", async (options2) => {
          unsub();
          if (options2?.hard) {
            return hardRestart();
          }
          await load(true);
        });
        await currentNuxt.hooks.callHook("listen", listener.server, listener);
        const address = listener.server.address() || {};
        currentNuxt.options.devServer.url = listener.url;
        currentNuxt.options.devServer.port = address.port;
        currentNuxt.options.devServer.host = address.address;
        currentNuxt.options.devServer.https = listener.https;
        await Promise.all([
          writeTypes(currentNuxt).catch(console.error),
          buildNuxt(currentNuxt)
        ]);
        currentHandler = toNodeListener(currentNuxt.server.app);
        if (isRestart && args.clear !== false) {
          showBanner();
          showURL();
        }
      } catch (err) {
        consola.error(`Cannot ${isRestart ? "restart" : "start"} nuxt: `, err);
        currentHandler = void 0;
        loadingMessage = "Error while loading nuxt. Please check console and fix errors.";
      }
    };
    const dLoad = debounce(load);
    const watcher = chokidar.watch([rootDir], { ignoreInitial: true, depth: 0 });
    watcher.on("all", (_event, _file) => {
      const file = relative(rootDir, _file);
      if (file === (args.dotenv || ".env")) {
        return hardRestart(".env updated");
      }
      if (RESTART_RE.test(file)) {
        dLoad(true, `${file} updated`);
      }
    });
    await load(false);
    return "wait";
  }
});
const RESTART_RE = /^(nuxt\.config\.(js|ts|mjs|cjs)|\.nuxtignore|\.nuxtrc)$/;

export { dev as default };
