import { c as consola } from '../shared/nuxi.114b1a98.mjs';
import 'node:util';
import 'node:path';
import 'node:process';
import 'tty';
import { w as writeTypes } from '../shared/nuxi.1006786a.mjs';
import { l as loadKit } from '../shared/nuxi.60154167.mjs';
import { c as clearBuildDir } from '../shared/nuxi.04a0178b.mjs';
import { o as overrideEnv } from '../shared/nuxi.d21ab543.mjs';
import { a as showVersions } from '../shared/nuxi.9ca7cc10.mjs';
import { d as defineNuxtCommand } from '../shared/nuxi.c68ce99d.mjs';
import { r as resolve, a as relative } from '../shared/nuxi.ffb4843d.mjs';
import 'node:fs';
import '../shared/nuxi.a685c563.mjs';
import '../shared/nuxi.602e8160.mjs';
import 'node:module';
import '../shared/nuxi.bd22f1f6.mjs';
import 'node:url';
import '../shared/nuxi.f03591c1.mjs';
import 'node:assert';
import 'node:v8';
import '../shared/nuxi.24198af3.mjs';
import 'assert';
import '../shared/nuxi.a3b9dacd.mjs';

const buildCommand = defineNuxtCommand({
  meta: {
    name: "build",
    usage: "npx nuxi build [--prerender] [--dotenv] [--log-level] [rootDir]",
    description: "Build nuxt for production deployment"
  },
  async invoke(args, options = {}) {
    overrideEnv("production");
    const rootDir = resolve(args._[0] || ".");
    showVersions(rootDir);
    const { loadNuxt, buildNuxt, useNitro } = await loadKit(rootDir);
    const nuxt = await loadNuxt({
      rootDir,
      dotenv: {
        cwd: rootDir,
        fileName: args.dotenv
      },
      overrides: {
        logLevel: args["log-level"],
        _generate: args.prerender,
        ...options?.overrides || {}
      }
    });
    const nitro = useNitro?.();
    await clearBuildDir(nuxt.options.buildDir);
    await writeTypes(nuxt);
    nuxt.hook("build:error", (err) => {
      consola.error("Nuxt Build Error:", err);
      process.exit(1);
    });
    await buildNuxt(nuxt);
    if (args.prerender) {
      if (!nuxt.options.ssr) {
        consola.warn("HTML content not prerendered because `ssr: false` was set. You can read more in `https://nuxt.com/docs/getting-started/deployment#static-hosting`.");
      }
      const dir = nitro?.options.output.publicDir;
      const publicDir = dir ? relative(process.cwd(), dir) : ".output/public";
      consola.success(`You can now deploy \`${publicDir}\` to any static hosting!`);
    }
  }
});

export { buildCommand as default };
