// src/index.ts
import MagicStringBase from "magic-string";
export * from "magic-string";
var MagicString = class extends MagicStringBase {
  removeNode(node, { offset = 0 } = {}) {
    if (isEmptyNodes(node))
      return this;
    super.remove(...getNodePos(node, offset));
    return this;
  }
  moveNode(node, index, { offset = 0 } = {}) {
    if (isEmptyNodes(node))
      return this;
    super.move(...getNodePos(node, offset), index);
    return this;
  }
  sliceNode(node, { offset = 0 } = {}) {
    if (isEmptyNodes(node))
      return "";
    return super.slice(...getNodePos(node, offset));
  }
  overwriteNode(node, content, { offset = 0, ...options } = {}) {
    if (isEmptyNodes(node))
      return this;
    const _content = typeof content === "string" ? content : this.sliceNode(content);
    super.overwrite(...getNodePos(node, offset), _content, options);
    return this;
  }
  snipNode(node, { offset = 0 } = {}) {
    if (isEmptyNodes(node))
      return new MagicStringBase("", {
        // @ts-expect-error
        filename: super.filename
      });
    return super.snip(...getNodePos(node, offset));
  }
};
function getNodePos(nodes, offset) {
  if (Array.isArray(nodes))
    return [offset + nodes[0].start, offset + nodes.slice(-1)[0].end];
  else
    return [offset + nodes.start, offset + nodes.end];
}
function isEmptyNodes(nodes) {
  return Array.isArray(nodes) && nodes.length === 0;
}
export {
  MagicString,
  MagicStringBase
};
