import { Function, Literal, Node, CallExpression, Identifier, Program, Expression, PrivateName, ThisExpression, Super, TemplateLiteral, MemberExpression, ImportSpecifier, ImportDefaultSpecifier, ImportNamespaceSpecifier, ImportDeclaration } from '@babel/types';
import { ParserOptions, ParseResult } from '@babel/parser';
import { AttachedScope } from '@rollup/pluginutils';
export { AttachedScope } from '@rollup/pluginutils';

type NodeType = Node['type'] | 'Function' | 'Literal';
type GetNode<K extends NodeType> = K extends 'Function' ? Function : K extends 'Literal' ? Literal : Extract<Node, {
    type: K;
}>;
declare function isTypeOf<K extends NodeType>(node: Node | undefined | null, types: Readonly<K[]>): node is GetNode<K>;
declare function isCallOf(node: Node | null | undefined, test: string | string[] | ((id: string) => boolean)): node is CallExpression;
declare function isIdentifierOf(node: Node | undefined | null, test: string | string[]): node is Identifier;
declare function isLiteralType(node: Node | undefined | null): node is Literal;
declare function isFunctionType(node: Node | undefined | null): node is Function;

declare const REGEX_DTS: RegExp;
declare const REGEX_LANG_TS: RegExp;
declare const REGEX_LANG_JSX: RegExp;
declare function getLang(filename: string): string;
declare function isDts(filename: string): boolean;
declare function isTs(lang?: string): boolean;

declare function babelParse(code: string, lang?: string, options?: ParserOptions): ParseResult<Program>;
declare function babelParseExpression(code: string, lang?: string, options?: ParserOptions): ParseResult<Expression>;

declare function resolveString(node: string | Identifier | Literal | PrivateName | ThisExpression | Super, computed?: boolean): string;
declare function resolveLiteral(node: Literal): string | number | boolean | null | RegExp | bigint;
declare function resolveTemplateLiteral(node: TemplateLiteral): string;
declare function resolveIdentifier(node: Identifier | PrivateName | MemberExpression | ThisExpression | Super): string[];

declare const attachScopes: <T>(ast: T, propertyName?: string) => AttachedScope;

type WithScope<T> = T & {
    scope?: AttachedScope;
};

declare const TS_NODE_TYPES: readonly ["TSAsExpression", "TSTypeAssertion", "TSNonNullExpression", "TSInstantiationExpression", "TSSatisfiesExpression"];
declare function unwrapTSNode(node: Node): Node;
declare function escapeKey(rawKey: string): string;

type WalkHandlers<T, R> = {
    enter?: (this: {
        skip: () => void;
        remove: () => void;
        replace: (node: T) => void;
    }, node: T, parent: T | null | undefined, key: string | null | undefined, index: number | null | undefined) => R;
    leave?: (this: {
        skip: () => void;
        remove: () => void;
        replace: (node: T) => void;
    }, node: T, parent: T | null | undefined, key: string | null | undefined, index: number | null | undefined) => R;
};
declare const walkAST: <T = Node>(node: T, hooks: WalkHandlers<T, void>) => T | null;
declare const walkASTAsync: <T = Node>(node: T, handlers: WalkHandlers<T, Promise<void>>) => Promise<T | null>;
interface ImportBinding {
    local: string;
    imported: string;
    source: string;
    specifier: ImportSpecifier | ImportDefaultSpecifier | ImportNamespaceSpecifier;
}
declare function walkImportDeclaration(imports: Record<string, ImportBinding>, node: ImportDeclaration): void;

export { GetNode, ImportBinding, REGEX_DTS, REGEX_LANG_JSX, REGEX_LANG_TS, TS_NODE_TYPES, WithScope, attachScopes, babelParse, babelParseExpression, escapeKey, getLang, isCallOf, isDts, isFunctionType, isIdentifierOf, isLiteralType, isTs, isTypeOf, resolveIdentifier, resolveLiteral, resolveString, resolveTemplateLiteral, unwrapTSNode, walkAST, walkASTAsync, walkImportDeclaration };
