import { SFCScriptBlock as SFCScriptBlock$1, SFCDescriptor, SFCParseResult } from '@vue/compiler-sfc';
import { Program, Node } from '@babel/types';
import { MagicStringBase, MagicString } from 'magic-string-ast';

type SFCScriptBlock = Omit<SFCScriptBlock$1, 'scriptAst' | 'scriptSetupAst'>;
type SFC = Omit<SFCDescriptor, 'script' | 'scriptSetup'> & {
    sfc: SFCParseResult;
    script?: SFCScriptBlock | null;
    scriptSetup?: SFCScriptBlock | null;
    lang: string | undefined;
    getScriptAst(): Program | undefined;
    getSetupAst(): Program | undefined;
    offset: number;
} & Pick<SFCParseResult, 'errors'>;
declare function parseSFC(code: string, id: string): SFC;
declare function getFileCodeAndLang(code: string, id: string): {
    code: string;
    lang: string;
};
declare function addNormalScript({ script, lang }: SFC, s: MagicStringBase): {
    start(): number;
    end(): void;
};
declare function removeMacroImport(node: Node, s: MagicString, offset: number): true | undefined;

export { SFC, SFCScriptBlock, addNormalScript, getFileCodeAndLang, parseSFC, removeMacroImport };
