// src/unplugin.ts
import {
  createFilter as createRollupFilter
} from "@rollup/pluginutils";
import { normalizePath } from "@rollup/pluginutils";
function getTransformResult(s, id) {
  if (s?.hasChanged()) {
    return {
      code: s.toString(),
      get map() {
        return s.generateMap({
          source: id,
          includeContent: true,
          hires: true
        });
      }
    };
  }
}
function createFilter(options) {
  return createRollupFilter(options.include, options.exclude);
}

export {
  getTransformResult,
  createFilter,
  normalizePath
};
