"use strict";Object.defineProperty(exports, "__esModule", {value: true}); function _optionalChain(ops) { let lastAccessLHS = undefined; let value = ops[0]; let i = 1; while (i < ops.length) { const op = ops[i]; const fn = ops[i + 1]; i += 2; if ((op === 'optionalAccess' || op === 'optionalCall') && value == null) { return undefined; } if (op === 'access' || op === 'optionalAccess') { lastAccessLHS = value; value = fn(value); } else if (op === 'call' || op === 'optionalCall') { value = fn((...args) => value.call(lastAccessLHS, ...args)); lastAccessLHS = undefined; } } return value; }// src/ast.ts
var _compilersfc = require('@vue/compiler-sfc');
var _astkit = require('ast-kit');
function checkInvalidScopeReference(node, method, setupBindings) {
  if (!node)
    return;
  _compilersfc.walkIdentifiers.call(void 0, node, (id) => {
    if (setupBindings.includes(id.name))
      throw new SyntaxError(
        `\`${method}()\` in <script setup> cannot reference locally declared variables (${id.name}) because it will be hoisted outside of the setup() function.`
      );
  });
}
function isStaticExpression(node, options = {}) {
  const { magicComment, fn, object, objectMethod, array, unary, regex } = options;
  if (magicComment && _optionalChain([node, 'access', _ => _.leadingComments, 'optionalAccess', _2 => _2.some, 'call', _3 => _3(
    (comment) => comment.value.trim() === magicComment
  )]))
    return true;
  else if (fn && _astkit.isFunctionType.call(void 0, node))
    return true;
  switch (node.type) {
    case "UnaryExpression":
      return !!unary && isStaticExpression(node.argument, options);
    case "LogicalExpression":
    case "BinaryExpression":
      return isStaticExpression(node.left, options) && isStaticExpression(node.right, options);
    case "ConditionalExpression":
      return isStaticExpression(node.test, options) && isStaticExpression(node.consequent, options) && isStaticExpression(node.alternate, options);
    case "SequenceExpression":
    case "TemplateLiteral":
      return node.expressions.every((expr) => isStaticExpression(expr, options));
    case "ArrayExpression":
      return !!array && node.elements.every(
        (element) => element && isStaticExpression(element, options)
      );
    case "ObjectExpression":
      return !!object && node.properties.every((prop) => {
        if (prop.type === "SpreadElement") {
          return prop.argument.type === "ObjectExpression" && isStaticExpression(prop.argument, options);
        } else if (!_astkit.isLiteralType.call(void 0, prop.key) && prop.computed) {
          return false;
        } else if (prop.type === "ObjectProperty" && !isStaticExpression(prop.value, options)) {
          return false;
        }
        if (prop.type === "ObjectMethod" && !objectMethod) {
          return false;
        }
        return true;
      });
    case "ParenthesizedExpression":
    case "TSNonNullExpression":
    case "TSAsExpression":
    case "TSTypeAssertion":
    case "TSSatisfiesExpression":
      return isStaticExpression(node.expression, options);
    case "RegExpLiteral":
      return !!regex;
  }
  if (_astkit.isLiteralType.call(void 0, node))
    return true;
  return false;
}
function isStaticObjectKey(node) {
  return node.properties.every((prop) => {
    if (prop.type === "SpreadElement") {
      return prop.argument.type === "ObjectExpression" && isStaticObjectKey(prop.argument);
    }
    return !prop.computed || _astkit.isLiteralType.call(void 0, prop.key);
  });
}
function resolveObjectExpression(node) {
  const maps = {};
  for (const property of node.properties) {
    if (property.type === "SpreadElement") {
      if (property.argument.type !== "ObjectExpression")
        return void 0;
      Object.assign(maps, resolveObjectExpression(property.argument));
    } else {
      const key = resolveObjectKey(property.key, property.computed, false);
      maps[key] = property;
    }
  }
  return maps;
}
function resolveObjectKey(node, computed = false, raw = true) {
  switch (node.type) {
    case "StringLiteral":
    case "NumericLiteral":
      return raw ? node.extra.raw : node.value;
    case "Identifier":
      if (!computed)
        return raw ? `'${node.name}'` : node.name;
    default:
      throw new SyntaxError(`Unexpected node type: ${node.type}`);
  }
}
var importedMap = /* @__PURE__ */ new WeakMap();
var HELPER_PREFIX = "__MACROS_";
function importHelperFn(s, offset, local, from = "vue", isDefault = false) {
  const imported = isDefault ? "default" : local;
  const cacheKey = `${from}@${imported}`;
  if (!_optionalChain([importedMap, 'access', _4 => _4.get, 'call', _5 => _5(s), 'optionalAccess', _6 => _6.has, 'call', _7 => _7(cacheKey)])) {
    s.appendLeft(
      offset,
      `
import ${isDefault ? HELPER_PREFIX + local : `{ ${imported} as ${HELPER_PREFIX + local} }`} from ${JSON.stringify(from)};`
    );
    if (!importedMap.has(s)) {
      importedMap.set(s, /* @__PURE__ */ new Set([cacheKey]));
    } else {
      importedMap.get(s).add(cacheKey);
    }
  }
  return `${HELPER_PREFIX}${local}`;
}









exports.checkInvalidScopeReference = checkInvalidScopeReference; exports.isStaticExpression = isStaticExpression; exports.isStaticObjectKey = isStaticObjectKey; exports.resolveObjectExpression = resolveObjectExpression; exports.resolveObjectKey = resolveObjectKey; exports.HELPER_PREFIX = HELPER_PREFIX; exports.importHelperFn = importHelperFn;
