"use strict";Object.defineProperty(exports, "__esModule", {value: true}); function _nullishCoalesce(lhs, rhsFn) { if (lhs != null) { return lhs; } else { return rhsFn(); } } function _optionalChain(ops) { let lastAccessLHS = undefined; let value = ops[0]; let i = 1; while (i < ops.length) { const op = ops[i]; const fn = ops[i + 1]; i += 2; if ((op === 'optionalAccess' || op === 'optionalCall') && value == null) { return undefined; } if (op === 'access' || op === 'optionalAccess') { lastAccessLHS = value; value = fn(value); } else if (op === 'call' || op === 'optionalCall') { value = fn((...args) => value.call(lastAccessLHS, ...args)); lastAccessLHS = undefined; } } return value; }

var _chunk3KTXRYLFjs = require('./chunk-3KTXRYLF.js');

// src/vue.ts


var _compilersfc = require('@vue/compiler-sfc');
var _astkit = require('ast-kit');
function parseSFC(code, id) {
  const sfc = _compilersfc.parse.call(void 0, code, {
    filename: id
  });
  const { descriptor, errors } = sfc;
  const scriptLang = _optionalChain([sfc, 'access', _ => _.descriptor, 'access', _2 => _2.script, 'optionalAccess', _3 => _3.lang]);
  const scriptSetupLang = _optionalChain([sfc, 'access', _4 => _4.descriptor, 'access', _5 => _5.scriptSetup, 'optionalAccess', _6 => _6.lang]);
  if (sfc.descriptor.script && sfc.descriptor.scriptSetup && (scriptLang || "js") !== (scriptSetupLang || "js")) {
    throw new Error(
      `[unplugin-vue-macros] <script> and <script setup> must have the same language type.`
    );
  }
  const lang = scriptLang || scriptSetupLang;
  return {
    sfc,
    ...descriptor,
    lang,
    errors,
    offset: _nullishCoalesce(_optionalChain([descriptor, 'access', _7 => _7.scriptSetup, 'optionalAccess', _8 => _8.loc, 'access', _9 => _9.start, 'access', _10 => _10.offset]), () => ( 0)),
    getSetupAst() {
      if (!descriptor.scriptSetup)
        return;
      return _astkit.babelParse.call(void 0, descriptor.scriptSetup.content, lang, {
        plugins: [["importAttributes", { deprecatedAssertSyntax: true }]]
      });
    },
    getScriptAst() {
      if (!descriptor.script)
        return;
      return _astkit.babelParse.call(void 0, descriptor.script.content, lang, {
        plugins: [["importAttributes", { deprecatedAssertSyntax: true }]]
      });
    }
  };
}
function getFileCodeAndLang(code, id) {
  if (!_chunk3KTXRYLFjs.REGEX_VUE_SFC.test(id)) {
    return {
      code,
      lang: _astkit.getLang.call(void 0, id)
    };
  }
  const sfc = parseSFC(code, id);
  const scriptCode = _nullishCoalesce(_optionalChain([sfc, 'access', _11 => _11.script, 'optionalAccess', _12 => _12.content]), () => ( ""));
  return {
    code: sfc.scriptSetup ? `${scriptCode}
;
${sfc.scriptSetup.content}` : scriptCode,
    lang: _nullishCoalesce(sfc.lang, () => ( "js"))
  };
}
function addNormalScript({ script, lang }, s) {
  return {
    start() {
      if (script)
        return script.loc.end.offset;
      const attrs = lang ? ` lang="${lang}"` : "";
      s.prependLeft(0, `<script${attrs}>`);
      return 0;
    },
    end() {
      if (!script)
        s.appendRight(0, `
</script>
`);
    }
  };
}
function removeMacroImport(node, s, offset) {
  if (node.type === "ImportDeclaration" && _optionalChain([node, 'access', _13 => _13.attributes, 'optionalAccess', _14 => _14.some, 'call', _15 => _15(
    (attr) => _astkit.resolveString.call(void 0, attr.key) === "type" && attr.value.value === "macro"
  )])) {
    s.removeNode(node, { offset });
    return true;
  }
}






exports.parseSFC = parseSFC; exports.getFileCodeAndLang = getFileCodeAndLang; exports.addNormalScript = addNormalScript; exports.removeMacroImport = removeMacroImport;
