import {
  REGEX_VUE_SFC
} from "./chunk-UVJ46V7L.mjs";

// src/vue.ts
import {
  parse
} from "@vue/compiler-sfc";
import { babelParse, getLang, resolveString } from "ast-kit";
function parseSFC(code, id) {
  const sfc = parse(code, {
    filename: id
  });
  const { descriptor, errors } = sfc;
  const scriptLang = sfc.descriptor.script?.lang;
  const scriptSetupLang = sfc.descriptor.scriptSetup?.lang;
  if (sfc.descriptor.script && sfc.descriptor.scriptSetup && (scriptLang || "js") !== (scriptSetupLang || "js")) {
    throw new Error(
      `[unplugin-vue-macros] <script> and <script setup> must have the same language type.`
    );
  }
  const lang = scriptLang || scriptSetupLang;
  return {
    sfc,
    ...descriptor,
    lang,
    errors,
    offset: descriptor.scriptSetup?.loc.start.offset ?? 0,
    getSetupAst() {
      if (!descriptor.scriptSetup)
        return;
      return babelParse(descriptor.scriptSetup.content, lang, {
        plugins: [["importAttributes", { deprecatedAssertSyntax: true }]]
      });
    },
    getScriptAst() {
      if (!descriptor.script)
        return;
      return babelParse(descriptor.script.content, lang, {
        plugins: [["importAttributes", { deprecatedAssertSyntax: true }]]
      });
    }
  };
}
function getFileCodeAndLang(code, id) {
  if (!REGEX_VUE_SFC.test(id)) {
    return {
      code,
      lang: getLang(id)
    };
  }
  const sfc = parseSFC(code, id);
  const scriptCode = sfc.script?.content ?? "";
  return {
    code: sfc.scriptSetup ? `${scriptCode}
;
${sfc.scriptSetup.content}` : scriptCode,
    lang: sfc.lang ?? "js"
  };
}
function addNormalScript({ script, lang }, s) {
  return {
    start() {
      if (script)
        return script.loc.end.offset;
      const attrs = lang ? ` lang="${lang}"` : "";
      s.prependLeft(0, `<script${attrs}>`);
      return 0;
    },
    end() {
      if (!script)
        s.appendRight(0, `
</script>
`);
    }
  };
}
function removeMacroImport(node, s, offset) {
  if (node.type === "ImportDeclaration" && node.attributes?.some(
    (attr) => resolveString(attr.key) === "type" && attr.value.value === "macro"
  )) {
    s.removeNode(node, { offset });
    return true;
  }
}

export {
  parseSFC,
  getFileCodeAndLang,
  addNormalScript,
  removeMacroImport
};
