import { Node, ObjectExpression, ObjectMethod, ObjectProperty } from '@babel/types';
import { MagicStringBase } from 'magic-string-ast';

declare function checkInvalidScopeReference(node: Node | undefined, method: string, setupBindings: string[]): void;
declare function isStaticExpression(node: Node, options?: Partial<Record<'object' | 'fn' | 'objectMethod' | 'array' | 'unary' | 'regex', boolean> & {
    magicComment?: string;
}>): boolean;
declare function isStaticObjectKey(node: ObjectExpression): boolean;
/**
 * @param node must be a static expression, SpreadElement is not supported
 */
declare function resolveObjectExpression(node: ObjectExpression): Record<string | number, ObjectMethod | ObjectProperty> | undefined;
declare function resolveObjectKey(node: Node, computed?: boolean, raw?: true): string;
declare function resolveObjectKey(node: Node, computed: boolean | undefined, raw: false): string | number;
declare const HELPER_PREFIX = "__MACROS_";
declare function importHelperFn(s: MagicStringBase, offset: number, local: string, from?: string, isDefault?: boolean): string;

export { HELPER_PREFIX, checkInvalidScopeReference, importHelperFn, isStaticExpression, isStaticObjectKey, resolveObjectExpression, resolveObjectKey };
