export { createHeadCore } from 'unhead';
import { R as ReactiveHead, M as MaybeComputedRefEntries, a as MaybeComputedRef, U as UseHeadInput, A as Arrayable, b as Meta, L as Link, S as Script, c as Style, N as Noscript } from './createHead-26c9c4af.js';
export { e as Base, B as BodyAttr, g as BodyAttributes, H as HtmlAttr, f as HtmlAttributes, i as MaybeComputedRefOrPromise, h as MaybeReadonlyRef, T as Title, d as TitleTemplate, V as VueHeadClient, m as createHead, l as createServerHead, j as headSymbol, k as injectHead } from './createHead-26c9c4af.js';
import * as _unhead_schema from '@unhead/schema';
import { SafeMeta, SafeLink, SafeNoscript, SafeScript, SafeHtmlAttr, SafeBodyAttr, MergeHead, HeadEntryOptions, ActiveHeadEntry, MetaFlatInput } from '@unhead/schema';
export { ActiveHeadEntry, Head, HeadEntryOptions, HeadTag, MergeHead, Unhead } from '@unhead/schema';
import { Plugin } from 'vue';

interface HeadSafe extends Pick<ReactiveHead, 'title' | 'titleTemplate' | 'templateParams'> {
    meta?: MaybeComputedRefEntries<SafeMeta>[];
    link?: MaybeComputedRefEntries<SafeLink>[];
    noscript?: MaybeComputedRefEntries<SafeNoscript>[];
    script?: MaybeComputedRefEntries<SafeScript>[];
    htmlAttrs?: MaybeComputedRefEntries<SafeHtmlAttr>;
    bodyAttrs?: MaybeComputedRefEntries<SafeBodyAttr>;
}
type UseHeadSafeInput = MaybeComputedRef<HeadSafe>;

declare function resolveUnrefHeadInput(ref: any, lastKey?: string | number): any;

declare const VueHeadMixin: {
    created(): void;
};

declare function VueReactiveUseHeadPlugin(): _unhead_schema.HeadPlugin;

declare const Vue2ProvideUnheadPlugin: Plugin;

declare function useHead<T extends MergeHead>(input: UseHeadInput<T>, options?: HeadEntryOptions): ActiveHeadEntry<UseHeadInput<T>> | void;

declare function useHeadSafe(input: UseHeadSafeInput, options?: HeadEntryOptions): ActiveHeadEntry<UseHeadSafeInput> | void;

type UseSeoMetaInput = MaybeComputedRefEntries<MetaFlatInput> & {
    title?: ReactiveHead['title'];
    titleTemplate?: ReactiveHead['titleTemplate'];
};
declare function useSeoMeta(input: UseSeoMetaInput, options?: HeadEntryOptions): ActiveHeadEntry<any> | void;

declare function useServerHead<T extends MergeHead>(input: UseHeadInput<T>, options?: HeadEntryOptions): _unhead_schema.ActiveHeadEntry<UseHeadInput<T>>;

declare function useServerHeadSafe(input: UseHeadSafeInput, options?: HeadEntryOptions): void | _unhead_schema.ActiveHeadEntry<UseHeadSafeInput>;

declare function useServerSeoMeta(input: UseSeoMetaInput, options?: HeadEntryOptions): ActiveHeadEntry<any> | void;

/**
 * @deprecated Use `useHead`
 */
declare function useTagTitle(title: ReactiveHead['title']): ActiveHeadEntry<any> | void;
/**
 * @deprecated Use `useHead`
 */
declare function useTitleTemplate(titleTemplate: ReactiveHead['titleTemplate']): ActiveHeadEntry<any> | void;
/**
 * @deprecated Use `useHead`
 */
declare function useTagMeta(meta: Arrayable<Meta>): ActiveHeadEntry<any> | void;
/**
 * @deprecated Use `useHead`
 */
declare function useTagMetaFlat(meta: MaybeComputedRefEntries<MetaFlatInput>): ActiveHeadEntry<any> | void;
/**
 * @deprecated Use `useHead`
 */
declare function useTagLink(link: Arrayable<Link>): ActiveHeadEntry<any> | void;
/**
 * @deprecated Use `useHead`
 */
declare function useTagScript(script: Arrayable<Script>): ActiveHeadEntry<any> | void;
/**
 * @deprecated Use `useHead`
 */
declare function useTagStyle(style: Arrayable<Style>): ActiveHeadEntry<any> | void;
/**
 * @deprecated Use `useHead`
 */
declare function useTagNoscript(noscript: Arrayable<Noscript>): ActiveHeadEntry<any> | void;
/**
 * @deprecated Use `useHead`
 */
declare function useTagBase(base: ReactiveHead['base']): ActiveHeadEntry<any> | void;
/**
 * @deprecated Use `useHead`
 */
declare function useHtmlAttrs(attrs: ReactiveHead['htmlAttrs']): ActiveHeadEntry<any> | void;
/**
 * @deprecated Use `useHead`
 */
declare function useBodyAttrs(attrs: ReactiveHead['bodyAttrs']): ActiveHeadEntry<any> | void;
/**
 * @deprecated Use `useHead`
 */
declare function useServerTagTitle(title: ReactiveHead['title']): ActiveHeadEntry<any> | void;
/**
 * @deprecated Use `useHead`
 */
declare function useServerTitleTemplate(titleTemplate: ReactiveHead['titleTemplate']): ActiveHeadEntry<any> | void;
/**
 * @deprecated Use `useHead`
 */
declare function useServerTagMeta(meta: Arrayable<Meta>): ActiveHeadEntry<any> | void;
/**
 * @deprecated Use `useHead`
 */
declare function useServerTagMetaFlat(meta: MaybeComputedRefEntries<MetaFlatInput>): ActiveHeadEntry<any> | void;
/**
 * @deprecated Use `useHead`
 */
declare function useServerTagLink(link: Arrayable<Link>): ActiveHeadEntry<any> | void;
/**
 * @deprecated Use `useHead`
 */
declare function useServerTagScript(script: Arrayable<Script>): ActiveHeadEntry<any> | void;
/**
 * @deprecated Use `useHead`
 */
declare function useServerTagStyle(style: Arrayable<Style>): ActiveHeadEntry<any> | void;
/**
 * @deprecated Use `useHead`
 */
declare function useServerTagNoscript(noscript: Arrayable<Noscript>): ActiveHeadEntry<any> | void;
/**
 * @deprecated Use `useHead`
 */
declare function useServerTagBase(base: ReactiveHead['base']): ActiveHeadEntry<any> | void;
/**
 * @deprecated Use `useHead`
 */
declare function useServerHtmlAttrs(attrs: ReactiveHead['htmlAttrs']): ActiveHeadEntry<any> | void;
/**
 * @deprecated Use `useHead`
 */
declare function useServerBodyAttrs(attrs: ReactiveHead['bodyAttrs']): ActiveHeadEntry<any> | void;

declare const unheadVueComposablesImports: {
    '@unhead/vue': string[];
};

export { Arrayable, HeadSafe, Link, MaybeComputedRef, MaybeComputedRefEntries, Meta, Noscript, ReactiveHead, Script, Style, UseHeadInput, UseHeadSafeInput, UseSeoMetaInput, Vue2ProvideUnheadPlugin, VueHeadMixin, VueReactiveUseHeadPlugin, resolveUnrefHeadInput, unheadVueComposablesImports, useBodyAttrs, useHead, useHeadSafe, useHtmlAttrs, useSeoMeta, useServerBodyAttrs, useServerHead, useServerHeadSafe, useServerHtmlAttrs, useServerSeoMeta, useServerTagBase, useServerTagLink, useServerTagMeta, useServerTagMetaFlat, useServerTagNoscript, useServerTagScript, useServerTagStyle, useServerTagTitle, useServerTitleTemplate, useTagBase, useTagLink, useTagMeta, useTagMetaFlat, useTagNoscript, useTagScript, useTagStyle, useTagTitle, useTitleTemplate };
