import { HeadPlugin, HeadTag } from '@unhead/schema';

type Arrayable<T> = T | Array<T>;
declare function asArray<T>(value: Arrayable<T>): T[];

declare const SelfClosingTags: string[];
declare const TagsWithInnerContent: string[];
declare const HasElementTags: string[];
declare const ValidHeadTags: string[];
declare const UniqueTags: string[];
declare const TagConfigKeys: string[];

declare function defineHeadPlugin(plugin: HeadPlugin): HeadPlugin;

declare function hashCode(s: string): string;
declare function hashTag(tag: HeadTag): string;
declare function computeHashes(hashes: string[]): string;

declare function tagDedupeKey<T extends HeadTag>(tag: T, fn?: (key: string) => boolean): string | false;

declare function resolveTitleTemplate(template: string | ((title?: string) => string | null) | null, title?: string): string | null;

export { Arrayable, HasElementTags, SelfClosingTags, TagConfigKeys, TagsWithInnerContent, UniqueTags, ValidHeadTags, asArray, computeHashes, defineHeadPlugin, hashCode, hashTag, resolveTitleTemplate, tagDedupeKey };
