import * as _unhead_schema from '@unhead/schema';
import { Unhead, DomRenderTagContext } from '@unhead/schema';

interface RenderDomHeadOptions {
    /**
     * Document to use for rendering. Allows stubbing for testing.
     */
    document?: Document;
}
interface DebouncedRenderDomHeadOptions extends RenderDomHeadOptions {
    /**
     * Specify a custom delay function for delaying the render.
     */
    delayFn?: (fn: () => void) => void;
}
/**
 * Render the head tags to the DOM.
 */
declare function renderDOMHead<T extends Unhead<any>>(head: T, options?: RenderDomHeadOptions): Promise<void>;
/**
 * Global instance of the dom update promise. Used for debounding head updates.
 */
declare let domUpdatePromise: Promise<void> | null;
/**
 * Queue a debounced update of the DOM head.
 */
declare function debouncedRenderDOMHead<T extends Unhead<any>>(head: T, options?: DebouncedRenderDomHeadOptions): Promise<void>;

interface TriggerDomPatchingOnUpdatesPluginOptions extends RenderDomHeadOptions {
    delayFn?: (fn: () => void) => void;
}
declare function PatchDomOnEntryUpdatesPlugin(options?: TriggerDomPatchingOnUpdatesPluginOptions): _unhead_schema.HeadPlugin;

/**
 * Set attributes on a DOM element, while adding entry side effects.
 */
declare function setAttrs(ctx: DomRenderTagContext, newEntry?: boolean, markSideEffect?: (ctx: DomRenderTagContext, k: string, fn: () => void) => void): void;

declare function maybeGetSSRHash(document: Document): string | false;

export { DebouncedRenderDomHeadOptions, PatchDomOnEntryUpdatesPlugin, RenderDomHeadOptions, TriggerDomPatchingOnUpdatesPluginOptions, debouncedRenderDOMHead, domUpdatePromise, maybeGetSSRHash, renderDOMHead, setAttrs };
