import _Vue2 from "vue";
import { createPinia, setActivePinia, PiniaVuePlugin } from "pinia";
const Vue = "default" in _Vue2 ? _Vue2.default : _Vue2;
Vue.use(PiniaVuePlugin);
export default (context, inject) => {
  const pinia = createPinia();
  context.app.pinia = pinia;
  setActivePinia(pinia);
  pinia._p.push(({ store }) => {
    Object.defineProperty(store, "$nuxt", { value: context });
  });
  if (process.server) {
    context.beforeNuxtRender((ctx) => {
      ctx.nuxtState.pinia = pinia.state.value;
    });
  } else if (context.nuxtState && context.nuxtState.pinia) {
    pinia.state.value = context.nuxtState.pinia;
  }
  inject("pinia", pinia);
};
