import { NuxtModule } from '@nuxt/schema';

interface ModuleOptions {
    /**
     * Pinia disables Vuex by default, set this option to `false` to avoid it and
     * use Pinia alongside Vuex (Nuxt 2 only)
     *
     * @default `true`
     */
    disableVuex?: boolean;
    /**
     * Array of auto imports to be added to the nuxt.config.js file.
     *
     * @example
     * ```js
     * autoImports: [
     *  // automatically import `defineStore`
     *  'defineStore',
     *  // automatically import `defineStore` as `definePiniaStore`
     *  ['defineStore', 'definePiniaStore',
     * ]
     * ```
     *
     */
    autoImports?: Array<string | [string, string]>;
}
declare const module: NuxtModule<ModuleOptions>;

export { ModuleOptions, module as default };
