import {
  __commonJS,
  __toESM
} from "./chunk-DFKQJ226.js";

// node_modules/qs/lib/formats.js
var require_formats = __commonJS({
  "node_modules/qs/lib/formats.js"(exports, module) {
    "use strict";
    var replace = String.prototype.replace;
    var percentTwenties = /%20/g;
    var Format = {
      RFC1738: "RFC1738",
      RFC3986: "RFC3986"
    };
    module.exports = {
      "default": Format.RFC3986,
      formatters: {
        RFC1738: function(value) {
          return replace.call(value, percentTwenties, "+");
        },
        RFC3986: function(value) {
          return String(value);
        }
      },
      RFC1738: Format.RFC1738,
      RFC3986: Format.RFC3986
    };
  }
});

// node_modules/qs/lib/utils.js
var require_utils = __commonJS({
  "node_modules/qs/lib/utils.js"(exports, module) {
    "use strict";
    var formats = require_formats();
    var has = Object.prototype.hasOwnProperty;
    var isArray = Array.isArray;
    var hexTable = function() {
      var array = [];
      for (var i2 = 0; i2 < 256; ++i2) {
        array.push("%" + ((i2 < 16 ? "0" : "") + i2.toString(16)).toUpperCase());
      }
      return array;
    }();
    var compactQueue = function compactQueue2(queue) {
      while (queue.length > 1) {
        var item = queue.pop();
        var obj = item.obj[item.prop];
        if (isArray(obj)) {
          var compacted = [];
          for (var j = 0; j < obj.length; ++j) {
            if (typeof obj[j] !== "undefined") {
              compacted.push(obj[j]);
            }
          }
          item.obj[item.prop] = compacted;
        }
      }
    };
    var arrayToObject = function arrayToObject2(source, options) {
      var obj = options && options.plainObjects ? /* @__PURE__ */ Object.create(null) : {};
      for (var i2 = 0; i2 < source.length; ++i2) {
        if (typeof source[i2] !== "undefined") {
          obj[i2] = source[i2];
        }
      }
      return obj;
    };
    var merge = function merge2(target, source, options) {
      if (!source) {
        return target;
      }
      if (typeof source !== "object") {
        if (isArray(target)) {
          target.push(source);
        } else if (target && typeof target === "object") {
          if (options && (options.plainObjects || options.allowPrototypes) || !has.call(Object.prototype, source)) {
            target[source] = true;
          }
        } else {
          return [target, source];
        }
        return target;
      }
      if (!target || typeof target !== "object") {
        return [target].concat(source);
      }
      var mergeTarget = target;
      if (isArray(target) && !isArray(source)) {
        mergeTarget = arrayToObject(target, options);
      }
      if (isArray(target) && isArray(source)) {
        source.forEach(function(item, i2) {
          if (has.call(target, i2)) {
            var targetItem = target[i2];
            if (targetItem && typeof targetItem === "object" && item && typeof item === "object") {
              target[i2] = merge2(targetItem, item, options);
            } else {
              target.push(item);
            }
          } else {
            target[i2] = item;
          }
        });
        return target;
      }
      return Object.keys(source).reduce(function(acc, key) {
        var value = source[key];
        if (has.call(acc, key)) {
          acc[key] = merge2(acc[key], value, options);
        } else {
          acc[key] = value;
        }
        return acc;
      }, mergeTarget);
    };
    var assign = function assignSingleSource(target, source) {
      return Object.keys(source).reduce(function(acc, key) {
        acc[key] = source[key];
        return acc;
      }, target);
    };
    var decode = function(str, decoder, charset) {
      var strWithoutPlus = str.replace(/\+/g, " ");
      if (charset === "iso-8859-1") {
        return strWithoutPlus.replace(/%[0-9a-f]{2}/gi, unescape);
      }
      try {
        return decodeURIComponent(strWithoutPlus);
      } catch (e2) {
        return strWithoutPlus;
      }
    };
    var encode = function encode2(str, defaultEncoder, charset, kind, format) {
      if (str.length === 0) {
        return str;
      }
      var string = str;
      if (typeof str === "symbol") {
        string = Symbol.prototype.toString.call(str);
      } else if (typeof str !== "string") {
        string = String(str);
      }
      if (charset === "iso-8859-1") {
        return escape(string).replace(/%u[0-9a-f]{4}/gi, function($0) {
          return "%26%23" + parseInt($0.slice(2), 16) + "%3B";
        });
      }
      var out = "";
      for (var i2 = 0; i2 < string.length; ++i2) {
        var c2 = string.charCodeAt(i2);
        if (c2 === 45 || c2 === 46 || c2 === 95 || c2 === 126 || c2 >= 48 && c2 <= 57 || c2 >= 65 && c2 <= 90 || c2 >= 97 && c2 <= 122 || format === formats.RFC1738 && (c2 === 40 || c2 === 41)) {
          out += string.charAt(i2);
          continue;
        }
        if (c2 < 128) {
          out = out + hexTable[c2];
          continue;
        }
        if (c2 < 2048) {
          out = out + (hexTable[192 | c2 >> 6] + hexTable[128 | c2 & 63]);
          continue;
        }
        if (c2 < 55296 || c2 >= 57344) {
          out = out + (hexTable[224 | c2 >> 12] + hexTable[128 | c2 >> 6 & 63] + hexTable[128 | c2 & 63]);
          continue;
        }
        i2 += 1;
        c2 = 65536 + ((c2 & 1023) << 10 | string.charCodeAt(i2) & 1023);
        out += hexTable[240 | c2 >> 18] + hexTable[128 | c2 >> 12 & 63] + hexTable[128 | c2 >> 6 & 63] + hexTable[128 | c2 & 63];
      }
      return out;
    };
    var compact = function compact2(value) {
      var queue = [{ obj: { o: value }, prop: "o" }];
      var refs = [];
      for (var i2 = 0; i2 < queue.length; ++i2) {
        var item = queue[i2];
        var obj = item.obj[item.prop];
        var keys = Object.keys(obj);
        for (var j = 0; j < keys.length; ++j) {
          var key = keys[j];
          var val = obj[key];
          if (typeof val === "object" && val !== null && refs.indexOf(val) === -1) {
            queue.push({ obj, prop: key });
            refs.push(val);
          }
        }
      }
      compactQueue(queue);
      return value;
    };
    var isRegExp = function isRegExp2(obj) {
      return Object.prototype.toString.call(obj) === "[object RegExp]";
    };
    var isBuffer = function isBuffer2(obj) {
      if (!obj || typeof obj !== "object") {
        return false;
      }
      return !!(obj.constructor && obj.constructor.isBuffer && obj.constructor.isBuffer(obj));
    };
    var combine = function combine2(a2, b) {
      return [].concat(a2, b);
    };
    var maybeMap = function maybeMap2(val, fn) {
      if (isArray(val)) {
        var mapped = [];
        for (var i2 = 0; i2 < val.length; i2 += 1) {
          mapped.push(fn(val[i2]));
        }
        return mapped;
      }
      return fn(val);
    };
    module.exports = {
      arrayToObject,
      assign,
      combine,
      compact,
      decode,
      encode,
      isBuffer,
      isRegExp,
      maybeMap,
      merge
    };
  }
});

// node_modules/qs/lib/stringify.js
var require_stringify = __commonJS({
  "node_modules/qs/lib/stringify.js"(exports, module) {
    "use strict";
    var utils = require_utils();
    var formats = require_formats();
    var has = Object.prototype.hasOwnProperty;
    var arrayPrefixGenerators = {
      brackets: function brackets(prefix) {
        return prefix + "[]";
      },
      comma: "comma",
      indices: function indices(prefix, key) {
        return prefix + "[" + key + "]";
      },
      repeat: function repeat(prefix) {
        return prefix;
      }
    };
    var isArray = Array.isArray;
    var split = String.prototype.split;
    var push = Array.prototype.push;
    var pushToArray = function(arr, valueOrArray) {
      push.apply(arr, isArray(valueOrArray) ? valueOrArray : [valueOrArray]);
    };
    var toISO = Date.prototype.toISOString;
    var defaultFormat = formats["default"];
    var defaults = {
      addQueryPrefix: false,
      allowDots: false,
      charset: "utf-8",
      charsetSentinel: false,
      delimiter: "&",
      encode: true,
      encoder: utils.encode,
      encodeValuesOnly: false,
      format: defaultFormat,
      formatter: formats.formatters[defaultFormat],
      // deprecated
      indices: false,
      serializeDate: function serializeDate(date) {
        return toISO.call(date);
      },
      skipNulls: false,
      strictNullHandling: false
    };
    var isNonNullishPrimitive = function isNonNullishPrimitive2(v) {
      return typeof v === "string" || typeof v === "number" || typeof v === "boolean" || typeof v === "symbol" || typeof v === "bigint";
    };
    var stringify = function stringify2(object, prefix, generateArrayPrefix, strictNullHandling, skipNulls, encoder, filter, sort, allowDots, serializeDate, format, formatter, encodeValuesOnly, charset) {
      var obj = object;
      if (typeof filter === "function") {
        obj = filter(prefix, obj);
      } else if (obj instanceof Date) {
        obj = serializeDate(obj);
      } else if (generateArrayPrefix === "comma" && isArray(obj)) {
        obj = utils.maybeMap(obj, function(value2) {
          if (value2 instanceof Date) {
            return serializeDate(value2);
          }
          return value2;
        });
      }
      if (obj === null) {
        if (strictNullHandling) {
          return encoder && !encodeValuesOnly ? encoder(prefix, defaults.encoder, charset, "key", format) : prefix;
        }
        obj = "";
      }
      if (isNonNullishPrimitive(obj) || utils.isBuffer(obj)) {
        if (encoder) {
          var keyValue = encodeValuesOnly ? prefix : encoder(prefix, defaults.encoder, charset, "key", format);
          if (generateArrayPrefix === "comma" && encodeValuesOnly) {
            var valuesArray = split.call(String(obj), ",");
            var valuesJoined = "";
            for (var i2 = 0; i2 < valuesArray.length; ++i2) {
              valuesJoined += (i2 === 0 ? "" : ",") + formatter(encoder(valuesArray[i2], defaults.encoder, charset, "value", format));
            }
            return [formatter(keyValue) + "=" + valuesJoined];
          }
          return [formatter(keyValue) + "=" + formatter(encoder(obj, defaults.encoder, charset, "value", format))];
        }
        return [formatter(prefix) + "=" + formatter(String(obj))];
      }
      var values = [];
      if (typeof obj === "undefined") {
        return values;
      }
      var objKeys;
      if (generateArrayPrefix === "comma" && isArray(obj)) {
        objKeys = [{ value: obj.length > 0 ? obj.join(",") || null : void 0 }];
      } else if (isArray(filter)) {
        objKeys = filter;
      } else {
        var keys = Object.keys(obj);
        objKeys = sort ? keys.sort(sort) : keys;
      }
      for (var j = 0; j < objKeys.length; ++j) {
        var key = objKeys[j];
        var value = typeof key === "object" && typeof key.value !== "undefined" ? key.value : obj[key];
        if (skipNulls && value === null) {
          continue;
        }
        var keyPrefix = isArray(obj) ? typeof generateArrayPrefix === "function" ? generateArrayPrefix(prefix, key) : prefix : prefix + (allowDots ? "." + key : "[" + key + "]");
        pushToArray(values, stringify2(
          value,
          keyPrefix,
          generateArrayPrefix,
          strictNullHandling,
          skipNulls,
          encoder,
          filter,
          sort,
          allowDots,
          serializeDate,
          format,
          formatter,
          encodeValuesOnly,
          charset
        ));
      }
      return values;
    };
    var normalizeStringifyOptions = function normalizeStringifyOptions2(opts) {
      if (!opts) {
        return defaults;
      }
      if (opts.encoder !== null && typeof opts.encoder !== "undefined" && typeof opts.encoder !== "function") {
        throw new TypeError("Encoder has to be a function.");
      }
      var charset = opts.charset || defaults.charset;
      if (typeof opts.charset !== "undefined" && opts.charset !== "utf-8" && opts.charset !== "iso-8859-1") {
        throw new TypeError("The charset option must be either utf-8, iso-8859-1, or undefined");
      }
      var format = formats["default"];
      if (typeof opts.format !== "undefined") {
        if (!has.call(formats.formatters, opts.format)) {
          throw new TypeError("Unknown format option provided.");
        }
        format = opts.format;
      }
      var formatter = formats.formatters[format];
      var filter = defaults.filter;
      if (typeof opts.filter === "function" || isArray(opts.filter)) {
        filter = opts.filter;
      }
      return {
        addQueryPrefix: typeof opts.addQueryPrefix === "boolean" ? opts.addQueryPrefix : defaults.addQueryPrefix,
        allowDots: typeof opts.allowDots === "undefined" ? defaults.allowDots : !!opts.allowDots,
        charset,
        charsetSentinel: typeof opts.charsetSentinel === "boolean" ? opts.charsetSentinel : defaults.charsetSentinel,
        delimiter: typeof opts.delimiter === "undefined" ? defaults.delimiter : opts.delimiter,
        encode: typeof opts.encode === "boolean" ? opts.encode : defaults.encode,
        encoder: typeof opts.encoder === "function" ? opts.encoder : defaults.encoder,
        encodeValuesOnly: typeof opts.encodeValuesOnly === "boolean" ? opts.encodeValuesOnly : defaults.encodeValuesOnly,
        filter,
        format,
        formatter,
        serializeDate: typeof opts.serializeDate === "function" ? opts.serializeDate : defaults.serializeDate,
        skipNulls: typeof opts.skipNulls === "boolean" ? opts.skipNulls : defaults.skipNulls,
        sort: typeof opts.sort === "function" ? opts.sort : null,
        strictNullHandling: typeof opts.strictNullHandling === "boolean" ? opts.strictNullHandling : defaults.strictNullHandling
      };
    };
    module.exports = function(object, opts) {
      var obj = object;
      var options = normalizeStringifyOptions(opts);
      var objKeys;
      var filter;
      if (typeof options.filter === "function") {
        filter = options.filter;
        obj = filter("", obj);
      } else if (isArray(options.filter)) {
        filter = options.filter;
        objKeys = filter;
      }
      var keys = [];
      if (typeof obj !== "object" || obj === null) {
        return "";
      }
      var arrayFormat;
      if (opts && opts.arrayFormat in arrayPrefixGenerators) {
        arrayFormat = opts.arrayFormat;
      } else if (opts && "indices" in opts) {
        arrayFormat = opts.indices ? "indices" : "repeat";
      } else {
        arrayFormat = "indices";
      }
      var generateArrayPrefix = arrayPrefixGenerators[arrayFormat];
      if (!objKeys) {
        objKeys = Object.keys(obj);
      }
      if (options.sort) {
        objKeys.sort(options.sort);
      }
      for (var i2 = 0; i2 < objKeys.length; ++i2) {
        var key = objKeys[i2];
        if (options.skipNulls && obj[key] === null) {
          continue;
        }
        pushToArray(keys, stringify(
          obj[key],
          key,
          generateArrayPrefix,
          options.strictNullHandling,
          options.skipNulls,
          options.encode ? options.encoder : null,
          options.filter,
          options.sort,
          options.allowDots,
          options.serializeDate,
          options.format,
          options.formatter,
          options.encodeValuesOnly,
          options.charset
        ));
      }
      var joined = keys.join(options.delimiter);
      var prefix = options.addQueryPrefix === true ? "?" : "";
      if (options.charsetSentinel) {
        if (options.charset === "iso-8859-1") {
          prefix += "utf8=%26%2310003%3B&";
        } else {
          prefix += "utf8=%E2%9C%93&";
        }
      }
      return joined.length > 0 ? prefix + joined : "";
    };
  }
});

// node_modules/qs/lib/parse.js
var require_parse = __commonJS({
  "node_modules/qs/lib/parse.js"(exports, module) {
    "use strict";
    var utils = require_utils();
    var has = Object.prototype.hasOwnProperty;
    var isArray = Array.isArray;
    var defaults = {
      allowDots: false,
      allowPrototypes: false,
      arrayLimit: 20,
      charset: "utf-8",
      charsetSentinel: false,
      comma: false,
      decoder: utils.decode,
      delimiter: "&",
      depth: 5,
      ignoreQueryPrefix: false,
      interpretNumericEntities: false,
      parameterLimit: 1e3,
      parseArrays: true,
      plainObjects: false,
      strictNullHandling: false
    };
    var interpretNumericEntities = function(str) {
      return str.replace(/&#(\d+);/g, function($0, numberStr) {
        return String.fromCharCode(parseInt(numberStr, 10));
      });
    };
    var parseArrayValue = function(val, options) {
      if (val && typeof val === "string" && options.comma && val.indexOf(",") > -1) {
        return val.split(",");
      }
      return val;
    };
    var isoSentinel = "utf8=%26%2310003%3B";
    var charsetSentinel = "utf8=%E2%9C%93";
    var parseValues = function parseQueryStringValues(str, options) {
      var obj = {};
      var cleanStr = options.ignoreQueryPrefix ? str.replace(/^\?/, "") : str;
      var limit = options.parameterLimit === Infinity ? void 0 : options.parameterLimit;
      var parts = cleanStr.split(options.delimiter, limit);
      var skipIndex = -1;
      var i2;
      var charset = options.charset;
      if (options.charsetSentinel) {
        for (i2 = 0; i2 < parts.length; ++i2) {
          if (parts[i2].indexOf("utf8=") === 0) {
            if (parts[i2] === charsetSentinel) {
              charset = "utf-8";
            } else if (parts[i2] === isoSentinel) {
              charset = "iso-8859-1";
            }
            skipIndex = i2;
            i2 = parts.length;
          }
        }
      }
      for (i2 = 0; i2 < parts.length; ++i2) {
        if (i2 === skipIndex) {
          continue;
        }
        var part = parts[i2];
        var bracketEqualsPos = part.indexOf("]=");
        var pos = bracketEqualsPos === -1 ? part.indexOf("=") : bracketEqualsPos + 1;
        var key, val;
        if (pos === -1) {
          key = options.decoder(part, defaults.decoder, charset, "key");
          val = options.strictNullHandling ? null : "";
        } else {
          key = options.decoder(part.slice(0, pos), defaults.decoder, charset, "key");
          val = utils.maybeMap(
            parseArrayValue(part.slice(pos + 1), options),
            function(encodedVal) {
              return options.decoder(encodedVal, defaults.decoder, charset, "value");
            }
          );
        }
        if (val && options.interpretNumericEntities && charset === "iso-8859-1") {
          val = interpretNumericEntities(val);
        }
        if (part.indexOf("[]=") > -1) {
          val = isArray(val) ? [val] : val;
        }
        if (has.call(obj, key)) {
          obj[key] = utils.combine(obj[key], val);
        } else {
          obj[key] = val;
        }
      }
      return obj;
    };
    var parseObject = function(chain, val, options, valuesParsed) {
      var leaf = valuesParsed ? val : parseArrayValue(val, options);
      for (var i2 = chain.length - 1; i2 >= 0; --i2) {
        var obj;
        var root = chain[i2];
        if (root === "[]" && options.parseArrays) {
          obj = [].concat(leaf);
        } else {
          obj = options.plainObjects ? /* @__PURE__ */ Object.create(null) : {};
          var cleanRoot = root.charAt(0) === "[" && root.charAt(root.length - 1) === "]" ? root.slice(1, -1) : root;
          var index = parseInt(cleanRoot, 10);
          if (!options.parseArrays && cleanRoot === "") {
            obj = { 0: leaf };
          } else if (!isNaN(index) && root !== cleanRoot && String(index) === cleanRoot && index >= 0 && (options.parseArrays && index <= options.arrayLimit)) {
            obj = [];
            obj[index] = leaf;
          } else if (cleanRoot !== "__proto__") {
            obj[cleanRoot] = leaf;
          }
        }
        leaf = obj;
      }
      return leaf;
    };
    var parseKeys = function parseQueryStringKeys(givenKey, val, options, valuesParsed) {
      if (!givenKey) {
        return;
      }
      var key = options.allowDots ? givenKey.replace(/\.([^.[]+)/g, "[$1]") : givenKey;
      var brackets = /(\[[^[\]]*])/;
      var child = /(\[[^[\]]*])/g;
      var segment = options.depth > 0 && brackets.exec(key);
      var parent = segment ? key.slice(0, segment.index) : key;
      var keys = [];
      if (parent) {
        if (!options.plainObjects && has.call(Object.prototype, parent)) {
          if (!options.allowPrototypes) {
            return;
          }
        }
        keys.push(parent);
      }
      var i2 = 0;
      while (options.depth > 0 && (segment = child.exec(key)) !== null && i2 < options.depth) {
        i2 += 1;
        if (!options.plainObjects && has.call(Object.prototype, segment[1].slice(1, -1))) {
          if (!options.allowPrototypes) {
            return;
          }
        }
        keys.push(segment[1]);
      }
      if (segment) {
        keys.push("[" + key.slice(segment.index) + "]");
      }
      return parseObject(keys, val, options, valuesParsed);
    };
    var normalizeParseOptions = function normalizeParseOptions2(opts) {
      if (!opts) {
        return defaults;
      }
      if (opts.decoder !== null && opts.decoder !== void 0 && typeof opts.decoder !== "function") {
        throw new TypeError("Decoder has to be a function.");
      }
      if (typeof opts.charset !== "undefined" && opts.charset !== "utf-8" && opts.charset !== "iso-8859-1") {
        throw new TypeError("The charset option must be either utf-8, iso-8859-1, or undefined");
      }
      var charset = typeof opts.charset === "undefined" ? defaults.charset : opts.charset;
      return {
        allowDots: typeof opts.allowDots === "undefined" ? defaults.allowDots : !!opts.allowDots,
        allowPrototypes: typeof opts.allowPrototypes === "boolean" ? opts.allowPrototypes : defaults.allowPrototypes,
        arrayLimit: typeof opts.arrayLimit === "number" ? opts.arrayLimit : defaults.arrayLimit,
        charset,
        charsetSentinel: typeof opts.charsetSentinel === "boolean" ? opts.charsetSentinel : defaults.charsetSentinel,
        comma: typeof opts.comma === "boolean" ? opts.comma : defaults.comma,
        decoder: typeof opts.decoder === "function" ? opts.decoder : defaults.decoder,
        delimiter: typeof opts.delimiter === "string" || utils.isRegExp(opts.delimiter) ? opts.delimiter : defaults.delimiter,
        // eslint-disable-next-line no-implicit-coercion, no-extra-parens
        depth: typeof opts.depth === "number" || opts.depth === false ? +opts.depth : defaults.depth,
        ignoreQueryPrefix: opts.ignoreQueryPrefix === true,
        interpretNumericEntities: typeof opts.interpretNumericEntities === "boolean" ? opts.interpretNumericEntities : defaults.interpretNumericEntities,
        parameterLimit: typeof opts.parameterLimit === "number" ? opts.parameterLimit : defaults.parameterLimit,
        parseArrays: opts.parseArrays !== false,
        plainObjects: typeof opts.plainObjects === "boolean" ? opts.plainObjects : defaults.plainObjects,
        strictNullHandling: typeof opts.strictNullHandling === "boolean" ? opts.strictNullHandling : defaults.strictNullHandling
      };
    };
    module.exports = function(str, opts) {
      var options = normalizeParseOptions(opts);
      if (str === "" || str === null || typeof str === "undefined") {
        return options.plainObjects ? /* @__PURE__ */ Object.create(null) : {};
      }
      var tempObj = typeof str === "string" ? parseValues(str, options) : str;
      var obj = options.plainObjects ? /* @__PURE__ */ Object.create(null) : {};
      var keys = Object.keys(tempObj);
      for (var i2 = 0; i2 < keys.length; ++i2) {
        var key = keys[i2];
        var newObj = parseKeys(key, tempObj[key], options, typeof str === "string");
        obj = utils.merge(obj, newObj, options);
      }
      return utils.compact(obj);
    };
  }
});

// node_modules/qs/lib/index.js
var require_lib = __commonJS({
  "node_modules/qs/lib/index.js"(exports, module) {
    "use strict";
    var stringify = require_stringify();
    var parse = require_parse();
    var formats = require_formats();
    module.exports = {
      formats,
      parse,
      stringify
    };
  }
});

// node_modules/ziggy-js/dist/index.m.js
var import_qs = __toESM(require_lib());
function r(t2, n2) {
  for (var r2 = 0; r2 < n2.length; r2++) {
    var e2 = n2[r2];
    e2.enumerable = e2.enumerable || false, e2.configurable = true, "value" in e2 && (e2.writable = true), Object.defineProperty(t2, e2.key, e2);
  }
}
function e(t2, n2, e2) {
  return n2 && r(t2.prototype, n2), e2 && r(t2, e2), Object.defineProperty(t2, "prototype", { writable: false }), t2;
}
function i() {
  return i = Object.assign ? Object.assign.bind() : function(t2) {
    for (var n2 = 1; n2 < arguments.length; n2++) {
      var r2 = arguments[n2];
      for (var e2 in r2)
        Object.prototype.hasOwnProperty.call(r2, e2) && (t2[e2] = r2[e2]);
    }
    return t2;
  }, i.apply(this, arguments);
}
function u(t2) {
  return u = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function(t3) {
    return t3.__proto__ || Object.getPrototypeOf(t3);
  }, u(t2);
}
function o(t2, n2) {
  return o = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function(t3, n3) {
    return t3.__proto__ = n3, t3;
  }, o(t2, n2);
}
function f() {
  if ("undefined" == typeof Reflect || !Reflect.construct)
    return false;
  if (Reflect.construct.sham)
    return false;
  if ("function" == typeof Proxy)
    return true;
  try {
    return Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function() {
    })), true;
  } catch (t2) {
    return false;
  }
}
function c(t2, n2, r2) {
  return c = f() ? Reflect.construct.bind() : function(t3, n3, r3) {
    var e2 = [null];
    e2.push.apply(e2, n3);
    var i2 = new (Function.bind.apply(t3, e2))();
    return r3 && o(i2, r3.prototype), i2;
  }, c.apply(null, arguments);
}
function a(t2) {
  var n2 = "function" == typeof Map ? /* @__PURE__ */ new Map() : void 0;
  return a = function(t3) {
    if (null === t3 || -1 === Function.toString.call(t3).indexOf("[native code]"))
      return t3;
    if ("function" != typeof t3)
      throw new TypeError("Super expression must either be null or a function");
    if (void 0 !== n2) {
      if (n2.has(t3))
        return n2.get(t3);
      n2.set(t3, r2);
    }
    function r2() {
      return c(t3, arguments, u(this).constructor);
    }
    return r2.prototype = Object.create(t3.prototype, { constructor: { value: r2, enumerable: false, writable: true, configurable: true } }), o(r2, t3);
  }, a(t2);
}
var s = function() {
  function n2(t2, n3, r3) {
    var e2, i2;
    this.name = t2, this.definition = n3, this.bindings = null != (e2 = n3.bindings) ? e2 : {}, this.wheres = null != (i2 = n3.wheres) ? i2 : {}, this.config = r3;
  }
  var r2 = n2.prototype;
  return r2.matchesUrl = function(n3) {
    var r3 = this;
    if (!this.definition.methods.includes("GET"))
      return false;
    var e2 = this.template.replace(/(\/?){([^}?]*)(\??)}/g, function(t2, n4, e3, i3) {
      var u3, o3 = "(?<" + e3 + ">" + ((null == (u3 = r3.wheres[e3]) ? void 0 : u3.replace(/(^\^)|(\$$)/g, "")) || "[^/?]+") + ")";
      return i3 ? "(" + n4 + o3 + ")?" : "" + n4 + o3;
    }).replace(/^\w+:\/\//, ""), i2 = n3.replace(/^\w+:\/\//, "").split("?"), u2 = i2[0], o2 = i2[1], f2 = new RegExp("^" + e2 + "/?$").exec(u2);
    if (f2) {
      for (var c2 in f2.groups)
        f2.groups[c2] = "string" == typeof f2.groups[c2] ? decodeURIComponent(f2.groups[c2]) : f2.groups[c2];
      return { params: f2.groups, query: (0, import_qs.parse)(o2) };
    }
    return false;
  }, r2.compile = function(t2) {
    var n3 = this, r3 = this.parameterSegments;
    return r3.length ? this.template.replace(/{([^}?]+)(\??)}/g, function(e2, i2, u2) {
      var o2, f2, c2;
      if (!u2 && [null, void 0].includes(t2[i2]))
        throw new Error("Ziggy error: '" + i2 + "' parameter is required for route '" + n3.name + "'.");
      if (r3[r3.length - 1].name === i2 && ".*" === n3.wheres[i2])
        return encodeURIComponent(null != (c2 = t2[i2]) ? c2 : "").replace(/%2F/g, "/");
      if (n3.wheres[i2] && !new RegExp("^" + (u2 ? "(" + n3.wheres[i2] + ")?" : n3.wheres[i2]) + "$").test(null != (o2 = t2[i2]) ? o2 : ""))
        throw new Error("Ziggy error: '" + i2 + "' parameter does not match required format '" + n3.wheres[i2] + "' for route '" + n3.name + "'.");
      return encodeURIComponent(null != (f2 = t2[i2]) ? f2 : "");
    }).replace(this.origin + "//", this.origin + "/").replace(/\/+$/, "") : this.template;
  }, e(n2, [{ key: "template", get: function() {
    return (this.origin + "/" + this.definition.uri).replace(/\/+$/, "");
  } }, { key: "origin", get: function() {
    return this.config.absolute ? this.definition.domain ? "" + this.config.url.match(/^\w+:\/\//)[0] + this.definition.domain + (this.config.port ? ":" + this.config.port : "") : this.config.url : "";
  } }, { key: "parameterSegments", get: function() {
    var t2, n3;
    return null != (t2 = null == (n3 = this.template.match(/{[^}?]+\??}/g)) ? void 0 : n3.map(function(t3) {
      return { name: t3.replace(/{|\??}/g, ""), required: !/\?}$/.test(t3) };
    })) ? t2 : [];
  } }]), n2;
}();
var l = function(t2) {
  var r2, u2;
  function f2(n2, r3, e2, u3) {
    var o2;
    if (void 0 === e2 && (e2 = true), (o2 = t2.call(this) || this).t = null != u3 ? u3 : "undefined" != typeof Ziggy ? Ziggy : null == globalThis ? void 0 : globalThis.Ziggy, o2.t = i({}, o2.t, { absolute: e2 }), n2) {
      if (!o2.t.routes[n2])
        throw new Error("Ziggy error: route '" + n2 + "' is not in the route list.");
      o2.i = new s(n2, o2.t.routes[n2], o2.t), o2.u = o2.o(r3);
    }
    return o2;
  }
  u2 = t2, (r2 = f2).prototype = Object.create(u2.prototype), r2.prototype.constructor = r2, o(r2, u2);
  var c2 = f2.prototype;
  return c2.toString = function() {
    var t3 = this, r3 = Object.keys(this.u).filter(function(n2) {
      return !t3.i.parameterSegments.some(function(t4) {
        return t4.name === n2;
      });
    }).filter(function(t4) {
      return "_query" !== t4;
    }).reduce(function(n2, r4) {
      var e2;
      return i({}, n2, ((e2 = {})[r4] = t3.u[r4], e2));
    }, {});
    return this.i.compile(this.u) + (0, import_qs.stringify)(i({}, r3, this.u._query), { addQueryPrefix: true, arrayFormat: "indices", encodeValuesOnly: true, skipNulls: true, encoder: function(t4, n2) {
      return "boolean" == typeof t4 ? Number(t4) : n2(t4);
    } });
  }, c2.l = function(t3) {
    var n2 = this;
    t3 ? this.t.absolute && t3.startsWith("/") && (t3 = this.h().host + t3) : t3 = this.v();
    var r3 = {}, e2 = Object.entries(this.t.routes).find(function(e3) {
      return r3 = new s(e3[0], e3[1], n2.t).matchesUrl(t3);
    }) || [void 0, void 0];
    return i({ name: e2[0] }, r3, { route: e2[1] });
  }, c2.v = function() {
    var t3 = this.h(), n2 = t3.pathname, r3 = t3.search;
    return (this.t.absolute ? t3.host + n2 : n2.replace(this.t.url.replace(/^\w*:\/\/[^/]+/, ""), "").replace(/^\/+/, "/")) + r3;
  }, c2.current = function(t3, n2) {
    var r3 = this.l(), e2 = r3.name, u3 = r3.params, o2 = r3.query, f3 = r3.route;
    if (!t3)
      return e2;
    var c3 = new RegExp("^" + t3.replace(/\./g, "\\.").replace(/\*/g, ".*") + "$").test(e2);
    if ([null, void 0].includes(n2) || !c3)
      return c3;
    var a2 = new s(e2, f3, this.t);
    n2 = this.o(n2, a2);
    var l2 = i({}, u3, o2);
    return !(!Object.values(n2).every(function(t4) {
      return !t4;
    }) || Object.values(l2).some(function(t4) {
      return void 0 !== t4;
    })) || Object.entries(n2).every(function(t4) {
      return l2[t4[0]] == t4[1];
    });
  }, c2.h = function() {
    var t3, n2, r3, e2, i2, u3, o2 = "undefined" != typeof window ? window.location : {}, f3 = o2.host, c3 = o2.pathname, a2 = o2.search;
    return { host: null != (t3 = null == (n2 = this.t.location) ? void 0 : n2.host) ? t3 : void 0 === f3 ? "" : f3, pathname: null != (r3 = null == (e2 = this.t.location) ? void 0 : e2.pathname) ? r3 : void 0 === c3 ? "" : c3, search: null != (i2 = null == (u3 = this.t.location) ? void 0 : u3.search) ? i2 : void 0 === a2 ? "" : a2 };
  }, c2.has = function(t3) {
    return Object.keys(this.t.routes).includes(t3);
  }, c2.o = function(t3, n2) {
    var r3 = this;
    void 0 === t3 && (t3 = {}), void 0 === n2 && (n2 = this.i), null != t3 || (t3 = {}), t3 = ["string", "number"].includes(typeof t3) ? [t3] : t3;
    var e2 = n2.parameterSegments.filter(function(t4) {
      return !r3.t.defaults[t4.name];
    });
    if (Array.isArray(t3))
      t3 = t3.reduce(function(t4, n3, r4) {
        var u4, o2;
        return i({}, t4, e2[r4] ? ((u4 = {})[e2[r4].name] = n3, u4) : "object" == typeof n3 ? n3 : ((o2 = {})[n3] = "", o2));
      }, {});
    else if (1 === e2.length && !t3[e2[0].name] && (t3.hasOwnProperty(Object.values(n2.bindings)[0]) || t3.hasOwnProperty("id"))) {
      var u3;
      (u3 = {})[e2[0].name] = t3, t3 = u3;
    }
    return i({}, this.g(n2), this.p(t3, n2));
  }, c2.g = function(t3) {
    var n2 = this;
    return t3.parameterSegments.filter(function(t4) {
      return n2.t.defaults[t4.name];
    }).reduce(function(t4, r3, e2) {
      var u3, o2 = r3.name;
      return i({}, t4, ((u3 = {})[o2] = n2.t.defaults[o2], u3));
    }, {});
  }, c2.p = function(t3, n2) {
    var r3 = n2.bindings, e2 = n2.parameterSegments;
    return Object.entries(t3).reduce(function(t4, n3) {
      var u3, o2, f3 = n3[0], c3 = n3[1];
      if (!c3 || "object" != typeof c3 || Array.isArray(c3) || !e2.some(function(t5) {
        return t5.name === f3;
      }))
        return i({}, t4, ((o2 = {})[f3] = c3, o2));
      if (!c3.hasOwnProperty(r3[f3])) {
        if (!c3.hasOwnProperty("id"))
          throw new Error("Ziggy error: object passed as '" + f3 + "' parameter is missing route model binding key '" + r3[f3] + "'.");
        r3[f3] = "id";
      }
      return i({}, t4, ((u3 = {})[f3] = c3[r3[f3]], u3));
    }, {});
  }, c2.valueOf = function() {
    return this.toString();
  }, c2.check = function(t3) {
    return this.has(t3);
  }, e(f2, [{ key: "params", get: function() {
    var t3 = this.l();
    return i({}, t3.params, t3.query);
  } }]), f2;
}(a(String));
function h(t2, n2, r2, e2) {
  var i2 = new l(t2, n2, r2, e2);
  return t2 ? i2.toString() : i2;
}
export {
  h as default
};
//# sourceMappingURL=ziggy-js.js.map
