import {
  __commonJS
} from "./chunk-DFKQJ226.js";

// node_modules/@stripe/stripe-js/dist/pure.js
var require_pure = __commonJS({
  "node_modules/@stripe/stripe-js/dist/pure.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function(obj2) {
          return typeof obj2;
        };
      } else {
        _typeof = function(obj2) {
          return obj2 && typeof Symbol === "function" && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
        };
      }
      return _typeof(obj);
    }
    var V3_URL = "https://js.stripe.com/v3";
    var V3_URL_REGEX = /^https:\/\/js\.stripe\.com\/v3\/?(\?.*)?$/;
    var EXISTING_SCRIPT_MESSAGE = "loadStripe.setLoadParameters was called but an existing Stripe.js script already exists in the document; existing script parameters will be used";
    var findScript = function findScript2() {
      var scripts = document.querySelectorAll('script[src^="'.concat(V3_URL, '"]'));
      for (var i = 0; i < scripts.length; i++) {
        var script = scripts[i];
        if (!V3_URL_REGEX.test(script.src)) {
          continue;
        }
        return script;
      }
      return null;
    };
    var injectScript = function injectScript2(params) {
      var queryString = params && !params.advancedFraudSignals ? "?advancedFraudSignals=false" : "";
      var script = document.createElement("script");
      script.src = "".concat(V3_URL).concat(queryString);
      var headOrBody = document.head || document.body;
      if (!headOrBody) {
        throw new Error("Expected document.body not to be null. Stripe.js requires a <body> element.");
      }
      headOrBody.appendChild(script);
      return script;
    };
    var registerWrapper = function registerWrapper2(stripe, startTime) {
      if (!stripe || !stripe._registerWrapper) {
        return;
      }
      stripe._registerWrapper({
        name: "stripe-js",
        version: "2.1.0",
        startTime
      });
    };
    var stripePromise = null;
    var loadScript = function loadScript2(params) {
      if (stripePromise !== null) {
        return stripePromise;
      }
      stripePromise = new Promise(function(resolve, reject) {
        if (typeof window === "undefined" || typeof document === "undefined") {
          resolve(null);
          return;
        }
        if (window.Stripe && params) {
          console.warn(EXISTING_SCRIPT_MESSAGE);
        }
        if (window.Stripe) {
          resolve(window.Stripe);
          return;
        }
        try {
          var script = findScript();
          if (script && params) {
            console.warn(EXISTING_SCRIPT_MESSAGE);
          } else if (!script) {
            script = injectScript(params);
          }
          script.addEventListener("load", function() {
            if (window.Stripe) {
              resolve(window.Stripe);
            } else {
              reject(new Error("Stripe.js not available"));
            }
          });
          script.addEventListener("error", function() {
            reject(new Error("Failed to load Stripe.js"));
          });
        } catch (error) {
          reject(error);
          return;
        }
      });
      return stripePromise;
    };
    var initStripe = function initStripe2(maybeStripe, args, startTime) {
      if (maybeStripe === null) {
        return null;
      }
      var stripe = maybeStripe.apply(void 0, args);
      registerWrapper(stripe, startTime);
      return stripe;
    };
    var validateLoadParams = function validateLoadParams2(params) {
      var errorMessage = "invalid load parameters; expected object of shape\n\n    {advancedFraudSignals: boolean}\n\nbut received\n\n    ".concat(JSON.stringify(params), "\n");
      if (params === null || _typeof(params) !== "object") {
        throw new Error(errorMessage);
      }
      if (Object.keys(params).length === 1 && typeof params.advancedFraudSignals === "boolean") {
        return params;
      }
      throw new Error(errorMessage);
    };
    var loadParams;
    var loadStripeCalled = false;
    var loadStripe = function loadStripe2() {
      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }
      loadStripeCalled = true;
      var startTime = Date.now();
      return loadScript(loadParams).then(function(maybeStripe) {
        return initStripe(maybeStripe, args, startTime);
      });
    };
    loadStripe.setLoadParameters = function(params) {
      if (loadStripeCalled && loadParams) {
        var validatedParams = validateLoadParams(params);
        var parameterKeys = Object.keys(validatedParams);
        var sameParameters = parameterKeys.reduce(function(previousValue, currentValue) {
          var _loadParams;
          return previousValue && params[currentValue] === ((_loadParams = loadParams) === null || _loadParams === void 0 ? void 0 : _loadParams[currentValue]);
        }, true);
        if (sameParameters) {
          return;
        }
      }
      if (loadStripeCalled) {
        throw new Error("You cannot change load parameters after calling loadStripe");
      }
      loadParams = validateLoadParams(params);
    };
    exports.loadStripe = loadStripe;
  }
});

// node_modules/@stripe/stripe-js/pure.js
var require_pure2 = __commonJS({
  "node_modules/@stripe/stripe-js/pure.js"(exports, module) {
    module.exports = require_pure();
  }
});
export default require_pure2();
//# sourceMappingURL=@stripe_stripe-js_pure.js.map
