globalThis._importMeta_=globalThis._importMeta_||{url:"file:///_entry.js",env:process.env};import 'node-fetch-native/polyfill';
import { Server as Server$1 } from 'node:http';
import { Server } from 'node:https';
import destr from 'destr';
import { defineEventHandler, handleCacheHeaders, createEvent, eventHandler, setHeaders, sendRedirect, proxyRequest, getRequestHeader, setResponseStatus, setResponseHeader, getRequestHeaders, createError, createApp, createRouter as createRouter$1, toNodeListener, fetchWithEvent, lazyEventHandler } from 'h3';
import { createFetch as createFetch$1, Headers } from 'ofetch';
import { createCall, createFetch } from 'unenv/runtime/fetch/index';
import { createHooks } from 'hookable';
import { snakeCase } from 'scule';
import { klona } from 'klona';
import defu, { defuFn } from 'defu';
import { hash } from 'ohash';
import { parseURL, withoutBase, joinURL, getQuery, withQuery, withLeadingSlash, withoutTrailingSlash } from 'ufo';
import { createStorage, prefixStorage } from 'unstorage';
import { toRouteMatcher, createRouter } from 'radix3';
import { promises } from 'node:fs';
import { fileURLToPath } from 'node:url';
import { dirname, resolve } from 'pathe';
import gracefulShutdown from 'http-graceful-shutdown';

const inlineAppConfig = {};



const appConfig = defuFn(inlineAppConfig);

const _inlineRuntimeConfig = {
  "app": {
    "baseURL": "/",
    "buildAssetsDir": "/_nuxt/",
    "cdnURL": ""
  },
  "nitro": {
    "envPrefix": "NUXT_",
    "routeRules": {
      "/__nuxt_error": {
        "cache": false
      },
      "/_nuxt/**": {
        "headers": {
          "cache-control": "public, max-age=31536000, immutable"
        }
      }
    }
  },
  "public": {
    "baseUrl": "",
    "gtag": {
      "id": "G-6SYFTJ34Q5",
      "config": {},
      "tags": [],
      "initialConsent": false,
      "loadingStrategy": "defer",
      "url": "https://www.googletagmanager.com/gtag/js"
    }
  }
};
const ENV_PREFIX = "NITRO_";
const ENV_PREFIX_ALT = _inlineRuntimeConfig.nitro.envPrefix ?? process.env.NITRO_ENV_PREFIX ?? "_";
const _sharedRuntimeConfig = _deepFreeze(
  _applyEnv(klona(_inlineRuntimeConfig))
);
function useRuntimeConfig(event) {
  if (!event) {
    return _sharedRuntimeConfig;
  }
  if (event.context.nitro.runtimeConfig) {
    return event.context.nitro.runtimeConfig;
  }
  const runtimeConfig = klona(_inlineRuntimeConfig);
  _applyEnv(runtimeConfig);
  event.context.nitro.runtimeConfig = runtimeConfig;
  return runtimeConfig;
}
_deepFreeze(klona(appConfig));
function _getEnv(key) {
  const envKey = snakeCase(key).toUpperCase();
  return destr(
    process.env[ENV_PREFIX + envKey] ?? process.env[ENV_PREFIX_ALT + envKey]
  );
}
function _isObject(input) {
  return typeof input === "object" && !Array.isArray(input);
}
function _applyEnv(obj, parentKey = "") {
  for (const key in obj) {
    const subKey = parentKey ? `${parentKey}_${key}` : key;
    const envValue = _getEnv(subKey);
    if (_isObject(obj[key])) {
      if (_isObject(envValue)) {
        obj[key] = { ...obj[key], ...envValue };
      }
      _applyEnv(obj[key], subKey);
    } else {
      obj[key] = envValue ?? obj[key];
    }
  }
  return obj;
}
function _deepFreeze(object) {
  const propNames = Object.getOwnPropertyNames(object);
  for (const name of propNames) {
    const value = object[name];
    if (value && typeof value === "object") {
      _deepFreeze(value);
    }
  }
  return Object.freeze(object);
}
new Proxy(/* @__PURE__ */ Object.create(null), {
  get: (_, prop) => {
    console.warn(
      "Please use `useRuntimeConfig()` instead of accessing config directly."
    );
    const runtimeConfig = useRuntimeConfig();
    if (prop in runtimeConfig) {
      return runtimeConfig[prop];
    }
    return void 0;
  }
});

const _assets = {

};

function normalizeKey(key) {
  if (!key) {
    return "";
  }
  return key.split("?")[0].replace(/[/\\]/g, ":").replace(/:+/g, ":").replace(/^:|:$/g, "");
}

const assets$1 = {
  getKeys() {
    return Promise.resolve(Object.keys(_assets))
  },
  hasItem (id) {
    id = normalizeKey(id);
    return Promise.resolve(id in _assets)
  },
  getItem (id) {
    id = normalizeKey(id);
    return Promise.resolve(_assets[id] ? _assets[id].import() : null)
  },
  getMeta (id) {
    id = normalizeKey(id);
    return Promise.resolve(_assets[id] ? _assets[id].meta : {})
  }
};

const storage = createStorage({});

storage.mount('/assets', assets$1);

function useStorage(base = "") {
  return base ? prefixStorage(storage, base) : storage;
}

const defaultCacheOptions = {
  name: "_",
  base: "/cache",
  swr: true,
  maxAge: 1
};
function defineCachedFunction(fn, opts = {}) {
  opts = { ...defaultCacheOptions, ...opts };
  const pending = {};
  const group = opts.group || "nitro/functions";
  const name = opts.name || fn.name || "_";
  const integrity = hash([opts.integrity, fn, opts]);
  const validate = opts.validate || (() => true);
  async function get(key, resolver, shouldInvalidateCache) {
    const cacheKey = [opts.base, group, name, key + ".json"].filter(Boolean).join(":").replace(/:\/$/, ":index");
    const entry = await useStorage().getItem(cacheKey) || {};
    const ttl = (opts.maxAge ?? opts.maxAge ?? 0) * 1e3;
    if (ttl) {
      entry.expires = Date.now() + ttl;
    }
    const expired = shouldInvalidateCache || entry.integrity !== integrity || ttl && Date.now() - (entry.mtime || 0) > ttl || !validate(entry);
    const _resolve = async () => {
      const isPending = pending[key];
      if (!isPending) {
        if (entry.value !== void 0 && (opts.staleMaxAge || 0) >= 0 && opts.swr === false) {
          entry.value = void 0;
          entry.integrity = void 0;
          entry.mtime = void 0;
          entry.expires = void 0;
        }
        pending[key] = Promise.resolve(resolver());
      }
      try {
        entry.value = await pending[key];
      } catch (error) {
        if (!isPending) {
          delete pending[key];
        }
        throw error;
      }
      if (!isPending) {
        entry.mtime = Date.now();
        entry.integrity = integrity;
        delete pending[key];
        if (validate(entry)) {
          useStorage().setItem(cacheKey, entry).catch((error) => console.error("[nitro] [cache]", error));
        }
      }
    };
    const _resolvePromise = expired ? _resolve() : Promise.resolve();
    if (opts.swr && entry.value) {
      _resolvePromise.catch(console.error);
      return entry;
    }
    return _resolvePromise.then(() => entry);
  }
  return async (...args) => {
    const shouldBypassCache = opts.shouldBypassCache?.(...args);
    if (shouldBypassCache) {
      return fn(...args);
    }
    const key = await (opts.getKey || getKey)(...args);
    const shouldInvalidateCache = opts.shouldInvalidateCache?.(...args);
    const entry = await get(key, () => fn(...args), shouldInvalidateCache);
    let value = entry.value;
    if (opts.transform) {
      value = await opts.transform(entry, ...args) || value;
    }
    return value;
  };
}
const cachedFunction = defineCachedFunction;
function getKey(...args) {
  return args.length > 0 ? hash(args, {}) : "";
}
function escapeKey(key) {
  return key.replace(/[^\dA-Za-z]/g, "");
}
function defineCachedEventHandler(handler, opts = defaultCacheOptions) {
  const _opts = {
    ...opts,
    getKey: async (event) => {
      const key = await opts.getKey?.(event);
      if (key) {
        return escapeKey(key);
      }
      const url = event.node.req.originalUrl || event.node.req.url;
      const friendlyName = escapeKey(decodeURI(parseURL(url).pathname)).slice(
        0,
        16
      );
      const urlHash = hash(url);
      return `${friendlyName}.${urlHash}`;
    },
    validate: (entry) => {
      if (entry.value.code >= 400) {
        return false;
      }
      if (entry.value.body === void 0) {
        return false;
      }
      return true;
    },
    group: opts.group || "nitro/handlers",
    integrity: [opts.integrity, handler]
  };
  const _cachedHandler = cachedFunction(
    async (incomingEvent) => {
      const reqProxy = cloneWithProxy(incomingEvent.node.req, { headers: {} });
      const resHeaders = {};
      let _resSendBody;
      const resProxy = cloneWithProxy(incomingEvent.node.res, {
        statusCode: 200,
        writableEnded: false,
        writableFinished: false,
        headersSent: false,
        closed: false,
        getHeader(name) {
          return resHeaders[name];
        },
        setHeader(name, value) {
          resHeaders[name] = value;
          return this;
        },
        getHeaderNames() {
          return Object.keys(resHeaders);
        },
        hasHeader(name) {
          return name in resHeaders;
        },
        removeHeader(name) {
          delete resHeaders[name];
        },
        getHeaders() {
          return resHeaders;
        },
        end(chunk, arg2, arg3) {
          if (typeof chunk === "string") {
            _resSendBody = chunk;
          }
          if (typeof arg2 === "function") {
            arg2();
          }
          if (typeof arg3 === "function") {
            arg3();
          }
          return this;
        },
        write(chunk, arg2, arg3) {
          if (typeof chunk === "string") {
            _resSendBody = chunk;
          }
          if (typeof arg2 === "function") {
            arg2();
          }
          if (typeof arg3 === "function") {
            arg3();
          }
          return this;
        },
        writeHead(statusCode, headers2) {
          this.statusCode = statusCode;
          if (headers2) {
            for (const header in headers2) {
              this.setHeader(header, headers2[header]);
            }
          }
          return this;
        }
      });
      const event = createEvent(reqProxy, resProxy);
      event.context = incomingEvent.context;
      const body = await handler(event) || _resSendBody;
      const headers = event.node.res.getHeaders();
      headers.etag = headers.Etag || headers.etag || `W/"${hash(body)}"`;
      headers["last-modified"] = headers["Last-Modified"] || headers["last-modified"] || (/* @__PURE__ */ new Date()).toUTCString();
      const cacheControl = [];
      if (opts.swr) {
        if (opts.maxAge) {
          cacheControl.push(`s-maxage=${opts.maxAge}`);
        }
        if (opts.staleMaxAge) {
          cacheControl.push(`stale-while-revalidate=${opts.staleMaxAge}`);
        } else {
          cacheControl.push("stale-while-revalidate");
        }
      } else if (opts.maxAge) {
        cacheControl.push(`max-age=${opts.maxAge}`);
      }
      if (cacheControl.length > 0) {
        headers["cache-control"] = cacheControl.join(", ");
      }
      const cacheEntry = {
        code: event.node.res.statusCode,
        headers,
        body
      };
      return cacheEntry;
    },
    _opts
  );
  return defineEventHandler(async (event) => {
    if (opts.headersOnly) {
      if (handleCacheHeaders(event, { maxAge: opts.maxAge })) {
        return;
      }
      return handler(event);
    }
    const response = await _cachedHandler(event);
    if (event.node.res.headersSent || event.node.res.writableEnded) {
      return response.body;
    }
    if (handleCacheHeaders(event, {
      modifiedTime: new Date(response.headers["last-modified"]),
      etag: response.headers.etag,
      maxAge: opts.maxAge
    })) {
      return;
    }
    event.node.res.statusCode = response.code;
    for (const name in response.headers) {
      event.node.res.setHeader(name, response.headers[name]);
    }
    return response.body;
  });
}
function cloneWithProxy(obj, overrides) {
  return new Proxy(obj, {
    get(target, property, receiver) {
      if (property in overrides) {
        return overrides[property];
      }
      return Reflect.get(target, property, receiver);
    },
    set(target, property, value, receiver) {
      if (property in overrides) {
        overrides[property] = value;
        return true;
      }
      return Reflect.set(target, property, value, receiver);
    }
  });
}
const cachedEventHandler = defineCachedEventHandler;

const config = useRuntimeConfig();
const _routeRulesMatcher = toRouteMatcher(
  createRouter({ routes: config.nitro.routeRules })
);
function createRouteRulesHandler() {
  return eventHandler((event) => {
    const routeRules = getRouteRules(event);
    if (routeRules.headers) {
      setHeaders(event, routeRules.headers);
    }
    if (routeRules.redirect) {
      return sendRedirect(
        event,
        routeRules.redirect.to,
        routeRules.redirect.statusCode
      );
    }
    if (routeRules.proxy) {
      let target = routeRules.proxy.to;
      if (target.endsWith("/**")) {
        let targetPath = event.path;
        const strpBase = routeRules.proxy._proxyStripBase;
        if (strpBase) {
          targetPath = withoutBase(targetPath, strpBase);
        }
        target = joinURL(target.slice(0, -3), targetPath);
      } else if (event.path.includes("?")) {
        const query = getQuery(event.path);
        target = withQuery(target, query);
      }
      return proxyRequest(event, target, {
        fetch: $fetch.raw,
        ...routeRules.proxy
      });
    }
  });
}
function getRouteRules(event) {
  event.context._nitro = event.context._nitro || {};
  if (!event.context._nitro.routeRules) {
    const path = new URL(event.node.req.url, "http://localhost").pathname;
    event.context._nitro.routeRules = getRouteRulesForPath(
      withoutBase(path, useRuntimeConfig().app.baseURL)
    );
  }
  return event.context._nitro.routeRules;
}
function getRouteRulesForPath(path) {
  return defu({}, ..._routeRulesMatcher.matchAll(path).reverse());
}

const plugins = [
  
];

function hasReqHeader(event, name, includes) {
  const value = getRequestHeader(event, name);
  return value && typeof value === "string" && value.toLowerCase().includes(includes);
}
function isJsonRequest(event) {
  return hasReqHeader(event, "accept", "application/json") || hasReqHeader(event, "user-agent", "curl/") || hasReqHeader(event, "user-agent", "httpie/") || hasReqHeader(event, "sec-fetch-mode", "cors") || event.path.startsWith("/api/") || event.path.endsWith(".json");
}
function normalizeError(error) {
  const cwd = typeof process.cwd === "function" ? process.cwd() : "/";
  const stack = (error.stack || "").split("\n").splice(1).filter((line) => line.includes("at ")).map((line) => {
    const text = line.replace(cwd + "/", "./").replace("webpack:/", "").replace("file://", "").trim();
    return {
      text,
      internal: line.includes("node_modules") && !line.includes(".cache") || line.includes("internal") || line.includes("new Promise")
    };
  });
  const statusCode = error.statusCode || 500;
  const statusMessage = error.statusMessage ?? (statusCode === 404 ? "Not Found" : "");
  const message = error.message || error.toString();
  return {
    stack,
    statusCode,
    statusMessage,
    message
  };
}
function trapUnhandledNodeErrors() {
  {
    process.on(
      "unhandledRejection",
      (err) => console.error("[nitro] [unhandledRejection] " + err)
    );
    process.on(
      "uncaughtException",
      (err) => console.error("[nitro]  [uncaughtException] " + err)
    );
  }
}

const errorHandler = (async function errorhandler(error, event) {
  const { stack, statusCode, statusMessage, message } = normalizeError(error);
  const errorObject = {
    url: event.node.req.url,
    statusCode,
    statusMessage,
    message,
    stack: "",
    data: error.data
  };
  if (error.unhandled || error.fatal) {
    const tags = [
      "[nuxt]",
      "[request error]",
      error.unhandled && "[unhandled]",
      error.fatal && "[fatal]",
      Number(errorObject.statusCode) !== 200 && `[${errorObject.statusCode}]`
    ].filter(Boolean).join(" ");
    console.error(tags, errorObject.message + "\n" + stack.map((l) => "  " + l.text).join("  \n"));
  }
  if (event.handled) {
    return;
  }
  setResponseStatus(event, errorObject.statusCode !== 200 && errorObject.statusCode || 500, errorObject.statusMessage);
  if (isJsonRequest(event)) {
    setResponseHeader(event, "Content-Type", "application/json");
    event.node.res.end(JSON.stringify(errorObject));
    return;
  }
  const isErrorPage = event.node.req.url?.startsWith("/__nuxt_error");
  const res = !isErrorPage ? await useNitroApp().localFetch(withQuery(joinURL(useRuntimeConfig().app.baseURL, "/__nuxt_error"), errorObject), {
    headers: getRequestHeaders(event),
    redirect: "manual"
  }).catch(() => null) : null;
  if (!res) {
    const { template } = await import('../error-500.mjs');
    if (event.handled) {
      return;
    }
    setResponseHeader(event, "Content-Type", "text/html;charset=UTF-8");
    event.node.res.end(template(errorObject));
    return;
  }
  const html = await res.text();
  if (event.handled) {
    return;
  }
  for (const [header, value] of res.headers.entries()) {
    setResponseHeader(event, header, value);
  }
  setResponseStatus(event, res.status && res.status !== 200 ? res.status : void 0, res.statusText);
  event.node.res.end(html);
});

const assets = {
  "/android-chrome-192x192.png": {
    "type": "image/png",
    "etag": "\"246d-RjlV096+9f3+/HZIvNuyvpsOxNc\"",
    "mtime": "2024-08-07T20:06:17.082Z",
    "size": 9325,
    "path": "../public/android-chrome-192x192.png"
  },
  "/android-chrome-512x512.png": {
    "type": "image/png",
    "etag": "\"6745-Pn+QuBHndiWmfWx9FuUdl0zv9ZU\"",
    "mtime": "2024-08-07T20:06:17.082Z",
    "size": 26437,
    "path": "../public/android-chrome-512x512.png"
  },
  "/apple-touch-icon.png": {
    "type": "image/png",
    "etag": "\"2070-CkM0U339wMT4XwjMQcl+rpzs/hE\"",
    "mtime": "2024-08-07T20:06:17.082Z",
    "size": 8304,
    "path": "../public/apple-touch-icon.png"
  },
  "/favicon-16x16.png": {
    "type": "image/png",
    "etag": "\"206-8CSUDWqDvdotaLQQcTJGfWAbYFQ\"",
    "mtime": "2024-08-07T20:06:17.081Z",
    "size": 518,
    "path": "../public/favicon-16x16.png"
  },
  "/favicon-32x32.png": {
    "type": "image/png",
    "etag": "\"3ef-cqmGWPzOpHOMiM7qa/BRcU3Qnrk\"",
    "mtime": "2024-08-07T20:06:17.081Z",
    "size": 1007,
    "path": "../public/favicon-32x32.png"
  },
  "/favicon.ico": {
    "type": "image/vnd.microsoft.icon",
    "etag": "\"3c2e-lMrg/FND7CVNfgFV6sGSVovy2Hs\"",
    "mtime": "2024-08-07T20:06:17.081Z",
    "size": 15406,
    "path": "../public/favicon.ico"
  },
  "/site.webmanifest": {
    "type": "application/manifest+json",
    "etag": "\"107-vzG6+RvdL83iSkXj8qG+M3M8b2k\"",
    "mtime": "2024-08-07T20:06:17.072Z",
    "size": 263,
    "path": "../public/site.webmanifest"
  },
  "/_nuxt/AvailableRouteCard.b93e6a03.js": {
    "type": "application/javascript",
    "etag": "\"784-+p6hdtmibzgrHxqZ23d9RryCjnc\"",
    "mtime": "2024-08-07T20:06:17.071Z",
    "size": 1924,
    "path": "../public/_nuxt/AvailableRouteCard.b93e6a03.js"
  },
  "/_nuxt/AvailableRouteCard.b93e6a03.js.map": {
    "type": "application/json",
    "etag": "\"a3b-fwIfhhD2vllAUoeoalEI5v4Of34\"",
    "mtime": "2024-08-07T20:06:17.071Z",
    "size": 2619,
    "path": "../public/_nuxt/AvailableRouteCard.b93e6a03.js.map"
  },
  "/_nuxt/BaseRouteCard.05b3b5e5.js": {
    "type": "application/javascript",
    "etag": "\"c0e-9Rs4taxTt4hvxpzamYrMI9HuFaM\"",
    "mtime": "2024-08-07T20:06:17.071Z",
    "size": 3086,
    "path": "../public/_nuxt/BaseRouteCard.05b3b5e5.js"
  },
  "/_nuxt/BaseRouteCard.05b3b5e5.js.map": {
    "type": "application/json",
    "etag": "\"11ed-CzsQPTRlpy+XY7BUyhDUdVBLSI4\"",
    "mtime": "2024-08-07T20:06:17.071Z",
    "size": 4589,
    "path": "../public/_nuxt/BaseRouteCard.05b3b5e5.js.map"
  },
  "/_nuxt/CircleNumber.c37b8f40.js": {
    "type": "application/javascript",
    "etag": "\"83c-Nnpv3/SrI/mOTjd00oG7Lx5mQNY\"",
    "mtime": "2024-08-07T20:06:17.071Z",
    "size": 2108,
    "path": "../public/_nuxt/CircleNumber.c37b8f40.js"
  },
  "/_nuxt/CircleNumber.c37b8f40.js.map": {
    "type": "application/json",
    "etag": "\"fba-bka6phSHd7tLUKMfz8xps07gJZ4\"",
    "mtime": "2024-08-07T20:06:17.071Z",
    "size": 4026,
    "path": "../public/_nuxt/CircleNumber.c37b8f40.js.map"
  },
  "/_nuxt/CitySelectField.4d3b6fdc.js": {
    "type": "application/javascript",
    "etag": "\"623-u6ip35+hPgu5Ko2Nvpo5px2l2MU\"",
    "mtime": "2024-08-07T20:06:17.071Z",
    "size": 1571,
    "path": "../public/_nuxt/CitySelectField.4d3b6fdc.js"
  },
  "/_nuxt/CitySelectField.4d3b6fdc.js.map": {
    "type": "application/json",
    "etag": "\"f33-0K7ILzDl/EC2Ipf1ggBiY4WsEfs\"",
    "mtime": "2024-08-07T20:06:17.070Z",
    "size": 3891,
    "path": "../public/_nuxt/CitySelectField.4d3b6fdc.js.map"
  },
  "/_nuxt/FormField.06ea38fd.css": {
    "type": "text/css; charset=utf-8",
    "etag": "\"26-WkBc7JDYPaydH/5WtcedhVQ8I7E\"",
    "mtime": "2024-08-07T20:06:17.070Z",
    "size": 38,
    "path": "../public/_nuxt/FormField.06ea38fd.css"
  },
  "/_nuxt/FormField.28d83c3d.js": {
    "type": "application/javascript",
    "etag": "\"375-lcZSVge9PNDnz/D69kYHDB9z4NA\"",
    "mtime": "2024-08-07T20:06:17.070Z",
    "size": 885,
    "path": "../public/_nuxt/FormField.28d83c3d.js"
  },
  "/_nuxt/FormField.28d83c3d.js.map": {
    "type": "application/json",
    "etag": "\"796-9E9SBbr/Ssuln33hWwv7OfoCQUU\"",
    "mtime": "2024-08-07T20:06:17.070Z",
    "size": 1942,
    "path": "../public/_nuxt/FormField.28d83c3d.js.map"
  },
  "/_nuxt/FormTitle.508c8534.js": {
    "type": "application/javascript",
    "etag": "\"2f5-UWPztVVdaydmSlFooflJxEXc1iE\"",
    "mtime": "2024-08-07T20:06:17.070Z",
    "size": 757,
    "path": "../public/_nuxt/FormTitle.508c8534.js"
  },
  "/_nuxt/FormTitle.508c8534.js.map": {
    "type": "application/json",
    "etag": "\"64f-eXlbnDjOuxDNkdORYmA0JbGar7s\"",
    "mtime": "2024-08-07T20:06:17.070Z",
    "size": 1615,
    "path": "../public/_nuxt/FormTitle.508c8534.js.map"
  },
  "/_nuxt/PageHeader.788b07c6.js": {
    "type": "application/javascript",
    "etag": "\"ad7-UBS8Ii0nmpEguwCvjjQDZgwx9ms\"",
    "mtime": "2024-08-07T20:06:17.070Z",
    "size": 2775,
    "path": "../public/_nuxt/PageHeader.788b07c6.js"
  },
  "/_nuxt/PageHeader.788b07c6.js.map": {
    "type": "application/json",
    "etag": "\"12ba-Q4jsybWUa0ZM8r7/v+JrxZn9KTA\"",
    "mtime": "2024-08-07T20:06:17.069Z",
    "size": 4794,
    "path": "../public/_nuxt/PageHeader.788b07c6.js.map"
  },
  "/_nuxt/PageHeaderTitle.89441d47.js": {
    "type": "application/javascript",
    "etag": "\"25f-kXS6g1TtbwpbCsJO7P4VWyBpV30\"",
    "mtime": "2024-08-07T20:06:17.069Z",
    "size": 607,
    "path": "../public/_nuxt/PageHeaderTitle.89441d47.js"
  },
  "/_nuxt/PageHeaderTitle.89441d47.js.map": {
    "type": "application/json",
    "etag": "\"442-y4+ZMwnV+QrnBgLHWgVVgk/7lCQ\"",
    "mtime": "2024-08-07T20:06:17.069Z",
    "size": 1090,
    "path": "../public/_nuxt/PageHeaderTitle.89441d47.js.map"
  },
  "/_nuxt/RoundedButton.f48696b9.js": {
    "type": "application/javascript",
    "etag": "\"916-QC23HOpJvcKmwfm+KrdxMUMpi5o\"",
    "mtime": "2024-08-07T20:06:17.069Z",
    "size": 2326,
    "path": "../public/_nuxt/RoundedButton.f48696b9.js"
  },
  "/_nuxt/RoundedButton.f48696b9.js.map": {
    "type": "application/json",
    "etag": "\"f0c-RIsa6IofGktN0f/8TCrugCJecgA\"",
    "mtime": "2024-08-07T20:06:17.069Z",
    "size": 3852,
    "path": "../public/_nuxt/RoundedButton.f48696b9.js.map"
  },
  "/_nuxt/SearchForm.15cdfcdc.js": {
    "type": "application/javascript",
    "etag": "\"19a6-3LmYUKUn93hh9BqdaPqk4yGwXKQ\"",
    "mtime": "2024-08-07T20:06:17.069Z",
    "size": 6566,
    "path": "../public/_nuxt/SearchForm.15cdfcdc.js"
  },
  "/_nuxt/SearchForm.15cdfcdc.js.map": {
    "type": "application/json",
    "etag": "\"45d1-FpbM08FfrlCxoys0YcftGeJ+ssI\"",
    "mtime": "2024-08-07T20:06:17.069Z",
    "size": 17873,
    "path": "../public/_nuxt/SearchForm.15cdfcdc.js.map"
  },
  "/_nuxt/SearchForm.24b846c2.css": {
    "type": "text/css; charset=utf-8",
    "etag": "\"60b-xv9kbvttFJaZeKq5Q0oBKK0rTHQ\"",
    "mtime": "2024-08-07T20:06:17.068Z",
    "size": 1547,
    "path": "../public/_nuxt/SearchForm.24b846c2.css"
  },
  "/_nuxt/SearchRoutes.7729e083.js": {
    "type": "application/javascript",
    "etag": "\"1d4-brytH5Zwf0rTMjXzxF5oL+cL0QQ\"",
    "mtime": "2024-08-07T20:06:17.068Z",
    "size": 468,
    "path": "../public/_nuxt/SearchRoutes.7729e083.js"
  },
  "/_nuxt/SearchRoutes.7729e083.js.map": {
    "type": "application/json",
    "etag": "\"382-JKZRcw4b3aV8cQ1hr6quqUwKRG0\"",
    "mtime": "2024-08-07T20:06:17.068Z",
    "size": 898,
    "path": "../public/_nuxt/SearchRoutes.7729e083.js.map"
  },
  "/_nuxt/SectionLayer.21234a05.js": {
    "type": "application/javascript",
    "etag": "\"1b3-w725ymjxvTcWtXuN2ux1oI0NWrM\"",
    "mtime": "2024-08-07T20:06:17.068Z",
    "size": 435,
    "path": "../public/_nuxt/SectionLayer.21234a05.js"
  },
  "/_nuxt/SectionLayer.21234a05.js.map": {
    "type": "application/json",
    "etag": "\"32c-jOuhpM1u/F5NlG8LT9yvQSFyFcw\"",
    "mtime": "2024-08-07T20:06:17.068Z",
    "size": 812,
    "path": "../public/_nuxt/SectionLayer.21234a05.js.map"
  },
  "/_nuxt/SectionTitle.bdb0230a.js": {
    "type": "application/javascript",
    "etag": "\"27f-J/y7tueKmf44dzdmdrIiV8HMPOc\"",
    "mtime": "2024-08-07T20:06:17.068Z",
    "size": 639,
    "path": "../public/_nuxt/SectionTitle.bdb0230a.js"
  },
  "/_nuxt/SectionTitle.bdb0230a.js.map": {
    "type": "application/json",
    "etag": "\"4d1-qRSq7+5+LMP/8a/xXVnCv21TWgA\"",
    "mtime": "2024-08-07T20:06:17.068Z",
    "size": 1233,
    "path": "../public/_nuxt/SectionTitle.bdb0230a.js.map"
  },
  "/_nuxt/SectionWrapper.a3888927.js": {
    "type": "application/javascript",
    "etag": "\"2f8-ObagwIjsLDDIGe8OMq2Qxj9pTZA\"",
    "mtime": "2024-08-07T20:06:17.067Z",
    "size": 760,
    "path": "../public/_nuxt/SectionWrapper.a3888927.js"
  },
  "/_nuxt/SectionWrapper.a3888927.js.map": {
    "type": "application/json",
    "etag": "\"5b2-hinYnL6xe+a4ERr22/TPofzHMH8\"",
    "mtime": "2024-08-07T20:06:17.067Z",
    "size": 1458,
    "path": "../public/_nuxt/SectionWrapper.a3888927.js.map"
  },
  "/_nuxt/SiteHeader.ad1d3b93.js": {
    "type": "application/javascript",
    "etag": "\"292-CHBp34AQsvRnbb33Kiyb76SoXbc\"",
    "mtime": "2024-08-07T20:06:17.067Z",
    "size": 658,
    "path": "../public/_nuxt/SiteHeader.ad1d3b93.js"
  },
  "/_nuxt/SiteHeader.ad1d3b93.js.map": {
    "type": "application/json",
    "etag": "\"3bf-RZz5+VUUDIOG0jvMOOKZqJi5RqU\"",
    "mtime": "2024-08-07T20:06:17.067Z",
    "size": 959,
    "path": "../public/_nuxt/SiteHeader.ad1d3b93.js.map"
  },
  "/_nuxt/SmallPageHeader.bd7eb180.js": {
    "type": "application/javascript",
    "etag": "\"326-7+fCR+3AGjnPKVLXnH99PVRr3OI\"",
    "mtime": "2024-08-07T20:06:17.067Z",
    "size": 806,
    "path": "../public/_nuxt/SmallPageHeader.bd7eb180.js"
  },
  "/_nuxt/SmallPageHeader.bd7eb180.js.map": {
    "type": "application/json",
    "etag": "\"608-ltKNmeFJZ7ju6NysO/kSHBZibso\"",
    "mtime": "2024-08-07T20:06:17.067Z",
    "size": 1544,
    "path": "../public/_nuxt/SmallPageHeader.bd7eb180.js.map"
  },
  "/_nuxt/Spinner.d190d224.js": {
    "type": "application/javascript",
    "etag": "\"1e5-MUeLs04tWuo19B86FlaDjtFnWps\"",
    "mtime": "2024-08-07T20:06:17.067Z",
    "size": 485,
    "path": "../public/_nuxt/Spinner.d190d224.js"
  },
  "/_nuxt/Spinner.d190d224.js.map": {
    "type": "application/json",
    "etag": "\"320-Tq8jz2O/hVmFNDeDLCw3+1fAfQo\"",
    "mtime": "2024-08-07T20:06:17.067Z",
    "size": 800,
    "path": "../public/_nuxt/Spinner.d190d224.js.map"
  },
  "/_nuxt/activated.30e4c1b6.js": {
    "type": "application/javascript",
    "etag": "\"125-b7XXADwduYy/RiNJMnChd/efbX8\"",
    "mtime": "2024-08-07T20:06:17.066Z",
    "size": 293,
    "path": "../public/_nuxt/activated.30e4c1b6.js"
  },
  "/_nuxt/activated.30e4c1b6.js.map": {
    "type": "application/json",
    "etag": "\"317-lTTauLOOiyhaW1s2Vb02wHaVq9g\"",
    "mtime": "2024-08-07T20:06:17.066Z",
    "size": 791,
    "path": "../public/_nuxt/activated.30e4c1b6.js.map"
  },
  "/_nuxt/auth.ee6e57cd.js": {
    "type": "application/javascript",
    "etag": "\"b8-wuFxhg9NmCHbz7E7IL3yHGedmLM\"",
    "mtime": "2024-08-07T20:06:17.066Z",
    "size": 184,
    "path": "../public/_nuxt/auth.ee6e57cd.js"
  },
  "/_nuxt/auth.ee6e57cd.js.map": {
    "type": "application/json",
    "etag": "\"223-ijh6rOig5NIU9nX8uYUvQLEoUxE\"",
    "mtime": "2024-08-07T20:06:17.066Z",
    "size": 547,
    "path": "../public/_nuxt/auth.ee6e57cd.js.map"
  },
  "/_nuxt/cgu.c5b48fcd.js": {
    "type": "application/javascript",
    "etag": "\"2e38-oFdSBMiCToUdYiOftBjeZYR2fwk\"",
    "mtime": "2024-08-07T20:06:17.066Z",
    "size": 11832,
    "path": "../public/_nuxt/cgu.c5b48fcd.js"
  },
  "/_nuxt/cgu.c5b48fcd.js.map": {
    "type": "application/json",
    "etag": "\"40d3-OzWNu455jXexru3IMTl8B8QVcV8\"",
    "mtime": "2024-08-07T20:06:17.066Z",
    "size": 16595,
    "path": "../public/_nuxt/cgu.c5b48fcd.js.map"
  },
  "/_nuxt/checkbox.esm.b2138736.js": {
    "type": "application/javascript",
    "etag": "\"a29-1UsbXeEBo+KVwjqlptK1X6KlbEE\"",
    "mtime": "2024-08-07T20:06:17.066Z",
    "size": 2601,
    "path": "../public/_nuxt/checkbox.esm.b2138736.js"
  },
  "/_nuxt/checkbox.esm.b2138736.js.map": {
    "type": "application/json",
    "etag": "\"20df-qQWN1feMJrvl8ehQNmL1MDjF0Lk\"",
    "mtime": "2024-08-07T20:06:17.065Z",
    "size": 8415,
    "path": "../public/_nuxt/checkbox.esm.b2138736.js.map"
  },
  "/_nuxt/client-only.3508f12e.js": {
    "type": "application/javascript",
    "etag": "\"206-u5QfqIcUINvJGQ4PZrLFVafXoQk\"",
    "mtime": "2024-08-07T20:06:17.065Z",
    "size": 518,
    "path": "../public/_nuxt/client-only.3508f12e.js"
  },
  "/_nuxt/client-only.3508f12e.js.map": {
    "type": "application/json",
    "etag": "\"d12-JPR6br0mFFl8sPFum105FtAYzJA\"",
    "mtime": "2024-08-07T20:06:17.065Z",
    "size": 3346,
    "path": "../public/_nuxt/client-only.3508f12e.js.map"
  },
  "/_nuxt/dashboard.b20113ab.js": {
    "type": "application/javascript",
    "etag": "\"1cbd-9EJshh6c9AP3SNbovzh503/X0HE\"",
    "mtime": "2024-08-07T20:06:17.065Z",
    "size": 7357,
    "path": "../public/_nuxt/dashboard.b20113ab.js"
  },
  "/_nuxt/dashboard.b20113ab.js.map": {
    "type": "application/json",
    "etag": "\"38b0-bBs+5yUnUYifXuSq+1xttDk7v28\"",
    "mtime": "2024-08-07T20:06:17.065Z",
    "size": 14512,
    "path": "../public/_nuxt/dashboard.b20113ab.js.map"
  },
  "/_nuxt/dayjs.12728dc2.js": {
    "type": "application/javascript",
    "etag": "\"8e-MGfMikF1YB+ieHVq3vD8gn2xM4A\"",
    "mtime": "2024-08-07T20:06:17.065Z",
    "size": 142,
    "path": "../public/_nuxt/dayjs.12728dc2.js"
  },
  "/_nuxt/dayjs.12728dc2.js.map": {
    "type": "application/json",
    "etag": "\"1b8-meGlS1OtCPM987ybsKpl+68KAMQ\"",
    "mtime": "2024-08-07T20:06:17.064Z",
    "size": 440,
    "path": "../public/_nuxt/dayjs.12728dc2.js.map"
  },
  "/_nuxt/entry.01d4b5f9.js": {
    "type": "application/javascript",
    "etag": "\"c5fa6-aaxWCuW+BWcHc3JoPFiJegf+7L0\"",
    "mtime": "2024-08-07T20:06:17.061Z",
    "size": 810918,
    "path": "../public/_nuxt/entry.01d4b5f9.js"
  },
  "/_nuxt/entry.01d4b5f9.js.map": {
    "type": "application/json",
    "etag": "\"320921-+AgSQX2Vm71ZRAYSt6aHcv/P/J0\"",
    "mtime": "2024-08-07T20:06:17.060Z",
    "size": 3279137,
    "path": "../public/_nuxt/entry.01d4b5f9.js.map"
  },
  "/_nuxt/entry.253f87eb.css": {
    "type": "text/css; charset=utf-8",
    "etag": "\"1c28e-Z+FNSfr+Vc7wyzgoMHvH0mZjqAU\"",
    "mtime": "2024-08-07T20:06:17.058Z",
    "size": 115342,
    "path": "../public/_nuxt/entry.253f87eb.css"
  },
  "/_nuxt/error-404.7fc72018.css": {
    "type": "text/css; charset=utf-8",
    "etag": "\"e2e-iNt1cqPQ0WDudfCTZVQd31BeRGs\"",
    "mtime": "2024-08-07T20:06:17.058Z",
    "size": 3630,
    "path": "../public/_nuxt/error-404.7fc72018.css"
  },
  "/_nuxt/error-404.eb7b0ab5.js": {
    "type": "application/javascript",
    "etag": "\"8fc-8yJfqj8T3ij2NHA9/BgMmDU6oWE\"",
    "mtime": "2024-08-07T20:06:17.058Z",
    "size": 2300,
    "path": "../public/_nuxt/error-404.eb7b0ab5.js"
  },
  "/_nuxt/error-404.eb7b0ab5.js.map": {
    "type": "application/json",
    "etag": "\"1663-cEmFpeZ6zWJbaeIxJ0IFAlY9RSQ\"",
    "mtime": "2024-08-07T20:06:17.058Z",
    "size": 5731,
    "path": "../public/_nuxt/error-404.eb7b0ab5.js.map"
  },
  "/_nuxt/error-500.75f6aa7e.js": {
    "type": "application/javascript",
    "etag": "\"785-U0Q0yDp/ZuhYwCo4vrAzfFWvF78\"",
    "mtime": "2024-08-07T20:06:17.057Z",
    "size": 1925,
    "path": "../public/_nuxt/error-500.75f6aa7e.js"
  },
  "/_nuxt/error-500.75f6aa7e.js.map": {
    "type": "application/json",
    "etag": "\"e80-yR0so+JiIoy28bmSQYfEkYTb3Xw\"",
    "mtime": "2024-08-07T20:06:17.057Z",
    "size": 3712,
    "path": "../public/_nuxt/error-500.75f6aa7e.js.map"
  },
  "/_nuxt/error-500.c5df6088.css": {
    "type": "text/css; charset=utf-8",
    "etag": "\"79e-ByRo+49BgcevWdRjJy3CMx2IA5k\"",
    "mtime": "2024-08-07T20:06:17.057Z",
    "size": 1950,
    "path": "../public/_nuxt/error-500.c5df6088.css"
  },
  "/_nuxt/fileupload.esm.e7cea8e8.js": {
    "type": "application/javascript",
    "etag": "\"44d9-EZ8GkuYqjYzQQQqH0huT3Qp6HyY\"",
    "mtime": "2024-08-07T20:06:17.057Z",
    "size": 17625,
    "path": "../public/_nuxt/fileupload.esm.e7cea8e8.js"
  },
  "/_nuxt/fileupload.esm.e7cea8e8.js.map": {
    "type": "application/json",
    "etag": "\"d104-+uE2IaP6IU+zy+xPu4aAoforFNc\"",
    "mtime": "2024-08-07T20:06:17.057Z",
    "size": 53508,
    "path": "../public/_nuxt/fileupload.esm.e7cea8e8.js.map"
  },
  "/_nuxt/forgot-password.ecd709a3.js": {
    "type": "application/javascript",
    "etag": "\"1586-cBWFL89SCwLXKE98Q76+DavlWc0\"",
    "mtime": "2024-08-07T20:06:17.057Z",
    "size": 5510,
    "path": "../public/_nuxt/forgot-password.ecd709a3.js"
  },
  "/_nuxt/forgot-password.ecd709a3.js.map": {
    "type": "application/json",
    "etag": "\"24c3-9KVLzFn468M7BTwJRAKk+W4i1PI\"",
    "mtime": "2024-08-07T20:06:17.056Z",
    "size": 9411,
    "path": "../public/_nuxt/forgot-password.ecd709a3.js.map"
  },
  "/_nuxt/guide.2da1bb94.css": {
    "type": "text/css; charset=utf-8",
    "etag": "\"d7-vpHqREz87vEDcGFN+z3xijWdE4o\"",
    "mtime": "2024-08-07T20:06:17.056Z",
    "size": 215,
    "path": "../public/_nuxt/guide.2da1bb94.css"
  },
  "/_nuxt/guide.5579791e.js": {
    "type": "application/javascript",
    "etag": "\"5223-K5Y20XcIfi1WJaab34JNkWUq1cw\"",
    "mtime": "2024-08-07T20:06:17.056Z",
    "size": 21027,
    "path": "../public/_nuxt/guide.5579791e.js"
  },
  "/_nuxt/guide.5579791e.js.map": {
    "type": "application/json",
    "etag": "\"9994-2jTV/oBWe1mRoA6Fi0+QoeU7RZs\"",
    "mtime": "2024-08-07T20:06:17.056Z",
    "size": 39316,
    "path": "../public/_nuxt/guide.5579791e.js.map"
  },
  "/_nuxt/index.1dc3f514.js": {
    "type": "application/javascript",
    "etag": "\"850c-5obxKRjVqBrFPKfGdVNwR+THkqk\"",
    "mtime": "2024-08-07T20:06:17.056Z",
    "size": 34060,
    "path": "../public/_nuxt/index.1dc3f514.js"
  },
  "/_nuxt/index.1dc3f514.js.map": {
    "type": "application/json",
    "etag": "\"f44f-SxMX1jl826C2feX9tFw3HTCtjpg\"",
    "mtime": "2024-08-07T20:06:17.055Z",
    "size": 62543,
    "path": "../public/_nuxt/index.1dc3f514.js.map"
  },
  "/_nuxt/index.602410b1.js": {
    "type": "application/javascript",
    "etag": "\"1cd9-XsdY+Y3R0Brzav4eVU/CGbi8j14\"",
    "mtime": "2024-08-07T20:06:17.055Z",
    "size": 7385,
    "path": "../public/_nuxt/index.602410b1.js"
  },
  "/_nuxt/index.602410b1.js.map": {
    "type": "application/json",
    "etag": "\"2fba-1JTmnZpGpufxFu9ie2/Skwo+6bc\"",
    "mtime": "2024-08-07T20:06:17.055Z",
    "size": 12218,
    "path": "../public/_nuxt/index.602410b1.js.map"
  },
  "/_nuxt/lodash.bf3645ef.js": {
    "type": "application/javascript",
    "etag": "\"1198b-q/2Kcz6JxG3qvHgmk0/mW7BNn78\"",
    "mtime": "2024-08-07T20:06:17.055Z",
    "size": 72075,
    "path": "../public/_nuxt/lodash.bf3645ef.js"
  },
  "/_nuxt/lodash.bf3645ef.js.map": {
    "type": "application/json",
    "etag": "\"ae40f-64pzER8ydEzxXbgzvElowVU3PWE\"",
    "mtime": "2024-08-07T20:06:17.055Z",
    "size": 713743,
    "path": "../public/_nuxt/lodash.bf3645ef.js.map"
  },
  "/_nuxt/login.8839ad0d.js": {
    "type": "application/javascript",
    "etag": "\"b45-t/5n6naNi2Xy+KcRmuk4cfVlljM\"",
    "mtime": "2024-08-07T20:06:17.054Z",
    "size": 2885,
    "path": "../public/_nuxt/login.8839ad0d.js"
  },
  "/_nuxt/login.8839ad0d.js.map": {
    "type": "application/json",
    "etag": "\"134b-6sUkL/IS5jjuyNTO+o9gcgOIEqg\"",
    "mtime": "2024-08-07T20:06:17.054Z",
    "size": 4939,
    "path": "../public/_nuxt/login.8839ad0d.js.map"
  },
  "/_nuxt/main.78ed87c6.css": {
    "type": "text/css; charset=utf-8",
    "etag": "\"2e-xsWfpCOpba5o514fad5wgXB745A\"",
    "mtime": "2024-08-07T20:06:17.054Z",
    "size": 46,
    "path": "../public/_nuxt/main.78ed87c6.css"
  },
  "/_nuxt/main.b866ffff.js": {
    "type": "application/javascript",
    "etag": "\"c8a9-/TPVOUqMmmusKJwNM/vVIlPL0pY\"",
    "mtime": "2024-08-07T20:06:17.053Z",
    "size": 51369,
    "path": "../public/_nuxt/main.b866ffff.js"
  },
  "/_nuxt/main.b866ffff.js.map": {
    "type": "application/json",
    "etag": "\"584cc-5M/xhuzB5qdmLkovP0Im0JH/LvU\"",
    "mtime": "2024-08-07T20:06:17.053Z",
    "size": 361676,
    "path": "../public/_nuxt/main.b866ffff.js.map"
  },
  "/_nuxt/mentions-legales.8d04929b.js": {
    "type": "application/javascript",
    "etag": "\"3100-x96HVhQ4REQDO/vqGj5ICRbBHZA\"",
    "mtime": "2024-08-07T20:06:17.053Z",
    "size": 12544,
    "path": "../public/_nuxt/mentions-legales.8d04929b.js"
  },
  "/_nuxt/mentions-legales.8d04929b.js.map": {
    "type": "application/json",
    "etag": "\"44ba-nRC9t7Tyt40MHDDKtgD97vF05xQ\"",
    "mtime": "2024-08-07T20:06:17.053Z",
    "size": 17594,
    "path": "../public/_nuxt/mentions-legales.8d04929b.js.map"
  },
  "/_nuxt/mes-alertes.fcacb00a.js": {
    "type": "application/javascript",
    "etag": "\"eec-QxCog/oWvCORjNxtMG8hY8xkQLc\"",
    "mtime": "2024-08-07T20:06:17.052Z",
    "size": 3820,
    "path": "../public/_nuxt/mes-alertes.fcacb00a.js"
  },
  "/_nuxt/mes-alertes.fcacb00a.js.map": {
    "type": "application/json",
    "etag": "\"1b86-HGpuWefpmnwxM8eWgA1bctoMNXY\"",
    "mtime": "2024-08-07T20:06:17.052Z",
    "size": 7046,
    "path": "../public/_nuxt/mes-alertes.fcacb00a.js.map"
  },
  "/_nuxt/mes-demandes-de-trajets.3cae8757.js": {
    "type": "application/javascript",
    "etag": "\"3de5-sLkyYmiTqO57l/0psU4hJYliKJo\"",
    "mtime": "2024-08-07T20:06:17.052Z",
    "size": 15845,
    "path": "../public/_nuxt/mes-demandes-de-trajets.3cae8757.js"
  },
  "/_nuxt/mes-demandes-de-trajets.3cae8757.js.map": {
    "type": "application/json",
    "etag": "\"6336-cMtWlj2DehYntmd21PUh91iWCkI\"",
    "mtime": "2024-08-07T20:06:17.052Z",
    "size": 25398,
    "path": "../public/_nuxt/mes-demandes-de-trajets.3cae8757.js.map"
  },
  "/_nuxt/mes-trajets-publies.c8114fdc.js": {
    "type": "application/javascript",
    "etag": "\"595d-sHOjnaXXpMEaPUnGezzmbYq13JI\"",
    "mtime": "2024-08-07T20:06:17.051Z",
    "size": 22877,
    "path": "../public/_nuxt/mes-trajets-publies.c8114fdc.js"
  },
  "/_nuxt/mes-trajets-publies.c8114fdc.js.map": {
    "type": "application/json",
    "etag": "\"8639-NjbMccUnGecJtHR0Ph2lWH/ZD7k\"",
    "mtime": "2024-08-07T20:06:17.051Z",
    "size": 34361,
    "path": "../public/_nuxt/mes-trajets-publies.c8114fdc.js.map"
  },
  "/_nuxt/mobile-verified.699da574.js": {
    "type": "application/javascript",
    "etag": "\"163-5ijzQrm/hw67MvuO1O9aKuEb4Uw\"",
    "mtime": "2024-08-07T20:06:17.051Z",
    "size": 355,
    "path": "../public/_nuxt/mobile-verified.699da574.js"
  },
  "/_nuxt/mobile-verified.699da574.js.map": {
    "type": "application/json",
    "etag": "\"371-JMTFbhvPcwuKpzMOJ2FlvYOFtQ4\"",
    "mtime": "2024-08-07T20:06:17.051Z",
    "size": 881,
    "path": "../public/_nuxt/mobile-verified.699da574.js.map"
  },
  "/_nuxt/nos-services.a36e171f.js": {
    "type": "application/javascript",
    "etag": "\"202f-tI2Ppp2GHuJXOKlyma3BBGrbpME\"",
    "mtime": "2024-08-07T20:06:17.051Z",
    "size": 8239,
    "path": "../public/_nuxt/nos-services.a36e171f.js"
  },
  "/_nuxt/nos-services.a36e171f.js.map": {
    "type": "application/json",
    "etag": "\"302d-EFlVz4mL36zWYWiA9/WgeezMXmQ\"",
    "mtime": "2024-08-07T20:06:17.050Z",
    "size": 12333,
    "path": "../public/_nuxt/nos-services.a36e171f.js.map"
  },
  "/_nuxt/notre-concept.c0979b87.js": {
    "type": "application/javascript",
    "etag": "\"1568-i6ANS2kgxJTADkw/69s+piEsWK8\"",
    "mtime": "2024-08-07T20:06:17.050Z",
    "size": 5480,
    "path": "../public/_nuxt/notre-concept.c0979b87.js"
  },
  "/_nuxt/notre-concept.c0979b87.js.map": {
    "type": "application/json",
    "etag": "\"233d-xqgrqdsT7oQ4ahQctNmsVMvCdng\"",
    "mtime": "2024-08-07T20:06:17.050Z",
    "size": 9021,
    "path": "../public/_nuxt/notre-concept.c0979b87.js.map"
  },
  "/_nuxt/nuxt-link.158ca296.js": {
    "type": "application/javascript",
    "etag": "\"112f-FOXySIwsoJnSN32mzt8Tiz7dSpg\"",
    "mtime": "2024-08-07T20:06:17.050Z",
    "size": 4399,
    "path": "../public/_nuxt/nuxt-link.158ca296.js"
  },
  "/_nuxt/nuxt-link.158ca296.js.map": {
    "type": "application/json",
    "etag": "\"4871-HRK/lRscPXuJ8h72tLuJe3XIVLo\"",
    "mtime": "2024-08-07T20:06:17.049Z",
    "size": 18545,
    "path": "../public/_nuxt/nuxt-link.158ca296.js.map"
  },
  "/_nuxt/politique-cookie.074c4d9e.js": {
    "type": "application/javascript",
    "etag": "\"2cd9-xGgLsIJf8YMF9HeTTE2b9t+d+H8\"",
    "mtime": "2024-08-07T20:06:17.049Z",
    "size": 11481,
    "path": "../public/_nuxt/politique-cookie.074c4d9e.js"
  },
  "/_nuxt/politique-cookie.074c4d9e.js.map": {
    "type": "application/json",
    "etag": "\"4252-OHjCdPsdkiyhR1oRxgmxsfdHCPM\"",
    "mtime": "2024-08-07T20:06:17.049Z",
    "size": 16978,
    "path": "../public/_nuxt/politique-cookie.074c4d9e.js.map"
  },
  "/_nuxt/politique-de-confidentialite.8a01c1ae.js": {
    "type": "application/javascript",
    "etag": "\"31bf-3DvpmBYdwgAyTCW3qyxQpxxCf0s\"",
    "mtime": "2024-08-07T20:06:17.049Z",
    "size": 12735,
    "path": "../public/_nuxt/politique-de-confidentialite.8a01c1ae.js"
  },
  "/_nuxt/politique-de-confidentialite.8a01c1ae.js.map": {
    "type": "application/json",
    "etag": "\"4d56-lTr6x4gmYVUx0M9CiLbLKJ+xbhk\"",
    "mtime": "2024-08-07T20:06:17.048Z",
    "size": 19798,
    "path": "../public/_nuxt/politique-de-confidentialite.8a01c1ae.js.map"
  },
  "/_nuxt/publier-un-trajet.91cff8ce.js": {
    "type": "application/javascript",
    "etag": "\"3f21-Ixehb6AaTvbZI4BU5kg5JKDTKtk\"",
    "mtime": "2024-08-07T20:06:17.048Z",
    "size": 16161,
    "path": "../public/_nuxt/publier-un-trajet.91cff8ce.js"
  },
  "/_nuxt/publier-un-trajet.91cff8ce.js.map": {
    "type": "application/json",
    "etag": "\"6ed8-rO2IVXOmBJvGvn26Iff2xevpRjA\"",
    "mtime": "2024-08-07T20:06:17.048Z",
    "size": 28376,
    "path": "../public/_nuxt/publier-un-trajet.91cff8ce.js.map"
  },
  "/_nuxt/rechercher-un-trajet.978f66d9.js": {
    "type": "application/javascript",
    "etag": "\"464-0XeUBaT3fx8xEccGYPu4/fj9e1o\"",
    "mtime": "2024-08-07T20:06:17.048Z",
    "size": 1124,
    "path": "../public/_nuxt/rechercher-un-trajet.978f66d9.js"
  },
  "/_nuxt/rechercher-un-trajet.978f66d9.js.map": {
    "type": "application/json",
    "etag": "\"71-iaWOI71FM/UQmbDTDDzZEcNZ5WA\"",
    "mtime": "2024-08-07T20:06:17.047Z",
    "size": 113,
    "path": "../public/_nuxt/rechercher-un-trajet.978f66d9.js.map"
  },
  "/_nuxt/register.9c75880f.js": {
    "type": "application/javascript",
    "etag": "\"539c-1nZbnTUWk18NAU3sBI+gX29cyJk\"",
    "mtime": "2024-08-07T20:06:17.047Z",
    "size": 21404,
    "path": "../public/_nuxt/register.9c75880f.js"
  },
  "/_nuxt/register.9c75880f.js.map": {
    "type": "application/json",
    "etag": "\"bb24-QmPGnSYkVY06RGdstRnKo3reYjo\"",
    "mtime": "2024-08-07T20:06:17.047Z",
    "size": 47908,
    "path": "../public/_nuxt/register.9c75880f.js.map"
  },
  "/_nuxt/resultats.183017de.css": {
    "type": "text/css; charset=utf-8",
    "etag": "\"2b2-+fwQkGNfANuf2N7Y1+I4ai10DAk\"",
    "mtime": "2024-08-07T20:06:17.047Z",
    "size": 690,
    "path": "../public/_nuxt/resultats.183017de.css"
  },
  "/_nuxt/resultats.38c25b5f.js": {
    "type": "application/javascript",
    "etag": "\"1c80-4KzFsY4Y4jHM3fzoWcUgKP7o6fY\"",
    "mtime": "2024-08-07T20:06:17.046Z",
    "size": 7296,
    "path": "../public/_nuxt/resultats.38c25b5f.js"
  },
  "/_nuxt/resultats.38c25b5f.js.map": {
    "type": "application/json",
    "etag": "\"3388-u2JyFJ36zjbFYV6GtxS7m1xU86c\"",
    "mtime": "2024-08-07T20:06:17.046Z",
    "size": 13192,
    "path": "../public/_nuxt/resultats.38c25b5f.js.map"
  },
  "/_nuxt/stripe.adcc31cc.js": {
    "type": "application/javascript",
    "etag": "\"221-xBv5AR3wSgp+KxP7jTtDq7n1WjA\"",
    "mtime": "2024-08-07T20:06:17.046Z",
    "size": 545,
    "path": "../public/_nuxt/stripe.adcc31cc.js"
  },
  "/_nuxt/stripe.adcc31cc.js.map": {
    "type": "application/json",
    "etag": "\"52e-9tX90MaHO2Zp9xJv52jpPo8nJKs\"",
    "mtime": "2024-08-07T20:06:17.045Z",
    "size": 1326,
    "path": "../public/_nuxt/stripe.adcc31cc.js.map"
  },
  "/_nuxt/subscribed.75f6815a.js": {
    "type": "application/javascript",
    "etag": "\"126-e4egHq4b6NCJ2xoIJlNsK+nuDB4\"",
    "mtime": "2024-08-07T20:06:17.045Z",
    "size": 294,
    "path": "../public/_nuxt/subscribed.75f6815a.js"
  },
  "/_nuxt/subscribed.75f6815a.js.map": {
    "type": "application/json",
    "etag": "\"318-Q9vjfFz5MKKWxheVew56dCihM1k\"",
    "mtime": "2024-08-07T20:06:17.045Z",
    "size": 792,
    "path": "../public/_nuxt/subscribed.75f6815a.js.map"
  },
  "/_nuxt/utils.20247176.js": {
    "type": "application/javascript",
    "etag": "\"415-W2pydb3WoJbPZ7D+FY9Y7vHd4aE\"",
    "mtime": "2024-08-07T20:06:17.045Z",
    "size": 1045,
    "path": "../public/_nuxt/utils.20247176.js"
  },
  "/_nuxt/utils.20247176.js.map": {
    "type": "application/json",
    "etag": "\"da1-6HBY4gHxS/xh0jfHnmo3mQvYvGs\"",
    "mtime": "2024-08-07T20:06:17.044Z",
    "size": 3489,
    "path": "../public/_nuxt/utils.20247176.js.map"
  },
  "/_nuxt/valid-clearance.c3416db1.js": {
    "type": "application/javascript",
    "etag": "\"1ad-slmydSjVew8adwFwzpKFtjNSVeU\"",
    "mtime": "2024-08-07T20:06:17.044Z",
    "size": 429,
    "path": "../public/_nuxt/valid-clearance.c3416db1.js"
  },
  "/_nuxt/valid-clearance.c3416db1.js.map": {
    "type": "application/json",
    "etag": "\"43d-RiZaQJvrijX5RZalRUAk+bqg14Y\"",
    "mtime": "2024-08-07T20:06:17.044Z",
    "size": 1085,
    "path": "../public/_nuxt/valid-clearance.c3416db1.js.map"
  },
  "/images/BACKGROUND CHIFFRES.png": {
    "type": "image/png",
    "etag": "\"12eb-nnMglaH+n3vMPtQEwU2t975E6g0\"",
    "mtime": "2024-08-07T20:06:17.081Z",
    "size": 4843,
    "path": "../public/images/BACKGROUND CHIFFRES.png"
  },
  "/images/BG POP UP SANS CLOCHE.png": {
    "type": "image/png",
    "etag": "\"12b1b-YLCIbxamqKzdlAfCIA4w5ndwd4E\"",
    "mtime": "2024-08-07T20:06:17.081Z",
    "size": 76571,
    "path": "../public/images/BG POP UP SANS CLOCHE.png"
  },
  "/images/BURGER.svg": {
    "type": "image/svg+xml",
    "etag": "\"104-/flxdDs5jeKs3nWX1kkT4S2hS54\"",
    "mtime": "2024-08-07T20:06:17.081Z",
    "size": 260,
    "path": "../public/images/BURGER.svg"
  },
  "/images/CLOCHE ALERTE POP UP.png": {
    "type": "image/png",
    "etag": "\"46e9-JQhTtP17yQjU90UL7O53cccx4sE\"",
    "mtime": "2024-08-07T20:06:17.080Z",
    "size": 18153,
    "path": "../public/images/CLOCHE ALERTE POP UP.png"
  },
  "/images/CLOSE.svg": {
    "type": "image/svg+xml",
    "etag": "\"18d-ikt0auVjOnWRP1R2vvQ5cTwbLJI\"",
    "mtime": "2024-08-07T20:06:17.080Z",
    "size": 397,
    "path": "../public/images/CLOSE.svg"
  },
  "/images/CROIX.svg": {
    "type": "image/svg+xml",
    "etag": "\"260-3ol1ntsmlEDziW4U0edUeHvSw9A\"",
    "mtime": "2024-08-07T20:06:17.080Z",
    "size": 608,
    "path": "../public/images/CROIX.svg"
  },
  "/images/FOND FLECHE BLEU 2.png": {
    "type": "image/png",
    "etag": "\"2b9a-uHIqAqCjqvrHjKMh7Gtr+1za+QM\"",
    "mtime": "2024-08-07T20:06:17.080Z",
    "size": 11162,
    "path": "../public/images/FOND FLECHE BLEU 2.png"
  },
  "/images/FOND FLÈCHE BLEU CLAIR.png": {
    "type": "image/png",
    "etag": "\"64de-HxsilRxQKaO6equh7Ul/PKLbIaQ\"",
    "mtime": "2024-08-07T20:06:17.080Z",
    "size": 25822,
    "path": "../public/images/FOND FLÈCHE BLEU CLAIR.png"
  },
  "/images/FOND FLÈCHES BLEU.png": {
    "type": "image/png",
    "etag": "\"106c1-UC1fE5qqSjAULRh6Jd0oTNmjMws\"",
    "mtime": "2024-08-07T20:06:17.080Z",
    "size": 67265,
    "path": "../public/images/FOND FLÈCHES BLEU.png"
  },
  "/images/FOND FLÈCHES GRIS 2.png": {
    "type": "image/png",
    "etag": "\"15140-33TNYZkHCdxzDwRYje01lEMF7Ow\"",
    "mtime": "2024-08-07T20:06:17.079Z",
    "size": 86336,
    "path": "../public/images/FOND FLÈCHES GRIS 2.png"
  },
  "/images/FOND FLÈCHES GRIS.png": {
    "type": "image/png",
    "etag": "\"9b09-VYnQkvnDYH3GtKQEHFIgmBZ0rSs\"",
    "mtime": "2024-08-07T20:06:17.079Z",
    "size": 39689,
    "path": "../public/images/FOND FLÈCHES GRIS.png"
  },
  "/images/FOND FLÈCHES VERT.png": {
    "type": "image/png",
    "etag": "\"10aa3-BDDmBhcOWRNwzueqn3H7n3T6/9c\"",
    "mtime": "2024-08-07T20:06:17.079Z",
    "size": 68259,
    "path": "../public/images/FOND FLÈCHES VERT.png"
  },
  "/images/FRANCE.png": {
    "type": "image/png",
    "etag": "\"a6ca-7TJ5l1x9fy40OZ8BXKqWqBxJMYQ\"",
    "mtime": "2024-08-07T20:06:17.079Z",
    "size": 42698,
    "path": "../public/images/FRANCE.png"
  },
  "/images/ILLU CHERCHER UN TRAJET.png": {
    "type": "image/png",
    "etag": "\"5883-dEJb/KiXrfFOUDnm/Ob5WRAMFyo\"",
    "mtime": "2024-08-07T20:06:17.079Z",
    "size": 22659,
    "path": "../public/images/ILLU CHERCHER UN TRAJET.png"
  },
  "/images/ILLU PUBLIER UN TRAJET.png": {
    "type": "image/png",
    "etag": "\"63f6-6gNkg6+do67DR8iVYV2Zd2xbjGo\"",
    "mtime": "2024-08-07T20:06:17.078Z",
    "size": 25590,
    "path": "../public/images/ILLU PUBLIER UN TRAJET.png"
  },
  "/images/MAP.svg": {
    "type": "image/svg+xml",
    "etag": "\"24a-E4RY7yZDfQKhhfjRfC/N64qHNSU\"",
    "mtime": "2024-08-07T20:06:17.078Z",
    "size": 586,
    "path": "../public/images/MAP.svg"
  },
  "/images/MONTAGNE.svg": {
    "type": "image/svg+xml",
    "etag": "\"28d-vfRhPq8s1wOm86kTVyrqYXt8JNM\"",
    "mtime": "2024-08-07T20:06:17.078Z",
    "size": 653,
    "path": "../public/images/MONTAGNE.svg"
  },
  "/images/PIN.svg": {
    "type": "image/svg+xml",
    "etag": "\"163c-akUupMKUAovuVukfXfGlxfPIA2s\"",
    "mtime": "2024-08-07T20:06:17.078Z",
    "size": 5692,
    "path": "../public/images/PIN.svg"
  },
  "/images/POINTILLÉS CROIX.svg": {
    "type": "image/svg+xml",
    "etag": "\"58a-Rm4QCN9WPYOrtGxyAI0ME7X13yM\"",
    "mtime": "2024-08-07T20:06:17.078Z",
    "size": 1418,
    "path": "../public/images/POINTILLÉS CROIX.svg"
  },
  "/images/POINTILLÉS MAP.svg": {
    "type": "image/svg+xml",
    "etag": "\"71581-xumT+NwQx/UA5ZJcN8JNptl+kIE\"",
    "mtime": "2024-08-07T20:06:17.078Z",
    "size": 464257,
    "path": "../public/images/POINTILLÉS MAP.svg"
  },
  "/images/POINTILLÉS MONTAGNE.svg": {
    "type": "image/svg+xml",
    "etag": "\"156-9ee6iSx+flv5hK1DEuAfJ2tmrmQ\"",
    "mtime": "2024-08-07T20:06:17.077Z",
    "size": 342,
    "path": "../public/images/POINTILLÉS MONTAGNE.svg"
  },
  "/images/POINTILLÉS PIN.svg": {
    "type": "image/svg+xml",
    "etag": "\"c5f5-cRICAZSXgFQOfRbBxEKmQaZVKJo\"",
    "mtime": "2024-08-07T20:06:17.077Z",
    "size": 50677,
    "path": "../public/images/POINTILLÉS PIN.svg"
  },
  "/images/POINTILLÉS POINT.svg": {
    "type": "image/svg+xml",
    "etag": "\"55b-dY/gfrIl/nKtMduGbKEPuiYH8P0\"",
    "mtime": "2024-08-07T20:06:17.077Z",
    "size": 1371,
    "path": "../public/images/POINTILLÉS POINT.svg"
  },
  "/images/POINTILLÉS TITRES.png": {
    "type": "image/png",
    "etag": "\"45a1-GjGx66jYI8DQGDVbXCT0hW/vPCA\"",
    "mtime": "2024-08-07T20:06:17.077Z",
    "size": 17825,
    "path": "../public/images/POINTILLÉS TITRES.png"
  },
  "/images/POINTILLÉS+CROIX.png": {
    "type": "image/png",
    "etag": "\"3675-JAWxLXT+lg/nN7NTA42iQ+p/rbk\"",
    "mtime": "2024-08-07T20:06:17.077Z",
    "size": 13941,
    "path": "../public/images/POINTILLÉS+CROIX.png"
  },
  "/images/POINTILLÉS+MONTAGNE.png": {
    "type": "image/png",
    "etag": "\"201c-c9cNmzJ9AP+DLObwbxNsKk18ua4\"",
    "mtime": "2024-08-07T20:06:17.076Z",
    "size": 8220,
    "path": "../public/images/POINTILLÉS+MONTAGNE.png"
  },
  "/images/POINTILLÉS+PIN.png": {
    "type": "image/png",
    "etag": "\"2785-13Y6ZlWPj2cnSpXZfJxnbXaSic4\"",
    "mtime": "2024-08-07T20:06:17.076Z",
    "size": 10117,
    "path": "../public/images/POINTILLÉS+PIN.png"
  },
  "/images/POINTILLÉS+PLAN.png": {
    "type": "image/png",
    "etag": "\"62aa-LiINWtQoVmZC1YkzNqClrPRQ4SE\"",
    "mtime": "2024-08-07T20:06:17.076Z",
    "size": 25258,
    "path": "../public/images/POINTILLÉS+PLAN.png"
  },
  "/images/POINTILLÉS+POINT.png": {
    "type": "image/png",
    "etag": "\"cbb0-BBpnnUQxwrXtvlbKezQrUo2SXbY\"",
    "mtime": "2024-08-07T20:06:17.076Z",
    "size": 52144,
    "path": "../public/images/POINTILLÉS+POINT.png"
  },
  "/images/ROND + PIN.png": {
    "type": "image/png",
    "etag": "\"25e8-m3qH+qE4w+VQsPFqY478XAk5x30\"",
    "mtime": "2024-08-07T20:06:17.076Z",
    "size": 9704,
    "path": "../public/images/ROND + PIN.png"
  },
  "/images/ROND VERT.png": {
    "type": "image/png",
    "etag": "\"2dc6-op+cPOGjNC6d0PPXoSTAIeDUdUg\"",
    "mtime": "2024-08-07T20:06:17.076Z",
    "size": 11718,
    "path": "../public/images/ROND VERT.png"
  },
  "/images/ROND VIOLET.png": {
    "type": "image/png",
    "etag": "\"229d-f5uzVUd6n9KA06ubf/IZ3kPKNjU\"",
    "mtime": "2024-08-07T20:06:17.075Z",
    "size": 8861,
    "path": "../public/images/ROND VIOLET.png"
  },
  "/images/ROND.svg": {
    "type": "image/svg+xml",
    "etag": "\"1e9-lx+7eCbIN0aRf/PSOlbcns40tqQ\"",
    "mtime": "2024-08-07T20:06:17.075Z",
    "size": 489,
    "path": "../public/images/ROND.svg"
  },
  "/images/ROUTE SOUS VIDÉO.png": {
    "type": "image/png",
    "etag": "\"5b938-qLoWOpwI0CpPTCdzi+EOzS82bjg\"",
    "mtime": "2024-08-07T20:06:17.075Z",
    "size": 375096,
    "path": "../public/images/ROUTE SOUS VIDÉO.png"
  },
  "/images/ROUTE.jpg": {
    "type": "image/jpeg",
    "etag": "\"3f859-djV5ssEgx6AGmflr9V+xFzigiyc\"",
    "mtime": "2024-08-07T20:06:17.075Z",
    "size": 260185,
    "path": "../public/images/ROUTE.jpg"
  },
  "/images/bg-pop-up.png": {
    "type": "image/png",
    "etag": "\"13983-aCHxuYfdErD5gYHRKCQvw2+k+KM\"",
    "mtime": "2024-08-07T20:06:17.074Z",
    "size": 80259,
    "path": "../public/images/bg-pop-up.png"
  },
  "/images/information.png": {
    "type": "image/png",
    "etag": "\"e19-m7/j7l+uGzM4Eg8rM2fiOPECc1w\"",
    "mtime": "2024-08-07T20:06:17.074Z",
    "size": 3609,
    "path": "../public/images/information.png"
  },
  "/images/logo-blanc.svg": {
    "type": "image/svg+xml",
    "etag": "\"40e4-t0DmoTNGLCiWfaxcSZrdGxAqDcU\"",
    "mtime": "2024-08-07T20:06:17.074Z",
    "size": 16612,
    "path": "../public/images/logo-blanc.svg"
  },
  "/images/logo-couleur.svg": {
    "type": "image/svg+xml",
    "etag": "\"11c4-PyboksBpwqY40U5BJs9Dn2MTuuY\"",
    "mtime": "2024-08-07T20:06:17.074Z",
    "size": 4548,
    "path": "../public/images/logo-couleur.svg"
  },
  "/images/nos-services-1.png": {
    "type": "image/png",
    "etag": "\"3c684-2mK16Xpb+qrdr+fieUEZXaW2GWQ\"",
    "mtime": "2024-08-07T20:06:17.074Z",
    "size": 247428,
    "path": "../public/images/nos-services-1.png"
  },
  "/images/nos-services-2.png": {
    "type": "image/png",
    "etag": "\"504df-Y9m5u/mU0uCh16dsEOYxc2EtT9k\"",
    "mtime": "2024-08-07T20:06:17.073Z",
    "size": 328927,
    "path": "../public/images/nos-services-2.png"
  },
  "/images/nos-services-3.png": {
    "type": "image/png",
    "etag": "\"2695a-qqQvQvciqD9owZIdldix4glMO5A\"",
    "mtime": "2024-08-07T20:06:17.073Z",
    "size": 158042,
    "path": "../public/images/nos-services-3.png"
  },
  "/images/road.svg": {
    "type": "image/svg+xml",
    "etag": "\"a58e9-UIhvcjoNCQVvSTPZiqVQgTQyqGc\"",
    "mtime": "2024-08-07T20:06:17.073Z",
    "size": 678121,
    "path": "../public/images/road.svg"
  },
  "/images/route_picture.png": {
    "type": "image/png",
    "etag": "\"1a0e-2lYPwOFQw6Pypk8ApiC+STSpeUQ\"",
    "mtime": "2024-08-07T20:06:17.072Z",
    "size": 6670,
    "path": "../public/images/route_picture.png"
  },
  "/images/video.png": {
    "type": "image/png",
    "etag": "\"198d-Zazw3MXD/bqGJEQjEQV3F4GYuIc\"",
    "mtime": "2024-08-07T20:06:17.072Z",
    "size": 6541,
    "path": "../public/images/video.png"
  }
};

function readAsset (id) {
  const serverDir = dirname(fileURLToPath(globalThis._importMeta_.url));
  return promises.readFile(resolve(serverDir, assets[id].path))
}

const publicAssetBases = {"/_nuxt":{"maxAge":31536000}};

function isPublicAssetURL(id = '') {
  if (assets[id]) {
    return true
  }
  for (const base in publicAssetBases) {
    if (id.startsWith(base)) { return true }
  }
  return false
}

function getAsset (id) {
  return assets[id]
}

const METHODS = /* @__PURE__ */ new Set(["HEAD", "GET"]);
const EncodingMap = { gzip: ".gz", br: ".br" };
const _f4b49z = eventHandler((event) => {
  if (event.node.req.method && !METHODS.has(event.node.req.method)) {
    return;
  }
  let id = decodeURIComponent(
    withLeadingSlash(
      withoutTrailingSlash(parseURL(event.node.req.url).pathname)
    )
  );
  let asset;
  const encodingHeader = String(
    event.node.req.headers["accept-encoding"] || ""
  );
  const encodings = [
    ...encodingHeader.split(",").map((e) => EncodingMap[e.trim()]).filter(Boolean).sort(),
    ""
  ];
  if (encodings.length > 1) {
    event.node.res.setHeader("Vary", "Accept-Encoding");
  }
  for (const encoding of encodings) {
    for (const _id of [id + encoding, joinURL(id, "index.html" + encoding)]) {
      const _asset = getAsset(_id);
      if (_asset) {
        asset = _asset;
        id = _id;
        break;
      }
    }
  }
  if (!asset) {
    if (isPublicAssetURL(id)) {
      event.node.res.removeHeader("cache-control");
      throw createError({
        statusMessage: "Cannot find static asset " + id,
        statusCode: 404
      });
    }
    return;
  }
  const ifNotMatch = event.node.req.headers["if-none-match"] === asset.etag;
  if (ifNotMatch) {
    if (!event.handled) {
      event.node.res.statusCode = 304;
      event.node.res.end();
    }
    return;
  }
  const ifModifiedSinceH = event.node.req.headers["if-modified-since"];
  const mtimeDate = new Date(asset.mtime);
  if (ifModifiedSinceH && asset.mtime && new Date(ifModifiedSinceH) >= mtimeDate) {
    if (!event.handled) {
      event.node.res.statusCode = 304;
      event.node.res.end();
    }
    return;
  }
  if (asset.type && !event.node.res.getHeader("Content-Type")) {
    event.node.res.setHeader("Content-Type", asset.type);
  }
  if (asset.etag && !event.node.res.getHeader("ETag")) {
    event.node.res.setHeader("ETag", asset.etag);
  }
  if (asset.mtime && !event.node.res.getHeader("Last-Modified")) {
    event.node.res.setHeader("Last-Modified", mtimeDate.toUTCString());
  }
  if (asset.encoding && !event.node.res.getHeader("Content-Encoding")) {
    event.node.res.setHeader("Content-Encoding", asset.encoding);
  }
  if (asset.size > 0 && !event.node.res.getHeader("Content-Length")) {
    event.node.res.setHeader("Content-Length", asset.size);
  }
  return readAsset(id);
});

const _lazy_M2GfmZ = () => import('../handlers/renderer.mjs').then(function (n) { return n.r; });

const handlers = [
  { route: '', handler: _f4b49z, lazy: false, middleware: true, method: undefined },
  { route: '/__nuxt_error', handler: _lazy_M2GfmZ, lazy: true, middleware: false, method: undefined },
  { route: '/**', handler: _lazy_M2GfmZ, lazy: true, middleware: false, method: undefined }
];

function createNitroApp() {
  const config = useRuntimeConfig();
  const hooks = createHooks();
  const h3App = createApp({
    debug: destr(false),
    onError: errorHandler
  });
  const router = createRouter$1();
  h3App.use(createRouteRulesHandler());
  const localCall = createCall(toNodeListener(h3App));
  const localFetch = createFetch(localCall, globalThis.fetch);
  const $fetch = createFetch$1({
    fetch: localFetch,
    Headers,
    defaults: { baseURL: config.app.baseURL }
  });
  globalThis.$fetch = $fetch;
  h3App.use(
    eventHandler((event) => {
      event.context.nitro = event.context.nitro || {};
      const envContext = event.node.req.__unenv__;
      if (envContext) {
        Object.assign(event.context, envContext);
      }
      event.fetch = (req, init) => fetchWithEvent(event, req, init, { fetch: localFetch });
      event.$fetch = (req, init) => fetchWithEvent(event, req, init, { fetch: $fetch });
    })
  );
  for (const h of handlers) {
    let handler = h.lazy ? lazyEventHandler(h.handler) : h.handler;
    if (h.middleware || !h.route) {
      const middlewareBase = (config.app.baseURL + (h.route || "/")).replace(
        /\/+/g,
        "/"
      );
      h3App.use(middlewareBase, handler);
    } else {
      const routeRules = getRouteRulesForPath(
        h.route.replace(/:\w+|\*\*/g, "_")
      );
      if (routeRules.cache) {
        handler = cachedEventHandler(handler, {
          group: "nitro/routes",
          ...routeRules.cache
        });
      }
      router.use(h.route, handler, h.method);
    }
  }
  h3App.use(config.app.baseURL, router.handler);
  const app = {
    hooks,
    h3App,
    router,
    localCall,
    localFetch
  };
  for (const plugin of plugins) {
    plugin(app);
  }
  return app;
}
const nitroApp = createNitroApp();
const useNitroApp = () => nitroApp;

function getGracefulShutdownConfig() {
  return {
    disabled: !!process.env.NITRO_SHUTDOWN_DISABLED,
    signals: (process.env.NITRO_SHUTDOWN_SIGNALS || "SIGTERM SIGINT").split(" ").map((s) => s.trim()),
    timeout: Number.parseInt(process.env.NITRO_SHUTDOWN_TIMEOUT, 10) || 3e4,
    forceExit: !process.env.NITRO_SHUTDOWN_NO_FORCE_EXIT
  };
}
function setupGracefulShutdown(listener, nitroApp) {
  const shutdownConfig = getGracefulShutdownConfig();
  if (shutdownConfig.disabled) {
    return;
  }
  gracefulShutdown(listener, {
    signals: shutdownConfig.signals.join(" "),
    timeout: shutdownConfig.timeout,
    forceExit: shutdownConfig.forceExit,
    onShutdown: async () => {
      await new Promise((resolve) => {
        const timeout = setTimeout(() => {
          console.warn("Graceful shutdown timeout, force exiting...");
          resolve();
        }, shutdownConfig.timeout);
        nitroApp.hooks.callHook("close").catch((err) => {
          console.error(err);
        }).finally(() => {
          clearTimeout(timeout);
          resolve();
        });
      });
    }
  });
}

const cert = process.env.NITRO_SSL_CERT;
const key = process.env.NITRO_SSL_KEY;
const server = cert && key ? new Server({ key, cert }, toNodeListener(nitroApp.h3App)) : new Server$1(toNodeListener(nitroApp.h3App));
const port = destr(process.env.NITRO_PORT || process.env.PORT) || 3e3;
const host = process.env.NITRO_HOST || process.env.HOST;
const listener = server.listen(port, host, (err) => {
  if (err) {
    console.error(err);
    process.exit(1);
  }
  const protocol = cert && key ? "https" : "http";
  const addressInfo = listener.address();
  const baseURL = (useRuntimeConfig().app.baseURL || "").replace(/\/$/, "");
  const url = `${protocol}://${addressInfo.family === "IPv6" ? `[${addressInfo.address}]` : addressInfo.address}:${addressInfo.port}${baseURL}`;
  console.log(`Listening ${url}`);
});
trapUnhandledNodeErrors();
setupGracefulShutdown(listener, nitroApp);
const nodeServer = {};

export { useRuntimeConfig as a, getRouteRules as g, nodeServer as n, useNitroApp as u };
//# sourceMappingURL=node-server.mjs.map
