import * as vue$1 from 'vue';
import { hasInjectionContext, getCurrentInstance, version, mergeProps, computed, inject, useSSRContext, ref, watchEffect, watch, openBlock, createElementBlock, resolveComponent, resolveDirective, withDirectives, renderSlot, normalizeClass, createBlock, createCommentVNode, createElementVNode, toDisplayString, Teleport, withCtx, resolveDynamicComponent, createVNode, Transition, Fragment, renderList, vShow, createTextVNode, normalizeProps, guardReactiveProps, withKeys, createApp, reactive, effectScope, isRef, isReactive, toRaw, unref, getCurrentScope, onScopeDispose, nextTick, createStaticVNode, defineComponent, h, Suspense, provide, onErrorCaptured, onServerPrefetch, toRef, shallowRef, isReadonly, toRefs, markRaw, defineAsyncComponent, isShallow, createSlots, toHandlers, withModifiers } from 'vue';
import { $fetch } from 'ofetch';
import { createHooks } from 'hookable';
import { getContext, executeAsync } from 'unctx';
import { useRoute as useRoute$1, RouterView, createMemoryHistory, createRouter, START_LOCATION } from 'vue-router';
import { createError as createError$1, sanitizeStatusCode } from 'h3';
import { withQuery, hasProtocol, parseURL, joinURL } from 'ufo';
import { renderSSRHead } from '@unhead/ssr';
import { getActiveHead, createServerHead as createServerHead$1 } from 'unhead';
import { defineHeadPlugin } from '@unhead/shared';
import dayjs from 'dayjs';
import relativeTime from 'dayjs/plugin/relativeTime.js';
import utc from 'dayjs/plugin/utc.js';
import timezone from 'dayjs/plugin/timezone.js';
import { Popover, PopoverButton, PopoverPanel } from '@headlessui/vue';
import { createI18n } from 'vue-i18n';
import { ssrRenderComponent, ssrRenderSuspense, ssrRenderVNode, ssrRenderAttrs } from 'vue/server-renderer';
import { defu } from 'defu';
import { a as useRuntimeConfig$1 } from '../nitro/node-server.mjs';
import 'node-fetch-native/polyfill';
import 'node:http';
import 'node:https';
import 'destr';
import 'unenv/runtime/fetch/index';
import 'scule';
import 'klona';
import 'ohash';
import 'unstorage';
import 'radix3';
import 'node:fs';
import 'node:url';
import 'pathe';
import 'http-graceful-shutdown';

function getDefaultExportFromCjs (x) {
	return x && x.__esModule && Object.prototype.hasOwnProperty.call(x, 'default') ? x['default'] : x;
}

function getDefaultExportFromNamespaceIfNotNamed (n) {
	return n && Object.prototype.hasOwnProperty.call(n, 'default') && Object.keys(n).length === 1 ? n['default'] : n;
}

const require$$0 = /*@__PURE__*/getDefaultExportFromNamespaceIfNotNamed(vue$1);

var vue=require$$0;function ownKeys(object, enumerableOnly) {
  var keys = Object.keys(object);

  if (Object.getOwnPropertySymbols) {
    var symbols = Object.getOwnPropertySymbols(object);

    if (enumerableOnly) {
      symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });
    }

    keys.push.apply(keys, symbols);
  }

  return keys;
}

function _objectSpread2(target) {
  for (var i = 1; i < arguments.length; i++) {
    var source = arguments[i] != null ? arguments[i] : {};

    if (i % 2) {
      ownKeys(Object(source), true).forEach(function (key) {
        _defineProperty(target, key, source[key]);
      });
    } else if (Object.getOwnPropertyDescriptors) {
      Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
    } else {
      ownKeys(Object(source)).forEach(function (key) {
        Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
      });
    }
  }

  return target;
}

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) {
  try {
    var info = gen[key](arg);
    var value = info.value;
  } catch (error) {
    reject(error);
    return;
  }

  if (info.done) {
    resolve(value);
  } else {
    Promise.resolve(value).then(_next, _throw);
  }
}

function _asyncToGenerator(fn) {
  return function () {
    var self = this,
        args = arguments;
    return new Promise(function (resolve, reject) {
      var gen = fn.apply(self, args);

      function _next(value) {
        asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value);
      }

      function _throw(err) {
        asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err);
      }

      _next(undefined);
    });
  };
}

function _defineProperty(obj, key, value) {
  if (key in obj) {
    Object.defineProperty(obj, key, {
      value: value,
      enumerable: true,
      configurable: true,
      writable: true
    });
  } else {
    obj[key] = value;
  }

  return obj;
}

function _slicedToArray(arr, i) {
  return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest();
}

function _toConsumableArray(arr) {
  return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread();
}

function _arrayWithoutHoles(arr) {
  if (Array.isArray(arr)) return _arrayLikeToArray(arr);
}

function _arrayWithHoles(arr) {
  if (Array.isArray(arr)) return arr;
}

function _iterableToArray(iter) {
  if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter);
}

function _iterableToArrayLimit(arr, i) {
  var _i = arr == null ? null : typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"];

  if (_i == null) return;
  var _arr = [];
  var _n = true;
  var _d = false;

  var _s, _e;

  try {
    for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) {
      _arr.push(_s.value);

      if (i && _arr.length === i) break;
    }
  } catch (err) {
    _d = true;
    _e = err;
  } finally {
    try {
      if (!_n && _i["return"] != null) _i["return"]();
    } finally {
      if (_d) throw _e;
    }
  }

  return _arr;
}

function _unsupportedIterableToArray(o, minLen) {
  if (!o) return;
  if (typeof o === "string") return _arrayLikeToArray(o, minLen);
  var n = Object.prototype.toString.call(o).slice(8, -1);
  if (n === "Object" && o.constructor) n = o.constructor.name;
  if (n === "Map" || n === "Set") return Array.from(o);
  if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen);
}

function _arrayLikeToArray(arr, len) {
  if (len == null || len > arr.length) len = arr.length;

  for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i];

  return arr2;
}

function _nonIterableSpread() {
  throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
}

function _nonIterableRest() {
  throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
}/**
 * Returns a function, that, as long as it continues to be invoked, will not
 * be triggered. The function will be called after it stops being called for
 * N milliseconds. If `immediate` is passed, trigger the function on the
 * leading edge, instead of the trailing. The function also has a property 'clear' 
 * that is a function which will clear the timer to prevent previously scheduled executions. 
 *
 * @source underscore.js
 * @see http://unscriptable.com/2009/03/20/debouncing-javascript-methods/
 * @param {Function} function to wrap
 * @param {Number} timeout in ms (`100`)
 * @param {Boolean} whether to execute at the beginning (`false`)
 * @api public
 */
function debounce$1(func, wait, immediate){
  var timeout, args, context, timestamp, result;
  if (null == wait) wait = 100;

  function later() {
    var last = Date.now() - timestamp;

    if (last < wait && last >= 0) {
      timeout = setTimeout(later, wait - last);
    } else {
      timeout = null;
      if (!immediate) {
        result = func.apply(context, args);
        context = args = null;
      }
    }
  }
  var debounced = function(){
    context = this;
    args = arguments;
    timestamp = Date.now();
    var callNow = immediate && !timeout;
    if (!timeout) timeout = setTimeout(later, wait);
    if (callNow) {
      result = func.apply(context, args);
      context = args = null;
    }

    return result;
  };

  debounced.clear = function() {
    if (timeout) {
      clearTimeout(timeout);
      timeout = null;
    }
  };
  
  debounced.flush = function() {
    if (timeout) {
      result = func.apply(context, args);
      context = args = null;
      
      clearTimeout(timeout);
      timeout = null;
    }
  };

  return debounced;
}
// Adds compatibility for ES modules
debounce$1.debounce = debounce$1;

var debounce_1 = debounce$1;function useContent(slots, popperNode, content) {
  var observer = null;
  var hasContent = vue.ref(false);
  vue.onMounted(function () {
    if (slots.content !== undefined || content.value) {
      hasContent.value = true;
    }

    observer = new MutationObserver(checkContent);
    observer.observe(popperNode.value, {
      childList: true,
      subtree: true
    });
  });
  vue.onBeforeUnmount(function () {
    return observer.disconnect();
  });
  /**
   * Watch the content prop
   */

  vue.watch(content, function (content) {
    if (content) {
      hasContent.value = true;
    } else {
      hasContent.value = false;
    }
  });
  /**
   * Check the content slot
   */

  var checkContent = function checkContent() {
    if (slots.content) {
      hasContent.value = true;
    } else {
      hasContent.value = false;
    }
  };

  return {
    hasContent: hasContent
  };
}// import { isHTMLElement } from './instanceOf';
function getBoundingClientRect(element, // eslint-disable-next-line unused-imports/no-unused-vars
includeScale) {

  var rect = element.getBoundingClientRect();
  var scaleX = 1;
  var scaleY = 1; // FIXME:
  // `offsetWidth` returns an integer while `getBoundingClientRect`
  // returns a float. This results in `scaleX` or `scaleY` being
  // non-1 when it should be for elements that aren't a full pixel in
  // width or height.
  // if (isHTMLElement(element) && includeScale) {
  //   const offsetHeight = element.offsetHeight;
  //   const offsetWidth = element.offsetWidth;
  //   // Do not attempt to divide by 0, otherwise we get `Infinity` as scale
  //   // Fallback to 1 in case both values are `0`
  //   if (offsetWidth > 0) {
  //     scaleX = rect.width / offsetWidth || 1;
  //   }
  //   if (offsetHeight > 0) {
  //     scaleY = rect.height / offsetHeight || 1;
  //   }
  // }

  return {
    width: rect.width / scaleX,
    height: rect.height / scaleY,
    top: rect.top / scaleY,
    right: rect.right / scaleX,
    bottom: rect.bottom / scaleY,
    left: rect.left / scaleX,
    x: rect.left / scaleX,
    y: rect.top / scaleY
  };
}function getWindow(node) {
  if (node == null) {
    return window;
  }

  if (node.toString() !== '[object Window]') {
    var ownerDocument = node.ownerDocument;
    return ownerDocument ? ownerDocument.defaultView || window : window;
  }

  return node;
}function getWindowScroll(node) {
  var win = getWindow(node);
  var scrollLeft = win.pageXOffset;
  var scrollTop = win.pageYOffset;
  return {
    scrollLeft: scrollLeft,
    scrollTop: scrollTop
  };
}function isElement(node) {
  var OwnElement = getWindow(node).Element;
  return node instanceof OwnElement || node instanceof Element;
}

function isHTMLElement(node) {
  var OwnElement = getWindow(node).HTMLElement;
  return node instanceof OwnElement || node instanceof HTMLElement;
}

function isShadowRoot(node) {
  // IE 11 has no ShadowRoot
  if (typeof ShadowRoot === 'undefined') {
    return false;
  }

  var OwnElement = getWindow(node).ShadowRoot;
  return node instanceof OwnElement || node instanceof ShadowRoot;
}function getHTMLElementScroll(element) {
  return {
    scrollLeft: element.scrollLeft,
    scrollTop: element.scrollTop
  };
}function getNodeScroll(node) {
  if (node === getWindow(node) || !isHTMLElement(node)) {
    return getWindowScroll(node);
  } else {
    return getHTMLElementScroll(node);
  }
}function getNodeName(element) {
  return element ? (element.nodeName || '').toLowerCase() : null;
}function getDocumentElement(element) {
  // $FlowFixMe[incompatible-return]: assume body is always available
  return ((isElement(element) ? element.ownerDocument : // $FlowFixMe[prop-missing]
  element.document) || window.document).documentElement;
}function getWindowScrollBarX(element) {
  // If <html> has a CSS width greater than the viewport, then this will be
  // incorrect for RTL.
  // Popper 1 is broken in this case and never had a bug report so let's assume
  // it's not an issue. I don't think anyone ever specifies width on <html>
  // anyway.
  // Browsers where the left scrollbar doesn't cause an issue report `0` for
  // this (e.g. Edge 2019, IE11, Safari)
  return getBoundingClientRect(getDocumentElement(element)).left + getWindowScroll(element).scrollLeft;
}function getComputedStyle$1(element) {
  return getWindow(element).getComputedStyle(element);
}function isScrollParent(element) {
  // Firefox wants us to check `-x` and `-y` variations as well
  var _getComputedStyle = getComputedStyle$1(element),
      overflow = _getComputedStyle.overflow,
      overflowX = _getComputedStyle.overflowX,
      overflowY = _getComputedStyle.overflowY;

  return /auto|scroll|overlay|hidden/.test(overflow + overflowY + overflowX);
}function isElementScaled(element) {
  var rect = element.getBoundingClientRect();
  var scaleX = rect.width / element.offsetWidth || 1;
  var scaleY = rect.height / element.offsetHeight || 1;
  return scaleX !== 1 || scaleY !== 1;
} // Returns the composite rect of an element relative to its offsetParent.
// Composite means it takes into account transforms as well as layout.


function getCompositeRect(elementOrVirtualElement, offsetParent, isFixed) {
  if (isFixed === void 0) {
    isFixed = false;
  }

  var isOffsetParentAnElement = isHTMLElement(offsetParent);
  isHTMLElement(offsetParent) && isElementScaled(offsetParent);
  var documentElement = getDocumentElement(offsetParent);
  var rect = getBoundingClientRect(elementOrVirtualElement);
  var scroll = {
    scrollLeft: 0,
    scrollTop: 0
  };
  var offsets = {
    x: 0,
    y: 0
  };

  if (isOffsetParentAnElement || !isOffsetParentAnElement && !isFixed) {
    if (getNodeName(offsetParent) !== 'body' || // https://github.com/popperjs/popper-core/issues/1078
    isScrollParent(documentElement)) {
      scroll = getNodeScroll(offsetParent);
    }

    if (isHTMLElement(offsetParent)) {
      offsets = getBoundingClientRect(offsetParent);
      offsets.x += offsetParent.clientLeft;
      offsets.y += offsetParent.clientTop;
    } else if (documentElement) {
      offsets.x = getWindowScrollBarX(documentElement);
    }
  }

  return {
    x: rect.left + scroll.scrollLeft - offsets.x,
    y: rect.top + scroll.scrollTop - offsets.y,
    width: rect.width,
    height: rect.height
  };
}// means it doesn't take into account transforms.

function getLayoutRect(element) {
  var clientRect = getBoundingClientRect(element); // Use the clientRect sizes if it's not been transformed.
  // Fixes https://github.com/popperjs/popper-core/issues/1223

  var width = element.offsetWidth;
  var height = element.offsetHeight;

  if (Math.abs(clientRect.width - width) <= 1) {
    width = clientRect.width;
  }

  if (Math.abs(clientRect.height - height) <= 1) {
    height = clientRect.height;
  }

  return {
    x: element.offsetLeft,
    y: element.offsetTop,
    width: width,
    height: height
  };
}function getParentNode(element) {
  if (getNodeName(element) === 'html') {
    return element;
  }

  return (// this is a quicker (but less type safe) way to save quite some bytes from the bundle
    // $FlowFixMe[incompatible-return]
    // $FlowFixMe[prop-missing]
    element.assignedSlot || // step into the shadow DOM of the parent of a slotted node
    element.parentNode || ( // DOM Element detected
    isShadowRoot(element) ? element.host : null) || // ShadowRoot detected
    // $FlowFixMe[incompatible-call]: HTMLElement is a Node
    getDocumentElement(element) // fallback

  );
}function getScrollParent(node) {
  if (['html', 'body', '#document'].indexOf(getNodeName(node)) >= 0) {
    // $FlowFixMe[incompatible-return]: assume body is always available
    return node.ownerDocument.body;
  }

  if (isHTMLElement(node) && isScrollParent(node)) {
    return node;
  }

  return getScrollParent(getParentNode(node));
}/*
given a DOM element, return the list of all scroll parents, up the list of ancesors
until we get to the top window object. This list is what we attach scroll listeners
to, because if any of these parent elements scroll, we'll need to re-calculate the
reference element's position.
*/

function listScrollParents(element, list) {
  var _element$ownerDocumen;

  if (list === void 0) {
    list = [];
  }

  var scrollParent = getScrollParent(element);
  var isBody = scrollParent === ((_element$ownerDocumen = element.ownerDocument) == null ? void 0 : _element$ownerDocumen.body);
  var win = getWindow(scrollParent);
  var target = isBody ? [win].concat(win.visualViewport || [], isScrollParent(scrollParent) ? scrollParent : []) : scrollParent;
  var updatedList = list.concat(target);
  return isBody ? updatedList : // $FlowFixMe[incompatible-call]: isBody tells us target will be an HTMLElement here
  updatedList.concat(listScrollParents(getParentNode(target)));
}function isTableElement(element) {
  return ['table', 'td', 'th'].indexOf(getNodeName(element)) >= 0;
}function getTrueOffsetParent(element) {
  if (!isHTMLElement(element) || // https://github.com/popperjs/popper-core/issues/837
  getComputedStyle$1(element).position === 'fixed') {
    return null;
  }

  return element.offsetParent;
} // `.offsetParent` reports `null` for fixed elements, while absolute elements
// return the containing block


function getContainingBlock(element) {
  var isFirefox = navigator.userAgent.toLowerCase().indexOf('firefox') !== -1;
  var isIE = navigator.userAgent.indexOf('Trident') !== -1;

  if (isIE && isHTMLElement(element)) {
    // In IE 9, 10 and 11 fixed elements containing block is always established by the viewport
    var elementCss = getComputedStyle$1(element);

    if (elementCss.position === 'fixed') {
      return null;
    }
  }

  var currentNode = getParentNode(element);

  while (isHTMLElement(currentNode) && ['html', 'body'].indexOf(getNodeName(currentNode)) < 0) {
    var css = getComputedStyle$1(currentNode); // This is non-exhaustive but covers the most common CSS properties that
    // create a containing block.
    // https://developer.mozilla.org/en-US/docs/Web/CSS/Containing_block#identifying_the_containing_block

    if (css.transform !== 'none' || css.perspective !== 'none' || css.contain === 'paint' || ['transform', 'perspective'].indexOf(css.willChange) !== -1 || isFirefox && css.willChange === 'filter' || isFirefox && css.filter && css.filter !== 'none') {
      return currentNode;
    } else {
      currentNode = currentNode.parentNode;
    }
  }

  return null;
} // Gets the closest ancestor positioned element. Handles some edge cases,
// such as table ancestors and cross browser bugs.


function getOffsetParent(element) {
  var window = getWindow(element);
  var offsetParent = getTrueOffsetParent(element);

  while (offsetParent && isTableElement(offsetParent) && getComputedStyle$1(offsetParent).position === 'static') {
    offsetParent = getTrueOffsetParent(offsetParent);
  }

  if (offsetParent && (getNodeName(offsetParent) === 'html' || getNodeName(offsetParent) === 'body' && getComputedStyle$1(offsetParent).position === 'static')) {
    return window;
  }

  return offsetParent || getContainingBlock(element) || window;
}var top = 'top';
var bottom = 'bottom';
var right = 'right';
var left = 'left';
var auto = 'auto';
var basePlacements = [top, bottom, right, left];
var start = 'start';
var end = 'end';
var clippingParents = 'clippingParents';
var viewport = 'viewport';
var popper = 'popper';
var reference = 'reference';
var variationPlacements = /*#__PURE__*/basePlacements.reduce(function (acc, placement) {
  return acc.concat([placement + "-" + start, placement + "-" + end]);
}, []);
var placements = /*#__PURE__*/[].concat(basePlacements, [auto]).reduce(function (acc, placement) {
  return acc.concat([placement, placement + "-" + start, placement + "-" + end]);
}, []); // modifiers that need to read the DOM

var beforeRead = 'beforeRead';
var read = 'read';
var afterRead = 'afterRead'; // pure-logic modifiers

var beforeMain = 'beforeMain';
var main = 'main';
var afterMain = 'afterMain'; // modifier with the purpose to write to the DOM (or write into a framework state)

var beforeWrite = 'beforeWrite';
var write = 'write';
var afterWrite = 'afterWrite';
var modifierPhases = [beforeRead, read, afterRead, beforeMain, main, afterMain, beforeWrite, write, afterWrite];function order(modifiers) {
  var map = new Map();
  var visited = new Set();
  var result = [];
  modifiers.forEach(function (modifier) {
    map.set(modifier.name, modifier);
  }); // On visiting object, check for its dependencies and visit them recursively

  function sort(modifier) {
    visited.add(modifier.name);
    var requires = [].concat(modifier.requires || [], modifier.requiresIfExists || []);
    requires.forEach(function (dep) {
      if (!visited.has(dep)) {
        var depModifier = map.get(dep);

        if (depModifier) {
          sort(depModifier);
        }
      }
    });
    result.push(modifier);
  }

  modifiers.forEach(function (modifier) {
    if (!visited.has(modifier.name)) {
      // check for visited object
      sort(modifier);
    }
  });
  return result;
}

function orderModifiers(modifiers) {
  // order based on dependencies
  var orderedModifiers = order(modifiers); // order based on phase

  return modifierPhases.reduce(function (acc, phase) {
    return acc.concat(orderedModifiers.filter(function (modifier) {
      return modifier.phase === phase;
    }));
  }, []);
}function debounce(fn) {
  var pending;
  return function () {
    if (!pending) {
      pending = new Promise(function (resolve) {
        Promise.resolve().then(function () {
          pending = undefined;
          resolve(fn());
        });
      });
    }

    return pending;
  };
}function getBasePlacement(placement) {
  return placement.split('-')[0];
}function mergeByName(modifiers) {
  var merged = modifiers.reduce(function (merged, current) {
    var existing = merged[current.name];
    merged[current.name] = existing ? Object.assign({}, existing, current, {
      options: Object.assign({}, existing.options, current.options),
      data: Object.assign({}, existing.data, current.data)
    }) : current;
    return merged;
  }, {}); // IE11 does not support Object.values

  return Object.keys(merged).map(function (key) {
    return merged[key];
  });
}function getViewportRect(element) {
  var win = getWindow(element);
  var html = getDocumentElement(element);
  var visualViewport = win.visualViewport;
  var width = html.clientWidth;
  var height = html.clientHeight;
  var x = 0;
  var y = 0; // NB: This isn't supported on iOS <= 12. If the keyboard is open, the popper
  // can be obscured underneath it.
  // Also, `html.clientHeight` adds the bottom bar height in Safari iOS, even
  // if it isn't open, so if this isn't available, the popper will be detected
  // to overflow the bottom of the screen too early.

  if (visualViewport) {
    width = visualViewport.width;
    height = visualViewport.height; // Uses Layout Viewport (like Chrome; Safari does not currently)
    // In Chrome, it returns a value very close to 0 (+/-) but contains rounding
    // errors due to floating point numbers, so we need to check precision.
    // Safari returns a number <= 0, usually < -1 when pinch-zoomed
    // Feature detection fails in mobile emulation mode in Chrome.
    // Math.abs(win.innerWidth / visualViewport.scale - visualViewport.width) <
    // 0.001
    // Fallback here: "Not Safari" userAgent

    if (!/^((?!chrome|android).)*safari/i.test(navigator.userAgent)) {
      x = visualViewport.offsetLeft;
      y = visualViewport.offsetTop;
    }
  }

  return {
    width: width,
    height: height,
    x: x + getWindowScrollBarX(element),
    y: y
  };
}var max = Math.max;
var min = Math.min;
var round = Math.round;// of the `<html>` and `<body>` rect bounds if horizontally scrollable

function getDocumentRect(element) {
  var _element$ownerDocumen;

  var html = getDocumentElement(element);
  var winScroll = getWindowScroll(element);
  var body = (_element$ownerDocumen = element.ownerDocument) == null ? void 0 : _element$ownerDocumen.body;
  var width = max(html.scrollWidth, html.clientWidth, body ? body.scrollWidth : 0, body ? body.clientWidth : 0);
  var height = max(html.scrollHeight, html.clientHeight, body ? body.scrollHeight : 0, body ? body.clientHeight : 0);
  var x = -winScroll.scrollLeft + getWindowScrollBarX(element);
  var y = -winScroll.scrollTop;

  if (getComputedStyle$1(body || html).direction === 'rtl') {
    x += max(html.clientWidth, body ? body.clientWidth : 0) - width;
  }

  return {
    width: width,
    height: height,
    x: x,
    y: y
  };
}function contains(parent, child) {
  var rootNode = child.getRootNode && child.getRootNode(); // First, attempt with faster native method

  if (parent.contains(child)) {
    return true;
  } // then fallback to custom implementation with Shadow DOM support
  else if (rootNode && isShadowRoot(rootNode)) {
      var next = child;

      do {
        if (next && parent.isSameNode(next)) {
          return true;
        } // $FlowFixMe[prop-missing]: need a better way to handle this...


        next = next.parentNode || next.host;
      } while (next);
    } // Give up, the result is false


  return false;
}function rectToClientRect(rect) {
  return Object.assign({}, rect, {
    left: rect.x,
    top: rect.y,
    right: rect.x + rect.width,
    bottom: rect.y + rect.height
  });
}function getInnerBoundingClientRect(element) {
  var rect = getBoundingClientRect(element);
  rect.top = rect.top + element.clientTop;
  rect.left = rect.left + element.clientLeft;
  rect.bottom = rect.top + element.clientHeight;
  rect.right = rect.left + element.clientWidth;
  rect.width = element.clientWidth;
  rect.height = element.clientHeight;
  rect.x = rect.left;
  rect.y = rect.top;
  return rect;
}

function getClientRectFromMixedType(element, clippingParent) {
  return clippingParent === viewport ? rectToClientRect(getViewportRect(element)) : isHTMLElement(clippingParent) ? getInnerBoundingClientRect(clippingParent) : rectToClientRect(getDocumentRect(getDocumentElement(element)));
} // A "clipping parent" is an overflowable container with the characteristic of
// clipping (or hiding) overflowing elements with a position different from
// `initial`


function getClippingParents(element) {
  var clippingParents = listScrollParents(getParentNode(element));
  var canEscapeClipping = ['absolute', 'fixed'].indexOf(getComputedStyle$1(element).position) >= 0;
  var clipperElement = canEscapeClipping && isHTMLElement(element) ? getOffsetParent(element) : element;

  if (!isElement(clipperElement)) {
    return [];
  } // $FlowFixMe[incompatible-return]: https://github.com/facebook/flow/issues/1414


  return clippingParents.filter(function (clippingParent) {
    return isElement(clippingParent) && contains(clippingParent, clipperElement) && getNodeName(clippingParent) !== 'body';
  });
} // Gets the maximum area that the element is visible in due to any number of
// clipping parents


function getClippingRect(element, boundary, rootBoundary) {
  var mainClippingParents = boundary === 'clippingParents' ? getClippingParents(element) : [].concat(boundary);
  var clippingParents = [].concat(mainClippingParents, [rootBoundary]);
  var firstClippingParent = clippingParents[0];
  var clippingRect = clippingParents.reduce(function (accRect, clippingParent) {
    var rect = getClientRectFromMixedType(element, clippingParent);
    accRect.top = max(rect.top, accRect.top);
    accRect.right = min(rect.right, accRect.right);
    accRect.bottom = min(rect.bottom, accRect.bottom);
    accRect.left = max(rect.left, accRect.left);
    return accRect;
  }, getClientRectFromMixedType(element, firstClippingParent));
  clippingRect.width = clippingRect.right - clippingRect.left;
  clippingRect.height = clippingRect.bottom - clippingRect.top;
  clippingRect.x = clippingRect.left;
  clippingRect.y = clippingRect.top;
  return clippingRect;
}function getVariation(placement) {
  return placement.split('-')[1];
}function getMainAxisFromPlacement(placement) {
  return ['top', 'bottom'].indexOf(placement) >= 0 ? 'x' : 'y';
}function computeOffsets(_ref) {
  var reference = _ref.reference,
      element = _ref.element,
      placement = _ref.placement;
  var basePlacement = placement ? getBasePlacement(placement) : null;
  var variation = placement ? getVariation(placement) : null;
  var commonX = reference.x + reference.width / 2 - element.width / 2;
  var commonY = reference.y + reference.height / 2 - element.height / 2;
  var offsets;

  switch (basePlacement) {
    case top:
      offsets = {
        x: commonX,
        y: reference.y - element.height
      };
      break;

    case bottom:
      offsets = {
        x: commonX,
        y: reference.y + reference.height
      };
      break;

    case right:
      offsets = {
        x: reference.x + reference.width,
        y: commonY
      };
      break;

    case left:
      offsets = {
        x: reference.x - element.width,
        y: commonY
      };
      break;

    default:
      offsets = {
        x: reference.x,
        y: reference.y
      };
  }

  var mainAxis = basePlacement ? getMainAxisFromPlacement(basePlacement) : null;

  if (mainAxis != null) {
    var len = mainAxis === 'y' ? 'height' : 'width';

    switch (variation) {
      case start:
        offsets[mainAxis] = offsets[mainAxis] - (reference[len] / 2 - element[len] / 2);
        break;

      case end:
        offsets[mainAxis] = offsets[mainAxis] + (reference[len] / 2 - element[len] / 2);
        break;
    }
  }

  return offsets;
}function getFreshSideObject() {
  return {
    top: 0,
    right: 0,
    bottom: 0,
    left: 0
  };
}function mergePaddingObject(paddingObject) {
  return Object.assign({}, getFreshSideObject(), paddingObject);
}function expandToHashMap(value, keys) {
  return keys.reduce(function (hashMap, key) {
    hashMap[key] = value;
    return hashMap;
  }, {});
}function detectOverflow(state, options) {
  if (options === void 0) {
    options = {};
  }

  var _options = options,
      _options$placement = _options.placement,
      placement = _options$placement === void 0 ? state.placement : _options$placement,
      _options$boundary = _options.boundary,
      boundary = _options$boundary === void 0 ? clippingParents : _options$boundary,
      _options$rootBoundary = _options.rootBoundary,
      rootBoundary = _options$rootBoundary === void 0 ? viewport : _options$rootBoundary,
      _options$elementConte = _options.elementContext,
      elementContext = _options$elementConte === void 0 ? popper : _options$elementConte,
      _options$altBoundary = _options.altBoundary,
      altBoundary = _options$altBoundary === void 0 ? false : _options$altBoundary,
      _options$padding = _options.padding,
      padding = _options$padding === void 0 ? 0 : _options$padding;
  var paddingObject = mergePaddingObject(typeof padding !== 'number' ? padding : expandToHashMap(padding, basePlacements));
  var altContext = elementContext === popper ? reference : popper;
  var popperRect = state.rects.popper;
  var element = state.elements[altBoundary ? altContext : elementContext];
  var clippingClientRect = getClippingRect(isElement(element) ? element : element.contextElement || getDocumentElement(state.elements.popper), boundary, rootBoundary);
  var referenceClientRect = getBoundingClientRect(state.elements.reference);
  var popperOffsets = computeOffsets({
    reference: referenceClientRect,
    element: popperRect,
    strategy: 'absolute',
    placement: placement
  });
  var popperClientRect = rectToClientRect(Object.assign({}, popperRect, popperOffsets));
  var elementClientRect = elementContext === popper ? popperClientRect : referenceClientRect; // positive = overflowing the clipping rect
  // 0 or negative = within the clipping rect

  var overflowOffsets = {
    top: clippingClientRect.top - elementClientRect.top + paddingObject.top,
    bottom: elementClientRect.bottom - clippingClientRect.bottom + paddingObject.bottom,
    left: clippingClientRect.left - elementClientRect.left + paddingObject.left,
    right: elementClientRect.right - clippingClientRect.right + paddingObject.right
  };
  var offsetData = state.modifiersData.offset; // Offsets can be applied only to the popper element

  if (elementContext === popper && offsetData) {
    var offset = offsetData[placement];
    Object.keys(overflowOffsets).forEach(function (key) {
      var multiply = [right, bottom].indexOf(key) >= 0 ? 1 : -1;
      var axis = [top, bottom].indexOf(key) >= 0 ? 'y' : 'x';
      overflowOffsets[key] += offset[axis] * multiply;
    });
  }

  return overflowOffsets;
}var DEFAULT_OPTIONS = {
  placement: 'bottom',
  modifiers: [],
  strategy: 'absolute'
};

function areValidElements() {
  for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
    args[_key] = arguments[_key];
  }

  return !args.some(function (element) {
    return !(element && typeof element.getBoundingClientRect === 'function');
  });
}

function popperGenerator(generatorOptions) {
  if (generatorOptions === void 0) {
    generatorOptions = {};
  }

  var _generatorOptions = generatorOptions,
      _generatorOptions$def = _generatorOptions.defaultModifiers,
      defaultModifiers = _generatorOptions$def === void 0 ? [] : _generatorOptions$def,
      _generatorOptions$def2 = _generatorOptions.defaultOptions,
      defaultOptions = _generatorOptions$def2 === void 0 ? DEFAULT_OPTIONS : _generatorOptions$def2;
  return function createPopper(reference, popper, options) {
    if (options === void 0) {
      options = defaultOptions;
    }

    var state = {
      placement: 'bottom',
      orderedModifiers: [],
      options: Object.assign({}, DEFAULT_OPTIONS, defaultOptions),
      modifiersData: {},
      elements: {
        reference: reference,
        popper: popper
      },
      attributes: {},
      styles: {}
    };
    var effectCleanupFns = [];
    var isDestroyed = false;
    var instance = {
      state: state,
      setOptions: function setOptions(setOptionsAction) {
        var options = typeof setOptionsAction === 'function' ? setOptionsAction(state.options) : setOptionsAction;
        cleanupModifierEffects();
        state.options = Object.assign({}, defaultOptions, state.options, options);
        state.scrollParents = {
          reference: isElement(reference) ? listScrollParents(reference) : reference.contextElement ? listScrollParents(reference.contextElement) : [],
          popper: listScrollParents(popper)
        }; // Orders the modifiers based on their dependencies and `phase`
        // properties

        var orderedModifiers = orderModifiers(mergeByName([].concat(defaultModifiers, state.options.modifiers))); // Strip out disabled modifiers

        state.orderedModifiers = orderedModifiers.filter(function (m) {
          return m.enabled;
        }); // Validate the provided modifiers so that the consumer will get warned

        runModifierEffects();
        return instance.update();
      },
      // Sync update – it will always be executed, even if not necessary. This
      // is useful for low frequency updates where sync behavior simplifies the
      // logic.
      // For high frequency updates (e.g. `resize` and `scroll` events), always
      // prefer the async Popper#update method
      forceUpdate: function forceUpdate() {
        if (isDestroyed) {
          return;
        }

        var _state$elements = state.elements,
            reference = _state$elements.reference,
            popper = _state$elements.popper; // Don't proceed if `reference` or `popper` are not valid elements
        // anymore

        if (!areValidElements(reference, popper)) {

          return;
        } // Store the reference and popper rects to be read by modifiers


        state.rects = {
          reference: getCompositeRect(reference, getOffsetParent(popper), state.options.strategy === 'fixed'),
          popper: getLayoutRect(popper)
        }; // Modifiers have the ability to reset the current update cycle. The
        // most common use case for this is the `flip` modifier changing the
        // placement, which then needs to re-run all the modifiers, because the
        // logic was previously ran for the previous placement and is therefore
        // stale/incorrect

        state.reset = false;
        state.placement = state.options.placement; // On each update cycle, the `modifiersData` property for each modifier
        // is filled with the initial data specified by the modifier. This means
        // it doesn't persist and is fresh on each update.
        // To ensure persistent data, use `${name}#persistent`

        state.orderedModifiers.forEach(function (modifier) {
          return state.modifiersData[modifier.name] = Object.assign({}, modifier.data);
        });

        for (var index = 0; index < state.orderedModifiers.length; index++) {

          if (state.reset === true) {
            state.reset = false;
            index = -1;
            continue;
          }

          var _state$orderedModifie = state.orderedModifiers[index],
              fn = _state$orderedModifie.fn,
              _state$orderedModifie2 = _state$orderedModifie.options,
              _options = _state$orderedModifie2 === void 0 ? {} : _state$orderedModifie2,
              name = _state$orderedModifie.name;

          if (typeof fn === 'function') {
            state = fn({
              state: state,
              options: _options,
              name: name,
              instance: instance
            }) || state;
          }
        }
      },
      // Async and optimistically optimized update – it will not be executed if
      // not necessary (debounced to run at most once-per-tick)
      update: debounce(function () {
        return new Promise(function (resolve) {
          instance.forceUpdate();
          resolve(state);
        });
      }),
      destroy: function destroy() {
        cleanupModifierEffects();
        isDestroyed = true;
      }
    };

    if (!areValidElements(reference, popper)) {

      return instance;
    }

    instance.setOptions(options).then(function (state) {
      if (!isDestroyed && options.onFirstUpdate) {
        options.onFirstUpdate(state);
      }
    }); // Modifiers have the ability to execute arbitrary code before the first
    // update cycle runs. They will be executed in the same order as the update
    // cycle. This is useful when a modifier adds some persistent data that
    // other modifiers need to use, but the modifier is run after the dependent
    // one.

    function runModifierEffects() {
      state.orderedModifiers.forEach(function (_ref3) {
        var name = _ref3.name,
            _ref3$options = _ref3.options,
            options = _ref3$options === void 0 ? {} : _ref3$options,
            effect = _ref3.effect;

        if (typeof effect === 'function') {
          var cleanupFn = effect({
            state: state,
            name: name,
            instance: instance,
            options: options
          });

          var noopFn = function noopFn() {};

          effectCleanupFns.push(cleanupFn || noopFn);
        }
      });
    }

    function cleanupModifierEffects() {
      effectCleanupFns.forEach(function (fn) {
        return fn();
      });
      effectCleanupFns = [];
    }

    return instance;
  };
}var passive = {
  passive: true
};

function effect$2(_ref) {
  var state = _ref.state,
      instance = _ref.instance,
      options = _ref.options;
  var _options$scroll = options.scroll,
      scroll = _options$scroll === void 0 ? true : _options$scroll,
      _options$resize = options.resize,
      resize = _options$resize === void 0 ? true : _options$resize;
  var window = getWindow(state.elements.popper);
  var scrollParents = [].concat(state.scrollParents.reference, state.scrollParents.popper);

  if (scroll) {
    scrollParents.forEach(function (scrollParent) {
      scrollParent.addEventListener('scroll', instance.update, passive);
    });
  }

  if (resize) {
    window.addEventListener('resize', instance.update, passive);
  }

  return function () {
    if (scroll) {
      scrollParents.forEach(function (scrollParent) {
        scrollParent.removeEventListener('scroll', instance.update, passive);
      });
    }

    if (resize) {
      window.removeEventListener('resize', instance.update, passive);
    }
  };
} // eslint-disable-next-line import/no-unused-modules


var eventListeners = {
  name: 'eventListeners',
  enabled: true,
  phase: 'write',
  fn: function fn() {},
  effect: effect$2,
  data: {}
};function popperOffsets(_ref) {
  var state = _ref.state,
      name = _ref.name;
  // Offsets are the actual position the popper needs to have to be
  // properly positioned near its reference element
  // This is the most basic placement, and will be adjusted by
  // the modifiers in the next step
  state.modifiersData[name] = computeOffsets({
    reference: state.rects.reference,
    element: state.rects.popper,
    strategy: 'absolute',
    placement: state.placement
  });
} // eslint-disable-next-line import/no-unused-modules


var popperOffsets$1 = {
  name: 'popperOffsets',
  enabled: true,
  phase: 'read',
  fn: popperOffsets,
  data: {}
};var unsetSides = {
  top: 'auto',
  right: 'auto',
  bottom: 'auto',
  left: 'auto'
}; // Round the offsets to the nearest suitable subpixel based on the DPR.
// Zooming can change the DPR, but it seems to report a value that will
// cleanly divide the values into the appropriate subpixels.

function roundOffsetsByDPR(_ref) {
  var x = _ref.x,
      y = _ref.y;
  var win = window;
  var dpr = win.devicePixelRatio || 1;
  return {
    x: round(round(x * dpr) / dpr) || 0,
    y: round(round(y * dpr) / dpr) || 0
  };
}

function mapToStyles(_ref2) {
  var _Object$assign2;

  var popper = _ref2.popper,
      popperRect = _ref2.popperRect,
      placement = _ref2.placement,
      variation = _ref2.variation,
      offsets = _ref2.offsets,
      position = _ref2.position,
      gpuAcceleration = _ref2.gpuAcceleration,
      adaptive = _ref2.adaptive,
      roundOffsets = _ref2.roundOffsets;

  var _ref3 = roundOffsets === true ? roundOffsetsByDPR(offsets) : typeof roundOffsets === 'function' ? roundOffsets(offsets) : offsets,
      _ref3$x = _ref3.x,
      x = _ref3$x === void 0 ? 0 : _ref3$x,
      _ref3$y = _ref3.y,
      y = _ref3$y === void 0 ? 0 : _ref3$y;

  var hasX = offsets.hasOwnProperty('x');
  var hasY = offsets.hasOwnProperty('y');
  var sideX = left;
  var sideY = top;
  var win = window;

  if (adaptive) {
    var offsetParent = getOffsetParent(popper);
    var heightProp = 'clientHeight';
    var widthProp = 'clientWidth';

    if (offsetParent === getWindow(popper)) {
      offsetParent = getDocumentElement(popper);

      if (getComputedStyle$1(offsetParent).position !== 'static' && position === 'absolute') {
        heightProp = 'scrollHeight';
        widthProp = 'scrollWidth';
      }
    } // $FlowFixMe[incompatible-cast]: force type refinement, we compare offsetParent with window above, but Flow doesn't detect it


    offsetParent = offsetParent;

    if (placement === top || (placement === left || placement === right) && variation === end) {
      sideY = bottom; // $FlowFixMe[prop-missing]

      y -= offsetParent[heightProp] - popperRect.height;
      y *= gpuAcceleration ? 1 : -1;
    }

    if (placement === left || (placement === top || placement === bottom) && variation === end) {
      sideX = right; // $FlowFixMe[prop-missing]

      x -= offsetParent[widthProp] - popperRect.width;
      x *= gpuAcceleration ? 1 : -1;
    }
  }

  var commonStyles = Object.assign({
    position: position
  }, adaptive && unsetSides);

  if (gpuAcceleration) {
    var _Object$assign;

    return Object.assign({}, commonStyles, (_Object$assign = {}, _Object$assign[sideY] = hasY ? '0' : '', _Object$assign[sideX] = hasX ? '0' : '', _Object$assign.transform = (win.devicePixelRatio || 1) <= 1 ? "translate(" + x + "px, " + y + "px)" : "translate3d(" + x + "px, " + y + "px, 0)", _Object$assign));
  }

  return Object.assign({}, commonStyles, (_Object$assign2 = {}, _Object$assign2[sideY] = hasY ? y + "px" : '', _Object$assign2[sideX] = hasX ? x + "px" : '', _Object$assign2.transform = '', _Object$assign2));
}

function computeStyles(_ref4) {
  var state = _ref4.state,
      options = _ref4.options;
  var _options$gpuAccelerat = options.gpuAcceleration,
      gpuAcceleration = _options$gpuAccelerat === void 0 ? true : _options$gpuAccelerat,
      _options$adaptive = options.adaptive,
      adaptive = _options$adaptive === void 0 ? true : _options$adaptive,
      _options$roundOffsets = options.roundOffsets,
      roundOffsets = _options$roundOffsets === void 0 ? true : _options$roundOffsets;

  var commonStyles = {
    placement: getBasePlacement(state.placement),
    variation: getVariation(state.placement),
    popper: state.elements.popper,
    popperRect: state.rects.popper,
    gpuAcceleration: gpuAcceleration
  };

  if (state.modifiersData.popperOffsets != null) {
    state.styles.popper = Object.assign({}, state.styles.popper, mapToStyles(Object.assign({}, commonStyles, {
      offsets: state.modifiersData.popperOffsets,
      position: state.options.strategy,
      adaptive: adaptive,
      roundOffsets: roundOffsets
    })));
  }

  if (state.modifiersData.arrow != null) {
    state.styles.arrow = Object.assign({}, state.styles.arrow, mapToStyles(Object.assign({}, commonStyles, {
      offsets: state.modifiersData.arrow,
      position: 'absolute',
      adaptive: false,
      roundOffsets: roundOffsets
    })));
  }

  state.attributes.popper = Object.assign({}, state.attributes.popper, {
    'data-popper-placement': state.placement
  });
} // eslint-disable-next-line import/no-unused-modules


var computeStyles$1 = {
  name: 'computeStyles',
  enabled: true,
  phase: 'beforeWrite',
  fn: computeStyles,
  data: {}
};// and applies them to the HTMLElements such as popper and arrow

function applyStyles(_ref) {
  var state = _ref.state;
  Object.keys(state.elements).forEach(function (name) {
    var style = state.styles[name] || {};
    var attributes = state.attributes[name] || {};
    var element = state.elements[name]; // arrow is optional + virtual elements

    if (!isHTMLElement(element) || !getNodeName(element)) {
      return;
    } // Flow doesn't support to extend this property, but it's the most
    // effective way to apply styles to an HTMLElement
    // $FlowFixMe[cannot-write]


    Object.assign(element.style, style);
    Object.keys(attributes).forEach(function (name) {
      var value = attributes[name];

      if (value === false) {
        element.removeAttribute(name);
      } else {
        element.setAttribute(name, value === true ? '' : value);
      }
    });
  });
}

function effect$1(_ref2) {
  var state = _ref2.state;
  var initialStyles = {
    popper: {
      position: state.options.strategy,
      left: '0',
      top: '0',
      margin: '0'
    },
    arrow: {
      position: 'absolute'
    },
    reference: {}
  };
  Object.assign(state.elements.popper.style, initialStyles.popper);
  state.styles = initialStyles;

  if (state.elements.arrow) {
    Object.assign(state.elements.arrow.style, initialStyles.arrow);
  }

  return function () {
    Object.keys(state.elements).forEach(function (name) {
      var element = state.elements[name];
      var attributes = state.attributes[name] || {};
      var styleProperties = Object.keys(state.styles.hasOwnProperty(name) ? state.styles[name] : initialStyles[name]); // Set all values to an empty string to unset them

      var style = styleProperties.reduce(function (style, property) {
        style[property] = '';
        return style;
      }, {}); // arrow is optional + virtual elements

      if (!isHTMLElement(element) || !getNodeName(element)) {
        return;
      }

      Object.assign(element.style, style);
      Object.keys(attributes).forEach(function (attribute) {
        element.removeAttribute(attribute);
      });
    });
  };
} // eslint-disable-next-line import/no-unused-modules


var applyStyles$1 = {
  name: 'applyStyles',
  enabled: true,
  phase: 'write',
  fn: applyStyles,
  effect: effect$1,
  requires: ['computeStyles']
};var defaultModifiers = [eventListeners, popperOffsets$1, computeStyles$1, applyStyles$1];
var createPopper = /*#__PURE__*/popperGenerator({
  defaultModifiers: defaultModifiers
}); // eslint-disable-next-line import/no-unused-modules
function getAltAxis(axis) {
  return axis === 'x' ? 'y' : 'x';
}function within(min$1, value, max$1) {
  return max(min$1, min(value, max$1));
}function preventOverflow(_ref) {
  var state = _ref.state,
      options = _ref.options,
      name = _ref.name;
  var _options$mainAxis = options.mainAxis,
      checkMainAxis = _options$mainAxis === void 0 ? true : _options$mainAxis,
      _options$altAxis = options.altAxis,
      checkAltAxis = _options$altAxis === void 0 ? false : _options$altAxis,
      boundary = options.boundary,
      rootBoundary = options.rootBoundary,
      altBoundary = options.altBoundary,
      padding = options.padding,
      _options$tether = options.tether,
      tether = _options$tether === void 0 ? true : _options$tether,
      _options$tetherOffset = options.tetherOffset,
      tetherOffset = _options$tetherOffset === void 0 ? 0 : _options$tetherOffset;
  var overflow = detectOverflow(state, {
    boundary: boundary,
    rootBoundary: rootBoundary,
    padding: padding,
    altBoundary: altBoundary
  });
  var basePlacement = getBasePlacement(state.placement);
  var variation = getVariation(state.placement);
  var isBasePlacement = !variation;
  var mainAxis = getMainAxisFromPlacement(basePlacement);
  var altAxis = getAltAxis(mainAxis);
  var popperOffsets = state.modifiersData.popperOffsets;
  var referenceRect = state.rects.reference;
  var popperRect = state.rects.popper;
  var tetherOffsetValue = typeof tetherOffset === 'function' ? tetherOffset(Object.assign({}, state.rects, {
    placement: state.placement
  })) : tetherOffset;
  var data = {
    x: 0,
    y: 0
  };

  if (!popperOffsets) {
    return;
  }

  if (checkMainAxis || checkAltAxis) {
    var mainSide = mainAxis === 'y' ? top : left;
    var altSide = mainAxis === 'y' ? bottom : right;
    var len = mainAxis === 'y' ? 'height' : 'width';
    var offset = popperOffsets[mainAxis];
    var min$1 = popperOffsets[mainAxis] + overflow[mainSide];
    var max$1 = popperOffsets[mainAxis] - overflow[altSide];
    var additive = tether ? -popperRect[len] / 2 : 0;
    var minLen = variation === start ? referenceRect[len] : popperRect[len];
    var maxLen = variation === start ? -popperRect[len] : -referenceRect[len]; // We need to include the arrow in the calculation so the arrow doesn't go
    // outside the reference bounds

    var arrowElement = state.elements.arrow;
    var arrowRect = tether && arrowElement ? getLayoutRect(arrowElement) : {
      width: 0,
      height: 0
    };
    var arrowPaddingObject = state.modifiersData['arrow#persistent'] ? state.modifiersData['arrow#persistent'].padding : getFreshSideObject();
    var arrowPaddingMin = arrowPaddingObject[mainSide];
    var arrowPaddingMax = arrowPaddingObject[altSide]; // If the reference length is smaller than the arrow length, we don't want
    // to include its full size in the calculation. If the reference is small
    // and near the edge of a boundary, the popper can overflow even if the
    // reference is not overflowing as well (e.g. virtual elements with no
    // width or height)

    var arrowLen = within(0, referenceRect[len], arrowRect[len]);
    var minOffset = isBasePlacement ? referenceRect[len] / 2 - additive - arrowLen - arrowPaddingMin - tetherOffsetValue : minLen - arrowLen - arrowPaddingMin - tetherOffsetValue;
    var maxOffset = isBasePlacement ? -referenceRect[len] / 2 + additive + arrowLen + arrowPaddingMax + tetherOffsetValue : maxLen + arrowLen + arrowPaddingMax + tetherOffsetValue;
    var arrowOffsetParent = state.elements.arrow && getOffsetParent(state.elements.arrow);
    var clientOffset = arrowOffsetParent ? mainAxis === 'y' ? arrowOffsetParent.clientTop || 0 : arrowOffsetParent.clientLeft || 0 : 0;
    var offsetModifierValue = state.modifiersData.offset ? state.modifiersData.offset[state.placement][mainAxis] : 0;
    var tetherMin = popperOffsets[mainAxis] + minOffset - offsetModifierValue - clientOffset;
    var tetherMax = popperOffsets[mainAxis] + maxOffset - offsetModifierValue;

    if (checkMainAxis) {
      var preventedOffset = within(tether ? min(min$1, tetherMin) : min$1, offset, tether ? max(max$1, tetherMax) : max$1);
      popperOffsets[mainAxis] = preventedOffset;
      data[mainAxis] = preventedOffset - offset;
    }

    if (checkAltAxis) {
      var _mainSide = mainAxis === 'x' ? top : left;

      var _altSide = mainAxis === 'x' ? bottom : right;

      var _offset = popperOffsets[altAxis];

      var _min = _offset + overflow[_mainSide];

      var _max = _offset - overflow[_altSide];

      var _preventedOffset = within(tether ? min(_min, tetherMin) : _min, _offset, tether ? max(_max, tetherMax) : _max);

      popperOffsets[altAxis] = _preventedOffset;
      data[altAxis] = _preventedOffset - _offset;
    }
  }

  state.modifiersData[name] = data;
} // eslint-disable-next-line import/no-unused-modules


var preventOverflow$1 = {
  name: 'preventOverflow',
  enabled: true,
  phase: 'main',
  fn: preventOverflow,
  requiresIfExists: ['offset']
};var hash$1 = {
  left: 'right',
  right: 'left',
  bottom: 'top',
  top: 'bottom'
};
function getOppositePlacement(placement) {
  return placement.replace(/left|right|bottom|top/g, function (matched) {
    return hash$1[matched];
  });
}var hash = {
  start: 'end',
  end: 'start'
};
function getOppositeVariationPlacement(placement) {
  return placement.replace(/start|end/g, function (matched) {
    return hash[matched];
  });
}function computeAutoPlacement(state, options) {
  if (options === void 0) {
    options = {};
  }

  var _options = options,
      placement = _options.placement,
      boundary = _options.boundary,
      rootBoundary = _options.rootBoundary,
      padding = _options.padding,
      flipVariations = _options.flipVariations,
      _options$allowedAutoP = _options.allowedAutoPlacements,
      allowedAutoPlacements = _options$allowedAutoP === void 0 ? placements : _options$allowedAutoP;
  var variation = getVariation(placement);
  var placements$1 = variation ? flipVariations ? variationPlacements : variationPlacements.filter(function (placement) {
    return getVariation(placement) === variation;
  }) : basePlacements;
  var allowedPlacements = placements$1.filter(function (placement) {
    return allowedAutoPlacements.indexOf(placement) >= 0;
  });

  if (allowedPlacements.length === 0) {
    allowedPlacements = placements$1;
  } // $FlowFixMe[incompatible-type]: Flow seems to have problems with two array unions...


  var overflows = allowedPlacements.reduce(function (acc, placement) {
    acc[placement] = detectOverflow(state, {
      placement: placement,
      boundary: boundary,
      rootBoundary: rootBoundary,
      padding: padding
    })[getBasePlacement(placement)];
    return acc;
  }, {});
  return Object.keys(overflows).sort(function (a, b) {
    return overflows[a] - overflows[b];
  });
}function getExpandedFallbackPlacements(placement) {
  if (getBasePlacement(placement) === auto) {
    return [];
  }

  var oppositePlacement = getOppositePlacement(placement);
  return [getOppositeVariationPlacement(placement), oppositePlacement, getOppositeVariationPlacement(oppositePlacement)];
}

function flip(_ref) {
  var state = _ref.state,
      options = _ref.options,
      name = _ref.name;

  if (state.modifiersData[name]._skip) {
    return;
  }

  var _options$mainAxis = options.mainAxis,
      checkMainAxis = _options$mainAxis === void 0 ? true : _options$mainAxis,
      _options$altAxis = options.altAxis,
      checkAltAxis = _options$altAxis === void 0 ? true : _options$altAxis,
      specifiedFallbackPlacements = options.fallbackPlacements,
      padding = options.padding,
      boundary = options.boundary,
      rootBoundary = options.rootBoundary,
      altBoundary = options.altBoundary,
      _options$flipVariatio = options.flipVariations,
      flipVariations = _options$flipVariatio === void 0 ? true : _options$flipVariatio,
      allowedAutoPlacements = options.allowedAutoPlacements;
  var preferredPlacement = state.options.placement;
  var basePlacement = getBasePlacement(preferredPlacement);
  var isBasePlacement = basePlacement === preferredPlacement;
  var fallbackPlacements = specifiedFallbackPlacements || (isBasePlacement || !flipVariations ? [getOppositePlacement(preferredPlacement)] : getExpandedFallbackPlacements(preferredPlacement));
  var placements = [preferredPlacement].concat(fallbackPlacements).reduce(function (acc, placement) {
    return acc.concat(getBasePlacement(placement) === auto ? computeAutoPlacement(state, {
      placement: placement,
      boundary: boundary,
      rootBoundary: rootBoundary,
      padding: padding,
      flipVariations: flipVariations,
      allowedAutoPlacements: allowedAutoPlacements
    }) : placement);
  }, []);
  var referenceRect = state.rects.reference;
  var popperRect = state.rects.popper;
  var checksMap = new Map();
  var makeFallbackChecks = true;
  var firstFittingPlacement = placements[0];

  for (var i = 0; i < placements.length; i++) {
    var placement = placements[i];

    var _basePlacement = getBasePlacement(placement);

    var isStartVariation = getVariation(placement) === start;
    var isVertical = [top, bottom].indexOf(_basePlacement) >= 0;
    var len = isVertical ? 'width' : 'height';
    var overflow = detectOverflow(state, {
      placement: placement,
      boundary: boundary,
      rootBoundary: rootBoundary,
      altBoundary: altBoundary,
      padding: padding
    });
    var mainVariationSide = isVertical ? isStartVariation ? right : left : isStartVariation ? bottom : top;

    if (referenceRect[len] > popperRect[len]) {
      mainVariationSide = getOppositePlacement(mainVariationSide);
    }

    var altVariationSide = getOppositePlacement(mainVariationSide);
    var checks = [];

    if (checkMainAxis) {
      checks.push(overflow[_basePlacement] <= 0);
    }

    if (checkAltAxis) {
      checks.push(overflow[mainVariationSide] <= 0, overflow[altVariationSide] <= 0);
    }

    if (checks.every(function (check) {
      return check;
    })) {
      firstFittingPlacement = placement;
      makeFallbackChecks = false;
      break;
    }

    checksMap.set(placement, checks);
  }

  if (makeFallbackChecks) {
    // `2` may be desired in some cases – research later
    var numberOfChecks = flipVariations ? 3 : 1;

    var _loop = function _loop(_i) {
      var fittingPlacement = placements.find(function (placement) {
        var checks = checksMap.get(placement);

        if (checks) {
          return checks.slice(0, _i).every(function (check) {
            return check;
          });
        }
      });

      if (fittingPlacement) {
        firstFittingPlacement = fittingPlacement;
        return "break";
      }
    };

    for (var _i = numberOfChecks; _i > 0; _i--) {
      var _ret = _loop(_i);

      if (_ret === "break") break;
    }
  }

  if (state.placement !== firstFittingPlacement) {
    state.modifiersData[name]._skip = true;
    state.placement = firstFittingPlacement;
    state.reset = true;
  }
} // eslint-disable-next-line import/no-unused-modules


var flip$1 = {
  name: 'flip',
  enabled: true,
  phase: 'main',
  fn: flip,
  requiresIfExists: ['offset'],
  data: {
    _skip: false
  }
};function distanceAndSkiddingToXY(placement, rects, offset) {
  var basePlacement = getBasePlacement(placement);
  var invertDistance = [left, top].indexOf(basePlacement) >= 0 ? -1 : 1;

  var _ref = typeof offset === 'function' ? offset(Object.assign({}, rects, {
    placement: placement
  })) : offset,
      skidding = _ref[0],
      distance = _ref[1];

  skidding = skidding || 0;
  distance = (distance || 0) * invertDistance;
  return [left, right].indexOf(basePlacement) >= 0 ? {
    x: distance,
    y: skidding
  } : {
    x: skidding,
    y: distance
  };
}

function offset(_ref2) {
  var state = _ref2.state,
      options = _ref2.options,
      name = _ref2.name;
  var _options$offset = options.offset,
      offset = _options$offset === void 0 ? [0, 0] : _options$offset;
  var data = placements.reduce(function (acc, placement) {
    acc[placement] = distanceAndSkiddingToXY(placement, state.rects, offset);
    return acc;
  }, {});
  var _data$state$placement = data[state.placement],
      x = _data$state$placement.x,
      y = _data$state$placement.y;

  if (state.modifiersData.popperOffsets != null) {
    state.modifiersData.popperOffsets.x += x;
    state.modifiersData.popperOffsets.y += y;
  }

  state.modifiersData[name] = data;
} // eslint-disable-next-line import/no-unused-modules


var offset$1 = {
  name: 'offset',
  enabled: true,
  phase: 'main',
  requires: ['popperOffsets'],
  fn: offset
};var toPaddingObject = function toPaddingObject(padding, state) {
  padding = typeof padding === 'function' ? padding(Object.assign({}, state.rects, {
    placement: state.placement
  })) : padding;
  return mergePaddingObject(typeof padding !== 'number' ? padding : expandToHashMap(padding, basePlacements));
};

function arrow(_ref) {
  var _state$modifiersData$;

  var state = _ref.state,
      name = _ref.name,
      options = _ref.options;
  var arrowElement = state.elements.arrow;
  var popperOffsets = state.modifiersData.popperOffsets;
  var basePlacement = getBasePlacement(state.placement);
  var axis = getMainAxisFromPlacement(basePlacement);
  var isVertical = [left, right].indexOf(basePlacement) >= 0;
  var len = isVertical ? 'height' : 'width';

  if (!arrowElement || !popperOffsets) {
    return;
  }

  var paddingObject = toPaddingObject(options.padding, state);
  var arrowRect = getLayoutRect(arrowElement);
  var minProp = axis === 'y' ? top : left;
  var maxProp = axis === 'y' ? bottom : right;
  var endDiff = state.rects.reference[len] + state.rects.reference[axis] - popperOffsets[axis] - state.rects.popper[len];
  var startDiff = popperOffsets[axis] - state.rects.reference[axis];
  var arrowOffsetParent = getOffsetParent(arrowElement);
  var clientSize = arrowOffsetParent ? axis === 'y' ? arrowOffsetParent.clientHeight || 0 : arrowOffsetParent.clientWidth || 0 : 0;
  var centerToReference = endDiff / 2 - startDiff / 2; // Make sure the arrow doesn't overflow the popper if the center point is
  // outside of the popper bounds

  var min = paddingObject[minProp];
  var max = clientSize - arrowRect[len] - paddingObject[maxProp];
  var center = clientSize / 2 - arrowRect[len] / 2 + centerToReference;
  var offset = within(min, center, max); // Prevents breaking syntax highlighting...

  var axisProp = axis;
  state.modifiersData[name] = (_state$modifiersData$ = {}, _state$modifiersData$[axisProp] = offset, _state$modifiersData$.centerOffset = offset - center, _state$modifiersData$);
}

function effect(_ref2) {
  var state = _ref2.state,
      options = _ref2.options;
  var _options$element = options.element,
      arrowElement = _options$element === void 0 ? '[data-popper-arrow]' : _options$element;

  if (arrowElement == null) {
    return;
  } // CSS selector


  if (typeof arrowElement === 'string') {
    arrowElement = state.elements.popper.querySelector(arrowElement);

    if (!arrowElement) {
      return;
    }
  }

  if (!contains(state.elements.popper, arrowElement)) {

    return;
  }

  state.elements.arrow = arrowElement;
} // eslint-disable-next-line import/no-unused-modules


var arrow$1 = {
  name: 'arrow',
  enabled: true,
  phase: 'main',
  fn: arrow,
  effect: effect,
  requires: ['popperOffsets'],
  requiresIfExists: ['preventOverflow']
};var toInt = function toInt(x) {
  return parseInt(x, 10);
};

function usePopper(_ref) {
  var arrowPadding = _ref.arrowPadding,
      emit = _ref.emit,
      locked = _ref.locked,
      offsetDistance = _ref.offsetDistance,
      offsetSkid = _ref.offsetSkid,
      placement = _ref.placement,
      popperNode = _ref.popperNode,
      triggerNode = _ref.triggerNode;
  var state = vue.reactive({
    isOpen: false,
    popperInstance: null
  }); // Enable or disable event listeners to optimize performance.

  var setPopperEventListeners = function setPopperEventListeners(enabled) {
    var _state$popperInstance;

    (_state$popperInstance = state.popperInstance) === null || _state$popperInstance === void 0 ? void 0 : _state$popperInstance.setOptions(function (options) {
      return _objectSpread2(_objectSpread2({}, options), {}, {
        modifiers: [].concat(_toConsumableArray(options.modifiers), [{
          name: "eventListeners",
          enabled: enabled
        }])
      });
    });
  };

  var enablePopperEventListeners = function enablePopperEventListeners() {
    return setPopperEventListeners(true);
  };

  var disablePopperEventListeners = function disablePopperEventListeners() {
    return setPopperEventListeners(false);
  };

  var close = function close() {
    if (!state.isOpen) {
      return;
    }

    state.isOpen = false;
    emit("close:popper");
  };

  var open = function open() {
    if (state.isOpen) {
      return;
    }

    state.isOpen = true;
    emit("open:popper");
  }; // When isOpen or placement change


  vue.watch([function () {
    return state.isOpen;
  }, placement], /*#__PURE__*/function () {
    var _ref3 = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee(_ref2) {
      var _ref4, isOpen;

      return regeneratorRuntime.wrap(function _callee$(_context) {
        while (1) {
          switch (_context.prev = _context.next) {
            case 0:
              _ref4 = _slicedToArray(_ref2, 1), isOpen = _ref4[0];

              if (!isOpen) {
                _context.next = 7;
                break;
              }

              _context.next = 4;
              return initializePopper();

            case 4:
              enablePopperEventListeners();
              _context.next = 8;
              break;

            case 7:
              disablePopperEventListeners();

            case 8:
            case "end":
              return _context.stop();
          }
        }
      }, _callee);
    }));

    return function (_x) {
      return _ref3.apply(this, arguments);
    };
  }());

  var initializePopper = /*#__PURE__*/function () {
    var _ref5 = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee2() {
      return regeneratorRuntime.wrap(function _callee2$(_context2) {
        while (1) {
          switch (_context2.prev = _context2.next) {
            case 0:
              _context2.next = 2;
              return vue.nextTick();

            case 2:
              state.popperInstance = createPopper(triggerNode.value, popperNode.value, {
                placement: placement.value,
                modifiers: [preventOverflow$1, flip$1, {
                  name: "flip",
                  enabled: !locked.value
                }, arrow$1, {
                  name: "arrow",
                  options: {
                    padding: toInt(arrowPadding.value)
                  }
                }, offset$1, {
                  name: "offset",
                  options: {
                    offset: [toInt(offsetSkid.value), toInt(offsetDistance.value)]
                  }
                }]
              }); // Update its position

              state.popperInstance.update();

            case 4:
            case "end":
              return _context2.stop();
          }
        }
      }, _callee2);
    }));

    return function initializePopper() {
      return _ref5.apply(this, arguments);
    };
  }();

  vue.onBeforeUnmount(function () {
    var _state$popperInstance2;

    (_state$popperInstance2 = state.popperInstance) === null || _state$popperInstance2 === void 0 ? void 0 : _state$popperInstance2.destroy();
  });
  return _objectSpread2(_objectSpread2({}, vue.toRefs(state)), {}, {
    open: open,
    close: close
  });
}var _hoisted_1$1$2 = {
  id: "arrow",
  "data-popper-arrow": ""
};
function render$V(_ctx, _cache) {
  return vue.openBlock(), vue.createElementBlock("div", _hoisted_1$1$2);
}function styleInject$i(css, ref) {
  if ( ref === void 0 ) ref = {};
  var insertAt = ref.insertAt;

  if (!css || typeof document === 'undefined') { return; }

  var head = document.head || document.getElementsByTagName('head')[0];
  var style = document.createElement('style');
  style.type = 'text/css';

  if (insertAt === 'top') {
    if (head.firstChild) {
      head.insertBefore(style, head.firstChild);
    } else {
      head.appendChild(style);
    }
  } else {
    head.appendChild(style);
  }

  if (style.styleSheet) {
    style.styleSheet.cssText = css;
  } else {
    style.appendChild(document.createTextNode(css));
  }
}var css_248z$1$1 = "\n#arrow[data-v-20b7fd4a],\n  #arrow[data-v-20b7fd4a]::before {\n    transition: background 250ms ease-in-out;\n    position: absolute;\n    width: calc(10px - var(--popper-theme-border-width, 0px));\n    height: calc(10px - var(--popper-theme-border-width, 0px));\n    box-sizing: border-box;\n    background: var(--popper-theme-background-color);\n}\n#arrow[data-v-20b7fd4a] {\n    visibility: hidden;\n}\n#arrow[data-v-20b7fd4a]::before {\n    visibility: visible;\n    content: \"\";\n    transform: rotate(45deg);\n}\n\n  /* Top arrow */\n.popper[data-popper-placement^=\"top\"] > #arrow[data-v-20b7fd4a] {\n    bottom: -5px;\n}\n.popper[data-popper-placement^=\"top\"] > #arrow[data-v-20b7fd4a]::before {\n    border-right: var(--popper-theme-border-width)\n      var(--popper-theme-border-style) var(--popper-theme-border-color);\n    border-bottom: var(--popper-theme-border-width)\n      var(--popper-theme-border-style) var(--popper-theme-border-color);\n}\n\n  /* Bottom arrow */\n.popper[data-popper-placement^=\"bottom\"] > #arrow[data-v-20b7fd4a] {\n    top: -5px;\n}\n.popper[data-popper-placement^=\"bottom\"] > #arrow[data-v-20b7fd4a]::before {\n    border-left: var(--popper-theme-border-width)\n      var(--popper-theme-border-style) var(--popper-theme-border-color);\n    border-top: var(--popper-theme-border-width)\n      var(--popper-theme-border-style) var(--popper-theme-border-color);\n}\n\n  /* Left arrow */\n.popper[data-popper-placement^=\"left\"] > #arrow[data-v-20b7fd4a] {\n    right: -5px;\n}\n.popper[data-popper-placement^=\"left\"] > #arrow[data-v-20b7fd4a]::before {\n    border-right: var(--popper-theme-border-width)\n      var(--popper-theme-border-style) var(--popper-theme-border-color);\n    border-top: var(--popper-theme-border-width)\n      var(--popper-theme-border-style) var(--popper-theme-border-color);\n}\n\n  /* Right arrow */\n.popper[data-popper-placement^=\"right\"] > #arrow[data-v-20b7fd4a] {\n    left: -5px;\n}\n";
styleInject$i(css_248z$1$1);var script$1$3 = {};
script$1$3.render = render$V;
script$1$3.__scopeId = "data-v-20b7fd4a";
var Arrow = script$1$3;var _hoisted_1$Q = ["onKeyup"];
var script$X = {
  props: {
    /**
     * Preferred placement (the "auto" placements will choose the side with most space.)
     */
    placement: {
      type: String,
      default: "bottom",
      validator: function validator(value) {
        return ["auto", "auto-start", "auto-end", "top", "top-start", "top-end", "bottom", "bottom-start", "bottom-end", "right", "right-start", "right-end", "left", "left-start", "left-end"].includes(value);
      }
    },

    /**
     * Disables automatically closing the popover when the user clicks away from it
     */
    disableClickAway: {
      type: Boolean,
      default: false
    },

    /**
     * Offset in pixels along the trigger element
     */
    offsetSkid: {
      type: String,
      default: "0"
    },

    /**
     * Offset in pixels away from the trigger element
     */
    offsetDistance: {
      type: String,
      default: "12"
    },

    /**
     * Trigger the popper on hover
     */
    hover: {
      type: Boolean,
      default: false
    },

    /**
     * Manually open/close the Popper, other events are ignored if this prop is set
     */
    show: {
      type: Boolean,
      default: null
    },

    /**
     * Disables the Popper. If it was already open, it will be closed.
     */
    disabled: {
      type: Boolean,
      default: false
    },

    /**
     * Open the Popper after a delay (ms).
     */
    openDelay: {
      type: [Number, String],
      default: 0
    },

    /**
     * Close the Popper after a delay (ms).
     */
    closeDelay: {
      type: [Number, String],
      default: 0
    },

    /**
     * The z-index of the Popper.
     */
    zIndex: {
      type: [Number, String],
      default: 9999
    },

    /**
     * Display an arrow on the popper
     */
    arrow: {
      type: Boolean,
      default: false
    },

    /**
     * Stop arrow from reaching the edge of the popper
     */
    arrowPadding: {
      type: String,
      default: "0"
    },

    /**
     * If the Popper should be interactive, it will close when clicked/hovered if false
     */
    interactive: {
      type: Boolean,
      default: true
    },

    /**
     * Lock the Popper into place, it will not flip dynamically when it runs out of space if true
     */
    locked: {
      type: Boolean,
      default: false
    },

    /**
     * If the content is just a simple string, it can be passed in as a prop
     */
    content: {
      type: String,
      default: null
    }
  },
  emits: ["open:popper", "close:popper"],
  setup: function setup(__props, _ref) {
    var emit = _ref.emit;
    var props = __props;

    vue.useCssVars(function (_ctx) {
      return {
        "c81fc0a4": __props.zIndex
      };
    });

    var slots = vue.useSlots();
    var popperContainerNode = vue.ref(null);
    var popperNode = vue.ref(null);
    var triggerNode = vue.ref(null);
    var modifiedIsOpen = vue.ref(false);
    vue.onMounted(function () {
      var children = slots.default();

      if (children && children.length > 1) {
        return console.error("[Popper]: The <Popper> component expects only one child element at its root. You passed ".concat(children.length, " child nodes."));
      }
    });

    var _toRefs = vue.toRefs(props),
        arrowPadding = _toRefs.arrowPadding,
        closeDelay = _toRefs.closeDelay,
        content = _toRefs.content,
        disableClickAway = _toRefs.disableClickAway,
        disabled = _toRefs.disabled,
        interactive = _toRefs.interactive,
        locked = _toRefs.locked,
        offsetDistance = _toRefs.offsetDistance,
        offsetSkid = _toRefs.offsetSkid,
        openDelay = _toRefs.openDelay,
        placement = _toRefs.placement,
        show = _toRefs.show;

    var _usePopper = usePopper({
      arrowPadding: arrowPadding,
      emit: emit,
      locked: locked,
      offsetDistance: offsetDistance,
      offsetSkid: offsetSkid,
      placement: placement,
      popperNode: popperNode,
      triggerNode: triggerNode
    }),
        isOpen = _usePopper.isOpen,
        open = _usePopper.open,
        close = _usePopper.close;

    var _useContent = useContent(slots, popperNode, content),
        hasContent = _useContent.hasContent;

    var manualMode = vue.computed(function () {
      return show.value !== null;
    });
    var invalid = vue.computed(function () {
      return disabled.value || !hasContent.value;
    });
    var shouldShowPopper = vue.computed(function () {
      return isOpen.value && !invalid.value;
    });
    var enableClickAway = vue.computed(function () {
      return !disableClickAway.value && !manualMode.value;
    }); // Add an invisible border to keep the Popper open when hovering from the trigger into it

    var interactiveStyle = vue.computed(function () {
      return interactive.value ? "border: ".concat(offsetDistance.value, "px solid transparent; margin: -").concat(offsetDistance.value, "px;") : null;
    });
    var openPopperDebounce = debounce_1.debounce(open, openDelay.value);
    var closePopperDebounce = debounce_1.debounce(close, closeDelay.value);

    var openPopper = /*#__PURE__*/function () {
      var _ref2 = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee() {
        return regeneratorRuntime.wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                if (!(invalid.value || manualMode.value)) {
                  _context.next = 2;
                  break;
                }

                return _context.abrupt("return");

              case 2:
                closePopperDebounce.clear();
                openPopperDebounce();

              case 4:
              case "end":
                return _context.stop();
            }
          }
        }, _callee);
      }));

      return function openPopper() {
        return _ref2.apply(this, arguments);
      };
    }();

    var closePopper = /*#__PURE__*/function () {
      var _ref3 = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee2() {
        return regeneratorRuntime.wrap(function _callee2$(_context2) {
          while (1) {
            switch (_context2.prev = _context2.next) {
              case 0:
                if (!manualMode.value) {
                  _context2.next = 2;
                  break;
                }

                return _context2.abrupt("return");

              case 2:
                openPopperDebounce.clear();
                closePopperDebounce();

              case 4:
              case "end":
                return _context2.stop();
            }
          }
        }, _callee2);
      }));

      return function closePopper() {
        return _ref3.apply(this, arguments);
      };
    }();

    var togglePopper = function togglePopper() {
      isOpen.value ? closePopper() : openPopper();
    };
    /**
     * If Popper is open, we automatically close it if it becomes
     * disabled or without content.
     */


    vue.watch([hasContent, disabled], function (_ref4) {
      var _ref5 = _slicedToArray(_ref4, 2),
          hasContent = _ref5[0],
          disabled = _ref5[1];

      if (isOpen.value && (!hasContent || disabled)) {
        close();
      }
    });
    /**
     * In order to eliminate flickering or visibly empty Poppers due to
     * the transition when using the isOpen slot property, we need to return a
     * separate debounced value based on isOpen.
     */

    vue.watch(isOpen, function (isOpen) {
      if (isOpen) {
        modifiedIsOpen.value = true;
      } else {
        debounce_1.debounce(function () {
          modifiedIsOpen.value = false;
        }, 200);
      }
    });
    /**
     * Watch for manual mode.
     */

    vue.watchEffect(function () {
      if (manualMode.value) {
        show.value ? openPopperDebounce() : closePopperDebounce();
      }
    });
    /**
     * Use click away if it should be enabled.
     */

    vue.watchEffect(function () {
      if (enableClickAway.value) ;
    });
    return function (_ctx, _cache) {
      return vue.openBlock(), vue.createElementBlock("div", {
        class: "inline-block",
        style: vue.normalizeStyle(vue.unref(interactiveStyle)),
        onMouseleave: _cache[2] || (_cache[2] = function ($event) {
          return __props.hover && closePopper();
        }),
        ref: function ref(_value, _refs) {
          _refs['popperContainerNode'] = _value;
          popperContainerNode.value = _value;
        }
      }, [vue.createElementVNode("div", {
        ref: function ref(_value, _refs) {
          _refs['triggerNode'] = _value;
          triggerNode.value = _value;
        },
        onMouseover: _cache[0] || (_cache[0] = function ($event) {
          return __props.hover && openPopper();
        }),
        onClick: togglePopper,
        onFocus: openPopper,
        onKeyup: vue.withKeys(closePopper, ["esc"])
      }, [vue.renderSlot(_ctx.$slots, "default")], 40, _hoisted_1$Q), vue.createVNode(vue.Transition, {
        name: "fade"
      }, {
        default: vue.withCtx(function () {
          return [vue.withDirectives(vue.createElementVNode("div", {
            onClick: _cache[1] || (_cache[1] = function ($event) {
              return !vue.unref(interactive) && closePopper();
            }),
            class: "popper",
            ref: function ref(_value, _refs) {
              _refs['popperNode'] = _value;
              popperNode.value = _value;
            }
          }, [vue.renderSlot(_ctx.$slots, "content", {
            close: vue.unref(close),
            isOpen: modifiedIsOpen.value
          }, function () {
            return [vue.createTextVNode(vue.toDisplayString(vue.unref(content)), 1)];
          }), __props.arrow ? (vue.openBlock(), vue.createBlock(Arrow, {
            key: 0
          })) : vue.createCommentVNode("", true)], 512), [[vue.vShow, vue.unref(shouldShowPopper)]])];
        }),
        _: 3
      })], 36);
    };
  }
};var css_248z$i = "\n.inline-block[data-v-5784ed69] {\n    display: inline-block;\n}\n.popper[data-v-5784ed69] {\n    transition: background 250ms ease-in-out;\n    background: var(--popper-theme-background-color);\n    padding: var(--popper-theme-padding);\n    color: var(--popper-theme-text-color);\n    border-radius: var(--popper-theme-border-radius);\n    border-width: var(--popper-theme-border-width);\n    border-style: var(--popper-theme-border-style);\n    border-color: var(--popper-theme-border-color);\n    box-shadow: var(--popper-theme-box-shadow);\n    z-index: var(--c81fc0a4);\n}\n.popper[data-v-5784ed69]:hover,\n  .popper:hover > #arrow[data-v-5784ed69]::before {\n    background: var(--popper-theme-background-color-hover);\n}\n.inline-block[data-v-5784ed69] {\n    display: inline-block;\n}\n.fade-enter-active[data-v-5784ed69],\n  .fade-leave-active[data-v-5784ed69] {\n    transition: opacity 0.2s ease;\n}\n.fade-enter-from[data-v-5784ed69],\n  .fade-leave-to[data-v-5784ed69] {\n    opacity: 0;\n}\n";
styleInject$i(css_248z$i);script$X.__scopeId = "data-v-5784ed69";// IIFE injects install function into component, allowing component
// to be registered via Vue.use() as well as Vue.component(),

var component = /*#__PURE__*/(function () {
  // Get component instance
  var installable = script$X; // Attach install function executed by Vue.use()

  installable.install = function (app) {
    app.component("Popper", installable);
  };

  return installable;
})(); // It's possible to expose named exports when writing components that can
// also be used as directives, etc. - eg. import { RollupDemoDirective } from 'rollup-demo';
// export const RollupDemoDirective = directive;
var namedExports=/*#__PURE__*/Object.freeze({__proto__:null,'default':component});// only expose one global var, with named exports exposed as properties of
// that global var (eg. plugin.namedExport)

Object.entries(namedExports).forEach(function (_ref) {
  var _ref2 = _slicedToArray(_ref, 2),
      exportName = _ref2[0],
      exported = _ref2[1];

  if (exportName !== "default") component[exportName] = exported;
});var popper_ssr=component;

const Popper = /*@__PURE__*/getDefaultExportFromCjs(popper_ssr);

const appConfig = useRuntimeConfig$1().app;
const baseURL = () => appConfig.baseURL;
const nuxtAppCtx = /* @__PURE__ */ getContext("nuxt-app");
const NuxtPluginIndicator = "__nuxt_plugin";
function createNuxtApp(options) {
  let hydratingCount = 0;
  const nuxtApp = {
    provide: void 0,
    globalName: "nuxt",
    versions: {
      get nuxt() {
        return "3.6.0";
      },
      get vue() {
        return nuxtApp.vueApp.version;
      }
    },
    payload: reactive({
      data: {},
      state: {},
      _errors: {},
      ...{ serverRendered: true }
    }),
    static: {
      data: {}
    },
    runWithContext: (fn) => callWithNuxt(nuxtApp, fn),
    isHydrating: false,
    deferHydration() {
      if (!nuxtApp.isHydrating) {
        return () => {
        };
      }
      hydratingCount++;
      let called = false;
      return () => {
        if (called) {
          return;
        }
        called = true;
        hydratingCount--;
        if (hydratingCount === 0) {
          nuxtApp.isHydrating = false;
          return nuxtApp.callHook("app:suspense:resolve");
        }
      };
    },
    _asyncDataPromises: {},
    _asyncData: {},
    _payloadRevivers: {},
    ...options
  };
  nuxtApp.hooks = createHooks();
  nuxtApp.hook = nuxtApp.hooks.hook;
  {
    async function contextCaller(hooks, args) {
      for (const hook of hooks) {
        await nuxtApp.runWithContext(() => hook(...args));
      }
    }
    nuxtApp.hooks.callHook = (name, ...args) => nuxtApp.hooks.callHookWith(contextCaller, name, ...args);
  }
  nuxtApp.callHook = nuxtApp.hooks.callHook;
  nuxtApp.provide = (name, value) => {
    const $name = "$" + name;
    defineGetter(nuxtApp, $name, value);
    defineGetter(nuxtApp.vueApp.config.globalProperties, $name, value);
  };
  defineGetter(nuxtApp.vueApp, "$nuxt", nuxtApp);
  defineGetter(nuxtApp.vueApp.config.globalProperties, "$nuxt", nuxtApp);
  {
    if (nuxtApp.ssrContext) {
      nuxtApp.ssrContext.nuxt = nuxtApp;
      nuxtApp.ssrContext._payloadReducers = {};
      nuxtApp.payload.path = nuxtApp.ssrContext.url;
    }
    nuxtApp.ssrContext = nuxtApp.ssrContext || {};
    if (nuxtApp.ssrContext.payload) {
      Object.assign(nuxtApp.payload, nuxtApp.ssrContext.payload);
    }
    nuxtApp.ssrContext.payload = nuxtApp.payload;
    nuxtApp.ssrContext.config = {
      public: options.ssrContext.runtimeConfig.public,
      app: options.ssrContext.runtimeConfig.app
    };
  }
  const runtimeConfig = options.ssrContext.runtimeConfig;
  nuxtApp.provide("config", runtimeConfig);
  return nuxtApp;
}
async function applyPlugin(nuxtApp, plugin2) {
  if (plugin2.hooks) {
    nuxtApp.hooks.addHooks(plugin2.hooks);
  }
  if (typeof plugin2 === "function") {
    const { provide: provide2 } = await nuxtApp.runWithContext(() => plugin2(nuxtApp)) || {};
    if (provide2 && typeof provide2 === "object") {
      for (const key in provide2) {
        nuxtApp.provide(key, provide2[key]);
      }
    }
  }
}
async function applyPlugins(nuxtApp, plugins2) {
  const parallels = [];
  const errors = [];
  for (const plugin2 of plugins2) {
    const promise = applyPlugin(nuxtApp, plugin2);
    if (plugin2.parallel) {
      parallels.push(promise.catch((e) => errors.push(e)));
    } else {
      await promise;
    }
  }
  await Promise.all(parallels);
  if (errors.length) {
    throw errors[0];
  }
}
/*! @__NO_SIDE_EFFECTS__ */
function defineNuxtPlugin(plugin2) {
  if (typeof plugin2 === "function") {
    return plugin2;
  }
  delete plugin2.name;
  return Object.assign(plugin2.setup || (() => {
  }), plugin2, { [NuxtPluginIndicator]: true });
}
function callWithNuxt(nuxt, setup, args) {
  const fn = () => args ? setup(...args) : setup();
  {
    return nuxt.vueApp.runWithContext(() => nuxtAppCtx.callAsync(nuxt, fn));
  }
}
/*! @__NO_SIDE_EFFECTS__ */
function useNuxtApp() {
  var _a;
  let nuxtAppInstance;
  if (hasInjectionContext()) {
    nuxtAppInstance = (_a = getCurrentInstance()) == null ? void 0 : _a.appContext.app.$nuxt;
  }
  nuxtAppInstance = nuxtAppInstance || nuxtAppCtx.tryUse();
  if (!nuxtAppInstance) {
    {
      throw new Error("[nuxt] instance unavailable");
    }
  }
  return nuxtAppInstance;
}
/*! @__NO_SIDE_EFFECTS__ */
function useRuntimeConfig() {
  return useNuxtApp().$config;
}
function defineGetter(obj, key, val) {
  Object.defineProperty(obj, key, { get: () => val });
}
const useStateKeyPrefix = "$s";
function useState(...args) {
  const autoKey = typeof args[args.length - 1] === "string" ? args.pop() : void 0;
  if (typeof args[0] !== "string") {
    args.unshift(autoKey);
  }
  const [_key, init] = args;
  if (!_key || typeof _key !== "string") {
    throw new TypeError("[nuxt] [useState] key must be a string: " + _key);
  }
  if (init !== void 0 && typeof init !== "function") {
    throw new Error("[nuxt] [useState] init must be a function: " + init);
  }
  const key = useStateKeyPrefix + _key;
  const nuxt = useNuxtApp();
  const state = toRef(nuxt.payload.state, key);
  if (state.value === void 0 && init) {
    const initialValue = init();
    if (isRef(initialValue)) {
      nuxt.payload.state[key] = initialValue;
      return initialValue;
    }
    state.value = initialValue;
  }
  return state;
}
const useRouter = () => {
  var _a;
  return (_a = useNuxtApp()) == null ? void 0 : _a.$router;
};
const useRoute = () => {
  if (hasInjectionContext()) {
    return inject("_route", useNuxtApp()._route);
  }
  return useNuxtApp()._route;
};
/*! @__NO_SIDE_EFFECTS__ */
function defineNuxtRouteMiddleware(middleware) {
  return middleware;
}
const isProcessingMiddleware = () => {
  try {
    if (useNuxtApp()._processingMiddleware) {
      return true;
    }
  } catch {
    return true;
  }
  return false;
};
const navigateTo = (to, options) => {
  if (!to) {
    to = "/";
  }
  const toPath = typeof to === "string" ? to : withQuery(to.path || "/", to.query || {}) + (to.hash || "");
  if (options == null ? void 0 : options.open) {
    return Promise.resolve();
  }
  const isExternal = (options == null ? void 0 : options.external) || hasProtocol(toPath, { acceptRelative: true });
  if (isExternal && !(options == null ? void 0 : options.external)) {
    throw new Error("Navigating to external URL is not allowed by default. Use `navigateTo (url, { external: true })`.");
  }
  if (isExternal && parseURL(toPath).protocol === "script:") {
    throw new Error("Cannot navigate to an URL with script protocol.");
  }
  const inMiddleware = isProcessingMiddleware();
  const router = useRouter();
  const nuxtApp = useNuxtApp();
  {
    if (nuxtApp.ssrContext) {
      const fullPath = typeof to === "string" || isExternal ? toPath : router.resolve(to).fullPath || "/";
      const location2 = isExternal ? toPath : joinURL(useRuntimeConfig().app.baseURL, fullPath);
      async function redirect(response) {
        await nuxtApp.callHook("app:redirected");
        const encodedLoc = location2.replace(/"/g, "%22");
        nuxtApp.ssrContext._renderResponse = {
          statusCode: sanitizeStatusCode((options == null ? void 0 : options.redirectCode) || 302, 302),
          body: `<!DOCTYPE html><html><head><meta http-equiv="refresh" content="0; url=${encodedLoc}"></head></html>`,
          headers: { location: location2 }
        };
        return response;
      }
      if (!isExternal && inMiddleware) {
        router.afterEach((final) => final.fullPath === fullPath ? redirect(false) : void 0);
        return to;
      }
      return redirect(!inMiddleware ? void 0 : (
        /* abort route navigation */
        false
      ));
    }
  }
  if (isExternal) {
    if (options == null ? void 0 : options.replace) {
      location.replace(toPath);
    } else {
      location.href = toPath;
    }
    if (inMiddleware) {
      if (!nuxtApp.isHydrating) {
        return false;
      }
      return new Promise(() => {
      });
    }
    return Promise.resolve();
  }
  return (options == null ? void 0 : options.replace) ? router.replace(to) : router.push(to);
};
const useError = () => toRef(useNuxtApp().payload, "error");
const showError = (_err) => {
  const err = createError(_err);
  try {
    const nuxtApp = useNuxtApp();
    const error = useError();
    if (false)
      ;
    error.value = error.value || err;
  } catch {
    throw err;
  }
  return err;
};
const isNuxtError = (err) => !!(err && typeof err === "object" && "__nuxt_error" in err);
const createError = (err) => {
  const _err = createError$1(err);
  _err.__nuxt_error = true;
  return _err;
};
const __nuxt_page_meta$4 = {
  middleware: [
    "activated",
    "subscribed",
    "mobile-verified",
    "stripe",
    "valid-clearance"
  ]
};
const __nuxt_page_meta$3 = {
  middleware: [
    "activated",
    "subscribed",
    "mobile-verified",
    "stripe",
    "valid-clearance"
  ]
};
const __nuxt_page_meta$2 = {
  middleware: [
    "activated",
    "subscribed",
    "mobile-verified",
    "stripe",
    "valid-clearance"
  ]
};
const __nuxt_page_meta$1 = {
  middleware: ["auth"]
};
const __nuxt_page_meta = {
  middleware: ["auth", "activated", "subscribed"]
};
const _routes = [
  {
    name: "auth-forgot-password",
    path: "/auth/forgot-password",
    meta: {},
    alias: [],
    redirect: void 0,
    component: () => import('./_nuxt/forgot-password-fee4c139.mjs').then((m) => m.default || m)
  },
  {
    name: "auth-login",
    path: "/auth/login",
    meta: {},
    alias: [],
    redirect: void 0,
    component: () => import('./_nuxt/login-99d5a6f6.mjs').then((m) => m.default || m)
  },
  {
    name: "auth-register",
    path: "/auth/register",
    meta: {},
    alias: [],
    redirect: void 0,
    component: () => import('./_nuxt/register-7070a2d6.mjs').then((m) => m.default || m)
  },
  {
    name: "cgu",
    path: "/cgu",
    meta: {},
    alias: [],
    redirect: void 0,
    component: () => import('./_nuxt/cgu-38173bd4.mjs').then((m) => m.default || m)
  },
  {
    path: (__nuxt_page_meta$1 == null ? void 0 : __nuxt_page_meta$1.path) ?? "/dashboard",
    children: [
      {
        name: "dashboard",
        path: "",
        meta: {},
        alias: [],
        redirect: void 0,
        component: () => import('./_nuxt/index-085191d4.mjs').then((m) => m.default || m)
      },
      {
        name: (__nuxt_page_meta$4 == null ? void 0 : __nuxt_page_meta$4.name) ?? "dashboard-mes-alertes",
        path: (__nuxt_page_meta$4 == null ? void 0 : __nuxt_page_meta$4.path) ?? "mes-alertes",
        meta: __nuxt_page_meta$4 || {},
        alias: (__nuxt_page_meta$4 == null ? void 0 : __nuxt_page_meta$4.alias) || [],
        redirect: (__nuxt_page_meta$4 == null ? void 0 : __nuxt_page_meta$4.redirect) || void 0,
        component: () => import('./_nuxt/mes-alertes-a6f9480d.mjs').then((m) => m.default || m)
      },
      {
        name: (__nuxt_page_meta$3 == null ? void 0 : __nuxt_page_meta$3.name) ?? "dashboard-mes-demandes-de-trajets",
        path: (__nuxt_page_meta$3 == null ? void 0 : __nuxt_page_meta$3.path) ?? "mes-demandes-de-trajets",
        meta: __nuxt_page_meta$3 || {},
        alias: (__nuxt_page_meta$3 == null ? void 0 : __nuxt_page_meta$3.alias) || [],
        redirect: (__nuxt_page_meta$3 == null ? void 0 : __nuxt_page_meta$3.redirect) || void 0,
        component: () => import('./_nuxt/mes-demandes-de-trajets-aae8bc6f.mjs').then((m) => m.default || m)
      },
      {
        name: (__nuxt_page_meta$2 == null ? void 0 : __nuxt_page_meta$2.name) ?? "dashboard-mes-trajets-publies",
        path: (__nuxt_page_meta$2 == null ? void 0 : __nuxt_page_meta$2.path) ?? "mes-trajets-publies",
        meta: __nuxt_page_meta$2 || {},
        alias: (__nuxt_page_meta$2 == null ? void 0 : __nuxt_page_meta$2.alias) || [],
        redirect: (__nuxt_page_meta$2 == null ? void 0 : __nuxt_page_meta$2.redirect) || void 0,
        component: () => import('./_nuxt/mes-trajets-publies-1610ee3e.mjs').then((m) => m.default || m)
      }
    ],
    name: (__nuxt_page_meta$1 == null ? void 0 : __nuxt_page_meta$1.name) ?? void 0,
    meta: __nuxt_page_meta$1 || {},
    alias: (__nuxt_page_meta$1 == null ? void 0 : __nuxt_page_meta$1.alias) || [],
    redirect: (__nuxt_page_meta$1 == null ? void 0 : __nuxt_page_meta$1.redirect) || void 0,
    component: () => import('./_nuxt/dashboard-56d523a3.mjs').then((m) => m.default || m)
  },
  {
    name: "guide",
    path: "/guide",
    meta: {},
    alias: [],
    redirect: void 0,
    component: () => import('./_nuxt/guide-a381351b.mjs').then((m) => m.default || m)
  },
  {
    name: "index",
    path: "/",
    meta: {},
    alias: [],
    redirect: void 0,
    component: () => import('./_nuxt/index-9027a391.mjs').then((m) => m.default || m)
  },
  {
    name: "mentions-legales",
    path: "/mentions-legales",
    meta: {},
    alias: [],
    redirect: void 0,
    component: () => import('./_nuxt/mentions-legales-c8dc7aba.mjs').then((m) => m.default || m)
  },
  {
    name: "nos-services",
    path: "/nos-services",
    meta: {},
    alias: [],
    redirect: void 0,
    component: () => import('./_nuxt/nos-services-b1e05add.mjs').then((m) => m.default || m)
  },
  {
    name: "notre-concept",
    path: "/notre-concept",
    meta: {},
    alias: [],
    redirect: void 0,
    component: () => import('./_nuxt/notre-concept-c35b7610.mjs').then((m) => m.default || m)
  },
  {
    name: "politique-cookie",
    path: "/politique-cookie",
    meta: {},
    alias: [],
    redirect: void 0,
    component: () => import('./_nuxt/politique-cookie-887d2e5a.mjs').then((m) => m.default || m)
  },
  {
    name: "politique-de-confidentialite",
    path: "/politique-de-confidentialite",
    meta: {},
    alias: [],
    redirect: void 0,
    component: () => import('./_nuxt/politique-de-confidentialite-5213a0f5.mjs').then((m) => m.default || m)
  },
  {
    name: (__nuxt_page_meta == null ? void 0 : __nuxt_page_meta.name) ?? "publier-un-trajet",
    path: (__nuxt_page_meta == null ? void 0 : __nuxt_page_meta.path) ?? "/publier-un-trajet",
    meta: __nuxt_page_meta || {},
    alias: (__nuxt_page_meta == null ? void 0 : __nuxt_page_meta.alias) || [],
    redirect: (__nuxt_page_meta == null ? void 0 : __nuxt_page_meta.redirect) || void 0,
    component: () => import('./_nuxt/publier-un-trajet-dd220349.mjs').then((m) => m.default || m)
  },
  {
    name: "rechercher-un-trajet",
    path: "/rechercher-un-trajet",
    meta: {},
    alias: [],
    redirect: void 0,
    component: () => import('./_nuxt/rechercher-un-trajet-e081ce54.mjs').then((m) => m.default || m)
  },
  {
    name: "resultats",
    path: "/resultats",
    meta: {},
    alias: [],
    redirect: void 0,
    component: () => import('./_nuxt/resultats-7ae8b503.mjs').then((m) => m.default || m)
  }
];
const appHead = { "meta": [{ "name": "viewport", "content": "width=device-width, initial-scale=1" }, { "charset": "utf-8" }], "link": [], "style": [], "script": [], "noscript": [] };
const appLayoutTransition = false;
const appPageTransition = false;
const appKeepalive = false;
const routerOptions0 = {
  scrollBehavior(to, from, savedPosition) {
    const nuxtApp = useNuxtApp();
    let position = savedPosition || void 0;
    if (!position && from && to && to.meta.scrollToTop !== false && _isDifferentRoute(from, to)) {
      position = { left: 0, top: 0 };
    }
    if (to.path === from.path) {
      if (from.hash && !to.hash) {
        return { left: 0, top: 0 };
      }
      if (to.hash) {
        return { el: to.hash, top: _getHashElementScrollMarginTop(to.hash) };
      }
    }
    const hasTransition = (route) => !!(route.meta.pageTransition ?? appPageTransition);
    const hookToWait = hasTransition(from) && hasTransition(to) ? "page:transition:finish" : "page:finish";
    return new Promise((resolve) => {
      nuxtApp.hooks.hookOnce(hookToWait, async () => {
        await nextTick();
        if (to.hash) {
          position = { el: to.hash, top: _getHashElementScrollMarginTop(to.hash) };
        }
        resolve(position);
      });
    });
  }
};
function _getHashElementScrollMarginTop(selector) {
  try {
    const elem = document.querySelector(selector);
    if (elem) {
      return parseFloat(getComputedStyle(elem).scrollMarginTop);
    }
  } catch {
  }
  return 0;
}
function _isDifferentRoute(from, to) {
  const samePageComponent = to.matched.every((comp, index) => {
    var _a, _b, _c;
    return ((_a = comp.components) == null ? void 0 : _a.default) === ((_c = (_b = from.matched[index]) == null ? void 0 : _b.components) == null ? void 0 : _c.default);
  });
  if (!samePageComponent) {
    return true;
  }
  if (samePageComponent && JSON.stringify(from.params) !== JSON.stringify(to.params)) {
    return true;
  }
  return false;
}
const configRouterOptions = {};
const routerOptions = {
  ...configRouterOptions,
  ...routerOptions0
};
const validate = /* @__PURE__ */ defineNuxtRouteMiddleware(async (to) => {
  var _a;
  let __temp, __restore;
  if (!((_a = to.meta) == null ? void 0 : _a.validate)) {
    return;
  }
  useRouter();
  const result = ([__temp, __restore] = executeAsync(() => Promise.resolve(to.meta.validate(to))), __temp = await __temp, __restore(), __temp);
  if (result === true) {
    return;
  }
  {
    return result;
  }
});
const globalMiddleware = [
  validate
];
const namedMiddleware = {
  activated: () => import('./_nuxt/activated-e504d1aa.mjs'),
  auth: () => import('./_nuxt/auth-b8dcc0bc.mjs'),
  "mobile-verified": () => import('./_nuxt/mobile-verified-4be6dd56.mjs'),
  stripe: () => import('./_nuxt/stripe-4f5d1b9f.mjs'),
  subscribed: () => import('./_nuxt/subscribed-e6972b7e.mjs'),
  "valid-clearance": () => import('./_nuxt/valid-clearance-5f6a404c.mjs')
};
const plugin$1 = /* @__PURE__ */ defineNuxtPlugin({
  name: "nuxt:router",
  enforce: "pre",
  async setup(nuxtApp) {
    var _a, _b;
    let __temp, __restore;
    let routerBase = useRuntimeConfig().app.baseURL;
    if (routerOptions.hashMode && !routerBase.includes("#")) {
      routerBase += "#";
    }
    const history = ((_a = routerOptions.history) == null ? void 0 : _a.call(routerOptions, routerBase)) ?? createMemoryHistory(routerBase);
    const routes = ((_b = routerOptions.routes) == null ? void 0 : _b.call(routerOptions, _routes)) ?? _routes;
    let startPosition;
    const initialURL = nuxtApp.ssrContext.url;
    const router = createRouter({
      ...routerOptions,
      scrollBehavior: (to, from, savedPosition) => {
        var _a2;
        if (from === START_LOCATION) {
          startPosition = savedPosition;
          return;
        }
        router.options.scrollBehavior = routerOptions.scrollBehavior;
        return (_a2 = routerOptions.scrollBehavior) == null ? void 0 : _a2.call(routerOptions, to, START_LOCATION, startPosition || savedPosition);
      },
      history,
      routes
    });
    nuxtApp.vueApp.use(router);
    const previousRoute = shallowRef(router.currentRoute.value);
    router.afterEach((_to, from) => {
      previousRoute.value = from;
    });
    Object.defineProperty(nuxtApp.vueApp.config.globalProperties, "previousRoute", {
      get: () => previousRoute.value
    });
    const _route = shallowRef(router.resolve(initialURL));
    const syncCurrentRoute = () => {
      _route.value = router.currentRoute.value;
    };
    nuxtApp.hook("page:finish", syncCurrentRoute);
    router.afterEach((to, from) => {
      var _a2, _b2, _c, _d;
      if (((_b2 = (_a2 = to.matched[0]) == null ? void 0 : _a2.components) == null ? void 0 : _b2.default) === ((_d = (_c = from.matched[0]) == null ? void 0 : _c.components) == null ? void 0 : _d.default)) {
        syncCurrentRoute();
      }
    });
    const route = {};
    for (const key in _route.value) {
      route[key] = computed(() => _route.value[key]);
    }
    nuxtApp._route = reactive(route);
    nuxtApp._middleware = nuxtApp._middleware || {
      global: [],
      named: {}
    };
    useError();
    try {
      if (true) {
        ;
        [__temp, __restore] = executeAsync(() => router.push(initialURL)), await __temp, __restore();
        ;
      }
      ;
      [__temp, __restore] = executeAsync(() => router.isReady()), await __temp, __restore();
      ;
    } catch (error2) {
      [__temp, __restore] = executeAsync(() => nuxtApp.runWithContext(() => showError(error2))), await __temp, __restore();
    }
    const initialLayout = useState("_layout");
    router.beforeEach(async (to, from) => {
      var _a2, _b2;
      to.meta = reactive(to.meta);
      if (nuxtApp.isHydrating && initialLayout.value && !isReadonly(to.meta.layout)) {
        to.meta.layout = initialLayout.value;
      }
      nuxtApp._processingMiddleware = true;
      if (!((_a2 = nuxtApp.ssrContext) == null ? void 0 : _a2.islandContext)) {
        const middlewareEntries = /* @__PURE__ */ new Set([...globalMiddleware, ...nuxtApp._middleware.global]);
        for (const component of to.matched) {
          const componentMiddleware = component.meta.middleware;
          if (!componentMiddleware) {
            continue;
          }
          if (Array.isArray(componentMiddleware)) {
            for (const entry2 of componentMiddleware) {
              middlewareEntries.add(entry2);
            }
          } else {
            middlewareEntries.add(componentMiddleware);
          }
        }
        for (const entry2 of middlewareEntries) {
          const middleware = typeof entry2 === "string" ? nuxtApp._middleware.named[entry2] || await ((_b2 = namedMiddleware[entry2]) == null ? void 0 : _b2.call(namedMiddleware).then((r) => r.default || r)) : entry2;
          if (!middleware) {
            throw new Error(`Unknown route middleware: '${entry2}'.`);
          }
          const result = await nuxtApp.runWithContext(() => middleware(to, from));
          {
            if (result === false || result instanceof Error) {
              const error2 = result || createError$1({
                statusCode: 404,
                statusMessage: `Page Not Found: ${initialURL}`
              });
              await nuxtApp.runWithContext(() => showError(error2));
              return false;
            }
          }
          if (result || result === false) {
            return result;
          }
        }
      }
    });
    router.onError(() => {
      delete nuxtApp._processingMiddleware;
    });
    router.afterEach(async (to, _from, failure) => {
      var _a2;
      delete nuxtApp._processingMiddleware;
      if ((failure == null ? void 0 : failure.type) === 4) {
        return;
      }
      if (to.matched.length === 0 && !((_a2 = nuxtApp.ssrContext) == null ? void 0 : _a2.islandContext)) {
        await nuxtApp.runWithContext(() => showError(createError$1({
          statusCode: 404,
          fatal: false,
          statusMessage: `Page not found: ${to.fullPath}`
        })));
      } else if (to.redirectedFrom) {
        await nuxtApp.runWithContext(() => navigateTo(to.fullPath || "/"));
      }
    });
    nuxtApp.hooks.hookOnce("app:created", async () => {
      try {
        await router.replace({
          ...router.resolve(initialURL),
          name: void 0,
          // #4920, #4982
          force: true
        });
        router.options.scrollBehavior = routerOptions.scrollBehavior;
      } catch (error2) {
        await nuxtApp.runWithContext(() => showError(error2));
      }
    });
    return { provide: { router } };
  }
});
const isVue2 = false;
/*!
  * pinia v2.1.4
  * (c) 2023 Eduardo San Martin Morote
  * @license MIT
  */
let activePinia;
const setActivePinia = (pinia) => activePinia = pinia;
const piniaSymbol = (
  /* istanbul ignore next */
  Symbol()
);
function isPlainObject(o) {
  return o && typeof o === "object" && Object.prototype.toString.call(o) === "[object Object]" && typeof o.toJSON !== "function";
}
var MutationType;
(function(MutationType2) {
  MutationType2["direct"] = "direct";
  MutationType2["patchObject"] = "patch object";
  MutationType2["patchFunction"] = "patch function";
})(MutationType || (MutationType = {}));
function createPinia() {
  const scope = effectScope(true);
  const state = scope.run(() => ref({}));
  let _p = [];
  let toBeInstalled = [];
  const pinia = markRaw({
    install(app) {
      setActivePinia(pinia);
      {
        pinia._a = app;
        app.provide(piniaSymbol, pinia);
        app.config.globalProperties.$pinia = pinia;
        toBeInstalled.forEach((plugin2) => _p.push(plugin2));
        toBeInstalled = [];
      }
    },
    use(plugin2) {
      if (!this._a && !isVue2) {
        toBeInstalled.push(plugin2);
      } else {
        _p.push(plugin2);
      }
      return this;
    },
    _p,
    // it's actually undefined here
    // @ts-expect-error
    _a: null,
    _e: scope,
    _s: /* @__PURE__ */ new Map(),
    state
  });
  return pinia;
}
const noop = () => {
};
function addSubscription(subscriptions, callback, detached, onCleanup = noop) {
  subscriptions.push(callback);
  const removeSubscription = () => {
    const idx = subscriptions.indexOf(callback);
    if (idx > -1) {
      subscriptions.splice(idx, 1);
      onCleanup();
    }
  };
  if (!detached && getCurrentScope()) {
    onScopeDispose(removeSubscription);
  }
  return removeSubscription;
}
function triggerSubscriptions(subscriptions, ...args) {
  subscriptions.slice().forEach((callback) => {
    callback(...args);
  });
}
const fallbackRunWithContext = (fn) => fn();
function mergeReactiveObjects(target, patchToApply) {
  if (target instanceof Map && patchToApply instanceof Map) {
    patchToApply.forEach((value, key) => target.set(key, value));
  }
  if (target instanceof Set && patchToApply instanceof Set) {
    patchToApply.forEach(target.add, target);
  }
  for (const key in patchToApply) {
    if (!patchToApply.hasOwnProperty(key))
      continue;
    const subPatch = patchToApply[key];
    const targetValue = target[key];
    if (isPlainObject(targetValue) && isPlainObject(subPatch) && target.hasOwnProperty(key) && !isRef(subPatch) && !isReactive(subPatch)) {
      target[key] = mergeReactiveObjects(targetValue, subPatch);
    } else {
      target[key] = subPatch;
    }
  }
  return target;
}
const skipHydrateSymbol = (
  /* istanbul ignore next */
  Symbol()
);
function shouldHydrate(obj) {
  return !isPlainObject(obj) || !obj.hasOwnProperty(skipHydrateSymbol);
}
const { assign } = Object;
function isComputed(o) {
  return !!(isRef(o) && o.effect);
}
function createOptionsStore(id, options, pinia, hot) {
  const { state, actions, getters } = options;
  const initialState = pinia.state.value[id];
  let store;
  function setup() {
    if (!initialState && (!("production" !== "production") )) {
      {
        pinia.state.value[id] = state ? state() : {};
      }
    }
    const localState = toRefs(pinia.state.value[id]);
    return assign(localState, actions, Object.keys(getters || {}).reduce((computedGetters, name) => {
      computedGetters[name] = markRaw(computed(() => {
        setActivePinia(pinia);
        const store2 = pinia._s.get(id);
        return getters[name].call(store2, store2);
      }));
      return computedGetters;
    }, {}));
  }
  store = createSetupStore(id, setup, options, pinia, hot, true);
  return store;
}
function createSetupStore($id, setup, options = {}, pinia, hot, isOptionsStore) {
  let scope;
  const optionsForPlugin = assign({ actions: {} }, options);
  const $subscribeOptions = {
    deep: true
    // flush: 'post',
  };
  let isListening;
  let isSyncListening;
  let subscriptions = [];
  let actionSubscriptions = [];
  let debuggerEvents;
  const initialState = pinia.state.value[$id];
  if (!isOptionsStore && !initialState && (!("production" !== "production") )) {
    {
      pinia.state.value[$id] = {};
    }
  }
  ref({});
  let activeListener;
  function $patch(partialStateOrMutator) {
    let subscriptionMutation;
    isListening = isSyncListening = false;
    if (typeof partialStateOrMutator === "function") {
      partialStateOrMutator(pinia.state.value[$id]);
      subscriptionMutation = {
        type: MutationType.patchFunction,
        storeId: $id,
        events: debuggerEvents
      };
    } else {
      mergeReactiveObjects(pinia.state.value[$id], partialStateOrMutator);
      subscriptionMutation = {
        type: MutationType.patchObject,
        payload: partialStateOrMutator,
        storeId: $id,
        events: debuggerEvents
      };
    }
    const myListenerId = activeListener = Symbol();
    nextTick().then(() => {
      if (activeListener === myListenerId) {
        isListening = true;
      }
    });
    isSyncListening = true;
    triggerSubscriptions(subscriptions, subscriptionMutation, pinia.state.value[$id]);
  }
  const $reset = isOptionsStore ? function $reset2() {
    const { state } = options;
    const newState = state ? state() : {};
    this.$patch(($state) => {
      assign($state, newState);
    });
  } : (
    /* istanbul ignore next */
    noop
  );
  function $dispose() {
    scope.stop();
    subscriptions = [];
    actionSubscriptions = [];
    pinia._s.delete($id);
  }
  function wrapAction(name, action) {
    return function() {
      setActivePinia(pinia);
      const args = Array.from(arguments);
      const afterCallbackList = [];
      const onErrorCallbackList = [];
      function after(callback) {
        afterCallbackList.push(callback);
      }
      function onError(callback) {
        onErrorCallbackList.push(callback);
      }
      triggerSubscriptions(actionSubscriptions, {
        args,
        name,
        store,
        after,
        onError
      });
      let ret;
      try {
        ret = action.apply(this && this.$id === $id ? this : store, args);
      } catch (error) {
        triggerSubscriptions(onErrorCallbackList, error);
        throw error;
      }
      if (ret instanceof Promise) {
        return ret.then((value) => {
          triggerSubscriptions(afterCallbackList, value);
          return value;
        }).catch((error) => {
          triggerSubscriptions(onErrorCallbackList, error);
          return Promise.reject(error);
        });
      }
      triggerSubscriptions(afterCallbackList, ret);
      return ret;
    };
  }
  const partialStore = {
    _p: pinia,
    // _s: scope,
    $id,
    $onAction: addSubscription.bind(null, actionSubscriptions),
    $patch,
    $reset,
    $subscribe(callback, options2 = {}) {
      const removeSubscription = addSubscription(subscriptions, callback, options2.detached, () => stopWatcher());
      const stopWatcher = scope.run(() => watch(() => pinia.state.value[$id], (state) => {
        if (options2.flush === "sync" ? isSyncListening : isListening) {
          callback({
            storeId: $id,
            type: MutationType.direct,
            events: debuggerEvents
          }, state);
        }
      }, assign({}, $subscribeOptions, options2)));
      return removeSubscription;
    },
    $dispose
  };
  const store = reactive(partialStore);
  pinia._s.set($id, store);
  const runWithContext = pinia._a && pinia._a.runWithContext || fallbackRunWithContext;
  const setupStore = pinia._e.run(() => {
    scope = effectScope();
    return runWithContext(() => scope.run(setup));
  });
  for (const key in setupStore) {
    const prop = setupStore[key];
    if (isRef(prop) && !isComputed(prop) || isReactive(prop)) {
      if (!isOptionsStore) {
        if (initialState && shouldHydrate(prop)) {
          if (isRef(prop)) {
            prop.value = initialState[key];
          } else {
            mergeReactiveObjects(prop, initialState[key]);
          }
        }
        {
          pinia.state.value[$id][key] = prop;
        }
      }
    } else if (typeof prop === "function") {
      const actionValue = wrapAction(key, prop);
      {
        setupStore[key] = actionValue;
      }
      optionsForPlugin.actions[key] = prop;
    } else ;
  }
  {
    assign(store, setupStore);
    assign(toRaw(store), setupStore);
  }
  Object.defineProperty(store, "$state", {
    get: () => pinia.state.value[$id],
    set: (state) => {
      $patch(($state) => {
        assign($state, state);
      });
    }
  });
  pinia._p.forEach((extender) => {
    {
      assign(store, scope.run(() => extender({
        store,
        app: pinia._a,
        pinia,
        options: optionsForPlugin
      })));
    }
  });
  if (initialState && isOptionsStore && options.hydrate) {
    options.hydrate(store.$state, initialState);
  }
  isListening = true;
  isSyncListening = true;
  return store;
}
function defineStore(idOrOptions, setup, setupOptions) {
  let id;
  let options;
  const isSetupStore = typeof setup === "function";
  if (typeof idOrOptions === "string") {
    id = idOrOptions;
    options = isSetupStore ? setupOptions : setup;
  } else {
    options = idOrOptions;
    id = idOrOptions.id;
  }
  function useStore(pinia, hot) {
    const hasContext = hasInjectionContext();
    pinia = // in test mode, ignore the argument provided as we can always retrieve a
    // pinia instance with getActivePinia()
    (pinia) || (hasContext ? inject(piniaSymbol, null) : null);
    if (pinia)
      setActivePinia(pinia);
    pinia = activePinia;
    if (!pinia._s.has(id)) {
      if (isSetupStore) {
        createSetupStore(id, setup, options, pinia);
      } else {
        createOptionsStore(id, options, pinia);
      }
    }
    const store = pinia._s.get(id);
    return store;
  }
  useStore.$id = id;
  return useStore;
}
function resolveUnref(r) {
  return typeof r === "function" ? r() : unref(r);
}
function resolveUnrefHeadInput(ref2, lastKey = "") {
  if (ref2 instanceof Promise)
    return ref2;
  const root = resolveUnref(ref2);
  if (!ref2 || !root)
    return root;
  if (Array.isArray(root))
    return root.map((r) => resolveUnrefHeadInput(r, lastKey));
  if (typeof root === "object") {
    return Object.fromEntries(
      Object.entries(root).map(([k, v]) => {
        if (k === "titleTemplate" || k.startsWith("on"))
          return [k, unref(v)];
        return [k, resolveUnrefHeadInput(v, k)];
      })
    );
  }
  return root;
}
const Vue3 = version.startsWith("3");
const headSymbol = "usehead";
function injectHead() {
  return getCurrentInstance() && inject(headSymbol) || getActiveHead();
}
function vueInstall(head) {
  const plugin2 = {
    install(app) {
      if (Vue3) {
        app.config.globalProperties.$unhead = head;
        app.config.globalProperties.$head = head;
        app.provide(headSymbol, head);
      }
    }
  };
  return plugin2.install;
}
function createServerHead(options = {}) {
  const head = createServerHead$1({
    ...options,
    plugins: [
      VueReactiveUseHeadPlugin(),
      ...(options == null ? void 0 : options.plugins) || []
    ]
  });
  head.install = vueInstall(head);
  return head;
}
function VueReactiveUseHeadPlugin() {
  return defineHeadPlugin({
    hooks: {
      "entries:resolve": function(ctx) {
        for (const entry2 of ctx.entries)
          entry2.resolvedInput = resolveUnrefHeadInput(entry2.input);
      }
    }
  });
}
function clientUseHead(input, options = {}) {
  const head = injectHead();
  const deactivated = ref(false);
  const resolvedInput = ref({});
  watchEffect(() => {
    resolvedInput.value = deactivated.value ? {} : resolveUnrefHeadInput(input);
  });
  const entry2 = head.push(resolvedInput.value, options);
  watch(resolvedInput, (e) => {
    entry2.patch(e);
  });
  getCurrentInstance();
  return entry2;
}
function serverUseHead(input, options = {}) {
  const head = injectHead();
  return head.push(input, options);
}
function useHead(input, options = {}) {
  var _a;
  const head = injectHead();
  if (head) {
    const isBrowser = !!((_a = head.resolvedOptions) == null ? void 0 : _a.document);
    if (options.mode === "server" && isBrowser || options.mode === "client" && !isBrowser)
      return;
    return isBrowser ? clientUseHead(input, options) : serverUseHead(input, options);
  }
}
function definePayloadReducer(name, reduce) {
  {
    useNuxtApp().ssrContext._payloadReducers[name] = reduce;
  }
}
const plugin = /* @__PURE__ */ defineNuxtPlugin((nuxtApp) => {
  const pinia = createPinia();
  nuxtApp.vueApp.use(pinia);
  setActivePinia(pinia);
  {
    nuxtApp.payload.pinia = pinia.state.value;
  }
  return {
    provide: {
      pinia
    }
  };
});
const reducers = {
  NuxtError: (data) => isNuxtError(data) && data.toJSON(),
  EmptyShallowRef: (data) => isRef(data) && isShallow(data) && !data.value && (typeof data.value === "bigint" ? "0n" : JSON.stringify(data.value) || "_"),
  EmptyRef: (data) => isRef(data) && !data.value && (typeof data.value === "bigint" ? "0n" : JSON.stringify(data.value) || "_"),
  ShallowRef: (data) => isRef(data) && isShallow(data) && data.value,
  ShallowReactive: (data) => isReactive(data) && isShallow(data) && toRaw(data),
  Ref: (data) => isRef(data) && data.value,
  Reactive: (data) => isReactive(data) && toRaw(data)
};
const revive_payload_server_eJ33V7gbc6 = /* @__PURE__ */ defineNuxtPlugin({
  name: "nuxt:revive-payload:server",
  setup() {
    for (const reducer in reducers) {
      definePayloadReducer(reducer, reducers[reducer]);
    }
  }
});
const components_plugin_KR1HBZs4kY = /* @__PURE__ */ defineNuxtPlugin({
  name: "nuxt:global-components"
});
const unhead_KgADcZ0jPj = /* @__PURE__ */ defineNuxtPlugin({
  name: "nuxt:head",
  setup(nuxtApp) {
    const createHead = createServerHead;
    const head = createHead();
    head.push(appHead);
    nuxtApp.vueApp.use(head);
    {
      nuxtApp.ssrContext.renderMeta = async () => {
        const meta = await renderSSRHead(head);
        return {
          ...meta,
          bodyScriptsPrepend: meta.bodyTagsOpen,
          // resolves naming difference with NuxtMeta and Unhead
          bodyScripts: meta.bodyTags
        };
      };
    }
  }
});
dayjs.extend(relativeTime);
dayjs.extend(utc);
dayjs.extend(timezone);
dayjs.locale("fr");
dayjs.tz.setDefault("Europe/Paris");
const plugin_8SbxDRbG6Y = /* @__PURE__ */ defineNuxtPlugin(async (nuxtApp) => nuxtApp.provide("dayjs", dayjs));
const headless_ui_sXgzlVd9r2 = /* @__PURE__ */ defineNuxtPlugin((nuxtApp) => {
  nuxtApp.vueApp.component("Popover", Popover);
  nuxtApp.vueApp.component("PopoverButton", PopoverButton);
  nuxtApp.vueApp.component("PopoverPanel", PopoverPanel);
});
const i18n_sVHQBgnb3t = /* @__PURE__ */ defineNuxtPlugin(({ vueApp }) => {
  const i18n = createI18n({
    legacy: false,
    globalInjection: true,
    locale: "fr",
    numberFormats: {
      fr: {
        currency: {
          style: "currency",
          currency: "EUR"
        },
        decimal: {
          style: "decimal",
          minimumFractionDigits: 2,
          maximumFractionDigits: 2
        },
        percent: {
          style: "percent"
        }
      }
    },
    messages: {
      fr: {}
    }
  });
  vueApp.use(i18n);
});
const popper_KwS8fMgSzV = /* @__PURE__ */ defineNuxtPlugin((nuxtApp) => {
  nuxtApp.vueApp.component("Popper", Popper);
});
var DomHandler = {
  innerWidth(el) {
    if (el) {
      let width = el.offsetWidth;
      let style = getComputedStyle(el);
      width += parseFloat(style.paddingLeft) + parseFloat(style.paddingRight);
      return width;
    }
    return 0;
  },
  width(el) {
    if (el) {
      let width = el.offsetWidth;
      let style = getComputedStyle(el);
      width -= parseFloat(style.paddingLeft) + parseFloat(style.paddingRight);
      return width;
    }
    return 0;
  },
  getWindowScrollTop() {
    let doc = document.documentElement;
    return (window.pageYOffset || doc.scrollTop) - (doc.clientTop || 0);
  },
  getWindowScrollLeft() {
    let doc = document.documentElement;
    return (window.pageXOffset || doc.scrollLeft) - (doc.clientLeft || 0);
  },
  getOuterWidth(el, margin) {
    if (el) {
      let width = el.offsetWidth;
      if (margin) {
        let style = getComputedStyle(el);
        width += parseFloat(style.marginLeft) + parseFloat(style.marginRight);
      }
      return width;
    }
    return 0;
  },
  getOuterHeight(el, margin) {
    if (el) {
      let height = el.offsetHeight;
      if (margin) {
        let style = getComputedStyle(el);
        height += parseFloat(style.marginTop) + parseFloat(style.marginBottom);
      }
      return height;
    }
    return 0;
  },
  getClientHeight(el, margin) {
    if (el) {
      let height = el.clientHeight;
      if (margin) {
        let style = getComputedStyle(el);
        height += parseFloat(style.marginTop) + parseFloat(style.marginBottom);
      }
      return height;
    }
    return 0;
  },
  getViewport() {
    let win = window, d = document, e = d.documentElement, g = d.getElementsByTagName("body")[0], w = win.innerWidth || e.clientWidth || g.clientWidth, h2 = win.innerHeight || e.clientHeight || g.clientHeight;
    return { width: w, height: h2 };
  },
  getOffset(el) {
    if (el) {
      let rect = el.getBoundingClientRect();
      return {
        top: rect.top + (window.pageYOffset || document.documentElement.scrollTop || document.body.scrollTop || 0),
        left: rect.left + (window.pageXOffset || document.documentElement.scrollLeft || document.body.scrollLeft || 0)
      };
    }
    return {
      top: "auto",
      left: "auto"
    };
  },
  index(element) {
    if (element) {
      let children = element.parentNode.childNodes;
      let num = 0;
      for (let i = 0; i < children.length; i++) {
        if (children[i] === element)
          return num;
        if (children[i].nodeType === 1)
          num++;
      }
    }
    return -1;
  },
  addMultipleClasses(element, className) {
    if (element && className) {
      if (element.classList) {
        let styles = className.split(" ");
        for (let i = 0; i < styles.length; i++) {
          element.classList.add(styles[i]);
        }
      } else {
        let styles = className.split(" ");
        for (let i = 0; i < styles.length; i++) {
          element.className += " " + styles[i];
        }
      }
    }
  },
  addClass(element, className) {
    if (element && className) {
      if (element.classList)
        element.classList.add(className);
      else
        element.className += " " + className;
    }
  },
  removeClass(element, className) {
    if (element && className) {
      if (element.classList)
        element.classList.remove(className);
      else
        element.className = element.className.replace(new RegExp("(^|\\b)" + className.split(" ").join("|") + "(\\b|$)", "gi"), " ");
    }
  },
  hasClass(element, className) {
    if (element) {
      if (element.classList)
        return element.classList.contains(className);
      else
        return new RegExp("(^| )" + className + "( |$)", "gi").test(element.className);
    }
    return false;
  },
  find(element, selector) {
    return this.isElement(element) ? element.querySelectorAll(selector) : [];
  },
  findSingle(element, selector) {
    return this.isElement(element) ? element.querySelector(selector) : null;
  },
  getHeight(el) {
    if (el) {
      let height = el.offsetHeight;
      let style = getComputedStyle(el);
      height -= parseFloat(style.paddingTop) + parseFloat(style.paddingBottom) + parseFloat(style.borderTopWidth) + parseFloat(style.borderBottomWidth);
      return height;
    }
    return 0;
  },
  getWidth(el) {
    if (el) {
      let width = el.offsetWidth;
      let style = getComputedStyle(el);
      width -= parseFloat(style.paddingLeft) + parseFloat(style.paddingRight) + parseFloat(style.borderLeftWidth) + parseFloat(style.borderRightWidth);
      return width;
    }
    return 0;
  },
  absolutePosition(element, target) {
    if (element) {
      let elementDimensions = element.offsetParent ? { width: element.offsetWidth, height: element.offsetHeight } : this.getHiddenElementDimensions(element);
      let elementOuterHeight = elementDimensions.height;
      let elementOuterWidth = elementDimensions.width;
      let targetOuterHeight = target.offsetHeight;
      let targetOuterWidth = target.offsetWidth;
      let targetOffset = target.getBoundingClientRect();
      let windowScrollTop = this.getWindowScrollTop();
      let windowScrollLeft = this.getWindowScrollLeft();
      let viewport = this.getViewport();
      let top, left;
      if (targetOffset.top + targetOuterHeight + elementOuterHeight > viewport.height) {
        top = targetOffset.top + windowScrollTop - elementOuterHeight;
        element.style.transformOrigin = "bottom";
        if (top < 0) {
          top = windowScrollTop;
        }
      } else {
        top = targetOuterHeight + targetOffset.top + windowScrollTop;
        element.style.transformOrigin = "top";
      }
      if (targetOffset.left + elementOuterWidth > viewport.width)
        left = Math.max(0, targetOffset.left + windowScrollLeft + targetOuterWidth - elementOuterWidth);
      else
        left = targetOffset.left + windowScrollLeft;
      element.style.top = top + "px";
      element.style.left = left + "px";
    }
  },
  relativePosition(element, target) {
    if (element) {
      let elementDimensions = element.offsetParent ? { width: element.offsetWidth, height: element.offsetHeight } : this.getHiddenElementDimensions(element);
      const targetHeight = target.offsetHeight;
      const targetOffset = target.getBoundingClientRect();
      const viewport = this.getViewport();
      let top, left;
      if (targetOffset.top + targetHeight + elementDimensions.height > viewport.height) {
        top = -1 * elementDimensions.height;
        element.style.transformOrigin = "bottom";
        if (targetOffset.top + top < 0) {
          top = -1 * targetOffset.top;
        }
      } else {
        top = targetHeight;
        element.style.transformOrigin = "top";
      }
      if (elementDimensions.width > viewport.width) {
        left = targetOffset.left * -1;
      } else if (targetOffset.left + elementDimensions.width > viewport.width) {
        left = (targetOffset.left + elementDimensions.width - viewport.width) * -1;
      } else {
        left = 0;
      }
      element.style.top = top + "px";
      element.style.left = left + "px";
    }
  },
  getParents(element, parents = []) {
    return element["parentNode"] === null ? parents : this.getParents(element.parentNode, parents.concat([element.parentNode]));
  },
  getScrollableParents(element) {
    let scrollableParents = [];
    if (element) {
      let parents = this.getParents(element);
      const overflowRegex = /(auto|scroll)/;
      const overflowCheck = (node) => {
        let styleDeclaration = window["getComputedStyle"](node, null);
        return overflowRegex.test(styleDeclaration.getPropertyValue("overflow")) || overflowRegex.test(styleDeclaration.getPropertyValue("overflowX")) || overflowRegex.test(styleDeclaration.getPropertyValue("overflowY"));
      };
      for (let parent of parents) {
        let scrollSelectors = parent.nodeType === 1 && parent.dataset["scrollselectors"];
        if (scrollSelectors) {
          let selectors = scrollSelectors.split(",");
          for (let selector of selectors) {
            let el = this.findSingle(parent, selector);
            if (el && overflowCheck(el)) {
              scrollableParents.push(el);
            }
          }
        }
        if (parent.nodeType !== 9 && overflowCheck(parent)) {
          scrollableParents.push(parent);
        }
      }
    }
    return scrollableParents;
  },
  getHiddenElementOuterHeight(element) {
    if (element) {
      element.style.visibility = "hidden";
      element.style.display = "block";
      let elementHeight = element.offsetHeight;
      element.style.display = "none";
      element.style.visibility = "visible";
      return elementHeight;
    }
    return 0;
  },
  getHiddenElementOuterWidth(element) {
    if (element) {
      element.style.visibility = "hidden";
      element.style.display = "block";
      let elementWidth = element.offsetWidth;
      element.style.display = "none";
      element.style.visibility = "visible";
      return elementWidth;
    }
    return 0;
  },
  getHiddenElementDimensions(element) {
    if (element) {
      let dimensions = {};
      element.style.visibility = "hidden";
      element.style.display = "block";
      dimensions.width = element.offsetWidth;
      dimensions.height = element.offsetHeight;
      element.style.display = "none";
      element.style.visibility = "visible";
      return dimensions;
    }
    return 0;
  },
  fadeIn(element, duration) {
    if (element) {
      element.style.opacity = 0;
      let last = +/* @__PURE__ */ new Date();
      let opacity = 0;
      let tick = function() {
        opacity = +element.style.opacity + ((/* @__PURE__ */ new Date()).getTime() - last) / duration;
        element.style.opacity = opacity;
        last = +/* @__PURE__ */ new Date();
        if (+opacity < 1) {
          window.requestAnimationFrame && requestAnimationFrame(tick) || setTimeout(tick, 16);
        }
      };
      tick();
    }
  },
  fadeOut(element, ms) {
    if (element) {
      let opacity = 1, interval = 50, duration = ms, gap = interval / duration;
      let fading = setInterval(() => {
        opacity -= gap;
        if (opacity <= 0) {
          opacity = 0;
          clearInterval(fading);
        }
        element.style.opacity = opacity;
      }, interval);
    }
  },
  getUserAgent() {
    return navigator.userAgent;
  },
  appendChild(element, target) {
    if (this.isElement(target))
      target.appendChild(element);
    else if (target.el && target.elElement)
      target.elElement.appendChild(element);
    else
      throw new Error("Cannot append " + target + " to " + element);
  },
  isElement(obj) {
    return typeof HTMLElement === "object" ? obj instanceof HTMLElement : obj && typeof obj === "object" && obj !== null && obj.nodeType === 1 && typeof obj.nodeName === "string";
  },
  scrollInView(container, item) {
    let borderTopValue = getComputedStyle(container).getPropertyValue("borderTopWidth");
    let borderTop = borderTopValue ? parseFloat(borderTopValue) : 0;
    let paddingTopValue = getComputedStyle(container).getPropertyValue("paddingTop");
    let paddingTop = paddingTopValue ? parseFloat(paddingTopValue) : 0;
    let containerRect = container.getBoundingClientRect();
    let itemRect = item.getBoundingClientRect();
    let offset = itemRect.top + document.body.scrollTop - (containerRect.top + document.body.scrollTop) - borderTop - paddingTop;
    let scroll = container.scrollTop;
    let elementHeight = container.clientHeight;
    let itemHeight = this.getOuterHeight(item);
    if (offset < 0) {
      container.scrollTop = scroll + offset;
    } else if (offset + itemHeight > elementHeight) {
      container.scrollTop = scroll + offset - elementHeight + itemHeight;
    }
  },
  clearSelection() {
    if (window.getSelection) {
      if (window.getSelection().empty) {
        window.getSelection().empty();
      } else if (window.getSelection().removeAllRanges && window.getSelection().rangeCount > 0 && window.getSelection().getRangeAt(0).getClientRects().length > 0) {
        window.getSelection().removeAllRanges();
      }
    } else if (document["selection"] && document["selection"].empty) {
      try {
        document["selection"].empty();
      } catch (error) {
      }
    }
  },
  getSelection() {
    if (window.getSelection)
      return window.getSelection().toString();
    else if (document.getSelection)
      return document.getSelection().toString();
    else if (document["selection"])
      return document["selection"].createRange().text;
    return null;
  },
  calculateScrollbarWidth() {
    if (this.calculatedScrollbarWidth != null)
      return this.calculatedScrollbarWidth;
    let scrollDiv = document.createElement("div");
    scrollDiv.className = "p-scrollbar-measure";
    document.body.appendChild(scrollDiv);
    let scrollbarWidth = scrollDiv.offsetWidth - scrollDiv.clientWidth;
    document.body.removeChild(scrollDiv);
    this.calculatedScrollbarWidth = scrollbarWidth;
    return scrollbarWidth;
  },
  getBrowser() {
    if (!this.browser) {
      let matched = this.resolveUserAgent();
      this.browser = {};
      if (matched.browser) {
        this.browser[matched.browser] = true;
        this.browser["version"] = matched.version;
      }
      if (this.browser["chrome"]) {
        this.browser["webkit"] = true;
      } else if (this.browser["webkit"]) {
        this.browser["safari"] = true;
      }
    }
    return this.browser;
  },
  resolveUserAgent() {
    let ua = navigator.userAgent.toLowerCase();
    let match = /(chrome)[ ]([\w.]+)/.exec(ua) || /(webkit)[ ]([\w.]+)/.exec(ua) || /(opera)(?:.*version|)[ ]([\w.]+)/.exec(ua) || /(msie) ([\w.]+)/.exec(ua) || ua.indexOf("compatible") < 0 && /(mozilla)(?:.*? rv:([\w.]+)|)/.exec(ua) || [];
    return {
      browser: match[1] || "",
      version: match[2] || "0"
    };
  },
  isVisible(element) {
    return element && element.offsetParent != null;
  },
  invokeElementMethod(element, methodName, args) {
    element[methodName].apply(element, args);
  },
  isExist(element) {
    return !!(element !== null && typeof element !== "undefined" && element.nodeName && element.parentNode);
  },
  isClient() {
    return false;
  },
  focus(el, options) {
    el && document.activeElement !== el && el.focus(options);
  },
  isFocusableElement(element, selector = "") {
    return this.isElement(element) ? element.matches(`button:not([tabindex = "-1"]):not([disabled]):not([style*="display:none"]):not([hidden])${selector},
                [href][clientHeight][clientWidth]:not([tabindex = "-1"]):not([disabled]):not([style*="display:none"]):not([hidden])${selector},
                input:not([tabindex = "-1"]):not([disabled]):not([style*="display:none"]):not([hidden])${selector},
                select:not([tabindex = "-1"]):not([disabled]):not([style*="display:none"]):not([hidden])${selector},
                textarea:not([tabindex = "-1"]):not([disabled]):not([style*="display:none"]):not([hidden])${selector},
                [tabIndex]:not([tabIndex = "-1"]):not([disabled]):not([style*="display:none"]):not([hidden])${selector},
                [contenteditable]:not([tabIndex = "-1"]):not([disabled]):not([style*="display:none"]):not([hidden])${selector}`) : false;
  },
  getFocusableElements(element, selector = "") {
    let focusableElements = this.find(
      element,
      `button:not([tabindex = "-1"]):not([disabled]):not([style*="display:none"]):not([hidden])${selector},
                [href][clientHeight][clientWidth]:not([tabindex = "-1"]):not([disabled]):not([style*="display:none"]):not([hidden])${selector},
                input:not([tabindex = "-1"]):not([disabled]):not([style*="display:none"]):not([hidden])${selector},
                select:not([tabindex = "-1"]):not([disabled]):not([style*="display:none"]):not([hidden])${selector},
                textarea:not([tabindex = "-1"]):not([disabled]):not([style*="display:none"]):not([hidden])${selector},
                [tabIndex]:not([tabIndex = "-1"]):not([disabled]):not([style*="display:none"]):not([hidden])${selector},
                [contenteditable]:not([tabIndex = "-1"]):not([disabled]):not([style*="display:none"]):not([hidden])${selector}`
    );
    let visibleFocusableElements = [];
    for (let focusableElement of focusableElements) {
      if (getComputedStyle(focusableElement).display != "none" && getComputedStyle(focusableElement).visibility != "hidden")
        visibleFocusableElements.push(focusableElement);
    }
    return visibleFocusableElements;
  },
  getFirstFocusableElement(element, selector) {
    const focusableElements = this.getFocusableElements(element, selector);
    return focusableElements.length > 0 ? focusableElements[0] : null;
  },
  getLastFocusableElement(element, selector) {
    const focusableElements = this.getFocusableElements(element, selector);
    return focusableElements.length > 0 ? focusableElements[focusableElements.length - 1] : null;
  },
  getNextFocusableElement(container, element, selector) {
    const focusableElements = this.getFocusableElements(container, selector);
    const index = focusableElements.length > 0 ? focusableElements.findIndex((el) => el === element) : -1;
    const nextIndex = index > -1 && focusableElements.length >= index + 1 ? index + 1 : -1;
    return nextIndex > -1 ? focusableElements[nextIndex] : null;
  },
  isClickable(element) {
    if (element) {
      const targetNode = element.nodeName;
      const parentNode = element.parentElement && element.parentElement.nodeName;
      return targetNode === "INPUT" || targetNode === "TEXTAREA" || targetNode === "BUTTON" || targetNode === "A" || parentNode === "INPUT" || parentNode === "TEXTAREA" || parentNode === "BUTTON" || parentNode === "A" || !!element.closest(".p-button, .p-checkbox, .p-radiobutton");
    }
    return false;
  },
  applyStyle(element, style) {
    if (typeof style === "string") {
      element.style.cssText = style;
    } else {
      for (let prop in style) {
        element.style[prop] = style[prop];
      }
    }
  },
  isIOS() {
    return /iPad|iPhone|iPod/.test(navigator.userAgent) && !window["MSStream"];
  },
  isAndroid() {
    return /(android)/i.test(navigator.userAgent);
  },
  isTouchDevice() {
    return "ontouchstart" in window || navigator.maxTouchPoints > 0 || navigator.msMaxTouchPoints > 0;
  },
  exportCSV(csv, filename) {
    let blob = new Blob([csv], {
      type: "application/csv;charset=utf-8;"
    });
    if (window.navigator.msSaveOrOpenBlob) {
      navigator.msSaveOrOpenBlob(blob, filename + ".csv");
    } else {
      let link = document.createElement("a");
      if (link.download !== void 0) {
        link.setAttribute("href", URL.createObjectURL(blob));
        link.setAttribute("download", filename + ".csv");
        link.style.display = "none";
        document.body.appendChild(link);
        link.click();
        document.body.removeChild(link);
      } else {
        csv = "data:text/csv;charset=utf-8," + csv;
        window.open(encodeURI(csv));
      }
    }
  }
};
class ConnectedOverlayScrollHandler {
  constructor(element, listener = () => {
  }) {
    this.element = element;
    this.listener = listener;
  }
  bindScrollListener() {
    this.scrollableParents = DomHandler.getScrollableParents(this.element);
    for (let i = 0; i < this.scrollableParents.length; i++) {
      this.scrollableParents[i].addEventListener("scroll", this.listener);
    }
  }
  unbindScrollListener() {
    if (this.scrollableParents) {
      for (let i = 0; i < this.scrollableParents.length; i++) {
        this.scrollableParents[i].removeEventListener("scroll", this.listener);
      }
    }
  }
  destroy() {
    this.unbindScrollListener();
    this.element = null;
    this.listener = null;
    this.scrollableParents = null;
  }
}
function primebus() {
  const allHandlers = /* @__PURE__ */ new Map();
  return {
    on(type, handler2) {
      let handlers = allHandlers.get(type);
      if (!handlers)
        handlers = [handler2];
      else
        handlers.push(handler2);
      allHandlers.set(type, handlers);
    },
    off(type, handler2) {
      let handlers = allHandlers.get(type);
      if (handlers) {
        handlers.splice(handlers.indexOf(handler2) >>> 0, 1);
      }
    },
    emit(type, evt) {
      let handlers = allHandlers.get(type);
      if (handlers) {
        handlers.slice().map((handler2) => {
          handler2(evt);
        });
      }
    }
  };
}
var ObjectUtils = {
  equals(obj1, obj2, field) {
    if (field)
      return this.resolveFieldData(obj1, field) === this.resolveFieldData(obj2, field);
    else
      return this.deepEquals(obj1, obj2);
  },
  deepEquals(a, b) {
    if (a === b)
      return true;
    if (a && b && typeof a == "object" && typeof b == "object") {
      var arrA = Array.isArray(a), arrB = Array.isArray(b), i, length, key;
      if (arrA && arrB) {
        length = a.length;
        if (length != b.length)
          return false;
        for (i = length; i-- !== 0; )
          if (!this.deepEquals(a[i], b[i]))
            return false;
        return true;
      }
      if (arrA != arrB)
        return false;
      var dateA = a instanceof Date, dateB = b instanceof Date;
      if (dateA != dateB)
        return false;
      if (dateA && dateB)
        return a.getTime() == b.getTime();
      var regexpA = a instanceof RegExp, regexpB = b instanceof RegExp;
      if (regexpA != regexpB)
        return false;
      if (regexpA && regexpB)
        return a.toString() == b.toString();
      var keys = Object.keys(a);
      length = keys.length;
      if (length !== Object.keys(b).length)
        return false;
      for (i = length; i-- !== 0; )
        if (!Object.prototype.hasOwnProperty.call(b, keys[i]))
          return false;
      for (i = length; i-- !== 0; ) {
        key = keys[i];
        if (!this.deepEquals(a[key], b[key]))
          return false;
      }
      return true;
    }
    return a !== a && b !== b;
  },
  resolveFieldData(data, field) {
    if (data && Object.keys(data).length && field) {
      if (this.isFunction(field)) {
        return field(data);
      } else if (field.indexOf(".") === -1) {
        return data[field];
      } else {
        let fields = field.split(".");
        let value = data;
        for (var i = 0, len = fields.length; i < len; ++i) {
          if (value == null) {
            return null;
          }
          value = value[fields[i]];
        }
        return value;
      }
    } else {
      return null;
    }
  },
  isFunction(obj) {
    return !!(obj && obj.constructor && obj.call && obj.apply);
  },
  getItemValue(obj, ...params) {
    return this.isFunction(obj) ? obj(...params) : obj;
  },
  filter(value, fields, filterValue) {
    var filteredItems = [];
    if (value) {
      for (let item of value) {
        for (let field of fields) {
          if (String(this.resolveFieldData(item, field)).toLowerCase().indexOf(filterValue.toLowerCase()) > -1) {
            filteredItems.push(item);
            break;
          }
        }
      }
    }
    return filteredItems;
  },
  reorderArray(value, from, to) {
    if (value && from !== to) {
      if (to >= value.length) {
        to %= value.length;
        from %= value.length;
      }
      value.splice(to, 0, value.splice(from, 1)[0]);
    }
  },
  findIndexInList(value, list) {
    let index = -1;
    if (list) {
      for (let i = 0; i < list.length; i++) {
        if (list[i] === value) {
          index = i;
          break;
        }
      }
    }
    return index;
  },
  contains(value, list) {
    if (value != null && list && list.length) {
      for (let val of list) {
        if (this.equals(value, val))
          return true;
      }
    }
    return false;
  },
  insertIntoOrderedArray(item, index, arr, sourceArr) {
    if (arr.length > 0) {
      let injected = false;
      for (let i = 0; i < arr.length; i++) {
        let currentItemIndex = this.findIndexInList(arr[i], sourceArr);
        if (currentItemIndex > index) {
          arr.splice(i, 0, item);
          injected = true;
          break;
        }
      }
      if (!injected) {
        arr.push(item);
      }
    } else {
      arr.push(item);
    }
  },
  removeAccents(str) {
    if (str && str.search(/[\xC0-\xFF]/g) > -1) {
      str = str.replace(/[\xC0-\xC5]/g, "A").replace(/[\xC6]/g, "AE").replace(/[\xC7]/g, "C").replace(/[\xC8-\xCB]/g, "E").replace(/[\xCC-\xCF]/g, "I").replace(/[\xD0]/g, "D").replace(/[\xD1]/g, "N").replace(/[\xD2-\xD6\xD8]/g, "O").replace(/[\xD9-\xDC]/g, "U").replace(/[\xDD]/g, "Y").replace(/[\xDE]/g, "P").replace(/[\xE0-\xE5]/g, "a").replace(/[\xE6]/g, "ae").replace(/[\xE7]/g, "c").replace(/[\xE8-\xEB]/g, "e").replace(/[\xEC-\xEF]/g, "i").replace(/[\xF1]/g, "n").replace(/[\xF2-\xF6\xF8]/g, "o").replace(/[\xF9-\xFC]/g, "u").replace(/[\xFE]/g, "p").replace(/[\xFD\xFF]/g, "y");
    }
    return str;
  },
  getVNodeProp(vnode, prop) {
    let props = vnode.props;
    if (props) {
      let kebapProp = prop.replace(/([a-z])([A-Z])/g, "$1-$2").toLowerCase();
      let propName = Object.prototype.hasOwnProperty.call(props, kebapProp) ? kebapProp : prop;
      return vnode.type.props[prop].type === Boolean && props[propName] === "" ? true : props[propName];
    }
    return null;
  },
  convertToFlatCase(str) {
    return this.isNotEmpty(str) ? str.replace(/(-|_)/g, "").toLowerCase() : str;
  },
  isEmpty(value) {
    return value === null || value === void 0 || value === "" || Array.isArray(value) && value.length === 0 || !(value instanceof Date) && typeof value === "object" && Object.keys(value).length === 0;
  },
  isNotEmpty(value) {
    return !this.isEmpty(value);
  },
  isPrintableCharacter(char = "") {
    return this.isNotEmpty(char) && char.length === 1 && char.match(/\S| /);
  },
  /**
   * Firefox-v103 does not currently support the "findLast" method. It is stated that this method will be supported with Firefox-v104.
   * https://caniuse.com/mdn-javascript_builtins_array_findlast
   */
  findLast(arr, callback) {
    let item;
    if (this.isNotEmpty(arr)) {
      try {
        item = arr.findLast(callback);
      } catch {
        item = [...arr].reverse().find(callback);
      }
    }
    return item;
  },
  /**
   * Firefox-v103 does not currently support the "findLastIndex" method. It is stated that this method will be supported with Firefox-v104.
   * https://caniuse.com/mdn-javascript_builtins_array_findlastindex
   */
  findLastIndex(arr, callback) {
    let index = -1;
    if (this.isNotEmpty(arr)) {
      try {
        index = arr.findLastIndex(callback);
      } catch {
        index = arr.lastIndexOf([...arr].reverse().find(callback));
      }
    }
    return index;
  }
};
var lastId = 0;
function UniqueComponentId(prefix = "pv_id_") {
  lastId++;
  return `${prefix}${lastId}`;
}
function handler() {
  let zIndexes = [];
  const generateZIndex = (key, autoZIndex, baseZIndex = 999) => {
    const lastZIndex = getLastZIndex(key, autoZIndex, baseZIndex);
    const newZIndex = lastZIndex.value + (lastZIndex.key === key ? 0 : baseZIndex) + 1;
    zIndexes.push({ key, value: newZIndex });
    return newZIndex;
  };
  const revertZIndex = (zIndex) => {
    zIndexes = zIndexes.filter((obj) => obj.value !== zIndex);
  };
  const getCurrentZIndex = (key, autoZIndex) => {
    return getLastZIndex(key, autoZIndex).value;
  };
  const getLastZIndex = (key, autoZIndex, baseZIndex = 0) => {
    return [...zIndexes].reverse().find((obj) => autoZIndex ? true : obj.key === key) || { key, value: baseZIndex };
  };
  const getZIndex = (el) => {
    return el ? parseInt(el.style.zIndex, 10) || 0 : 0;
  };
  return {
    get: getZIndex,
    set: (key, el, baseZIndex) => {
      if (el) {
        el.style.zIndex = String(generateZIndex(key, true, baseZIndex));
      }
    },
    clear: (el) => {
      if (el) {
        revertZIndex(getZIndex(el));
        el.style.zIndex = "";
      }
    },
    getCurrent: (key) => getCurrentZIndex(key, true)
  };
}
var ZIndexUtils = handler();
const FilterMatchMode = {
  STARTS_WITH: "startsWith",
  CONTAINS: "contains",
  NOT_CONTAINS: "notContains",
  ENDS_WITH: "endsWith",
  EQUALS: "equals",
  NOT_EQUALS: "notEquals",
  IN: "in",
  LESS_THAN: "lt",
  LESS_THAN_OR_EQUAL_TO: "lte",
  GREATER_THAN: "gt",
  GREATER_THAN_OR_EQUAL_TO: "gte",
  BETWEEN: "between",
  DATE_IS: "dateIs",
  DATE_IS_NOT: "dateIsNot",
  DATE_BEFORE: "dateBefore",
  DATE_AFTER: "dateAfter"
};
const FilterOperator = {
  AND: "and",
  OR: "or"
};
const FilterService = {
  filter(value, fields, filterValue, filterMatchMode, filterLocale) {
    let filteredItems = [];
    if (value) {
      for (let item of value) {
        for (let field of fields) {
          let fieldValue = ObjectUtils.resolveFieldData(item, field);
          if (this.filters[filterMatchMode](fieldValue, filterValue, filterLocale)) {
            filteredItems.push(item);
            break;
          }
        }
      }
    }
    return filteredItems;
  },
  filters: {
    startsWith(value, filter, filterLocale) {
      if (filter === void 0 || filter === null || filter.trim() === "") {
        return true;
      }
      if (value === void 0 || value === null) {
        return false;
      }
      let filterValue = ObjectUtils.removeAccents(filter.toString()).toLocaleLowerCase(filterLocale);
      let stringValue = ObjectUtils.removeAccents(value.toString()).toLocaleLowerCase(filterLocale);
      return stringValue.slice(0, filterValue.length) === filterValue;
    },
    contains(value, filter, filterLocale) {
      if (filter === void 0 || filter === null || typeof filter === "string" && filter.trim() === "") {
        return true;
      }
      if (value === void 0 || value === null) {
        return false;
      }
      let filterValue = ObjectUtils.removeAccents(filter.toString()).toLocaleLowerCase(filterLocale);
      let stringValue = ObjectUtils.removeAccents(value.toString()).toLocaleLowerCase(filterLocale);
      return stringValue.indexOf(filterValue) !== -1;
    },
    notContains(value, filter, filterLocale) {
      if (filter === void 0 || filter === null || typeof filter === "string" && filter.trim() === "") {
        return true;
      }
      if (value === void 0 || value === null) {
        return false;
      }
      let filterValue = ObjectUtils.removeAccents(filter.toString()).toLocaleLowerCase(filterLocale);
      let stringValue = ObjectUtils.removeAccents(value.toString()).toLocaleLowerCase(filterLocale);
      return stringValue.indexOf(filterValue) === -1;
    },
    endsWith(value, filter, filterLocale) {
      if (filter === void 0 || filter === null || filter.trim() === "") {
        return true;
      }
      if (value === void 0 || value === null) {
        return false;
      }
      let filterValue = ObjectUtils.removeAccents(filter.toString()).toLocaleLowerCase(filterLocale);
      let stringValue = ObjectUtils.removeAccents(value.toString()).toLocaleLowerCase(filterLocale);
      return stringValue.indexOf(filterValue, stringValue.length - filterValue.length) !== -1;
    },
    equals(value, filter, filterLocale) {
      if (filter === void 0 || filter === null || typeof filter === "string" && filter.trim() === "") {
        return true;
      }
      if (value === void 0 || value === null) {
        return false;
      }
      if (value.getTime && filter.getTime)
        return value.getTime() === filter.getTime();
      else
        return ObjectUtils.removeAccents(value.toString()).toLocaleLowerCase(filterLocale) == ObjectUtils.removeAccents(filter.toString()).toLocaleLowerCase(filterLocale);
    },
    notEquals(value, filter, filterLocale) {
      if (filter === void 0 || filter === null || typeof filter === "string" && filter.trim() === "") {
        return false;
      }
      if (value === void 0 || value === null) {
        return true;
      }
      if (value.getTime && filter.getTime)
        return value.getTime() !== filter.getTime();
      else
        return ObjectUtils.removeAccents(value.toString()).toLocaleLowerCase(filterLocale) != ObjectUtils.removeAccents(filter.toString()).toLocaleLowerCase(filterLocale);
    },
    in(value, filter) {
      if (filter === void 0 || filter === null || filter.length === 0) {
        return true;
      }
      for (let i = 0; i < filter.length; i++) {
        if (ObjectUtils.equals(value, filter[i])) {
          return true;
        }
      }
      return false;
    },
    between(value, filter) {
      if (filter == null || filter[0] == null || filter[1] == null) {
        return true;
      }
      if (value === void 0 || value === null) {
        return false;
      }
      if (value.getTime)
        return filter[0].getTime() <= value.getTime() && value.getTime() <= filter[1].getTime();
      else
        return filter[0] <= value && value <= filter[1];
    },
    lt(value, filter) {
      if (filter === void 0 || filter === null) {
        return true;
      }
      if (value === void 0 || value === null) {
        return false;
      }
      if (value.getTime && filter.getTime)
        return value.getTime() < filter.getTime();
      else
        return value < filter;
    },
    lte(value, filter) {
      if (filter === void 0 || filter === null) {
        return true;
      }
      if (value === void 0 || value === null) {
        return false;
      }
      if (value.getTime && filter.getTime)
        return value.getTime() <= filter.getTime();
      else
        return value <= filter;
    },
    gt(value, filter) {
      if (filter === void 0 || filter === null) {
        return true;
      }
      if (value === void 0 || value === null) {
        return false;
      }
      if (value.getTime && filter.getTime)
        return value.getTime() > filter.getTime();
      else
        return value > filter;
    },
    gte(value, filter) {
      if (filter === void 0 || filter === null) {
        return true;
      }
      if (value === void 0 || value === null) {
        return false;
      }
      if (value.getTime && filter.getTime)
        return value.getTime() >= filter.getTime();
      else
        return value >= filter;
    },
    dateIs(value, filter) {
      if (filter === void 0 || filter === null) {
        return true;
      }
      if (value === void 0 || value === null) {
        return false;
      }
      return value.toDateString() === filter.toDateString();
    },
    dateIsNot(value, filter) {
      if (filter === void 0 || filter === null) {
        return true;
      }
      if (value === void 0 || value === null) {
        return false;
      }
      return value.toDateString() !== filter.toDateString();
    },
    dateBefore(value, filter) {
      if (filter === void 0 || filter === null) {
        return true;
      }
      if (value === void 0 || value === null) {
        return false;
      }
      return value.getTime() < filter.getTime();
    },
    dateAfter(value, filter) {
      if (filter === void 0 || filter === null) {
        return true;
      }
      if (value === void 0 || value === null) {
        return false;
      }
      return value.getTime() > filter.getTime();
    }
  },
  register(rule, fn) {
    this.filters[rule] = fn;
  }
};
const defaultOptions = {
  ripple: false,
  inputStyle: "outlined",
  locale: {
    startsWith: "Starts with",
    contains: "Contains",
    notContains: "Not contains",
    endsWith: "Ends with",
    equals: "Equals",
    notEquals: "Not equals",
    noFilter: "No Filter",
    lt: "Less than",
    lte: "Less than or equal to",
    gt: "Greater than",
    gte: "Greater than or equal to",
    dateIs: "Date is",
    dateIsNot: "Date is not",
    dateBefore: "Date is before",
    dateAfter: "Date is after",
    clear: "Clear",
    apply: "Apply",
    matchAll: "Match All",
    matchAny: "Match Any",
    addRule: "Add Rule",
    removeRule: "Remove Rule",
    accept: "Yes",
    reject: "No",
    choose: "Choose",
    upload: "Upload",
    cancel: "Cancel",
    completed: "Completed",
    pending: "Pending",
    dayNames: ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"],
    dayNamesShort: ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"],
    dayNamesMin: ["Su", "Mo", "Tu", "We", "Th", "Fr", "Sa"],
    monthNames: ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"],
    monthNamesShort: ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"],
    chooseYear: "Choose Year",
    chooseMonth: "Choose Month",
    chooseDate: "Choose Date",
    prevDecade: "Previous Decade",
    nextDecade: "Next Decade",
    prevYear: "Previous Year",
    nextYear: "Next Year",
    prevMonth: "Previous Month",
    nextMonth: "Next Month",
    prevHour: "Previous Hour",
    nextHour: "Next Hour",
    prevMinute: "Previous Minute",
    nextMinute: "Next Minute",
    prevSecond: "Previous Second",
    nextSecond: "Next Second",
    am: "am",
    pm: "pm",
    today: "Today",
    weekHeader: "Wk",
    firstDayOfWeek: 0,
    dateFormat: "mm/dd/yy",
    weak: "Weak",
    medium: "Medium",
    strong: "Strong",
    passwordPrompt: "Enter a password",
    emptyFilterMessage: "No results found",
    // @deprecated Use 'emptySearchMessage' option instead.
    searchMessage: "{0} results are available",
    selectionMessage: "{0} items selected",
    emptySelectionMessage: "No selected item",
    emptySearchMessage: "No results found",
    emptyMessage: "No available options",
    aria: {
      trueLabel: "True",
      falseLabel: "False",
      nullLabel: "Not Selected",
      star: "1 star",
      stars: "{star} stars",
      selectAll: "All items selected",
      unselectAll: "All items unselected",
      close: "Close",
      previous: "Previous",
      next: "Next",
      navigation: "Navigation",
      scrollTop: "Scroll Top",
      moveTop: "Move Top",
      moveUp: "Move Up",
      moveDown: "Move Down",
      moveBottom: "Move Bottom",
      moveToTarget: "Move to Target",
      moveToSource: "Move to Source",
      moveAllToTarget: "Move All to Target",
      moveAllToSource: "Move All to Source",
      pageLabel: "{page}",
      firstPageLabel: "First Page",
      lastPageLabel: "Last Page",
      nextPageLabel: "Next Page",
      prevPageLabel: "Previous Page",
      rowsPerPageLabel: "Rows per page",
      jumpToPageDropdownLabel: "Jump to Page Dropdown",
      jumpToPageInputLabel: "Jump to Page Input",
      selectRow: "Row Selected",
      unselectRow: "Row Unselected",
      expandRow: "Row Expanded",
      collapseRow: "Row Collapsed",
      showFilterMenu: "Show Filter Menu",
      hideFilterMenu: "Hide Filter Menu",
      filterOperator: "Filter Operator",
      filterConstraint: "Filter Constraint",
      editRow: "Row Edit",
      saveEdit: "Save Edit",
      cancelEdit: "Cancel Edit",
      listView: "List View",
      gridView: "Grid View",
      slide: "Slide",
      slideNumber: "{slideNumber}",
      zoomImage: "Zoom Image",
      zoomIn: "Zoom In",
      zoomOut: "Zoom Out",
      rotateRight: "Rotate Right",
      rotateLeft: "Rotate Left"
    }
  },
  filterMatchModeOptions: {
    text: [FilterMatchMode.STARTS_WITH, FilterMatchMode.CONTAINS, FilterMatchMode.NOT_CONTAINS, FilterMatchMode.ENDS_WITH, FilterMatchMode.EQUALS, FilterMatchMode.NOT_EQUALS],
    numeric: [FilterMatchMode.EQUALS, FilterMatchMode.NOT_EQUALS, FilterMatchMode.LESS_THAN, FilterMatchMode.LESS_THAN_OR_EQUAL_TO, FilterMatchMode.GREATER_THAN, FilterMatchMode.GREATER_THAN_OR_EQUAL_TO],
    date: [FilterMatchMode.DATE_IS, FilterMatchMode.DATE_IS_NOT, FilterMatchMode.DATE_BEFORE, FilterMatchMode.DATE_AFTER]
  },
  zIndex: {
    modal: 1100,
    overlay: 1e3,
    menu: 1e3,
    tooltip: 1100
  },
  pt: void 0
};
const PrimeVueSymbol = Symbol();
function switchTheme(currentTheme, newTheme, linkElementId, callback) {
  const linkElement = document.getElementById(linkElementId);
  const cloneLinkElement = linkElement.cloneNode(true);
  const newThemeUrl = linkElement.getAttribute("href").replace(currentTheme, newTheme);
  cloneLinkElement.setAttribute("id", linkElementId + "-clone");
  cloneLinkElement.setAttribute("href", newThemeUrl);
  cloneLinkElement.addEventListener("load", () => {
    linkElement.remove();
    cloneLinkElement.setAttribute("id", linkElementId);
    if (callback) {
      callback();
    }
  });
  linkElement.parentNode && linkElement.parentNode.insertBefore(cloneLinkElement, linkElement.nextSibling);
}
var PrimeVue = {
  install: (app, options) => {
    let configOptions = options ? { ...defaultOptions, ...options } : { ...defaultOptions };
    const PrimeVue2 = {
      config: reactive(configOptions),
      changeTheme: switchTheme
    };
    app.config.globalProperties.$primevue = PrimeVue2;
    app.provide(PrimeVueSymbol, PrimeVue2);
  }
};
var script$W = {
  name: "BaseComponent",
  props: {
    pt: {
      type: Object,
      default: void 0
    }
  },
  methods: {
    getOption(obj = {}, key = "") {
      const fKey = ObjectUtils.convertToFlatCase(key);
      return obj[Object.keys(obj).find((k) => ObjectUtils.convertToFlatCase(k) === fKey) || ""];
    },
    getPTValue(obj = {}, key = "", params = {}) {
      const self = ObjectUtils.getItemValue(this.getOption(obj, key), params);
      const globalPT = ObjectUtils.getItemValue(this.getOption(this.defaultPT, key), params);
      const merged = mergeProps(self, globalPT);
      return merged;
    },
    ptm(key = "", params = {}) {
      return this.getPTValue(this.pt, key, { props: this.$props, state: this.$data, ...params });
    },
    ptmo(obj = {}, key = "", params = {}) {
      return this.getPTValue(obj, key, params);
    }
  },
  computed: {
    defaultPT() {
      return ObjectUtils.getItemValue(this.getOption(this.$primevue.config.pt, this.$.type.name), this.defaultsParams);
    },
    defaultsParams() {
      return { instance: this.$ };
    }
  }
};
var script$V = {
  name: "BaseIcon",
  props: {
    label: {
      type: String,
      default: void 0
    },
    spin: {
      type: Boolean,
      default: false
    }
  },
  methods: {
    pti() {
      const isLabelEmpty = ObjectUtils.isEmpty(this.label);
      return {
        class: [
          "p-icon",
          {
            "p-icon-spin": this.spin
          }
        ],
        role: !isLabelEmpty ? "img" : void 0,
        "aria-label": !isLabelEmpty ? this.label : void 0,
        "aria-hidden": isLabelEmpty
      };
    }
  }
};
function styleInject$h(css, ref2) {
  if (ref2 === void 0)
    ref2 = {};
  var insertAt = ref2.insertAt;
  if (!css || true) {
    return;
  }
  var head = document.head || document.getElementsByTagName("head")[0];
  var style = document.createElement("style");
  style.type = "text/css";
  if (insertAt === "top") {
    if (head.firstChild) {
      head.insertBefore(style, head.firstChild);
    } else {
      head.appendChild(style);
    }
  } else {
    head.appendChild(style);
  }
  if (style.styleSheet) {
    style.styleSheet.cssText = css;
  } else {
    style.appendChild(document.createTextNode(css));
  }
}
var css_248z$h = "\n.p-icon {\n    display: inline-block;\n}\n.p-icon-spin {\n    -webkit-animation: p-icon-spin 2s infinite linear;\n    animation: p-icon-spin 2s infinite linear;\n}\n@-webkit-keyframes p-icon-spin {\n0% {\n        -webkit-transform: rotate(0deg);\n        transform: rotate(0deg);\n}\n100% {\n        -webkit-transform: rotate(359deg);\n        transform: rotate(359deg);\n}\n}\n@keyframes p-icon-spin {\n0% {\n        -webkit-transform: rotate(0deg);\n        transform: rotate(0deg);\n}\n100% {\n        -webkit-transform: rotate(359deg);\n        transform: rotate(359deg);\n}\n}\n";
styleInject$h(css_248z$h);
var script$U = {
  name: "SpinnerIcon",
  extends: script$V
};
const _hoisted_1$P = /* @__PURE__ */ createElementVNode("g", { "clip-path": "url(#clip0_417_21408)" }, [
  /* @__PURE__ */ createElementVNode("path", {
    d: "M6.99701 14C5.85441 13.999 4.72939 13.7186 3.72012 13.1832C2.71084 12.6478 1.84795 11.8737 1.20673 10.9284C0.565504 9.98305 0.165424 8.89526 0.041387 7.75989C-0.0826496 6.62453 0.073125 5.47607 0.495122 4.4147C0.917119 3.35333 1.59252 2.4113 2.46241 1.67077C3.33229 0.930247 4.37024 0.413729 5.4857 0.166275C6.60117 -0.0811796 7.76026 -0.0520535 8.86188 0.251112C9.9635 0.554278 10.9742 1.12227 11.8057 1.90555C11.915 2.01493 11.9764 2.16319 11.9764 2.31778C11.9764 2.47236 11.915 2.62062 11.8057 2.73C11.7521 2.78503 11.688 2.82877 11.6171 2.85864C11.5463 2.8885 11.4702 2.90389 11.3933 2.90389C11.3165 2.90389 11.2404 2.8885 11.1695 2.85864C11.0987 2.82877 11.0346 2.78503 10.9809 2.73C9.9998 1.81273 8.73246 1.26138 7.39226 1.16876C6.05206 1.07615 4.72086 1.44794 3.62279 2.22152C2.52471 2.99511 1.72683 4.12325 1.36345 5.41602C1.00008 6.70879 1.09342 8.08723 1.62775 9.31926C2.16209 10.5513 3.10478 11.5617 4.29713 12.1803C5.48947 12.7989 6.85865 12.988 8.17414 12.7157C9.48963 12.4435 10.6711 11.7264 11.5196 10.6854C12.3681 9.64432 12.8319 8.34282 12.8328 7C12.8328 6.84529 12.8943 6.69692 13.0038 6.58752C13.1132 6.47812 13.2616 6.41667 13.4164 6.41667C13.5712 6.41667 13.7196 6.47812 13.8291 6.58752C13.9385 6.69692 14 6.84529 14 7C14 8.85651 13.2622 10.637 11.9489 11.9497C10.6356 13.2625 8.85432 14 6.99701 14Z",
    fill: "currentColor"
  })
], -1);
const _hoisted_2$y = /* @__PURE__ */ createElementVNode("defs", null, [
  /* @__PURE__ */ createElementVNode("clipPath", { id: "clip0_417_21408" }, [
    /* @__PURE__ */ createElementVNode("rect", {
      width: "14",
      height: "14",
      fill: "white"
    })
  ])
], -1);
const _hoisted_3$m = [
  _hoisted_1$P,
  _hoisted_2$y
];
function render$U(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("svg", mergeProps({
    width: "14",
    height: "14",
    viewBox: "0 0 14 14",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, _ctx.pti()), _hoisted_3$m, 16);
}
script$U.render = render$U;
let timeout;
function bindEvents(el) {
  el.addEventListener("mousedown", onMouseDown);
}
function unbindEvents(el) {
  el.removeEventListener("mousedown", onMouseDown);
}
function create(el) {
  let ink = document.createElement("span");
  ink.className = "p-ink";
  ink.setAttribute("role", "presentation");
  ink.setAttribute("aria-hidden", "true");
  el.appendChild(ink);
  ink.addEventListener("animationend", onAnimationEnd);
}
function remove(el) {
  let ink = getInk(el);
  if (ink) {
    unbindEvents(el);
    ink.removeEventListener("animationend", onAnimationEnd);
    ink.remove();
  }
}
function onMouseDown(event2) {
  let target = event2.currentTarget;
  let ink = getInk(target);
  if (!ink || getComputedStyle(ink, null).display === "none") {
    return;
  }
  DomHandler.removeClass(ink, "p-ink-active");
  if (!DomHandler.getHeight(ink) && !DomHandler.getWidth(ink)) {
    let d = Math.max(DomHandler.getOuterWidth(target), DomHandler.getOuterHeight(target));
    ink.style.height = d + "px";
    ink.style.width = d + "px";
  }
  let offset = DomHandler.getOffset(target);
  let x = event2.pageX - offset.left + document.body.scrollTop - DomHandler.getWidth(ink) / 2;
  let y = event2.pageY - offset.top + document.body.scrollLeft - DomHandler.getHeight(ink) / 2;
  ink.style.top = y + "px";
  ink.style.left = x + "px";
  DomHandler.addClass(ink, "p-ink-active");
  timeout = setTimeout(() => {
    if (ink) {
      DomHandler.removeClass(ink, "p-ink-active");
    }
  }, 401);
}
function onAnimationEnd(event2) {
  if (timeout) {
    clearTimeout(timeout);
  }
  DomHandler.removeClass(event2.currentTarget, "p-ink-active");
}
function getInk(el) {
  for (let i = 0; i < el.children.length; i++) {
    if (typeof el.children[i].className === "string" && el.children[i].className.indexOf("p-ink") !== -1) {
      return el.children[i];
    }
  }
  return null;
}
const Ripple = {
  mounted(el, binding) {
    if (binding.instance.$primevue && binding.instance.$primevue.config && binding.instance.$primevue.config.ripple) {
      create(el);
      bindEvents(el);
    }
  },
  unmounted(el) {
    remove(el);
  }
};
var script$T = {
  name: "Button",
  extends: script$W,
  props: {
    label: {
      type: String,
      default: null
    },
    icon: {
      type: String,
      default: null
    },
    iconPos: {
      type: String,
      default: "left"
    },
    iconClass: {
      type: String,
      default: null
    },
    badge: {
      type: String,
      default: null
    },
    badgeClass: {
      type: String,
      default: null
    },
    loading: {
      type: Boolean,
      default: false
    },
    loadingIcon: {
      type: String,
      default: void 0
    },
    link: {
      type: Boolean,
      default: false
    },
    severity: {
      type: String,
      default: null
    },
    raised: {
      type: Boolean,
      default: false
    },
    rounded: {
      type: Boolean,
      default: false
    },
    text: {
      type: Boolean,
      default: false
    },
    outlined: {
      type: Boolean,
      default: false
    },
    size: {
      type: String,
      default: null
    },
    plain: {
      type: Boolean,
      default: false
    }
  },
  computed: {
    buttonClass() {
      return [
        "p-button p-component",
        {
          "p-button-icon-only": this.hasIcon && !this.label,
          "p-button-vertical": (this.iconPos === "top" || this.iconPos === "bottom") && this.label,
          "p-disabled": this.$attrs.disabled || this.loading,
          "p-button-loading": this.loading,
          "p-button-loading-label-only": this.loading && !this.hasIcon && this.label,
          "p-button-link": this.link,
          [`p-button-${this.severity}`]: this.severity,
          "p-button-raised": this.raised,
          "p-button-rounded": this.rounded,
          "p-button-text": this.text,
          "p-button-outlined": this.outlined,
          "p-button-sm": this.size === "small",
          "p-button-lg": this.size === "large",
          "p-button-plain": this.plain
        }
      ];
    },
    iconStyleClass() {
      return [
        "p-button-icon",
        this.iconClass,
        {
          "p-button-icon-left": this.iconPos === "left" && this.label,
          "p-button-icon-right": this.iconPos === "right" && this.label,
          "p-button-icon-top": this.iconPos === "top" && this.label,
          "p-button-icon-bottom": this.iconPos === "bottom" && this.label
        }
      ];
    },
    loadingIconStyleClass() {
      return ["p-button-loading-icon pi-spin", this.iconStyleClass];
    },
    badgeStyleClass() {
      return [
        "p-badge p-component",
        this.badgeClass,
        {
          "p-badge-no-gutter": this.badge && String(this.badge).length === 1
        }
      ];
    },
    disabled() {
      return this.$attrs.disabled || this.loading;
    },
    defaultAriaLabel() {
      return this.label ? this.label + (this.badge ? " " + this.badge : "") : this.$attrs["aria-label"];
    },
    hasIcon() {
      return this.icon || this.$slots.icon;
    }
  },
  components: {
    SpinnerIcon: script$U
  },
  directives: {
    ripple: Ripple
  }
};
const _hoisted_1$O = ["aria-label", "disabled"];
function render$T(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_SpinnerIcon = resolveComponent("SpinnerIcon");
  const _directive_ripple = resolveDirective("ripple");
  return withDirectives((openBlock(), createElementBlock("button", mergeProps({
    class: $options.buttonClass,
    type: "button",
    "aria-label": $options.defaultAriaLabel,
    disabled: $options.disabled
  }, _ctx.ptm("root")), [
    renderSlot(_ctx.$slots, "default", {}, () => [
      $props.loading ? renderSlot(_ctx.$slots, "loadingicon", {
        key: 0,
        class: normalizeClass($options.loadingIconStyleClass)
      }, () => [
        $props.loadingIcon ? (openBlock(), createElementBlock("span", mergeProps({
          key: 0,
          class: [$options.loadingIconStyleClass, $props.loadingIcon]
        }, _ctx.ptm("loadingIcon")), null, 16)) : (openBlock(), createBlock(_component_SpinnerIcon, mergeProps({
          key: 1,
          class: $options.loadingIconStyleClass,
          spin: ""
        }, _ctx.ptm("loadingIcon")), null, 16, ["class"]))
      ]) : renderSlot(_ctx.$slots, "icon", {
        key: 1,
        class: normalizeClass($options.iconStyleClass)
      }, () => [
        $props.icon ? (openBlock(), createElementBlock("span", mergeProps({
          key: 0,
          class: [$options.iconStyleClass, $props.icon]
        }, _ctx.ptm("icon")), null, 16)) : createCommentVNode("", true)
      ]),
      createElementVNode("span", mergeProps({ class: "p-button-label" }, _ctx.ptm("label")), toDisplayString($props.label || " "), 17),
      $props.badge ? (openBlock(), createElementBlock("span", mergeProps({
        key: 2,
        class: $options.badgeStyleClass
      }, _ctx.ptm("badge")), toDisplayString($props.badge), 17)) : createCommentVNode("", true)
    ])
  ], 16, _hoisted_1$O)), [
    [_directive_ripple]
  ]);
}
script$T.render = render$T;
var script$S = {
  name: "ChevronDownIcon",
  extends: script$V
};
const _hoisted_1$N = /* @__PURE__ */ createElementVNode("path", {
  d: "M7.01744 10.398C6.91269 10.3985 6.8089 10.378 6.71215 10.3379C6.61541 10.2977 6.52766 10.2386 6.45405 10.1641L1.13907 4.84913C1.03306 4.69404 0.985221 4.5065 1.00399 4.31958C1.02276 4.13266 1.10693 3.95838 1.24166 3.82747C1.37639 3.69655 1.55301 3.61742 1.74039 3.60402C1.92777 3.59062 2.11386 3.64382 2.26584 3.75424L7.01744 8.47394L11.769 3.75424C11.9189 3.65709 12.097 3.61306 12.2748 3.62921C12.4527 3.64535 12.6199 3.72073 12.7498 3.84328C12.8797 3.96582 12.9647 4.12842 12.9912 4.30502C13.0177 4.48162 12.9841 4.662 12.8958 4.81724L7.58083 10.1322C7.50996 10.2125 7.42344 10.2775 7.32656 10.3232C7.22968 10.3689 7.12449 10.3944 7.01744 10.398Z",
  fill: "currentColor"
}, null, -1);
const _hoisted_2$x = [
  _hoisted_1$N
];
function render$S(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("svg", mergeProps({
    width: "14",
    height: "14",
    viewBox: "0 0 14 14",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, _ctx.pti()), _hoisted_2$x, 16);
}
script$S.render = render$S;
var script$R = {
  name: "TimesCircleIcon",
  extends: script$V
};
const _hoisted_1$M = /* @__PURE__ */ createElementVNode("g", { "clip-path": "url(#clip0_334_13179)" }, [
  /* @__PURE__ */ createElementVNode("path", {
    "fill-rule": "evenodd",
    "clip-rule": "evenodd",
    d: "M7 14C5.61553 14 4.26215 13.5895 3.11101 12.8203C1.95987 12.0511 1.06266 10.9579 0.532846 9.67879C0.00303296 8.3997 -0.13559 6.99224 0.134506 5.63437C0.404603 4.2765 1.07129 3.02922 2.05026 2.05026C3.02922 1.07129 4.2765 0.404603 5.63437 0.134506C6.99224 -0.13559 8.3997 0.00303296 9.67879 0.532846C10.9579 1.06266 12.0511 1.95987 12.8203 3.11101C13.5895 4.26215 14 5.61553 14 7C14 8.85652 13.2625 10.637 11.9497 11.9497C10.637 13.2625 8.85652 14 7 14ZM7 1.16667C5.84628 1.16667 4.71846 1.50879 3.75918 2.14976C2.79989 2.79074 2.05222 3.70178 1.61071 4.76768C1.16919 5.83358 1.05367 7.00647 1.27876 8.13803C1.50384 9.26958 2.05941 10.309 2.87521 11.1248C3.69102 11.9406 4.73042 12.4962 5.86198 12.7212C6.99353 12.9463 8.16642 12.8308 9.23232 12.3893C10.2982 11.9478 11.2093 11.2001 11.8502 10.2408C12.4912 9.28154 12.8333 8.15373 12.8333 7C12.8333 5.45291 12.2188 3.96918 11.1248 2.87521C10.0308 1.78125 8.5471 1.16667 7 1.16667ZM4.66662 9.91668C4.58998 9.91704 4.51404 9.90209 4.44325 9.87271C4.37246 9.84333 4.30826 9.8001 4.2544 9.74557C4.14516 9.6362 4.0838 9.48793 4.0838 9.33335C4.0838 9.17876 4.14516 9.0305 4.2544 8.92113L6.17553 7L4.25443 5.07891C4.15139 4.96832 4.09529 4.82207 4.09796 4.67094C4.10063 4.51982 4.16185 4.37563 4.26872 4.26876C4.3756 4.16188 4.51979 4.10066 4.67091 4.09799C4.82204 4.09532 4.96829 4.15142 5.07887 4.25446L6.99997 6.17556L8.92106 4.25446C9.03164 4.15142 9.1779 4.09532 9.32903 4.09799C9.48015 4.10066 9.62434 4.16188 9.73121 4.26876C9.83809 4.37563 9.89931 4.51982 9.90198 4.67094C9.90464 4.82207 9.84855 4.96832 9.74551 5.07891L7.82441 7L9.74554 8.92113C9.85478 9.0305 9.91614 9.17876 9.91614 9.33335C9.91614 9.48793 9.85478 9.6362 9.74554 9.74557C9.69168 9.8001 9.62748 9.84333 9.55669 9.87271C9.4859 9.90209 9.40996 9.91704 9.33332 9.91668C9.25668 9.91704 9.18073 9.90209 9.10995 9.87271C9.03916 9.84333 8.97495 9.8001 8.9211 9.74557L6.99997 7.82444L5.07884 9.74557C5.02499 9.8001 4.96078 9.84333 4.88999 9.87271C4.81921 9.90209 4.74326 9.91704 4.66662 9.91668Z",
    fill: "currentColor"
  })
], -1);
const _hoisted_2$w = /* @__PURE__ */ createElementVNode("defs", null, [
  /* @__PURE__ */ createElementVNode("clipPath", { id: "clip0_334_13179" }, [
    /* @__PURE__ */ createElementVNode("rect", {
      width: "14",
      height: "14",
      fill: "white"
    })
  ])
], -1);
const _hoisted_3$l = [
  _hoisted_1$M,
  _hoisted_2$w
];
function render$R(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("svg", mergeProps({
    width: "14",
    height: "14",
    viewBox: "0 0 14 14",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, _ctx.pti()), _hoisted_3$l, 16);
}
script$R.render = render$R;
var OverlayEventBus = primebus();
var script$Q = {
  name: "Portal",
  props: {
    appendTo: {
      type: String,
      default: "body"
    },
    disabled: {
      type: Boolean,
      default: false
    }
  },
  data() {
    return {
      mounted: false
    };
  },
  mounted() {
    this.mounted = DomHandler.isClient();
  },
  computed: {
    inline() {
      return this.disabled || this.appendTo === "self";
    }
  }
};
function render$Q(_ctx, _cache, $props, $setup, $data, $options) {
  return $options.inline ? renderSlot(_ctx.$slots, "default", { key: 0 }) : $data.mounted ? (openBlock(), createBlock(Teleport, {
    key: 1,
    to: $props.appendTo
  }, [
    renderSlot(_ctx.$slots, "default")
  ], 8, ["to"])) : createCommentVNode("", true);
}
script$Q.render = render$Q;
var script$P = {
  name: "VirtualScroller",
  extends: script$W,
  emits: ["update:numToleratedItems", "scroll", "scroll-index-change", "lazy-load"],
  props: {
    id: {
      type: String,
      default: null
    },
    style: null,
    class: null,
    items: {
      type: Array,
      default: null
    },
    itemSize: {
      type: [Number, Array],
      default: 0
    },
    scrollHeight: null,
    scrollWidth: null,
    orientation: {
      type: String,
      default: "vertical"
    },
    numToleratedItems: {
      type: Number,
      default: null
    },
    delay: {
      type: Number,
      default: 0
    },
    resizeDelay: {
      type: Number,
      default: 10
    },
    lazy: {
      type: Boolean,
      default: false
    },
    disabled: {
      type: Boolean,
      default: false
    },
    loaderDisabled: {
      type: Boolean,
      default: false
    },
    columns: {
      type: Array,
      default: null
    },
    loading: {
      type: Boolean,
      default: false
    },
    showSpacer: {
      type: Boolean,
      default: true
    },
    showLoader: {
      type: Boolean,
      default: false
    },
    tabindex: {
      type: Number,
      default: 0
    },
    inline: {
      type: Boolean,
      default: false
    },
    step: {
      type: Number,
      default: 0
    },
    appendOnly: {
      type: Boolean,
      default: false
    },
    autoSize: {
      type: Boolean,
      default: false
    }
  },
  data() {
    return {
      first: this.isBoth() ? { rows: 0, cols: 0 } : 0,
      last: this.isBoth() ? { rows: 0, cols: 0 } : 0,
      page: this.isBoth() ? { rows: 0, cols: 0 } : 0,
      numItemsInViewport: this.isBoth() ? { rows: 0, cols: 0 } : 0,
      lastScrollPos: this.isBoth() ? { top: 0, left: 0 } : 0,
      d_numToleratedItems: this.numToleratedItems,
      d_loading: this.loading,
      loaderArr: [],
      spacerStyle: {},
      contentStyle: {}
    };
  },
  element: null,
  content: null,
  lastScrollPos: null,
  scrollTimeout: null,
  resizeTimeout: null,
  defaultWidth: 0,
  defaultHeight: 0,
  defaultContentWidth: 0,
  defaultContentHeight: 0,
  isRangeChanged: false,
  lazyLoadState: {},
  resizeListener: null,
  initialized: false,
  watch: {
    numToleratedItems(newValue) {
      this.d_numToleratedItems = newValue;
    },
    loading(newValue) {
      this.d_loading = newValue;
    },
    items(newValue, oldValue) {
      if (!oldValue || oldValue.length !== (newValue || []).length) {
        this.init();
        this.calculateAutoSize();
      }
    },
    itemSize() {
      this.init();
      this.calculateAutoSize();
    },
    orientation() {
      this.lastScrollPos = this.isBoth() ? { top: 0, left: 0 } : 0;
    },
    scrollHeight() {
      this.init();
      this.calculateAutoSize();
    },
    scrollWidth() {
      this.init();
      this.calculateAutoSize();
    }
  },
  mounted() {
    this.viewInit();
    this.lastScrollPos = this.isBoth() ? { top: 0, left: 0 } : 0;
    this.lazyLoadState = this.lazyLoadState || {};
  },
  updated() {
    !this.initialized && this.viewInit();
  },
  unmounted() {
    this.unbindResizeListener();
    this.initialized = false;
  },
  methods: {
    viewInit() {
      if (DomHandler.isVisible(this.element)) {
        this.setContentEl(this.content);
        this.init();
        this.bindResizeListener();
        this.defaultWidth = DomHandler.getWidth(this.element);
        this.defaultHeight = DomHandler.getHeight(this.element);
        this.defaultContentWidth = DomHandler.getWidth(this.content);
        this.defaultContentHeight = DomHandler.getHeight(this.content);
        this.initialized = true;
      }
    },
    init() {
      if (!this.disabled) {
        this.setSize();
        this.calculateOptions();
        this.setSpacerSize();
      }
    },
    isVertical() {
      return this.orientation === "vertical";
    },
    isHorizontal() {
      return this.orientation === "horizontal";
    },
    isBoth() {
      return this.orientation === "both";
    },
    scrollTo(options) {
      this.lastScrollPos = this.both ? { top: 0, left: 0 } : 0;
      this.element && this.element.scrollTo(options);
    },
    scrollToIndex(index, behavior = "auto") {
      const both = this.isBoth();
      const horizontal = this.isHorizontal();
      const first = this.first;
      const { numToleratedItems } = this.calculateNumItems();
      const contentPos = this.getContentPosition();
      const itemSize = this.itemSize;
      const calculateFirst = (_index = 0, _numT) => _index <= _numT ? 0 : _index;
      const calculateCoord = (_first, _size, _cpos) => _first * _size + _cpos;
      const scrollTo = (left = 0, top = 0) => this.scrollTo({ left, top, behavior });
      let newFirst = both ? { rows: 0, cols: 0 } : 0;
      let isRangeChanged = false;
      if (both) {
        newFirst = { rows: calculateFirst(index[0], numToleratedItems[0]), cols: calculateFirst(index[1], numToleratedItems[1]) };
        scrollTo(calculateCoord(newFirst.cols, itemSize[1], contentPos.left), calculateCoord(newFirst.rows, itemSize[0], contentPos.top));
        isRangeChanged = newFirst.rows !== first.rows || newFirst.cols !== first.cols;
      } else {
        newFirst = calculateFirst(index, numToleratedItems);
        horizontal ? scrollTo(calculateCoord(newFirst, itemSize, contentPos.left), 0) : scrollTo(0, calculateCoord(newFirst, itemSize, contentPos.top));
        isRangeChanged = newFirst !== first;
      }
      this.isRangeChanged = isRangeChanged;
      this.first = newFirst;
    },
    scrollInView(index, to, behavior = "auto") {
      if (to) {
        const both = this.isBoth();
        const horizontal = this.isHorizontal();
        const { first, viewport } = this.getRenderedRange();
        const scrollTo = (left = 0, top = 0) => this.scrollTo({ left, top, behavior });
        const isToStart = to === "to-start";
        const isToEnd = to === "to-end";
        if (isToStart) {
          if (both) {
            if (viewport.first.rows - first.rows > index[0]) {
              scrollTo(viewport.first.cols * this.itemSize[1], (viewport.first.rows - 1) * this.itemSize[0]);
            } else if (viewport.first.cols - first.cols > index[1]) {
              scrollTo((viewport.first.cols - 1) * this.itemSize[1], viewport.first.rows * this.itemSize[0]);
            }
          } else {
            if (viewport.first - first > index) {
              const pos = (viewport.first - 1) * this.itemSize;
              horizontal ? scrollTo(pos, 0) : scrollTo(0, pos);
            }
          }
        } else if (isToEnd) {
          if (both) {
            if (viewport.last.rows - first.rows <= index[0] + 1) {
              scrollTo(viewport.first.cols * this.itemSize[1], (viewport.first.rows + 1) * this.itemSize[0]);
            } else if (viewport.last.cols - first.cols <= index[1] + 1) {
              scrollTo((viewport.first.cols + 1) * this.itemSize[1], viewport.first.rows * this.itemSize[0]);
            }
          } else {
            if (viewport.last - first <= index + 1) {
              const pos = (viewport.first + 1) * this.itemSize;
              horizontal ? scrollTo(pos, 0) : scrollTo(0, pos);
            }
          }
        }
      } else {
        this.scrollToIndex(index, behavior);
      }
    },
    getRenderedRange() {
      const calculateFirstInViewport = (_pos, _size) => Math.floor(_pos / (_size || _pos));
      let firstInViewport = this.first;
      let lastInViewport = 0;
      if (this.element) {
        const both = this.isBoth();
        const horizontal = this.isHorizontal();
        const { scrollTop, scrollLeft } = this.element.scrollTop;
        if (both) {
          firstInViewport = { rows: calculateFirstInViewport(scrollTop, this.itemSize[0]), cols: calculateFirstInViewport(scrollLeft, this.itemSize[1]) };
          lastInViewport = { rows: firstInViewport.rows + this.numItemsInViewport.rows, cols: firstInViewport.cols + this.numItemsInViewport.cols };
        } else {
          const scrollPos = horizontal ? scrollLeft : scrollTop;
          firstInViewport = calculateFirstInViewport(scrollPos, this.itemSize);
          lastInViewport = firstInViewport + this.numItemsInViewport;
        }
      }
      return {
        first: this.first,
        last: this.last,
        viewport: {
          first: firstInViewport,
          last: lastInViewport
        }
      };
    },
    calculateNumItems() {
      const both = this.isBoth();
      const horizontal = this.isHorizontal();
      const itemSize = this.itemSize;
      const contentPos = this.getContentPosition();
      const contentWidth = this.element ? this.element.offsetWidth - contentPos.left : 0;
      const contentHeight = this.element ? this.element.offsetHeight - contentPos.top : 0;
      const calculateNumItemsInViewport = (_contentSize, _itemSize) => Math.ceil(_contentSize / (_itemSize || _contentSize));
      const calculateNumToleratedItems = (_numItems) => Math.ceil(_numItems / 2);
      const numItemsInViewport = both ? { rows: calculateNumItemsInViewport(contentHeight, itemSize[0]), cols: calculateNumItemsInViewport(contentWidth, itemSize[1]) } : calculateNumItemsInViewport(horizontal ? contentWidth : contentHeight, itemSize);
      const numToleratedItems = this.d_numToleratedItems || (both ? [calculateNumToleratedItems(numItemsInViewport.rows), calculateNumToleratedItems(numItemsInViewport.cols)] : calculateNumToleratedItems(numItemsInViewport));
      return { numItemsInViewport, numToleratedItems };
    },
    calculateOptions() {
      const both = this.isBoth();
      const first = this.first;
      const { numItemsInViewport, numToleratedItems } = this.calculateNumItems();
      const calculateLast = (_first, _num, _numT, _isCols = false) => this.getLast(_first + _num + (_first < _numT ? 2 : 3) * _numT, _isCols);
      const last = both ? { rows: calculateLast(first.rows, numItemsInViewport.rows, numToleratedItems[0]), cols: calculateLast(first.cols, numItemsInViewport.cols, numToleratedItems[1], true) } : calculateLast(first, numItemsInViewport, numToleratedItems);
      this.last = last;
      this.numItemsInViewport = numItemsInViewport;
      this.d_numToleratedItems = numToleratedItems;
      this.$emit("update:numToleratedItems", this.d_numToleratedItems);
      if (this.showLoader) {
        this.loaderArr = both ? Array.from({ length: numItemsInViewport.rows }).map(() => Array.from({ length: numItemsInViewport.cols })) : Array.from({ length: numItemsInViewport });
      }
      if (this.lazy) {
        Promise.resolve().then(() => {
          this.lazyLoadState = {
            first: this.step ? both ? { rows: 0, cols: first.cols } : 0 : first,
            last: Math.min(this.step ? this.step : last, this.items.length)
          };
          this.$emit("lazy-load", this.lazyLoadState);
        });
      }
    },
    calculateAutoSize() {
      if (this.autoSize && !this.d_loading) {
        Promise.resolve().then(() => {
          if (this.content) {
            const both = this.isBoth();
            const horizontal = this.isHorizontal();
            const vertical = this.isVertical();
            this.content.style.minHeight = this.content.style.minWidth = "auto";
            this.content.style.position = "relative";
            this.element.style.contain = "none";
            const [contentWidth, contentHeight] = [DomHandler.getWidth(this.content), DomHandler.getHeight(this.content)];
            contentWidth !== this.defaultContentWidth && (this.element.style.width = "");
            contentHeight !== this.defaultContentHeight && (this.element.style.height = "");
            const [width, height] = [DomHandler.getWidth(this.element), DomHandler.getHeight(this.element)];
            (both || horizontal) && (this.element.style.width = width < this.defaultWidth ? width + "px" : this.scrollWidth || this.defaultWidth + "px");
            (both || vertical) && (this.element.style.height = height < this.defaultHeight ? height + "px" : this.scrollHeight || this.defaultHeight + "px");
            this.content.style.minHeight = this.content.style.minWidth = "";
            this.content.style.position = "";
            this.element.style.contain = "";
          }
        });
      }
    },
    getLast(last = 0, isCols) {
      return this.items ? Math.min(isCols ? (this.columns || this.items[0]).length : this.items.length, last) : 0;
    },
    getContentPosition() {
      if (this.content) {
        const style = getComputedStyle(this.content);
        const left = parseFloat(style.paddingLeft) + Math.max(parseFloat(style.left) || 0, 0);
        const right = parseFloat(style.paddingRight) + Math.max(parseFloat(style.right) || 0, 0);
        const top = parseFloat(style.paddingTop) + Math.max(parseFloat(style.top) || 0, 0);
        const bottom = parseFloat(style.paddingBottom) + Math.max(parseFloat(style.bottom) || 0, 0);
        return { left, right, top, bottom, x: left + right, y: top + bottom };
      }
      return { left: 0, right: 0, top: 0, bottom: 0, x: 0, y: 0 };
    },
    setSize() {
      if (this.element) {
        const both = this.isBoth();
        const horizontal = this.isHorizontal();
        const parentElement = this.element.parentElement;
        const width = this.scrollWidth || `${this.element.offsetWidth || parentElement.offsetWidth}px`;
        const height = this.scrollHeight || `${this.element.offsetHeight || parentElement.offsetHeight}px`;
        const setProp = (_name, _value) => this.element.style[_name] = _value;
        if (both || horizontal) {
          setProp("height", height);
          setProp("width", width);
        } else {
          setProp("height", height);
        }
      }
    },
    setSpacerSize() {
      const items = this.items;
      if (items) {
        const both = this.isBoth();
        const horizontal = this.isHorizontal();
        const contentPos = this.getContentPosition();
        const setProp = (_name, _value, _size, _cpos = 0) => this.spacerStyle = { ...this.spacerStyle, ...{ [`${_name}`]: (_value || []).length * _size + _cpos + "px" } };
        if (both) {
          setProp("height", items, this.itemSize[0], contentPos.y);
          setProp("width", this.columns || items[1], this.itemSize[1], contentPos.x);
        } else {
          horizontal ? setProp("width", this.columns || items, this.itemSize, contentPos.x) : setProp("height", items, this.itemSize, contentPos.y);
        }
      }
    },
    setContentPosition(pos) {
      if (this.content && !this.appendOnly) {
        const both = this.isBoth();
        const horizontal = this.isHorizontal();
        const first = pos ? pos.first : this.first;
        const calculateTranslateVal = (_first, _size) => _first * _size;
        const setTransform = (_x = 0, _y = 0) => this.contentStyle = { ...this.contentStyle, ...{ transform: `translate3d(${_x}px, ${_y}px, 0)` } };
        if (both) {
          setTransform(calculateTranslateVal(first.cols, this.itemSize[1]), calculateTranslateVal(first.rows, this.itemSize[0]));
        } else {
          const translateVal = calculateTranslateVal(first, this.itemSize);
          horizontal ? setTransform(translateVal, 0) : setTransform(0, translateVal);
        }
      }
    },
    onScrollPositionChange(event2) {
      const target = event2.target;
      const both = this.isBoth();
      const horizontal = this.isHorizontal();
      const contentPos = this.getContentPosition();
      const calculateScrollPos = (_pos, _cpos) => _pos ? _pos > _cpos ? _pos - _cpos : _pos : 0;
      const calculateCurrentIndex = (_pos, _size) => Math.floor(_pos / (_size || _pos));
      const calculateTriggerIndex = (_currentIndex, _first, _last, _num, _numT, _isScrollDownOrRight) => {
        return _currentIndex <= _numT ? _numT : _isScrollDownOrRight ? _last - _num - _numT : _first + _numT - 1;
      };
      const calculateFirst = (_currentIndex, _triggerIndex, _first, _last, _num, _numT, _isScrollDownOrRight) => {
        if (_currentIndex <= _numT)
          return 0;
        else
          return Math.max(0, _isScrollDownOrRight ? _currentIndex < _triggerIndex ? _first : _currentIndex - _numT : _currentIndex > _triggerIndex ? _first : _currentIndex - 2 * _numT);
      };
      const calculateLast = (_currentIndex, _first, _last, _num, _numT, _isCols) => {
        let lastValue = _first + _num + 2 * _numT;
        if (_currentIndex >= _numT) {
          lastValue += _numT + 1;
        }
        return this.getLast(lastValue, _isCols);
      };
      const scrollTop = calculateScrollPos(target.scrollTop, contentPos.top);
      const scrollLeft = calculateScrollPos(target.scrollLeft, contentPos.left);
      let newFirst = both ? { rows: 0, cols: 0 } : 0;
      let newLast = this.last;
      let isRangeChanged = false;
      let newScrollPos = this.lastScrollPos;
      if (both) {
        const isScrollDown = this.lastScrollPos.top <= scrollTop;
        const isScrollRight = this.lastScrollPos.left <= scrollLeft;
        if (!this.appendOnly || this.appendOnly && (isScrollDown || isScrollRight)) {
          const currentIndex = { rows: calculateCurrentIndex(scrollTop, this.itemSize[0]), cols: calculateCurrentIndex(scrollLeft, this.itemSize[1]) };
          const triggerIndex = {
            rows: calculateTriggerIndex(currentIndex.rows, this.first.rows, this.last.rows, this.numItemsInViewport.rows, this.d_numToleratedItems[0], isScrollDown),
            cols: calculateTriggerIndex(currentIndex.cols, this.first.cols, this.last.cols, this.numItemsInViewport.cols, this.d_numToleratedItems[1], isScrollRight)
          };
          newFirst = {
            rows: calculateFirst(currentIndex.rows, triggerIndex.rows, this.first.rows, this.last.rows, this.numItemsInViewport.rows, this.d_numToleratedItems[0], isScrollDown),
            cols: calculateFirst(currentIndex.cols, triggerIndex.cols, this.first.cols, this.last.cols, this.numItemsInViewport.cols, this.d_numToleratedItems[1], isScrollRight)
          };
          newLast = {
            rows: calculateLast(currentIndex.rows, newFirst.rows, this.last.rows, this.numItemsInViewport.rows, this.d_numToleratedItems[0]),
            cols: calculateLast(currentIndex.cols, newFirst.cols, this.last.cols, this.numItemsInViewport.cols, this.d_numToleratedItems[1], true)
          };
          isRangeChanged = newFirst.rows !== this.first.rows || newLast.rows !== this.last.rows || newFirst.cols !== this.first.cols || newLast.cols !== this.last.cols || this.isRangeChanged;
          newScrollPos = { top: scrollTop, left: scrollLeft };
        }
      } else {
        const scrollPos = horizontal ? scrollLeft : scrollTop;
        const isScrollDownOrRight = this.lastScrollPos <= scrollPos;
        if (!this.appendOnly || this.appendOnly && isScrollDownOrRight) {
          const currentIndex = calculateCurrentIndex(scrollPos, this.itemSize);
          const triggerIndex = calculateTriggerIndex(currentIndex, this.first, this.last, this.numItemsInViewport, this.d_numToleratedItems, isScrollDownOrRight);
          newFirst = calculateFirst(currentIndex, triggerIndex, this.first, this.last, this.numItemsInViewport, this.d_numToleratedItems, isScrollDownOrRight);
          newLast = calculateLast(currentIndex, newFirst, this.last, this.numItemsInViewport, this.d_numToleratedItems);
          isRangeChanged = newFirst !== this.first || newLast !== this.last || this.isRangeChanged;
          newScrollPos = scrollPos;
        }
      }
      return {
        first: newFirst,
        last: newLast,
        isRangeChanged,
        scrollPos: newScrollPos
      };
    },
    onScrollChange(event2) {
      const { first, last, isRangeChanged, scrollPos } = this.onScrollPositionChange(event2);
      if (isRangeChanged) {
        const newState = { first, last };
        this.setContentPosition(newState);
        this.first = first;
        this.last = last;
        this.lastScrollPos = scrollPos;
        this.$emit("scroll-index-change", newState);
        if (this.lazy && this.isPageChanged(first)) {
          const lazyLoadState = {
            first: this.step ? Math.min(this.getPageByFirst(first) * this.step, this.items.length - this.step) : first,
            last: Math.min(this.step ? (this.getPageByFirst(first) + 1) * this.step : last, this.items.length)
          };
          const isLazyStateChanged = this.lazyLoadState.first !== lazyLoadState.first || this.lazyLoadState.last !== lazyLoadState.last;
          isLazyStateChanged && this.$emit("lazy-load", lazyLoadState);
          this.lazyLoadState = lazyLoadState;
        }
      }
    },
    onScroll(event2) {
      this.$emit("scroll", event2);
      if (this.delay && this.isPageChanged()) {
        if (this.scrollTimeout) {
          clearTimeout(this.scrollTimeout);
        }
        if (!this.d_loading && this.showLoader) {
          const { isRangeChanged } = this.onScrollPositionChange(event2);
          const changed = isRangeChanged || (this.step ? this.isPageChanged() : false);
          changed && (this.d_loading = true);
        }
        this.scrollTimeout = setTimeout(() => {
          this.onScrollChange(event2);
          if (this.d_loading && this.showLoader && (!this.lazy || this.loading === void 0)) {
            this.d_loading = false;
            this.page = this.getPageByFirst();
          }
        }, this.delay);
      } else {
        this.onScrollChange(event2);
      }
    },
    onResize() {
      if (this.resizeTimeout) {
        clearTimeout(this.resizeTimeout);
      }
      this.resizeTimeout = setTimeout(() => {
        if (DomHandler.isVisible(this.element)) {
          const both = this.isBoth();
          const vertical = this.isVertical();
          const horizontal = this.isHorizontal();
          const [width, height] = [DomHandler.getWidth(this.element), DomHandler.getHeight(this.element)];
          const [isDiffWidth, isDiffHeight] = [width !== this.defaultWidth, height !== this.defaultHeight];
          const reinit = both ? isDiffWidth || isDiffHeight : horizontal ? isDiffWidth : vertical ? isDiffHeight : false;
          if (reinit) {
            this.d_numToleratedItems = this.numToleratedItems;
            this.defaultWidth = width;
            this.defaultHeight = height;
            this.defaultContentWidth = DomHandler.getWidth(this.content);
            this.defaultContentHeight = DomHandler.getHeight(this.content);
            this.init();
          }
        }
      }, this.resizeDelay);
    },
    bindResizeListener() {
      if (!this.resizeListener) {
        this.resizeListener = this.onResize.bind(this);
        window.addEventListener("resize", this.resizeListener);
        window.addEventListener("orientationchange", this.resizeListener);
      }
    },
    unbindResizeListener() {
      if (this.resizeListener) {
        window.removeEventListener("resize", this.resizeListener);
        window.removeEventListener("orientationchange", this.resizeListener);
        this.resizeListener = null;
      }
    },
    getOptions(renderedIndex) {
      const count = (this.items || []).length;
      const index = this.isBoth() ? this.first.rows + renderedIndex : this.first + renderedIndex;
      return {
        index,
        count,
        first: index === 0,
        last: index === count - 1,
        even: index % 2 === 0,
        odd: index % 2 !== 0
      };
    },
    getLoaderOptions(index, extOptions) {
      let count = this.loaderArr.length;
      return {
        index,
        count,
        first: index === 0,
        last: index === count - 1,
        even: index % 2 === 0,
        odd: index % 2 !== 0,
        ...extOptions
      };
    },
    getPageByFirst(first) {
      return Math.floor(((first ?? this.first) + this.d_numToleratedItems * 4) / (this.step || 1));
    },
    isPageChanged(first) {
      return this.step ? this.page !== this.getPageByFirst(first ?? this.first) : true;
    },
    setContentEl(el) {
      this.content = el || this.content || DomHandler.findSingle(this.element, ".p-virtualscroller-content");
    },
    elementRef(el) {
      this.element = el;
    },
    contentRef(el) {
      this.content = el;
    }
  },
  computed: {
    containerClass() {
      return [
        "p-virtualscroller",
        {
          "p-virtualscroller-inline": this.inline,
          "p-virtualscroller-both p-both-scroll": this.isBoth(),
          "p-virtualscroller-horizontal p-horizontal-scroll": this.isHorizontal()
        },
        this.class
      ];
    },
    contentClass() {
      return [
        "p-virtualscroller-content",
        {
          "p-virtualscroller-loading": this.d_loading
        }
      ];
    },
    loaderClass() {
      return [
        "p-virtualscroller-loader",
        {
          "p-component-overlay": !this.$slots.loader
        }
      ];
    },
    loadedItems() {
      if (this.items && !this.d_loading) {
        if (this.isBoth())
          return this.items.slice(this.appendOnly ? 0 : this.first.rows, this.last.rows).map((item) => this.columns ? item : item.slice(this.appendOnly ? 0 : this.first.cols, this.last.cols));
        else if (this.isHorizontal() && this.columns)
          return this.items;
        else
          return this.items.slice(this.appendOnly ? 0 : this.first, this.last);
      }
      return [];
    },
    loadedRows() {
      return this.d_loading ? this.loaderDisabled ? this.loaderArr : [] : this.loadedItems;
    },
    loadedColumns() {
      if (this.columns) {
        const both = this.isBoth();
        const horizontal = this.isHorizontal();
        if (both || horizontal) {
          return this.d_loading && this.loaderDisabled ? both ? this.loaderArr[0] : this.loaderArr : this.columns.slice(both ? this.first.cols : this.first, both ? this.last.cols : this.last);
        }
      }
      return this.columns;
    }
  },
  components: {
    SpinnerIcon: script$U
  }
};
const _hoisted_1$L = ["tabindex"];
function render$P(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_SpinnerIcon = resolveComponent("SpinnerIcon");
  return !$props.disabled ? (openBlock(), createElementBlock("div", mergeProps({
    key: 0,
    ref: $options.elementRef,
    class: $options.containerClass,
    tabindex: $props.tabindex,
    style: $props.style,
    onScroll: _cache[0] || (_cache[0] = (...args) => $options.onScroll && $options.onScroll(...args))
  }, _ctx.ptm("root")), [
    renderSlot(_ctx.$slots, "content", {
      styleClass: $options.contentClass,
      items: $options.loadedItems,
      getItemOptions: $options.getOptions,
      loading: $data.d_loading,
      getLoaderOptions: $options.getLoaderOptions,
      itemSize: $props.itemSize,
      rows: $options.loadedRows,
      columns: $options.loadedColumns,
      contentRef: $options.contentRef,
      spacerStyle: $data.spacerStyle,
      contentStyle: $data.contentStyle,
      vertical: $options.isVertical(),
      horizontal: $options.isHorizontal(),
      both: $options.isBoth()
    }, () => [
      createElementVNode("div", mergeProps({
        ref: $options.contentRef,
        class: $options.contentClass,
        style: $data.contentStyle
      }, _ctx.ptm("content")), [
        (openBlock(true), createElementBlock(Fragment, null, renderList($options.loadedItems, (item, index) => {
          return renderSlot(_ctx.$slots, "item", {
            key: index,
            item,
            options: $options.getOptions(index)
          });
        }), 128))
      ], 16)
    ]),
    $props.showSpacer ? (openBlock(), createElementBlock("div", mergeProps({
      key: 0,
      class: "p-virtualscroller-spacer",
      style: $data.spacerStyle
    }, _ctx.ptm("spacer")), null, 16)) : createCommentVNode("", true),
    !$props.loaderDisabled && $props.showLoader && $data.d_loading ? (openBlock(), createElementBlock("div", mergeProps({
      key: 1,
      class: $options.loaderClass
    }, _ctx.ptm("loader")), [
      _ctx.$slots && _ctx.$slots.loader ? (openBlock(true), createElementBlock(Fragment, { key: 0 }, renderList($data.loaderArr, (_, index) => {
        return renderSlot(_ctx.$slots, "loader", {
          key: index,
          options: $options.getLoaderOptions(index, $options.isBoth() && { numCols: _ctx.d_numItemsInViewport.cols })
        });
      }), 128)) : createCommentVNode("", true),
      renderSlot(_ctx.$slots, "loadingicon", {}, () => [
        createVNode(_component_SpinnerIcon, mergeProps({
          spin: "",
          class: "p-virtualscroller-loading-icon"
        }, _ctx.ptm("loadingIcon")), null, 16)
      ])
    ], 16)) : createCommentVNode("", true)
  ], 16, _hoisted_1$L)) : (openBlock(), createElementBlock(Fragment, { key: 1 }, [
    renderSlot(_ctx.$slots, "default"),
    renderSlot(_ctx.$slots, "content", {
      items: $props.items,
      rows: $props.items,
      columns: $options.loadedColumns
    })
  ], 64));
}
function styleInject$g(css, ref2) {
  if (ref2 === void 0)
    ref2 = {};
  var insertAt = ref2.insertAt;
  if (!css || true) {
    return;
  }
  var head = document.head || document.getElementsByTagName("head")[0];
  var style = document.createElement("style");
  style.type = "text/css";
  if (insertAt === "top") {
    if (head.firstChild) {
      head.insertBefore(style, head.firstChild);
    } else {
      head.appendChild(style);
    }
  } else {
    head.appendChild(style);
  }
  if (style.styleSheet) {
    style.styleSheet.cssText = css;
  } else {
    style.appendChild(document.createTextNode(css));
  }
}
var css_248z$g = "\n.p-virtualscroller {\n    position: relative;\n    overflow: auto;\n    contain: strict;\n    transform: translateZ(0);\n    will-change: scroll-position;\n    outline: 0 none;\n}\n.p-virtualscroller-content {\n    position: absolute;\n    top: 0;\n    left: 0;\n    /* contain: content; */\n    min-height: 100%;\n    min-width: 100%;\n    will-change: transform;\n}\n.p-virtualscroller-spacer {\n    position: absolute;\n    top: 0;\n    left: 0;\n    height: 1px;\n    width: 1px;\n    transform-origin: 0 0;\n    pointer-events: none;\n}\n.p-virtualscroller .p-virtualscroller-loader {\n    position: sticky;\n    top: 0;\n    left: 0;\n    width: 100%;\n    height: 100%;\n}\n.p-virtualscroller-loader.p-component-overlay {\n    display: flex;\n    align-items: center;\n    justify-content: center;\n}\n.p-virtualscroller-loading-icon {\n    font-size: 2rem;\n}\n.p-virtualscroller-loading-icon.p-icon {\n    width: 2rem;\n    height: 2rem;\n}\n.p-virtualscroller-horizontal > .p-virtualscroller-content {\n    display: flex;\n}\n\n/* Inline */\n.p-virtualscroller-inline .p-virtualscroller-content {\n    position: static;\n}\n";
styleInject$g(css_248z$g);
script$P.render = render$P;
var script$O = {
  name: "AutoComplete",
  extends: script$W,
  emits: ["update:modelValue", "change", "focus", "blur", "item-select", "item-unselect", "dropdown-click", "clear", "complete", "before-show", "before-hide", "show", "hide"],
  props: {
    modelValue: null,
    suggestions: {
      type: Array,
      default: null
    },
    field: {
      // TODO: Deprecated since v3.16.0
      type: [String, Function],
      default: null
    },
    optionLabel: null,
    optionDisabled: null,
    optionGroupLabel: null,
    optionGroupChildren: null,
    scrollHeight: {
      type: String,
      default: "200px"
    },
    dropdown: {
      type: Boolean,
      default: false
    },
    dropdownMode: {
      type: String,
      default: "blank"
    },
    autoHighlight: {
      // TODO: Deprecated since v3.16.0. Use selectOnFocus property instead.
      type: Boolean,
      default: false
    },
    multiple: {
      type: Boolean,
      default: false
    },
    disabled: {
      type: Boolean,
      default: false
    },
    placeholder: {
      type: String,
      default: null
    },
    dataKey: {
      type: String,
      default: null
    },
    minLength: {
      type: Number,
      default: 1
    },
    delay: {
      type: Number,
      default: 300
    },
    appendTo: {
      type: String,
      default: "body"
    },
    forceSelection: {
      type: Boolean,
      default: false
    },
    completeOnFocus: {
      type: Boolean,
      default: false
    },
    inputId: {
      type: String,
      default: null
    },
    inputStyle: {
      type: Object,
      default: null
    },
    inputClass: {
      type: [String, Object],
      default: null
    },
    inputProps: {
      type: null,
      default: null
    },
    panelStyle: {
      type: Object,
      default: null
    },
    panelClass: {
      type: [String, Object],
      default: null
    },
    panelProps: {
      type: null,
      default: null
    },
    dropdownIcon: {
      type: String,
      default: void 0
    },
    dropdownClass: {
      type: [String, Object],
      default: null
    },
    loadingIcon: {
      type: String,
      default: void 0
    },
    removeTokenIcon: {
      type: String,
      default: void 0
    },
    virtualScrollerOptions: {
      type: Object,
      default: null
    },
    autoOptionFocus: {
      type: Boolean,
      default: true
    },
    selectOnFocus: {
      type: Boolean,
      default: false
    },
    searchLocale: {
      type: String,
      default: void 0
    },
    searchMessage: {
      type: String,
      default: null
    },
    selectionMessage: {
      type: String,
      default: null
    },
    emptySelectionMessage: {
      type: String,
      default: null
    },
    emptySearchMessage: {
      type: String,
      default: null
    },
    tabindex: {
      type: Number,
      default: 0
    },
    "aria-label": {
      type: String,
      default: null
    },
    "aria-labelledby": {
      type: String,
      default: null
    }
  },
  outsideClickListener: null,
  resizeListener: null,
  scrollHandler: null,
  overlay: null,
  virtualScroller: null,
  searchTimeout: null,
  focusOnHover: false,
  dirty: false,
  data() {
    return {
      id: this.$attrs.id,
      focused: false,
      focusedOptionIndex: -1,
      focusedMultipleOptionIndex: -1,
      overlayVisible: false,
      searching: false
    };
  },
  watch: {
    "$attrs.id": function(newValue) {
      this.id = newValue || UniqueComponentId();
    },
    suggestions() {
      if (this.searching) {
        ObjectUtils.isNotEmpty(this.suggestions) ? this.show() : !!this.$slots.empty ? this.show() : this.hide();
        this.focusedOptionIndex = this.overlayVisible && this.autoOptionFocus ? this.findFirstFocusedOptionIndex() : -1;
        this.searching = false;
      }
      this.autoUpdateModel();
    }
  },
  mounted() {
    this.id = this.id || UniqueComponentId();
    this.autoUpdateModel();
  },
  updated() {
    if (this.overlayVisible) {
      this.alignOverlay();
    }
  },
  beforeUnmount() {
    this.unbindOutsideClickListener();
    this.unbindResizeListener();
    if (this.scrollHandler) {
      this.scrollHandler.destroy();
      this.scrollHandler = null;
    }
    if (this.overlay) {
      ZIndexUtils.clear(this.overlay);
      this.overlay = null;
    }
  },
  methods: {
    getOptionIndex(index, fn) {
      return this.virtualScrollerDisabled ? index : fn && fn(index)["index"];
    },
    getOptionLabel(option) {
      return this.field || this.optionLabel ? ObjectUtils.resolveFieldData(option, this.field || this.optionLabel) : option;
    },
    getOptionValue(option) {
      return option;
    },
    getOptionRenderKey(option, index) {
      return (this.dataKey ? ObjectUtils.resolveFieldData(option, this.dataKey) : this.getOptionLabel(option)) + "_" + index;
    },
    getPTOptions(option, itemOptions, index, key) {
      return this.ptm(key, {
        context: {
          selected: this.isSelected(option),
          focused: this.focusedOptionIndex === this.getOptionIndex(index, itemOptions),
          disabled: this.isOptionDisabled(option)
        }
      });
    },
    isOptionDisabled(option) {
      return this.optionDisabled ? ObjectUtils.resolveFieldData(option, this.optionDisabled) : false;
    },
    isOptionGroup(option) {
      return this.optionGroupLabel && option.optionGroup && option.group;
    },
    getOptionGroupLabel(optionGroup) {
      return ObjectUtils.resolveFieldData(optionGroup, this.optionGroupLabel);
    },
    getOptionGroupChildren(optionGroup) {
      return ObjectUtils.resolveFieldData(optionGroup, this.optionGroupChildren);
    },
    getAriaPosInset(index) {
      return (this.optionGroupLabel ? index - this.visibleOptions.slice(0, index).filter((option) => this.isOptionGroup(option)).length : index) + 1;
    },
    show(isFocus) {
      this.$emit("before-show");
      this.dirty = true;
      this.overlayVisible = true;
      this.focusedOptionIndex = this.focusedOptionIndex !== -1 ? this.focusedOptionIndex : this.autoOptionFocus ? this.findFirstFocusedOptionIndex() : -1;
      isFocus && DomHandler.focus(this.$refs.focusInput);
    },
    hide(isFocus) {
      const _hide = () => {
        this.$emit("before-hide");
        this.dirty = isFocus;
        this.overlayVisible = false;
        this.focusedOptionIndex = -1;
        isFocus && DomHandler.focus(this.$refs.focusInput);
      };
      setTimeout(() => {
        _hide();
      }, 0);
    },
    onFocus(event2) {
      if (this.disabled) {
        return;
      }
      if (!this.dirty && this.completeOnFocus) {
        this.search(event2, event2.target.value, "focus");
      }
      this.dirty = true;
      this.focused = true;
      this.focusedOptionIndex = this.focusedOptionIndex !== -1 ? this.focusedOptionIndex : this.overlayVisible && this.autoOptionFocus ? this.findFirstFocusedOptionIndex() : -1;
      this.overlayVisible && this.scrollInView(this.focusedOptionIndex);
      this.$emit("focus", event2);
    },
    onBlur(event2) {
      this.dirty = false;
      this.focused = false;
      this.focusedOptionIndex = -1;
      this.$emit("blur", event2);
    },
    onKeyDown(event2) {
      if (this.disabled) {
        event2.preventDefault();
        return;
      }
      switch (event2.code) {
        case "ArrowDown":
          this.onArrowDownKey(event2);
          break;
        case "ArrowUp":
          this.onArrowUpKey(event2);
          break;
        case "ArrowLeft":
          this.onArrowLeftKey(event2);
          break;
        case "ArrowRight":
          this.onArrowRightKey(event2);
          break;
        case "Home":
          this.onHomeKey(event2);
          break;
        case "End":
          this.onEndKey(event2);
          break;
        case "PageDown":
          this.onPageDownKey(event2);
          break;
        case "PageUp":
          this.onPageUpKey(event2);
          break;
        case "Enter":
        case "NumpadEnter":
          this.onEnterKey(event2);
          break;
        case "Escape":
          this.onEscapeKey(event2);
          break;
        case "Tab":
          this.onTabKey(event2);
          break;
        case "Backspace":
          this.onBackspaceKey(event2);
          break;
      }
    },
    onInput(event2) {
      if (this.searchTimeout) {
        clearTimeout(this.searchTimeout);
      }
      let query = event2.target.value;
      if (!this.multiple) {
        this.updateModel(event2, query);
      }
      if (query.length === 0) {
        this.hide();
        this.$emit("clear");
      } else {
        if (query.length >= this.minLength) {
          this.focusedOptionIndex = -1;
          this.searchTimeout = setTimeout(() => {
            this.search(event2, query, "input");
          }, this.delay);
        } else {
          this.hide();
        }
      }
    },
    onChange(event2) {
      if (this.forceSelection) {
        let valid = false;
        if (this.visibleOptions) {
          const matchedValue = this.visibleOptions.find((option) => this.isOptionMatched(option, this.$refs.focusInput.value || ""));
          if (matchedValue !== void 0) {
            valid = true;
            !this.isSelected(matchedValue) && this.onOptionSelect(event2, matchedValue);
          }
        }
        if (!valid) {
          this.$refs.focusInput.value = "";
          this.$emit("clear");
          !this.multiple && this.updateModel(event2, null);
        }
      }
    },
    onMultipleContainerFocus() {
      if (this.disabled) {
        return;
      }
      this.focused = true;
    },
    onMultipleContainerBlur() {
      this.focusedMultipleOptionIndex = -1;
      this.focused = false;
    },
    onMultipleContainerKeyDown(event2) {
      if (this.disabled) {
        event2.preventDefault();
        return;
      }
      switch (event2.code) {
        case "ArrowLeft":
          this.onArrowLeftKeyOnMultiple(event2);
          break;
        case "ArrowRight":
          this.onArrowRightKeyOnMultiple(event2);
          break;
        case "Backspace":
          this.onBackspaceKeyOnMultiple(event2);
          break;
      }
    },
    onContainerClick(event2) {
      if (this.disabled || this.searching || this.isInputClicked(event2) || this.isDropdownClicked(event2)) {
        return;
      }
      if (!this.overlay || !this.overlay.contains(event2.target)) {
        DomHandler.focus(this.$refs.focusInput);
      }
    },
    onDropdownClick(event2) {
      let query = void 0;
      if (this.overlayVisible) {
        this.hide(true);
      } else {
        DomHandler.focus(this.$refs.focusInput);
        query = this.$refs.focusInput.value;
        if (this.dropdownMode === "blank")
          this.search(event2, "", "dropdown");
        else if (this.dropdownMode === "current")
          this.search(event2, query, "dropdown");
      }
      this.$emit("dropdown-click", { originalEvent: event2, query });
    },
    onOptionSelect(event2, option, isHide = true) {
      const value = this.getOptionValue(option);
      if (this.multiple) {
        this.$refs.focusInput.value = "";
        if (!this.isSelected(option)) {
          this.updateModel(event2, [...this.modelValue || [], value]);
        }
      } else {
        this.updateModel(event2, value);
      }
      this.$emit("item-select", { originalEvent: event2, value: option });
      isHide && this.hide(true);
    },
    onOptionMouseMove(event2, index) {
      if (this.focusOnHover) {
        this.changeFocusedOptionIndex(event2, index);
      }
    },
    onOverlayClick(event2) {
      OverlayEventBus.emit("overlay-click", {
        originalEvent: event2,
        target: this.$el
      });
    },
    onOverlayKeyDown(event2) {
      switch (event2.code) {
        case "Escape":
          this.onEscapeKey(event2);
          break;
      }
    },
    onArrowDownKey(event2) {
      if (!this.overlayVisible) {
        return;
      }
      const optionIndex = this.focusedOptionIndex !== -1 ? this.findNextOptionIndex(this.focusedOptionIndex) : this.findFirstFocusedOptionIndex();
      this.changeFocusedOptionIndex(event2, optionIndex);
      event2.preventDefault();
    },
    onArrowUpKey(event2) {
      if (!this.overlayVisible) {
        return;
      }
      if (event2.altKey) {
        if (this.focusedOptionIndex !== -1) {
          this.onOptionSelect(event2, this.visibleOptions[this.focusedOptionIndex]);
        }
        this.overlayVisible && this.hide();
        event2.preventDefault();
      } else {
        const optionIndex = this.focusedOptionIndex !== -1 ? this.findPrevOptionIndex(this.focusedOptionIndex) : this.findLastFocusedOptionIndex();
        this.changeFocusedOptionIndex(event2, optionIndex);
        event2.preventDefault();
      }
    },
    onArrowLeftKey(event2) {
      const target = event2.currentTarget;
      this.focusedOptionIndex = -1;
      if (this.multiple) {
        if (ObjectUtils.isEmpty(target.value) && this.hasSelectedOption) {
          DomHandler.focus(this.$refs.multiContainer);
          this.focusedMultipleOptionIndex = this.modelValue.length;
        } else {
          event2.stopPropagation();
        }
      }
    },
    onArrowRightKey(event2) {
      this.focusedOptionIndex = -1;
      this.multiple && event2.stopPropagation();
    },
    onHomeKey(event2) {
      const { currentTarget } = event2;
      const len = currentTarget.value.length;
      currentTarget.setSelectionRange(0, event2.shiftKey ? len : 0);
      this.focusedOptionIndex = -1;
      event2.preventDefault();
    },
    onEndKey(event2) {
      const { currentTarget } = event2;
      const len = currentTarget.value.length;
      currentTarget.setSelectionRange(event2.shiftKey ? 0 : len, len);
      this.focusedOptionIndex = -1;
      event2.preventDefault();
    },
    onPageUpKey(event2) {
      this.scrollInView(0);
      event2.preventDefault();
    },
    onPageDownKey(event2) {
      this.scrollInView(this.visibleOptions.length - 1);
      event2.preventDefault();
    },
    onEnterKey(event2) {
      if (!this.overlayVisible) {
        this.onArrowDownKey(event2);
      } else {
        if (this.focusedOptionIndex !== -1) {
          this.onOptionSelect(event2, this.visibleOptions[this.focusedOptionIndex]);
        }
        this.hide();
      }
      event2.preventDefault();
    },
    onEscapeKey(event2) {
      this.overlayVisible && this.hide(true);
      event2.preventDefault();
    },
    onTabKey(event2) {
      if (this.focusedOptionIndex !== -1) {
        this.onOptionSelect(event2, this.visibleOptions[this.focusedOptionIndex]);
      }
      this.overlayVisible && this.hide();
    },
    onBackspaceKey(event2) {
      if (this.multiple) {
        if (ObjectUtils.isNotEmpty(this.modelValue) && !this.$refs.focusInput.value) {
          const removedValue = this.modelValue[this.modelValue.length - 1];
          const newValue = this.modelValue.slice(0, -1);
          this.$emit("update:modelValue", newValue);
          this.$emit("item-unselect", { originalEvent: event2, value: removedValue });
        }
        event2.stopPropagation();
      }
    },
    onArrowLeftKeyOnMultiple() {
      this.focusedMultipleOptionIndex = this.focusedMultipleOptionIndex < 1 ? 0 : this.focusedMultipleOptionIndex - 1;
    },
    onArrowRightKeyOnMultiple() {
      this.focusedMultipleOptionIndex++;
      if (this.focusedMultipleOptionIndex > this.modelValue.length - 1) {
        this.focusedMultipleOptionIndex = -1;
        DomHandler.focus(this.$refs.focusInput);
      }
    },
    onBackspaceKeyOnMultiple(event2) {
      if (this.focusedMultipleOptionIndex !== -1) {
        this.removeOption(event2, this.focusedMultipleOptionIndex);
      }
    },
    onOverlayEnter(el) {
      ZIndexUtils.set("overlay", el, this.$primevue.config.zIndex.overlay);
      this.alignOverlay();
    },
    onOverlayAfterEnter() {
      this.bindOutsideClickListener();
      this.bindScrollListener();
      this.bindResizeListener();
      this.$emit("show");
    },
    onOverlayLeave() {
      this.unbindOutsideClickListener();
      this.unbindScrollListener();
      this.unbindResizeListener();
      this.$emit("hide");
      this.overlay = null;
    },
    onOverlayAfterLeave(el) {
      ZIndexUtils.clear(el);
    },
    alignOverlay() {
      let target = this.multiple ? this.$refs.multiContainer : this.$refs.focusInput;
      if (this.appendTo === "self") {
        DomHandler.relativePosition(this.overlay, target);
      } else {
        this.overlay.style.minWidth = DomHandler.getOuterWidth(target) + "px";
        DomHandler.absolutePosition(this.overlay, target);
      }
    },
    bindOutsideClickListener() {
      if (!this.outsideClickListener) {
        this.outsideClickListener = (event2) => {
          if (this.overlayVisible && this.overlay && this.isOutsideClicked(event2)) {
            this.hide();
          }
        };
        document.addEventListener("click", this.outsideClickListener);
      }
    },
    unbindOutsideClickListener() {
      if (this.outsideClickListener) {
        document.removeEventListener("click", this.outsideClickListener);
        this.outsideClickListener = null;
      }
    },
    bindScrollListener() {
      if (!this.scrollHandler) {
        this.scrollHandler = new ConnectedOverlayScrollHandler(this.$refs.container, () => {
          if (this.overlayVisible) {
            this.hide();
          }
        });
      }
      this.scrollHandler.bindScrollListener();
    },
    unbindScrollListener() {
      if (this.scrollHandler) {
        this.scrollHandler.unbindScrollListener();
      }
    },
    bindResizeListener() {
      if (!this.resizeListener) {
        this.resizeListener = () => {
          if (this.overlayVisible && !DomHandler.isTouchDevice()) {
            this.hide();
          }
        };
        window.addEventListener("resize", this.resizeListener);
      }
    },
    unbindResizeListener() {
      if (this.resizeListener) {
        window.removeEventListener("resize", this.resizeListener);
        this.resizeListener = null;
      }
    },
    isOutsideClicked(event2) {
      return !this.overlay.contains(event2.target) && !this.isInputClicked(event2) && !this.isDropdownClicked(event2);
    },
    isInputClicked(event2) {
      if (this.multiple)
        return event2.target === this.$refs.multiContainer || this.$refs.multiContainer.contains(event2.target);
      else
        return event2.target === this.$refs.focusInput;
    },
    isDropdownClicked(event2) {
      return this.$refs.dropdownButton ? event2.target === this.$refs.dropdownButton || this.$refs.dropdownButton.$el.contains(event2.target) : false;
    },
    isOptionMatched(option, value) {
      return this.isValidOption(option) && this.getOptionLabel(option).toLocaleLowerCase(this.searchLocale) === value.toLocaleLowerCase(this.searchLocale);
    },
    isValidOption(option) {
      return option && !(this.isOptionDisabled(option) || this.isOptionGroup(option));
    },
    isValidSelectedOption(option) {
      return this.isValidOption(option) && this.isSelected(option);
    },
    isSelected(option) {
      return ObjectUtils.equals(this.modelValue, this.getOptionValue(option), this.equalityKey);
    },
    findFirstOptionIndex() {
      return this.visibleOptions.findIndex((option) => this.isValidOption(option));
    },
    findLastOptionIndex() {
      return ObjectUtils.findLastIndex(this.visibleOptions, (option) => this.isValidOption(option));
    },
    findNextOptionIndex(index) {
      const matchedOptionIndex = index < this.visibleOptions.length - 1 ? this.visibleOptions.slice(index + 1).findIndex((option) => this.isValidOption(option)) : -1;
      return matchedOptionIndex > -1 ? matchedOptionIndex + index + 1 : index;
    },
    findPrevOptionIndex(index) {
      const matchedOptionIndex = index > 0 ? ObjectUtils.findLastIndex(this.visibleOptions.slice(0, index), (option) => this.isValidOption(option)) : -1;
      return matchedOptionIndex > -1 ? matchedOptionIndex : index;
    },
    findSelectedOptionIndex() {
      return this.hasSelectedOption ? this.visibleOptions.findIndex((option) => this.isValidSelectedOption(option)) : -1;
    },
    findFirstFocusedOptionIndex() {
      const selectedIndex = this.findSelectedOptionIndex();
      return selectedIndex < 0 ? this.findFirstOptionIndex() : selectedIndex;
    },
    findLastFocusedOptionIndex() {
      const selectedIndex = this.findSelectedOptionIndex();
      return selectedIndex < 0 ? this.findLastOptionIndex() : selectedIndex;
    },
    search(event2, query, source) {
      if (query === void 0 || query === null) {
        return;
      }
      if (source === "input" && query.trim().length === 0) {
        return;
      }
      this.searching = true;
      this.$emit("complete", { originalEvent: event2, query });
    },
    removeOption(event2, index) {
      const removedOption = this.modelValue[index];
      const value = this.modelValue.filter((_, i) => i !== index).map((option) => this.getOptionValue(option));
      this.updateModel(event2, value);
      this.$emit("item-unselect", { originalEvent: event2, value: removedOption });
      this.dirty = true;
      DomHandler.focus(this.$refs.focusInput);
    },
    changeFocusedOptionIndex(event2, index) {
      if (this.focusedOptionIndex !== index) {
        this.focusedOptionIndex = index;
        this.scrollInView();
        if (this.selectOnFocus || this.autoHighlight) {
          this.onOptionSelect(event2, this.visibleOptions[index], false);
        }
      }
    },
    scrollInView(index = -1) {
      const id = index !== -1 ? `${this.id}_${index}` : this.focusedOptionId;
      const element = DomHandler.findSingle(this.list, `li[id="${id}"]`);
      if (element) {
        element.scrollIntoView && element.scrollIntoView({ block: "nearest", inline: "start" });
      } else if (!this.virtualScrollerDisabled) {
        setTimeout(() => {
          this.virtualScroller && this.virtualScroller.scrollToIndex(index !== -1 ? index : this.focusedOptionIndex);
        }, 0);
      }
    },
    autoUpdateModel() {
      if ((this.selectOnFocus || this.autoHighlight) && this.autoOptionFocus && !this.hasSelectedOption) {
        this.focusedOptionIndex = this.findFirstFocusedOptionIndex();
        this.onOptionSelect(null, this.visibleOptions[this.focusedOptionIndex], false);
      }
    },
    updateModel(event2, value) {
      this.$emit("update:modelValue", value);
      this.$emit("change", { originalEvent: event2, value });
    },
    flatOptions(options) {
      return (options || []).reduce((result, option, index) => {
        result.push({ optionGroup: option, group: true, index });
        const optionGroupChildren = this.getOptionGroupChildren(option);
        optionGroupChildren && optionGroupChildren.forEach((o) => result.push(o));
        return result;
      }, []);
    },
    overlayRef(el) {
      this.overlay = el;
    },
    listRef(el, contentRef) {
      this.list = el;
      contentRef && contentRef(el);
    },
    virtualScrollerRef(el) {
      this.virtualScroller = el;
    }
  },
  computed: {
    containerClass() {
      return [
        "p-autocomplete p-component p-inputwrapper",
        {
          "p-disabled": this.disabled,
          "p-focus": this.focused,
          "p-autocomplete-dd": this.dropdown,
          "p-autocomplete-multiple": this.multiple,
          "p-inputwrapper-filled": this.modelValue || ObjectUtils.isNotEmpty(this.inputValue),
          "p-inputwrapper-focus": this.focused,
          "p-overlay-open": this.overlayVisible
        }
      ];
    },
    inputStyleClass() {
      return [
        "p-autocomplete-input p-inputtext p-component",
        this.inputClass,
        {
          "p-autocomplete-dd-input": this.dropdown
        }
      ];
    },
    multiContainerClass() {
      return ["p-autocomplete-multiple-container p-component p-inputtext"];
    },
    panelStyleClass() {
      return [
        "p-autocomplete-panel p-component",
        this.panelClass,
        {
          "p-input-filled": this.$primevue.config.inputStyle === "filled",
          "p-ripple-disabled": this.$primevue.config.ripple === false
        }
      ];
    },
    visibleOptions() {
      return this.optionGroupLabel ? this.flatOptions(this.suggestions) : this.suggestions || [];
    },
    inputValue() {
      if (this.modelValue) {
        if (typeof this.modelValue === "object") {
          const label = this.getOptionLabel(this.modelValue);
          return label != null ? label : this.modelValue;
        } else {
          return this.modelValue;
        }
      } else {
        return "";
      }
    },
    hasSelectedOption() {
      return ObjectUtils.isNotEmpty(this.modelValue);
    },
    equalityKey() {
      return this.dataKey;
    },
    searchResultMessageText() {
      return ObjectUtils.isNotEmpty(this.visibleOptions) && this.overlayVisible ? this.searchMessageText.replaceAll("{0}", this.visibleOptions.length) : this.emptySearchMessageText;
    },
    searchMessageText() {
      return this.searchMessage || this.$primevue.config.locale.searchMessage || "";
    },
    emptySearchMessageText() {
      return this.emptySearchMessage || this.$primevue.config.locale.emptySearchMessage || "";
    },
    selectionMessageText() {
      return this.selectionMessage || this.$primevue.config.locale.selectionMessage || "";
    },
    emptySelectionMessageText() {
      return this.emptySelectionMessage || this.$primevue.config.locale.emptySelectionMessage || "";
    },
    selectedMessageText() {
      return this.hasSelectedOption ? this.selectionMessageText.replaceAll("{0}", this.multiple ? this.modelValue.length : "1") : this.emptySelectionMessageText;
    },
    focusedOptionId() {
      return this.focusedOptionIndex !== -1 ? `${this.id}_${this.focusedOptionIndex}` : null;
    },
    focusedMultipleOptionId() {
      return this.focusedMultipleOptionIndex !== -1 ? `${this.id}_multiple_option_${this.focusedMultipleOptionIndex}` : null;
    },
    ariaSetSize() {
      return this.visibleOptions.filter((option) => !this.isOptionGroup(option)).length;
    },
    virtualScrollerDisabled() {
      return !this.virtualScrollerOptions;
    }
  },
  components: {
    Button: script$T,
    VirtualScroller: script$P,
    Portal: script$Q,
    ChevronDownIcon: script$S,
    SpinnerIcon: script$U,
    TimesCircleIcon: script$R
  },
  directives: {
    ripple: Ripple
  }
};
const _hoisted_1$K = ["id", "value", "placeholder", "tabindex", "disabled", "aria-label", "aria-labelledby", "aria-expanded", "aria-controls", "aria-activedescendant"];
const _hoisted_2$v = ["aria-activedescendant"];
const _hoisted_3$k = ["id", "aria-label", "aria-setsize", "aria-posinset"];
const _hoisted_4$5 = ["id", "placeholder", "tabindex", "disabled", "aria-label", "aria-labelledby", "aria-expanded", "aria-controls", "aria-activedescendant"];
const _hoisted_5$3 = ["id"];
const _hoisted_6$3 = ["id"];
const _hoisted_7$3 = ["id", "aria-label", "aria-selected", "aria-disabled", "aria-setsize", "aria-posinset", "onClick", "onMousemove"];
function render$O(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_SpinnerIcon = resolveComponent("SpinnerIcon");
  const _component_Button = resolveComponent("Button");
  const _component_VirtualScroller = resolveComponent("VirtualScroller");
  const _component_Portal = resolveComponent("Portal");
  const _directive_ripple = resolveDirective("ripple");
  return openBlock(), createElementBlock("div", mergeProps({
    ref: "container",
    class: $options.containerClass,
    onClick: _cache[15] || (_cache[15] = (...args) => $options.onContainerClick && $options.onContainerClick(...args))
  }, _ctx.ptm("root")), [
    !$props.multiple ? (openBlock(), createElementBlock("input", mergeProps({
      key: 0,
      ref: "focusInput",
      id: $props.inputId,
      type: "text",
      style: $props.inputStyle,
      class: $options.inputStyleClass,
      value: $options.inputValue,
      placeholder: $props.placeholder,
      tabindex: !$props.disabled ? $props.tabindex : -1,
      disabled: $props.disabled,
      autocomplete: "off",
      role: "combobox",
      "aria-label": _ctx.ariaLabel,
      "aria-labelledby": _ctx.ariaLabelledby,
      "aria-haspopup": "listbox",
      "aria-autocomplete": "list",
      "aria-expanded": $data.overlayVisible,
      "aria-controls": $data.id + "_list",
      "aria-activedescendant": $data.focused ? $options.focusedOptionId : void 0,
      onFocus: _cache[0] || (_cache[0] = (...args) => $options.onFocus && $options.onFocus(...args)),
      onBlur: _cache[1] || (_cache[1] = (...args) => $options.onBlur && $options.onBlur(...args)),
      onKeydown: _cache[2] || (_cache[2] = (...args) => $options.onKeyDown && $options.onKeyDown(...args)),
      onInput: _cache[3] || (_cache[3] = (...args) => $options.onInput && $options.onInput(...args)),
      onChange: _cache[4] || (_cache[4] = (...args) => $options.onChange && $options.onChange(...args))
    }, { ...$props.inputProps, ..._ctx.ptm("input") }), null, 16, _hoisted_1$K)) : createCommentVNode("", true),
    $props.multiple ? (openBlock(), createElementBlock("ul", mergeProps({
      key: 1,
      ref: "multiContainer",
      class: $options.multiContainerClass,
      tabindex: "-1",
      role: "listbox",
      "aria-orientation": "horizontal",
      "aria-activedescendant": $data.focused ? $options.focusedMultipleOptionId : void 0,
      onFocus: _cache[10] || (_cache[10] = (...args) => $options.onMultipleContainerFocus && $options.onMultipleContainerFocus(...args)),
      onBlur: _cache[11] || (_cache[11] = (...args) => $options.onMultipleContainerBlur && $options.onMultipleContainerBlur(...args)),
      onKeydown: _cache[12] || (_cache[12] = (...args) => $options.onMultipleContainerKeyDown && $options.onMultipleContainerKeyDown(...args))
    }, _ctx.ptm("container")), [
      (openBlock(true), createElementBlock(Fragment, null, renderList($props.modelValue, (option, i) => {
        return openBlock(), createElementBlock("li", mergeProps({
          key: i,
          id: $data.id + "_multiple_option_" + i,
          class: ["p-autocomplete-token", { "p-focus": $data.focusedMultipleOptionIndex === i }],
          role: "option",
          "aria-label": $options.getOptionLabel(option),
          "aria-selected": true,
          "aria-setsize": $props.modelValue.length,
          "aria-posinset": i + 1
        }, _ctx.ptm("token")), [
          renderSlot(_ctx.$slots, "chip", { value: option }, () => [
            createElementVNode("span", mergeProps({ class: "p-autocomplete-token-label" }, _ctx.ptm("tokenLabel")), toDisplayString($options.getOptionLabel(option)), 17)
          ]),
          renderSlot(_ctx.$slots, "removetokenicon", {
            class: "p-autocomplete-token-icon",
            onClick: (event2) => $options.removeOption(event2, i)
          }, () => [
            (openBlock(), createBlock(resolveDynamicComponent($props.removeTokenIcon ? "span" : "TimesCircleIcon"), mergeProps({
              class: ["p-autocomplete-token-icon", $props.removeTokenIcon],
              onClick: ($event) => $options.removeOption($event, i),
              "aria-hidden": "true"
            }, _ctx.ptm("removeTokenIcon")), null, 16, ["class", "onClick"]))
          ])
        ], 16, _hoisted_3$k);
      }), 128)),
      createElementVNode("li", mergeProps({
        class: "p-autocomplete-input-token",
        role: "option"
      }, _ctx.ptm("token")), [
        createElementVNode("input", mergeProps({
          ref: "focusInput",
          id: $props.inputId,
          type: "text",
          style: $props.inputStyle,
          class: $props.inputClass,
          placeholder: $props.placeholder,
          tabindex: !$props.disabled ? $props.tabindex : -1,
          disabled: $props.disabled,
          autocomplete: "off",
          role: "combobox",
          "aria-label": _ctx.ariaLabel,
          "aria-labelledby": _ctx.ariaLabelledby,
          "aria-haspopup": "listbox",
          "aria-autocomplete": "list",
          "aria-expanded": $data.overlayVisible,
          "aria-controls": $data.id + "_list",
          "aria-activedescendant": $data.focused ? $options.focusedOptionId : void 0,
          onFocus: _cache[5] || (_cache[5] = (...args) => $options.onFocus && $options.onFocus(...args)),
          onBlur: _cache[6] || (_cache[6] = (...args) => $options.onBlur && $options.onBlur(...args)),
          onKeydown: _cache[7] || (_cache[7] = (...args) => $options.onKeyDown && $options.onKeyDown(...args)),
          onInput: _cache[8] || (_cache[8] = (...args) => $options.onInput && $options.onInput(...args)),
          onChange: _cache[9] || (_cache[9] = (...args) => $options.onChange && $options.onChange(...args))
        }, { ...$props.inputProps, ..._ctx.ptm("input") }), null, 16, _hoisted_4$5)
      ], 16)
    ], 16, _hoisted_2$v)) : createCommentVNode("", true),
    $data.searching ? renderSlot(_ctx.$slots, "loadingicon", { key: 2 }, () => [
      $props.loadingIcon ? (openBlock(), createElementBlock("i", mergeProps({
        key: 0,
        class: ["p-autocomplete-loader pi-spin", $props.loadingIcon],
        "aria-hidden": "true"
      }, _ctx.ptm("loadingIcon")), null, 16)) : (openBlock(), createBlock(_component_SpinnerIcon, mergeProps({
        key: 1,
        class: "p-autocomplete-loader",
        spin: "",
        "aria-hidden": "true"
      }, _ctx.ptm("loadingIcon")), null, 16))
    ]) : createCommentVNode("", true),
    $props.dropdown ? (openBlock(), createBlock(_component_Button, {
      key: 3,
      ref: "dropdownButton",
      type: "button",
      tabindex: "-1",
      class: normalizeClass(["p-autocomplete-dropdown", $props.dropdownClass]),
      disabled: $props.disabled,
      "aria-hidden": "true",
      onClick: $options.onDropdownClick,
      pt: _ctx.ptm("dropdownButton")
    }, {
      icon: withCtx(() => [
        renderSlot(_ctx.$slots, "dropdownicon", {}, () => [
          (openBlock(), createBlock(resolveDynamicComponent($props.dropdownIcon ? "span" : "ChevronDownIcon"), mergeProps({ class: $props.dropdownIcon }, _ctx.ptm("dropdownButton")["icon"]), null, 16, ["class"]))
        ])
      ]),
      _: 3
    }, 8, ["class", "disabled", "onClick", "pt"])) : createCommentVNode("", true),
    createElementVNode("span", mergeProps({
      role: "status",
      "aria-live": "polite",
      class: "p-hidden-accessible"
    }, _ctx.ptm("hiddenSearchResult")), toDisplayString($options.searchResultMessageText), 17),
    createVNode(_component_Portal, { appendTo: $props.appendTo }, {
      default: withCtx(() => [
        createVNode(Transition, {
          name: "p-connected-overlay",
          onEnter: $options.onOverlayEnter,
          onAfterEnter: $options.onOverlayAfterEnter,
          onLeave: $options.onOverlayLeave,
          onAfterLeave: $options.onOverlayAfterLeave
        }, {
          default: withCtx(() => [
            $data.overlayVisible ? (openBlock(), createElementBlock("div", mergeProps({
              key: 0,
              ref: $options.overlayRef,
              class: $options.panelStyleClass,
              style: { ...$props.panelStyle, "max-height": $options.virtualScrollerDisabled ? $props.scrollHeight : "" },
              onClick: _cache[13] || (_cache[13] = (...args) => $options.onOverlayClick && $options.onOverlayClick(...args)),
              onKeydown: _cache[14] || (_cache[14] = (...args) => $options.onOverlayKeyDown && $options.onOverlayKeyDown(...args))
            }, { ...$props.panelProps, ..._ctx.ptm("panel") }), [
              renderSlot(_ctx.$slots, "header", {
                value: $props.modelValue,
                suggestions: $options.visibleOptions
              }),
              createVNode(_component_VirtualScroller, mergeProps({ ref: $options.virtualScrollerRef }, { ...$props.virtualScrollerOptions, ..._ctx.ptm("virtualScroller") }, {
                style: { height: $props.scrollHeight },
                items: $options.visibleOptions,
                tabindex: -1,
                disabled: $options.virtualScrollerDisabled
              }), createSlots({
                content: withCtx(({ styleClass, contentRef, items, getItemOptions, contentStyle, itemSize }) => [
                  createElementVNode("ul", mergeProps({
                    ref: (el) => $options.listRef(el, contentRef),
                    id: $data.id + "_list",
                    class: ["p-autocomplete-items", styleClass],
                    style: contentStyle,
                    role: "listbox"
                  }, _ctx.ptm("list")), [
                    (openBlock(true), createElementBlock(Fragment, null, renderList(items, (option, i) => {
                      return openBlock(), createElementBlock(Fragment, {
                        key: $options.getOptionRenderKey(option, $options.getOptionIndex(i, getItemOptions))
                      }, [
                        $options.isOptionGroup(option) ? (openBlock(), createElementBlock("li", mergeProps({
                          key: 0,
                          id: $data.id + "_" + $options.getOptionIndex(i, getItemOptions),
                          style: { height: itemSize ? itemSize + "px" : void 0 },
                          class: "p-autocomplete-item-group",
                          role: "option"
                        }, _ctx.ptm("itemGroup")), [
                          renderSlot(_ctx.$slots, "optiongroup", {
                            option: option.optionGroup,
                            item: option.optionGroup,
                            index: $options.getOptionIndex(i, getItemOptions)
                          }, () => [
                            createTextVNode(toDisplayString($options.getOptionGroupLabel(option.optionGroup)), 1)
                          ])
                        ], 16, _hoisted_6$3)) : withDirectives((openBlock(), createElementBlock("li", mergeProps({
                          key: 1,
                          id: $data.id + "_" + $options.getOptionIndex(i, getItemOptions),
                          style: { height: itemSize ? itemSize + "px" : void 0 },
                          class: ["p-autocomplete-item", { "p-highlight": $options.isSelected(option), "p-focus": $data.focusedOptionIndex === $options.getOptionIndex(i, getItemOptions), "p-disabled": $options.isOptionDisabled(option) }],
                          role: "option",
                          "aria-label": $options.getOptionLabel(option),
                          "aria-selected": $options.isSelected(option),
                          "aria-disabled": $options.isOptionDisabled(option),
                          "aria-setsize": $options.ariaSetSize,
                          "aria-posinset": $options.getAriaPosInset($options.getOptionIndex(i, getItemOptions)),
                          onClick: ($event) => $options.onOptionSelect($event, option),
                          onMousemove: ($event) => $options.onOptionMouseMove($event, $options.getOptionIndex(i, getItemOptions))
                        }, $options.getPTOptions(option, getItemOptions, i, "item")), [
                          _ctx.$slots.option ? renderSlot(_ctx.$slots, "option", {
                            key: 0,
                            option,
                            index: $options.getOptionIndex(i, getItemOptions)
                          }, () => [
                            createTextVNode(toDisplayString($options.getOptionLabel(option)), 1)
                          ]) : renderSlot(_ctx.$slots, "item", {
                            key: 1,
                            item: option,
                            index: $options.getOptionIndex(i, getItemOptions)
                          }, () => [
                            createTextVNode(toDisplayString($options.getOptionLabel(option)), 1)
                          ])
                        ], 16, _hoisted_7$3)), [
                          [_directive_ripple]
                        ])
                      ], 64);
                    }), 128)),
                    !items || items && items.length === 0 ? (openBlock(), createElementBlock("li", mergeProps({
                      key: 0,
                      class: "p-autocomplete-empty-message",
                      role: "option"
                    }, _ctx.ptm("emptyMessage")), [
                      renderSlot(_ctx.$slots, "empty", {}, () => [
                        createTextVNode(toDisplayString($options.searchResultMessageText), 1)
                      ])
                    ], 16)) : createCommentVNode("", true)
                  ], 16, _hoisted_5$3)
                ]),
                _: 2
              }, [
                _ctx.$slots.loader ? {
                  name: "loader",
                  fn: withCtx(({ options }) => [
                    renderSlot(_ctx.$slots, "loader", { options })
                  ]),
                  key: "0"
                } : void 0
              ]), 1040, ["style", "items", "disabled"]),
              renderSlot(_ctx.$slots, "footer", {
                value: $props.modelValue,
                suggestions: $options.visibleOptions
              }),
              createElementVNode("span", mergeProps({
                role: "status",
                "aria-live": "polite",
                class: "p-hidden-accessible"
              }, _ctx.ptm("hiddenSelectedMessage")), toDisplayString($options.selectedMessageText), 17)
            ], 16)) : createCommentVNode("", true)
          ]),
          _: 3
        }, 8, ["onEnter", "onAfterEnter", "onLeave", "onAfterLeave"])
      ]),
      _: 3
    }, 8, ["appendTo"])
  ], 16);
}
function styleInject$f(css, ref2) {
  if (ref2 === void 0)
    ref2 = {};
  var insertAt = ref2.insertAt;
  if (!css || true) {
    return;
  }
  var head = document.head || document.getElementsByTagName("head")[0];
  var style = document.createElement("style");
  style.type = "text/css";
  if (insertAt === "top") {
    if (head.firstChild) {
      head.insertBefore(style, head.firstChild);
    } else {
      head.appendChild(style);
    }
  } else {
    head.appendChild(style);
  }
  if (style.styleSheet) {
    style.styleSheet.cssText = css;
  } else {
    style.appendChild(document.createTextNode(css));
  }
}
var css_248z$f = "\n.p-autocomplete {\n    display: inline-flex;\n    position: relative;\n}\n.p-autocomplete-loader {\n    position: absolute;\n    top: 50%;\n    margin-top: -0.5rem;\n}\n.p-autocomplete-dd .p-autocomplete-input {\n    flex: 1 1 auto;\n    width: 1%;\n}\n.p-autocomplete-dd .p-autocomplete-input,\n.p-autocomplete-dd .p-autocomplete-multiple-container {\n    border-top-right-radius: 0;\n    border-bottom-right-radius: 0;\n}\n.p-autocomplete-dd .p-autocomplete-dropdown {\n    border-top-left-radius: 0;\n    border-bottom-left-radius: 0px;\n}\n.p-autocomplete .p-autocomplete-panel {\n    min-width: 100%;\n}\n.p-autocomplete-panel {\n    position: absolute;\n    overflow: auto;\n    top: 0;\n    left: 0;\n}\n.p-autocomplete-items {\n    margin: 0;\n    padding: 0;\n    list-style-type: none;\n}\n.p-autocomplete-item {\n    cursor: pointer;\n    white-space: nowrap;\n    position: relative;\n    overflow: hidden;\n}\n.p-autocomplete-multiple-container {\n    margin: 0;\n    padding: 0;\n    list-style-type: none;\n    cursor: text;\n    overflow: hidden;\n    display: flex;\n    align-items: center;\n    flex-wrap: wrap;\n}\n.p-autocomplete-token {\n    cursor: default;\n    display: inline-flex;\n    align-items: center;\n    flex: 0 0 auto;\n}\n.p-autocomplete-token-icon {\n    cursor: pointer;\n}\n.p-autocomplete-input-token {\n    flex: 1 1 auto;\n    display: inline-flex;\n}\n.p-autocomplete-input-token input {\n    border: 0 none;\n    outline: 0 none;\n    background-color: transparent;\n    margin: 0;\n    padding: 0;\n    box-shadow: none;\n    border-radius: 0;\n    width: 100%;\n}\n.p-fluid .p-autocomplete {\n    display: flex;\n}\n.p-fluid .p-autocomplete-dd .p-autocomplete-input {\n    width: 1%;\n}\n";
styleInject$f(css_248z$f);
script$O.render = render$O;
var script$N = {
  name: "CalendarIcon",
  extends: script$V
};
const _hoisted_1$J = /* @__PURE__ */ createElementVNode("path", {
  d: "M10.7838 1.51351H9.83783V0.567568C9.83783 0.417039 9.77804 0.272676 9.6716 0.166237C9.56516 0.0597971 9.42079 0 9.27027 0C9.11974 0 8.97538 0.0597971 8.86894 0.166237C8.7625 0.272676 8.7027 0.417039 8.7027 0.567568V1.51351H5.29729V0.567568C5.29729 0.417039 5.2375 0.272676 5.13106 0.166237C5.02462 0.0597971 4.88025 0 4.72973 0C4.5792 0 4.43484 0.0597971 4.3284 0.166237C4.22196 0.272676 4.16216 0.417039 4.16216 0.567568V1.51351H3.21621C2.66428 1.51351 2.13494 1.73277 1.74467 2.12305C1.35439 2.51333 1.13513 3.04266 1.13513 3.59459V11.9189C1.13513 12.4709 1.35439 13.0002 1.74467 13.3905C2.13494 13.7807 2.66428 14 3.21621 14H10.7838C11.3357 14 11.865 13.7807 12.2553 13.3905C12.6456 13.0002 12.8649 12.4709 12.8649 11.9189V3.59459C12.8649 3.04266 12.6456 2.51333 12.2553 2.12305C11.865 1.73277 11.3357 1.51351 10.7838 1.51351ZM3.21621 2.64865H4.16216V3.59459C4.16216 3.74512 4.22196 3.88949 4.3284 3.99593C4.43484 4.10237 4.5792 4.16216 4.72973 4.16216C4.88025 4.16216 5.02462 4.10237 5.13106 3.99593C5.2375 3.88949 5.29729 3.74512 5.29729 3.59459V2.64865H8.7027V3.59459C8.7027 3.74512 8.7625 3.88949 8.86894 3.99593C8.97538 4.10237 9.11974 4.16216 9.27027 4.16216C9.42079 4.16216 9.56516 4.10237 9.6716 3.99593C9.77804 3.88949 9.83783 3.74512 9.83783 3.59459V2.64865H10.7838C11.0347 2.64865 11.2753 2.74831 11.4527 2.92571C11.6301 3.10311 11.7297 3.34371 11.7297 3.59459V5.67568H2.27027V3.59459C2.27027 3.34371 2.36993 3.10311 2.54733 2.92571C2.72473 2.74831 2.96533 2.64865 3.21621 2.64865ZM10.7838 12.8649H3.21621C2.96533 12.8649 2.72473 12.7652 2.54733 12.5878C2.36993 12.4104 2.27027 12.1698 2.27027 11.9189V6.81081H11.7297V11.9189C11.7297 12.1698 11.6301 12.4104 11.4527 12.5878C11.2753 12.7652 11.0347 12.8649 10.7838 12.8649Z",
  fill: "currentColor"
}, null, -1);
const _hoisted_2$u = [
  _hoisted_1$J
];
function render$N(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("svg", mergeProps({
    width: "14",
    height: "14",
    viewBox: "0 0 14 14",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, _ctx.pti()), _hoisted_2$u, 16);
}
script$N.render = render$N;
var script$M = {
  name: "ChevronLeftIcon",
  extends: script$V
};
const _hoisted_1$I = /* @__PURE__ */ createElementVNode("path", {
  d: "M9.61296 13C9.50997 13.0005 9.40792 12.9804 9.3128 12.9409C9.21767 12.9014 9.13139 12.8433 9.05902 12.7701L3.83313 7.54416C3.68634 7.39718 3.60388 7.19795 3.60388 6.99022C3.60388 6.78249 3.68634 6.58325 3.83313 6.43628L9.05902 1.21039C9.20762 1.07192 9.40416 0.996539 9.60724 1.00012C9.81032 1.00371 10.0041 1.08597 10.1477 1.22959C10.2913 1.37322 10.3736 1.56698 10.3772 1.77005C10.3808 1.97313 10.3054 2.16968 10.1669 2.31827L5.49496 6.99022L10.1669 11.6622C10.3137 11.8091 10.3962 12.0084 10.3962 12.2161C10.3962 12.4238 10.3137 12.6231 10.1669 12.7701C10.0945 12.8433 10.0083 12.9014 9.91313 12.9409C9.81801 12.9804 9.71596 13.0005 9.61296 13Z",
  fill: "currentColor"
}, null, -1);
const _hoisted_2$t = [
  _hoisted_1$I
];
function render$M(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("svg", mergeProps({
    width: "14",
    height: "14",
    viewBox: "0 0 14 14",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, _ctx.pti()), _hoisted_2$t, 16);
}
script$M.render = render$M;
var script$L = {
  name: "ChevronRightIcon",
  extends: script$V
};
const _hoisted_1$H = /* @__PURE__ */ createElementVNode("path", {
  d: "M4.38708 13C4.28408 13.0005 4.18203 12.9804 4.08691 12.9409C3.99178 12.9014 3.9055 12.8433 3.83313 12.7701C3.68634 12.6231 3.60388 12.4238 3.60388 12.2161C3.60388 12.0084 3.68634 11.8091 3.83313 11.6622L8.50507 6.99022L3.83313 2.31827C3.69467 2.16968 3.61928 1.97313 3.62287 1.77005C3.62645 1.56698 3.70872 1.37322 3.85234 1.22959C3.99596 1.08597 4.18972 1.00371 4.3928 1.00012C4.59588 0.996539 4.79242 1.07192 4.94102 1.21039L10.1669 6.43628C10.3137 6.58325 10.3962 6.78249 10.3962 6.99022C10.3962 7.19795 10.3137 7.39718 10.1669 7.54416L4.94102 12.7701C4.86865 12.8433 4.78237 12.9014 4.68724 12.9409C4.59212 12.9804 4.49007 13.0005 4.38708 13Z",
  fill: "currentColor"
}, null, -1);
const _hoisted_2$s = [
  _hoisted_1$H
];
function render$L(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("svg", mergeProps({
    width: "14",
    height: "14",
    viewBox: "0 0 14 14",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, _ctx.pti()), _hoisted_2$s, 16);
}
script$L.render = render$L;
var script$K = {
  name: "ChevronUpIcon",
  extends: script$V
};
const _hoisted_1$G = /* @__PURE__ */ createElementVNode("path", {
  d: "M12.2097 10.4113C12.1057 10.4118 12.0027 10.3915 11.9067 10.3516C11.8107 10.3118 11.7237 10.2532 11.6506 10.1792L6.93602 5.46461L2.22139 10.1476C2.07272 10.244 1.89599 10.2877 1.71953 10.2717C1.54307 10.2556 1.3771 10.1808 1.24822 10.0593C1.11933 9.93766 1.035 9.77633 1.00874 9.6011C0.982477 9.42587 1.0158 9.2469 1.10338 9.09287L6.37701 3.81923C6.52533 3.6711 6.72639 3.58789 6.93602 3.58789C7.14565 3.58789 7.3467 3.6711 7.49502 3.81923L12.7687 9.09287C12.9168 9.24119 13 9.44225 13 9.65187C13 9.8615 12.9168 10.0626 12.7687 10.2109C12.616 10.3487 12.4151 10.4207 12.2097 10.4113Z",
  fill: "currentColor"
}, null, -1);
const _hoisted_2$r = [
  _hoisted_1$G
];
function render$K(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("svg", mergeProps({
    width: "14",
    height: "14",
    viewBox: "0 0 14 14",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, _ctx.pti()), _hoisted_2$r, 16);
}
script$K.render = render$K;
var script$J = {
  name: "Calendar",
  extends: script$W,
  emits: ["show", "hide", "input", "month-change", "year-change", "date-select", "update:modelValue", "today-click", "clear-click", "focus", "blur", "keydown"],
  props: {
    modelValue: null,
    selectionMode: {
      type: String,
      default: "single"
    },
    dateFormat: {
      type: String,
      default: null
    },
    inline: {
      type: Boolean,
      default: false
    },
    showOtherMonths: {
      type: Boolean,
      default: true
    },
    selectOtherMonths: {
      type: Boolean,
      default: false
    },
    showIcon: {
      type: Boolean,
      default: false
    },
    icon: {
      type: String,
      default: void 0
    },
    previousIcon: {
      type: String,
      default: void 0
    },
    nextIcon: {
      type: String,
      default: void 0
    },
    incrementIcon: {
      type: String,
      default: void 0
    },
    decrementIcon: {
      type: String,
      default: void 0
    },
    numberOfMonths: {
      type: Number,
      default: 1
    },
    responsiveOptions: Array,
    view: {
      type: String,
      default: "date"
    },
    touchUI: {
      type: Boolean,
      default: false
    },
    monthNavigator: {
      type: Boolean,
      default: false
    },
    yearNavigator: {
      type: Boolean,
      default: false
    },
    yearRange: {
      type: String,
      default: null
    },
    minDate: {
      type: Date,
      value: null
    },
    maxDate: {
      type: Date,
      value: null
    },
    disabledDates: {
      type: Array,
      value: null
    },
    disabledDays: {
      type: Array,
      value: null
    },
    maxDateCount: {
      type: Number,
      value: null
    },
    showOnFocus: {
      type: Boolean,
      default: true
    },
    autoZIndex: {
      type: Boolean,
      default: true
    },
    baseZIndex: {
      type: Number,
      default: 0
    },
    showButtonBar: {
      type: Boolean,
      default: false
    },
    shortYearCutoff: {
      type: String,
      default: "+10"
    },
    showTime: {
      type: Boolean,
      default: false
    },
    timeOnly: {
      type: Boolean,
      default: false
    },
    hourFormat: {
      type: String,
      default: "24"
    },
    stepHour: {
      type: Number,
      default: 1
    },
    stepMinute: {
      type: Number,
      default: 1
    },
    stepSecond: {
      type: Number,
      default: 1
    },
    showSeconds: {
      type: Boolean,
      default: false
    },
    hideOnDateTimeSelect: {
      type: Boolean,
      default: false
    },
    hideOnRangeSelection: {
      type: Boolean,
      default: false
    },
    timeSeparator: {
      type: String,
      default: ":"
    },
    showWeek: {
      type: Boolean,
      default: false
    },
    manualInput: {
      type: Boolean,
      default: true
    },
    appendTo: {
      type: String,
      default: "body"
    },
    disabled: {
      type: Boolean,
      default: false
    },
    readonly: {
      type: Boolean,
      default: false
    },
    placeholder: {
      type: String,
      default: null
    },
    id: {
      type: String,
      default: null
    },
    inputId: {
      type: String,
      default: null
    },
    inputClass: {
      type: [String, Object],
      default: null
    },
    inputStyle: {
      type: Object,
      default: null
    },
    inputProps: {
      type: null,
      default: null
    },
    panelClass: {
      type: [String, Object],
      default: null
    },
    panelStyle: {
      type: Object,
      default: null
    },
    panelProps: {
      type: null,
      default: null
    },
    "aria-labelledby": {
      type: String,
      default: null
    },
    "aria-label": {
      type: String,
      default: null
    }
  },
  navigationState: null,
  timePickerChange: false,
  scrollHandler: null,
  outsideClickListener: null,
  maskClickListener: null,
  resizeListener: null,
  overlay: null,
  input: null,
  mask: null,
  timePickerTimer: null,
  preventFocus: false,
  typeUpdate: false,
  data() {
    return {
      currentMonth: null,
      currentYear: null,
      currentHour: null,
      currentMinute: null,
      currentSecond: null,
      pm: null,
      focused: false,
      overlayVisible: false,
      currentView: this.view
    };
  },
  watch: {
    modelValue(newValue) {
      this.updateCurrentMetaData();
      if (!this.typeUpdate && !this.inline && this.input) {
        this.input.value = this.formatValue(newValue);
      }
      this.typeUpdate = false;
    },
    showTime() {
      this.updateCurrentMetaData();
    },
    months() {
      if (this.overlay) {
        if (!this.focused) {
          if (this.inline) {
            this.preventFocus = true;
          }
          setTimeout(this.updateFocus, 0);
        }
      }
    },
    numberOfMonths() {
      this.destroyResponsiveStyleElement();
      this.createResponsiveStyle();
    },
    responsiveOptions() {
      this.destroyResponsiveStyleElement();
      this.createResponsiveStyle();
    },
    currentView() {
      Promise.resolve(null).then(() => this.alignOverlay());
    }
  },
  created() {
    this.updateCurrentMetaData();
  },
  mounted() {
    this.createResponsiveStyle();
    if (this.inline) {
      this.overlay && this.overlay.setAttribute(this.attributeSelector, "");
      if (!this.disabled) {
        this.preventFocus = true;
        this.initFocusableCell();
        if (this.numberOfMonths === 1) {
          this.overlay.style.width = DomHandler.getOuterWidth(this.$el) + "px";
        }
      }
    } else {
      this.input.value = this.formatValue(this.modelValue);
    }
  },
  updated() {
    if (this.overlay) {
      this.preventFocus = true;
      setTimeout(this.updateFocus, 0);
    }
    if (this.input && this.selectionStart != null && this.selectionEnd != null) {
      this.input.selectionStart = this.selectionStart;
      this.input.selectionEnd = this.selectionEnd;
      this.selectionStart = null;
      this.selectionEnd = null;
    }
  },
  beforeUnmount() {
    if (this.timePickerTimer) {
      clearTimeout(this.timePickerTimer);
    }
    if (this.mask) {
      this.destroyMask();
    }
    this.destroyResponsiveStyleElement();
    this.unbindOutsideClickListener();
    this.unbindResizeListener();
    if (this.scrollHandler) {
      this.scrollHandler.destroy();
      this.scrollHandler = null;
    }
    if (this.overlay && this.autoZIndex) {
      ZIndexUtils.clear(this.overlay);
    }
    this.overlay = null;
  },
  methods: {
    isComparable() {
      return this.modelValue != null && typeof this.modelValue !== "string";
    },
    isSelected(dateMeta) {
      if (!this.isComparable()) {
        return false;
      }
      if (this.modelValue) {
        if (this.isSingleSelection()) {
          return this.isDateEquals(this.modelValue, dateMeta);
        } else if (this.isMultipleSelection()) {
          let selected = false;
          for (let date of this.modelValue) {
            selected = this.isDateEquals(date, dateMeta);
            if (selected) {
              break;
            }
          }
          return selected;
        } else if (this.isRangeSelection()) {
          if (this.modelValue[1])
            return this.isDateEquals(this.modelValue[0], dateMeta) || this.isDateEquals(this.modelValue[1], dateMeta) || this.isDateBetween(this.modelValue[0], this.modelValue[1], dateMeta);
          else {
            return this.isDateEquals(this.modelValue[0], dateMeta);
          }
        }
      }
      return false;
    },
    isMonthSelected(month) {
      if (this.isComparable()) {
        let value = this.isRangeSelection() ? this.modelValue[0] : this.modelValue;
        return !this.isMultipleSelection() ? value.getMonth() === month && value.getFullYear() === this.currentYear : false;
      }
      return false;
    },
    isYearSelected(year) {
      if (this.isComparable()) {
        let value = this.isRangeSelection() ? this.modelValue[0] : this.modelValue;
        return !this.isMultipleSelection() && this.isComparable() ? value.getFullYear() === year : false;
      }
      return false;
    },
    isDateEquals(value, dateMeta) {
      if (value)
        return value.getDate() === dateMeta.day && value.getMonth() === dateMeta.month && value.getFullYear() === dateMeta.year;
      else
        return false;
    },
    isDateBetween(start, end, dateMeta) {
      let between = false;
      if (start && end) {
        let date = new Date(dateMeta.year, dateMeta.month, dateMeta.day);
        return start.getTime() <= date.getTime() && end.getTime() >= date.getTime();
      }
      return between;
    },
    getFirstDayOfMonthIndex(month, year) {
      let day = /* @__PURE__ */ new Date();
      day.setDate(1);
      day.setMonth(month);
      day.setFullYear(year);
      let dayIndex = day.getDay() + this.sundayIndex;
      return dayIndex >= 7 ? dayIndex - 7 : dayIndex;
    },
    getDaysCountInMonth(month, year) {
      return 32 - this.daylightSavingAdjust(new Date(year, month, 32)).getDate();
    },
    getDaysCountInPrevMonth(month, year) {
      let prev = this.getPreviousMonthAndYear(month, year);
      return this.getDaysCountInMonth(prev.month, prev.year);
    },
    getPreviousMonthAndYear(month, year) {
      let m, y;
      if (month === 0) {
        m = 11;
        y = year - 1;
      } else {
        m = month - 1;
        y = year;
      }
      return { month: m, year: y };
    },
    getNextMonthAndYear(month, year) {
      let m, y;
      if (month === 11) {
        m = 0;
        y = year + 1;
      } else {
        m = month + 1;
        y = year;
      }
      return { month: m, year: y };
    },
    daylightSavingAdjust(date) {
      if (!date) {
        return null;
      }
      date.setHours(date.getHours() > 12 ? date.getHours() + 2 : 0);
      return date;
    },
    isToday(today, day, month, year) {
      return today.getDate() === day && today.getMonth() === month && today.getFullYear() === year;
    },
    isSelectable(day, month, year, otherMonth) {
      let validMin = true;
      let validMax = true;
      let validDate = true;
      let validDay = true;
      if (otherMonth && !this.selectOtherMonths) {
        return false;
      }
      if (this.minDate) {
        if (this.minDate.getFullYear() > year) {
          validMin = false;
        } else if (this.minDate.getFullYear() === year) {
          if (this.minDate.getMonth() > month) {
            validMin = false;
          } else if (this.minDate.getMonth() === month) {
            if (this.minDate.getDate() > day) {
              validMin = false;
            }
          }
        }
      }
      if (this.maxDate) {
        if (this.maxDate.getFullYear() < year) {
          validMax = false;
        } else if (this.maxDate.getFullYear() === year) {
          if (this.maxDate.getMonth() < month) {
            validMax = false;
          } else if (this.maxDate.getMonth() === month) {
            if (this.maxDate.getDate() < day) {
              validMax = false;
            }
          }
        }
      }
      if (this.disabledDates) {
        validDate = !this.isDateDisabled(day, month, year);
      }
      if (this.disabledDays) {
        validDay = !this.isDayDisabled(day, month, year);
      }
      return validMin && validMax && validDate && validDay;
    },
    onOverlayEnter(el) {
      el.setAttribute(this.attributeSelector, "");
      if (this.autoZIndex) {
        if (this.touchUI)
          ZIndexUtils.set("modal", el, this.baseZIndex || this.$primevue.config.zIndex.modal);
        else
          ZIndexUtils.set("overlay", el, this.baseZIndex || this.$primevue.config.zIndex.overlay);
      }
      this.alignOverlay();
      this.$emit("show");
    },
    onOverlayEnterComplete() {
      this.bindOutsideClickListener();
      this.bindScrollListener();
      this.bindResizeListener();
    },
    onOverlayAfterLeave(el) {
      if (this.autoZIndex) {
        ZIndexUtils.clear(el);
      }
    },
    onOverlayLeave() {
      this.currentView = this.view;
      this.unbindOutsideClickListener();
      this.unbindScrollListener();
      this.unbindResizeListener();
      this.$emit("hide");
      if (this.mask) {
        this.disableModality();
      }
      this.overlay = null;
    },
    onPrevButtonClick(event2) {
      if (this.showOtherMonths) {
        this.navigationState = { backward: true, button: true };
        this.navBackward(event2);
      }
    },
    onNextButtonClick(event2) {
      if (this.showOtherMonths) {
        this.navigationState = { backward: false, button: true };
        this.navForward(event2);
      }
    },
    navBackward(event2) {
      event2.preventDefault();
      if (!this.isEnabled()) {
        return;
      }
      if (this.currentView === "month") {
        this.decrementYear();
        this.$emit("year-change", { month: this.currentMonth, year: this.currentYear });
      } else if (this.currentView === "year") {
        this.decrementDecade();
      } else {
        if (event2.shiftKey) {
          this.decrementYear();
        } else {
          if (this.currentMonth === 0) {
            this.currentMonth = 11;
            this.decrementYear();
          } else {
            this.currentMonth--;
          }
          this.$emit("month-change", { month: this.currentMonth + 1, year: this.currentYear });
        }
      }
    },
    navForward(event2) {
      event2.preventDefault();
      if (!this.isEnabled()) {
        return;
      }
      if (this.currentView === "month") {
        this.incrementYear();
        this.$emit("year-change", { month: this.currentMonth, year: this.currentYear });
      } else if (this.currentView === "year") {
        this.incrementDecade();
      } else {
        if (event2.shiftKey) {
          this.incrementYear();
        } else {
          if (this.currentMonth === 11) {
            this.currentMonth = 0;
            this.incrementYear();
          } else {
            this.currentMonth++;
          }
          this.$emit("month-change", { month: this.currentMonth + 1, year: this.currentYear });
        }
      }
    },
    decrementYear() {
      this.currentYear--;
    },
    decrementDecade() {
      this.currentYear = this.currentYear - 10;
    },
    incrementYear() {
      this.currentYear++;
    },
    incrementDecade() {
      this.currentYear = this.currentYear + 10;
    },
    switchToMonthView(event2) {
      this.currentView = "month";
      setTimeout(this.updateFocus, 0);
      event2.preventDefault();
    },
    switchToYearView(event2) {
      this.currentView = "year";
      setTimeout(this.updateFocus, 0);
      event2.preventDefault();
    },
    isEnabled() {
      return !this.disabled && !this.readonly;
    },
    updateCurrentTimeMeta(date) {
      let currentHour = date.getHours();
      if (this.hourFormat === "12") {
        this.pm = currentHour > 11;
        if (currentHour >= 12)
          currentHour = currentHour == 12 ? 12 : currentHour - 12;
        else
          currentHour = currentHour == 0 ? 12 : currentHour;
      }
      this.currentHour = Math.floor(currentHour / this.stepHour) * this.stepHour;
      this.currentMinute = Math.floor(date.getMinutes() / this.stepMinute) * this.stepMinute;
      this.currentSecond = Math.floor(date.getSeconds() / this.stepSecond) * this.stepSecond;
    },
    bindOutsideClickListener() {
      if (!this.outsideClickListener) {
        this.outsideClickListener = (event2) => {
          if (this.overlayVisible && this.isOutsideClicked(event2)) {
            this.overlayVisible = false;
          }
        };
        document.addEventListener("mousedown", this.outsideClickListener);
      }
    },
    unbindOutsideClickListener() {
      if (this.outsideClickListener) {
        document.removeEventListener("mousedown", this.outsideClickListener);
        this.outsideClickListener = null;
      }
    },
    bindScrollListener() {
      if (!this.scrollHandler) {
        this.scrollHandler = new ConnectedOverlayScrollHandler(this.$refs.container, () => {
          if (this.overlayVisible) {
            this.overlayVisible = false;
          }
        });
      }
      this.scrollHandler.bindScrollListener();
    },
    unbindScrollListener() {
      if (this.scrollHandler) {
        this.scrollHandler.unbindScrollListener();
      }
    },
    bindResizeListener() {
      if (!this.resizeListener) {
        this.resizeListener = () => {
          if (this.overlayVisible && !DomHandler.isTouchDevice()) {
            this.overlayVisible = false;
          }
        };
        window.addEventListener("resize", this.resizeListener);
      }
    },
    unbindResizeListener() {
      if (this.resizeListener) {
        window.removeEventListener("resize", this.resizeListener);
        this.resizeListener = null;
      }
    },
    isOutsideClicked(event2) {
      return !(this.$el.isSameNode(event2.target) || this.isNavIconClicked(event2) || this.$el.contains(event2.target) || this.overlay && this.overlay.contains(event2.target));
    },
    isNavIconClicked(event2) {
      return DomHandler.hasClass(event2.target, "p-datepicker-prev") || DomHandler.hasClass(event2.target, "p-datepicker-prev-icon") || DomHandler.hasClass(event2.target, "p-datepicker-next") || DomHandler.hasClass(event2.target, "p-datepicker-next-icon");
    },
    alignOverlay() {
      if (this.touchUI) {
        this.enableModality();
      } else if (this.overlay) {
        if (this.appendTo === "self" || this.inline) {
          DomHandler.relativePosition(this.overlay, this.$el);
        } else {
          if (this.view === "date") {
            this.overlay.style.width = DomHandler.getOuterWidth(this.overlay) + "px";
            this.overlay.style.minWidth = DomHandler.getOuterWidth(this.$el) + "px";
          } else {
            this.overlay.style.width = DomHandler.getOuterWidth(this.$el) + "px";
          }
          DomHandler.absolutePosition(this.overlay, this.$el);
        }
      }
    },
    onButtonClick() {
      if (this.isEnabled()) {
        if (!this.overlayVisible) {
          this.input.focus();
          this.overlayVisible = true;
        } else {
          this.overlayVisible = false;
        }
      }
    },
    isDateDisabled(day, month, year) {
      if (this.disabledDates) {
        for (let disabledDate of this.disabledDates) {
          if (disabledDate.getFullYear() === year && disabledDate.getMonth() === month && disabledDate.getDate() === day) {
            return true;
          }
        }
      }
      return false;
    },
    isDayDisabled(day, month, year) {
      if (this.disabledDays) {
        let weekday = new Date(year, month, day);
        let weekdayNumber = weekday.getDay();
        return this.disabledDays.indexOf(weekdayNumber) !== -1;
      }
      return false;
    },
    onMonthDropdownChange(value) {
      this.currentMonth = parseInt(value);
      this.$emit("month-change", { month: this.currentMonth + 1, year: this.currentYear });
    },
    onYearDropdownChange(value) {
      this.currentYear = parseInt(value);
      this.$emit("year-change", { month: this.currentMonth + 1, year: this.currentYear });
    },
    onDateSelect(event2, dateMeta) {
      if (this.disabled || !dateMeta.selectable) {
        return;
      }
      DomHandler.find(this.overlay, ".p-datepicker-calendar td span:not(.p-disabled)").forEach((cell) => cell.tabIndex = -1);
      if (event2) {
        event2.currentTarget.focus();
      }
      if (this.isMultipleSelection() && this.isSelected(dateMeta)) {
        let newValue = this.modelValue.filter((date) => !this.isDateEquals(date, dateMeta));
        this.updateModel(newValue);
      } else {
        if (this.shouldSelectDate(dateMeta)) {
          if (dateMeta.otherMonth) {
            this.currentMonth = dateMeta.month;
            this.currentYear = dateMeta.year;
            this.selectDate(dateMeta);
          } else {
            this.selectDate(dateMeta);
          }
        }
      }
      if (this.isSingleSelection() && (!this.showTime || this.hideOnDateTimeSelect)) {
        setTimeout(() => {
          if (this.input) {
            this.input.focus();
          }
          this.overlayVisible = false;
        }, 150);
      }
    },
    selectDate(dateMeta) {
      let date = new Date(dateMeta.year, dateMeta.month, dateMeta.day);
      if (this.showTime) {
        if (this.hourFormat === "12" && this.pm && this.currentHour != 12)
          date.setHours(this.currentHour + 12);
        else
          date.setHours(this.currentHour);
        date.setMinutes(this.currentMinute);
        date.setSeconds(this.currentSecond);
      }
      if (this.minDate && this.minDate > date) {
        date = this.minDate;
        this.currentHour = date.getHours();
        this.currentMinute = date.getMinutes();
        this.currentSecond = date.getSeconds();
      }
      if (this.maxDate && this.maxDate < date) {
        date = this.maxDate;
        this.currentHour = date.getHours();
        this.currentMinute = date.getMinutes();
        this.currentSecond = date.getSeconds();
      }
      let modelVal = null;
      if (this.isSingleSelection()) {
        modelVal = date;
      } else if (this.isMultipleSelection()) {
        modelVal = this.modelValue ? [...this.modelValue, date] : [date];
      } else if (this.isRangeSelection()) {
        if (this.modelValue && this.modelValue.length) {
          let startDate = this.modelValue[0];
          let endDate = this.modelValue[1];
          if (!endDate && date.getTime() >= startDate.getTime()) {
            endDate = date;
          } else {
            startDate = date;
            endDate = null;
          }
          modelVal = [startDate, endDate];
        } else {
          modelVal = [date, null];
        }
      }
      if (modelVal !== null) {
        this.updateModel(modelVal);
      }
      if (this.isRangeSelection() && this.hideOnRangeSelection && modelVal[1] !== null) {
        setTimeout(() => {
          this.overlayVisible = false;
        }, 150);
      }
      this.$emit("date-select", date);
    },
    updateModel(value) {
      this.$emit("update:modelValue", value);
    },
    shouldSelectDate() {
      if (this.isMultipleSelection())
        return this.maxDateCount != null ? this.maxDateCount > (this.modelValue ? this.modelValue.length : 0) : true;
      else
        return true;
    },
    isSingleSelection() {
      return this.selectionMode === "single";
    },
    isRangeSelection() {
      return this.selectionMode === "range";
    },
    isMultipleSelection() {
      return this.selectionMode === "multiple";
    },
    formatValue(value) {
      if (typeof value === "string") {
        return value;
      }
      let formattedValue = "";
      if (value) {
        try {
          if (this.isSingleSelection()) {
            formattedValue = this.formatDateTime(value);
          } else if (this.isMultipleSelection()) {
            for (let i = 0; i < value.length; i++) {
              let dateAsString = this.formatDateTime(value[i]);
              formattedValue += dateAsString;
              if (i !== value.length - 1) {
                formattedValue += ", ";
              }
            }
          } else if (this.isRangeSelection()) {
            if (value && value.length) {
              let startDate = value[0];
              let endDate = value[1];
              formattedValue = this.formatDateTime(startDate);
              if (endDate) {
                formattedValue += " - " + this.formatDateTime(endDate);
              }
            }
          }
        } catch (err) {
          formattedValue = value;
        }
      }
      return formattedValue;
    },
    formatDateTime(date) {
      let formattedValue = null;
      if (date) {
        if (this.timeOnly) {
          formattedValue = this.formatTime(date);
        } else {
          formattedValue = this.formatDate(date, this.datePattern);
          if (this.showTime) {
            formattedValue += " " + this.formatTime(date);
          }
        }
      }
      return formattedValue;
    },
    formatDate(date, format) {
      if (!date) {
        return "";
      }
      let iFormat;
      const lookAhead = (match) => {
        const matches = iFormat + 1 < format.length && format.charAt(iFormat + 1) === match;
        if (matches) {
          iFormat++;
        }
        return matches;
      }, formatNumber = (match, value, len) => {
        let num = "" + value;
        if (lookAhead(match)) {
          while (num.length < len) {
            num = "0" + num;
          }
        }
        return num;
      }, formatName = (match, value, shortNames, longNames) => {
        return lookAhead(match) ? longNames[value] : shortNames[value];
      };
      let output = "";
      let literal = false;
      if (date) {
        for (iFormat = 0; iFormat < format.length; iFormat++) {
          if (literal) {
            if (format.charAt(iFormat) === "'" && !lookAhead("'")) {
              literal = false;
            } else {
              output += format.charAt(iFormat);
            }
          } else {
            switch (format.charAt(iFormat)) {
              case "d":
                output += formatNumber("d", date.getDate(), 2);
                break;
              case "D":
                output += formatName("D", date.getDay(), this.$primevue.config.locale.dayNamesShort, this.$primevue.config.locale.dayNames);
                break;
              case "o":
                output += formatNumber("o", Math.round((new Date(date.getFullYear(), date.getMonth(), date.getDate()).getTime() - new Date(date.getFullYear(), 0, 0).getTime()) / 864e5), 3);
                break;
              case "m":
                output += formatNumber("m", date.getMonth() + 1, 2);
                break;
              case "M":
                output += formatName("M", date.getMonth(), this.$primevue.config.locale.monthNamesShort, this.$primevue.config.locale.monthNames);
                break;
              case "y":
                output += lookAhead("y") ? date.getFullYear() : (date.getFullYear() % 100 < 10 ? "0" : "") + date.getFullYear() % 100;
                break;
              case "@":
                output += date.getTime();
                break;
              case "!":
                output += date.getTime() * 1e4 + this.ticksTo1970;
                break;
              case "'":
                if (lookAhead("'")) {
                  output += "'";
                } else {
                  literal = true;
                }
                break;
              default:
                output += format.charAt(iFormat);
            }
          }
        }
      }
      return output;
    },
    formatTime(date) {
      if (!date) {
        return "";
      }
      let output = "";
      let hours = date.getHours();
      let minutes = date.getMinutes();
      let seconds = date.getSeconds();
      if (this.hourFormat === "12" && hours > 11 && hours !== 12) {
        hours -= 12;
      }
      if (this.hourFormat === "12") {
        output += hours === 0 ? 12 : hours < 10 ? "0" + hours : hours;
      } else {
        output += hours < 10 ? "0" + hours : hours;
      }
      output += ":";
      output += minutes < 10 ? "0" + minutes : minutes;
      if (this.showSeconds) {
        output += ":";
        output += seconds < 10 ? "0" + seconds : seconds;
      }
      if (this.hourFormat === "12") {
        output += date.getHours() > 11 ? ` ${this.$primevue.config.locale.pm}` : ` ${this.$primevue.config.locale.am}`;
      }
      return output;
    },
    onTodayButtonClick(event2) {
      let date = /* @__PURE__ */ new Date();
      let dateMeta = {
        day: date.getDate(),
        month: date.getMonth(),
        year: date.getFullYear(),
        otherMonth: date.getMonth() !== this.currentMonth || date.getFullYear() !== this.currentYear,
        today: true,
        selectable: true
      };
      this.onDateSelect(null, dateMeta);
      this.$emit("today-click", date);
      event2.preventDefault();
    },
    onClearButtonClick(event2) {
      this.updateModel(null);
      this.overlayVisible = false;
      this.$emit("clear-click", event2);
      event2.preventDefault();
    },
    onTimePickerElementMouseDown(event2, type, direction) {
      if (this.isEnabled()) {
        this.repeat(event2, null, type, direction);
        event2.preventDefault();
      }
    },
    onTimePickerElementMouseUp(event2) {
      if (this.isEnabled()) {
        this.clearTimePickerTimer();
        this.updateModelTime();
        event2.preventDefault();
      }
    },
    onTimePickerElementMouseLeave() {
      this.clearTimePickerTimer();
    },
    repeat(event2, interval, type, direction) {
      let i = interval || 500;
      this.clearTimePickerTimer();
      this.timePickerTimer = setTimeout(() => {
        this.repeat(event2, 100, type, direction);
      }, i);
      switch (type) {
        case 0:
          if (direction === 1)
            this.incrementHour(event2);
          else
            this.decrementHour(event2);
          break;
        case 1:
          if (direction === 1)
            this.incrementMinute(event2);
          else
            this.decrementMinute(event2);
          break;
        case 2:
          if (direction === 1)
            this.incrementSecond(event2);
          else
            this.decrementSecond(event2);
          break;
      }
    },
    convertTo24Hour(hours, pm) {
      if (this.hourFormat == "12") {
        if (hours === 12) {
          return pm ? 12 : 0;
        } else {
          return pm ? hours + 12 : hours;
        }
      }
      return hours;
    },
    validateTime(hour, minute, second, pm) {
      let value = this.isComparable() ? this.modelValue : this.viewDate;
      const convertedHour = this.convertTo24Hour(hour, pm);
      if (this.isRangeSelection()) {
        value = this.modelValue[1] || this.modelValue[0];
      }
      if (this.isMultipleSelection()) {
        value = this.modelValue[this.modelValue.length - 1];
      }
      const valueDateString = value ? value.toDateString() : null;
      if (this.minDate && valueDateString && this.minDate.toDateString() === valueDateString) {
        if (this.minDate.getHours() > convertedHour) {
          return false;
        }
        if (this.minDate.getHours() === convertedHour) {
          if (this.minDate.getMinutes() > minute) {
            return false;
          }
          if (this.minDate.getMinutes() === minute) {
            if (this.minDate.getSeconds() > second) {
              return false;
            }
          }
        }
      }
      if (this.maxDate && valueDateString && this.maxDate.toDateString() === valueDateString) {
        if (this.maxDate.getHours() < convertedHour) {
          return false;
        }
        if (this.maxDate.getHours() === convertedHour) {
          if (this.maxDate.getMinutes() < minute) {
            return false;
          }
          if (this.maxDate.getMinutes() === minute) {
            if (this.maxDate.getSeconds() < second) {
              return false;
            }
          }
        }
      }
      return true;
    },
    incrementHour(event2) {
      let prevHour = this.currentHour;
      let newHour = this.currentHour + this.stepHour;
      let newPM = this.pm;
      if (this.hourFormat == "24")
        newHour = newHour >= 24 ? newHour - 24 : newHour;
      else if (this.hourFormat == "12") {
        if (prevHour < 12 && newHour > 11) {
          newPM = !this.pm;
        }
        newHour = newHour >= 13 ? newHour - 12 : newHour;
      }
      if (this.validateTime(newHour, this.currentMinute, this.currentSecond, newPM)) {
        this.currentHour = newHour;
        this.pm = newPM;
      }
      event2.preventDefault();
    },
    decrementHour(event2) {
      let newHour = this.currentHour - this.stepHour;
      let newPM = this.pm;
      if (this.hourFormat == "24")
        newHour = newHour < 0 ? 24 + newHour : newHour;
      else if (this.hourFormat == "12") {
        if (this.currentHour === 12) {
          newPM = !this.pm;
        }
        newHour = newHour <= 0 ? 12 + newHour : newHour;
      }
      if (this.validateTime(newHour, this.currentMinute, this.currentSecond, newPM)) {
        this.currentHour = newHour;
        this.pm = newPM;
      }
      event2.preventDefault();
    },
    incrementMinute(event2) {
      let newMinute = this.currentMinute + this.stepMinute;
      if (this.validateTime(this.currentHour, newMinute, this.currentSecond, this.pm)) {
        this.currentMinute = newMinute > 59 ? newMinute - 60 : newMinute;
      }
      event2.preventDefault();
    },
    decrementMinute(event2) {
      let newMinute = this.currentMinute - this.stepMinute;
      newMinute = newMinute < 0 ? 60 + newMinute : newMinute;
      if (this.validateTime(this.currentHour, newMinute, this.currentSecond, this.pm)) {
        this.currentMinute = newMinute;
      }
      event2.preventDefault();
    },
    incrementSecond(event2) {
      let newSecond = this.currentSecond + this.stepSecond;
      if (this.validateTime(this.currentHour, this.currentMinute, newSecond, this.pm)) {
        this.currentSecond = newSecond > 59 ? newSecond - 60 : newSecond;
      }
      event2.preventDefault();
    },
    decrementSecond(event2) {
      let newSecond = this.currentSecond - this.stepSecond;
      newSecond = newSecond < 0 ? 60 + newSecond : newSecond;
      if (this.validateTime(this.currentHour, this.currentMinute, newSecond, this.pm)) {
        this.currentSecond = newSecond;
      }
      event2.preventDefault();
    },
    updateModelTime() {
      this.timePickerChange = true;
      let value = this.isComparable() ? this.modelValue : this.viewDate;
      if (this.isRangeSelection()) {
        value = this.modelValue[1] || this.modelValue[0];
      }
      if (this.isMultipleSelection()) {
        value = this.modelValue[this.modelValue.length - 1];
      }
      value = value ? new Date(value.getTime()) : /* @__PURE__ */ new Date();
      if (this.hourFormat == "12") {
        if (this.currentHour === 12)
          value.setHours(this.pm ? 12 : 0);
        else
          value.setHours(this.pm ? this.currentHour + 12 : this.currentHour);
      } else {
        value.setHours(this.currentHour);
      }
      value.setMinutes(this.currentMinute);
      value.setSeconds(this.currentSecond);
      if (this.isRangeSelection()) {
        if (this.modelValue[1])
          value = [this.modelValue[0], value];
        else
          value = [value, null];
      }
      if (this.isMultipleSelection()) {
        value = [...this.modelValue.slice(0, -1), value];
      }
      this.updateModel(value);
      this.$emit("date-select", value);
      setTimeout(() => this.timePickerChange = false, 0);
    },
    toggleAMPM(event2) {
      const validHour = this.validateTime(this.currentHour, this.currentMinute, this.currentSecond, !this.pm);
      if (!validHour && (this.maxDate || this.minDate))
        return;
      this.pm = !this.pm;
      this.updateModelTime();
      event2.preventDefault();
    },
    clearTimePickerTimer() {
      if (this.timePickerTimer) {
        clearInterval(this.timePickerTimer);
      }
    },
    onMonthSelect(event2, { month, index }) {
      if (this.view === "month") {
        this.onDateSelect(event2, { year: this.currentYear, month: index, day: 1, selectable: true });
      } else {
        this.currentMonth = index;
        this.currentView = "date";
        this.$emit("month-change", { month: this.currentMonth + 1, year: this.currentYear });
      }
      setTimeout(this.updateFocus, 0);
    },
    onYearSelect(event2, year) {
      if (this.view === "year") {
        this.onDateSelect(event2, { year: year.value, month: 0, day: 1, selectable: true });
      } else {
        this.currentYear = year.value;
        this.currentView = "month";
        this.$emit("year-change", { month: this.currentMonth + 1, year: this.currentYear });
      }
      setTimeout(this.updateFocus, 0);
    },
    enableModality() {
      if (!this.mask) {
        this.mask = document.createElement("div");
        this.mask.style.zIndex = String(parseInt(this.overlay.style.zIndex, 10) - 1);
        DomHandler.addMultipleClasses(this.mask, "p-datepicker-mask p-datepicker-mask-scrollblocker p-component-overlay p-component-overlay-enter");
        this.maskClickListener = () => {
          this.overlayVisible = false;
        };
        this.mask.addEventListener("click", this.maskClickListener);
        document.body.appendChild(this.mask);
        DomHandler.addClass(document.body, "p-overflow-hidden");
      }
    },
    disableModality() {
      if (this.mask) {
        DomHandler.addClass(this.mask, "p-component-overlay-leave");
        this.mask.addEventListener("animationend", () => {
          this.destroyMask();
        });
      }
    },
    destroyMask() {
      this.mask.removeEventListener("click", this.maskClickListener);
      this.maskClickListener = null;
      document.body.removeChild(this.mask);
      this.mask = null;
      let bodyChildren = document.body.children;
      let hasBlockerMasks;
      for (let i = 0; i < bodyChildren.length; i++) {
        let bodyChild = bodyChildren[i];
        if (DomHandler.hasClass(bodyChild, "p-datepicker-mask-scrollblocker")) {
          hasBlockerMasks = true;
          break;
        }
      }
      if (!hasBlockerMasks) {
        DomHandler.removeClass(document.body, "p-overflow-hidden");
      }
    },
    updateCurrentMetaData() {
      const viewDate = this.viewDate;
      this.currentMonth = viewDate.getMonth();
      this.currentYear = viewDate.getFullYear();
      if (this.showTime || this.timeOnly) {
        this.updateCurrentTimeMeta(viewDate);
      }
    },
    isValidSelection(value) {
      if (value == null) {
        return true;
      }
      let isValid = true;
      if (this.isSingleSelection()) {
        if (!this.isSelectable(value.getDate(), value.getMonth(), value.getFullYear(), false)) {
          isValid = false;
        }
      } else if (value.every((v) => this.isSelectable(v.getDate(), v.getMonth(), v.getFullYear(), false))) {
        if (this.isRangeSelection()) {
          isValid = value.length > 1 && value[1] > value[0] ? true : false;
        }
      }
      return isValid;
    },
    parseValue(text) {
      if (!text || text.trim().length === 0) {
        return null;
      }
      let value;
      if (this.isSingleSelection()) {
        value = this.parseDateTime(text);
      } else if (this.isMultipleSelection()) {
        let tokens = text.split(",");
        value = [];
        for (let token of tokens) {
          value.push(this.parseDateTime(token.trim()));
        }
      } else if (this.isRangeSelection()) {
        let tokens = text.split(" - ");
        value = [];
        for (let i = 0; i < tokens.length; i++) {
          value[i] = this.parseDateTime(tokens[i].trim());
        }
      }
      return value;
    },
    parseDateTime(text) {
      let date;
      let parts = text.split(" ");
      if (this.timeOnly) {
        date = /* @__PURE__ */ new Date();
        this.populateTime(date, parts[0], parts[1]);
      } else {
        const dateFormat = this.datePattern;
        if (this.showTime) {
          date = this.parseDate(parts[0], dateFormat);
          this.populateTime(date, parts[1], parts[2]);
        } else {
          date = this.parseDate(text, dateFormat);
        }
      }
      return date;
    },
    populateTime(value, timeString, ampm) {
      if (this.hourFormat == "12" && !ampm) {
        throw "Invalid Time";
      }
      this.pm = ampm === this.$primevue.config.locale.pm || ampm === this.$primevue.config.locale.pm.toLowerCase();
      let time = this.parseTime(timeString);
      value.setHours(time.hour);
      value.setMinutes(time.minute);
      value.setSeconds(time.second);
    },
    parseTime(value) {
      let tokens = value.split(":");
      let validTokenLength = this.showSeconds ? 3 : 2;
      let regex = /^[0-9][0-9]$/;
      if (tokens.length !== validTokenLength || !tokens[0].match(regex) || !tokens[1].match(regex) || this.showSeconds && !tokens[2].match(regex)) {
        throw "Invalid time";
      }
      let h2 = parseInt(tokens[0]);
      let m = parseInt(tokens[1]);
      let s = this.showSeconds ? parseInt(tokens[2]) : null;
      if (isNaN(h2) || isNaN(m) || h2 > 23 || m > 59 || this.hourFormat == "12" && h2 > 12 || this.showSeconds && (isNaN(s) || s > 59)) {
        throw "Invalid time";
      } else {
        if (this.hourFormat == "12" && h2 !== 12 && this.pm) {
          h2 += 12;
        }
        return { hour: h2, minute: m, second: s };
      }
    },
    parseDate(value, format) {
      if (format == null || value == null) {
        throw "Invalid arguments";
      }
      value = typeof value === "object" ? value.toString() : value + "";
      if (value === "") {
        return null;
      }
      let iFormat, dim, extra, iValue = 0, shortYearCutoff = typeof this.shortYearCutoff !== "string" ? this.shortYearCutoff : (/* @__PURE__ */ new Date()).getFullYear() % 100 + parseInt(this.shortYearCutoff, 10), year = -1, month = -1, day = -1, doy = -1, literal = false, date, lookAhead = (match) => {
        let matches = iFormat + 1 < format.length && format.charAt(iFormat + 1) === match;
        if (matches) {
          iFormat++;
        }
        return matches;
      }, getNumber = (match) => {
        let isDoubled = lookAhead(match), size = match === "@" ? 14 : match === "!" ? 20 : match === "y" && isDoubled ? 4 : match === "o" ? 3 : 2, minSize = match === "y" ? size : 1, digits = new RegExp("^\\d{" + minSize + "," + size + "}"), num = value.substring(iValue).match(digits);
        if (!num) {
          throw "Missing number at position " + iValue;
        }
        iValue += num[0].length;
        return parseInt(num[0], 10);
      }, getName = (match, shortNames, longNames) => {
        let index = -1;
        let arr = lookAhead(match) ? longNames : shortNames;
        let names = [];
        for (let i = 0; i < arr.length; i++) {
          names.push([i, arr[i]]);
        }
        names.sort((a, b) => {
          return -(a[1].length - b[1].length);
        });
        for (let i = 0; i < names.length; i++) {
          let name = names[i][1];
          if (value.substr(iValue, name.length).toLowerCase() === name.toLowerCase()) {
            index = names[i][0];
            iValue += name.length;
            break;
          }
        }
        if (index !== -1) {
          return index + 1;
        } else {
          throw "Unknown name at position " + iValue;
        }
      }, checkLiteral = () => {
        if (value.charAt(iValue) !== format.charAt(iFormat)) {
          throw "Unexpected literal at position " + iValue;
        }
        iValue++;
      };
      if (this.currentView === "month") {
        day = 1;
      }
      for (iFormat = 0; iFormat < format.length; iFormat++) {
        if (literal) {
          if (format.charAt(iFormat) === "'" && !lookAhead("'")) {
            literal = false;
          } else {
            checkLiteral();
          }
        } else {
          switch (format.charAt(iFormat)) {
            case "d":
              day = getNumber("d");
              break;
            case "D":
              getName("D", this.$primevue.config.locale.dayNamesShort, this.$primevue.config.locale.dayNames);
              break;
            case "o":
              doy = getNumber("o");
              break;
            case "m":
              month = getNumber("m");
              break;
            case "M":
              month = getName("M", this.$primevue.config.locale.monthNamesShort, this.$primevue.config.locale.monthNames);
              break;
            case "y":
              year = getNumber("y");
              break;
            case "@":
              date = new Date(getNumber("@"));
              year = date.getFullYear();
              month = date.getMonth() + 1;
              day = date.getDate();
              break;
            case "!":
              date = new Date((getNumber("!") - this.ticksTo1970) / 1e4);
              year = date.getFullYear();
              month = date.getMonth() + 1;
              day = date.getDate();
              break;
            case "'":
              if (lookAhead("'")) {
                checkLiteral();
              } else {
                literal = true;
              }
              break;
            default:
              checkLiteral();
          }
        }
      }
      if (iValue < value.length) {
        extra = value.substr(iValue);
        if (!/^\s+/.test(extra)) {
          throw "Extra/unparsed characters found in date: " + extra;
        }
      }
      if (year === -1) {
        year = (/* @__PURE__ */ new Date()).getFullYear();
      } else if (year < 100) {
        year += (/* @__PURE__ */ new Date()).getFullYear() - (/* @__PURE__ */ new Date()).getFullYear() % 100 + (year <= shortYearCutoff ? 0 : -100);
      }
      if (doy > -1) {
        month = 1;
        day = doy;
        do {
          dim = this.getDaysCountInMonth(year, month - 1);
          if (day <= dim) {
            break;
          }
          month++;
          day -= dim;
        } while (true);
      }
      date = this.daylightSavingAdjust(new Date(year, month - 1, day));
      if (date.getFullYear() !== year || date.getMonth() + 1 !== month || date.getDate() !== day) {
        throw "Invalid date";
      }
      return date;
    },
    getWeekNumber(date) {
      let checkDate = new Date(date.getTime());
      checkDate.setDate(checkDate.getDate() + 4 - (checkDate.getDay() || 7));
      let time = checkDate.getTime();
      checkDate.setMonth(0);
      checkDate.setDate(1);
      return Math.floor(Math.round((time - checkDate.getTime()) / 864e5) / 7) + 1;
    },
    onDateCellKeydown(event2, date, groupIndex) {
      const cellContent = event2.currentTarget;
      const cell = cellContent.parentElement;
      const cellIndex = DomHandler.index(cell);
      switch (event2.code) {
        case "ArrowDown": {
          cellContent.tabIndex = "-1";
          let nextRow = cell.parentElement.nextElementSibling;
          if (nextRow) {
            let tableRowIndex = DomHandler.index(cell.parentElement);
            const tableRows = Array.from(cell.parentElement.parentElement.children);
            const nextTableRows = tableRows.slice(tableRowIndex + 1);
            let hasNextFocusableDate = nextTableRows.find((el) => {
              let focusCell = el.children[cellIndex].children[0];
              return !DomHandler.hasClass(focusCell, "p-disabled");
            });
            if (hasNextFocusableDate) {
              let focusCell = hasNextFocusableDate.children[cellIndex].children[0];
              focusCell.tabIndex = "0";
              focusCell.focus();
            } else {
              this.navigationState = { backward: false };
              this.navForward(event2);
            }
          } else {
            this.navigationState = { backward: false };
            this.navForward(event2);
          }
          event2.preventDefault();
          break;
        }
        case "ArrowUp": {
          cellContent.tabIndex = "-1";
          let prevRow = cell.parentElement.previousElementSibling;
          if (prevRow) {
            let tableRowIndex = DomHandler.index(cell.parentElement);
            const tableRows = Array.from(cell.parentElement.parentElement.children);
            const prevTableRows = tableRows.slice(0, tableRowIndex).reverse();
            let hasNextFocusableDate = prevTableRows.find((el) => {
              let focusCell = el.children[cellIndex].children[0];
              return !DomHandler.hasClass(focusCell, "p-disabled");
            });
            if (hasNextFocusableDate) {
              let focusCell = hasNextFocusableDate.children[cellIndex].children[0];
              focusCell.tabIndex = "0";
              focusCell.focus();
            } else {
              this.navigationState = { backward: true };
              this.navBackward(event2);
            }
          } else {
            this.navigationState = { backward: true };
            this.navBackward(event2);
          }
          event2.preventDefault();
          break;
        }
        case "ArrowLeft": {
          cellContent.tabIndex = "-1";
          let prevCell = cell.previousElementSibling;
          if (prevCell) {
            const cells = Array.from(cell.parentElement.children);
            const prevCells = cells.slice(0, cellIndex).reverse();
            let hasNextFocusableDate = prevCells.find((el) => {
              let focusCell = el.children[0];
              return !DomHandler.hasClass(focusCell, "p-disabled");
            });
            if (hasNextFocusableDate) {
              let focusCell = hasNextFocusableDate.children[0];
              focusCell.tabIndex = "0";
              focusCell.focus();
            } else {
              this.navigateToMonth(event2, true, groupIndex);
            }
          } else {
            this.navigateToMonth(event2, true, groupIndex);
          }
          event2.preventDefault();
          break;
        }
        case "ArrowRight": {
          cellContent.tabIndex = "-1";
          let nextCell = cell.nextElementSibling;
          if (nextCell) {
            const cells = Array.from(cell.parentElement.children);
            const nextCells = cells.slice(cellIndex + 1);
            let hasNextFocusableDate = nextCells.find((el) => {
              let focusCell = el.children[0];
              return !DomHandler.hasClass(focusCell, "p-disabled");
            });
            if (hasNextFocusableDate) {
              let focusCell = hasNextFocusableDate.children[0];
              focusCell.tabIndex = "0";
              focusCell.focus();
            } else {
              this.navigateToMonth(event2, false, groupIndex);
            }
          } else {
            this.navigateToMonth(event2, false, groupIndex);
          }
          event2.preventDefault();
          break;
        }
        case "Enter":
        case "Space": {
          this.onDateSelect(event2, date);
          event2.preventDefault();
          break;
        }
        case "Escape": {
          this.overlayVisible = false;
          event2.preventDefault();
          break;
        }
        case "Tab": {
          if (!this.inline) {
            this.trapFocus(event2);
          }
          break;
        }
        case "Home": {
          cellContent.tabIndex = "-1";
          let currentRow = cell.parentElement;
          let focusCell = currentRow.children[0].children[0];
          if (DomHandler.hasClass(focusCell, "p-disabled")) {
            this.navigateToMonth(event2, true, groupIndex);
          } else {
            focusCell.tabIndex = "0";
            focusCell.focus();
          }
          event2.preventDefault();
          break;
        }
        case "End": {
          cellContent.tabIndex = "-1";
          let currentRow = cell.parentElement;
          let focusCell = currentRow.children[currentRow.children.length - 1].children[0];
          if (DomHandler.hasClass(focusCell, "p-disabled")) {
            this.navigateToMonth(event2, false, groupIndex);
          } else {
            focusCell.tabIndex = "0";
            focusCell.focus();
          }
          event2.preventDefault();
          break;
        }
        case "PageUp": {
          cellContent.tabIndex = "-1";
          if (event2.shiftKey) {
            this.navigationState = { backward: true };
            this.navBackward(event2);
          } else
            this.navigateToMonth(event2, true, groupIndex);
          event2.preventDefault();
          break;
        }
        case "PageDown": {
          cellContent.tabIndex = "-1";
          if (event2.shiftKey) {
            this.navigationState = { backward: false };
            this.navForward(event2);
          } else
            this.navigateToMonth(event2, false, groupIndex);
          event2.preventDefault();
          break;
        }
      }
    },
    navigateToMonth(event2, prev, groupIndex) {
      if (prev) {
        if (this.numberOfMonths === 1 || groupIndex === 0) {
          this.navigationState = { backward: true };
          this.navBackward(event2);
        } else {
          let prevMonthContainer = this.overlay.children[groupIndex - 1];
          let cells = DomHandler.find(prevMonthContainer, ".p-datepicker-calendar td span:not(.p-disabled):not(.p-ink)");
          let focusCell = cells[cells.length - 1];
          focusCell.tabIndex = "0";
          focusCell.focus();
        }
      } else {
        if (this.numberOfMonths === 1 || groupIndex === this.numberOfMonths - 1) {
          this.navigationState = { backward: false };
          this.navForward(event2);
        } else {
          let nextMonthContainer = this.overlay.children[groupIndex + 1];
          let focusCell = DomHandler.findSingle(nextMonthContainer, ".p-datepicker-calendar td span:not(.p-disabled):not(.p-ink)");
          focusCell.tabIndex = "0";
          focusCell.focus();
        }
      }
    },
    onMonthCellKeydown(event2, index) {
      const cell = event2.currentTarget;
      switch (event2.code) {
        case "ArrowUp":
        case "ArrowDown": {
          cell.tabIndex = "-1";
          var cells = cell.parentElement.children;
          var cellIndex = DomHandler.index(cell);
          let nextCell = cells[event2.code === "ArrowDown" ? cellIndex + 3 : cellIndex - 3];
          if (nextCell) {
            nextCell.tabIndex = "0";
            nextCell.focus();
          }
          event2.preventDefault();
          break;
        }
        case "ArrowLeft": {
          cell.tabIndex = "-1";
          let prevCell = cell.previousElementSibling;
          if (prevCell) {
            prevCell.tabIndex = "0";
            prevCell.focus();
          } else {
            this.navigationState = { backward: true };
            this.navBackward(event2);
          }
          event2.preventDefault();
          break;
        }
        case "ArrowRight": {
          cell.tabIndex = "-1";
          let nextCell = cell.nextElementSibling;
          if (nextCell) {
            nextCell.tabIndex = "0";
            nextCell.focus();
          } else {
            this.navigationState = { backward: false };
            this.navForward(event2);
          }
          event2.preventDefault();
          break;
        }
        case "PageUp": {
          if (event2.shiftKey)
            return;
          this.navigationState = { backward: true };
          this.navBackward(event2);
          break;
        }
        case "PageDown": {
          if (event2.shiftKey)
            return;
          this.navigationState = { backward: false };
          this.navForward(event2);
          break;
        }
        case "Enter":
        case "Space": {
          this.onMonthSelect(event2, index);
          event2.preventDefault();
          break;
        }
        case "Escape": {
          this.overlayVisible = false;
          event2.preventDefault();
          break;
        }
        case "Tab": {
          this.trapFocus(event2);
          break;
        }
      }
    },
    onYearCellKeydown(event2, index) {
      const cell = event2.currentTarget;
      switch (event2.code) {
        case "ArrowUp":
        case "ArrowDown": {
          cell.tabIndex = "-1";
          var cells = cell.parentElement.children;
          var cellIndex = DomHandler.index(cell);
          let nextCell = cells[event2.code === "ArrowDown" ? cellIndex + 2 : cellIndex - 2];
          if (nextCell) {
            nextCell.tabIndex = "0";
            nextCell.focus();
          }
          event2.preventDefault();
          break;
        }
        case "ArrowLeft": {
          cell.tabIndex = "-1";
          let prevCell = cell.previousElementSibling;
          if (prevCell) {
            prevCell.tabIndex = "0";
            prevCell.focus();
          } else {
            this.navigationState = { backward: true };
            this.navBackward(event2);
          }
          event2.preventDefault();
          break;
        }
        case "ArrowRight": {
          cell.tabIndex = "-1";
          let nextCell = cell.nextElementSibling;
          if (nextCell) {
            nextCell.tabIndex = "0";
            nextCell.focus();
          } else {
            this.navigationState = { backward: false };
            this.navForward(event2);
          }
          event2.preventDefault();
          break;
        }
        case "PageUp": {
          if (event2.shiftKey)
            return;
          this.navigationState = { backward: true };
          this.navBackward(event2);
          break;
        }
        case "PageDown": {
          if (event2.shiftKey)
            return;
          this.navigationState = { backward: false };
          this.navForward(event2);
          break;
        }
        case "Enter":
        case "Space": {
          this.onYearSelect(event2, index);
          event2.preventDefault();
          break;
        }
        case "Escape": {
          this.overlayVisible = false;
          event2.preventDefault();
          break;
        }
        case "Tab": {
          this.trapFocus(event2);
          break;
        }
      }
    },
    updateFocus() {
      let cell;
      if (this.navigationState) {
        if (this.navigationState.button) {
          this.initFocusableCell();
          if (this.navigationState.backward)
            DomHandler.findSingle(this.overlay, ".p-datepicker-prev").focus();
          else
            DomHandler.findSingle(this.overlay, ".p-datepicker-next").focus();
        } else {
          if (this.navigationState.backward) {
            let cells;
            if (this.currentView === "month") {
              cells = DomHandler.find(this.overlay, ".p-monthpicker .p-monthpicker-month:not(.p-disabled)");
            } else if (this.currentView === "year") {
              cells = DomHandler.find(this.overlay, ".p-yearpicker .p-yearpicker-year:not(.p-disabled)");
            } else {
              cells = DomHandler.find(this.overlay, ".p-datepicker-calendar td span:not(.p-disabled):not(.p-ink)");
            }
            if (cells && cells.length > 0) {
              cell = cells[cells.length - 1];
            }
          } else {
            if (this.currentView === "month") {
              cell = DomHandler.findSingle(this.overlay, ".p-monthpicker .p-monthpicker-month:not(.p-disabled)");
            } else if (this.currentView === "year") {
              cell = DomHandler.findSingle(this.overlay, ".p-yearpicker .p-yearpicker-year:not(.p-disabled)");
            } else {
              cell = DomHandler.findSingle(this.overlay, ".p-datepicker-calendar td span:not(.p-disabled):not(.p-ink)");
            }
          }
          if (cell) {
            cell.tabIndex = "0";
            cell.focus();
          }
        }
        this.navigationState = null;
      } else {
        this.initFocusableCell();
      }
    },
    initFocusableCell() {
      let cell;
      if (this.currentView === "month") {
        let cells = DomHandler.find(this.overlay, ".p-monthpicker .p-monthpicker-month");
        let selectedCell = DomHandler.findSingle(this.overlay, ".p-monthpicker .p-monthpicker-month.p-highlight");
        cells.forEach((cell2) => cell2.tabIndex = -1);
        cell = selectedCell || cells[0];
      } else if (this.currentView === "year") {
        let cells = DomHandler.find(this.overlay, ".p-yearpicker .p-yearpicker-year");
        let selectedCell = DomHandler.findSingle(this.overlay, ".p-yearpicker .p-yearpicker-year.p-highlight");
        cells.forEach((cell2) => cell2.tabIndex = -1);
        cell = selectedCell || cells[0];
      } else {
        cell = DomHandler.findSingle(this.overlay, "span.p-highlight");
        if (!cell) {
          let todayCell = DomHandler.findSingle(this.overlay, "td.p-datepicker-today span:not(.p-disabled):not(.p-ink)");
          if (todayCell)
            cell = todayCell;
          else
            cell = DomHandler.findSingle(this.overlay, ".p-datepicker-calendar td span:not(.p-disabled):not(.p-ink)");
        }
      }
      if (cell) {
        cell.tabIndex = "0";
        if (!this.inline && (!this.navigationState || !this.navigationState.button) && !this.timePickerChange) {
          cell.focus();
        }
        this.preventFocus = false;
      }
    },
    trapFocus(event2) {
      event2.preventDefault();
      let focusableElements = DomHandler.getFocusableElements(this.overlay);
      if (focusableElements && focusableElements.length > 0) {
        if (!document.activeElement) {
          focusableElements[0].focus();
        } else {
          let focusedIndex = focusableElements.indexOf(document.activeElement);
          if (event2.shiftKey) {
            if (focusedIndex === -1 || focusedIndex === 0)
              focusableElements[focusableElements.length - 1].focus();
            else
              focusableElements[focusedIndex - 1].focus();
          } else {
            if (focusedIndex === -1) {
              if (this.timeOnly) {
                focusableElements[0].focus();
              } else {
                let spanIndex = null;
                for (let i = 0; i < focusableElements.length; i++) {
                  if (focusableElements[i].tagName === "SPAN")
                    spanIndex = i;
                }
                focusableElements[spanIndex].focus();
              }
            } else if (focusedIndex === focusableElements.length - 1)
              focusableElements[0].focus();
            else
              focusableElements[focusedIndex + 1].focus();
          }
        }
      }
    },
    onContainerButtonKeydown(event2) {
      switch (event2.code) {
        case "Tab":
          this.trapFocus(event2);
          break;
        case "Escape":
          this.overlayVisible = false;
          event2.preventDefault();
          break;
      }
      this.$emit("keydown", event2);
    },
    onInput(event2) {
      try {
        this.selectionStart = this.input.selectionStart;
        this.selectionEnd = this.input.selectionEnd;
        let value = this.parseValue(event2.target.value);
        if (this.isValidSelection(value)) {
          this.typeUpdate = true;
          this.updateModel(value);
        }
      } catch (err) {
      }
      this.$emit("input", event2);
    },
    onInputClick() {
      if (this.showOnFocus && this.isEnabled() && !this.overlayVisible) {
        this.overlayVisible = true;
      }
    },
    onFocus(event2) {
      if (this.showOnFocus && this.isEnabled()) {
        this.overlayVisible = true;
      }
      this.focused = true;
      this.$emit("focus", event2);
    },
    onBlur(event2) {
      this.$emit("blur", { originalEvent: event2, value: event2.target.value });
      this.focused = false;
      event2.target.value = this.formatValue(this.modelValue);
    },
    onKeyDown(event2) {
      if (event2.code === "ArrowDown" && this.overlay) {
        this.trapFocus(event2);
      } else if (event2.code === "ArrowDown" && !this.overlay) {
        this.overlayVisible = true;
      } else if (event2.code === "Escape") {
        if (this.overlayVisible) {
          this.overlayVisible = false;
          event2.preventDefault();
        }
      } else if (event2.code === "Tab") {
        if (this.overlay) {
          DomHandler.getFocusableElements(this.overlay).forEach((el) => el.tabIndex = "-1");
        }
        if (this.overlayVisible) {
          this.overlayVisible = false;
        }
      }
    },
    overlayRef(el) {
      this.overlay = el;
    },
    inputRef(el) {
      this.input = el;
    },
    getMonthName(index) {
      return this.$primevue.config.locale.monthNames[index];
    },
    getYear(month) {
      return this.currentView === "month" ? this.currentYear : month.year;
    },
    onOverlayClick(event2) {
      if (!this.inline) {
        OverlayEventBus.emit("overlay-click", {
          originalEvent: event2,
          target: this.$el
        });
      }
    },
    onOverlayKeyDown(event2) {
      switch (event2.code) {
        case "Escape":
          this.input.focus();
          this.overlayVisible = false;
          break;
      }
    },
    onOverlayMouseUp(event2) {
      this.onOverlayClick(event2);
    },
    createResponsiveStyle() {
      if (this.numberOfMonths > 1 && this.responsiveOptions) {
        if (!this.responsiveStyleElement) {
          this.responsiveStyleElement = document.createElement("style");
          this.responsiveStyleElement.type = "text/css";
          document.body.appendChild(this.responsiveStyleElement);
        }
        let innerHTML = "";
        if (this.responsiveOptions) {
          let responsiveOptions = [...this.responsiveOptions].filter((o) => !!(o.breakpoint && o.numMonths)).sort((o1, o2) => -1 * o1.breakpoint.localeCompare(o2.breakpoint, void 0, { numeric: true }));
          for (let i = 0; i < responsiveOptions.length; i++) {
            let { breakpoint, numMonths } = responsiveOptions[i];
            let styles = `
                            .p-datepicker[${this.attributeSelector}] .p-datepicker-group:nth-child(${numMonths}) .p-datepicker-next {
                                display: inline-flex !important;
                            }
                        `;
            for (let j = numMonths; j < this.numberOfMonths; j++) {
              styles += `
                                .p-datepicker[${this.attributeSelector}] .p-datepicker-group:nth-child(${j + 1}) {
                                    display: none !important;
                                }
                            `;
            }
            innerHTML += `
                            @media screen and (max-width: ${breakpoint}) {
                                ${styles}
                            }
                        `;
          }
        }
        this.responsiveStyleElement.innerHTML = innerHTML;
      }
    },
    destroyResponsiveStyleElement() {
      if (this.responsiveStyleElement) {
        this.responsiveStyleElement.remove();
        this.responsiveStyleElement = null;
      }
    }
  },
  computed: {
    viewDate() {
      let propValue = this.modelValue;
      if (propValue && Array.isArray(propValue)) {
        if (this.isRangeSelection()) {
          propValue = this.inline ? propValue[0] : propValue[1] || propValue[0];
        } else if (this.isMultipleSelection()) {
          propValue = propValue[propValue.length - 1];
        }
      }
      if (propValue && typeof propValue !== "string") {
        return propValue;
      } else {
        let today = /* @__PURE__ */ new Date();
        if (this.maxDate && this.maxDate < today) {
          return this.maxDate;
        }
        if (this.minDate && this.minDate > today) {
          return this.minDate;
        }
        return today;
      }
    },
    inputFieldValue() {
      return this.formatValue(this.modelValue);
    },
    containerClass() {
      return [
        "p-calendar p-component p-inputwrapper",
        {
          "p-calendar-w-btn": this.showIcon,
          "p-calendar-timeonly": this.timeOnly,
          "p-calendar-disabled": this.disabled,
          "p-inputwrapper-filled": this.modelValue,
          "p-inputwrapper-focus": this.focused
        }
      ];
    },
    panelStyleClass() {
      return [
        "p-datepicker p-component",
        this.panelClass,
        {
          "p-datepicker-inline": this.inline,
          "p-disabled": this.disabled,
          "p-datepicker-timeonly": this.timeOnly,
          "p-datepicker-multiple-month": this.numberOfMonths > 1,
          "p-datepicker-monthpicker": this.currentView === "month",
          "p-datepicker-yearpicker": this.currentView === "year",
          "p-datepicker-touch-ui": this.touchUI,
          "p-input-filled": this.$primevue.config.inputStyle === "filled",
          "p-ripple-disabled": this.$primevue.config.ripple === false
        }
      ];
    },
    months() {
      let months = [];
      for (let i = 0; i < this.numberOfMonths; i++) {
        let month = this.currentMonth + i;
        let year = this.currentYear;
        if (month > 11) {
          month = month % 11 - 1;
          year = year + 1;
        }
        let dates = [];
        let firstDay = this.getFirstDayOfMonthIndex(month, year);
        let daysLength = this.getDaysCountInMonth(month, year);
        let prevMonthDaysLength = this.getDaysCountInPrevMonth(month, year);
        let dayNo = 1;
        let today = /* @__PURE__ */ new Date();
        let weekNumbers = [];
        let monthRows = Math.ceil((daysLength + firstDay) / 7);
        for (let i2 = 0; i2 < monthRows; i2++) {
          let week = [];
          if (i2 == 0) {
            for (let j = prevMonthDaysLength - firstDay + 1; j <= prevMonthDaysLength; j++) {
              let prev = this.getPreviousMonthAndYear(month, year);
              week.push({ day: j, month: prev.month, year: prev.year, otherMonth: true, today: this.isToday(today, j, prev.month, prev.year), selectable: this.isSelectable(j, prev.month, prev.year, true) });
            }
            let remainingDaysLength = 7 - week.length;
            for (let j = 0; j < remainingDaysLength; j++) {
              week.push({ day: dayNo, month, year, today: this.isToday(today, dayNo, month, year), selectable: this.isSelectable(dayNo, month, year, false) });
              dayNo++;
            }
          } else {
            for (let j = 0; j < 7; j++) {
              if (dayNo > daysLength) {
                let next = this.getNextMonthAndYear(month, year);
                week.push({
                  day: dayNo - daysLength,
                  month: next.month,
                  year: next.year,
                  otherMonth: true,
                  today: this.isToday(today, dayNo - daysLength, next.month, next.year),
                  selectable: this.isSelectable(dayNo - daysLength, next.month, next.year, true)
                });
              } else {
                week.push({ day: dayNo, month, year, today: this.isToday(today, dayNo, month, year), selectable: this.isSelectable(dayNo, month, year, false) });
              }
              dayNo++;
            }
          }
          if (this.showWeek) {
            weekNumbers.push(this.getWeekNumber(new Date(week[0].year, week[0].month, week[0].day)));
          }
          dates.push(week);
        }
        months.push({
          month,
          year,
          dates,
          weekNumbers
        });
      }
      return months;
    },
    weekDays() {
      let weekDays = [];
      let dayIndex = this.$primevue.config.locale.firstDayOfWeek;
      for (let i = 0; i < 7; i++) {
        weekDays.push(this.$primevue.config.locale.dayNamesMin[dayIndex]);
        dayIndex = dayIndex == 6 ? 0 : ++dayIndex;
      }
      return weekDays;
    },
    ticksTo1970() {
      return ((1970 - 1) * 365 + Math.floor(1970 / 4) - Math.floor(1970 / 100) + Math.floor(1970 / 400)) * 24 * 60 * 60 * 1e7;
    },
    sundayIndex() {
      return this.$primevue.config.locale.firstDayOfWeek > 0 ? 7 - this.$primevue.config.locale.firstDayOfWeek : 0;
    },
    datePattern() {
      return this.dateFormat || this.$primevue.config.locale.dateFormat;
    },
    yearOptions() {
      if (this.yearRange) {
        let $vm = this;
        const years = this.yearRange.split(":");
        let yearStart = parseInt(years[0]);
        let yearEnd = parseInt(years[1]);
        let yearOptions = [];
        if (this.currentYear < yearStart) {
          $vm.currentYear = yearEnd;
        } else if (this.currentYear > yearEnd) {
          $vm.currentYear = yearStart;
        }
        for (let i = yearStart; i <= yearEnd; i++) {
          yearOptions.push(i);
        }
        return yearOptions;
      } else {
        return null;
      }
    },
    monthPickerValues() {
      let monthPickerValues = [];
      const isSelectableMonth = (baseMonth) => {
        if (this.minDate) {
          const minMonth = this.minDate.getMonth();
          const minYear = this.minDate.getFullYear();
          if (this.currentYear < minYear || this.currentYear === minYear && baseMonth < minMonth) {
            return false;
          }
        }
        if (this.maxDate) {
          const maxMonth = this.maxDate.getMonth();
          const maxYear = this.maxDate.getFullYear();
          if (this.currentYear > maxYear || this.currentYear === maxYear && baseMonth > maxMonth) {
            return false;
          }
        }
        return true;
      };
      for (let i = 0; i <= 11; i++) {
        monthPickerValues.push({ value: this.$primevue.config.locale.monthNamesShort[i], selectable: isSelectableMonth(i) });
      }
      return monthPickerValues;
    },
    yearPickerValues() {
      let yearPickerValues = [];
      let base = this.currentYear - this.currentYear % 10;
      const isSelectableYear = (baseYear) => {
        if (this.minDate) {
          if (this.minDate.getFullYear() > baseYear)
            return false;
        }
        if (this.maxDate) {
          if (this.maxDate.getFullYear() < baseYear)
            return false;
        }
        return true;
      };
      for (let i = 0; i < 10; i++) {
        yearPickerValues.push({ value: base + i, selectable: isSelectableYear(base + i) });
      }
      return yearPickerValues;
    },
    formattedCurrentHour() {
      return this.currentHour < 10 ? "0" + this.currentHour : this.currentHour;
    },
    formattedCurrentMinute() {
      return this.currentMinute < 10 ? "0" + this.currentMinute : this.currentMinute;
    },
    formattedCurrentSecond() {
      return this.currentSecond < 10 ? "0" + this.currentSecond : this.currentSecond;
    },
    todayLabel() {
      return this.$primevue.config.locale.today;
    },
    clearLabel() {
      return this.$primevue.config.locale.clear;
    },
    weekHeaderLabel() {
      return this.$primevue.config.locale.weekHeader;
    },
    monthNames() {
      return this.$primevue.config.locale.monthNames;
    },
    attributeSelector() {
      return UniqueComponentId();
    },
    switchViewButtonDisabled() {
      return this.numberOfMonths > 1 || this.disabled;
    },
    panelId() {
      return UniqueComponentId() + "_panel";
    }
  },
  components: {
    CalendarButton: script$T,
    Portal: script$Q,
    CalendarIcon: script$N,
    ChevronLeftIcon: script$M,
    ChevronRightIcon: script$L,
    ChevronUpIcon: script$K,
    ChevronDownIcon: script$S
  },
  directives: {
    ripple: Ripple
  }
};
const _hoisted_1$F = ["id"];
const _hoisted_2$q = ["id", "placeholder", "aria-expanded", "aria-controls", "aria-labelledby", "aria-label", "disabled", "readonly"];
const _hoisted_3$j = ["id", "role", "aria-modal", "aria-label"];
const _hoisted_4$4 = ["disabled", "aria-label"];
const _hoisted_5$2 = ["disabled", "aria-label"];
const _hoisted_6$2 = ["disabled", "aria-label"];
const _hoisted_7$2 = ["disabled", "aria-label"];
const _hoisted_8 = ["abbr"];
const _hoisted_9 = ["aria-label"];
const _hoisted_10 = ["onClick", "onKeydown", "aria-selected"];
const _hoisted_11 = ["onClick", "onKeydown"];
const _hoisted_12 = ["onClick", "onKeydown"];
const _hoisted_13 = ["aria-label"];
const _hoisted_14 = ["aria-label"];
const _hoisted_15 = ["aria-label", "disabled"];
const _hoisted_16 = ["aria-label", "disabled"];
const _hoisted_17 = ["aria-label", "disabled"];
const _hoisted_18 = ["aria-label", "disabled"];
const _hoisted_19 = ["aria-label", "disabled"];
const _hoisted_20 = ["aria-label", "disabled"];
function render$J(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_CalendarButton = resolveComponent("CalendarButton");
  const _component_Portal = resolveComponent("Portal");
  const _directive_ripple = resolveDirective("ripple");
  return openBlock(), createElementBlock("span", mergeProps({
    ref: "container",
    id: $props.id,
    class: $options.containerClass
  }, _ctx.ptm("root")), [
    !$props.inline ? (openBlock(), createElementBlock("input", mergeProps({
      key: 0,
      ref: $options.inputRef,
      id: $props.inputId,
      type: "text",
      role: "combobox",
      class: ["p-inputtext p-component", $props.inputClass],
      style: $props.inputStyle,
      placeholder: $props.placeholder,
      autocomplete: "off",
      "aria-autocomplete": "none",
      "aria-haspopup": "dialog",
      "aria-expanded": $data.overlayVisible,
      "aria-controls": $options.panelId,
      "aria-labelledby": _ctx.ariaLabelledby,
      "aria-label": _ctx.ariaLabel,
      inputmode: "none",
      disabled: $props.disabled,
      readonly: !$props.manualInput || $props.readonly,
      tabindex: 0,
      onInput: _cache[0] || (_cache[0] = (...args) => $options.onInput && $options.onInput(...args)),
      onClick: _cache[1] || (_cache[1] = (...args) => $options.onInputClick && $options.onInputClick(...args)),
      onFocus: _cache[2] || (_cache[2] = (...args) => $options.onFocus && $options.onFocus(...args)),
      onBlur: _cache[3] || (_cache[3] = (...args) => $options.onBlur && $options.onBlur(...args)),
      onKeydown: _cache[4] || (_cache[4] = (...args) => $options.onKeyDown && $options.onKeyDown(...args))
    }, { ...$props.inputProps, ..._ctx.ptm("input") }), null, 16, _hoisted_2$q)) : createCommentVNode("", true),
    $props.showIcon ? (openBlock(), createBlock(_component_CalendarButton, {
      key: 1,
      class: "p-datepicker-trigger",
      disabled: $props.disabled,
      onClick: $options.onButtonClick,
      type: "button",
      "aria-label": _ctx.$primevue.config.locale.chooseDate,
      "aria-haspopup": "dialog",
      "aria-expanded": $data.overlayVisible,
      "aria-controls": $options.panelId,
      pt: _ctx.ptm("dropdownButton")
    }, {
      icon: withCtx(() => [
        renderSlot(_ctx.$slots, "dropdownicon", {}, () => [
          (openBlock(), createBlock(resolveDynamicComponent($props.icon ? "span" : "CalendarIcon"), mergeProps({ class: $props.icon }, _ctx.ptm("dropdownButton")["icon"]), null, 16, ["class"]))
        ])
      ]),
      _: 3
    }, 8, ["disabled", "onClick", "aria-label", "aria-expanded", "aria-controls", "pt"])) : createCommentVNode("", true),
    createVNode(_component_Portal, {
      appendTo: $props.appendTo,
      disabled: $props.inline
    }, {
      default: withCtx(() => [
        createVNode(Transition, {
          name: "p-connected-overlay",
          onEnter: _cache[68] || (_cache[68] = ($event) => $options.onOverlayEnter($event)),
          onAfterEnter: $options.onOverlayEnterComplete,
          onAfterLeave: $options.onOverlayAfterLeave,
          onLeave: $options.onOverlayLeave
        }, {
          default: withCtx(() => [
            $props.inline || $data.overlayVisible ? (openBlock(), createElementBlock("div", mergeProps({
              key: 0,
              ref: $options.overlayRef,
              id: $options.panelId,
              class: $options.panelStyleClass,
              style: $props.panelStyle,
              role: $props.inline ? null : "dialog",
              "aria-modal": $props.inline ? null : "true",
              "aria-label": _ctx.$primevue.config.locale.chooseDate,
              onClick: _cache[65] || (_cache[65] = (...args) => $options.onOverlayClick && $options.onOverlayClick(...args)),
              onKeydown: _cache[66] || (_cache[66] = (...args) => $options.onOverlayKeyDown && $options.onOverlayKeyDown(...args)),
              onMouseup: _cache[67] || (_cache[67] = (...args) => $options.onOverlayMouseUp && $options.onOverlayMouseUp(...args))
            }, { ...$props.panelProps, ..._ctx.ptm("panel") }), [
              !$props.timeOnly ? (openBlock(), createElementBlock(Fragment, { key: 0 }, [
                createElementVNode("div", mergeProps({ class: "p-datepicker-group-container" }, _ctx.ptm("groupContainer")), [
                  (openBlock(true), createElementBlock(Fragment, null, renderList($options.months, (month, groupIndex) => {
                    return openBlock(), createElementBlock("div", mergeProps({
                      key: month.month + month.year,
                      class: "p-datepicker-group"
                    }, _ctx.ptm("group")), [
                      createElementVNode("div", mergeProps({ class: "p-datepicker-header" }, _ctx.ptm("header")), [
                        renderSlot(_ctx.$slots, "header"),
                        withDirectives((openBlock(), createElementBlock("button", mergeProps({
                          class: "p-datepicker-prev p-link",
                          onClick: _cache[5] || (_cache[5] = (...args) => $options.onPrevButtonClick && $options.onPrevButtonClick(...args)),
                          type: "button",
                          onKeydown: _cache[6] || (_cache[6] = (...args) => $options.onContainerButtonKeydown && $options.onContainerButtonKeydown(...args)),
                          disabled: $props.disabled,
                          "aria-label": $data.currentView === "year" ? _ctx.$primevue.config.locale.prevDecade : $data.currentView === "month" ? _ctx.$primevue.config.locale.prevYear : _ctx.$primevue.config.locale.prevMonth
                        }, _ctx.ptm("previousButton")), [
                          renderSlot(_ctx.$slots, "previousicon", {}, () => [
                            (openBlock(), createBlock(resolveDynamicComponent($props.previousIcon ? "span" : "ChevronLeftIcon"), mergeProps({
                              class: ["p-datepicker-prev-icon", $props.previousIcon]
                            }, _ctx.ptm("previousIcon")), null, 16, ["class"]))
                          ])
                        ], 16, _hoisted_4$4)), [
                          [vShow, $props.showOtherMonths ? groupIndex === 0 : false],
                          [_directive_ripple]
                        ]),
                        createElementVNode("div", mergeProps({ class: "p-datepicker-title" }, _ctx.ptm("title")), [
                          $data.currentView === "date" ? (openBlock(), createElementBlock("button", mergeProps({
                            key: 0,
                            type: "button",
                            onClick: _cache[7] || (_cache[7] = (...args) => $options.switchToMonthView && $options.switchToMonthView(...args)),
                            onKeydown: _cache[8] || (_cache[8] = (...args) => $options.onContainerButtonKeydown && $options.onContainerButtonKeydown(...args)),
                            class: "p-datepicker-month p-link",
                            disabled: $options.switchViewButtonDisabled,
                            "aria-label": _ctx.$primevue.config.locale.chooseMonth
                          }, _ctx.ptm("monthTitle")), toDisplayString($options.getMonthName(month.month)), 17, _hoisted_5$2)) : createCommentVNode("", true),
                          $data.currentView !== "year" ? (openBlock(), createElementBlock("button", mergeProps({
                            key: 1,
                            type: "button",
                            onClick: _cache[9] || (_cache[9] = (...args) => $options.switchToYearView && $options.switchToYearView(...args)),
                            onKeydown: _cache[10] || (_cache[10] = (...args) => $options.onContainerButtonKeydown && $options.onContainerButtonKeydown(...args)),
                            class: "p-datepicker-year p-link",
                            disabled: $options.switchViewButtonDisabled,
                            "aria-label": _ctx.$primevue.config.locale.chooseYear
                          }, _ctx.ptm("yearTitle")), toDisplayString($options.getYear(month)), 17, _hoisted_6$2)) : createCommentVNode("", true),
                          $data.currentView === "year" ? (openBlock(), createElementBlock("span", mergeProps({
                            key: 2,
                            class: "p-datepicker-decade"
                          }, _ctx.ptm("decadeTitle")), [
                            renderSlot(_ctx.$slots, "decade", { years: $options.yearPickerValues }, () => [
                              createTextVNode(toDisplayString($options.yearPickerValues[0].value) + " - " + toDisplayString($options.yearPickerValues[$options.yearPickerValues.length - 1].value), 1)
                            ])
                          ], 16)) : createCommentVNode("", true)
                        ], 16),
                        withDirectives((openBlock(), createElementBlock("button", mergeProps({
                          class: "p-datepicker-next p-link",
                          onClick: _cache[11] || (_cache[11] = (...args) => $options.onNextButtonClick && $options.onNextButtonClick(...args)),
                          type: "button",
                          onKeydown: _cache[12] || (_cache[12] = (...args) => $options.onContainerButtonKeydown && $options.onContainerButtonKeydown(...args)),
                          disabled: $props.disabled,
                          "aria-label": $data.currentView === "year" ? _ctx.$primevue.config.locale.nextDecade : $data.currentView === "month" ? _ctx.$primevue.config.locale.nextYear : _ctx.$primevue.config.locale.nextMonth
                        }, _ctx.ptm("nextButton")), [
                          renderSlot(_ctx.$slots, "nexticon", {}, () => [
                            (openBlock(), createBlock(resolveDynamicComponent($props.nextIcon ? "span" : "ChevronRightIcon"), mergeProps({
                              class: ["p-datepicker-next-icon", $props.nextIcon]
                            }, _ctx.ptm("nextIcon")), null, 16, ["class"]))
                          ])
                        ], 16, _hoisted_7$2)), [
                          [vShow, $props.showOtherMonths ? $props.numberOfMonths === 1 ? true : groupIndex === $props.numberOfMonths - 1 : false],
                          [_directive_ripple]
                        ])
                      ], 16),
                      $data.currentView === "date" ? (openBlock(), createElementBlock("div", mergeProps({
                        key: 0,
                        class: "p-datepicker-calendar-container"
                      }, _ctx.ptm("container")), [
                        createElementVNode("table", mergeProps({
                          class: "p-datepicker-calendar",
                          role: "grid"
                        }, _ctx.ptm("table")), [
                          createElementVNode("thead", normalizeProps(guardReactiveProps(_ctx.ptm("tableHeader"))), [
                            createElementVNode("tr", normalizeProps(guardReactiveProps(_ctx.ptm("tableHeaderRow"))), [
                              $props.showWeek ? (openBlock(), createElementBlock("th", mergeProps({
                                key: 0,
                                scope: "col",
                                class: "p-datepicker-weekheader p-disabled"
                              }, _ctx.ptm("weekHeader")), [
                                createElementVNode("span", normalizeProps(guardReactiveProps(_ctx.ptm("weekLabel"))), toDisplayString($options.weekHeaderLabel), 17)
                              ], 16)) : createCommentVNode("", true),
                              (openBlock(true), createElementBlock(Fragment, null, renderList($options.weekDays, (weekDay) => {
                                return openBlock(), createElementBlock("th", mergeProps({
                                  key: weekDay,
                                  scope: "col",
                                  abbr: weekDay
                                }, _ctx.ptm("tableHeaderCell")), [
                                  createElementVNode("span", normalizeProps(guardReactiveProps(_ctx.ptm("weekDay"))), toDisplayString(weekDay), 17)
                                ], 16, _hoisted_8);
                              }), 128))
                            ], 16)
                          ], 16),
                          createElementVNode("tbody", normalizeProps(guardReactiveProps(_ctx.ptm("tableBody"))), [
                            (openBlock(true), createElementBlock(Fragment, null, renderList(month.dates, (week, i) => {
                              return openBlock(), createElementBlock("tr", mergeProps({
                                key: week[0].day + "" + week[0].month
                              }, _ctx.ptm("tableBodyRow")), [
                                $props.showWeek ? (openBlock(), createElementBlock("td", mergeProps({
                                  key: 0,
                                  class: "p-datepicker-weeknumber"
                                }, _ctx.ptm("weekNumber")), [
                                  createElementVNode("span", mergeProps({ class: "p-disabled" }, _ctx.ptm("weekLabelContainer")), [
                                    month.weekNumbers[i] < 10 ? (openBlock(), createElementBlock("span", mergeProps({
                                      key: 0,
                                      style: { "visibility": "hidden" }
                                    }, _ctx.ptm("weekLabel")), "0", 16)) : createCommentVNode("", true),
                                    createTextVNode(" " + toDisplayString(month.weekNumbers[i]), 1)
                                  ], 16)
                                ], 16)) : createCommentVNode("", true),
                                (openBlock(true), createElementBlock(Fragment, null, renderList(week, (date) => {
                                  return openBlock(), createElementBlock("td", mergeProps({
                                    key: date.day + "" + date.month,
                                    "aria-label": date.day,
                                    class: { "p-datepicker-other-month": date.otherMonth, "p-datepicker-today": date.today }
                                  }, _ctx.ptm("day")), [
                                    withDirectives((openBlock(), createElementBlock("span", mergeProps({
                                      class: { "p-highlight": $options.isSelected(date), "p-disabled": !date.selectable },
                                      onClick: ($event) => $options.onDateSelect($event, date),
                                      draggable: "false",
                                      onKeydown: ($event) => $options.onDateCellKeydown($event, date, groupIndex),
                                      "aria-selected": $options.isSelected(date)
                                    }, _ctx.ptm("dayLabel")), [
                                      renderSlot(_ctx.$slots, "date", { date }, () => [
                                        createTextVNode(toDisplayString(date.day), 1)
                                      ])
                                    ], 16, _hoisted_10)), [
                                      [_directive_ripple]
                                    ]),
                                    $options.isSelected(date) ? (openBlock(), createElementBlock("div", mergeProps({
                                      key: 0,
                                      class: "p-hidden-accessible",
                                      "aria-live": "polite"
                                    }, _ctx.ptm("ariaSelectedDay")), toDisplayString(date.day), 17)) : createCommentVNode("", true)
                                  ], 16, _hoisted_9);
                                }), 128))
                              ], 16);
                            }), 128))
                          ], 16)
                        ], 16)
                      ], 16)) : createCommentVNode("", true)
                    ], 16);
                  }), 128))
                ], 16),
                $data.currentView === "month" ? (openBlock(), createElementBlock("div", mergeProps({
                  key: 0,
                  class: "p-monthpicker"
                }, _ctx.ptm("monthPicker")), [
                  (openBlock(true), createElementBlock(Fragment, null, renderList($options.monthPickerValues, (m, i) => {
                    return withDirectives((openBlock(), createElementBlock("span", mergeProps({
                      key: m,
                      onClick: ($event) => $options.onMonthSelect($event, { month: m, index: i }),
                      onKeydown: ($event) => $options.onMonthCellKeydown($event, { month: m, index: i }),
                      class: ["p-monthpicker-month", { "p-highlight": $options.isMonthSelected(i), "p-disabled": !m.selectable }]
                    }, _ctx.ptm("month")), [
                      createTextVNode(toDisplayString(m.value) + " ", 1),
                      $options.isMonthSelected(i) ? (openBlock(), createElementBlock("div", mergeProps({
                        key: 0,
                        class: "p-hidden-accessible",
                        "aria-live": "polite"
                      }, _ctx.ptm("ariaMonth")), toDisplayString(m.value), 17)) : createCommentVNode("", true)
                    ], 16, _hoisted_11)), [
                      [_directive_ripple]
                    ]);
                  }), 128))
                ], 16)) : createCommentVNode("", true),
                $data.currentView === "year" ? (openBlock(), createElementBlock("div", mergeProps({
                  key: 1,
                  class: "p-yearpicker"
                }, _ctx.ptm("yearPicker")), [
                  (openBlock(true), createElementBlock(Fragment, null, renderList($options.yearPickerValues, (y) => {
                    return withDirectives((openBlock(), createElementBlock("span", mergeProps({
                      key: y.value,
                      onClick: ($event) => $options.onYearSelect($event, y),
                      onKeydown: ($event) => $options.onYearCellKeydown($event, y),
                      class: ["p-yearpicker-year", { "p-highlight": $options.isYearSelected(y.value), "p-disabled": !y.selectable }]
                    }, _ctx.ptm("year")), [
                      createTextVNode(toDisplayString(y.value) + " ", 1),
                      $options.isYearSelected(y.value) ? (openBlock(), createElementBlock("div", mergeProps({
                        key: 0,
                        class: "p-hidden-accessible",
                        "aria-live": "polite"
                      }, _ctx.ptm("ariaYear")), toDisplayString(y.value), 17)) : createCommentVNode("", true)
                    ], 16, _hoisted_12)), [
                      [_directive_ripple]
                    ]);
                  }), 128))
                ], 16)) : createCommentVNode("", true)
              ], 64)) : createCommentVNode("", true),
              ($props.showTime || $props.timeOnly) && $data.currentView === "date" ? (openBlock(), createElementBlock("div", mergeProps({
                key: 1,
                class: "p-timepicker"
              }, _ctx.ptm("timePicker")), [
                createElementVNode("div", mergeProps({ class: "p-hour-picker" }, _ctx.ptm("hourPicker")), [
                  withDirectives((openBlock(), createElementBlock("button", mergeProps({
                    class: "p-link",
                    "aria-label": _ctx.$primevue.config.locale.nextHour,
                    onMousedown: _cache[13] || (_cache[13] = ($event) => $options.onTimePickerElementMouseDown($event, 0, 1)),
                    onMouseup: _cache[14] || (_cache[14] = ($event) => $options.onTimePickerElementMouseUp($event)),
                    onKeydown: [
                      _cache[15] || (_cache[15] = (...args) => $options.onContainerButtonKeydown && $options.onContainerButtonKeydown(...args)),
                      _cache[17] || (_cache[17] = withKeys(($event) => $options.onTimePickerElementMouseDown($event, 0, 1), ["enter"])),
                      _cache[18] || (_cache[18] = withKeys(($event) => $options.onTimePickerElementMouseDown($event, 0, 1), ["space"]))
                    ],
                    onMouseleave: _cache[16] || (_cache[16] = ($event) => $options.onTimePickerElementMouseLeave()),
                    onKeyup: [
                      _cache[19] || (_cache[19] = withKeys(($event) => $options.onTimePickerElementMouseUp($event), ["enter"])),
                      _cache[20] || (_cache[20] = withKeys(($event) => $options.onTimePickerElementMouseUp($event), ["space"]))
                    ],
                    type: "button"
                  }, _ctx.ptm("incrementButton")), [
                    renderSlot(_ctx.$slots, "incrementicon", {}, () => [
                      (openBlock(), createBlock(resolveDynamicComponent($props.incrementIcon ? "span" : "ChevronUpIcon"), mergeProps({ class: $props.incrementIcon }, _ctx.ptm("incrementIcon")), null, 16, ["class"]))
                    ])
                  ], 16, _hoisted_13)), [
                    [_directive_ripple]
                  ]),
                  createElementVNode("span", normalizeProps(guardReactiveProps(_ctx.ptm("hour"))), toDisplayString($options.formattedCurrentHour), 17),
                  withDirectives((openBlock(), createElementBlock("button", mergeProps({
                    class: "p-link",
                    "aria-label": _ctx.$primevue.config.locale.prevHour,
                    onMousedown: _cache[21] || (_cache[21] = ($event) => $options.onTimePickerElementMouseDown($event, 0, -1)),
                    onMouseup: _cache[22] || (_cache[22] = ($event) => $options.onTimePickerElementMouseUp($event)),
                    onKeydown: [
                      _cache[23] || (_cache[23] = (...args) => $options.onContainerButtonKeydown && $options.onContainerButtonKeydown(...args)),
                      _cache[25] || (_cache[25] = withKeys(($event) => $options.onTimePickerElementMouseDown($event, 0, -1), ["enter"])),
                      _cache[26] || (_cache[26] = withKeys(($event) => $options.onTimePickerElementMouseDown($event, 0, -1), ["space"]))
                    ],
                    onMouseleave: _cache[24] || (_cache[24] = ($event) => $options.onTimePickerElementMouseLeave()),
                    onKeyup: [
                      _cache[27] || (_cache[27] = withKeys(($event) => $options.onTimePickerElementMouseUp($event), ["enter"])),
                      _cache[28] || (_cache[28] = withKeys(($event) => $options.onTimePickerElementMouseUp($event), ["space"]))
                    ],
                    type: "button"
                  }, _ctx.ptm("decrementButton")), [
                    renderSlot(_ctx.$slots, "decrementicon", {}, () => [
                      (openBlock(), createBlock(resolveDynamicComponent($props.decrementIcon ? "span" : "ChevronDownIcon"), mergeProps({ class: $props.decrementIcon }, _ctx.ptm("decrementIcon")), null, 16, ["class"]))
                    ])
                  ], 16, _hoisted_14)), [
                    [_directive_ripple]
                  ])
                ], 16),
                createElementVNode("div", mergeProps({ class: "p-separator" }, _ctx.ptm("separatorContainer")), [
                  createElementVNode("span", normalizeProps(guardReactiveProps(_ctx.ptm("separator"))), toDisplayString($props.timeSeparator), 17)
                ], 16),
                createElementVNode("div", mergeProps({ class: "p-minute-picker" }, _ctx.ptm("minutePicker")), [
                  withDirectives((openBlock(), createElementBlock("button", mergeProps({
                    class: "p-link",
                    "aria-label": _ctx.$primevue.config.locale.nextMinute,
                    onMousedown: _cache[29] || (_cache[29] = ($event) => $options.onTimePickerElementMouseDown($event, 1, 1)),
                    onMouseup: _cache[30] || (_cache[30] = ($event) => $options.onTimePickerElementMouseUp($event)),
                    onKeydown: [
                      _cache[31] || (_cache[31] = (...args) => $options.onContainerButtonKeydown && $options.onContainerButtonKeydown(...args)),
                      _cache[33] || (_cache[33] = withKeys(($event) => $options.onTimePickerElementMouseDown($event, 1, 1), ["enter"])),
                      _cache[34] || (_cache[34] = withKeys(($event) => $options.onTimePickerElementMouseDown($event, 1, 1), ["space"]))
                    ],
                    disabled: $props.disabled,
                    onMouseleave: _cache[32] || (_cache[32] = ($event) => $options.onTimePickerElementMouseLeave()),
                    onKeyup: [
                      _cache[35] || (_cache[35] = withKeys(($event) => $options.onTimePickerElementMouseUp($event), ["enter"])),
                      _cache[36] || (_cache[36] = withKeys(($event) => $options.onTimePickerElementMouseUp($event), ["space"]))
                    ],
                    type: "button"
                  }, _ctx.ptm("incrementButton")), [
                    renderSlot(_ctx.$slots, "incrementicon", {}, () => [
                      (openBlock(), createBlock(resolveDynamicComponent($props.incrementIcon ? "span" : "ChevronUpIcon"), mergeProps({ class: $props.incrementIcon }, _ctx.ptm("incrementIcon")), null, 16, ["class"]))
                    ])
                  ], 16, _hoisted_15)), [
                    [_directive_ripple]
                  ]),
                  createElementVNode("span", normalizeProps(guardReactiveProps(_ctx.ptm("minute"))), toDisplayString($options.formattedCurrentMinute), 17),
                  withDirectives((openBlock(), createElementBlock("button", mergeProps({
                    class: "p-link",
                    "aria-label": _ctx.$primevue.config.locale.prevMinute,
                    onMousedown: _cache[37] || (_cache[37] = ($event) => $options.onTimePickerElementMouseDown($event, 1, -1)),
                    onMouseup: _cache[38] || (_cache[38] = ($event) => $options.onTimePickerElementMouseUp($event)),
                    onKeydown: [
                      _cache[39] || (_cache[39] = (...args) => $options.onContainerButtonKeydown && $options.onContainerButtonKeydown(...args)),
                      _cache[41] || (_cache[41] = withKeys(($event) => $options.onTimePickerElementMouseDown($event, 1, -1), ["enter"])),
                      _cache[42] || (_cache[42] = withKeys(($event) => $options.onTimePickerElementMouseDown($event, 1, -1), ["space"]))
                    ],
                    disabled: $props.disabled,
                    onMouseleave: _cache[40] || (_cache[40] = ($event) => $options.onTimePickerElementMouseLeave()),
                    onKeyup: [
                      _cache[43] || (_cache[43] = withKeys(($event) => $options.onTimePickerElementMouseUp($event), ["enter"])),
                      _cache[44] || (_cache[44] = withKeys(($event) => $options.onTimePickerElementMouseUp($event), ["space"]))
                    ],
                    type: "button"
                  }, _ctx.ptm("decrementButton")), [
                    renderSlot(_ctx.$slots, "decrementicon", {}, () => [
                      (openBlock(), createBlock(resolveDynamicComponent($props.decrementIcon ? "span" : "ChevronDownIcon"), mergeProps({ class: $props.decrementIcon }, _ctx.ptm("decrementIcon")), null, 16, ["class"]))
                    ])
                  ], 16, _hoisted_16)), [
                    [_directive_ripple]
                  ])
                ], 16),
                $props.showSeconds ? (openBlock(), createElementBlock("div", mergeProps({
                  key: 0,
                  class: "p-separator"
                }, _ctx.ptm("separatorContainer")), [
                  createElementVNode("span", normalizeProps(guardReactiveProps(_ctx.ptm("separator"))), toDisplayString($props.timeSeparator), 17)
                ], 16)) : createCommentVNode("", true),
                $props.showSeconds ? (openBlock(), createElementBlock("div", mergeProps({
                  key: 1,
                  class: "p-second-picker"
                }, _ctx.ptm("secondPicker")), [
                  withDirectives((openBlock(), createElementBlock("button", mergeProps({
                    class: "p-link",
                    "aria-label": _ctx.$primevue.config.locale.nextSecond,
                    onMousedown: _cache[45] || (_cache[45] = ($event) => $options.onTimePickerElementMouseDown($event, 2, 1)),
                    onMouseup: _cache[46] || (_cache[46] = ($event) => $options.onTimePickerElementMouseUp($event)),
                    onKeydown: [
                      _cache[47] || (_cache[47] = (...args) => $options.onContainerButtonKeydown && $options.onContainerButtonKeydown(...args)),
                      _cache[49] || (_cache[49] = withKeys(($event) => $options.onTimePickerElementMouseDown($event, 2, 1), ["enter"])),
                      _cache[50] || (_cache[50] = withKeys(($event) => $options.onTimePickerElementMouseDown($event, 2, 1), ["space"]))
                    ],
                    disabled: $props.disabled,
                    onMouseleave: _cache[48] || (_cache[48] = ($event) => $options.onTimePickerElementMouseLeave()),
                    onKeyup: [
                      _cache[51] || (_cache[51] = withKeys(($event) => $options.onTimePickerElementMouseUp($event), ["enter"])),
                      _cache[52] || (_cache[52] = withKeys(($event) => $options.onTimePickerElementMouseUp($event), ["space"]))
                    ],
                    type: "button"
                  }, _ctx.ptm("incrementButton")), [
                    renderSlot(_ctx.$slots, "incrementicon", {}, () => [
                      (openBlock(), createBlock(resolveDynamicComponent($props.incrementIcon ? "span" : "ChevronUpIcon"), mergeProps({ class: $props.incrementIcon }, _ctx.ptm("incrementIcon")), null, 16, ["class"]))
                    ])
                  ], 16, _hoisted_17)), [
                    [_directive_ripple]
                  ]),
                  createElementVNode("span", normalizeProps(guardReactiveProps(_ctx.ptm("second"))), toDisplayString($options.formattedCurrentSecond), 17),
                  withDirectives((openBlock(), createElementBlock("button", mergeProps({
                    class: "p-link",
                    "aria-label": _ctx.$primevue.config.locale.prevSecond,
                    onMousedown: _cache[53] || (_cache[53] = ($event) => $options.onTimePickerElementMouseDown($event, 2, -1)),
                    onMouseup: _cache[54] || (_cache[54] = ($event) => $options.onTimePickerElementMouseUp($event)),
                    onKeydown: [
                      _cache[55] || (_cache[55] = (...args) => $options.onContainerButtonKeydown && $options.onContainerButtonKeydown(...args)),
                      _cache[57] || (_cache[57] = withKeys(($event) => $options.onTimePickerElementMouseDown($event, 2, -1), ["enter"])),
                      _cache[58] || (_cache[58] = withKeys(($event) => $options.onTimePickerElementMouseDown($event, 2, -1), ["space"]))
                    ],
                    disabled: $props.disabled,
                    onMouseleave: _cache[56] || (_cache[56] = ($event) => $options.onTimePickerElementMouseLeave()),
                    onKeyup: [
                      _cache[59] || (_cache[59] = withKeys(($event) => $options.onTimePickerElementMouseUp($event), ["enter"])),
                      _cache[60] || (_cache[60] = withKeys(($event) => $options.onTimePickerElementMouseUp($event), ["space"]))
                    ],
                    type: "button"
                  }, _ctx.ptm("decrementButton")), [
                    renderSlot(_ctx.$slots, "decrementicon", {}, () => [
                      (openBlock(), createBlock(resolveDynamicComponent($props.decrementIcon ? "span" : "ChevronDownIcon"), mergeProps({ class: $props.decrementIcon }, _ctx.ptm("decrementIcon")), null, 16, ["class"]))
                    ])
                  ], 16, _hoisted_18)), [
                    [_directive_ripple]
                  ])
                ], 16)) : createCommentVNode("", true),
                $props.hourFormat == "12" ? (openBlock(), createElementBlock("div", mergeProps({
                  key: 2,
                  class: "p-separator"
                }, _ctx.ptm("separatorContainer")), [
                  createElementVNode("span", normalizeProps(guardReactiveProps(_ctx.ptm("separator"))), toDisplayString($props.timeSeparator), 17)
                ], 16)) : createCommentVNode("", true),
                $props.hourFormat == "12" ? (openBlock(), createElementBlock("div", mergeProps({
                  key: 3,
                  class: "p-ampm-picker"
                }, _ctx.ptm("ampmPicker")), [
                  withDirectives((openBlock(), createElementBlock("button", mergeProps({
                    class: "p-link",
                    "aria-label": _ctx.$primevue.config.locale.am,
                    onClick: _cache[61] || (_cache[61] = ($event) => $options.toggleAMPM($event)),
                    type: "button",
                    disabled: $props.disabled
                  }, _ctx.ptm("incrementButton")), [
                    renderSlot(_ctx.$slots, "incrementicon", {}, () => [
                      (openBlock(), createBlock(resolveDynamicComponent($props.incrementIcon ? "span" : "ChevronUpIcon"), mergeProps({ class: $props.incrementIcon }, _ctx.ptm("incrementIcon")), null, 16, ["class"]))
                    ])
                  ], 16, _hoisted_19)), [
                    [_directive_ripple]
                  ]),
                  createElementVNode("span", normalizeProps(guardReactiveProps(_ctx.ptm("ampm"))), toDisplayString($data.pm ? _ctx.$primevue.config.locale.pm : _ctx.$primevue.config.locale.am), 17),
                  withDirectives((openBlock(), createElementBlock("button", mergeProps({
                    class: "p-link",
                    "aria-label": _ctx.$primevue.config.locale.pm,
                    onClick: _cache[62] || (_cache[62] = ($event) => $options.toggleAMPM($event)),
                    type: "button",
                    disabled: $props.disabled
                  }, _ctx.ptm("decrementButton")), [
                    renderSlot(_ctx.$slots, "decrementicon", {}, () => [
                      (openBlock(), createBlock(resolveDynamicComponent($props.decrementIcon ? "span" : "ChevronDownIcon"), mergeProps({ class: $props.decrementIcon }, _ctx.ptm("decrementIcon")), null, 16, ["class"]))
                    ])
                  ], 16, _hoisted_20)), [
                    [_directive_ripple]
                  ])
                ], 16)) : createCommentVNode("", true)
              ], 16)) : createCommentVNode("", true),
              $props.showButtonBar ? (openBlock(), createElementBlock("div", mergeProps({
                key: 2,
                class: "p-datepicker-buttonbar"
              }, _ctx.ptm("buttonbar")), [
                createVNode(_component_CalendarButton, {
                  type: "button",
                  label: $options.todayLabel,
                  onClick: _cache[63] || (_cache[63] = ($event) => $options.onTodayButtonClick($event)),
                  class: "p-button-text",
                  onKeydown: $options.onContainerButtonKeydown,
                  pt: _ctx.ptm("todayButton")
                }, null, 8, ["label", "onKeydown", "pt"]),
                createVNode(_component_CalendarButton, {
                  type: "button",
                  label: $options.clearLabel,
                  onClick: _cache[64] || (_cache[64] = ($event) => $options.onClearButtonClick($event)),
                  class: "p-button-text",
                  onKeydown: $options.onContainerButtonKeydown,
                  pt: _ctx.ptm("clearButton")
                }, null, 8, ["label", "onKeydown", "pt"])
              ], 16)) : createCommentVNode("", true),
              renderSlot(_ctx.$slots, "footer")
            ], 16, _hoisted_3$j)) : createCommentVNode("", true)
          ]),
          _: 3
        }, 8, ["onAfterEnter", "onAfterLeave", "onLeave"])
      ]),
      _: 3
    }, 8, ["appendTo", "disabled"])
  ], 16, _hoisted_1$F);
}
function styleInject$e(css, ref2) {
  if (ref2 === void 0)
    ref2 = {};
  var insertAt = ref2.insertAt;
  if (!css || true) {
    return;
  }
  var head = document.head || document.getElementsByTagName("head")[0];
  var style = document.createElement("style");
  style.type = "text/css";
  if (insertAt === "top") {
    if (head.firstChild) {
      head.insertBefore(style, head.firstChild);
    } else {
      head.appendChild(style);
    }
  } else {
    head.appendChild(style);
  }
  if (style.styleSheet) {
    style.styleSheet.cssText = css;
  } else {
    style.appendChild(document.createTextNode(css));
  }
}
var css_248z$e = "\n.p-calendar {\n    position: relative;\n    display: inline-flex;\n    max-width: 100%;\n}\n.p-calendar .p-inputtext {\n    flex: 1 1 auto;\n    width: 1%;\n}\n.p-calendar-w-btn .p-inputtext {\n    border-top-right-radius: 0;\n    border-bottom-right-radius: 0;\n}\n.p-calendar-w-btn .p-datepicker-trigger {\n    border-top-left-radius: 0;\n    border-bottom-left-radius: 0;\n}\n\n/* Fluid */\n.p-fluid .p-calendar {\n    display: flex;\n}\n.p-fluid .p-calendar .p-inputtext {\n    width: 1%;\n}\n\n/* Datepicker */\n.p-calendar .p-datepicker {\n    min-width: 100%;\n}\n.p-datepicker {\n    width: auto;\n    position: absolute;\n    top: 0;\n    left: 0;\n}\n.p-datepicker-inline {\n    display: inline-block;\n    position: static;\n    overflow-x: auto;\n}\n\n/* Header */\n.p-datepicker-header {\n    display: flex;\n    align-items: center;\n    justify-content: space-between;\n}\n.p-datepicker-header .p-datepicker-title {\n    margin: 0 auto;\n}\n.p-datepicker-prev,\n.p-datepicker-next {\n    cursor: pointer;\n    display: inline-flex;\n    justify-content: center;\n    align-items: center;\n    overflow: hidden;\n    position: relative;\n}\n\n/* Multiple Month DatePicker */\n.p-datepicker-multiple-month .p-datepicker-group-container {\n    display: flex;\n}\n.p-datepicker-multiple-month .p-datepicker-group-container .p-datepicker-group {\n    flex: 1 1 auto;\n}\n\n/* DatePicker Table */\n.p-datepicker table {\n    width: 100%;\n    border-collapse: collapse;\n}\n.p-datepicker td > span {\n    display: flex;\n    justify-content: center;\n    align-items: center;\n    cursor: pointer;\n    margin: 0 auto;\n    overflow: hidden;\n    position: relative;\n}\n\n/* Month Picker */\n.p-monthpicker-month {\n    width: 33.3%;\n    display: inline-flex;\n    align-items: center;\n    justify-content: center;\n    cursor: pointer;\n    overflow: hidden;\n    position: relative;\n}\n\n/* Year Picker */\n.p-yearpicker-year {\n    width: 50%;\n    display: inline-flex;\n    align-items: center;\n    justify-content: center;\n    cursor: pointer;\n    overflow: hidden;\n    position: relative;\n}\n\n/*  Button Bar */\n.p-datepicker-buttonbar {\n    display: flex;\n    justify-content: space-between;\n    align-items: center;\n}\n\n/* Time Picker */\n.p-timepicker {\n    display: flex;\n    justify-content: center;\n    align-items: center;\n}\n.p-timepicker button {\n    display: flex;\n    align-items: center;\n    justify-content: center;\n    cursor: pointer;\n    overflow: hidden;\n    position: relative;\n}\n.p-timepicker > div {\n    display: flex;\n    align-items: center;\n    flex-direction: column;\n}\n\n/* Touch UI */\n.p-datepicker-touch-ui,\n.p-calendar .p-datepicker-touch-ui {\n    position: fixed;\n    top: 50%;\n    left: 50%;\n    min-width: 80vw;\n    transform: translate(-50%, -50%);\n}\n";
styleInject$e(css_248z$e);
script$J.render = render$J;
var script$I = {
  name: "InputText",
  extends: script$W,
  emits: ["update:modelValue"],
  props: {
    modelValue: null
  },
  methods: {
    onInput(event2) {
      this.$emit("update:modelValue", event2.target.value);
    }
  },
  computed: {
    filled() {
      return this.modelValue != null && this.modelValue.toString().length > 0;
    }
  }
};
const _hoisted_1$E = ["value"];
function render$I(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("input", mergeProps({
    class: ["p-inputtext p-component", { "p-filled": $options.filled }],
    value: $props.modelValue,
    onInput: _cache[0] || (_cache[0] = (...args) => $options.onInput && $options.onInput(...args))
  }, _ctx.ptm("root")), null, 16, _hoisted_1$E);
}
script$I.render = render$I;
var script$H = {
  name: "CheckIcon",
  extends: script$V
};
const _hoisted_1$D = /* @__PURE__ */ createElementVNode("path", {
  d: "M4.86199 11.5948C4.78717 11.5923 4.71366 11.5745 4.64596 11.5426C4.57826 11.5107 4.51779 11.4652 4.46827 11.4091L0.753985 7.69483C0.683167 7.64891 0.623706 7.58751 0.580092 7.51525C0.536478 7.44299 0.509851 7.36177 0.502221 7.27771C0.49459 7.19366 0.506156 7.10897 0.536046 7.03004C0.565935 6.95111 0.613367 6.88 0.674759 6.82208C0.736151 6.76416 0.8099 6.72095 0.890436 6.69571C0.970973 6.67046 1.05619 6.66385 1.13966 6.67635C1.22313 6.68886 1.30266 6.72017 1.37226 6.76792C1.44186 6.81567 1.4997 6.8786 1.54141 6.95197L4.86199 10.2503L12.6397 2.49483C12.7444 2.42694 12.8689 2.39617 12.9932 2.40745C13.1174 2.41873 13.2343 2.47141 13.3251 2.55705C13.4159 2.64268 13.4753 2.75632 13.4938 2.87973C13.5123 3.00315 13.4888 3.1292 13.4271 3.23768L5.2557 11.4091C5.20618 11.4652 5.14571 11.5107 5.07801 11.5426C5.01031 11.5745 4.9368 11.5923 4.86199 11.5948Z",
  fill: "currentColor"
}, null, -1);
const _hoisted_2$p = [
  _hoisted_1$D
];
function render$H(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("svg", mergeProps({
    width: "14",
    height: "14",
    viewBox: "0 0 14 14",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, _ctx.pti()), _hoisted_2$p, 16);
}
script$H.render = render$H;
var script$G = {
  name: "ExclamationTriangleIcon",
  extends: script$V
};
const _hoisted_1$C = /* @__PURE__ */ createStaticVNode('<g clip-path="url(#clip0_323_12417)"><path d="M13.4018 13.1893H0.598161C0.49329 13.189 0.390283 13.1615 0.299143 13.1097C0.208003 13.0578 0.131826 12.9832 0.0780112 12.8932C0.0268539 12.8015 0 12.6982 0 12.5931C0 12.4881 0.0268539 12.3848 0.0780112 12.293L6.47985 1.08982C6.53679 1.00399 6.61408 0.933574 6.70484 0.884867C6.7956 0.836159 6.897 0.810669 7 0.810669C7.103 0.810669 7.2044 0.836159 7.29516 0.884867C7.38592 0.933574 7.46321 1.00399 7.52015 1.08982L13.922 12.293C13.9731 12.3848 14 12.4881 14 12.5931C14 12.6982 13.9731 12.8015 13.922 12.8932C13.8682 12.9832 13.792 13.0578 13.7009 13.1097C13.6097 13.1615 13.5067 13.189 13.4018 13.1893ZM1.63046 11.989H12.3695L7 2.59425L1.63046 11.989Z" fill="currentColor"></path><path d="M6.99996 8.78801C6.84143 8.78594 6.68997 8.72204 6.57787 8.60993C6.46576 8.49782 6.40186 8.34637 6.39979 8.18784V5.38703C6.39979 5.22786 6.46302 5.0752 6.57557 4.96265C6.68813 4.85009 6.84078 4.78686 6.99996 4.78686C7.15914 4.78686 7.31179 4.85009 7.42435 4.96265C7.5369 5.0752 7.60013 5.22786 7.60013 5.38703V8.18784C7.59806 8.34637 7.53416 8.49782 7.42205 8.60993C7.30995 8.72204 7.15849 8.78594 6.99996 8.78801Z" fill="currentColor"></path><path d="M6.99996 11.1887C6.84143 11.1866 6.68997 11.1227 6.57787 11.0106C6.46576 10.8985 6.40186 10.7471 6.39979 10.5885V10.1884C6.39979 10.0292 6.46302 9.87658 6.57557 9.76403C6.68813 9.65147 6.84078 9.58824 6.99996 9.58824C7.15914 9.58824 7.31179 9.65147 7.42435 9.76403C7.5369 9.87658 7.60013 10.0292 7.60013 10.1884V10.5885C7.59806 10.7471 7.53416 10.8985 7.42205 11.0106C7.30995 11.1227 7.15849 11.1866 6.99996 11.1887Z" fill="currentColor"></path></g><defs><clipPath id="clip0_323_12417"><rect width="14" height="14" fill="white"></rect></clipPath></defs>', 2);
const _hoisted_3$i = [
  _hoisted_1$C
];
function render$G(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("svg", mergeProps({
    width: "14",
    height: "14",
    viewBox: "0 0 14 14",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, _ctx.pti()), _hoisted_3$i, 16);
}
script$G.render = render$G;
var script$F = {
  name: "InfoCircleIcon",
  extends: script$V
};
const _hoisted_1$B = /* @__PURE__ */ createElementVNode("g", { "clip-path": "url(#clip0_408_21102)" }, [
  /* @__PURE__ */ createElementVNode("path", {
    "fill-rule": "evenodd",
    "clip-rule": "evenodd",
    d: "M3.11101 12.8203C4.26215 13.5895 5.61553 14 7 14C8.85652 14 10.637 13.2625 11.9497 11.9497C13.2625 10.637 14 8.85652 14 7C14 5.61553 13.5895 4.26215 12.8203 3.11101C12.0511 1.95987 10.9579 1.06266 9.67879 0.532846C8.3997 0.00303296 6.99224 -0.13559 5.63437 0.134506C4.2765 0.404603 3.02922 1.07129 2.05026 2.05026C1.07129 3.02922 0.404603 4.2765 0.134506 5.63437C-0.13559 6.99224 0.00303296 8.3997 0.532846 9.67879C1.06266 10.9579 1.95987 12.0511 3.11101 12.8203ZM3.75918 2.14976C4.71846 1.50879 5.84628 1.16667 7 1.16667C8.5471 1.16667 10.0308 1.78125 11.1248 2.87521C12.2188 3.96918 12.8333 5.45291 12.8333 7C12.8333 8.15373 12.4912 9.28154 11.8502 10.2408C11.2093 11.2001 10.2982 11.9478 9.23232 12.3893C8.16642 12.8308 6.99353 12.9463 5.86198 12.7212C4.73042 12.4962 3.69102 11.9406 2.87521 11.1248C2.05941 10.309 1.50384 9.26958 1.27876 8.13803C1.05367 7.00647 1.16919 5.83358 1.61071 4.76768C2.05222 3.70178 2.79989 2.79074 3.75918 2.14976ZM7.00002 4.8611C6.84594 4.85908 6.69873 4.79698 6.58977 4.68801C6.48081 4.57905 6.4187 4.43185 6.41669 4.27776V3.88888C6.41669 3.73417 6.47815 3.58579 6.58754 3.4764C6.69694 3.367 6.84531 3.30554 7.00002 3.30554C7.15473 3.30554 7.3031 3.367 7.4125 3.4764C7.52189 3.58579 7.58335 3.73417 7.58335 3.88888V4.27776C7.58134 4.43185 7.51923 4.57905 7.41027 4.68801C7.30131 4.79698 7.1541 4.85908 7.00002 4.8611ZM7.00002 10.6945C6.84594 10.6925 6.69873 10.6304 6.58977 10.5214C6.48081 10.4124 6.4187 10.2652 6.41669 10.1111V6.22225C6.41669 6.06754 6.47815 5.91917 6.58754 5.80977C6.69694 5.70037 6.84531 5.63892 7.00002 5.63892C7.15473 5.63892 7.3031 5.70037 7.4125 5.80977C7.52189 5.91917 7.58335 6.06754 7.58335 6.22225V10.1111C7.58134 10.2652 7.51923 10.4124 7.41027 10.5214C7.30131 10.6304 7.1541 10.6925 7.00002 10.6945Z",
    fill: "currentColor"
  })
], -1);
const _hoisted_2$o = /* @__PURE__ */ createElementVNode("defs", null, [
  /* @__PURE__ */ createElementVNode("clipPath", { id: "clip0_408_21102" }, [
    /* @__PURE__ */ createElementVNode("rect", {
      width: "14",
      height: "14",
      fill: "white"
    })
  ])
], -1);
const _hoisted_3$h = [
  _hoisted_1$B,
  _hoisted_2$o
];
function render$F(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("svg", mergeProps({
    width: "14",
    height: "14",
    viewBox: "0 0 14 14",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, _ctx.pti()), _hoisted_3$h, 16);
}
script$F.render = render$F;
var script$E = {
  name: "TimesIcon",
  extends: script$V
};
const _hoisted_1$A = /* @__PURE__ */ createElementVNode("path", {
  d: "M8.01186 7.00933L12.27 2.75116C12.341 2.68501 12.398 2.60524 12.4375 2.51661C12.4769 2.42798 12.4982 2.3323 12.4999 2.23529C12.5016 2.13827 12.4838 2.0419 12.4474 1.95194C12.4111 1.86197 12.357 1.78024 12.2884 1.71163C12.2198 1.64302 12.138 1.58893 12.0481 1.55259C11.9581 1.51625 11.8617 1.4984 11.7647 1.50011C11.6677 1.50182 11.572 1.52306 11.4834 1.56255C11.3948 1.60204 11.315 1.65898 11.2488 1.72997L6.99067 5.98814L2.7325 1.72997C2.59553 1.60234 2.41437 1.53286 2.22718 1.53616C2.03999 1.53946 1.8614 1.61529 1.72901 1.74767C1.59663 1.88006 1.5208 2.05865 1.5175 2.24584C1.5142 2.43303 1.58368 2.61419 1.71131 2.75116L5.96948 7.00933L1.71131 11.2675C1.576 11.403 1.5 11.5866 1.5 11.7781C1.5 11.9696 1.576 12.1532 1.71131 12.2887C1.84679 12.424 2.03043 12.5 2.2219 12.5C2.41338 12.5 2.59702 12.424 2.7325 12.2887L6.99067 8.03052L11.2488 12.2887C11.3843 12.424 11.568 12.5 11.7594 12.5C11.9509 12.5 12.1346 12.424 12.27 12.2887C12.4053 12.1532 12.4813 11.9696 12.4813 11.7781C12.4813 11.5866 12.4053 11.403 12.27 11.2675L8.01186 7.00933Z",
  fill: "currentColor"
}, null, -1);
const _hoisted_2$n = [
  _hoisted_1$A
];
function render$E(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("svg", mergeProps({
    width: "14",
    height: "14",
    viewBox: "0 0 14 14",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, _ctx.pti()), _hoisted_2$n, 16);
}
script$E.render = render$E;
var script$D = {
  name: "Message",
  extends: script$W,
  emits: ["close"],
  props: {
    severity: {
      type: String,
      default: "info"
    },
    closable: {
      type: Boolean,
      default: true
    },
    sticky: {
      type: Boolean,
      default: true
    },
    life: {
      type: Number,
      default: 3e3
    },
    icon: {
      type: String,
      default: void 0
    },
    closeIcon: {
      type: String,
      default: void 0
    },
    closeButtonProps: {
      type: null,
      default: null
    }
  },
  timeout: null,
  data() {
    return {
      visible: true
    };
  },
  mounted() {
    if (!this.sticky) {
      this.closeAfterDelay();
    }
  },
  methods: {
    close(event2) {
      this.visible = false;
      this.$emit("close", event2);
    },
    closeAfterDelay() {
      setTimeout(() => {
        this.visible = false;
      }, this.life);
    }
  },
  computed: {
    containerClass() {
      return "p-message p-component p-message-" + this.severity;
    },
    iconComponent() {
      return {
        info: script$F,
        success: script$H,
        warn: script$G,
        error: script$R
      }[this.severity];
    },
    closeAriaLabel() {
      return this.$primevue.config.locale.aria ? this.$primevue.config.locale.aria.close : void 0;
    }
  },
  directives: {
    ripple: Ripple
  },
  components: {
    TimesIcon: script$E,
    InfoCircleIcon: script$F,
    CheckIcon: script$H,
    ExclamationTriangleIcon: script$G,
    TimesCircleIcon: script$R
  }
};
const _hoisted_1$z = ["aria-label"];
function render$D(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_TimesIcon = resolveComponent("TimesIcon");
  const _directive_ripple = resolveDirective("ripple");
  return openBlock(), createBlock(Transition, {
    name: "p-message",
    appear: ""
  }, {
    default: withCtx(() => [
      withDirectives(createElementVNode("div", mergeProps({
        class: $options.containerClass,
        role: "alert",
        "aria-live": "assertive",
        "aria-atomic": "true"
      }, _ctx.ptm("root")), [
        createElementVNode("div", mergeProps({ class: "p-message-wrapper" }, _ctx.ptm("wrapper")), [
          renderSlot(_ctx.$slots, "messageicon", { class: "p-message-icon" }, () => [
            (openBlock(), createBlock(resolveDynamicComponent($props.icon ? "span" : $options.iconComponent), mergeProps({
              class: ["p-message-icon", $props.icon]
            }, _ctx.ptm("icon")), null, 16, ["class"]))
          ]),
          createElementVNode("div", mergeProps({ class: "p-message-text" }, _ctx.ptm("text")), [
            renderSlot(_ctx.$slots, "default")
          ], 16),
          $props.closable ? withDirectives((openBlock(), createElementBlock("button", mergeProps({
            key: 0,
            class: "p-message-close p-link",
            "aria-label": $options.closeAriaLabel,
            type: "button",
            onClick: _cache[0] || (_cache[0] = ($event) => $options.close($event))
          }, { ...$props.closeButtonProps, ..._ctx.ptm("button") }), [
            renderSlot(_ctx.$slots, "closeicon", { class: "p-message-close-icon" }, () => [
              $props.closeIcon ? (openBlock(), createElementBlock("i", mergeProps({
                key: 0,
                class: ["p-message-close-icon", $props.closeIcon]
              }, _ctx.ptm("buttonIcon")), null, 16)) : (openBlock(), createBlock(_component_TimesIcon, mergeProps({
                key: 1,
                class: "p-message-close-icon"
              }, _ctx.ptm("buttonIcon")), null, 16))
            ])
          ], 16, _hoisted_1$z)), [
            [_directive_ripple]
          ]) : createCommentVNode("", true)
        ], 16)
      ], 16), [
        [vShow, $data.visible]
      ])
    ]),
    _: 3
  });
}
function styleInject$d(css, ref2) {
  if (ref2 === void 0)
    ref2 = {};
  var insertAt = ref2.insertAt;
  if (!css || true) {
    return;
  }
  var head = document.head || document.getElementsByTagName("head")[0];
  var style = document.createElement("style");
  style.type = "text/css";
  if (insertAt === "top") {
    if (head.firstChild) {
      head.insertBefore(style, head.firstChild);
    } else {
      head.appendChild(style);
    }
  } else {
    head.appendChild(style);
  }
  if (style.styleSheet) {
    style.styleSheet.cssText = css;
  } else {
    style.appendChild(document.createTextNode(css));
  }
}
var css_248z$d = "\n.p-message-wrapper {\n    display: flex;\n    align-items: center;\n}\n.p-message-close {\n    display: flex;\n    align-items: center;\n    justify-content: center;\n}\n.p-message-close.p-link {\n    margin-left: auto;\n    overflow: hidden;\n    position: relative;\n}\n.p-message-enter-from {\n    opacity: 0;\n}\n.p-message-enter-active {\n    transition: opacity 0.3s;\n}\n.p-message.p-message-leave-from {\n    max-height: 1000px;\n}\n.p-message.p-message-leave-to {\n    max-height: 0;\n    opacity: 0;\n    margin: 0 !important;\n}\n.p-message-leave-active {\n    overflow: hidden;\n    transition: max-height 0.3s cubic-bezier(0, 1, 0, 1), opacity 0.3s, margin 0.15s;\n}\n.p-message-leave-active .p-message-close {\n    display: none;\n}\n";
styleInject$d(css_248z$d);
script$D.render = render$D;
var script$C = {
  name: "ProgressSpinner",
  extends: script$W,
  props: {
    strokeWidth: {
      type: String,
      default: "2"
    },
    fill: {
      type: String,
      default: "none"
    },
    animationDuration: {
      type: String,
      default: "2s"
    }
  },
  computed: {
    svgStyle() {
      return {
        "animation-duration": this.animationDuration
      };
    }
  }
};
const _hoisted_1$y = ["fill", "stroke-width"];
function render$C(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("div", mergeProps({
    class: "p-progress-spinner",
    role: "progressbar"
  }, _ctx.ptm("root")), [
    (openBlock(), createElementBlock("svg", mergeProps({
      class: "p-progress-spinner-svg",
      viewBox: "25 25 50 50",
      style: $options.svgStyle
    }, _ctx.ptm("spinner")), [
      createElementVNode("circle", mergeProps({
        class: "p-progress-spinner-circle",
        cx: "50",
        cy: "50",
        r: "20",
        fill: $props.fill,
        "stroke-width": $props.strokeWidth,
        strokeMiterlimit: "10"
      }, _ctx.ptm("circle")), null, 16, _hoisted_1$y)
    ], 16))
  ], 16);
}
function styleInject$c(css, ref2) {
  if (ref2 === void 0)
    ref2 = {};
  var insertAt = ref2.insertAt;
  if (!css || true) {
    return;
  }
  var head = document.head || document.getElementsByTagName("head")[0];
  var style = document.createElement("style");
  style.type = "text/css";
  if (insertAt === "top") {
    if (head.firstChild) {
      head.insertBefore(style, head.firstChild);
    } else {
      head.appendChild(style);
    }
  } else {
    head.appendChild(style);
  }
  if (style.styleSheet) {
    style.styleSheet.cssText = css;
  } else {
    style.appendChild(document.createTextNode(css));
  }
}
var css_248z$c = "\n.p-progress-spinner {\n    position: relative;\n    margin: 0 auto;\n    width: 100px;\n    height: 100px;\n    display: inline-block;\n}\n.p-progress-spinner::before {\n    content: '';\n    display: block;\n    padding-top: 100%;\n}\n.p-progress-spinner-svg {\n    height: 100%;\n    transform-origin: center center;\n    width: 100%;\n    position: absolute;\n    top: 0;\n    bottom: 0;\n    left: 0;\n    right: 0;\n    margin: auto;\n}\n";
styleInject$c(css_248z$c);
script$C.render = render$C;
var script$B = {
  name: "FilterIcon",
  extends: script$V
};
const _hoisted_1$x = /* @__PURE__ */ createElementVNode("g", { "clip-path": "url(#clip0_390_17708)" }, [
  /* @__PURE__ */ createElementVNode("path", {
    d: "M8.64708 14H5.35296C5.18981 13.9979 5.03395 13.9321 4.91858 13.8167C4.8032 13.7014 4.73745 13.5455 4.73531 13.3824V7L0.329431 0.98C0.259794 0.889466 0.217389 0.780968 0.20718 0.667208C0.19697 0.553448 0.219379 0.439133 0.271783 0.337647C0.324282 0.236453 0.403423 0.151519 0.500663 0.0920138C0.597903 0.0325088 0.709548 0.000692754 0.823548 0H13.1765C13.2905 0.000692754 13.4021 0.0325088 13.4994 0.0920138C13.5966 0.151519 13.6758 0.236453 13.7283 0.337647C13.7807 0.439133 13.8031 0.553448 13.7929 0.667208C13.7826 0.780968 13.7402 0.889466 13.6706 0.98L9.26472 7V13.3824C9.26259 13.5455 9.19683 13.7014 9.08146 13.8167C8.96609 13.9321 8.81022 13.9979 8.64708 14ZM5.97061 12.7647H8.02943V6.79412C8.02878 6.66289 8.07229 6.53527 8.15296 6.43177L11.9412 1.23529H2.05884L5.86355 6.43177C5.94422 6.53527 5.98773 6.66289 5.98708 6.79412L5.97061 12.7647Z",
    fill: "currentColor"
  })
], -1);
const _hoisted_2$m = /* @__PURE__ */ createElementVNode("defs", null, [
  /* @__PURE__ */ createElementVNode("clipPath", { id: "clip0_390_17708" }, [
    /* @__PURE__ */ createElementVNode("rect", {
      width: "14",
      height: "14",
      fill: "white"
    })
  ])
], -1);
const _hoisted_3$g = [
  _hoisted_1$x,
  _hoisted_2$m
];
function render$B(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("svg", mergeProps({
    width: "14",
    height: "14",
    viewBox: "0 0 14 14",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, _ctx.pti()), _hoisted_3$g, 16);
}
script$B.render = render$B;
var script$A = {
  name: "Dropdown",
  extends: script$W,
  emits: ["update:modelValue", "change", "focus", "blur", "before-show", "before-hide", "show", "hide", "filter"],
  props: {
    modelValue: null,
    options: Array,
    optionLabel: null,
    optionValue: null,
    optionDisabled: null,
    optionGroupLabel: null,
    optionGroupChildren: null,
    scrollHeight: {
      type: String,
      default: "200px"
    },
    filter: Boolean,
    filterPlaceholder: String,
    filterLocale: String,
    filterMatchMode: {
      type: String,
      default: "contains"
    },
    filterFields: {
      type: Array,
      default: null
    },
    editable: Boolean,
    placeholder: {
      type: String,
      default: null
    },
    disabled: {
      type: Boolean,
      default: false
    },
    dataKey: null,
    showClear: {
      type: Boolean,
      default: false
    },
    inputId: {
      type: String,
      default: null
    },
    inputClass: {
      type: [String, Object],
      default: null
    },
    inputStyle: {
      type: Object,
      default: null
    },
    inputProps: {
      type: null,
      default: null
    },
    panelClass: {
      type: [String, Object],
      default: null
    },
    panelStyle: {
      type: Object,
      default: null
    },
    panelProps: {
      type: null,
      default: null
    },
    filterInputProps: {
      type: null,
      default: null
    },
    clearIconProps: {
      type: null,
      default: null
    },
    appendTo: {
      type: String,
      default: "body"
    },
    loading: {
      type: Boolean,
      default: false
    },
    clearIcon: {
      type: String,
      default: void 0
    },
    dropdownIcon: {
      type: String,
      default: void 0
    },
    filterIcon: {
      type: String,
      default: void 0
    },
    loadingIcon: {
      type: String,
      default: void 0
    },
    resetFilterOnHide: {
      type: Boolean,
      default: false
    },
    virtualScrollerOptions: {
      type: Object,
      default: null
    },
    autoOptionFocus: {
      type: Boolean,
      default: true
    },
    autoFilterFocus: {
      type: Boolean,
      default: false
    },
    selectOnFocus: {
      type: Boolean,
      default: false
    },
    filterMessage: {
      type: String,
      default: null
    },
    selectionMessage: {
      type: String,
      default: null
    },
    emptySelectionMessage: {
      type: String,
      default: null
    },
    emptyFilterMessage: {
      type: String,
      default: null
    },
    emptyMessage: {
      type: String,
      default: null
    },
    tabindex: {
      type: Number,
      default: 0
    },
    "aria-label": {
      type: String,
      default: null
    },
    "aria-labelledby": {
      type: String,
      default: null
    }
  },
  outsideClickListener: null,
  scrollHandler: null,
  resizeListener: null,
  overlay: null,
  list: null,
  virtualScroller: null,
  searchTimeout: null,
  searchValue: null,
  isModelValueChanged: false,
  focusOnHover: false,
  data() {
    return {
      id: this.$attrs.id,
      focused: false,
      focusedOptionIndex: -1,
      filterValue: null,
      overlayVisible: false
    };
  },
  watch: {
    "$attrs.id": function(newValue) {
      this.id = newValue || UniqueComponentId();
    },
    modelValue() {
      this.isModelValueChanged = true;
    },
    options() {
      this.autoUpdateModel();
    }
  },
  mounted() {
    this.id = this.id || UniqueComponentId();
    this.autoUpdateModel();
  },
  updated() {
    if (this.overlayVisible && this.isModelValueChanged) {
      this.scrollInView(this.findSelectedOptionIndex());
    }
    this.isModelValueChanged = false;
  },
  beforeUnmount() {
    this.unbindOutsideClickListener();
    this.unbindResizeListener();
    if (this.scrollHandler) {
      this.scrollHandler.destroy();
      this.scrollHandler = null;
    }
    if (this.overlay) {
      ZIndexUtils.clear(this.overlay);
      this.overlay = null;
    }
  },
  methods: {
    getOptionIndex(index, fn) {
      return this.virtualScrollerDisabled ? index : fn && fn(index)["index"];
    },
    getOptionLabel(option) {
      return this.optionLabel ? ObjectUtils.resolveFieldData(option, this.optionLabel) : option;
    },
    getOptionValue(option) {
      return this.optionValue ? ObjectUtils.resolveFieldData(option, this.optionValue) : option;
    },
    getOptionRenderKey(option, index) {
      return (this.dataKey ? ObjectUtils.resolveFieldData(option, this.dataKey) : this.getOptionLabel(option)) + "_" + index;
    },
    getPTOptions(option, itemOptions, index, key) {
      return this.ptm(key, {
        context: {
          selected: this.isSelected(option),
          focused: this.focusedOptionIndex === this.getOptionIndex(index, itemOptions),
          disabled: this.isOptionDisabled(option)
        }
      });
    },
    isOptionDisabled(option) {
      return this.optionDisabled ? ObjectUtils.resolveFieldData(option, this.optionDisabled) : false;
    },
    isOptionGroup(option) {
      return this.optionGroupLabel && option.optionGroup && option.group;
    },
    getOptionGroupLabel(optionGroup) {
      return ObjectUtils.resolveFieldData(optionGroup, this.optionGroupLabel);
    },
    getOptionGroupChildren(optionGroup) {
      return ObjectUtils.resolveFieldData(optionGroup, this.optionGroupChildren);
    },
    getAriaPosInset(index) {
      return (this.optionGroupLabel ? index - this.visibleOptions.slice(0, index).filter((option) => this.isOptionGroup(option)).length : index) + 1;
    },
    show(isFocus) {
      this.$emit("before-show");
      this.overlayVisible = true;
      this.focusedOptionIndex = this.focusedOptionIndex !== -1 ? this.focusedOptionIndex : this.autoOptionFocus ? this.findFirstFocusedOptionIndex() : -1;
      isFocus && DomHandler.focus(this.$refs.focusInput);
    },
    hide(isFocus) {
      const _hide = () => {
        this.$emit("before-hide");
        this.overlayVisible = false;
        this.focusedOptionIndex = -1;
        this.searchValue = "";
        this.resetFilterOnHide && (this.filterValue = null);
        isFocus && DomHandler.focus(this.$refs.focusInput);
      };
      setTimeout(() => {
        _hide();
      }, 0);
    },
    onFocus(event2) {
      if (this.disabled) {
        return;
      }
      this.focused = true;
      this.focusedOptionIndex = this.focusedOptionIndex !== -1 ? this.focusedOptionIndex : this.overlayVisible && this.autoOptionFocus ? this.findFirstFocusedOptionIndex() : -1;
      this.overlayVisible && this.scrollInView(this.focusedOptionIndex);
      this.$emit("focus", event2);
    },
    onBlur(event2) {
      this.focused = false;
      this.focusedOptionIndex = -1;
      this.searchValue = "";
      this.$emit("blur", event2);
    },
    onKeyDown(event2) {
      if (this.disabled) {
        event2.preventDefault();
        return;
      }
      const metaKey = event2.metaKey || event2.ctrlKey;
      switch (event2.code) {
        case "ArrowDown":
          this.onArrowDownKey(event2);
          break;
        case "ArrowUp":
          this.onArrowUpKey(event2, this.editable);
          break;
        case "ArrowLeft":
        case "ArrowRight":
          this.onArrowLeftKey(event2, this.editable);
          break;
        case "Home":
          this.onHomeKey(event2, this.editable);
          break;
        case "End":
          this.onEndKey(event2, this.editable);
          break;
        case "PageDown":
          this.onPageDownKey(event2);
          break;
        case "PageUp":
          this.onPageUpKey(event2);
          break;
        case "Space":
          this.onSpaceKey(event2, this.editable);
          break;
        case "Enter":
        case "NumpadEnter":
          this.onEnterKey(event2);
          break;
        case "Escape":
          this.onEscapeKey(event2);
          break;
        case "Tab":
          this.onTabKey(event2);
          break;
        case "Backspace":
          this.onBackspaceKey(event2, this.editable);
          break;
        case "ShiftLeft":
        case "ShiftRight":
          break;
        default:
          if (!metaKey && ObjectUtils.isPrintableCharacter(event2.key)) {
            !this.overlayVisible && this.show();
            !this.editable && this.searchOptions(event2, event2.key);
          }
          break;
      }
    },
    onEditableInput(event2) {
      const value = event2.target.value;
      this.searchValue = "";
      const matched = this.searchOptions(event2, value);
      !matched && (this.focusedOptionIndex = -1);
      this.updateModel(event2, value);
    },
    onContainerClick(event2) {
      if (this.disabled || this.loading) {
        return;
      }
      if (DomHandler.hasClass(event2.target, "p-dropdown-clear-icon") || event2.target.tagName === "INPUT") {
        return;
      } else if (!this.overlay || !this.overlay.contains(event2.target)) {
        this.overlayVisible ? this.hide(true) : this.show(true);
      }
    },
    onClearClick(event2) {
      this.updateModel(event2, null);
    },
    onFirstHiddenFocus(event2) {
      const focusableEl = event2.relatedTarget === this.$refs.focusInput ? DomHandler.getFirstFocusableElement(this.overlay, ":not(.p-hidden-focusable)") : this.$refs.focusInput;
      DomHandler.focus(focusableEl);
    },
    onLastHiddenFocus(event2) {
      const focusableEl = event2.relatedTarget === this.$refs.focusInput ? DomHandler.getLastFocusableElement(this.overlay, ":not(.p-hidden-focusable)") : this.$refs.focusInput;
      DomHandler.focus(focusableEl);
    },
    onOptionSelect(event2, option, isHide = true) {
      const value = this.getOptionValue(option);
      this.updateModel(event2, value);
      isHide && this.hide(true);
    },
    onOptionMouseMove(event2, index) {
      if (this.focusOnHover) {
        this.changeFocusedOptionIndex(event2, index);
      }
    },
    onFilterChange(event2) {
      const value = event2.target.value;
      this.filterValue = value;
      this.focusedOptionIndex = -1;
      this.$emit("filter", { originalEvent: event2, value });
      !this.virtualScrollerDisabled && this.virtualScroller.scrollToIndex(0);
    },
    onFilterKeyDown(event2) {
      switch (event2.code) {
        case "ArrowDown":
          this.onArrowDownKey(event2);
          break;
        case "ArrowUp":
          this.onArrowUpKey(event2, true);
          break;
        case "ArrowLeft":
        case "ArrowRight":
          this.onArrowLeftKey(event2, true);
          break;
        case "Home":
          this.onHomeKey(event2, true);
          break;
        case "End":
          this.onEndKey(event2, true);
          break;
        case "Enter":
          this.onEnterKey(event2);
          break;
        case "Escape":
          this.onEscapeKey(event2);
          break;
        case "Tab":
          this.onTabKey(event2, true);
          break;
      }
    },
    onFilterBlur() {
      this.focusedOptionIndex = -1;
    },
    onFilterUpdated() {
      if (this.overlayVisible) {
        this.alignOverlay();
      }
    },
    onOverlayClick(event2) {
      OverlayEventBus.emit("overlay-click", {
        originalEvent: event2,
        target: this.$el
      });
    },
    onOverlayKeyDown(event2) {
      switch (event2.code) {
        case "Escape":
          this.onEscapeKey(event2);
          break;
      }
    },
    onArrowDownKey(event2) {
      const optionIndex = this.focusedOptionIndex !== -1 ? this.findNextOptionIndex(this.focusedOptionIndex) : this.findFirstFocusedOptionIndex();
      this.changeFocusedOptionIndex(event2, optionIndex);
      !this.overlayVisible && this.show();
      event2.preventDefault();
    },
    onArrowUpKey(event2, pressedInInputText = false) {
      if (event2.altKey && !pressedInInputText) {
        if (this.focusedOptionIndex !== -1) {
          this.onOptionSelect(event2, this.visibleOptions[this.focusedOptionIndex]);
        }
        this.overlayVisible && this.hide();
        event2.preventDefault();
      } else {
        const optionIndex = this.focusedOptionIndex !== -1 ? this.findPrevOptionIndex(this.focusedOptionIndex) : this.findLastFocusedOptionIndex();
        this.changeFocusedOptionIndex(event2, optionIndex);
        !this.overlayVisible && this.show();
        event2.preventDefault();
      }
    },
    onArrowLeftKey(event2, pressedInInputText = false) {
      pressedInInputText && (this.focusedOptionIndex = -1);
    },
    onHomeKey(event2, pressedInInputText = false) {
      if (pressedInInputText) {
        event2.currentTarget.setSelectionRange(0, 0);
        this.focusedOptionIndex = -1;
      } else {
        this.changeFocusedOptionIndex(event2, this.findFirstOptionIndex());
        !this.overlayVisible && this.show();
      }
      event2.preventDefault();
    },
    onEndKey(event2, pressedInInputText = false) {
      if (pressedInInputText) {
        const target = event2.currentTarget;
        const len = target.value.length;
        target.setSelectionRange(len, len);
        this.focusedOptionIndex = -1;
      } else {
        this.changeFocusedOptionIndex(event2, this.findLastOptionIndex());
        !this.overlayVisible && this.show();
      }
      event2.preventDefault();
    },
    onPageUpKey(event2) {
      this.scrollInView(0);
      event2.preventDefault();
    },
    onPageDownKey(event2) {
      this.scrollInView(this.visibleOptions.length - 1);
      event2.preventDefault();
    },
    onEnterKey(event2) {
      if (!this.overlayVisible) {
        this.onArrowDownKey(event2);
      } else {
        if (this.focusedOptionIndex !== -1) {
          this.onOptionSelect(event2, this.visibleOptions[this.focusedOptionIndex]);
        }
        this.hide();
      }
      event2.preventDefault();
    },
    onSpaceKey(event2, pressedInInputText = false) {
      !pressedInInputText && this.onEnterKey(event2);
    },
    onEscapeKey(event2) {
      this.overlayVisible && this.hide(true);
      event2.preventDefault();
    },
    onTabKey(event2, pressedInInputText = false) {
      if (!pressedInInputText) {
        if (this.overlayVisible && this.hasFocusableElements()) {
          DomHandler.focus(this.$refs.firstHiddenFocusableElementOnOverlay);
          event2.preventDefault();
        } else {
          if (this.focusedOptionIndex !== -1) {
            this.onOptionSelect(event2, this.visibleOptions[this.focusedOptionIndex]);
          }
          this.overlayVisible && this.hide(this.filter);
        }
      }
    },
    onBackspaceKey(event2, pressedInInputText = false) {
      if (pressedInInputText) {
        !this.overlayVisible && this.show();
      }
    },
    onOverlayEnter(el) {
      ZIndexUtils.set("overlay", el, this.$primevue.config.zIndex.overlay);
      this.alignOverlay();
      this.scrollInView();
      this.autoFilterFocus && DomHandler.focus(this.$refs.filterInput);
    },
    onOverlayAfterEnter() {
      this.bindOutsideClickListener();
      this.bindScrollListener();
      this.bindResizeListener();
      this.$emit("show");
    },
    onOverlayLeave() {
      this.unbindOutsideClickListener();
      this.unbindScrollListener();
      this.unbindResizeListener();
      this.$emit("hide");
      this.overlay = null;
    },
    onOverlayAfterLeave(el) {
      ZIndexUtils.clear(el);
    },
    alignOverlay() {
      if (this.appendTo === "self") {
        DomHandler.relativePosition(this.overlay, this.$el);
      } else {
        this.overlay.style.minWidth = DomHandler.getOuterWidth(this.$el) + "px";
        DomHandler.absolutePosition(this.overlay, this.$el);
      }
    },
    bindOutsideClickListener() {
      if (!this.outsideClickListener) {
        this.outsideClickListener = (event2) => {
          if (this.overlayVisible && this.overlay && !this.$el.contains(event2.target) && !this.overlay.contains(event2.target)) {
            this.hide();
          }
        };
        document.addEventListener("click", this.outsideClickListener);
      }
    },
    unbindOutsideClickListener() {
      if (this.outsideClickListener) {
        document.removeEventListener("click", this.outsideClickListener);
        this.outsideClickListener = null;
      }
    },
    bindScrollListener() {
      if (!this.scrollHandler) {
        this.scrollHandler = new ConnectedOverlayScrollHandler(this.$refs.container, () => {
          if (this.overlayVisible) {
            this.hide();
          }
        });
      }
      this.scrollHandler.bindScrollListener();
    },
    unbindScrollListener() {
      if (this.scrollHandler) {
        this.scrollHandler.unbindScrollListener();
      }
    },
    bindResizeListener() {
      if (!this.resizeListener) {
        this.resizeListener = () => {
          if (this.overlayVisible && !DomHandler.isTouchDevice()) {
            this.hide();
          }
        };
        window.addEventListener("resize", this.resizeListener);
      }
    },
    unbindResizeListener() {
      if (this.resizeListener) {
        window.removeEventListener("resize", this.resizeListener);
        this.resizeListener = null;
      }
    },
    hasFocusableElements() {
      return DomHandler.getFocusableElements(this.overlay, ":not(.p-hidden-focusable)").length > 0;
    },
    isOptionMatched(option) {
      return this.isValidOption(option) && this.getOptionLabel(option).toLocaleLowerCase(this.filterLocale).startsWith(this.searchValue.toLocaleLowerCase(this.filterLocale));
    },
    isValidOption(option) {
      return option && !(this.isOptionDisabled(option) || this.isOptionGroup(option));
    },
    isValidSelectedOption(option) {
      return this.isValidOption(option) && this.isSelected(option);
    },
    isSelected(option) {
      return this.isValidOption(option) && ObjectUtils.equals(this.modelValue, this.getOptionValue(option), this.equalityKey);
    },
    findFirstOptionIndex() {
      return this.visibleOptions.findIndex((option) => this.isValidOption(option));
    },
    findLastOptionIndex() {
      return ObjectUtils.findLastIndex(this.visibleOptions, (option) => this.isValidOption(option));
    },
    findNextOptionIndex(index) {
      const matchedOptionIndex = index < this.visibleOptions.length - 1 ? this.visibleOptions.slice(index + 1).findIndex((option) => this.isValidOption(option)) : -1;
      return matchedOptionIndex > -1 ? matchedOptionIndex + index + 1 : index;
    },
    findPrevOptionIndex(index) {
      const matchedOptionIndex = index > 0 ? ObjectUtils.findLastIndex(this.visibleOptions.slice(0, index), (option) => this.isValidOption(option)) : -1;
      return matchedOptionIndex > -1 ? matchedOptionIndex : index;
    },
    findSelectedOptionIndex() {
      return this.hasSelectedOption ? this.visibleOptions.findIndex((option) => this.isValidSelectedOption(option)) : -1;
    },
    findFirstFocusedOptionIndex() {
      const selectedIndex = this.findSelectedOptionIndex();
      return selectedIndex < 0 ? this.findFirstOptionIndex() : selectedIndex;
    },
    findLastFocusedOptionIndex() {
      const selectedIndex = this.findSelectedOptionIndex();
      return selectedIndex < 0 ? this.findLastOptionIndex() : selectedIndex;
    },
    searchOptions(event2, char) {
      this.searchValue = (this.searchValue || "") + char;
      let optionIndex = -1;
      let matched = false;
      if (this.focusedOptionIndex !== -1) {
        optionIndex = this.visibleOptions.slice(this.focusedOptionIndex).findIndex((option) => this.isOptionMatched(option));
        optionIndex = optionIndex === -1 ? this.visibleOptions.slice(0, this.focusedOptionIndex).findIndex((option) => this.isOptionMatched(option)) : optionIndex + this.focusedOptionIndex;
      } else {
        optionIndex = this.visibleOptions.findIndex((option) => this.isOptionMatched(option));
      }
      if (optionIndex !== -1) {
        matched = true;
      }
      if (optionIndex === -1 && this.focusedOptionIndex === -1) {
        optionIndex = this.findFirstFocusedOptionIndex();
      }
      if (optionIndex !== -1) {
        this.changeFocusedOptionIndex(event2, optionIndex);
      }
      if (this.searchTimeout) {
        clearTimeout(this.searchTimeout);
      }
      this.searchTimeout = setTimeout(() => {
        this.searchValue = "";
        this.searchTimeout = null;
      }, 500);
      return matched;
    },
    changeFocusedOptionIndex(event2, index) {
      if (this.focusedOptionIndex !== index) {
        this.focusedOptionIndex = index;
        this.scrollInView();
        if (this.selectOnFocus) {
          this.onOptionSelect(event2, this.visibleOptions[index], false);
        }
      }
    },
    scrollInView(index = -1) {
      const id = index !== -1 ? `${this.id}_${index}` : this.focusedOptionId;
      const element = DomHandler.findSingle(this.list, `li[id="${id}"]`);
      if (element) {
        element.scrollIntoView && element.scrollIntoView({ block: "nearest", inline: "start" });
      } else if (!this.virtualScrollerDisabled) {
        setTimeout(() => {
          this.virtualScroller && this.virtualScroller.scrollToIndex(index !== -1 ? index : this.focusedOptionIndex);
        }, 0);
      }
    },
    autoUpdateModel() {
      if (this.selectOnFocus && this.autoOptionFocus && !this.hasSelectedOption) {
        this.focusedOptionIndex = this.findFirstFocusedOptionIndex();
        this.onOptionSelect(null, this.visibleOptions[this.focusedOptionIndex], false);
      }
    },
    updateModel(event2, value) {
      this.$emit("update:modelValue", value);
      this.$emit("change", { originalEvent: event2, value });
    },
    flatOptions(options) {
      return (options || []).reduce((result, option, index) => {
        result.push({ optionGroup: option, group: true, index });
        const optionGroupChildren = this.getOptionGroupChildren(option);
        optionGroupChildren && optionGroupChildren.forEach((o) => result.push(o));
        return result;
      }, []);
    },
    overlayRef(el) {
      this.overlay = el;
    },
    listRef(el, contentRef) {
      this.list = el;
      contentRef && contentRef(el);
    },
    virtualScrollerRef(el) {
      this.virtualScroller = el;
    }
  },
  computed: {
    containerClass() {
      return [
        "p-dropdown p-component p-inputwrapper",
        {
          "p-disabled": this.disabled,
          "p-dropdown-clearable": this.showClear && !this.disabled,
          "p-focus": this.focused,
          "p-inputwrapper-filled": this.hasSelectedOption,
          "p-inputwrapper-focus": this.focused || this.overlayVisible,
          "p-overlay-open": this.overlayVisible
        }
      ];
    },
    inputStyleClass() {
      return [
        "p-dropdown-label p-inputtext",
        this.inputClass,
        {
          "p-placeholder": !this.editable && this.label === this.placeholder,
          "p-dropdown-label-empty": !this.editable && !this.$slots["value"] && (this.label === "p-emptylabel" || this.label.length === 0)
        }
      ];
    },
    panelStyleClass() {
      return [
        "p-dropdown-panel p-component",
        this.panelClass,
        {
          "p-input-filled": this.$primevue.config.inputStyle === "filled",
          "p-ripple-disabled": this.$primevue.config.ripple === false
        }
      ];
    },
    visibleOptions() {
      const options = this.optionGroupLabel ? this.flatOptions(this.options) : this.options || [];
      if (this.filterValue) {
        const filteredOptions = FilterService.filter(options, this.searchFields, this.filterValue, this.filterMatchMode, this.filterLocale);
        if (this.optionGroupLabel) {
          const optionGroups = this.options || [];
          const filtered = [];
          optionGroups.forEach((group) => {
            const groupChildren = this.getOptionGroupChildren(group);
            const filteredItems = groupChildren.filter((item) => filteredOptions.includes(item));
            if (filteredItems.length > 0)
              filtered.push({ ...group, [typeof this.optionGroupChildren === "string" ? this.optionGroupChildren : "items"]: [...filteredItems] });
          });
          return this.flatOptions(filtered);
        }
        return filteredOptions;
      }
      return options;
    },
    hasSelectedOption() {
      return ObjectUtils.isNotEmpty(this.modelValue);
    },
    label() {
      const selectedOptionIndex = this.findSelectedOptionIndex();
      return selectedOptionIndex !== -1 ? this.getOptionLabel(this.visibleOptions[selectedOptionIndex]) : this.placeholder || "p-emptylabel";
    },
    editableInputValue() {
      const selectedOptionIndex = this.findSelectedOptionIndex();
      return selectedOptionIndex !== -1 ? this.getOptionLabel(this.visibleOptions[selectedOptionIndex]) : this.modelValue || "";
    },
    equalityKey() {
      return this.optionValue ? null : this.dataKey;
    },
    searchFields() {
      return this.filterFields || [this.optionLabel];
    },
    filterResultMessageText() {
      return ObjectUtils.isNotEmpty(this.visibleOptions) ? this.filterMessageText.replaceAll("{0}", this.visibleOptions.length) : this.emptyFilterMessageText;
    },
    filterMessageText() {
      return this.filterMessage || this.$primevue.config.locale.searchMessage || "";
    },
    emptyFilterMessageText() {
      return this.emptyFilterMessage || this.$primevue.config.locale.emptySearchMessage || this.$primevue.config.locale.emptyFilterMessage || "";
    },
    emptyMessageText() {
      return this.emptyMessage || this.$primevue.config.locale.emptyMessage || "";
    },
    selectionMessageText() {
      return this.selectionMessage || this.$primevue.config.locale.selectionMessage || "";
    },
    emptySelectionMessageText() {
      return this.emptySelectionMessage || this.$primevue.config.locale.emptySelectionMessage || "";
    },
    selectedMessageText() {
      return this.hasSelectedOption ? this.selectionMessageText.replaceAll("{0}", "1") : this.emptySelectionMessageText;
    },
    focusedOptionId() {
      return this.focusedOptionIndex !== -1 ? `${this.id}_${this.focusedOptionIndex}` : null;
    },
    ariaSetSize() {
      return this.visibleOptions.filter((option) => !this.isOptionGroup(option)).length;
    },
    virtualScrollerDisabled() {
      return !this.virtualScrollerOptions;
    }
  },
  directives: {
    ripple: Ripple
  },
  components: {
    VirtualScroller: script$P,
    Portal: script$Q,
    TimesIcon: script$E,
    ChevronDownIcon: script$S,
    SpinnerIcon: script$U,
    FilterIcon: script$B
  }
};
const _hoisted_1$w = ["id"];
const _hoisted_2$l = ["id", "value", "placeholder", "tabindex", "disabled", "aria-label", "aria-labelledby", "aria-expanded", "aria-controls", "aria-activedescendant"];
const _hoisted_3$f = ["id", "tabindex", "aria-label", "aria-labelledby", "aria-expanded", "aria-controls", "aria-activedescendant", "aria-disabled"];
const _hoisted_4$3 = ["value", "placeholder", "aria-owns", "aria-activedescendant"];
const _hoisted_5$1 = ["id"];
const _hoisted_6$1 = ["id"];
const _hoisted_7$1 = ["id", "aria-label", "aria-selected", "aria-disabled", "aria-setsize", "aria-posinset", "onClick", "onMousemove"];
function render$A(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_SpinnerIcon = resolveComponent("SpinnerIcon");
  const _component_VirtualScroller = resolveComponent("VirtualScroller");
  const _component_Portal = resolveComponent("Portal");
  const _directive_ripple = resolveDirective("ripple");
  return openBlock(), createElementBlock("div", mergeProps({
    ref: "container",
    id: $data.id,
    class: $options.containerClass,
    onClick: _cache[15] || (_cache[15] = (...args) => $options.onContainerClick && $options.onContainerClick(...args))
  }, _ctx.ptm("root")), [
    $props.editable ? (openBlock(), createElementBlock("input", mergeProps({
      key: 0,
      ref: "focusInput",
      id: $props.inputId,
      type: "text",
      style: $props.inputStyle,
      class: $options.inputStyleClass,
      value: $options.editableInputValue,
      placeholder: $props.placeholder,
      tabindex: !$props.disabled ? $props.tabindex : -1,
      disabled: $props.disabled,
      autocomplete: "off",
      role: "combobox",
      "aria-label": _ctx.ariaLabel,
      "aria-labelledby": _ctx.ariaLabelledby,
      "aria-haspopup": "listbox",
      "aria-expanded": $data.overlayVisible,
      "aria-controls": $data.id + "_list",
      "aria-activedescendant": $data.focused ? $options.focusedOptionId : void 0,
      onFocus: _cache[0] || (_cache[0] = (...args) => $options.onFocus && $options.onFocus(...args)),
      onBlur: _cache[1] || (_cache[1] = (...args) => $options.onBlur && $options.onBlur(...args)),
      onKeydown: _cache[2] || (_cache[2] = (...args) => $options.onKeyDown && $options.onKeyDown(...args)),
      onInput: _cache[3] || (_cache[3] = (...args) => $options.onEditableInput && $options.onEditableInput(...args))
    }, { ...$props.inputProps, ..._ctx.ptm("input") }), null, 16, _hoisted_2$l)) : (openBlock(), createElementBlock("span", mergeProps({
      key: 1,
      ref: "focusInput",
      id: $props.inputId,
      style: $props.inputStyle,
      class: $options.inputStyleClass,
      tabindex: !$props.disabled ? $props.tabindex : -1,
      role: "combobox",
      "aria-label": _ctx.ariaLabel || ($options.label === "p-emptylabel" ? void 0 : $options.label),
      "aria-labelledby": _ctx.ariaLabelledby,
      "aria-haspopup": "listbox",
      "aria-expanded": $data.overlayVisible,
      "aria-controls": $data.id + "_list",
      "aria-activedescendant": $data.focused ? $options.focusedOptionId : void 0,
      "aria-disabled": $props.disabled,
      onFocus: _cache[4] || (_cache[4] = (...args) => $options.onFocus && $options.onFocus(...args)),
      onBlur: _cache[5] || (_cache[5] = (...args) => $options.onBlur && $options.onBlur(...args)),
      onKeydown: _cache[6] || (_cache[6] = (...args) => $options.onKeyDown && $options.onKeyDown(...args))
    }, { ...$props.inputProps, ..._ctx.ptm("input") }), [
      renderSlot(_ctx.$slots, "value", {
        value: $props.modelValue,
        placeholder: $props.placeholder
      }, () => [
        createTextVNode(toDisplayString($options.label === "p-emptylabel" ? " " : $options.label || "empty"), 1)
      ])
    ], 16, _hoisted_3$f)),
    $props.showClear && $props.modelValue != null ? renderSlot(_ctx.$slots, "clearicon", {
      key: 2,
      onClick: $options.onClearClick
    }, () => [
      (openBlock(), createBlock(resolveDynamicComponent($props.clearIcon ? "i" : "TimesIcon"), mergeProps({
        class: ["p-dropdown-clear-icon", $props.clearIcon],
        onClick: $options.onClearClick
      }, { ...$props.clearIconProps, ..._ctx.ptm("clearIcon") }), null, 16, ["class", "onClick"]))
    ]) : createCommentVNode("", true),
    createElementVNode("div", mergeProps({ class: "p-dropdown-trigger" }, _ctx.ptm("trigger")), [
      $props.loading ? renderSlot(_ctx.$slots, "loadingicon", {
        key: 0,
        class: "p-dropdown-trigger-icon"
      }, () => [
        $props.loadingIcon ? (openBlock(), createElementBlock("span", mergeProps({
          key: 0,
          class: ["p-dropdown-trigger-icon pi-spin", $props.loadingIcon],
          "aria-hidden": "true"
        }, _ctx.ptm("loadingIcon")), null, 16)) : (openBlock(), createBlock(_component_SpinnerIcon, mergeProps({
          key: 1,
          class: "p-dropdown-trigger-icon",
          spin: "",
          "aria-hidden": "true"
        }, _ctx.ptm("loadingIcon")), null, 16))
      ]) : renderSlot(_ctx.$slots, "dropdownicon", {
        key: 1,
        class: "p-dropdown-trigger-icon"
      }, () => [
        (openBlock(), createBlock(resolveDynamicComponent($props.dropdownIcon ? "span" : "ChevronDownIcon"), mergeProps({
          class: ["p-dropdown-trigger-icon", $props.dropdownIcon],
          "aria-hidden": "true"
        }, _ctx.ptm("dropdownIcon")), null, 16, ["class"]))
      ])
    ], 16),
    createVNode(_component_Portal, { appendTo: $props.appendTo }, {
      default: withCtx(() => [
        createVNode(Transition, {
          name: "p-connected-overlay",
          onEnter: $options.onOverlayEnter,
          onAfterEnter: $options.onOverlayAfterEnter,
          onLeave: $options.onOverlayLeave,
          onAfterLeave: $options.onOverlayAfterLeave
        }, {
          default: withCtx(() => [
            $data.overlayVisible ? (openBlock(), createElementBlock("div", mergeProps({
              key: 0,
              ref: $options.overlayRef,
              style: $props.panelStyle,
              class: $options.panelStyleClass,
              onClick: _cache[13] || (_cache[13] = (...args) => $options.onOverlayClick && $options.onOverlayClick(...args)),
              onKeydown: _cache[14] || (_cache[14] = (...args) => $options.onOverlayKeyDown && $options.onOverlayKeyDown(...args))
            }, { ...$props.panelProps, ..._ctx.ptm("panel") }), [
              createElementVNode("span", mergeProps({
                ref: "firstHiddenFocusableElementOnOverlay",
                role: "presentation",
                "aria-hidden": "true",
                class: "p-hidden-accessible p-hidden-focusable",
                tabindex: 0,
                onFocus: _cache[7] || (_cache[7] = (...args) => $options.onFirstHiddenFocus && $options.onFirstHiddenFocus(...args))
              }, _ctx.ptm("hiddenFirstFocusableEl")), null, 16),
              renderSlot(_ctx.$slots, "header", {
                value: $props.modelValue,
                options: $options.visibleOptions
              }),
              $props.filter ? (openBlock(), createElementBlock("div", mergeProps({
                key: 0,
                class: "p-dropdown-header"
              }, _ctx.ptm("header")), [
                createElementVNode("div", mergeProps({ class: "p-dropdown-filter-container" }, _ctx.ptm("filterContainer")), [
                  createElementVNode("input", mergeProps({
                    ref: "filterInput",
                    type: "text",
                    value: $data.filterValue,
                    onVnodeMounted: _cache[8] || (_cache[8] = (...args) => $options.onFilterUpdated && $options.onFilterUpdated(...args)),
                    class: "p-dropdown-filter p-inputtext p-component",
                    placeholder: $props.filterPlaceholder,
                    role: "searchbox",
                    autocomplete: "off",
                    "aria-owns": $data.id + "_list",
                    "aria-activedescendant": $options.focusedOptionId,
                    onKeydown: _cache[9] || (_cache[9] = (...args) => $options.onFilterKeyDown && $options.onFilterKeyDown(...args)),
                    onBlur: _cache[10] || (_cache[10] = (...args) => $options.onFilterBlur && $options.onFilterBlur(...args)),
                    onInput: _cache[11] || (_cache[11] = (...args) => $options.onFilterChange && $options.onFilterChange(...args))
                  }, { ...$props.filterInputProps, ..._ctx.ptm("filterInput") }), null, 16, _hoisted_4$3),
                  renderSlot(_ctx.$slots, "filtericon", {}, () => [
                    (openBlock(), createBlock(resolveDynamicComponent($props.filterIcon ? "span" : "FilterIcon"), mergeProps({
                      class: ["p-dropdown-filter-icon", $props.filterIcon]
                    }, _ctx.ptm("filterIcon")), null, 16, ["class"]))
                  ])
                ], 16),
                createElementVNode("span", mergeProps({
                  role: "status",
                  "aria-live": "polite",
                  class: "p-hidden-accessible"
                }, _ctx.ptm("hiddenFilterResult")), toDisplayString($options.filterResultMessageText), 17)
              ], 16)) : createCommentVNode("", true),
              createElementVNode("div", mergeProps({
                class: "p-dropdown-items-wrapper",
                style: { "max-height": $options.virtualScrollerDisabled ? $props.scrollHeight : "" }
              }, _ctx.ptm("wrapper")), [
                createVNode(_component_VirtualScroller, mergeProps({ ref: $options.virtualScrollerRef }, { ...$props.virtualScrollerOptions, ..._ctx.ptm("virtualScroller") }, {
                  items: $options.visibleOptions,
                  style: { height: $props.scrollHeight },
                  tabindex: -1,
                  disabled: $options.virtualScrollerDisabled
                }), createSlots({
                  content: withCtx(({ styleClass, contentRef, items, getItemOptions, contentStyle, itemSize }) => [
                    createElementVNode("ul", mergeProps({
                      ref: (el) => $options.listRef(el, contentRef),
                      id: $data.id + "_list",
                      class: ["p-dropdown-items", styleClass],
                      style: contentStyle,
                      role: "listbox"
                    }, _ctx.ptm("list")), [
                      (openBlock(true), createElementBlock(Fragment, null, renderList(items, (option, i) => {
                        return openBlock(), createElementBlock(Fragment, {
                          key: $options.getOptionRenderKey(option, $options.getOptionIndex(i, getItemOptions))
                        }, [
                          $options.isOptionGroup(option) ? (openBlock(), createElementBlock("li", mergeProps({
                            key: 0,
                            id: $data.id + "_" + $options.getOptionIndex(i, getItemOptions),
                            style: { height: itemSize ? itemSize + "px" : void 0 },
                            class: "p-dropdown-item-group",
                            role: "option"
                          }, _ctx.ptm("itemGroup")), [
                            renderSlot(_ctx.$slots, "optiongroup", {
                              option: option.optionGroup,
                              index: $options.getOptionIndex(i, getItemOptions)
                            }, () => [
                              createTextVNode(toDisplayString($options.getOptionGroupLabel(option.optionGroup)), 1)
                            ])
                          ], 16, _hoisted_6$1)) : withDirectives((openBlock(), createElementBlock("li", mergeProps({
                            key: 1,
                            id: $data.id + "_" + $options.getOptionIndex(i, getItemOptions),
                            style: { height: itemSize ? itemSize + "px" : void 0 },
                            class: ["p-dropdown-item", { "p-highlight": $options.isSelected(option), "p-focus": $data.focusedOptionIndex === $options.getOptionIndex(i, getItemOptions), "p-disabled": $options.isOptionDisabled(option) }],
                            role: "option",
                            "aria-label": $options.getOptionLabel(option),
                            "aria-selected": $options.isSelected(option),
                            "aria-disabled": $options.isOptionDisabled(option),
                            "aria-setsize": $options.ariaSetSize,
                            "aria-posinset": $options.getAriaPosInset($options.getOptionIndex(i, getItemOptions)),
                            onClick: ($event) => $options.onOptionSelect($event, option),
                            onMousemove: ($event) => $options.onOptionMouseMove($event, $options.getOptionIndex(i, getItemOptions))
                          }, $options.getPTOptions(option, getItemOptions, i, "item")), [
                            renderSlot(_ctx.$slots, "option", {
                              option,
                              index: $options.getOptionIndex(i, getItemOptions)
                            }, () => [
                              createTextVNode(toDisplayString($options.getOptionLabel(option)), 1)
                            ])
                          ], 16, _hoisted_7$1)), [
                            [_directive_ripple]
                          ])
                        ], 64);
                      }), 128)),
                      $data.filterValue && (!items || items && items.length === 0) ? (openBlock(), createElementBlock("li", mergeProps({
                        key: 0,
                        class: "p-dropdown-empty-message",
                        role: "option"
                      }, _ctx.ptm("emptyMessage")), [
                        renderSlot(_ctx.$slots, "emptyfilter", {}, () => [
                          createTextVNode(toDisplayString($options.emptyFilterMessageText), 1)
                        ])
                      ], 16)) : !$props.options || $props.options && $props.options.length === 0 ? (openBlock(), createElementBlock("li", mergeProps({
                        key: 1,
                        class: "p-dropdown-empty-message",
                        role: "option"
                      }, _ctx.ptm("emptyMessage")), [
                        renderSlot(_ctx.$slots, "empty", {}, () => [
                          createTextVNode(toDisplayString($options.emptyMessageText), 1)
                        ])
                      ], 16)) : createCommentVNode("", true)
                    ], 16, _hoisted_5$1)
                  ]),
                  _: 2
                }, [
                  _ctx.$slots.loader ? {
                    name: "loader",
                    fn: withCtx(({ options }) => [
                      renderSlot(_ctx.$slots, "loader", { options })
                    ]),
                    key: "0"
                  } : void 0
                ]), 1040, ["items", "style", "disabled"])
              ], 16),
              renderSlot(_ctx.$slots, "footer", {
                value: $props.modelValue,
                options: $options.visibleOptions
              }),
              !$props.options || $props.options && $props.options.length === 0 ? (openBlock(), createElementBlock("span", mergeProps({
                key: 1,
                role: "status",
                "aria-live": "polite",
                class: "p-hidden-accessible"
              }, _ctx.ptm("emptyMessage")), toDisplayString($options.emptyMessageText), 17)) : createCommentVNode("", true),
              createElementVNode("span", mergeProps({
                role: "status",
                "aria-live": "polite",
                class: "p-hidden-accessible"
              }, _ctx.ptm("hiddenSelectedMessage")), toDisplayString($options.selectedMessageText), 17),
              createElementVNode("span", mergeProps({
                ref: "lastHiddenFocusableElementOnOverlay",
                role: "presentation",
                "aria-hidden": "true",
                class: "p-hidden-accessible p-hidden-focusable",
                tabindex: 0,
                onFocus: _cache[12] || (_cache[12] = (...args) => $options.onLastHiddenFocus && $options.onLastHiddenFocus(...args))
              }, _ctx.ptm("hiddenLastFocusableEl")), null, 16)
            ], 16)) : createCommentVNode("", true)
          ]),
          _: 3
        }, 8, ["onEnter", "onAfterEnter", "onLeave", "onAfterLeave"])
      ]),
      _: 3
    }, 8, ["appendTo"])
  ], 16, _hoisted_1$w);
}
function styleInject$b(css, ref2) {
  if (ref2 === void 0)
    ref2 = {};
  var insertAt = ref2.insertAt;
  if (!css || true) {
    return;
  }
  var head = document.head || document.getElementsByTagName("head")[0];
  var style = document.createElement("style");
  style.type = "text/css";
  if (insertAt === "top") {
    if (head.firstChild) {
      head.insertBefore(style, head.firstChild);
    } else {
      head.appendChild(style);
    }
  } else {
    head.appendChild(style);
  }
  if (style.styleSheet) {
    style.styleSheet.cssText = css;
  } else {
    style.appendChild(document.createTextNode(css));
  }
}
var css_248z$b = "\n.p-dropdown {\n    display: inline-flex;\n    cursor: pointer;\n    position: relative;\n    user-select: none;\n}\n.p-dropdown-clear-icon {\n    position: absolute;\n    top: 50%;\n    margin-top: -0.5rem;\n}\n.p-dropdown-trigger {\n    display: flex;\n    align-items: center;\n    justify-content: center;\n    flex-shrink: 0;\n}\n.p-dropdown-label {\n    display: block;\n    white-space: nowrap;\n    overflow: hidden;\n    flex: 1 1 auto;\n    width: 1%;\n    text-overflow: ellipsis;\n    cursor: pointer;\n}\n.p-dropdown-label-empty {\n    overflow: hidden;\n    opacity: 0;\n}\ninput.p-dropdown-label {\n    cursor: default;\n}\n.p-dropdown .p-dropdown-panel {\n    min-width: 100%;\n}\n.p-dropdown-panel {\n    position: absolute;\n    top: 0;\n    left: 0;\n}\n.p-dropdown-items-wrapper {\n    overflow: auto;\n}\n.p-dropdown-item {\n    cursor: pointer;\n    font-weight: normal;\n    white-space: nowrap;\n    position: relative;\n    overflow: hidden;\n}\n.p-dropdown-item-group {\n    cursor: auto;\n}\n.p-dropdown-items {\n    margin: 0;\n    padding: 0;\n    list-style-type: none;\n}\n.p-dropdown-filter {\n    width: 100%;\n}\n.p-dropdown-filter-container {\n    position: relative;\n}\n.p-dropdown-filter-icon {\n    position: absolute;\n    top: 50%;\n    margin-top: -0.5rem;\n}\n.p-fluid .p-dropdown {\n    display: flex;\n}\n.p-fluid .p-dropdown .p-dropdown-label {\n    width: 1%;\n}\n";
styleInject$b(css_248z$b);
script$A.render = render$A;
var script$z = {
  name: "ProgressBar",
  extends: script$W,
  props: {
    value: {
      type: Number,
      default: null
    },
    mode: {
      type: String,
      default: "determinate"
    },
    showValue: {
      type: Boolean,
      default: true
    }
  },
  computed: {
    containerClass() {
      return [
        "p-progressbar p-component",
        {
          "p-progressbar-determinate": this.determinate,
          "p-progressbar-indeterminate": this.indeterminate
        }
      ];
    },
    progressStyle() {
      return {
        width: this.value + "%",
        display: "flex"
      };
    },
    indeterminate() {
      return this.mode === "indeterminate";
    },
    determinate() {
      return this.mode === "determinate";
    }
  }
};
const _hoisted_1$v = ["aria-valuenow"];
function render$z(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("div", mergeProps({
    role: "progressbar",
    class: $options.containerClass,
    "aria-valuemin": "0",
    "aria-valuenow": $props.value,
    "aria-valuemax": "100"
  }, _ctx.ptm("root")), [
    $options.determinate ? (openBlock(), createElementBlock("div", mergeProps({
      key: 0,
      class: "p-progressbar-value p-progressbar-value-animate",
      style: $options.progressStyle
    }, _ctx.ptm("value")), [
      $props.value != null && $props.value !== 0 && $props.showValue ? (openBlock(), createElementBlock("div", mergeProps({
        key: 0,
        class: "p-progressbar-label"
      }, _ctx.ptm("label")), [
        renderSlot(_ctx.$slots, "default", {}, () => [
          createTextVNode(toDisplayString($props.value + "%"), 1)
        ])
      ], 16)) : createCommentVNode("", true)
    ], 16)) : createCommentVNode("", true),
    $options.indeterminate ? (openBlock(), createElementBlock("div", mergeProps({
      key: 1,
      class: "p-progressbar-indeterminate-container"
    }, _ctx.ptm("root")), [
      createElementVNode("div", mergeProps({ class: "p-progressbar-value p-progressbar-value-animate" }, _ctx.ptm("value")), null, 16)
    ], 16)) : createCommentVNode("", true)
  ], 16, _hoisted_1$v);
}
function styleInject$a(css, ref2) {
  if (ref2 === void 0)
    ref2 = {};
  var insertAt = ref2.insertAt;
  if (!css || true) {
    return;
  }
  var head = document.head || document.getElementsByTagName("head")[0];
  var style = document.createElement("style");
  style.type = "text/css";
  if (insertAt === "top") {
    if (head.firstChild) {
      head.insertBefore(style, head.firstChild);
    } else {
      head.appendChild(style);
    }
  } else {
    head.appendChild(style);
  }
  if (style.styleSheet) {
    style.styleSheet.cssText = css;
  } else {
    style.appendChild(document.createTextNode(css));
  }
}
var css_248z$a = "\n.p-progressbar {\n    position: relative;\n    overflow: hidden;\n}\n.p-progressbar-determinate .p-progressbar-value {\n    height: 100%;\n    width: 0%;\n    position: absolute;\n    display: none;\n    border: 0 none;\n    display: flex;\n    align-items: center;\n    justify-content: center;\n    overflow: hidden;\n}\n.p-progressbar-determinate .p-progressbar-label {\n    display: inline-flex;\n}\n.p-progressbar-determinate .p-progressbar-value-animate {\n    transition: width 1s ease-in-out;\n}\n.p-progressbar-indeterminate .p-progressbar-value::before {\n    content: '';\n    position: absolute;\n    background-color: inherit;\n    top: 0;\n    left: 0;\n    bottom: 0;\n    will-change: left, right;\n    -webkit-animation: p-progressbar-indeterminate-anim 2.1s cubic-bezier(0.65, 0.815, 0.735, 0.395) infinite;\n    animation: p-progressbar-indeterminate-anim 2.1s cubic-bezier(0.65, 0.815, 0.735, 0.395) infinite;\n}\n.p-progressbar-indeterminate .p-progressbar-value::after {\n    content: '';\n    position: absolute;\n    background-color: inherit;\n    top: 0;\n    left: 0;\n    bottom: 0;\n    will-change: left, right;\n    -webkit-animation: p-progressbar-indeterminate-anim-short 2.1s cubic-bezier(0.165, 0.84, 0.44, 1) infinite;\n    animation: p-progressbar-indeterminate-anim-short 2.1s cubic-bezier(0.165, 0.84, 0.44, 1) infinite;\n    -webkit-animation-delay: 1.15s;\n    animation-delay: 1.15s;\n}\n@-webkit-keyframes p-progressbar-indeterminate-anim {\n0% {\n        left: -35%;\n        right: 100%;\n}\n60% {\n        left: 100%;\n        right: -90%;\n}\n100% {\n        left: 100%;\n        right: -90%;\n}\n}\n@keyframes p-progressbar-indeterminate-anim {\n0% {\n        left: -35%;\n        right: 100%;\n}\n60% {\n        left: 100%;\n        right: -90%;\n}\n100% {\n        left: 100%;\n        right: -90%;\n}\n}\n@-webkit-keyframes p-progressbar-indeterminate-anim-short {\n0% {\n        left: -200%;\n        right: 100%;\n}\n60% {\n        left: 107%;\n        right: -8%;\n}\n100% {\n        left: 107%;\n        right: -8%;\n}\n}\n@keyframes p-progressbar-indeterminate-anim-short {\n0% {\n        left: -200%;\n        right: 100%;\n}\n60% {\n        left: 107%;\n        right: -8%;\n}\n100% {\n        left: 107%;\n        right: -8%;\n}\n}\n";
styleInject$a(css_248z$a);
script$z.render = render$z;
var script$y = {
  name: "Slider",
  extends: script$W,
  emits: ["update:modelValue", "change", "slideend"],
  props: {
    modelValue: [Number, Array],
    min: {
      type: Number,
      default: 0
    },
    max: {
      type: Number,
      default: 100
    },
    orientation: {
      type: String,
      default: "horizontal"
    },
    step: {
      type: Number,
      default: null
    },
    range: {
      type: Boolean,
      default: false
    },
    disabled: {
      type: Boolean,
      default: false
    },
    tabindex: {
      type: Number,
      default: 0
    },
    "aria-labelledby": {
      type: String,
      default: null
    },
    "aria-label": {
      type: String,
      default: null
    }
  },
  dragging: false,
  handleIndex: null,
  initX: null,
  initY: null,
  barWidth: null,
  barHeight: null,
  dragListener: null,
  dragEndListener: null,
  beforeUnmount() {
    this.unbindDragListeners();
  },
  methods: {
    updateDomData() {
      let rect = this.$el.getBoundingClientRect();
      this.initX = rect.left + DomHandler.getWindowScrollLeft();
      this.initY = rect.top + DomHandler.getWindowScrollTop();
      this.barWidth = this.$el.offsetWidth;
      this.barHeight = this.$el.offsetHeight;
    },
    setValue(event2) {
      let handleValue;
      let pageX = event2.touches ? event2.touches[0].pageX : event2.pageX;
      let pageY = event2.touches ? event2.touches[0].pageY : event2.pageY;
      if (this.orientation === "horizontal")
        handleValue = (pageX - this.initX) * 100 / this.barWidth;
      else
        handleValue = (this.initY + this.barHeight - pageY) * 100 / this.barHeight;
      let newValue = (this.max - this.min) * (handleValue / 100) + this.min;
      if (this.step) {
        const oldValue = this.range ? this.modelValue[this.handleIndex] : this.modelValue;
        const diff = newValue - oldValue;
        if (diff < 0)
          newValue = oldValue + Math.ceil(newValue / this.step - oldValue / this.step) * this.step;
        else if (diff > 0)
          newValue = oldValue + Math.floor(newValue / this.step - oldValue / this.step) * this.step;
      } else {
        newValue = Math.floor(newValue);
      }
      this.updateModel(event2, newValue);
    },
    updateModel(event2, value) {
      let newValue = parseFloat(value.toFixed(10));
      let modelValue;
      if (this.range) {
        modelValue = this.modelValue ? [...this.modelValue] : [];
        if (this.handleIndex == 0) {
          if (newValue < this.min)
            newValue = this.min;
          else if (newValue >= this.max)
            newValue = this.max;
          modelValue[0] = newValue;
        } else {
          if (newValue > this.max)
            newValue = this.max;
          else if (newValue <= this.min)
            newValue = this.min;
          modelValue[1] = newValue;
        }
      } else {
        if (newValue < this.min)
          newValue = this.min;
        else if (newValue > this.max)
          newValue = this.max;
        modelValue = newValue;
      }
      this.$emit("update:modelValue", modelValue);
      this.$emit("change", modelValue);
    },
    onDragStart(event2, index) {
      if (this.disabled) {
        return;
      }
      DomHandler.addClass(this.$el, "p-slider-sliding");
      this.dragging = true;
      this.updateDomData();
      if (this.range && this.modelValue[0] === this.max) {
        this.handleIndex = 0;
      } else {
        this.handleIndex = index;
      }
      event2.currentTarget.focus();
      event2.preventDefault();
    },
    onDrag(event2) {
      if (this.dragging) {
        this.setValue(event2);
        event2.preventDefault();
      }
    },
    onDragEnd(event2) {
      if (this.dragging) {
        this.dragging = false;
        DomHandler.removeClass(this.$el, "p-slider-sliding");
        this.$emit("slideend", { originalEvent: event2, value: this.modelValue });
      }
    },
    onBarClick(event2) {
      if (this.disabled) {
        return;
      }
      if (!DomHandler.hasClass(event2.target, "p-slider-handle")) {
        this.updateDomData();
        this.setValue(event2);
      }
    },
    onMouseDown(event2, index) {
      this.bindDragListeners();
      this.onDragStart(event2, index);
    },
    onKeyDown(event2, index) {
      this.handleIndex = index;
      switch (event2.code) {
        case "ArrowDown":
        case "ArrowLeft":
          this.decrementValue(event2, index);
          event2.preventDefault();
          break;
        case "ArrowUp":
        case "ArrowRight":
          this.incrementValue(event2, index);
          event2.preventDefault();
          break;
        case "PageDown":
          this.decrementValue(event2, index, true);
          event2.preventDefault();
          break;
        case "PageUp":
          this.incrementValue(event2, index, true);
          event2.preventDefault();
          break;
        case "Home":
          this.updateModel(event2, this.min);
          event2.preventDefault();
          break;
        case "End":
          this.updateModel(event2, this.max);
          event2.preventDefault();
          break;
      }
    },
    decrementValue(event2, index, pageKey = false) {
      let newValue;
      if (this.range) {
        if (this.step)
          newValue = this.modelValue[index] - this.step;
        else
          newValue = this.modelValue[index] - 1;
      } else {
        if (this.step)
          newValue = this.modelValue - this.step;
        else if (!this.step && pageKey)
          newValue = this.modelValue - 10;
        else
          newValue = this.modelValue - 1;
      }
      this.updateModel(event2, newValue);
      event2.preventDefault();
    },
    incrementValue(event2, index, pageKey = false) {
      let newValue;
      if (this.range) {
        if (this.step)
          newValue = this.modelValue[index] + this.step;
        else
          newValue = this.modelValue[index] + 1;
      } else {
        if (this.step)
          newValue = this.modelValue + this.step;
        else if (!this.step && pageKey)
          newValue = this.modelValue + 10;
        else
          newValue = this.modelValue + 1;
      }
      this.updateModel(event2, newValue);
      event2.preventDefault();
    },
    bindDragListeners() {
      if (!this.dragListener) {
        this.dragListener = this.onDrag.bind(this);
        document.addEventListener("mousemove", this.dragListener);
      }
      if (!this.dragEndListener) {
        this.dragEndListener = this.onDragEnd.bind(this);
        document.addEventListener("mouseup", this.dragEndListener);
      }
    },
    unbindDragListeners() {
      if (this.dragListener) {
        document.removeEventListener("mousemove", this.dragListener);
        this.dragListener = null;
      }
      if (this.dragEndListener) {
        document.removeEventListener("mouseup", this.dragEndListener);
        this.dragEndListener = null;
      }
    }
  },
  computed: {
    containerClass() {
      return [
        "p-slider p-component",
        {
          "p-disabled": this.disabled,
          "p-slider-horizontal": this.orientation === "horizontal",
          "p-slider-vertical": this.orientation === "vertical"
        }
      ];
    },
    horizontal() {
      return this.orientation === "horizontal";
    },
    vertical() {
      return this.orientation === "vertical";
    },
    rangeStyle() {
      if (this.range) {
        const rangeSliderWidth = this.rangeEndPosition > this.rangeStartPosition ? this.rangeEndPosition - this.rangeStartPosition : this.rangeStartPosition - this.rangeEndPosition;
        const rangeSliderPosition = this.rangeEndPosition > this.rangeStartPosition ? this.rangeStartPosition : this.rangeEndPosition;
        if (this.horizontal)
          return { left: rangeSliderPosition + "%", width: rangeSliderWidth + "%" };
        else
          return { bottom: rangeSliderPosition + "%", height: rangeSliderWidth + "%" };
      } else {
        if (this.horizontal)
          return { width: this.handlePosition + "%" };
        else
          return { height: this.handlePosition + "%" };
      }
    },
    handleStyle() {
      if (this.horizontal)
        return { left: this.handlePosition + "%" };
      else
        return { bottom: this.handlePosition + "%" };
    },
    handlePosition() {
      if (this.modelValue < this.min)
        return 0;
      else if (this.modelValue > this.max)
        return 100;
      else
        return (this.modelValue - this.min) * 100 / (this.max - this.min);
    },
    rangeStartPosition() {
      if (this.modelValue && this.modelValue[0])
        return (this.modelValue[0] < this.min ? 0 : this.modelValue[0] - this.min) * 100 / (this.max - this.min);
      else
        return 0;
    },
    rangeEndPosition() {
      if (this.modelValue && this.modelValue.length === 2)
        return (this.modelValue[1] > this.max ? 100 : this.modelValue[1] - this.min) * 100 / (this.max - this.min);
      else
        return 100;
    },
    rangeStartHandleStyle() {
      if (this.horizontal)
        return { left: this.rangeStartPosition + "%" };
      else
        return { bottom: this.rangeStartPosition + "%" };
    },
    rangeEndHandleStyle() {
      if (this.horizontal)
        return { left: this.rangeEndPosition + "%" };
      else
        return { bottom: this.rangeEndPosition + "%" };
    }
  }
};
const _hoisted_1$u = ["tabindex", "aria-valuemin", "aria-valuenow", "aria-valuemax", "aria-labelledby", "aria-label", "aria-orientation"];
const _hoisted_2$k = ["tabindex", "aria-valuemin", "aria-valuenow", "aria-valuemax", "aria-labelledby", "aria-label", "aria-orientation"];
const _hoisted_3$e = ["tabindex", "aria-valuemin", "aria-valuenow", "aria-valuemax", "aria-labelledby", "aria-label", "aria-orientation"];
function render$y(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("div", mergeProps({
    class: $options.containerClass,
    onClick: _cache[15] || (_cache[15] = (...args) => $options.onBarClick && $options.onBarClick(...args))
  }, _ctx.ptm("root")), [
    createElementVNode("span", mergeProps({
      class: "p-slider-range",
      style: $options.rangeStyle
    }, _ctx.ptm("range")), null, 16),
    !$props.range ? (openBlock(), createElementBlock("span", mergeProps({
      key: 0,
      class: "p-slider-handle",
      style: $options.handleStyle,
      onTouchstart: _cache[0] || (_cache[0] = ($event) => $options.onDragStart($event)),
      onTouchmove: _cache[1] || (_cache[1] = ($event) => $options.onDrag($event)),
      onTouchend: _cache[2] || (_cache[2] = ($event) => $options.onDragEnd($event)),
      onMousedown: _cache[3] || (_cache[3] = ($event) => $options.onMouseDown($event)),
      onKeydown: _cache[4] || (_cache[4] = ($event) => $options.onKeyDown($event)),
      tabindex: $props.tabindex,
      role: "slider",
      "aria-valuemin": $props.min,
      "aria-valuenow": $props.modelValue,
      "aria-valuemax": $props.max,
      "aria-labelledby": _ctx.ariaLabelledby,
      "aria-label": _ctx.ariaLabel,
      "aria-orientation": $props.orientation
    }, _ctx.ptm("handle")), null, 16, _hoisted_1$u)) : createCommentVNode("", true),
    $props.range ? (openBlock(), createElementBlock("span", mergeProps({
      key: 1,
      class: "p-slider-handle",
      style: $options.rangeStartHandleStyle,
      onTouchstart: _cache[5] || (_cache[5] = ($event) => $options.onDragStart($event, 0)),
      onTouchmove: _cache[6] || (_cache[6] = ($event) => $options.onDrag($event)),
      onTouchend: _cache[7] || (_cache[7] = ($event) => $options.onDragEnd($event)),
      onMousedown: _cache[8] || (_cache[8] = ($event) => $options.onMouseDown($event, 0)),
      onKeydown: _cache[9] || (_cache[9] = ($event) => $options.onKeyDown($event, 0)),
      tabindex: $props.tabindex,
      role: "slider",
      "aria-valuemin": $props.min,
      "aria-valuenow": $props.modelValue ? $props.modelValue[0] : null,
      "aria-valuemax": $props.max,
      "aria-labelledby": _ctx.ariaLabelledby,
      "aria-label": _ctx.ariaLabel,
      "aria-orientation": $props.orientation
    }, _ctx.ptm("startHandler")), null, 16, _hoisted_2$k)) : createCommentVNode("", true),
    $props.range ? (openBlock(), createElementBlock("span", mergeProps({
      key: 2,
      class: "p-slider-handle",
      style: $options.rangeEndHandleStyle,
      onTouchstart: _cache[10] || (_cache[10] = ($event) => $options.onDragStart($event, 1)),
      onTouchmove: _cache[11] || (_cache[11] = ($event) => $options.onDrag($event)),
      onTouchend: _cache[12] || (_cache[12] = ($event) => $options.onDragEnd($event)),
      onMousedown: _cache[13] || (_cache[13] = ($event) => $options.onMouseDown($event, 1)),
      onKeydown: _cache[14] || (_cache[14] = ($event) => $options.onKeyDown($event, 1)),
      tabindex: $props.tabindex,
      role: "slider",
      "aria-valuemin": $props.min,
      "aria-valuenow": $props.modelValue ? $props.modelValue[1] : null,
      "aria-valuemax": $props.max,
      "aria-labelledby": _ctx.ariaLabelledby,
      "aria-label": _ctx.ariaLabel,
      "aria-orientation": $props.orientation
    }, _ctx.ptm("endHandler")), null, 16, _hoisted_3$e)) : createCommentVNode("", true)
  ], 16);
}
function styleInject$9(css, ref2) {
  if (ref2 === void 0)
    ref2 = {};
  var insertAt = ref2.insertAt;
  if (!css || true) {
    return;
  }
  var head = document.head || document.getElementsByTagName("head")[0];
  var style = document.createElement("style");
  style.type = "text/css";
  if (insertAt === "top") {
    if (head.firstChild) {
      head.insertBefore(style, head.firstChild);
    } else {
      head.appendChild(style);
    }
  } else {
    head.appendChild(style);
  }
  if (style.styleSheet) {
    style.styleSheet.cssText = css;
  } else {
    style.appendChild(document.createTextNode(css));
  }
}
var css_248z$9 = "\n.p-slider {\n    position: relative;\n}\n.p-slider .p-slider-handle {\n    position: absolute;\n    cursor: grab;\n    touch-action: none;\n    display: block;\n}\n.p-slider-range {\n    position: absolute;\n    display: block;\n}\n.p-slider-horizontal .p-slider-range {\n    top: 0;\n    left: 0;\n    height: 100%;\n}\n.p-slider-horizontal .p-slider-handle {\n    top: 50%;\n}\n.p-slider-vertical {\n    height: 100px;\n}\n.p-slider-vertical .p-slider-handle {\n    left: 50%;\n}\n.p-slider-vertical .p-slider-range {\n    bottom: 0;\n    left: 0;\n    width: 100%;\n}\n";
styleInject$9(css_248z$9);
script$y.render = render$y;
var script$x = {
  name: "InputSwitch",
  extends: script$W,
  emits: ["click", "update:modelValue", "change", "input", "focus", "blur"],
  props: {
    modelValue: {
      type: null,
      default: false
    },
    trueValue: {
      type: null,
      default: true
    },
    falseValue: {
      type: null,
      default: false
    },
    disabled: {
      type: Boolean,
      default: false
    },
    inputId: {
      type: String,
      default: null
    },
    inputClass: {
      type: [String, Object],
      default: null
    },
    inputStyle: {
      type: Object,
      default: null
    },
    inputProps: {
      type: null,
      default: null
    },
    "aria-labelledby": {
      type: String,
      default: null
    },
    "aria-label": {
      type: String,
      default: null
    }
  },
  data() {
    return {
      focused: false
    };
  },
  methods: {
    onClick(event2) {
      if (!this.disabled) {
        const newValue = this.checked ? this.falseValue : this.trueValue;
        this.$emit("click", event2);
        this.$emit("update:modelValue", newValue);
        this.$emit("change", event2);
        this.$emit("input", newValue);
        this.$refs.input.focus();
      }
      event2.preventDefault();
    },
    onFocus(event2) {
      this.focused = true;
      this.$emit("focus", event2);
    },
    onBlur(event2) {
      this.focused = false;
      this.$emit("blur", event2);
    }
  },
  computed: {
    containerClass() {
      return [
        "p-inputswitch p-component",
        {
          "p-inputswitch-checked": this.checked,
          "p-disabled": this.disabled,
          "p-focus": this.focused
        }
      ];
    },
    checked() {
      return this.modelValue === this.trueValue;
    }
  }
};
const _hoisted_1$t = ["id", "checked", "disabled", "aria-checked", "aria-labelledby", "aria-label"];
function render$x(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("div", mergeProps({
    class: $options.containerClass,
    onClick: _cache[2] || (_cache[2] = ($event) => $options.onClick($event))
  }, _ctx.ptm("root")), [
    createElementVNode("div", mergeProps({ class: "p-hidden-accessible" }, _ctx.ptm("hiddenInputWrapper")), [
      createElementVNode("input", mergeProps({
        ref: "input",
        id: $props.inputId,
        type: "checkbox",
        role: "switch",
        class: $props.inputClass,
        style: $props.inputStyle,
        checked: $options.checked,
        disabled: $props.disabled,
        "aria-checked": $options.checked,
        "aria-labelledby": _ctx.ariaLabelledby,
        "aria-label": _ctx.ariaLabel,
        onFocus: _cache[0] || (_cache[0] = ($event) => $options.onFocus($event)),
        onBlur: _cache[1] || (_cache[1] = ($event) => $options.onBlur($event))
      }, _ctx.ptm("hiddenInput")), null, 16, _hoisted_1$t)
    ], 16),
    createElementVNode("span", mergeProps({ class: "p-inputswitch-slider" }, { ...$props.inputProps, ..._ctx.ptm("slider") }), null, 16)
  ], 16);
}
function styleInject$8(css, ref2) {
  if (ref2 === void 0)
    ref2 = {};
  var insertAt = ref2.insertAt;
  if (!css || true) {
    return;
  }
  var head = document.head || document.getElementsByTagName("head")[0];
  var style = document.createElement("style");
  style.type = "text/css";
  if (insertAt === "top") {
    if (head.firstChild) {
      head.insertBefore(style, head.firstChild);
    } else {
      head.appendChild(style);
    }
  } else {
    head.appendChild(style);
  }
  if (style.styleSheet) {
    style.styleSheet.cssText = css;
  } else {
    style.appendChild(document.createTextNode(css));
  }
}
var css_248z$8 = "\n.p-inputswitch {\n    position: relative;\n    display: inline-block;\n}\n.p-inputswitch-slider {\n    position: absolute;\n    cursor: pointer;\n    top: 0;\n    left: 0;\n    right: 0;\n    bottom: 0;\n    border: 1px solid transparent;\n}\n.p-inputswitch-slider:before {\n    position: absolute;\n    content: '';\n    top: 50%;\n}\n";
styleInject$8(css_248z$8);
script$x.render = render$x;
var script$w = {
  name: "AngleDownIcon",
  extends: script$V
};
const _hoisted_1$s = /* @__PURE__ */ createElementVNode("path", {
  d: "M3.58659 4.5007C3.68513 4.50023 3.78277 4.51945 3.87379 4.55723C3.9648 4.59501 4.04735 4.65058 4.11659 4.7207L7.11659 7.7207L10.1166 4.7207C10.2619 4.65055 10.4259 4.62911 10.5843 4.65956C10.7427 4.69002 10.8871 4.77074 10.996 4.88976C11.1049 5.00877 11.1726 5.15973 11.1889 5.32022C11.2052 5.48072 11.1693 5.6422 11.0866 5.7807L7.58659 9.2807C7.44597 9.42115 7.25534 9.50004 7.05659 9.50004C6.85784 9.50004 6.66722 9.42115 6.52659 9.2807L3.02659 5.7807C2.88614 5.64007 2.80725 5.44945 2.80725 5.2507C2.80725 5.05195 2.88614 4.86132 3.02659 4.7207C3.09932 4.64685 3.18675 4.58911 3.28322 4.55121C3.37969 4.51331 3.48305 4.4961 3.58659 4.5007Z",
  fill: "currentColor"
}, null, -1);
const _hoisted_2$j = [
  _hoisted_1$s
];
function render$w(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("svg", mergeProps({
    width: "14",
    height: "14",
    viewBox: "0 0 14 14",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, _ctx.pti()), _hoisted_2$j, 16);
}
script$w.render = render$w;
var script$v = {
  name: "AngleUpIcon",
  extends: script$V
};
const _hoisted_1$r = /* @__PURE__ */ createElementVNode("path", {
  d: "M10.4134 9.49931C10.3148 9.49977 10.2172 9.48055 10.1262 9.44278C10.0352 9.405 9.95263 9.34942 9.88338 9.27931L6.88338 6.27931L3.88338 9.27931C3.73811 9.34946 3.57409 9.3709 3.41567 9.34044C3.25724 9.30999 3.11286 9.22926 3.00395 9.11025C2.89504 8.99124 2.82741 8.84028 2.8111 8.67978C2.79478 8.51928 2.83065 8.35781 2.91338 8.21931L6.41338 4.71931C6.55401 4.57886 6.74463 4.49997 6.94338 4.49997C7.14213 4.49997 7.33276 4.57886 7.47338 4.71931L10.9734 8.21931C11.1138 8.35994 11.1927 8.55056 11.1927 8.74931C11.1927 8.94806 11.1138 9.13868 10.9734 9.27931C10.9007 9.35315 10.8132 9.41089 10.7168 9.44879C10.6203 9.48669 10.5169 9.5039 10.4134 9.49931Z",
  fill: "currentColor"
}, null, -1);
const _hoisted_2$i = [
  _hoisted_1$r
];
function render$v(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("svg", mergeProps({
    width: "14",
    height: "14",
    viewBox: "0 0 14 14",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, _ctx.pti()), _hoisted_2$i, 16);
}
script$v.render = render$v;
var script$u = {
  name: "InputNumber",
  extends: script$W,
  emits: ["update:modelValue", "input", "focus", "blur"],
  props: {
    modelValue: {
      type: Number,
      default: null
    },
    format: {
      type: Boolean,
      default: true
    },
    showButtons: {
      type: Boolean,
      default: false
    },
    buttonLayout: {
      type: String,
      default: "stacked"
    },
    incrementButtonClass: {
      type: String,
      default: null
    },
    decrementButtonClass: {
      type: String,
      default: null
    },
    incrementButtonIcon: {
      type: String,
      default: void 0
    },
    decrementButtonIcon: {
      type: String,
      default: void 0
    },
    locale: {
      type: String,
      default: void 0
    },
    localeMatcher: {
      type: String,
      default: void 0
    },
    mode: {
      type: String,
      default: "decimal"
    },
    prefix: {
      type: String,
      default: null
    },
    suffix: {
      type: String,
      default: null
    },
    currency: {
      type: String,
      default: void 0
    },
    currencyDisplay: {
      type: String,
      default: void 0
    },
    useGrouping: {
      type: Boolean,
      default: true
    },
    minFractionDigits: {
      type: Number,
      default: void 0
    },
    maxFractionDigits: {
      type: Number,
      default: void 0
    },
    min: {
      type: Number,
      default: null
    },
    max: {
      type: Number,
      default: null
    },
    step: {
      type: Number,
      default: 1
    },
    allowEmpty: {
      type: Boolean,
      default: true
    },
    highlightOnFocus: {
      type: Boolean,
      default: false
    },
    readonly: {
      type: Boolean,
      default: false
    },
    disabled: {
      type: Boolean,
      default: false
    },
    placeholder: {
      type: String,
      default: null
    },
    inputId: {
      type: String,
      default: null
    },
    inputClass: {
      type: [String, Object],
      default: null
    },
    inputStyle: {
      type: Object,
      default: null
    },
    inputProps: {
      type: null,
      default: null
    },
    incrementButtonProps: {
      type: null,
      default: null
    },
    decrementButtonProps: {
      type: null,
      default: null
    },
    "aria-labelledby": {
      type: String,
      default: null
    },
    "aria-label": {
      type: String,
      default: null
    }
  },
  numberFormat: null,
  _numeral: null,
  _decimal: null,
  _group: null,
  _minusSign: null,
  _currency: null,
  _suffix: null,
  _prefix: null,
  _index: null,
  groupChar: "",
  isSpecialChar: null,
  prefixChar: null,
  suffixChar: null,
  timer: null,
  data() {
    return {
      d_modelValue: this.modelValue,
      focused: false
    };
  },
  watch: {
    modelValue(newValue) {
      this.d_modelValue = newValue;
    },
    locale(newValue, oldValue) {
      this.updateConstructParser(newValue, oldValue);
    },
    localeMatcher(newValue, oldValue) {
      this.updateConstructParser(newValue, oldValue);
    },
    mode(newValue, oldValue) {
      this.updateConstructParser(newValue, oldValue);
    },
    currency(newValue, oldValue) {
      this.updateConstructParser(newValue, oldValue);
    },
    currencyDisplay(newValue, oldValue) {
      this.updateConstructParser(newValue, oldValue);
    },
    useGrouping(newValue, oldValue) {
      this.updateConstructParser(newValue, oldValue);
    },
    minFractionDigits(newValue, oldValue) {
      this.updateConstructParser(newValue, oldValue);
    },
    maxFractionDigits(newValue, oldValue) {
      this.updateConstructParser(newValue, oldValue);
    },
    suffix(newValue, oldValue) {
      this.updateConstructParser(newValue, oldValue);
    },
    prefix(newValue, oldValue) {
      this.updateConstructParser(newValue, oldValue);
    }
  },
  created() {
    this.constructParser();
  },
  methods: {
    getOptions() {
      return {
        localeMatcher: this.localeMatcher,
        style: this.mode,
        currency: this.currency,
        currencyDisplay: this.currencyDisplay,
        useGrouping: this.useGrouping,
        minimumFractionDigits: this.minFractionDigits,
        maximumFractionDigits: this.maxFractionDigits
      };
    },
    constructParser() {
      this.numberFormat = new Intl.NumberFormat(this.locale, this.getOptions());
      const numerals = [...new Intl.NumberFormat(this.locale, { useGrouping: false }).format(9876543210)].reverse();
      const index = new Map(numerals.map((d, i) => [d, i]));
      this._numeral = new RegExp(`[${numerals.join("")}]`, "g");
      this._group = this.getGroupingExpression();
      this._minusSign = this.getMinusSignExpression();
      this._currency = this.getCurrencyExpression();
      this._decimal = this.getDecimalExpression();
      this._suffix = this.getSuffixExpression();
      this._prefix = this.getPrefixExpression();
      this._index = (d) => index.get(d);
    },
    updateConstructParser(newValue, oldValue) {
      if (newValue !== oldValue) {
        this.constructParser();
      }
    },
    escapeRegExp(text) {
      return text.replace(/[-[\]{}()*+?.,\\^$|#\s]/g, "\\$&");
    },
    getDecimalExpression() {
      const formatter = new Intl.NumberFormat(this.locale, { ...this.getOptions(), useGrouping: false });
      return new RegExp(`[${formatter.format(1.1).replace(this._currency, "").trim().replace(this._numeral, "")}]`, "g");
    },
    getGroupingExpression() {
      const formatter = new Intl.NumberFormat(this.locale, { useGrouping: true });
      this.groupChar = formatter.format(1e6).trim().replace(this._numeral, "").charAt(0);
      return new RegExp(`[${this.groupChar}]`, "g");
    },
    getMinusSignExpression() {
      const formatter = new Intl.NumberFormat(this.locale, { useGrouping: false });
      return new RegExp(`[${formatter.format(-1).trim().replace(this._numeral, "")}]`, "g");
    },
    getCurrencyExpression() {
      if (this.currency) {
        const formatter = new Intl.NumberFormat(this.locale, { style: "currency", currency: this.currency, currencyDisplay: this.currencyDisplay, minimumFractionDigits: 0, maximumFractionDigits: 0 });
        return new RegExp(`[${formatter.format(1).replace(/\s/g, "").replace(this._numeral, "").replace(this._group, "")}]`, "g");
      }
      return new RegExp(`[]`, "g");
    },
    getPrefixExpression() {
      if (this.prefix) {
        this.prefixChar = this.prefix;
      } else {
        const formatter = new Intl.NumberFormat(this.locale, { style: this.mode, currency: this.currency, currencyDisplay: this.currencyDisplay });
        this.prefixChar = formatter.format(1).split("1")[0];
      }
      return new RegExp(`${this.escapeRegExp(this.prefixChar || "")}`, "g");
    },
    getSuffixExpression() {
      if (this.suffix) {
        this.suffixChar = this.suffix;
      } else {
        const formatter = new Intl.NumberFormat(this.locale, { style: this.mode, currency: this.currency, currencyDisplay: this.currencyDisplay, minimumFractionDigits: 0, maximumFractionDigits: 0 });
        this.suffixChar = formatter.format(1).split("1")[1];
      }
      return new RegExp(`${this.escapeRegExp(this.suffixChar || "")}`, "g");
    },
    formatValue(value) {
      if (value != null) {
        if (value === "-") {
          return value;
        }
        if (this.format) {
          let formatter = new Intl.NumberFormat(this.locale, this.getOptions());
          let formattedValue = formatter.format(value);
          if (this.prefix) {
            formattedValue = this.prefix + formattedValue;
          }
          if (this.suffix) {
            formattedValue = formattedValue + this.suffix;
          }
          return formattedValue;
        }
        return value.toString();
      }
      return "";
    },
    parseValue(text) {
      let filteredText = text.replace(this._suffix, "").replace(this._prefix, "").trim().replace(/\s/g, "").replace(this._currency, "").replace(this._group, "").replace(this._minusSign, "-").replace(this._decimal, ".").replace(this._numeral, this._index);
      if (filteredText) {
        if (filteredText === "-")
          return filteredText;
        let parsedValue = +filteredText;
        return isNaN(parsedValue) ? null : parsedValue;
      }
      return null;
    },
    repeat(event2, interval, dir) {
      if (this.readonly) {
        return;
      }
      let i = interval || 500;
      this.clearTimer();
      this.timer = setTimeout(() => {
        this.repeat(event2, 40, dir);
      }, i);
      this.spin(event2, dir);
    },
    spin(event2, dir) {
      if (this.$refs.input) {
        let step = this.step * dir;
        let currentValue = this.parseValue(this.$refs.input.$el.value) || 0;
        let newValue = this.validateValue(currentValue + step);
        this.updateInput(newValue, null, "spin");
        this.updateModel(event2, newValue);
        this.handleOnInput(event2, currentValue, newValue);
      }
    },
    onUpButtonMouseDown(event2) {
      if (!this.disabled) {
        this.$refs.input.$el.focus();
        this.repeat(event2, null, 1);
        event2.preventDefault();
      }
    },
    onUpButtonMouseUp() {
      if (!this.disabled) {
        this.clearTimer();
      }
    },
    onUpButtonMouseLeave() {
      if (!this.disabled) {
        this.clearTimer();
      }
    },
    onUpButtonKeyUp() {
      if (!this.disabled) {
        this.clearTimer();
      }
    },
    onUpButtonKeyDown(event2) {
      if (event2.keyCode === 32 || event2.keyCode === 13) {
        this.repeat(event2, null, 1);
      }
    },
    onDownButtonMouseDown(event2) {
      if (!this.disabled) {
        this.$refs.input.$el.focus();
        this.repeat(event2, null, -1);
        event2.preventDefault();
      }
    },
    onDownButtonMouseUp() {
      if (!this.disabled) {
        this.clearTimer();
      }
    },
    onDownButtonMouseLeave() {
      if (!this.disabled) {
        this.clearTimer();
      }
    },
    onDownButtonKeyUp() {
      if (!this.disabled) {
        this.clearTimer();
      }
    },
    onDownButtonKeyDown(event2) {
      if (event2.keyCode === 32 || event2.keyCode === 13) {
        this.repeat(event2, null, -1);
      }
    },
    onUserInput() {
      if (this.isSpecialChar) {
        this.$refs.input.$el.value = this.lastValue;
      }
      this.isSpecialChar = false;
    },
    onInputKeyDown(event2) {
      if (this.readonly) {
        return;
      }
      this.lastValue = event2.target.value;
      if (event2.shiftKey || event2.altKey) {
        this.isSpecialChar = true;
        return;
      }
      let selectionStart = event2.target.selectionStart;
      let selectionEnd = event2.target.selectionEnd;
      let inputValue = event2.target.value;
      let newValueStr = null;
      if (event2.altKey) {
        event2.preventDefault();
      }
      switch (event2.code) {
        case "ArrowUp":
          this.spin(event2, 1);
          event2.preventDefault();
          break;
        case "ArrowDown":
          this.spin(event2, -1);
          event2.preventDefault();
          break;
        case "ArrowLeft":
          if (!this.isNumeralChar(inputValue.charAt(selectionStart - 1))) {
            event2.preventDefault();
          }
          break;
        case "ArrowRight":
          if (!this.isNumeralChar(inputValue.charAt(selectionStart))) {
            event2.preventDefault();
          }
          break;
        case "Tab":
        case "Enter":
          newValueStr = this.validateValue(this.parseValue(inputValue));
          this.$refs.input.$el.value = this.formatValue(newValueStr);
          this.$refs.input.$el.setAttribute("aria-valuenow", newValueStr);
          this.updateModel(event2, newValueStr);
          break;
        case "Backspace": {
          event2.preventDefault();
          if (selectionStart === selectionEnd) {
            const deleteChar = inputValue.charAt(selectionStart - 1);
            const { decimalCharIndex, decimalCharIndexWithoutPrefix } = this.getDecimalCharIndexes(inputValue);
            if (this.isNumeralChar(deleteChar)) {
              const decimalLength = this.getDecimalLength(inputValue);
              if (this._group.test(deleteChar)) {
                this._group.lastIndex = 0;
                newValueStr = inputValue.slice(0, selectionStart - 2) + inputValue.slice(selectionStart - 1);
              } else if (this._decimal.test(deleteChar)) {
                this._decimal.lastIndex = 0;
                if (decimalLength) {
                  this.$refs.input.$el.setSelectionRange(selectionStart - 1, selectionStart - 1);
                } else {
                  newValueStr = inputValue.slice(0, selectionStart - 1) + inputValue.slice(selectionStart);
                }
              } else if (decimalCharIndex > 0 && selectionStart > decimalCharIndex) {
                const insertedText = this.isDecimalMode() && (this.minFractionDigits || 0) < decimalLength ? "" : "0";
                newValueStr = inputValue.slice(0, selectionStart - 1) + insertedText + inputValue.slice(selectionStart);
              } else if (decimalCharIndexWithoutPrefix === 1) {
                newValueStr = inputValue.slice(0, selectionStart - 1) + "0" + inputValue.slice(selectionStart);
                newValueStr = this.parseValue(newValueStr) > 0 ? newValueStr : "";
              } else {
                newValueStr = inputValue.slice(0, selectionStart - 1) + inputValue.slice(selectionStart);
              }
            }
            this.updateValue(event2, newValueStr, null, "delete-single");
          } else {
            newValueStr = this.deleteRange(inputValue, selectionStart, selectionEnd);
            this.updateValue(event2, newValueStr, null, "delete-range");
          }
          break;
        }
        case "Delete":
          event2.preventDefault();
          if (selectionStart === selectionEnd) {
            const deleteChar = inputValue.charAt(selectionStart);
            const { decimalCharIndex, decimalCharIndexWithoutPrefix } = this.getDecimalCharIndexes(inputValue);
            if (this.isNumeralChar(deleteChar)) {
              const decimalLength = this.getDecimalLength(inputValue);
              if (this._group.test(deleteChar)) {
                this._group.lastIndex = 0;
                newValueStr = inputValue.slice(0, selectionStart) + inputValue.slice(selectionStart + 2);
              } else if (this._decimal.test(deleteChar)) {
                this._decimal.lastIndex = 0;
                if (decimalLength) {
                  this.$refs.input.$el.setSelectionRange(selectionStart + 1, selectionStart + 1);
                } else {
                  newValueStr = inputValue.slice(0, selectionStart) + inputValue.slice(selectionStart + 1);
                }
              } else if (decimalCharIndex > 0 && selectionStart > decimalCharIndex) {
                const insertedText = this.isDecimalMode() && (this.minFractionDigits || 0) < decimalLength ? "" : "0";
                newValueStr = inputValue.slice(0, selectionStart) + insertedText + inputValue.slice(selectionStart + 1);
              } else if (decimalCharIndexWithoutPrefix === 1) {
                newValueStr = inputValue.slice(0, selectionStart) + "0" + inputValue.slice(selectionStart + 1);
                newValueStr = this.parseValue(newValueStr) > 0 ? newValueStr : "";
              } else {
                newValueStr = inputValue.slice(0, selectionStart) + inputValue.slice(selectionStart + 1);
              }
            }
            this.updateValue(event2, newValueStr, null, "delete-back-single");
          } else {
            newValueStr = this.deleteRange(inputValue, selectionStart, selectionEnd);
            this.updateValue(event2, newValueStr, null, "delete-range");
          }
          break;
        case "Home":
          if (this.min) {
            this.updateModel(event2, this.min);
            event2.preventDefault();
          }
          break;
        case "End":
          if (this.max) {
            this.updateModel(event2, this.max);
            event2.preventDefault();
          }
          break;
      }
    },
    onInputKeyPress(event2) {
      if (this.readonly) {
        return;
      }
      event2.preventDefault();
      let code = event2.which || event2.keyCode;
      let char = String.fromCharCode(code);
      const isDecimalSign = this.isDecimalSign(char);
      const isMinusSign = this.isMinusSign(char);
      if (48 <= code && code <= 57 || isMinusSign || isDecimalSign) {
        this.insert(event2, char, { isDecimalSign, isMinusSign });
      }
    },
    onPaste(event2) {
      event2.preventDefault();
      let data = (event2.clipboardData || window["clipboardData"]).getData("Text");
      if (data) {
        let filteredData = this.parseValue(data);
        if (filteredData != null) {
          this.insert(event2, filteredData.toString());
        }
      }
    },
    allowMinusSign() {
      return this.min === null || this.min < 0;
    },
    isMinusSign(char) {
      if (this._minusSign.test(char) || char === "-") {
        this._minusSign.lastIndex = 0;
        return true;
      }
      return false;
    },
    isDecimalSign(char) {
      if (this._decimal.test(char)) {
        this._decimal.lastIndex = 0;
        return true;
      }
      return false;
    },
    isDecimalMode() {
      return this.mode === "decimal";
    },
    getDecimalCharIndexes(val) {
      let decimalCharIndex = val.search(this._decimal);
      this._decimal.lastIndex = 0;
      const filteredVal = val.replace(this._prefix, "").trim().replace(/\s/g, "").replace(this._currency, "");
      const decimalCharIndexWithoutPrefix = filteredVal.search(this._decimal);
      this._decimal.lastIndex = 0;
      return { decimalCharIndex, decimalCharIndexWithoutPrefix };
    },
    getCharIndexes(val) {
      const decimalCharIndex = val.search(this._decimal);
      this._decimal.lastIndex = 0;
      const minusCharIndex = val.search(this._minusSign);
      this._minusSign.lastIndex = 0;
      const suffixCharIndex = val.search(this._suffix);
      this._suffix.lastIndex = 0;
      const currencyCharIndex = val.search(this._currency);
      this._currency.lastIndex = 0;
      return { decimalCharIndex, minusCharIndex, suffixCharIndex, currencyCharIndex };
    },
    insert(event2, text, sign = { isDecimalSign: false, isMinusSign: false }) {
      const minusCharIndexOnText = text.search(this._minusSign);
      this._minusSign.lastIndex = 0;
      if (!this.allowMinusSign() && minusCharIndexOnText !== -1) {
        return;
      }
      const selectionStart = this.$refs.input.$el.selectionStart;
      const selectionEnd = this.$refs.input.$el.selectionEnd;
      let inputValue = this.$refs.input.$el.value.trim();
      const { decimalCharIndex, minusCharIndex, suffixCharIndex, currencyCharIndex } = this.getCharIndexes(inputValue);
      let newValueStr;
      if (sign.isMinusSign) {
        if (selectionStart === 0) {
          newValueStr = inputValue;
          if (minusCharIndex === -1 || selectionEnd !== 0) {
            newValueStr = this.insertText(inputValue, text, 0, selectionEnd);
          }
          this.updateValue(event2, newValueStr, text, "insert");
        }
      } else if (sign.isDecimalSign) {
        if (decimalCharIndex > 0 && selectionStart === decimalCharIndex) {
          this.updateValue(event2, inputValue, text, "insert");
        } else if (decimalCharIndex > selectionStart && decimalCharIndex < selectionEnd) {
          newValueStr = this.insertText(inputValue, text, selectionStart, selectionEnd);
          this.updateValue(event2, newValueStr, text, "insert");
        } else if (decimalCharIndex === -1 && this.maxFractionDigits) {
          newValueStr = this.insertText(inputValue, text, selectionStart, selectionEnd);
          this.updateValue(event2, newValueStr, text, "insert");
        }
      } else {
        const maxFractionDigits = this.numberFormat.resolvedOptions().maximumFractionDigits;
        const operation = selectionStart !== selectionEnd ? "range-insert" : "insert";
        if (decimalCharIndex > 0 && selectionStart > decimalCharIndex) {
          if (selectionStart + text.length - (decimalCharIndex + 1) <= maxFractionDigits) {
            const charIndex = currencyCharIndex >= selectionStart ? currencyCharIndex - 1 : suffixCharIndex >= selectionStart ? suffixCharIndex : inputValue.length;
            newValueStr = inputValue.slice(0, selectionStart) + text + inputValue.slice(selectionStart + text.length, charIndex) + inputValue.slice(charIndex);
            this.updateValue(event2, newValueStr, text, operation);
          }
        } else {
          newValueStr = this.insertText(inputValue, text, selectionStart, selectionEnd);
          this.updateValue(event2, newValueStr, text, operation);
        }
      }
    },
    insertText(value, text, start, end) {
      let textSplit = text === "." ? text : text.split(".");
      if (textSplit.length === 2) {
        const decimalCharIndex = value.slice(start, end).search(this._decimal);
        this._decimal.lastIndex = 0;
        return decimalCharIndex > 0 ? value.slice(0, start) + this.formatValue(text) + value.slice(end) : value || this.formatValue(text);
      } else if (end - start === value.length) {
        return this.formatValue(text);
      } else if (start === 0) {
        return text + value.slice(end);
      } else if (end === value.length) {
        return value.slice(0, start) + text;
      } else {
        return value.slice(0, start) + text + value.slice(end);
      }
    },
    deleteRange(value, start, end) {
      let newValueStr;
      if (end - start === value.length)
        newValueStr = "";
      else if (start === 0)
        newValueStr = value.slice(end);
      else if (end === value.length)
        newValueStr = value.slice(0, start);
      else
        newValueStr = value.slice(0, start) + value.slice(end);
      return newValueStr;
    },
    initCursor() {
      let selectionStart = this.$refs.input.$el.selectionStart;
      let inputValue = this.$refs.input.$el.value;
      let valueLength = inputValue.length;
      let index = null;
      let prefixLength = (this.prefixChar || "").length;
      inputValue = inputValue.replace(this._prefix, "");
      selectionStart = selectionStart - prefixLength;
      let char = inputValue.charAt(selectionStart);
      if (this.isNumeralChar(char)) {
        return selectionStart + prefixLength;
      }
      let i = selectionStart - 1;
      while (i >= 0) {
        char = inputValue.charAt(i);
        if (this.isNumeralChar(char)) {
          index = i + prefixLength;
          break;
        } else {
          i--;
        }
      }
      if (index !== null) {
        this.$refs.input.$el.setSelectionRange(index + 1, index + 1);
      } else {
        i = selectionStart;
        while (i < valueLength) {
          char = inputValue.charAt(i);
          if (this.isNumeralChar(char)) {
            index = i + prefixLength;
            break;
          } else {
            i++;
          }
        }
        if (index !== null) {
          this.$refs.input.$el.setSelectionRange(index, index);
        }
      }
      return index || 0;
    },
    onInputClick() {
      const currentValue = this.$refs.input.$el.value;
      if (!this.readonly && currentValue !== DomHandler.getSelection()) {
        this.initCursor();
      }
    },
    isNumeralChar(char) {
      if (char.length === 1 && (this._numeral.test(char) || this._decimal.test(char) || this._group.test(char) || this._minusSign.test(char))) {
        this.resetRegex();
        return true;
      }
      return false;
    },
    resetRegex() {
      this._numeral.lastIndex = 0;
      this._decimal.lastIndex = 0;
      this._group.lastIndex = 0;
      this._minusSign.lastIndex = 0;
    },
    updateValue(event2, valueStr, insertedValueStr, operation) {
      let currentValue = this.$refs.input.$el.value;
      let newValue = null;
      if (valueStr != null) {
        newValue = this.parseValue(valueStr);
        newValue = !newValue && !this.allowEmpty ? 0 : newValue;
        this.updateInput(newValue, insertedValueStr, operation, valueStr);
        this.handleOnInput(event2, currentValue, newValue);
      }
    },
    handleOnInput(event2, currentValue, newValue) {
      if (this.isValueChanged(currentValue, newValue)) {
        this.$emit("input", { originalEvent: event2, value: newValue, formattedValue: currentValue });
      }
    },
    isValueChanged(currentValue, newValue) {
      if (newValue === null && currentValue !== null) {
        return true;
      }
      if (newValue != null) {
        let parsedCurrentValue = typeof currentValue === "string" ? this.parseValue(currentValue) : currentValue;
        return newValue !== parsedCurrentValue;
      }
      return false;
    },
    validateValue(value) {
      if (value === "-" || value == null) {
        return null;
      }
      if (this.min != null && value < this.min) {
        return this.min;
      }
      if (this.max != null && value > this.max) {
        return this.max;
      }
      return value;
    },
    updateInput(value, insertedValueStr, operation, valueStr) {
      insertedValueStr = insertedValueStr || "";
      let inputValue = this.$refs.input.$el.value;
      let newValue = this.formatValue(value);
      let currentLength = inputValue.length;
      if (newValue !== valueStr) {
        newValue = this.concatValues(newValue, valueStr);
      }
      if (currentLength === 0) {
        this.$refs.input.$el.value = newValue;
        this.$refs.input.$el.setSelectionRange(0, 0);
        const index = this.initCursor();
        const selectionEnd = index + insertedValueStr.length;
        this.$refs.input.$el.setSelectionRange(selectionEnd, selectionEnd);
      } else {
        let selectionStart = this.$refs.input.$el.selectionStart;
        let selectionEnd = this.$refs.input.$el.selectionEnd;
        this.$refs.input.$el.value = newValue;
        let newLength = newValue.length;
        if (operation === "range-insert") {
          const startValue = this.parseValue((inputValue || "").slice(0, selectionStart));
          const startValueStr = startValue !== null ? startValue.toString() : "";
          const startExpr = startValueStr.split("").join(`(${this.groupChar})?`);
          const sRegex = new RegExp(startExpr, "g");
          sRegex.test(newValue);
          const tExpr = insertedValueStr.split("").join(`(${this.groupChar})?`);
          const tRegex = new RegExp(tExpr, "g");
          tRegex.test(newValue.slice(sRegex.lastIndex));
          selectionEnd = sRegex.lastIndex + tRegex.lastIndex;
          this.$refs.input.$el.setSelectionRange(selectionEnd, selectionEnd);
        } else if (newLength === currentLength) {
          if (operation === "insert" || operation === "delete-back-single")
            this.$refs.input.$el.setSelectionRange(selectionEnd + 1, selectionEnd + 1);
          else if (operation === "delete-single")
            this.$refs.input.$el.setSelectionRange(selectionEnd - 1, selectionEnd - 1);
          else if (operation === "delete-range" || operation === "spin")
            this.$refs.input.$el.setSelectionRange(selectionEnd, selectionEnd);
        } else if (operation === "delete-back-single") {
          let prevChar = inputValue.charAt(selectionEnd - 1);
          let nextChar = inputValue.charAt(selectionEnd);
          let diff = currentLength - newLength;
          let isGroupChar = this._group.test(nextChar);
          if (isGroupChar && diff === 1) {
            selectionEnd += 1;
          } else if (!isGroupChar && this.isNumeralChar(prevChar)) {
            selectionEnd += -1 * diff + 1;
          }
          this._group.lastIndex = 0;
          this.$refs.input.$el.setSelectionRange(selectionEnd, selectionEnd);
        } else if (inputValue === "-" && operation === "insert") {
          this.$refs.input.$el.setSelectionRange(0, 0);
          const index = this.initCursor();
          const selectionEnd2 = index + insertedValueStr.length + 1;
          this.$refs.input.$el.setSelectionRange(selectionEnd2, selectionEnd2);
        } else {
          selectionEnd = selectionEnd + (newLength - currentLength);
          this.$refs.input.$el.setSelectionRange(selectionEnd, selectionEnd);
        }
      }
      this.$refs.input.$el.setAttribute("aria-valuenow", value);
    },
    concatValues(val1, val2) {
      if (val1 && val2) {
        let decimalCharIndex = val2.search(this._decimal);
        this._decimal.lastIndex = 0;
        if (this.suffixChar) {
          return val1.replace(this.suffixChar, "").split(this._decimal)[0] + val2.replace(this.suffixChar, "").slice(decimalCharIndex) + this.suffixChar;
        } else {
          return decimalCharIndex !== -1 ? val1.split(this._decimal)[0] + val2.slice(decimalCharIndex) : val1;
        }
      }
      return val1;
    },
    getDecimalLength(value) {
      if (value) {
        const valueSplit = value.split(this._decimal);
        if (valueSplit.length === 2) {
          return valueSplit[1].replace(this._suffix, "").trim().replace(/\s/g, "").replace(this._currency, "").length;
        }
      }
      return 0;
    },
    updateModel(event2, value) {
      this.d_modelValue = value;
      this.$emit("update:modelValue", value);
    },
    onInputFocus(event2) {
      this.focused = true;
      if (!this.disabled && !this.readonly && this.$refs.input.$el.value !== DomHandler.getSelection() && this.highlightOnFocus) {
        event2.target.select();
      }
      this.$emit("focus", event2);
    },
    onInputBlur(event2) {
      this.focused = false;
      let input = event2.target;
      let newValue = this.validateValue(this.parseValue(input.value));
      this.$emit("blur", { originalEvent: event2, value: input.value });
      input.value = this.formatValue(newValue);
      input.setAttribute("aria-valuenow", newValue);
      this.updateModel(event2, newValue);
    },
    clearTimer() {
      if (this.timer) {
        clearInterval(this.timer);
      }
    },
    maxBoundry() {
      return this.d_modelValue >= this.max;
    },
    minBoundry() {
      return this.d_modelValue <= this.min;
    }
  },
  computed: {
    containerClass() {
      return [
        "p-inputnumber p-component p-inputwrapper",
        {
          "p-inputwrapper-filled": this.filled,
          "p-inputwrapper-focus": this.focused,
          "p-inputnumber-buttons-stacked": this.showButtons && this.buttonLayout === "stacked",
          "p-inputnumber-buttons-horizontal": this.showButtons && this.buttonLayout === "horizontal",
          "p-inputnumber-buttons-vertical": this.showButtons && this.buttonLayout === "vertical"
        }
      ];
    },
    upButtonClass() {
      return [
        "p-inputnumber-button p-inputnumber-button-up",
        this.incrementButtonClass,
        {
          "p-disabled": this.showButtons && this.max !== null && this.maxBoundry()
        }
      ];
    },
    downButtonClass() {
      return [
        "p-inputnumber-button p-inputnumber-button-down",
        this.decrementButtonClass,
        {
          "p-disabled": this.showButtons && this.min !== null && this.minBoundry()
        }
      ];
    },
    filled() {
      return this.modelValue != null && this.modelValue.toString().length > 0;
    },
    upButtonListeners() {
      return {
        mousedown: (event2) => this.onUpButtonMouseDown(event2),
        mouseup: (event2) => this.onUpButtonMouseUp(event2),
        mouseleave: (event2) => this.onUpButtonMouseLeave(event2),
        keydown: (event2) => this.onUpButtonKeyDown(event2),
        keyup: (event2) => this.onUpButtonKeyUp(event2)
      };
    },
    downButtonListeners() {
      return {
        mousedown: (event2) => this.onDownButtonMouseDown(event2),
        mouseup: (event2) => this.onDownButtonMouseUp(event2),
        mouseleave: (event2) => this.onDownButtonMouseLeave(event2),
        keydown: (event2) => this.onDownButtonKeyDown(event2),
        keyup: (event2) => this.onDownButtonKeyUp(event2)
      };
    },
    formattedValue() {
      const val = !this.modelValue && !this.allowEmpty ? 0 : this.modelValue;
      return this.formatValue(val);
    },
    getFormatter() {
      return this.numberFormat;
    }
  },
  components: {
    INInputText: script$I,
    INButton: script$T,
    AngleUpIcon: script$v,
    AngleDownIcon: script$w
  }
};
function render$u(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_INInputText = resolveComponent("INInputText");
  const _component_INButton = resolveComponent("INButton");
  return openBlock(), createElementBlock("span", mergeProps({ class: $options.containerClass }, _ctx.ptm("root")), [
    createVNode(_component_INInputText, mergeProps({
      ref: "input",
      id: $props.inputId,
      class: ["p-inputnumber-input", $props.inputClass],
      role: "spinbutton",
      style: $props.inputStyle,
      value: $options.formattedValue,
      "aria-valuemin": $props.min,
      "aria-valuemax": $props.max,
      "aria-valuenow": $props.modelValue,
      disabled: $props.disabled,
      readonly: $props.readonly,
      placeholder: $props.placeholder,
      "aria-labelledby": _ctx.ariaLabelledby,
      "aria-label": _ctx.ariaLabel,
      onInput: $options.onUserInput,
      onKeydown: $options.onInputKeyDown,
      onKeypress: $options.onInputKeyPress,
      onPaste: $options.onPaste,
      onClick: $options.onInputClick,
      onFocus: $options.onInputFocus,
      onBlur: $options.onInputBlur
    }, { ...$props.inputProps, ..._ctx.ptm("input") }), null, 16, ["id", "class", "style", "value", "aria-valuemin", "aria-valuemax", "aria-valuenow", "disabled", "readonly", "placeholder", "aria-labelledby", "aria-label", "onInput", "onKeydown", "onKeypress", "onPaste", "onClick", "onFocus", "onBlur"]),
    $props.showButtons && $props.buttonLayout === "stacked" ? (openBlock(), createElementBlock("span", mergeProps({
      key: 0,
      class: "p-inputnumber-button-group"
    }, _ctx.ptm("buttonGroup")), [
      createVNode(_component_INButton, mergeProps({ class: $options.upButtonClass }, toHandlers($options.upButtonListeners), {
        disabled: $props.disabled,
        tabindex: -1,
        "aria-hidden": "true"
      }, { ...$props.incrementButtonProps, ..._ctx.ptm("incrementButton") }), {
        icon: withCtx(() => [
          renderSlot(_ctx.$slots, "incrementbuttonicon", {}, () => [
            (openBlock(), createBlock(resolveDynamicComponent($props.incrementButtonIcon ? "span" : "AngleUpIcon"), mergeProps({ class: $props.incrementButtonIcon }, _ctx.ptm("incrementButton")["icon"]), null, 16, ["class"]))
          ])
        ]),
        _: 3
      }, 16, ["class", "disabled"]),
      createVNode(_component_INButton, mergeProps({ class: $options.downButtonClass }, toHandlers($options.downButtonListeners), {
        disabled: $props.disabled,
        tabindex: -1,
        "aria-hidden": "true"
      }, { ...$props.decrementButtonProps, ..._ctx.ptm("decrementButton") }), {
        icon: withCtx(() => [
          renderSlot(_ctx.$slots, "decrementbuttonicon", {}, () => [
            (openBlock(), createBlock(resolveDynamicComponent($props.decrementButtonIcon ? "span" : "AngleDownIcon"), mergeProps({ class: $props.decrementButtonIcon }, _ctx.ptm("decrementButton")["icon"]), null, 16, ["class"]))
          ])
        ]),
        _: 3
      }, 16, ["class", "disabled"])
    ], 16)) : createCommentVNode("", true),
    $props.showButtons && $props.buttonLayout !== "stacked" ? (openBlock(), createBlock(_component_INButton, mergeProps({
      key: 1,
      class: $options.upButtonClass
    }, toHandlers($options.upButtonListeners), {
      disabled: $props.disabled,
      tabindex: -1,
      "aria-hidden": "true"
    }, { ...$props.incrementButtonProps, ..._ctx.ptm("incrementButton") }), {
      icon: withCtx(() => [
        renderSlot(_ctx.$slots, "incrementbuttonicon", {}, () => [
          (openBlock(), createBlock(resolveDynamicComponent($props.incrementButtonIcon ? "span" : "AngleUpIcon"), mergeProps({ class: $props.incrementButtonIcon }, _ctx.ptm("incrementButton")["icon"]), null, 16, ["class"]))
        ])
      ]),
      _: 3
    }, 16, ["class", "disabled"])) : createCommentVNode("", true),
    $props.showButtons && $props.buttonLayout !== "stacked" ? (openBlock(), createBlock(_component_INButton, mergeProps({
      key: 2,
      class: $options.downButtonClass
    }, toHandlers($options.downButtonListeners), {
      disabled: $props.disabled,
      tabindex: -1,
      "aria-hidden": "true"
    }, { ...$props.decrementButtonProps, ..._ctx.ptm("decrementButton") }), {
      icon: withCtx(() => [
        renderSlot(_ctx.$slots, "decrementbuttonicon", {}, () => [
          (openBlock(), createBlock(resolveDynamicComponent($props.decrementButtonIcon ? "span" : "AngleDownIcon"), mergeProps({ class: $props.decrementButtonIcon }, _ctx.ptm("decrementButton")["icon"]), null, 16, ["class"]))
        ])
      ]),
      _: 3
    }, 16, ["class", "disabled"])) : createCommentVNode("", true)
  ], 16);
}
function styleInject$7(css, ref2) {
  if (ref2 === void 0)
    ref2 = {};
  var insertAt = ref2.insertAt;
  if (!css || true) {
    return;
  }
  var head = document.head || document.getElementsByTagName("head")[0];
  var style = document.createElement("style");
  style.type = "text/css";
  if (insertAt === "top") {
    if (head.firstChild) {
      head.insertBefore(style, head.firstChild);
    } else {
      head.appendChild(style);
    }
  } else {
    head.appendChild(style);
  }
  if (style.styleSheet) {
    style.styleSheet.cssText = css;
  } else {
    style.appendChild(document.createTextNode(css));
  }
}
var css_248z$7 = "\n.p-inputnumber {\n    display: inline-flex;\n}\n.p-inputnumber-button {\n    display: flex;\n    align-items: center;\n    justify-content: center;\n    flex: 0 0 auto;\n}\n.p-inputnumber-buttons-stacked .p-button.p-inputnumber-button .p-button-label,\n.p-inputnumber-buttons-horizontal .p-button.p-inputnumber-button .p-button-label {\n    display: none;\n}\n.p-inputnumber-buttons-stacked .p-button.p-inputnumber-button-up {\n    border-top-left-radius: 0;\n    border-bottom-left-radius: 0;\n    border-bottom-right-radius: 0;\n    padding: 0;\n}\n.p-inputnumber-buttons-stacked .p-inputnumber-input {\n    border-top-right-radius: 0;\n    border-bottom-right-radius: 0;\n}\n.p-inputnumber-buttons-stacked .p-button.p-inputnumber-button-down {\n    border-top-left-radius: 0;\n    border-top-right-radius: 0;\n    border-bottom-left-radius: 0;\n    padding: 0;\n}\n.p-inputnumber-buttons-stacked .p-inputnumber-button-group {\n    display: flex;\n    flex-direction: column;\n}\n.p-inputnumber-buttons-stacked .p-inputnumber-button-group .p-button.p-inputnumber-button {\n    flex: 1 1 auto;\n}\n.p-inputnumber-buttons-horizontal .p-button.p-inputnumber-button-up {\n    order: 3;\n    border-top-left-radius: 0;\n    border-bottom-left-radius: 0;\n}\n.p-inputnumber-buttons-horizontal .p-inputnumber-input {\n    order: 2;\n    border-radius: 0;\n}\n.p-inputnumber-buttons-horizontal .p-button.p-inputnumber-button-down {\n    order: 1;\n    border-top-right-radius: 0;\n    border-bottom-right-radius: 0;\n}\n.p-inputnumber-buttons-vertical {\n    flex-direction: column;\n}\n.p-inputnumber-buttons-vertical .p-button.p-inputnumber-button-up {\n    order: 1;\n    border-bottom-left-radius: 0;\n    border-bottom-right-radius: 0;\n    width: 100%;\n}\n.p-inputnumber-buttons-vertical .p-inputnumber-input {\n    order: 2;\n    border-radius: 0;\n    text-align: center;\n}\n.p-inputnumber-buttons-vertical .p-button.p-inputnumber-button-down {\n    order: 3;\n    border-top-left-radius: 0;\n    border-top-right-radius: 0;\n    width: 100%;\n}\n.p-inputnumber-input {\n    flex: 1 1 auto;\n}\n.p-fluid .p-inputnumber {\n    width: 100%;\n}\n.p-fluid .p-inputnumber .p-inputnumber-input {\n    width: 1%;\n}\n.p-fluid .p-inputnumber-buttons-vertical .p-inputnumber-input {\n    width: 100%;\n}\n";
styleInject$7(css_248z$7);
script$u.render = render$u;
var script$t = {
  name: "InputMask",
  extends: script$W,
  emits: ["update:modelValue", "focus", "blur", "keydown", "complete", "keypress", "paste"],
  props: {
    modelValue: null,
    slotChar: {
      type: String,
      default: "_"
    },
    mask: {
      type: String,
      default: null
    },
    autoClear: {
      type: Boolean,
      default: true
    },
    unmask: {
      type: Boolean,
      default: false
    },
    readonly: {
      type: Boolean,
      default: false
    }
  },
  watch: {
    mask(newMask, oldMask) {
      if (oldMask !== newMask) {
        this.initMask();
      }
    }
  },
  mounted() {
    this.initMask();
  },
  updated() {
    if (this.isValueUpdated()) {
      this.updateValue();
    }
  },
  methods: {
    onInput(event2) {
      if (this.androidChrome)
        this.handleAndroidInput(event2);
      else
        this.handleInputChange(event2);
      this.$emit("update:modelValue", event2.target.value);
    },
    onFocus(event2) {
      if (this.readonly) {
        return;
      }
      this.focus = true;
      clearTimeout(this.caretTimeoutId);
      let pos;
      this.focusText = this.$el.value;
      pos = this.checkVal();
      this.caretTimeoutId = setTimeout(() => {
        if (this.$el !== document.activeElement) {
          return;
        }
        this.writeBuffer();
        if (pos === this.mask.replace("?", "").length) {
          this.caret(0, pos);
        } else {
          this.caret(pos);
        }
      }, 10);
      this.$emit("focus", event2);
    },
    onBlur(event2) {
      this.focus = false;
      this.checkVal();
      this.updateModel(event2);
      if (this.$el.value !== this.focusText) {
        let e = document.createEvent("HTMLEvents");
        e.initEvent("change", true, false);
        this.$el.dispatchEvent(e);
      }
      this.$emit("blur", event2);
    },
    onKeyDown(event2) {
      if (this.readonly) {
        return;
      }
      let k = event2.which || event2.keyCode, pos, begin, end;
      let iPhone = /iphone/i.test(DomHandler.getUserAgent());
      this.oldVal = this.$el.value;
      if (k === 8 || k === 46 || iPhone && k === 127) {
        pos = this.caret();
        begin = pos.begin;
        end = pos.end;
        if (end - begin === 0) {
          begin = k !== 46 ? this.seekPrev(begin) : end = this.seekNext(begin - 1);
          end = k === 46 ? this.seekNext(end) : end;
        }
        this.clearBuffer(begin, end);
        this.shiftL(begin, end - 1);
        this.updateModel(event2);
        event2.preventDefault();
      } else if (k === 13) {
        this.$el.blur();
        this.updateModel(event2);
      } else if (k === 27) {
        this.$el.value = this.focusText;
        this.caret(0, this.checkVal());
        this.updateModel(event2);
        event2.preventDefault();
      }
      this.$emit("keydown", event2);
    },
    onKeyPress(event2) {
      if (this.readonly) {
        return;
      }
      var k = event2.which || event2.keyCode, pos = this.caret(), p, c, next, completed;
      if (event2.ctrlKey || event2.altKey || event2.metaKey || k < 32) {
        return;
      } else if (k && k !== 13) {
        if (pos.end - pos.begin !== 0) {
          this.clearBuffer(pos.begin, pos.end);
          this.shiftL(pos.begin, pos.end - 1);
        }
        p = this.seekNext(pos.begin - 1);
        if (p < this.len) {
          c = String.fromCharCode(k);
          if (this.tests[p].test(c)) {
            this.shiftR(p);
            this.buffer[p] = c;
            this.writeBuffer();
            next = this.seekNext(p);
            if (/android/i.test(DomHandler.getUserAgent())) {
              let proxy = () => {
                this.caret(next);
              };
              setTimeout(proxy, 0);
            } else {
              this.caret(next);
            }
            if (pos.begin <= this.lastRequiredNonMaskPos) {
              completed = this.isCompleted();
            }
          }
        }
        event2.preventDefault();
      }
      this.updateModel(event2);
      if (completed) {
        this.$emit("complete", event2);
      }
      this.$emit("keypress", event2);
    },
    onPaste(event2) {
      this.handleInputChange(event2);
      this.$emit("paste", event2);
    },
    caret(first, last) {
      let range, begin, end;
      if (!this.$el.offsetParent || this.$el !== document.activeElement) {
        return;
      }
      if (typeof first === "number") {
        begin = first;
        end = typeof last === "number" ? last : begin;
        if (this.$el.setSelectionRange) {
          this.$el.setSelectionRange(begin, end);
        } else if (this.$el["createTextRange"]) {
          range = this.$el["createTextRange"]();
          range.collapse(true);
          range.moveEnd("character", end);
          range.moveStart("character", begin);
          range.select();
        }
      } else {
        if (this.$el.setSelectionRange) {
          begin = this.$el.selectionStart;
          end = this.$el.selectionEnd;
        } else if (document["selection"] && document["selection"].createRange) {
          range = document["selection"].createRange();
          begin = 0 - range.duplicate().moveStart("character", -1e5);
          end = begin + range.text.length;
        }
        return { begin, end };
      }
    },
    isCompleted() {
      for (let i = this.firstNonMaskPos; i <= this.lastRequiredNonMaskPos; i++) {
        if (this.tests[i] && this.buffer[i] === this.getPlaceholder(i)) {
          return false;
        }
      }
      return true;
    },
    getPlaceholder(i) {
      if (i < this.slotChar.length) {
        return this.slotChar.charAt(i);
      }
      return this.slotChar.charAt(0);
    },
    seekNext(pos) {
      while (++pos < this.len && !this.tests[pos])
        ;
      return pos;
    },
    seekPrev(pos) {
      while (--pos >= 0 && !this.tests[pos])
        ;
      return pos;
    },
    shiftL(begin, end) {
      let i, j;
      if (begin < 0) {
        return;
      }
      for (i = begin, j = this.seekNext(end); i < this.len; i++) {
        if (this.tests[i]) {
          if (j < this.len && this.tests[i].test(this.buffer[j])) {
            this.buffer[i] = this.buffer[j];
            this.buffer[j] = this.getPlaceholder(j);
          } else {
            break;
          }
          j = this.seekNext(j);
        }
      }
      this.writeBuffer();
      this.caret(Math.max(this.firstNonMaskPos, begin));
    },
    shiftR(pos) {
      let i, c, j, t;
      for (i = pos, c = this.getPlaceholder(pos); i < this.len; i++) {
        if (this.tests[i]) {
          j = this.seekNext(i);
          t = this.buffer[i];
          this.buffer[i] = c;
          if (j < this.len && this.tests[j].test(t)) {
            c = t;
          } else {
            break;
          }
        }
      }
    },
    handleAndroidInput(event2) {
      var curVal = this.$el.value;
      var pos = this.caret();
      if (this.oldVal && this.oldVal.length && this.oldVal.length > curVal.length) {
        this.checkVal(true);
        while (pos.begin > 0 && !this.tests[pos.begin - 1])
          pos.begin--;
        if (pos.begin === 0) {
          while (pos.begin < this.firstNonMaskPos && !this.tests[pos.begin])
            pos.begin++;
        }
        this.caret(pos.begin, pos.begin);
      } else {
        this.checkVal(true);
        while (pos.begin < this.len && !this.tests[pos.begin])
          pos.begin++;
        this.caret(pos.begin, pos.begin);
      }
      if (this.isCompleted()) {
        this.$emit("complete", event2);
      }
    },
    clearBuffer(start, end) {
      let i;
      for (i = start; i < end && i < this.len; i++) {
        if (this.tests[i]) {
          this.buffer[i] = this.getPlaceholder(i);
        }
      }
    },
    writeBuffer() {
      this.$el.value = this.buffer.join("");
    },
    checkVal(allow) {
      this.isValueChecked = true;
      let test = this.$el.value, lastMatch = -1, i, c, pos;
      for (i = 0, pos = 0; i < this.len; i++) {
        if (this.tests[i]) {
          this.buffer[i] = this.getPlaceholder(i);
          while (pos++ < test.length) {
            c = test.charAt(pos - 1);
            if (this.tests[i].test(c)) {
              this.buffer[i] = c;
              lastMatch = i;
              break;
            }
          }
          if (pos > test.length) {
            this.clearBuffer(i + 1, this.len);
            break;
          }
        } else {
          if (this.buffer[i] === test.charAt(pos)) {
            pos++;
          }
          if (i < this.partialPosition) {
            lastMatch = i;
          }
        }
      }
      if (allow) {
        this.writeBuffer();
      } else if (lastMatch + 1 < this.partialPosition) {
        if (this.autoClear || this.buffer.join("") === this.defaultBuffer) {
          if (this.$el.value)
            this.$el.value = "";
          this.clearBuffer(0, this.len);
        } else {
          this.writeBuffer();
        }
      } else {
        this.writeBuffer();
        this.$el.value = this.$el.value.substring(0, lastMatch + 1);
      }
      return this.partialPosition ? i : this.firstNonMaskPos;
    },
    handleInputChange(event2) {
      if (this.readonly) {
        return;
      }
      var pos = this.checkVal(true);
      this.caret(pos);
      this.updateModel(event2);
      if (this.isCompleted()) {
        this.$emit("complete", event2);
      }
    },
    getUnmaskedValue() {
      let unmaskedBuffer = [];
      for (let i = 0; i < this.buffer.length; i++) {
        let c = this.buffer[i];
        if (this.tests[i] && c !== this.getPlaceholder(i)) {
          unmaskedBuffer.push(c);
        }
      }
      return unmaskedBuffer.join("");
    },
    updateModel(e) {
      let val = this.unmask ? this.getUnmaskedValue() : e.target.value;
      this.$emit("update:modelValue", this.defaultBuffer !== val ? val : "");
    },
    updateValue(updateModel = true) {
      if (this.$el) {
        if (this.modelValue == null) {
          this.$el.value = "";
          updateModel && this.$emit("update:modelValue", "");
        } else {
          this.$el.value = this.modelValue;
          this.checkVal();
          setTimeout(() => {
            if (this.$el) {
              this.writeBuffer();
              this.checkVal();
              if (updateModel) {
                let val = this.unmask ? this.getUnmaskedValue() : this.$el.value;
                this.$emit("update:modelValue", this.defaultBuffer !== val ? val : "");
              }
            }
          }, 10);
        }
        this.focusText = this.$el.value;
      }
    },
    initMask() {
      this.tests = [];
      this.partialPosition = this.mask.length;
      this.len = this.mask.length;
      this.firstNonMaskPos = null;
      this.defs = {
        9: "[0-9]",
        a: "[A-Za-z]",
        "*": "[A-Za-z0-9]"
      };
      let ua = DomHandler.getUserAgent();
      this.androidChrome = /chrome/i.test(ua) && /android/i.test(ua);
      let maskTokens = this.mask.split("");
      for (let i = 0; i < maskTokens.length; i++) {
        let c = maskTokens[i];
        if (c === "?") {
          this.len--;
          this.partialPosition = i;
        } else if (this.defs[c]) {
          this.tests.push(new RegExp(this.defs[c]));
          if (this.firstNonMaskPos === null) {
            this.firstNonMaskPos = this.tests.length - 1;
          }
          if (i < this.partialPosition) {
            this.lastRequiredNonMaskPos = this.tests.length - 1;
          }
        } else {
          this.tests.push(null);
        }
      }
      this.buffer = [];
      for (let i = 0; i < maskTokens.length; i++) {
        let c = maskTokens[i];
        if (c !== "?") {
          if (this.defs[c])
            this.buffer.push(this.getPlaceholder(i));
          else
            this.buffer.push(c);
        }
      }
      this.defaultBuffer = this.buffer.join("");
      this.updateValue(false);
    },
    isValueUpdated() {
      return this.unmask ? this.modelValue != this.getUnmaskedValue() : this.defaultBuffer !== this.$el.value && this.$el.value !== this.modelValue;
    }
  },
  computed: {
    filled() {
      return this.modelValue != null && this.modelValue.toString().length > 0;
    },
    inputClass() {
      return [
        "p-inputmask p-inputtext p-component",
        {
          "p-filled": this.filled
        }
      ];
    }
  }
};
const _hoisted_1$q = ["readonly"];
function render$t(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("input", mergeProps({
    class: $options.inputClass,
    readonly: $props.readonly,
    onInput: _cache[0] || (_cache[0] = (...args) => $options.onInput && $options.onInput(...args)),
    onFocus: _cache[1] || (_cache[1] = (...args) => $options.onFocus && $options.onFocus(...args)),
    onBlur: _cache[2] || (_cache[2] = (...args) => $options.onBlur && $options.onBlur(...args)),
    onKeydown: _cache[3] || (_cache[3] = (...args) => $options.onKeyDown && $options.onKeyDown(...args)),
    onKeypress: _cache[4] || (_cache[4] = (...args) => $options.onKeyPress && $options.onKeyPress(...args)),
    onPaste: _cache[5] || (_cache[5] = (...args) => $options.onPaste && $options.onPaste(...args))
  }, _ctx.ptm("root")), null, 16, _hoisted_1$q);
}
script$t.render = render$t;
var script$s = {
  name: "MinusIcon",
  extends: script$V
};
const _hoisted_1$p = /* @__PURE__ */ createElementVNode("path", {
  d: "M13.2222 7.77778H0.777778C0.571498 7.77778 0.373667 7.69584 0.227806 7.54998C0.0819442 7.40412 0 7.20629 0 7.00001C0 6.79373 0.0819442 6.5959 0.227806 6.45003C0.373667 6.30417 0.571498 6.22223 0.777778 6.22223H13.2222C13.4285 6.22223 13.6263 6.30417 13.7722 6.45003C13.9181 6.5959 14 6.79373 14 7.00001C14 7.20629 13.9181 7.40412 13.7722 7.54998C13.6263 7.69584 13.4285 7.77778 13.2222 7.77778Z",
  fill: "currentColor"
}, null, -1);
const _hoisted_2$h = [
  _hoisted_1$p
];
function render$s(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("svg", mergeProps({
    width: "14",
    height: "14",
    viewBox: "0 0 14 14",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, _ctx.pti()), _hoisted_2$h, 16);
}
script$s.render = render$s;
var script$r = {
  name: "PlusIcon",
  extends: script$V
};
const _hoisted_1$o = /* @__PURE__ */ createElementVNode("g", { "clip-path": "url(#clip0_306_11939)" }, [
  /* @__PURE__ */ createElementVNode("path", {
    d: "M7.67742 6.32258V0.677419C7.67742 0.497757 7.60605 0.325452 7.47901 0.198411C7.35197 0.0713707 7.17966 0 7 0C6.82034 0 6.64803 0.0713707 6.52099 0.198411C6.39395 0.325452 6.32258 0.497757 6.32258 0.677419V6.32258H0.677419C0.497757 6.32258 0.325452 6.39395 0.198411 6.52099C0.0713707 6.64803 0 6.82034 0 7C0 7.17966 0.0713707 7.35197 0.198411 7.47901C0.325452 7.60605 0.497757 7.67742 0.677419 7.67742H6.32258V13.3226C6.32492 13.5015 6.39704 13.6725 6.52358 13.799C6.65012 13.9255 6.82106 13.9977 7 14C7.17966 14 7.35197 13.9286 7.47901 13.8016C7.60605 13.6745 7.67742 13.5022 7.67742 13.3226V7.67742H13.3226C13.5022 7.67742 13.6745 7.60605 13.8016 7.47901C13.9286 7.35197 14 7.17966 14 7C13.9977 6.82106 13.9255 6.65012 13.799 6.52358C13.6725 6.39704 13.5015 6.32492 13.3226 6.32258H7.67742Z",
    fill: "currentColor"
  })
], -1);
const _hoisted_2$g = /* @__PURE__ */ createElementVNode("defs", null, [
  /* @__PURE__ */ createElementVNode("clipPath", { id: "clip0_306_11939" }, [
    /* @__PURE__ */ createElementVNode("rect", {
      width: "14",
      height: "14",
      fill: "white"
    })
  ])
], -1);
const _hoisted_3$d = [
  _hoisted_1$o,
  _hoisted_2$g
];
function render$r(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("svg", mergeProps({
    width: "14",
    height: "14",
    viewBox: "0 0 14 14",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, _ctx.pti()), _hoisted_3$d, 16);
}
script$r.render = render$r;
var script$q = {
  name: "Panel",
  extends: script$W,
  emits: ["update:collapsed", "toggle"],
  props: {
    header: String,
    toggleable: Boolean,
    collapsed: Boolean,
    toggleButtonProps: {
      type: null,
      default: null
    }
  },
  data() {
    return {
      d_collapsed: this.collapsed
    };
  },
  watch: {
    collapsed(newValue) {
      this.d_collapsed = newValue;
    }
  },
  methods: {
    toggle(event2) {
      this.d_collapsed = !this.d_collapsed;
      this.$emit("update:collapsed", this.d_collapsed);
      this.$emit("toggle", {
        originalEvent: event2,
        value: this.d_collapsed
      });
    },
    onKeyDown(event2) {
      if (event2.code === "Enter" || event2.code === "Space") {
        this.toggle(event2);
        event2.preventDefault();
      }
    }
  },
  computed: {
    ariaId() {
      return UniqueComponentId();
    },
    containerClass() {
      return ["p-panel p-component", { "p-panel-toggleable": this.toggleable }];
    },
    buttonAriaLabel() {
      return this.toggleButtonProps && this.toggleButtonProps["aria-label"] ? this.toggleButtonProps["aria-label"] : this.header;
    }
  },
  components: {
    PlusIcon: script$r,
    MinusIcon: script$s
  },
  directives: {
    ripple: Ripple
  }
};
const _hoisted_1$n = ["id"];
const _hoisted_2$f = ["id", "aria-label", "aria-controls", "aria-expanded"];
const _hoisted_3$c = ["id", "aria-labelledby"];
function render$q(_ctx, _cache, $props, $setup, $data, $options) {
  const _directive_ripple = resolveDirective("ripple");
  return openBlock(), createElementBlock("div", mergeProps({ class: $options.containerClass }, _ctx.ptm("root")), [
    createElementVNode("div", mergeProps({ class: "p-panel-header" }, _ctx.ptm("header")), [
      renderSlot(_ctx.$slots, "header", {
        id: $options.ariaId + "_header",
        class: "p-panel-title"
      }, () => [
        $props.header ? (openBlock(), createElementBlock("span", mergeProps({
          key: 0,
          id: $options.ariaId + "_header",
          class: "p-panel-title"
        }, _ctx.ptm("title")), toDisplayString($props.header), 17, _hoisted_1$n)) : createCommentVNode("", true)
      ]),
      createElementVNode("div", mergeProps({ class: "p-panel-icons" }, _ctx.ptm("icons")), [
        renderSlot(_ctx.$slots, "icons"),
        $props.toggleable ? withDirectives((openBlock(), createElementBlock("button", mergeProps({
          key: 0,
          id: $options.ariaId + "_header",
          type: "button",
          role: "button",
          class: "p-panel-header-icon p-panel-toggler p-link",
          "aria-label": $options.buttonAriaLabel,
          "aria-controls": $options.ariaId + "_content",
          "aria-expanded": !$data.d_collapsed,
          onClick: _cache[0] || (_cache[0] = (...args) => $options.toggle && $options.toggle(...args)),
          onKeydown: _cache[1] || (_cache[1] = (...args) => $options.onKeyDown && $options.onKeyDown(...args))
        }, { ...$props.toggleButtonProps, ..._ctx.ptm("toggler") }), [
          renderSlot(_ctx.$slots, "togglericon", { collapsed: $data.d_collapsed }, () => [
            (openBlock(), createBlock(resolveDynamicComponent($data.d_collapsed ? "PlusIcon" : "MinusIcon"), normalizeProps(guardReactiveProps(_ctx.ptm("togglericon"))), null, 16))
          ])
        ], 16, _hoisted_2$f)), [
          [_directive_ripple]
        ]) : createCommentVNode("", true)
      ], 16)
    ], 16),
    createVNode(Transition, { name: "p-toggleable-content" }, {
      default: withCtx(() => [
        withDirectives(createElementVNode("div", mergeProps({
          id: $options.ariaId + "_content",
          class: "p-toggleable-content",
          role: "region",
          "aria-labelledby": $options.ariaId + "_header"
        }, _ctx.ptm("toggleablecontent")), [
          createElementVNode("div", mergeProps({ class: "p-panel-content" }, _ctx.ptm("content")), [
            renderSlot(_ctx.$slots, "default")
          ], 16),
          _ctx.$slots.footer ? (openBlock(), createElementBlock("div", mergeProps({
            key: 0,
            class: "p-panel-footer"
          }, _ctx.ptm("footer")), [
            renderSlot(_ctx.$slots, "footer")
          ], 16)) : createCommentVNode("", true)
        ], 16, _hoisted_3$c), [
          [vShow, !$data.d_collapsed]
        ])
      ]),
      _: 3
    })
  ], 16);
}
function styleInject$6(css, ref2) {
  if (ref2 === void 0)
    ref2 = {};
  var insertAt = ref2.insertAt;
  if (!css || true) {
    return;
  }
  var head = document.head || document.getElementsByTagName("head")[0];
  var style = document.createElement("style");
  style.type = "text/css";
  if (insertAt === "top") {
    if (head.firstChild) {
      head.insertBefore(style, head.firstChild);
    } else {
      head.appendChild(style);
    }
  } else {
    head.appendChild(style);
  }
  if (style.styleSheet) {
    style.styleSheet.cssText = css;
  } else {
    style.appendChild(document.createTextNode(css));
  }
}
var css_248z$6 = "\n.p-panel-header {\n    display: flex;\n    justify-content: space-between;\n    align-items: center;\n}\n.p-panel-title {\n    line-height: 1;\n}\n.p-panel-header-icon {\n    display: inline-flex;\n    justify-content: center;\n    align-items: center;\n    cursor: pointer;\n    text-decoration: none;\n    overflow: hidden;\n    position: relative;\n}\n";
styleInject$6(css_248z$6);
script$q.render = render$q;
var script$p = {
  name: "ArrowDownIcon",
  extends: script$V
};
const _hoisted_1$m = /* @__PURE__ */ createElementVNode("g", { "clip-path": "url(#clip0_326_12468)" }, [
  /* @__PURE__ */ createElementVNode("path", {
    "fill-rule": "evenodd",
    "clip-rule": "evenodd",
    d: "M6.99994 14C6.91097 14.0004 6.82281 13.983 6.74064 13.9489C6.65843 13.9148 6.58387 13.8646 6.52133 13.8013L1.10198 8.38193C0.982318 8.25351 0.917175 8.08367 0.920272 7.90817C0.923368 7.73267 0.994462 7.56523 1.11858 7.44111C1.24269 7.317 1.41014 7.2459 1.58563 7.2428C1.76113 7.23971 1.93098 7.30485 2.0594 7.42451L6.32263 11.6877V0.677419C6.32263 0.497756 6.394 0.325452 6.52104 0.198411C6.64808 0.0713706 6.82039 0 7.00005 0C7.17971 0 7.35202 0.0713706 7.47906 0.198411C7.6061 0.325452 7.67747 0.497756 7.67747 0.677419V11.6877L11.9407 7.42451C12.0691 7.30485 12.2389 7.23971 12.4144 7.2428C12.5899 7.2459 12.7574 7.317 12.8815 7.44111C13.0056 7.56523 13.0767 7.73267 13.0798 7.90817C13.0829 8.08367 13.0178 8.25351 12.8981 8.38193L7.47875 13.8013C7.41621 13.8646 7.34164 13.9148 7.25944 13.9489C7.17727 13.983 7.08912 14.0004 7.00015 14C7.00012 14 7.00009 14 7.00005 14C7.00001 14 6.99998 14 6.99994 14Z",
    fill: "currentColor"
  })
], -1);
const _hoisted_2$e = /* @__PURE__ */ createElementVNode("defs", null, [
  /* @__PURE__ */ createElementVNode("clipPath", { id: "clip0_326_12468" }, [
    /* @__PURE__ */ createElementVNode("rect", {
      width: "14",
      height: "14",
      fill: "white"
    })
  ])
], -1);
const _hoisted_3$b = [
  _hoisted_1$m,
  _hoisted_2$e
];
function render$p(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("svg", mergeProps({
    width: "14",
    height: "14",
    viewBox: "0 0 14 14",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, _ctx.pti()), _hoisted_3$b, 16);
}
script$p.render = render$p;
var script$o = {
  name: "ArrowUpIcon",
  extends: script$V
};
const _hoisted_1$l = /* @__PURE__ */ createElementVNode("g", { "clip-path": "url(#clip0_326_12509)" }, [
  /* @__PURE__ */ createElementVNode("path", {
    "fill-rule": "evenodd",
    "clip-rule": "evenodd",
    d: "M6.51551 13.799C6.64205 13.9255 6.813 13.9977 6.99193 14C7.17087 13.9977 7.34182 13.9255 7.46835 13.799C7.59489 13.6725 7.66701 13.5015 7.66935 13.3226V2.31233L11.9326 6.57554C11.9951 6.63887 12.0697 6.68907 12.1519 6.72319C12.2341 6.75731 12.3223 6.77467 12.4113 6.77425C12.5003 6.77467 12.5885 6.75731 12.6707 6.72319C12.7529 6.68907 12.8274 6.63887 12.89 6.57554C13.0168 6.44853 13.0881 6.27635 13.0881 6.09683C13.0881 5.91732 13.0168 5.74514 12.89 5.61812L7.48846 0.216594C7.48274 0.210436 7.4769 0.204374 7.47094 0.198411C7.3439 0.0713707 7.1716 0 6.99193 0C6.81227 0 6.63997 0.0713707 6.51293 0.198411C6.50704 0.204296 6.50128 0.210278 6.49563 0.216354L1.09386 5.61812C0.974201 5.74654 0.909057 5.91639 0.912154 6.09189C0.91525 6.26738 0.986345 6.43483 1.11046 6.55894C1.23457 6.68306 1.40202 6.75415 1.57752 6.75725C1.75302 6.76035 1.92286 6.6952 2.05128 6.57554L6.31451 2.31231V13.3226C6.31685 13.5015 6.38898 13.6725 6.51551 13.799Z",
    fill: "currentColor"
  })
], -1);
const _hoisted_2$d = /* @__PURE__ */ createElementVNode("defs", null, [
  /* @__PURE__ */ createElementVNode("clipPath", { id: "clip0_326_12509" }, [
    /* @__PURE__ */ createElementVNode("rect", {
      width: "14",
      height: "14",
      fill: "white"
    })
  ])
], -1);
const _hoisted_3$a = [
  _hoisted_1$l,
  _hoisted_2$d
];
function render$o(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("svg", mergeProps({
    width: "14",
    height: "14",
    viewBox: "0 0 14 14",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, _ctx.pti()), _hoisted_3$a, 16);
}
script$o.render = render$o;
var script$n = {
  name: "AngleDoubleLeftIcon",
  extends: script$V
};
const _hoisted_1$k = /* @__PURE__ */ createElementVNode("path", {
  "fill-rule": "evenodd",
  "clip-rule": "evenodd",
  d: "M5.71602 11.164C5.80782 11.2021 5.9063 11.2215 6.00569 11.221C6.20216 11.2301 6.39427 11.1612 6.54025 11.0294C6.68191 10.8875 6.76148 10.6953 6.76148 10.4948C6.76148 10.2943 6.68191 10.1021 6.54025 9.96024L3.51441 6.9344L6.54025 3.90855C6.624 3.76126 6.65587 3.59011 6.63076 3.42254C6.60564 3.25498 6.525 3.10069 6.40175 2.98442C6.2785 2.86815 6.11978 2.79662 5.95104 2.7813C5.78229 2.76598 5.61329 2.80776 5.47112 2.89994L1.97123 6.39983C1.82957 6.54167 1.75 6.73393 1.75 6.9344C1.75 7.13486 1.82957 7.32712 1.97123 7.46896L5.47112 10.9991C5.54096 11.0698 5.62422 11.1259 5.71602 11.164ZM11.0488 10.9689C11.1775 11.1156 11.3585 11.2061 11.5531 11.221C11.7477 11.2061 11.9288 11.1156 12.0574 10.9689C12.1815 10.8302 12.25 10.6506 12.25 10.4645C12.25 10.2785 12.1815 10.0989 12.0574 9.96024L9.03158 6.93439L12.0574 3.90855C12.1248 3.76739 12.1468 3.60881 12.1204 3.45463C12.0939 3.30045 12.0203 3.15826 11.9097 3.04765C11.7991 2.93703 11.6569 2.86343 11.5027 2.83698C11.3486 2.81053 11.19 2.83252 11.0488 2.89994L7.51865 6.36957C7.37699 6.51141 7.29742 6.70367 7.29742 6.90414C7.29742 7.1046 7.37699 7.29686 7.51865 7.4387L11.0488 10.9689Z",
  fill: "currentColor"
}, null, -1);
const _hoisted_2$c = [
  _hoisted_1$k
];
function render$n(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("svg", mergeProps({
    width: "14",
    height: "14",
    viewBox: "0 0 14 14",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, _ctx.pti()), _hoisted_2$c, 16);
}
script$n.render = render$n;
var script$m = {
  name: "AngleDoubleRightIcon",
  extends: script$V
};
const _hoisted_1$j = /* @__PURE__ */ createElementVNode("path", {
  "fill-rule": "evenodd",
  "clip-rule": "evenodd",
  d: "M7.68757 11.1451C7.7791 11.1831 7.8773 11.2024 7.9764 11.2019C8.07769 11.1985 8.17721 11.1745 8.26886 11.1312C8.36052 11.088 8.44238 11.0265 8.50943 10.9505L12.0294 7.49085C12.1707 7.34942 12.25 7.15771 12.25 6.95782C12.25 6.75794 12.1707 6.56622 12.0294 6.42479L8.50943 2.90479C8.37014 2.82159 8.20774 2.78551 8.04633 2.80192C7.88491 2.81833 7.73309 2.88635 7.6134 2.99588C7.4937 3.10541 7.41252 3.25061 7.38189 3.40994C7.35126 3.56927 7.37282 3.73423 7.44337 3.88033L10.4605 6.89748L7.44337 9.91463C7.30212 10.0561 7.22278 10.2478 7.22278 10.4477C7.22278 10.6475 7.30212 10.8393 7.44337 10.9807C7.51301 11.0512 7.59603 11.1071 7.68757 11.1451ZM1.94207 10.9505C2.07037 11.0968 2.25089 11.1871 2.44493 11.2019C2.63898 11.1871 2.81949 11.0968 2.94779 10.9505L6.46779 7.49085C6.60905 7.34942 6.68839 7.15771 6.68839 6.95782C6.68839 6.75793 6.60905 6.56622 6.46779 6.42479L2.94779 2.90479C2.80704 2.83757 2.6489 2.81563 2.49517 2.84201C2.34143 2.86839 2.19965 2.94178 2.08936 3.05207C1.97906 3.16237 1.90567 3.30415 1.8793 3.45788C1.85292 3.61162 1.87485 3.76975 1.94207 3.9105L4.95922 6.92765L1.94207 9.9448C1.81838 10.0831 1.75 10.2621 1.75 10.4477C1.75 10.6332 1.81838 10.8122 1.94207 10.9505Z",
  fill: "currentColor"
}, null, -1);
const _hoisted_2$b = [
  _hoisted_1$j
];
function render$m(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("svg", mergeProps({
    width: "14",
    height: "14",
    viewBox: "0 0 14 14",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, _ctx.pti()), _hoisted_2$b, 16);
}
script$m.render = render$m;
var script$l = {
  name: "AngleRightIcon",
  extends: script$V
};
const _hoisted_1$i = /* @__PURE__ */ createElementVNode("path", {
  d: "M5.25 11.1728C5.14929 11.1694 5.05033 11.1455 4.9592 11.1025C4.86806 11.0595 4.78666 10.9984 4.72 10.9228C4.57955 10.7822 4.50066 10.5916 4.50066 10.3928C4.50066 10.1941 4.57955 10.0035 4.72 9.86283L7.72 6.86283L4.72 3.86283C4.66067 3.71882 4.64765 3.55991 4.68275 3.40816C4.71785 3.25642 4.79932 3.11936 4.91585 3.01602C5.03238 2.91268 5.17819 2.84819 5.33305 2.83149C5.4879 2.81479 5.64411 2.84671 5.78 2.92283L9.28 6.42283C9.42045 6.56346 9.49934 6.75408 9.49934 6.95283C9.49934 7.15158 9.42045 7.34221 9.28 7.48283L5.78 10.9228C5.71333 10.9984 5.63193 11.0595 5.5408 11.1025C5.44966 11.1455 5.35071 11.1694 5.25 11.1728Z",
  fill: "currentColor"
}, null, -1);
const _hoisted_2$a = [
  _hoisted_1$i
];
function render$l(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("svg", mergeProps({
    width: "14",
    height: "14",
    viewBox: "0 0 14 14",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, _ctx.pti()), _hoisted_2$a, 16);
}
script$l.render = render$l;
var script$k = {
  name: "AngleLeftIcon",
  extends: script$V
};
const _hoisted_1$h = /* @__PURE__ */ createElementVNode("path", {
  d: "M8.75 11.185C8.65146 11.1854 8.55381 11.1662 8.4628 11.1284C8.37179 11.0906 8.28924 11.0351 8.22 10.965L4.72 7.46496C4.57955 7.32433 4.50066 7.13371 4.50066 6.93496C4.50066 6.73621 4.57955 6.54558 4.72 6.40496L8.22 2.93496C8.36095 2.84357 8.52851 2.80215 8.69582 2.81733C8.86312 2.83252 9.02048 2.90344 9.14268 3.01872C9.26487 3.134 9.34483 3.28696 9.36973 3.4531C9.39463 3.61924 9.36303 3.78892 9.28 3.93496L6.28 6.93496L9.28 9.93496C9.42045 10.0756 9.49934 10.2662 9.49934 10.465C9.49934 10.6637 9.42045 10.8543 9.28 10.995C9.13526 11.1257 8.9448 11.1939 8.75 11.185Z",
  fill: "currentColor"
}, null, -1);
const _hoisted_2$9 = [
  _hoisted_1$h
];
function render$k(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("svg", mergeProps({
    width: "14",
    height: "14",
    viewBox: "0 0 14 14",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, _ctx.pti()), _hoisted_2$9, 16);
}
script$k.render = render$k;
var script$9$2 = {
  name: "CurrentPageReport",
  extends: script$W,
  props: {
    pageCount: {
      type: Number,
      default: 0
    },
    currentPage: {
      type: Number,
      default: 0
    },
    page: {
      type: Number,
      default: 0
    },
    first: {
      type: Number,
      default: 0
    },
    rows: {
      type: Number,
      default: 0
    },
    totalRecords: {
      type: Number,
      default: 0
    },
    template: {
      type: String,
      default: "({currentPage} of {totalPages})"
    }
  },
  computed: {
    text() {
      let text = this.template.replace("{currentPage}", this.currentPage).replace("{totalPages}", this.pageCount).replace("{first}", this.pageCount > 0 ? this.first + 1 : 0).replace("{last}", Math.min(this.first + this.rows, this.totalRecords)).replace("{rows}", this.rows).replace("{totalRecords}", this.totalRecords);
      return text;
    }
  }
};
function render$9$1(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("span", mergeProps({ class: "p-paginator-current" }, _ctx.ptm("current")), toDisplayString($options.text), 17);
}
script$9$2.render = render$9$1;
var script$8$2 = {
  name: "FirstPageLink",
  extends: script$W,
  props: {
    template: {
      type: Function,
      default: null
    }
  },
  methods: {
    getPTOptions(key) {
      return this.ptm(key, {
        context: {
          disabled: this.$attrs.disabled
        }
      });
    }
  },
  computed: {
    containerClass() {
      return [
        "p-paginator-first p-paginator-element p-link",
        {
          "p-disabled": this.$attrs.disabled
        }
      ];
    }
  },
  components: {
    AngleDoubleLeftIcon: script$n
  },
  directives: {
    ripple: Ripple
  }
};
function render$8$2(_ctx, _cache, $props, $setup, $data, $options) {
  const _directive_ripple = resolveDirective("ripple");
  return withDirectives((openBlock(), createElementBlock("button", mergeProps({
    class: $options.containerClass,
    type: "button"
  }, $options.getPTOptions("firstPageButton")), [
    (openBlock(), createBlock(resolveDynamicComponent($props.template || "AngleDoubleLeftIcon"), mergeProps({ class: "p-paginator-icon" }, $options.getPTOptions("firstPageIcon")), null, 16))
  ], 16)), [
    [_directive_ripple]
  ]);
}
script$8$2.render = render$8$2;
var script$7$2 = {
  name: "JumpToPageDropdown",
  extends: script$W,
  emits: ["page-change"],
  props: {
    page: Number,
    pageCount: Number,
    disabled: Boolean
  },
  methods: {
    onChange(value) {
      this.$emit("page-change", value);
    }
  },
  computed: {
    pageOptions() {
      let opts = [];
      for (let i = 0; i < this.pageCount; i++) {
        opts.push({ label: String(i + 1), value: i });
      }
      return opts;
    }
  },
  components: {
    JTPDropdown: script$A
  }
};
function render$7$2(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_JTPDropdown = resolveComponent("JTPDropdown");
  return openBlock(), createBlock(_component_JTPDropdown, {
    modelValue: $props.page,
    options: $options.pageOptions,
    optionLabel: "label",
    optionValue: "value",
    "onUpdate:modelValue": _cache[0] || (_cache[0] = ($event) => $options.onChange($event)),
    class: "p-paginator-page-options",
    disabled: $props.disabled,
    pt: _ctx.ptm("JTPDropdown")
  }, null, 8, ["modelValue", "options", "disabled", "pt"]);
}
script$7$2.render = render$7$2;
var script$6$2 = {
  name: "JumpToPageInput",
  extends: script$W,
  inheritAttrs: false,
  emits: ["page-change"],
  props: {
    page: Number,
    pageCount: Number,
    disabled: Boolean
  },
  data() {
    return {
      d_page: this.page
    };
  },
  watch: {
    page(newValue) {
      this.d_page = newValue;
    }
  },
  methods: {
    onChange(value) {
      if (value !== this.page) {
        this.d_page = value;
        this.$emit("page-change", value - 1);
      }
    }
  },
  computed: {
    inputArialabel() {
      return this.$primevue.config.locale.aria ? this.$primevue.config.locale.aria.jumpToPageInputLabel : void 0;
    }
  },
  components: {
    JTPInput: script$u
  }
};
function render$6$2(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_JTPInput = resolveComponent("JTPInput");
  return openBlock(), createBlock(_component_JTPInput, {
    ref: "jtpInput",
    modelValue: $data.d_page,
    class: "p-paginator-page-input",
    "aria-label": $options.inputArialabel,
    disabled: $props.disabled,
    "onUpdate:modelValue": $options.onChange,
    pt: _ctx.ptm("JTPInput")
  }, null, 8, ["modelValue", "aria-label", "disabled", "onUpdate:modelValue", "pt"]);
}
script$6$2.render = render$6$2;
var script$5$2 = {
  name: "LastPageLink",
  extends: script$W,
  props: {
    template: {
      type: Function,
      default: null
    }
  },
  methods: {
    getPTOptions(key) {
      return this.ptm(key, {
        context: {
          disabled: this.$attrs.disabled
        }
      });
    }
  },
  computed: {
    containerClass() {
      return [
        "p-paginator-last p-paginator-element p-link",
        {
          "p-disabled": this.$attrs.disabled
        }
      ];
    }
  },
  components: {
    AngleDoubleRightIcon: script$m
  },
  directives: {
    ripple: Ripple
  }
};
function render$5$2(_ctx, _cache, $props, $setup, $data, $options) {
  const _directive_ripple = resolveDirective("ripple");
  return withDirectives((openBlock(), createElementBlock("button", mergeProps({
    class: $options.containerClass,
    type: "button"
  }, $options.getPTOptions("lastPageButton")), [
    (openBlock(), createBlock(resolveDynamicComponent($props.template || "AngleDoubleRightIcon"), mergeProps({ class: "p-paginator-icon" }, $options.getPTOptions("lastPageIcon")), null, 16))
  ], 16)), [
    [_directive_ripple]
  ]);
}
script$5$2.render = render$5$2;
var script$4$2 = {
  name: "NextPageLink",
  extends: script$W,
  props: {
    template: {
      type: Function,
      default: null
    }
  },
  methods: {
    getPTOptions(key) {
      return this.ptm(key, {
        context: {
          disabled: this.$attrs.disabled
        }
      });
    }
  },
  computed: {
    containerClass() {
      return [
        "p-paginator-next p-paginator-element p-link",
        {
          "p-disabled": this.$attrs.disabled
        }
      ];
    }
  },
  components: {
    AngleRightIcon: script$l
  },
  directives: {
    ripple: Ripple
  }
};
function render$4$2(_ctx, _cache, $props, $setup, $data, $options) {
  const _directive_ripple = resolveDirective("ripple");
  return withDirectives((openBlock(), createElementBlock("button", mergeProps({
    class: $options.containerClass,
    type: "button"
  }, $options.getPTOptions("nextPageButton")), [
    (openBlock(), createBlock(resolveDynamicComponent($props.template || "AngleRightIcon"), mergeProps({ class: "p-paginator-icon" }, $options.getPTOptions("nextPageIcon")), null, 16))
  ], 16)), [
    [_directive_ripple]
  ]);
}
script$4$2.render = render$4$2;
var script$3$2 = {
  name: "PageLinks",
  extends: script$W,
  inheritAttrs: false,
  emits: ["click"],
  props: {
    value: Array,
    page: Number
  },
  methods: {
    getPTOptions(pageLink, key) {
      return this.ptm(key, {
        context: {
          active: pageLink === this.page
        }
      });
    },
    onPageLinkClick(event2, pageLink) {
      this.$emit("click", {
        originalEvent: event2,
        value: pageLink
      });
    },
    ariaPageLabel(value) {
      return this.$primevue.config.locale.aria ? this.$primevue.config.locale.aria.pageLabel.replace(/{page}/g, value) : void 0;
    }
  },
  directives: {
    ripple: Ripple
  }
};
const _hoisted_1$g = ["aria-label", "aria-current", "onClick"];
function render$3$2(_ctx, _cache, $props, $setup, $data, $options) {
  const _directive_ripple = resolveDirective("ripple");
  return openBlock(), createElementBlock("span", mergeProps({ class: "p-paginator-pages" }, _ctx.ptm("pages")), [
    (openBlock(true), createElementBlock(Fragment, null, renderList($props.value, (pageLink) => {
      return withDirectives((openBlock(), createElementBlock("button", mergeProps({
        key: pageLink,
        class: ["p-paginator-page p-paginator-element p-link", { "p-highlight": pageLink - 1 === $props.page }],
        type: "button",
        "aria-label": $options.ariaPageLabel(pageLink),
        "aria-current": pageLink - 1 === $props.page ? "page" : void 0,
        onClick: ($event) => $options.onPageLinkClick($event, pageLink)
      }, $options.getPTOptions(pageLink - 1, "pageButton")), [
        createTextVNode(toDisplayString(pageLink), 1)
      ], 16, _hoisted_1$g)), [
        [_directive_ripple]
      ]);
    }), 128))
  ], 16);
}
script$3$2.render = render$3$2;
var script$2$2 = {
  name: "PrevPageLink",
  extends: script$W,
  props: {
    template: {
      type: Function,
      default: null
    }
  },
  methods: {
    getPTOptions(key) {
      return this.ptm(key, {
        context: {
          disabled: this.$attrs.disabled
        }
      });
    }
  },
  computed: {
    containerClass() {
      return [
        "p-paginator-prev p-paginator-element p-link",
        {
          "p-disabled": this.$attrs.disabled
        }
      ];
    }
  },
  components: {
    AngleLeftIcon: script$k
  },
  directives: {
    ripple: Ripple
  }
};
function render$2$2(_ctx, _cache, $props, $setup, $data, $options) {
  const _directive_ripple = resolveDirective("ripple");
  return withDirectives((openBlock(), createElementBlock("button", mergeProps({
    class: $options.containerClass,
    type: "button"
  }, $options.getPTOptions("prevPageButton")), [
    (openBlock(), createBlock(resolveDynamicComponent($props.template || "AngleLeftIcon"), mergeProps({ class: "p-paginator-icon" }, $options.getPTOptions("prevPageIcon")), null, 16))
  ], 16)), [
    [_directive_ripple]
  ]);
}
script$2$2.render = render$2$2;
var script$1$2 = {
  name: "RowsPerPageDropdown",
  extends: script$W,
  emits: ["rows-change"],
  props: {
    options: Array,
    rows: Number,
    disabled: Boolean
  },
  methods: {
    onChange(value) {
      this.$emit("rows-change", value);
    }
  },
  computed: {
    rowsOptions() {
      let opts = [];
      if (this.options) {
        for (let i = 0; i < this.options.length; i++) {
          opts.push({ label: String(this.options[i]), value: this.options[i] });
        }
      }
      return opts;
    }
  },
  components: {
    RPPDropdown: script$A
  }
};
function render$1$2(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_RPPDropdown = resolveComponent("RPPDropdown");
  return openBlock(), createBlock(_component_RPPDropdown, {
    modelValue: $props.rows,
    options: $options.rowsOptions,
    optionLabel: "label",
    optionValue: "value",
    "onUpdate:modelValue": _cache[0] || (_cache[0] = ($event) => $options.onChange($event)),
    class: "p-paginator-rpp-options",
    disabled: $props.disabled,
    pt: _ctx.ptm("RPPDropdown")
  }, null, 8, ["modelValue", "options", "disabled", "pt"]);
}
script$1$2.render = render$1$2;
var script$j = {
  name: "Paginator",
  extends: script$W,
  emits: ["update:first", "update:rows", "page"],
  props: {
    totalRecords: {
      type: Number,
      default: 0
    },
    rows: {
      type: Number,
      default: 0
    },
    first: {
      type: Number,
      default: 0
    },
    pageLinkSize: {
      type: Number,
      default: 5
    },
    rowsPerPageOptions: {
      type: Array,
      default: null
    },
    template: {
      type: [Object, String],
      default: "FirstPageLink PrevPageLink PageLinks NextPageLink LastPageLink RowsPerPageDropdown"
    },
    currentPageReportTemplate: {
      type: null,
      default: "({currentPage} of {totalPages})"
    },
    alwaysShow: {
      type: Boolean,
      default: true
    }
  },
  data() {
    return {
      d_first: this.first,
      d_rows: this.rows
    };
  },
  watch: {
    first(newValue) {
      this.d_first = newValue;
    },
    rows(newValue) {
      this.d_rows = newValue;
    },
    totalRecords(newValue) {
      if (this.page > 0 && newValue && this.d_first >= newValue) {
        this.changePage(this.pageCount - 1);
      }
    }
  },
  mounted() {
    this.setPaginatorAttribute();
    this.createStyle();
  },
  methods: {
    changePage(p) {
      const pc = this.pageCount;
      if (p >= 0 && p < pc) {
        this.d_first = this.d_rows * p;
        const state = {
          page: p,
          first: this.d_first,
          rows: this.d_rows,
          pageCount: pc
        };
        this.$emit("update:first", this.d_first);
        this.$emit("update:rows", this.d_rows);
        this.$emit("page", state);
      }
    },
    changePageToFirst(event2) {
      if (!this.isFirstPage) {
        this.changePage(0);
      }
      event2.preventDefault();
    },
    changePageToPrev(event2) {
      this.changePage(this.page - 1);
      event2.preventDefault();
    },
    changePageLink(event2) {
      this.changePage(event2.value - 1);
      event2.originalEvent.preventDefault();
    },
    changePageToNext(event2) {
      this.changePage(this.page + 1);
      event2.preventDefault();
    },
    changePageToLast(event2) {
      if (!this.isLastPage) {
        this.changePage(this.pageCount - 1);
      }
      event2.preventDefault();
    },
    onRowChange(value) {
      this.d_rows = value;
      this.changePage(this.page);
    },
    createStyle() {
      if (this.hasBreakpoints()) {
        this.styleElement = document.createElement("style");
        this.styleElement.type = "text/css";
        document.head.appendChild(this.styleElement);
        let innerHTML = "";
        const keys = Object.keys(this.template);
        const sortedBreakpoints = {};
        keys.sort((a, b) => parseInt(a) - parseInt(b)).forEach((key) => {
          sortedBreakpoints[key] = this.template[key];
        });
        for (const [index, [key]] of Object.entries(Object.entries(sortedBreakpoints))) {
          const minValue = Object.entries(sortedBreakpoints)[index - 1] ? `and (min-width:${Object.keys(sortedBreakpoints)[index - 1]})` : "";
          if (key === "default") {
            innerHTML += `
                            @media screen ${minValue} {
                                .paginator[${this.attributeSelector}],
                                .p-paginator-default{
                                    display: flex !important;
                                }
                            }
                        `;
          } else {
            innerHTML += `
                        .paginator[${this.attributeSelector}], .p-paginator-${key} {
                                display: none !important;
                            }
                        @media screen ${minValue} and (max-width: ${key}) {
                            .paginator[${this.attributeSelector}], .p-paginator-${key} {
                                display: flex !important;
                            }
                            .paginator[${this.attributeSelector}],
                            .p-paginator-default{
                                display: none !important;
                            }
                        }
                    `;
          }
        }
        this.styleElement.innerHTML = innerHTML;
      }
    },
    hasBreakpoints() {
      return typeof this.template === "object";
    },
    getPaginatorClasses(key) {
      return [
        {
          "p-paginator-default": !this.hasBreakpoints(),
          [`p-paginator-${key}`]: this.hasBreakpoints()
        }
      ];
    },
    setPaginatorAttribute() {
      if (this.$refs.paginator && this.$refs.paginator.length >= 0) {
        [...this.$refs.paginator].forEach((el) => {
          el.setAttribute(this.attributeSelector, "");
        });
      }
    },
    getAriaLabel(labelType) {
      return this.$primevue.config.locale.aria ? this.$primevue.config.locale.aria[labelType] : void 0;
    }
  },
  computed: {
    templateItems() {
      let keys = {};
      if (this.hasBreakpoints()) {
        keys = this.template;
        if (!keys.default) {
          keys.default = "FirstPageLink PrevPageLink PageLinks NextPageLink LastPageLink RowsPerPageDropdown";
        }
        for (const item in keys) {
          keys[item] = this.template[item].split(" ").map((value) => {
            return value.trim();
          });
        }
        return keys;
      }
      keys["default"] = this.template.split(" ").map((value) => {
        return value.trim();
      });
      return keys;
    },
    page() {
      return Math.floor(this.d_first / this.d_rows);
    },
    pageCount() {
      return Math.ceil(this.totalRecords / this.d_rows);
    },
    isFirstPage() {
      return this.page === 0;
    },
    isLastPage() {
      return this.page === this.pageCount - 1;
    },
    calculatePageLinkBoundaries() {
      const numberOfPages = this.pageCount;
      const visiblePages = Math.min(this.pageLinkSize, numberOfPages);
      let start = Math.max(0, Math.ceil(this.page - visiblePages / 2));
      let end = Math.min(numberOfPages - 1, start + visiblePages - 1);
      const delta = this.pageLinkSize - (end - start + 1);
      start = Math.max(0, start - delta);
      return [start, end];
    },
    pageLinks() {
      let pageLinks = [];
      let boundaries = this.calculatePageLinkBoundaries;
      let start = boundaries[0];
      let end = boundaries[1];
      for (var i = start; i <= end; i++) {
        pageLinks.push(i + 1);
      }
      return pageLinks;
    },
    currentState() {
      return {
        page: this.page,
        first: this.d_first,
        rows: this.d_rows
      };
    },
    empty() {
      return this.pageCount === 0;
    },
    currentPage() {
      return this.pageCount > 0 ? this.page + 1 : 0;
    },
    attributeSelector() {
      return UniqueComponentId();
    }
  },
  components: {
    CurrentPageReport: script$9$2,
    FirstPageLink: script$8$2,
    LastPageLink: script$5$2,
    NextPageLink: script$4$2,
    PageLinks: script$3$2,
    PrevPageLink: script$2$2,
    RowsPerPageDropdown: script$1$2,
    JumpToPageDropdown: script$7$2,
    JumpToPageInput: script$6$2
  }
};
function render$j(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_FirstPageLink = resolveComponent("FirstPageLink");
  const _component_PrevPageLink = resolveComponent("PrevPageLink");
  const _component_NextPageLink = resolveComponent("NextPageLink");
  const _component_LastPageLink = resolveComponent("LastPageLink");
  const _component_PageLinks = resolveComponent("PageLinks");
  const _component_CurrentPageReport = resolveComponent("CurrentPageReport");
  const _component_RowsPerPageDropdown = resolveComponent("RowsPerPageDropdown");
  const _component_JumpToPageDropdown = resolveComponent("JumpToPageDropdown");
  const _component_JumpToPageInput = resolveComponent("JumpToPageInput");
  return ($props.alwaysShow ? true : $options.pageLinks && $options.pageLinks.length > 1) ? (openBlock(), createElementBlock("nav", normalizeProps(mergeProps({ key: 0 }, _ctx.ptm("root"))), [
    (openBlock(true), createElementBlock(Fragment, null, renderList($options.templateItems, (value, key) => {
      return openBlock(), createElementBlock("div", mergeProps({
        key,
        ref_for: true,
        ref: "paginator",
        class: ["p-paginator p-component", $options.getPaginatorClasses(key)]
      }, _ctx.ptm("paginator")), [
        _ctx.$slots.start ? (openBlock(), createElementBlock("div", mergeProps({
          key: 0,
          class: "p-paginator-left-content"
        }, _ctx.ptm("left")), [
          renderSlot(_ctx.$slots, "start", { state: $options.currentState })
        ], 16)) : createCommentVNode("", true),
        (openBlock(true), createElementBlock(Fragment, null, renderList(value, (item) => {
          return openBlock(), createElementBlock(Fragment, { key: item }, [
            item === "FirstPageLink" ? (openBlock(), createBlock(_component_FirstPageLink, {
              key: 0,
              "aria-label": $options.getAriaLabel("firstPageLabel"),
              template: _ctx.$slots.firstpagelinkicon,
              onClick: _cache[0] || (_cache[0] = ($event) => $options.changePageToFirst($event)),
              disabled: $options.isFirstPage || $options.empty,
              pt: _ctx.pt
            }, null, 8, ["aria-label", "template", "disabled", "pt"])) : item === "PrevPageLink" ? (openBlock(), createBlock(_component_PrevPageLink, {
              key: 1,
              "aria-label": $options.getAriaLabel("prevPageLabel"),
              template: _ctx.$slots.prevpagelinkicon,
              onClick: _cache[1] || (_cache[1] = ($event) => $options.changePageToPrev($event)),
              disabled: $options.isFirstPage || $options.empty,
              pt: _ctx.pt
            }, null, 8, ["aria-label", "template", "disabled", "pt"])) : item === "NextPageLink" ? (openBlock(), createBlock(_component_NextPageLink, {
              key: 2,
              "aria-label": $options.getAriaLabel("nextPageLabel"),
              template: _ctx.$slots.nextpagelinkicon,
              onClick: _cache[2] || (_cache[2] = ($event) => $options.changePageToNext($event)),
              disabled: $options.isLastPage || $options.empty,
              pt: _ctx.pt
            }, null, 8, ["aria-label", "template", "disabled", "pt"])) : item === "LastPageLink" ? (openBlock(), createBlock(_component_LastPageLink, {
              key: 3,
              "aria-label": $options.getAriaLabel("lastPageLabel"),
              template: _ctx.$slots.lastpagelinkicon,
              onClick: _cache[3] || (_cache[3] = ($event) => $options.changePageToLast($event)),
              disabled: $options.isLastPage || $options.empty,
              pt: _ctx.pt
            }, null, 8, ["aria-label", "template", "disabled", "pt"])) : item === "PageLinks" ? (openBlock(), createBlock(_component_PageLinks, {
              key: 4,
              "aria-label": $options.getAriaLabel("pageLabel"),
              value: $options.pageLinks,
              page: $options.page,
              onClick: _cache[4] || (_cache[4] = ($event) => $options.changePageLink($event)),
              pt: _ctx.pt
            }, null, 8, ["aria-label", "value", "page", "pt"])) : item === "CurrentPageReport" ? (openBlock(), createBlock(_component_CurrentPageReport, {
              key: 5,
              "aria-live": "polite",
              template: $props.currentPageReportTemplate,
              currentPage: $options.currentPage,
              page: $options.page,
              pageCount: $options.pageCount,
              first: $data.d_first,
              rows: $data.d_rows,
              totalRecords: $props.totalRecords,
              pt: _ctx.pt
            }, null, 8, ["template", "currentPage", "page", "pageCount", "first", "rows", "totalRecords", "pt"])) : item === "RowsPerPageDropdown" && $props.rowsPerPageOptions ? (openBlock(), createBlock(_component_RowsPerPageDropdown, {
              key: 6,
              "aria-label": $options.getAriaLabel("rowsPerPageLabel"),
              rows: $data.d_rows,
              options: $props.rowsPerPageOptions,
              onRowsChange: _cache[5] || (_cache[5] = ($event) => $options.onRowChange($event)),
              disabled: $options.empty,
              pt: _ctx.pt
            }, null, 8, ["aria-label", "rows", "options", "disabled", "pt"])) : item === "JumpToPageDropdown" ? (openBlock(), createBlock(_component_JumpToPageDropdown, {
              key: 7,
              "aria-label": $options.getAriaLabel("jumpToPageDropdownLabel"),
              page: $options.page,
              pageCount: $options.pageCount,
              onPageChange: _cache[6] || (_cache[6] = ($event) => $options.changePage($event)),
              disabled: $options.empty,
              pt: _ctx.pt
            }, null, 8, ["aria-label", "page", "pageCount", "disabled", "pt"])) : item === "JumpToPageInput" ? (openBlock(), createBlock(_component_JumpToPageInput, {
              key: 8,
              page: $options.currentPage,
              onPageChange: _cache[7] || (_cache[7] = ($event) => $options.changePage($event)),
              disabled: $options.empty,
              pt: _ctx.pt
            }, null, 8, ["page", "disabled", "pt"])) : createCommentVNode("", true)
          ], 64);
        }), 128)),
        _ctx.$slots.end ? (openBlock(), createElementBlock("div", mergeProps({
          key: 1,
          class: "p-paginator-right-content"
        }, _ctx.ptm("end")), [
          renderSlot(_ctx.$slots, "end", { state: $options.currentState })
        ], 16)) : createCommentVNode("", true)
      ], 16);
    }), 128))
  ], 16)) : createCommentVNode("", true);
}
function styleInject$5(css, ref2) {
  if (ref2 === void 0)
    ref2 = {};
  var insertAt = ref2.insertAt;
  if (!css || true) {
    return;
  }
  var head = document.head || document.getElementsByTagName("head")[0];
  var style = document.createElement("style");
  style.type = "text/css";
  if (insertAt === "top") {
    if (head.firstChild) {
      head.insertBefore(style, head.firstChild);
    } else {
      head.appendChild(style);
    }
  } else {
    head.appendChild(style);
  }
  if (style.styleSheet) {
    style.styleSheet.cssText = css;
  } else {
    style.appendChild(document.createTextNode(css));
  }
}
var css_248z$5 = "\n.p-paginator-default {\n    display: flex;\n}\n.p-paginator {\n    display: flex;\n    align-items: center;\n    justify-content: center;\n    flex-wrap: wrap;\n}\n.p-paginator-left-content {\n    margin-right: auto;\n}\n.p-paginator-right-content {\n    margin-left: auto;\n}\n.p-paginator-page,\n.p-paginator-next,\n.p-paginator-last,\n.p-paginator-first,\n.p-paginator-prev,\n.p-paginator-current {\n    cursor: pointer;\n    display: inline-flex;\n    align-items: center;\n    justify-content: center;\n    line-height: 1;\n    user-select: none;\n    overflow: hidden;\n    position: relative;\n}\n.p-paginator-element:focus {\n    z-index: 1;\n    position: relative;\n}\n";
styleInject$5(css_248z$5);
script$j.render = render$j;
var script$i = {
  name: "BarsIcon",
  extends: script$V
};
const _hoisted_1$f = /* @__PURE__ */ createElementVNode("path", {
  "fill-rule": "evenodd",
  "clip-rule": "evenodd",
  d: "M13.3226 3.6129H0.677419C0.497757 3.6129 0.325452 3.54152 0.198411 3.41448C0.0713707 3.28744 0 3.11514 0 2.93548C0 2.75581 0.0713707 2.58351 0.198411 2.45647C0.325452 2.32943 0.497757 2.25806 0.677419 2.25806H13.3226C13.5022 2.25806 13.6745 2.32943 13.8016 2.45647C13.9286 2.58351 14 2.75581 14 2.93548C14 3.11514 13.9286 3.28744 13.8016 3.41448C13.6745 3.54152 13.5022 3.6129 13.3226 3.6129ZM13.3226 7.67741H0.677419C0.497757 7.67741 0.325452 7.60604 0.198411 7.479C0.0713707 7.35196 0 7.17965 0 6.99999C0 6.82033 0.0713707 6.64802 0.198411 6.52098C0.325452 6.39394 0.497757 6.32257 0.677419 6.32257H13.3226C13.5022 6.32257 13.6745 6.39394 13.8016 6.52098C13.9286 6.64802 14 6.82033 14 6.99999C14 7.17965 13.9286 7.35196 13.8016 7.479C13.6745 7.60604 13.5022 7.67741 13.3226 7.67741ZM0.677419 11.7419H13.3226C13.5022 11.7419 13.6745 11.6706 13.8016 11.5435C13.9286 11.4165 14 11.2442 14 11.0645C14 10.8848 13.9286 10.7125 13.8016 10.5855C13.6745 10.4585 13.5022 10.3871 13.3226 10.3871H0.677419C0.497757 10.3871 0.325452 10.4585 0.198411 10.5855C0.0713707 10.7125 0 10.8848 0 11.0645C0 11.2442 0.0713707 11.4165 0.198411 11.5435C0.325452 11.6706 0.497757 11.7419 0.677419 11.7419Z",
  fill: "currentColor"
}, null, -1);
const _hoisted_2$8 = [
  _hoisted_1$f
];
function render$i(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("svg", mergeProps({
    width: "14",
    height: "14",
    viewBox: "0 0 14 14",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, _ctx.pti()), _hoisted_2$8, 16);
}
script$i.render = render$i;
var script$h = {
  name: "PencilIcon",
  extends: script$V
};
const _hoisted_1$e = /* @__PURE__ */ createElementVNode("g", { "clip-path": "url(#clip0_414_20836)" }, [
  /* @__PURE__ */ createElementVNode("path", {
    d: "M0.609628 13.959C0.530658 13.9599 0.452305 13.9451 0.379077 13.9156C0.305849 13.8861 0.239191 13.8424 0.18294 13.787C0.118447 13.7234 0.0688234 13.6464 0.0376166 13.5614C0.00640987 13.4765 -0.00560954 13.3857 0.00241768 13.2956L0.25679 10.1501C0.267698 10.0041 0.331934 9.86709 0.437312 9.76516L9.51265 0.705715C10.0183 0.233014 10.6911 -0.0203041 11.3835 0.00127367C12.0714 0.00660201 12.7315 0.27311 13.2298 0.746671C13.7076 1.23651 13.9824 1.88848 13.9992 2.57201C14.0159 3.25554 13.7733 3.92015 13.32 4.4327L4.23648 13.5331C4.13482 13.6342 4.0017 13.6978 3.85903 13.7133L0.667067 14L0.609628 13.959ZM1.43018 10.4696L1.25787 12.714L3.50619 12.5092L12.4502 3.56444C12.6246 3.35841 12.7361 3.10674 12.7714 2.83933C12.8067 2.57193 12.7644 2.30002 12.6495 2.05591C12.5346 1.8118 12.3519 1.60575 12.1231 1.46224C11.8943 1.31873 11.6291 1.2438 11.3589 1.24633C11.1813 1.23508 11.0033 1.25975 10.8355 1.31887C10.6677 1.37798 10.5136 1.47033 10.3824 1.59036L1.43018 10.4696Z",
    fill: "currentColor"
  })
], -1);
const _hoisted_2$7 = /* @__PURE__ */ createElementVNode("defs", null, [
  /* @__PURE__ */ createElementVNode("clipPath", { id: "clip0_414_20836" }, [
    /* @__PURE__ */ createElementVNode("rect", {
      width: "14",
      height: "14",
      fill: "white"
    })
  ])
], -1);
const _hoisted_3$9 = [
  _hoisted_1$e,
  _hoisted_2$7
];
function render$h(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("svg", mergeProps({
    width: "14",
    height: "14",
    viewBox: "0 0 14 14",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, _ctx.pti()), _hoisted_3$9, 16);
}
script$h.render = render$h;
function bind(el, binding) {
  const { onFocusIn, onFocusOut } = binding.value || {};
  el.$_pfocustrap_mutationobserver = new MutationObserver((mutationList) => {
    mutationList.forEach((mutation) => {
      if (mutation.type === "childList" && !el.contains(document.activeElement)) {
        const findNextFocusableElement = (el2) => {
          const focusableElement = DomHandler.isFocusableElement(el2) ? el2 : DomHandler.getFirstFocusableElement(el2);
          return ObjectUtils.isNotEmpty(focusableElement) ? focusableElement : findNextFocusableElement(el2.nextSibling);
        };
        DomHandler.focus(findNextFocusableElement(mutation.nextSibling));
      }
    });
  });
  el.$_pfocustrap_mutationobserver.disconnect();
  el.$_pfocustrap_mutationobserver.observe(el, {
    childList: true
  });
  el.$_pfocustrap_focusinlistener = (event2) => onFocusIn && onFocusIn(event2);
  el.$_pfocustrap_focusoutlistener = (event2) => onFocusOut && onFocusOut(event2);
  el.addEventListener("focusin", el.$_pfocustrap_focusinlistener);
  el.addEventListener("focusout", el.$_pfocustrap_focusoutlistener);
}
function unbind(el) {
  el.$_pfocustrap_mutationobserver && el.$_pfocustrap_mutationobserver.disconnect();
  el.$_pfocustrap_focusinlistener && el.removeEventListener("focusin", el.$_pfocustrap_focusinlistener) && (el.$_pfocustrap_focusinlistener = null);
  el.$_pfocustrap_focusoutlistener && el.removeEventListener("focusout", el.$_pfocustrap_focusoutlistener) && (el.$_pfocustrap_focusoutlistener = null);
}
function autoFocus(el, binding) {
  const { autoFocusSelector = "", firstFocusableSelector = "", autoFocus: autoFocus2 = false } = binding.value || {};
  let focusableElement = DomHandler.getFirstFocusableElement(el, `[autofocus]:not(.p-hidden-focusable)${autoFocusSelector}`);
  autoFocus2 && !focusableElement && (focusableElement = DomHandler.getFirstFocusableElement(el, `:not(.p-hidden-focusable)${firstFocusableSelector}`));
  DomHandler.focus(focusableElement);
}
function onFirstHiddenElementFocus(event2) {
  const { currentTarget, relatedTarget } = event2;
  const focusableElement = relatedTarget === currentTarget.$_pfocustrap_lasthiddenfocusableelement ? DomHandler.getFirstFocusableElement(currentTarget.parentElement, `:not(.p-hidden-focusable)${currentTarget.$_pfocustrap_focusableselector}`) : currentTarget.$_pfocustrap_lasthiddenfocusableelement;
  DomHandler.focus(focusableElement);
}
function onLastHiddenElementFocus(event2) {
  const { currentTarget, relatedTarget } = event2;
  const focusableElement = relatedTarget === currentTarget.$_pfocustrap_firsthiddenfocusableelement ? DomHandler.getLastFocusableElement(currentTarget.parentElement, `:not(.p-hidden-focusable)${currentTarget.$_pfocustrap_focusableselector}`) : currentTarget.$_pfocustrap_firsthiddenfocusableelement;
  DomHandler.focus(focusableElement);
}
function createHiddenFocusableElements(el, binding) {
  const { tabIndex = 0, firstFocusableSelector = "", lastFocusableSelector = "" } = binding.value || {};
  const createFocusableElement = (onFocus) => {
    const element = document.createElement("span");
    element.classList = "p-hidden-accessible p-hidden-focusable";
    element.tabIndex = tabIndex;
    element.setAttribute("aria-hidden", "true");
    element.setAttribute("role", "presentation");
    element.addEventListener("focus", onFocus);
    return element;
  };
  const firstFocusableElement = createFocusableElement(onFirstHiddenElementFocus);
  const lastFocusableElement = createFocusableElement(onLastHiddenElementFocus);
  firstFocusableElement.$_pfocustrap_lasthiddenfocusableelement = lastFocusableElement;
  firstFocusableElement.$_pfocustrap_focusableselector = firstFocusableSelector;
  lastFocusableElement.$_pfocustrap_firsthiddenfocusableelement = firstFocusableElement;
  lastFocusableElement.$_pfocustrap_focusableselector = lastFocusableSelector;
  el.prepend(firstFocusableElement);
  el.append(lastFocusableElement);
}
const FocusTrap = {
  mounted(el, binding) {
    const { disabled } = binding.value || {};
    if (!disabled) {
      createHiddenFocusableElements(el, binding);
      bind(el, binding);
      autoFocus(el, binding);
    }
  },
  updated(el, binding) {
    const { disabled } = binding.value || {};
    disabled && unbind(el);
  },
  unmounted(el) {
    unbind(el);
  }
};
var script$g = {
  name: "FilterSlashIcon",
  extends: script$V
};
const _hoisted_1$d = /* @__PURE__ */ createElementVNode("g", { "clip-path": "url(#clip0_408_20963)" }, [
  /* @__PURE__ */ createElementVNode("path", {
    "fill-rule": "evenodd",
    "clip-rule": "evenodd",
    d: "M13.4994 0.0920138C13.5967 0.151519 13.6758 0.236453 13.7283 0.337647C13.7807 0.439133 13.8031 0.553448 13.7929 0.667208C13.7827 0.780968 13.7403 0.889466 13.6707 0.98L11.406 4.06823C11.3099 4.19928 11.1656 4.28679 11.005 4.3115C10.8444 4.33621 10.6805 4.2961 10.5495 4.2C10.4184 4.1039 10.3309 3.95967 10.3062 3.79905C10.2815 3.63843 10.3216 3.47458 10.4177 3.34353L11.9412 1.23529H7.41184C7.24803 1.23529 7.09093 1.17022 6.97509 1.05439C6.85926 0.938558 6.79419 0.781457 6.79419 0.617647C6.79419 0.453837 6.85926 0.296736 6.97509 0.180905C7.09093 0.0650733 7.24803 0 7.41184 0H13.1765C13.2905 0.000692754 13.4022 0.0325088 13.4994 0.0920138ZM4.20008 0.181168H4.24126L13.2013 9.03411C13.3169 9.14992 13.3819 9.3069 13.3819 9.47058C13.3819 9.63426 13.3169 9.79124 13.2013 9.90705C13.1445 9.96517 13.0766 10.0112 13.0016 10.0423C12.9266 10.0735 12.846 10.0891 12.7648 10.0882C12.6836 10.0886 12.6032 10.0728 12.5283 10.0417C12.4533 10.0106 12.3853 9.96479 12.3283 9.90705L9.3142 6.92587L9.26479 6.99999V13.3823C9.26265 13.5455 9.19689 13.7014 9.08152 13.8167C8.96615 13.9321 8.81029 13.9979 8.64714 14H5.35302C5.18987 13.9979 5.03401 13.9321 4.91864 13.8167C4.80327 13.7014 4.73751 13.5455 4.73537 13.3823V6.99999L0.329492 1.02117C0.259855 0.930634 0.21745 0.822137 0.207241 0.708376C0.197031 0.594616 0.21944 0.480301 0.271844 0.378815C0.324343 0.277621 0.403484 0.192687 0.500724 0.133182C0.597964 0.073677 0.709609 0.041861 0.823609 0.0411682H3.86243C3.92448 0.0461551 3.9855 0.060022 4.04361 0.0823446C4.10037 0.10735 4.15311 0.140655 4.20008 0.181168ZM8.02949 6.79411C8.02884 6.66289 8.07235 6.53526 8.15302 6.43176L8.42478 6.05293L3.55773 1.23529H2.0589L5.84714 6.43176C5.92781 6.53526 5.97132 6.66289 5.97067 6.79411V12.7647H8.02949V6.79411Z",
    fill: "currentColor"
  })
], -1);
const _hoisted_2$6 = /* @__PURE__ */ createElementVNode("defs", null, [
  /* @__PURE__ */ createElementVNode("clipPath", { id: "clip0_408_20963" }, [
    /* @__PURE__ */ createElementVNode("rect", {
      width: "14",
      height: "14",
      fill: "white"
    })
  ])
], -1);
const _hoisted_3$8 = [
  _hoisted_1$d,
  _hoisted_2$6
];
function render$g(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("svg", mergeProps({
    width: "14",
    height: "14",
    viewBox: "0 0 14 14",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, _ctx.pti()), _hoisted_3$8, 16);
}
script$g.render = render$g;
var script$f = {
  name: "TrashIcon",
  extends: script$V
};
const _hoisted_1$c = /* @__PURE__ */ createElementVNode("g", { "clip-path": "url(#clip0_417_21589)" }, [
  /* @__PURE__ */ createElementVNode("path", {
    "fill-rule": "evenodd",
    "clip-rule": "evenodd",
    d: "M3.44802 13.9955H10.552C10.8056 14.0129 11.06 13.9797 11.3006 13.898C11.5412 13.8163 11.7632 13.6877 11.9537 13.5196C12.1442 13.3515 12.2995 13.1473 12.4104 12.9188C12.5213 12.6903 12.5858 12.442 12.6 12.1884V4.36041H13.4C13.5591 4.36041 13.7117 4.29722 13.8243 4.18476C13.9368 4.07229 14 3.91976 14 3.76071C14 3.60166 13.9368 3.44912 13.8243 3.33666C13.7117 3.22419 13.5591 3.16101 13.4 3.16101H12.0537C12.0203 3.1557 11.9863 3.15299 11.952 3.15299C11.9178 3.15299 11.8838 3.1557 11.8503 3.16101H11.2285C11.2421 3.10893 11.2487 3.05513 11.248 3.00106V1.80966C11.2171 1.30262 10.9871 0.828306 10.608 0.48989C10.229 0.151475 9.73159 -0.0236625 9.22402 0.00257442H4.77602C4.27251 -0.0171866 3.78126 0.160868 3.40746 0.498617C3.03365 0.836366 2.807 1.30697 2.77602 1.80966V3.00106C2.77602 3.0556 2.78346 3.10936 2.79776 3.16101H0.6C0.521207 3.16101 0.443185 3.17652 0.37039 3.20666C0.297595 3.2368 0.231451 3.28097 0.175736 3.33666C0.120021 3.39235 0.0758251 3.45846 0.0456722 3.53121C0.0155194 3.60397 0 3.68196 0 3.76071C0 3.83946 0.0155194 3.91744 0.0456722 3.9902C0.0758251 4.06296 0.120021 4.12907 0.175736 4.18476C0.231451 4.24045 0.297595 4.28462 0.37039 4.31476C0.443185 4.3449 0.521207 4.36041 0.6 4.36041H1.40002V12.1884C1.41426 12.442 1.47871 12.6903 1.58965 12.9188C1.7006 13.1473 1.85582 13.3515 2.04633 13.5196C2.23683 13.6877 2.45882 13.8163 2.69944 13.898C2.94005 13.9797 3.1945 14.0129 3.44802 13.9955ZM2.60002 4.36041H11.304V12.1884C11.304 12.5163 10.952 12.7961 10.504 12.7961H3.40002C2.97602 12.7961 2.60002 12.5163 2.60002 12.1884V4.36041ZM3.95429 3.16101C3.96859 3.10936 3.97602 3.0556 3.97602 3.00106V1.80966C3.97602 1.48183 4.33602 1.20197 4.77602 1.20197H9.24802C9.66403 1.20197 10.048 1.48183 10.048 1.80966V3.00106C10.0473 3.05515 10.054 3.10896 10.0678 3.16101H3.95429ZM5.57571 10.997C5.41731 10.995 5.26597 10.9311 5.15395 10.8191C5.04193 10.7071 4.97808 10.5558 4.97601 10.3973V6.77517C4.97601 6.61612 5.0392 6.46359 5.15166 6.35112C5.26413 6.23866 5.41666 6.17548 5.57571 6.17548C5.73476 6.17548 5.8873 6.23866 5.99976 6.35112C6.11223 6.46359 6.17541 6.61612 6.17541 6.77517V10.3894C6.17647 10.4688 6.16174 10.5476 6.13208 10.6213C6.10241 10.695 6.05841 10.762 6.00261 10.8186C5.94682 10.8751 5.88035 10.92 5.80707 10.9506C5.73378 10.9813 5.65514 10.9971 5.57571 10.997ZM7.99968 10.8214C8.11215 10.9339 8.26468 10.997 8.42373 10.997C8.58351 10.9949 8.73604 10.93 8.84828 10.8163C8.96052 10.7025 9.02345 10.5491 9.02343 10.3894V6.77517C9.02343 6.61612 8.96025 6.46359 8.84778 6.35112C8.73532 6.23866 8.58278 6.17548 8.42373 6.17548C8.26468 6.17548 8.11215 6.23866 7.99968 6.35112C7.88722 6.46359 7.82404 6.61612 7.82404 6.77517V10.3973C7.82404 10.5564 7.88722 10.7089 7.99968 10.8214Z",
    fill: "currentColor"
  })
], -1);
const _hoisted_2$5 = /* @__PURE__ */ createElementVNode("defs", null, [
  /* @__PURE__ */ createElementVNode("clipPath", { id: "clip0_417_21589" }, [
    /* @__PURE__ */ createElementVNode("rect", {
      width: "14",
      height: "14",
      fill: "white"
    })
  ])
], -1);
const _hoisted_3$7 = [
  _hoisted_1$c,
  _hoisted_2$5
];
function render$f(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("svg", mergeProps({
    width: "14",
    height: "14",
    viewBox: "0 0 14 14",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, _ctx.pti()), _hoisted_3$7, 16);
}
script$f.render = render$f;
var script$e = {
  name: "SortAltIcon",
  extends: script$V
};
const _hoisted_1$b = /* @__PURE__ */ createStaticVNode('<g clip-path="url(#clip0_378_15529)"><path d="M5.64515 3.61291C5.47353 3.61291 5.30192 3.54968 5.16644 3.4142L3.38708 1.63484L1.60773 3.4142C1.34579 3.67613 0.912244 3.67613 0.650309 3.4142C0.388374 3.15226 0.388374 2.71871 0.650309 2.45678L2.90837 0.198712C3.17031 -0.0632236 3.60386 -0.0632236 3.86579 0.198712L6.12386 2.45678C6.38579 2.71871 6.38579 3.15226 6.12386 3.4142C5.98837 3.54968 5.81676 3.61291 5.64515 3.61291Z" fill="currentColor"></path><path d="M3.38714 14C3.01681 14 2.70972 13.6929 2.70972 13.3226V0.677419C2.70972 0.307097 3.01681 0 3.38714 0C3.75746 0 4.06456 0.307097 4.06456 0.677419V13.3226C4.06456 13.6929 3.75746 14 3.38714 14Z" fill="currentColor"></path><path d="M10.6129 14C10.4413 14 10.2697 13.9368 10.1342 13.8013L7.87611 11.5432C7.61418 11.2813 7.61418 10.8477 7.87611 10.5858C8.13805 10.3239 8.5716 10.3239 8.83353 10.5858L10.6129 12.3652L12.3922 10.5858C12.6542 10.3239 13.0877 10.3239 13.3497 10.5858C13.6116 10.8477 13.6116 11.2813 13.3497 11.5432L11.0916 13.8013C10.9561 13.9368 10.7845 14 10.6129 14Z" fill="currentColor"></path><path d="M10.6129 14C10.2426 14 9.93552 13.6929 9.93552 13.3226V0.677419C9.93552 0.307097 10.2426 0 10.6129 0C10.9833 0 11.2904 0.307097 11.2904 0.677419V13.3226C11.2904 13.6929 10.9832 14 10.6129 14Z" fill="currentColor"></path></g><defs><clipPath id="clip0_378_15529"><rect width="14" height="14" fill="white"></rect></clipPath></defs>', 2);
const _hoisted_3$6 = [
  _hoisted_1$b
];
function render$e(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("svg", mergeProps({
    width: "14",
    height: "14",
    viewBox: "0 0 14 14",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, _ctx.pti()), _hoisted_3$6, 16);
}
script$e.render = render$e;
var script$d = {
  name: "SortAmountDownIcon",
  extends: script$V
};
const _hoisted_1$a = /* @__PURE__ */ createStaticVNode('<g clip-path="url(#clip0_378_15544)"><path d="M2.59836 13.2009C2.44634 13.2009 2.29432 13.1449 2.1743 13.0248L0.174024 11.0246C-0.0580081 10.7925 -0.0580081 10.4085 0.174024 10.1764C0.406057 9.94441 0.79011 9.94441 1.02214 10.1764L2.59836 11.7527L4.17458 10.1764C4.40662 9.94441 4.79067 9.94441 5.0227 10.1764C5.25473 10.4085 5.25473 10.7925 5.0227 11.0246L3.02242 13.0248C2.90241 13.1449 2.75038 13.2009 2.59836 13.2009Z" fill="currentColor"></path><path d="M2.59836 13.2009C2.27032 13.2009 1.99833 12.9288 1.99833 12.6008V1.39922C1.99833 1.07117 2.27036 0.799133 2.59841 0.799133C2.92646 0.799133 3.19849 1.07117 3.19849 1.39922V12.6008C3.19849 12.9288 2.92641 13.2009 2.59836 13.2009Z" fill="currentColor"></path><path d="M13.3999 11.2006H6.99902C6.67098 11.2006 6.39894 10.9285 6.39894 10.6005C6.39894 10.2725 6.67098 10.0004 6.99902 10.0004H13.3999C13.728 10.0004 14 10.2725 14 10.6005C14 10.9285 13.728 11.2006 13.3999 11.2006Z" fill="currentColor"></path><path d="M10.1995 6.39991H6.99902C6.67098 6.39991 6.39894 6.12788 6.39894 5.79983C6.39894 5.47179 6.67098 5.19975 6.99902 5.19975H10.1995C10.5275 5.19975 10.7996 5.47179 10.7996 5.79983C10.7996 6.12788 10.5275 6.39991 10.1995 6.39991Z" fill="currentColor"></path><path d="M8.59925 3.99958H6.99902C6.67098 3.99958 6.39894 3.72754 6.39894 3.3995C6.39894 3.07145 6.67098 2.79941 6.99902 2.79941H8.59925C8.92729 2.79941 9.19933 3.07145 9.19933 3.3995C9.19933 3.72754 8.92729 3.99958 8.59925 3.99958Z" fill="currentColor"></path><path d="M11.7997 8.80025H6.99902C6.67098 8.80025 6.39894 8.52821 6.39894 8.20017C6.39894 7.87212 6.67098 7.60008 6.99902 7.60008H11.7997C12.1277 7.60008 12.3998 7.87212 12.3998 8.20017C12.3998 8.52821 12.1277 8.80025 11.7997 8.80025Z" fill="currentColor"></path></g><defs><clipPath id="clip0_378_15544"><rect width="14" height="14" fill="white"></rect></clipPath></defs>', 2);
const _hoisted_3$5 = [
  _hoisted_1$a
];
function render$d(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("svg", mergeProps({
    width: "14",
    height: "14",
    viewBox: "0 0 14 14",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, _ctx.pti()), _hoisted_3$5, 16);
}
script$d.render = render$d;
var script$c = {
  name: "SortAmountUpAltIcon",
  extends: script$V
};
const _hoisted_1$9 = /* @__PURE__ */ createStaticVNode('<g clip-path="url(#clip0_378_15578)"><path d="M4.59864 3.99958C4.44662 3.99958 4.2946 3.94357 4.17458 3.82356L2.59836 2.24734L1.02214 3.82356C0.79011 4.05559 0.406057 4.05559 0.174024 3.82356C-0.0580081 3.59152 -0.0580081 3.20747 0.174024 2.97544L2.1743 0.97516C2.40634 0.743127 2.79039 0.743127 3.02242 0.97516L5.0227 2.97544C5.25473 3.20747 5.25473 3.59152 5.0227 3.82356C4.90268 3.94357 4.75066 3.99958 4.59864 3.99958Z" fill="currentColor"></path><path d="M2.59841 13.2009C2.27036 13.2009 1.99833 12.9288 1.99833 12.6008V1.39922C1.99833 1.07117 2.27036 0.799133 2.59841 0.799133C2.92646 0.799133 3.19849 1.07117 3.19849 1.39922V12.6008C3.19849 12.9288 2.92646 13.2009 2.59841 13.2009Z" fill="currentColor"></path><path d="M13.3999 11.2006H6.99902C6.67098 11.2006 6.39894 10.9285 6.39894 10.6005C6.39894 10.2725 6.67098 10.0004 6.99902 10.0004H13.3999C13.728 10.0004 14 10.2725 14 10.6005C14 10.9285 13.728 11.2006 13.3999 11.2006Z" fill="currentColor"></path><path d="M10.1995 6.39991H6.99902C6.67098 6.39991 6.39894 6.12788 6.39894 5.79983C6.39894 5.47179 6.67098 5.19975 6.99902 5.19975H10.1995C10.5275 5.19975 10.7996 5.47179 10.7996 5.79983C10.7996 6.12788 10.5275 6.39991 10.1995 6.39991Z" fill="currentColor"></path><path d="M8.59925 3.99958H6.99902C6.67098 3.99958 6.39894 3.72754 6.39894 3.3995C6.39894 3.07145 6.67098 2.79941 6.99902 2.79941H8.59925C8.92729 2.79941 9.19933 3.07145 9.19933 3.3995C9.19933 3.72754 8.92729 3.99958 8.59925 3.99958Z" fill="currentColor"></path><path d="M11.7997 8.80025H6.99902C6.67098 8.80025 6.39894 8.52821 6.39894 8.20017C6.39894 7.87212 6.67098 7.60008 6.99902 7.60008H11.7997C12.1277 7.60008 12.3998 7.87212 12.3998 8.20017C12.3998 8.52821 12.1277 8.80025 11.7997 8.80025Z" fill="currentColor"></path></g><defs><clipPath id="clip0_378_15578"><rect width="14" height="14" fill="white"></rect></clipPath></defs>', 2);
const _hoisted_3$4 = [
  _hoisted_1$9
];
function render$c(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("svg", mergeProps({
    width: "14",
    height: "14",
    viewBox: "0 0 14 14",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, _ctx.pti()), _hoisted_3$4, 16);
}
script$c.render = render$c;
var script$a = {
  name: "RowCheckbox",
  extends: script$W,
  emits: ["change"],
  props: {
    value: null,
    checked: null,
    column: null,
    rowCheckboxIconTemplate: {
      type: Function,
      default: null
    }
  },
  data() {
    return {
      focused: false
    };
  },
  methods: {
    getColumnPTOptions(key) {
      return this.ptmo(this.getColumnProp(), key, {
        props: this.column.props,
        parent: {
          props: this.$props,
          state: this.$data
        },
        context: {
          checked: this.checked,
          focused: this.focused,
          disabled: this.$attrs.disabled
        }
      });
    },
    getColumnProp() {
      return this.column.props && this.column.props.pt ? this.column.props.pt : void 0;
    },
    onClick(event2) {
      if (!this.$attrs.disabled) {
        this.$emit("change", {
          originalEvent: event2,
          data: this.value
        });
        DomHandler.focus(this.$refs.input);
      }
      event2.preventDefault();
    },
    onFocus() {
      this.focused = true;
    },
    onBlur() {
      this.focused = false;
    },
    onKeydown(event2) {
      switch (event2.code) {
        case "Space": {
          this.onClick(event2);
          break;
        }
      }
    }
  },
  computed: {
    checkboxAriaLabel() {
      return this.$primevue.config.locale.aria ? this.checked ? this.$primevue.config.locale.aria.selectRow : this.$primevue.config.locale.aria.unselectRow : void 0;
    }
  },
  components: {
    CheckIcon: script$H
  }
};
const _hoisted_1$7 = ["checked", "disabled", "tabindex", "aria-label"];
function render$a(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_CheckIcon = resolveComponent("CheckIcon");
  return openBlock(), createElementBlock("div", mergeProps({
    class: ["p-checkbox p-component", { "p-checkbox-focused": $data.focused }],
    onClick: _cache[3] || (_cache[3] = (...args) => $options.onClick && $options.onClick(...args))
  }, $options.getColumnPTOptions("checkboxWrapper")), [
    createElementVNode("div", mergeProps({ class: "p-hidden-accessible" }, $options.getColumnPTOptions("hiddenInputWrapper")), [
      createElementVNode("input", mergeProps({
        ref: "input",
        type: "checkbox",
        checked: $props.checked,
        disabled: _ctx.$attrs.disabled,
        tabindex: _ctx.$attrs.disabled ? null : "0",
        "aria-label": $options.checkboxAriaLabel,
        onFocus: _cache[0] || (_cache[0] = ($event) => $options.onFocus($event)),
        onBlur: _cache[1] || (_cache[1] = ($event) => $options.onBlur($event)),
        onKeydown: _cache[2] || (_cache[2] = (...args) => $options.onKeydown && $options.onKeydown(...args))
      }, $options.getColumnPTOptions("hiddenInput")), null, 16, _hoisted_1$7)
    ], 16),
    createElementVNode("div", mergeProps({
      ref: "box",
      class: ["p-checkbox-box p-component", { "p-highlight": $props.checked, "p-disabled": _ctx.$attrs.disabled, "p-focus": $data.focused }]
    }, $options.getColumnPTOptions("checkbox")), [
      $props.rowCheckboxIconTemplate ? (openBlock(), createBlock(resolveDynamicComponent($props.rowCheckboxIconTemplate), {
        key: 0,
        checked: $props.checked,
        class: "p-checkbox-icon"
      }, null, 8, ["checked"])) : !$props.rowCheckboxIconTemplate && !!$props.checked ? (openBlock(), createBlock(_component_CheckIcon, mergeProps({
        key: 1,
        class: "p-checkbox-icon"
      }, $options.getColumnPTOptions("checkboxIcon")), null, 16)) : createCommentVNode("", true)
    ], 16)
  ], 16);
}
script$a.render = render$a;
var script$9$1 = {
  name: "RowRadioButton",
  extends: script$W,
  inheritAttrs: false,
  emits: ["change"],
  props: {
    value: null,
    checked: null,
    name: null,
    column: null
  },
  data() {
    return {
      focused: false
    };
  },
  methods: {
    getColumnPTOptions(key) {
      return this.ptmo(this.getColumnProp(), key, {
        props: this.column.props,
        parent: {
          props: this.$props,
          state: this.$data
        },
        context: {
          checked: this.checked,
          focused: this.focused,
          disabled: this.$attrs.disabled
        }
      });
    },
    getColumnProp() {
      return this.column.props && this.column.props.pt ? this.column.props.pt : void 0;
    },
    onClick(event2) {
      if (!this.disabled) {
        if (!this.checked) {
          this.$emit("change", {
            originalEvent: event2,
            data: this.value
          });
          DomHandler.focus(this.$refs.input);
        }
      }
    },
    onFocus() {
      this.focused = true;
    },
    onBlur() {
      this.focused = false;
    }
  }
};
const _hoisted_1$6 = ["checked", "disabled", "name"];
function render$9(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("div", mergeProps({
    class: ["p-radiobutton p-component", { "p-radiobutton-focused": $data.focused }],
    onClick: _cache[3] || (_cache[3] = (...args) => $options.onClick && $options.onClick(...args))
  }, $options.getColumnPTOptions("radiobuttonWrapper")), [
    createElementVNode("div", mergeProps({ class: "p-hidden-accessible" }, _ctx.ptm("hiddenInputWrapper")), [
      createElementVNode("input", mergeProps({
        ref: "input",
        type: "radio",
        checked: $props.checked,
        disabled: _ctx.$attrs.disabled,
        name: $props.name,
        tabindex: "0",
        onFocus: _cache[0] || (_cache[0] = ($event) => $options.onFocus($event)),
        onBlur: _cache[1] || (_cache[1] = ($event) => $options.onBlur($event)),
        onKeydown: _cache[2] || (_cache[2] = withKeys(withModifiers((...args) => $options.onClick && $options.onClick(...args), ["prevent"]), ["space"]))
      }, $options.getColumnPTOptions("hiddenInput")), null, 16, _hoisted_1$6)
    ], 16),
    createElementVNode("div", mergeProps({
      ref: "box",
      class: ["p-radiobutton-box p-component", { "p-highlight": $props.checked, "p-disabled": _ctx.$attrs.disabled, "p-focus": $data.focused }]
    }, $options.getColumnPTOptions("radiobutton")), [
      createElementVNode("div", mergeProps({ class: "p-radiobutton-icon" }, $options.getColumnPTOptions("radiobuttonIcon")), null, 16)
    ], 16)
  ], 16);
}
script$9$1.render = render$9;
var script$8$1 = {
  name: "BodyCell",
  extends: script$W,
  emits: ["cell-edit-init", "cell-edit-complete", "cell-edit-cancel", "row-edit-init", "row-edit-save", "row-edit-cancel", "row-toggle", "radio-change", "checkbox-change", "editing-meta-change"],
  props: {
    rowData: {
      type: Object,
      default: null
    },
    column: {
      type: Object,
      default: null
    },
    frozenRow: {
      type: Boolean,
      default: false
    },
    rowIndex: {
      type: Number,
      default: null
    },
    index: {
      type: Number,
      default: null
    },
    isRowExpanded: {
      type: Boolean,
      default: false
    },
    selected: {
      type: Boolean,
      default: false
    },
    editing: {
      type: Boolean,
      default: false
    },
    editingMeta: {
      type: Object,
      default: null
    },
    editMode: {
      type: String,
      default: null
    },
    responsiveLayout: {
      type: String,
      default: "stack"
    },
    virtualScrollerContentProps: {
      type: Object,
      default: null
    },
    ariaControls: {
      type: String,
      default: null
    },
    name: {
      type: String,
      default: null
    },
    expandedRowIcon: {
      type: String,
      default: null
    },
    collapsedRowIcon: {
      type: String,
      default: null
    }
  },
  documentEditListener: null,
  selfClick: false,
  overlayEventListener: null,
  data() {
    return {
      d_editing: this.editing,
      styleObject: {}
    };
  },
  watch: {
    editing(newValue) {
      this.d_editing = newValue;
    },
    "$data.d_editing": function(newValue) {
      this.$emit("editing-meta-change", { data: this.rowData, field: this.field || `field_${this.index}`, index: this.rowIndex, editing: newValue });
    }
  },
  mounted() {
    if (this.columnProp("frozen")) {
      this.updateStickyPosition();
    }
  },
  updated() {
    if (this.columnProp("frozen")) {
      this.updateStickyPosition();
    }
    if (this.d_editing && (this.editMode === "cell" || this.editMode === "row" && this.columnProp("rowEditor"))) {
      setTimeout(() => {
        const focusableEl = DomHandler.getFirstFocusableElement(this.$el);
        focusableEl && focusableEl.focus();
      }, 1);
    }
  },
  beforeUnmount() {
    if (this.overlayEventListener) {
      OverlayEventBus.off("overlay-click", this.overlayEventListener);
      this.overlayEventListener = null;
    }
  },
  methods: {
    columnProp(prop) {
      return ObjectUtils.getVNodeProp(this.column, prop);
    },
    getColumnPTOptions(column, key) {
      return this.ptmo(this.getColumnProp(column), key, {
        props: column.props,
        parent: {
          props: this.$props,
          state: this.$data
        }
      });
    },
    getColumnProp(column) {
      return column.props && column.props.pt ? column.props.pt : void 0;
    },
    resolveFieldData() {
      return ObjectUtils.resolveFieldData(this.rowData, this.field);
    },
    toggleRow(event2) {
      this.$emit("row-toggle", {
        originalEvent: event2,
        data: this.rowData
      });
    },
    toggleRowWithRadio(event2, index) {
      this.$emit("radio-change", { originalEvent: event2.originalEvent, index, data: event2.data });
    },
    toggleRowWithCheckbox(event2, index) {
      this.$emit("checkbox-change", { originalEvent: event2.originalEvent, index, data: event2.data });
    },
    isEditable() {
      return this.column.children && this.column.children.editor != null;
    },
    bindDocumentEditListener() {
      if (!this.documentEditListener) {
        this.documentEditListener = (event2) => {
          if (!this.selfClick) {
            this.completeEdit(event2, "outside");
          }
          this.selfClick = false;
        };
        document.addEventListener("click", this.documentEditListener);
      }
    },
    unbindDocumentEditListener() {
      if (this.documentEditListener) {
        document.removeEventListener("click", this.documentEditListener);
        this.documentEditListener = null;
        this.selfClick = false;
      }
    },
    switchCellToViewMode() {
      this.d_editing = false;
      this.unbindDocumentEditListener();
      OverlayEventBus.off("overlay-click", this.overlayEventListener);
      this.overlayEventListener = null;
    },
    onClick(event2) {
      if (this.editMode === "cell" && this.isEditable()) {
        this.selfClick = true;
        if (!this.d_editing) {
          this.d_editing = true;
          this.bindDocumentEditListener();
          this.$emit("cell-edit-init", { originalEvent: event2, data: this.rowData, field: this.field, index: this.rowIndex });
          this.overlayEventListener = (e) => {
            if (this.$el && this.$el.contains(e.target)) {
              this.selfClick = true;
            }
          };
          OverlayEventBus.on("overlay-click", this.overlayEventListener);
        }
      }
    },
    completeEdit(event2, type) {
      const completeEvent = {
        originalEvent: event2,
        data: this.rowData,
        newData: this.editingRowData,
        value: this.rowData[this.field],
        newValue: this.editingRowData[this.field],
        field: this.field,
        index: this.rowIndex,
        type,
        defaultPrevented: false,
        preventDefault: function() {
          this.defaultPrevented = true;
        }
      };
      this.$emit("cell-edit-complete", completeEvent);
      if (!completeEvent.defaultPrevented) {
        this.switchCellToViewMode();
      }
    },
    onKeyDown(event2) {
      if (this.editMode === "cell") {
        switch (event2.code) {
          case "Enter":
            this.completeEdit(event2, "enter");
            break;
          case "Escape":
            this.switchCellToViewMode();
            this.$emit("cell-edit-cancel", { originalEvent: event2, data: this.rowData, field: this.field, index: this.rowIndex });
            break;
          case "Tab":
            this.completeEdit(event2, "tab");
            if (event2.shiftKey)
              this.moveToPreviousCell(event2);
            else
              this.moveToNextCell(event2);
            break;
        }
      }
    },
    moveToPreviousCell(event2) {
      let currentCell = this.findCell(event2.target);
      let targetCell = this.findPreviousEditableColumn(currentCell);
      if (targetCell) {
        DomHandler.invokeElementMethod(targetCell, "click");
        event2.preventDefault();
      }
    },
    moveToNextCell(event2) {
      let currentCell = this.findCell(event2.target);
      let targetCell = this.findNextEditableColumn(currentCell);
      if (targetCell) {
        DomHandler.invokeElementMethod(targetCell, "click");
        event2.preventDefault();
      }
    },
    findCell(element) {
      if (element) {
        let cell = element;
        while (cell && !DomHandler.hasClass(cell, "p-cell-editing")) {
          cell = cell.parentElement;
        }
        return cell;
      } else {
        return null;
      }
    },
    findPreviousEditableColumn(cell) {
      let prevCell = cell.previousElementSibling;
      if (!prevCell) {
        let previousRow = cell.parentElement.previousElementSibling;
        if (previousRow) {
          prevCell = previousRow.lastElementChild;
        }
      }
      if (prevCell) {
        if (DomHandler.hasClass(prevCell, "p-editable-column"))
          return prevCell;
        else
          return this.findPreviousEditableColumn(prevCell);
      } else {
        return null;
      }
    },
    findNextEditableColumn(cell) {
      let nextCell = cell.nextElementSibling;
      if (!nextCell) {
        let nextRow = cell.parentElement.nextElementSibling;
        if (nextRow) {
          nextCell = nextRow.firstElementChild;
        }
      }
      if (nextCell) {
        if (DomHandler.hasClass(nextCell, "p-editable-column"))
          return nextCell;
        else
          return this.findNextEditableColumn(nextCell);
      } else {
        return null;
      }
    },
    isEditingCellValid() {
      return DomHandler.find(this.$el, ".p-invalid").length === 0;
    },
    onRowEditInit(event2) {
      this.$emit("row-edit-init", { originalEvent: event2, data: this.rowData, newData: this.editingRowData, field: this.field, index: this.rowIndex });
    },
    onRowEditSave(event2) {
      this.$emit("row-edit-save", { originalEvent: event2, data: this.rowData, newData: this.editingRowData, field: this.field, index: this.rowIndex });
    },
    onRowEditCancel(event2) {
      this.$emit("row-edit-cancel", { originalEvent: event2, data: this.rowData, newData: this.editingRowData, field: this.field, index: this.rowIndex });
    },
    editorInitCallback(event2) {
      this.$emit("row-edit-init", { originalEvent: event2, data: this.rowData, newData: this.editingRowData, field: this.field, index: this.rowIndex });
    },
    editorSaveCallback(event2) {
      if (this.editMode === "row") {
        this.$emit("row-edit-save", { originalEvent: event2, data: this.rowData, newData: this.editingRowData, field: this.field, index: this.rowIndex });
      } else {
        this.completeEdit(event2, "enter");
      }
    },
    editorCancelCallback(event2) {
      if (this.editMode === "row") {
        this.$emit("row-edit-cancel", { originalEvent: event2, data: this.rowData, newData: this.editingRowData, field: this.field, index: this.rowIndex });
      } else {
        this.switchCellToViewMode();
        this.$emit("cell-edit-cancel", { originalEvent: event2, data: this.rowData, field: this.field, index: this.rowIndex });
      }
    },
    updateStickyPosition() {
      if (this.columnProp("frozen")) {
        let align = this.columnProp("alignFrozen");
        if (align === "right") {
          let right = 0;
          let next = this.$el.nextElementSibling;
          if (next) {
            right = DomHandler.getOuterWidth(next) + parseFloat(next.style.right || 0);
          }
          this.styleObject.right = right + "px";
        } else {
          let left = 0;
          let prev = this.$el.previousElementSibling;
          if (prev) {
            left = DomHandler.getOuterWidth(prev) + parseFloat(prev.style.left || 0);
          }
          this.styleObject.left = left + "px";
        }
      }
    },
    getVirtualScrollerProp(option) {
      return this.virtualScrollerContentProps ? this.virtualScrollerContentProps[option] : null;
    }
  },
  computed: {
    editingRowData() {
      return this.editingMeta[this.rowIndex] ? this.editingMeta[this.rowIndex].data : this.rowData;
    },
    field() {
      return this.columnProp("field");
    },
    containerClass() {
      return [
        this.columnProp("bodyClass"),
        this.columnProp("class"),
        {
          "p-selection-column": this.columnProp("selectionMode") != null,
          "p-editable-column": this.isEditable(),
          "p-cell-editing": this.d_editing,
          "p-frozen-column": this.columnProp("frozen")
        }
      ];
    },
    containerStyle() {
      let bodyStyle = this.columnProp("bodyStyle");
      let columnStyle = this.columnProp("style");
      return this.columnProp("frozen") ? [columnStyle, bodyStyle, this.styleObject] : [columnStyle, bodyStyle];
    },
    loading() {
      return this.getVirtualScrollerProp("loading");
    },
    loadingOptions() {
      const getLoaderOptions = this.getVirtualScrollerProp("getLoaderOptions");
      return getLoaderOptions && getLoaderOptions(this.rowIndex, {
        cellIndex: this.index,
        cellFirst: this.index === 0,
        cellLast: this.index === this.getVirtualScrollerProp("columns").length - 1,
        cellEven: this.index % 2 === 0,
        cellOdd: this.index % 2 !== 0,
        column: this.column,
        field: this.field
      });
    },
    expandButtonAriaLabel() {
      return this.$primevue.config.locale.aria ? this.isRowExpanded ? this.$primevue.config.locale.aria.expandRow : this.$primevue.config.locale.aria.collapseRow : void 0;
    },
    initButtonAriaLabel() {
      return this.$primevue.config.locale.aria ? this.$primevue.config.locale.aria.editRow : void 0;
    },
    saveButtonAriaLabel() {
      return this.$primevue.config.locale.aria ? this.$primevue.config.locale.aria.saveEdit : void 0;
    },
    cancelButtonAriaLabel() {
      return this.$primevue.config.locale.aria ? this.$primevue.config.locale.aria.cancelEdit : void 0;
    }
  },
  components: {
    DTRadioButton: script$9$1,
    DTCheckbox: script$a,
    ChevronDownIcon: script$S,
    ChevronRightIcon: script$L,
    BarsIcon: script$i,
    PencilIcon: script$h,
    CheckIcon: script$H,
    TimesIcon: script$E
  },
  directives: {
    ripple: Ripple
  }
};
const _hoisted_1$5 = ["aria-expanded", "aria-controls", "aria-label"];
const _hoisted_2$2$1 = ["aria-label"];
const _hoisted_3$2$1 = ["aria-label"];
const _hoisted_4$1 = ["aria-label"];
function render$8$1(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_DTRadioButton = resolveComponent("DTRadioButton");
  const _component_DTCheckbox = resolveComponent("DTCheckbox");
  const _component_ChevronDownIcon = resolveComponent("ChevronDownIcon");
  const _component_ChevronRightIcon = resolveComponent("ChevronRightIcon");
  const _directive_ripple = resolveDirective("ripple");
  return $options.loading ? (openBlock(), createElementBlock("td", mergeProps({
    key: 0,
    style: $options.containerStyle,
    class: $options.containerClass,
    role: "cell"
  }, { ...$options.getColumnPTOptions($props.column, "root"), ...$options.getColumnPTOptions($props.column, "bodyCell") }), [
    (openBlock(), createBlock(resolveDynamicComponent($props.column.children.loading), {
      data: $props.rowData,
      column: $props.column,
      field: $options.field,
      index: $props.rowIndex,
      frozenRow: $props.frozenRow,
      loadingOptions: $options.loadingOptions
    }, null, 8, ["data", "column", "field", "index", "frozenRow", "loadingOptions"]))
  ], 16)) : (openBlock(), createElementBlock("td", mergeProps({
    key: 1,
    style: $options.containerStyle,
    class: $options.containerClass,
    onClick: _cache[6] || (_cache[6] = (...args) => $options.onClick && $options.onClick(...args)),
    onKeydown: _cache[7] || (_cache[7] = (...args) => $options.onKeyDown && $options.onKeyDown(...args)),
    role: "cell"
  }, { ...$options.getColumnPTOptions($props.column, "root"), ...$options.getColumnPTOptions($props.column, "bodyCell") }), [
    $props.responsiveLayout === "stack" ? (openBlock(), createElementBlock("span", mergeProps({
      key: 0,
      class: "p-column-title"
    }, $options.getColumnPTOptions($props.column, "columnTitle")), toDisplayString($options.columnProp("header")), 17)) : createCommentVNode("", true),
    $props.column.children && $props.column.children.body && !$data.d_editing ? (openBlock(), createBlock(resolveDynamicComponent($props.column.children.body), {
      key: 1,
      data: $props.rowData,
      column: $props.column,
      field: $options.field,
      index: $props.rowIndex,
      frozenRow: $props.frozenRow,
      editorInitCallback: $options.editorInitCallback
    }, null, 8, ["data", "column", "field", "index", "frozenRow", "editorInitCallback"])) : $props.column.children && $props.column.children.editor && $data.d_editing ? (openBlock(), createBlock(resolveDynamicComponent($props.column.children.editor), {
      key: 2,
      data: $options.editingRowData,
      column: $props.column,
      field: $options.field,
      index: $props.rowIndex,
      frozenRow: $props.frozenRow,
      editorSaveCallback: $options.editorSaveCallback,
      editorCancelCallback: $options.editorCancelCallback
    }, null, 8, ["data", "column", "field", "index", "frozenRow", "editorSaveCallback", "editorCancelCallback"])) : $props.column.children && $props.column.children.body && !$props.column.children.editor && $data.d_editing ? (openBlock(), createBlock(resolveDynamicComponent($props.column.children.body), {
      key: 3,
      data: $options.editingRowData,
      column: $props.column,
      field: $options.field,
      index: $props.rowIndex,
      frozenRow: $props.frozenRow
    }, null, 8, ["data", "column", "field", "index", "frozenRow"])) : $options.columnProp("selectionMode") ? (openBlock(), createElementBlock(Fragment, { key: 4 }, [
      $options.columnProp("selectionMode") === "single" ? (openBlock(), createBlock(_component_DTRadioButton, {
        key: 0,
        value: $props.rowData,
        name: $props.name,
        checked: $props.selected,
        onChange: _cache[0] || (_cache[0] = ($event) => $options.toggleRowWithRadio($event, $props.rowIndex)),
        column: $props.column,
        pt: _ctx.pt
      }, null, 8, ["value", "name", "checked", "column", "pt"])) : $options.columnProp("selectionMode") === "multiple" ? (openBlock(), createBlock(_component_DTCheckbox, {
        key: 1,
        value: $props.rowData,
        checked: $props.selected,
        rowCheckboxIconTemplate: $props.column.children && $props.column.children.rowcheckboxicon,
        "aria-selected": $props.selected ? true : void 0,
        onChange: _cache[1] || (_cache[1] = ($event) => $options.toggleRowWithCheckbox($event, $props.rowIndex)),
        column: $props.column,
        pt: _ctx.pt
      }, null, 8, ["value", "checked", "rowCheckboxIconTemplate", "aria-selected", "column", "pt"])) : createCommentVNode("", true)
    ], 64)) : $options.columnProp("rowReorder") ? (openBlock(), createBlock(resolveDynamicComponent($props.column.children && $props.column.children.rowreordericon ? $props.column.children.rowreordericon : $options.columnProp("rowReorderIcon") ? "i" : "BarsIcon"), {
      key: 5,
      class: normalizeClass(["p-datatable-reorderablerow-handle", $options.columnProp("rowReorderIcon")])
    }, null, 8, ["class"])) : $options.columnProp("expander") ? withDirectives((openBlock(), createElementBlock("button", mergeProps({
      key: 6,
      class: "p-row-toggler p-link",
      type: "button",
      "aria-expanded": $props.isRowExpanded,
      "aria-controls": $props.ariaControls,
      "aria-label": $options.expandButtonAriaLabel,
      onClick: _cache[2] || (_cache[2] = (...args) => $options.toggleRow && $options.toggleRow(...args))
    }, $options.getColumnPTOptions($props.column, "rowToggler")), [
      $props.column.children && $props.column.children.rowtogglericon ? (openBlock(), createBlock(resolveDynamicComponent($props.column.children.rowtogglericon), {
        key: 0,
        rowExpanded: $props.isRowExpanded
      }, null, 8, ["rowExpanded"])) : (openBlock(), createElementBlock(Fragment, { key: 1 }, [
        $props.isRowExpanded && $props.expandedRowIcon ? (openBlock(), createElementBlock("span", {
          key: 0,
          class: normalizeClass(["p-row-toggler-icon", $props.expandedRowIcon])
        }, null, 2)) : $props.isRowExpanded && !$props.expandedRowIcon ? (openBlock(), createBlock(_component_ChevronDownIcon, mergeProps({
          key: 1,
          class: "p-row-toggler-icon"
        }, $options.getColumnPTOptions($props.column, "rowTogglerIcon")), null, 16)) : !$props.isRowExpanded && $props.collapsedRowIcon ? (openBlock(), createElementBlock("span", {
          key: 2,
          class: normalizeClass(["p-row-toggler-icon", $props.collapsedRowIcon])
        }, null, 2)) : !$props.isRowExpanded && !$props.collapsedRowIcon ? (openBlock(), createBlock(_component_ChevronRightIcon, mergeProps({
          key: 3,
          class: "p-row-toggler-icon"
        }, $options.getColumnPTOptions($props.column, "rowTogglerIcon")), null, 16)) : createCommentVNode("", true)
      ], 64))
    ], 16, _hoisted_1$5)), [
      [_directive_ripple]
    ]) : $props.editMode === "row" && $options.columnProp("rowEditor") ? (openBlock(), createElementBlock(Fragment, { key: 7 }, [
      !$data.d_editing ? withDirectives((openBlock(), createElementBlock("button", mergeProps({
        key: 0,
        class: "p-row-editor-init p-link",
        type: "button",
        "aria-label": $options.initButtonAriaLabel,
        onClick: _cache[3] || (_cache[3] = (...args) => $options.onRowEditInit && $options.onRowEditInit(...args))
      }, $options.getColumnPTOptions($props.column, "rowEditorInitButton")), [
        (openBlock(), createBlock(resolveDynamicComponent($props.column.children && $props.column.children.roweditoriniticon || "PencilIcon"), mergeProps({ class: "p-row-editor-init-icon" }, $options.getColumnPTOptions($props.column, "rowEditorInitIcon")), null, 16))
      ], 16, _hoisted_2$2$1)), [
        [_directive_ripple]
      ]) : createCommentVNode("", true),
      $data.d_editing ? withDirectives((openBlock(), createElementBlock("button", mergeProps({
        key: 1,
        class: "p-row-editor-save p-link",
        type: "button",
        "aria-label": $options.saveButtonAriaLabel,
        onClick: _cache[4] || (_cache[4] = (...args) => $options.onRowEditSave && $options.onRowEditSave(...args))
      }, $options.getColumnPTOptions($props.column, "rowEditorEditButton")), [
        (openBlock(), createBlock(resolveDynamicComponent($props.column.children && $props.column.children.roweditorsaveicon || "CheckIcon"), mergeProps({ class: "p-row-editor-save-icon" }, $options.getColumnPTOptions($props.column, "rowEditorEditIcon")), null, 16))
      ], 16, _hoisted_3$2$1)), [
        [_directive_ripple]
      ]) : createCommentVNode("", true),
      $data.d_editing ? withDirectives((openBlock(), createElementBlock("button", mergeProps({
        key: 2,
        class: "p-row-editor-cancel p-link",
        type: "button",
        "aria-label": $options.cancelButtonAriaLabel,
        onClick: _cache[5] || (_cache[5] = (...args) => $options.onRowEditCancel && $options.onRowEditCancel(...args))
      }, $options.getColumnPTOptions($props.column, "rowEditorCancelButton")), [
        (openBlock(), createBlock(resolveDynamicComponent($props.column.children && $props.column.children.roweditorcancelicon || "TimesIcon"), mergeProps({ class: "p-row-editor-cancel-icon" }, $options.getColumnPTOptions($props.column, "rowEditorCancelIcon")), null, 16))
      ], 16, _hoisted_4$1)), [
        [_directive_ripple]
      ]) : createCommentVNode("", true)
    ], 64)) : (openBlock(), createElementBlock(Fragment, { key: 8 }, [
      createTextVNode(toDisplayString($options.resolveFieldData()), 1)
    ], 64))
  ], 16));
}
script$8$1.render = render$8$1;
var script$7$1 = {
  name: "TableBody",
  extends: script$W,
  emits: [
    "rowgroup-toggle",
    "row-click",
    "row-dblclick",
    "row-rightclick",
    "row-touchend",
    "row-keydown",
    "row-mousedown",
    "row-dragstart",
    "row-dragover",
    "row-dragleave",
    "row-dragend",
    "row-drop",
    "row-toggle",
    "radio-change",
    "checkbox-change",
    "cell-edit-init",
    "cell-edit-complete",
    "cell-edit-cancel",
    "row-edit-init",
    "row-edit-save",
    "row-edit-cancel",
    "editing-meta-change"
  ],
  props: {
    value: {
      type: Array,
      default: null
    },
    columns: {
      type: null,
      default: null
    },
    frozenRow: {
      type: Boolean,
      default: false
    },
    empty: {
      type: Boolean,
      default: false
    },
    rowGroupMode: {
      type: String,
      default: null
    },
    groupRowsBy: {
      type: [Array, String, Function],
      default: null
    },
    expandableRowGroups: {
      type: Boolean,
      default: false
    },
    expandedRowGroups: {
      type: Array,
      default: null
    },
    first: {
      type: Number,
      default: 0
    },
    dataKey: {
      type: String,
      default: null
    },
    expandedRowIcon: {
      type: String,
      default: null
    },
    collapsedRowIcon: {
      type: String,
      default: null
    },
    expandedRows: {
      type: Array,
      default: null
    },
    expandedRowKeys: {
      type: null,
      default: null
    },
    selection: {
      type: [Array, Object],
      default: null
    },
    selectionKeys: {
      type: null,
      default: null
    },
    selectionMode: {
      type: String,
      default: null
    },
    contextMenu: {
      type: Boolean,
      default: false
    },
    contextMenuSelection: {
      type: Object,
      default: null
    },
    rowClass: {
      type: null,
      default: null
    },
    rowStyle: {
      type: null,
      default: null
    },
    editMode: {
      type: String,
      default: null
    },
    compareSelectionBy: {
      type: String,
      default: "deepEquals"
    },
    editingRows: {
      type: Array,
      default: null
    },
    editingRowKeys: {
      type: null,
      default: null
    },
    editingMeta: {
      type: Object,
      default: null
    },
    templates: {
      type: null,
      default: null
    },
    scrollable: {
      type: Boolean,
      default: false
    },
    responsiveLayout: {
      type: String,
      default: "stack"
    },
    virtualScrollerContentProps: {
      type: Object,
      default: null
    },
    isVirtualScrollerDisabled: {
      type: Boolean,
      default: false
    }
  },
  data() {
    return {
      rowGroupHeaderStyleObject: {},
      tabindexArray: [],
      isARowSelected: false
    };
  },
  mounted() {
    if (this.frozenRow) {
      this.updateFrozenRowStickyPosition();
    }
    if (this.scrollable && this.rowGroupMode === "subheader") {
      this.updateFrozenRowGroupHeaderStickyPosition();
    }
  },
  updated() {
    if (this.frozenRow) {
      this.updateFrozenRowStickyPosition();
    }
    if (this.scrollable && this.rowGroupMode === "subheader") {
      this.updateFrozenRowGroupHeaderStickyPosition();
    }
  },
  methods: {
    columnProp(col, prop) {
      return ObjectUtils.getVNodeProp(col, prop);
    },
    getColumnPTOptions(column, key) {
      return this.ptmo(this.getColumnProp(column), key, {
        props: column.props,
        parent: {
          props: this.$props,
          state: this.$data
        }
      });
    },
    getColumnProp(column) {
      return column.props && column.props.pt ? column.props.pt : void 0;
    },
    shouldRenderRowGroupHeader(value, rowData, i) {
      let currentRowFieldData = ObjectUtils.resolveFieldData(rowData, this.groupRowsBy);
      let prevRowData = value[i - 1];
      if (prevRowData) {
        let previousRowFieldData = ObjectUtils.resolveFieldData(prevRowData, this.groupRowsBy);
        return currentRowFieldData !== previousRowFieldData;
      } else {
        return true;
      }
    },
    getRowKey(rowData, index) {
      return this.dataKey ? ObjectUtils.resolveFieldData(rowData, this.dataKey) : this.getRowIndex(index);
    },
    getRowIndex(index) {
      const getItemOptions = this.getVirtualScrollerProp("getItemOptions");
      return getItemOptions ? getItemOptions(index).index : this.first + index;
    },
    getRowStyle(rowData) {
      if (this.rowStyle) {
        return this.rowStyle(rowData);
      }
    },
    getRowClass(rowData) {
      let rowStyleClass = [];
      if (this.selectionMode) {
        rowStyleClass.push("p-selectable-row");
      }
      if (this.selection) {
        rowStyleClass.push({
          "p-highlight": this.isSelected(rowData)
        });
      }
      if (this.contextMenuSelection) {
        rowStyleClass.push({
          "p-highlight-contextmenu": this.isSelectedWithContextMenu(rowData)
        });
      }
      if (this.rowClass) {
        let rowClassValue = this.rowClass(rowData);
        if (rowClassValue) {
          rowStyleClass.push(rowClassValue);
        }
      }
      return rowStyleClass;
    },
    shouldRenderRowGroupFooter(value, rowData, i) {
      if (this.expandableRowGroups && !this.isRowGroupExpanded(rowData)) {
        return false;
      } else {
        let currentRowFieldData = ObjectUtils.resolveFieldData(rowData, this.groupRowsBy);
        let nextRowData = value[i + 1];
        if (nextRowData) {
          let nextRowFieldData = ObjectUtils.resolveFieldData(nextRowData, this.groupRowsBy);
          return currentRowFieldData !== nextRowFieldData;
        } else {
          return true;
        }
      }
    },
    shouldRenderBodyCell(value, column, i) {
      if (this.rowGroupMode) {
        if (this.rowGroupMode === "subheader") {
          return this.groupRowsBy !== this.columnProp(column, "field");
        } else if (this.rowGroupMode === "rowspan") {
          if (this.isGrouped(column)) {
            let prevRowData = value[i - 1];
            if (prevRowData) {
              let currentRowFieldData = ObjectUtils.resolveFieldData(value[i], this.columnProp(column, "field"));
              let previousRowFieldData = ObjectUtils.resolveFieldData(prevRowData, this.columnProp(column, "field"));
              return currentRowFieldData !== previousRowFieldData;
            } else {
              return true;
            }
          } else {
            return true;
          }
        }
      } else {
        return !this.columnProp(column, "hidden");
      }
    },
    calculateRowGroupSize(value, column, index) {
      if (this.isGrouped(column)) {
        let currentRowFieldData = ObjectUtils.resolveFieldData(value[index], this.columnProp(column, "field"));
        let nextRowFieldData = currentRowFieldData;
        let groupRowSpan = 0;
        while (currentRowFieldData === nextRowFieldData) {
          groupRowSpan++;
          let nextRowData = value[++index];
          if (nextRowData) {
            nextRowFieldData = ObjectUtils.resolveFieldData(nextRowData, this.columnProp(column, "field"));
          } else {
            break;
          }
        }
        return groupRowSpan === 1 ? null : groupRowSpan;
      } else {
        return null;
      }
    },
    isGrouped(column) {
      if (this.groupRowsBy && this.columnProp(column, "field")) {
        if (Array.isArray(this.groupRowsBy))
          return this.groupRowsBy.indexOf(column.props.field) > -1;
        else
          return this.groupRowsBy === column.props.field;
      } else {
        return false;
      }
    },
    isRowEditing(rowData) {
      if (rowData && this.editingRows) {
        if (this.dataKey)
          return this.editingRowKeys ? this.editingRowKeys[ObjectUtils.resolveFieldData(rowData, this.dataKey)] !== void 0 : false;
        else
          return this.findIndex(rowData, this.editingRows) > -1;
      }
      return false;
    },
    isRowExpanded(rowData) {
      if (rowData && this.expandedRows) {
        if (this.dataKey)
          return this.expandedRowKeys ? this.expandedRowKeys[ObjectUtils.resolveFieldData(rowData, this.dataKey)] !== void 0 : false;
        else
          return this.findIndex(rowData, this.expandedRows) > -1;
      }
      return false;
    },
    isRowGroupExpanded(rowData) {
      if (this.expandableRowGroups && this.expandedRowGroups) {
        let groupFieldValue = ObjectUtils.resolveFieldData(rowData, this.groupRowsBy);
        return this.expandedRowGroups.indexOf(groupFieldValue) > -1;
      }
      return false;
    },
    isSelected(rowData) {
      if (rowData && this.selection) {
        if (this.dataKey) {
          return this.selectionKeys ? this.selectionKeys[ObjectUtils.resolveFieldData(rowData, this.dataKey)] !== void 0 : false;
        } else {
          if (this.selection instanceof Array)
            return this.findIndexInSelection(rowData) > -1;
          else
            return this.equals(rowData, this.selection);
        }
      }
      return false;
    },
    isSelectedWithContextMenu(rowData) {
      if (rowData && this.contextMenuSelection) {
        return this.equals(rowData, this.contextMenuSelection, this.dataKey);
      }
      return false;
    },
    findIndexInSelection(rowData) {
      return this.findIndex(rowData, this.selection);
    },
    findIndex(rowData, collection) {
      let index = -1;
      if (collection && collection.length) {
        for (let i = 0; i < collection.length; i++) {
          if (this.equals(rowData, collection[i])) {
            index = i;
            break;
          }
        }
      }
      return index;
    },
    equals(data1, data2) {
      return this.compareSelectionBy === "equals" ? data1 === data2 : ObjectUtils.equals(data1, data2, this.dataKey);
    },
    onRowGroupToggle(event2, data) {
      this.$emit("rowgroup-toggle", { originalEvent: event2, data });
    },
    onRowClick(event2, rowData, rowIndex) {
      this.$emit("row-click", { originalEvent: event2, data: rowData, index: rowIndex });
    },
    onRowDblClick(event2, rowData, rowIndex) {
      this.$emit("row-dblclick", { originalEvent: event2, data: rowData, index: rowIndex });
    },
    onRowRightClick(event2, rowData, rowIndex) {
      this.$emit("row-rightclick", { originalEvent: event2, data: rowData, index: rowIndex });
    },
    onRowTouchEnd(event2) {
      this.$emit("row-touchend", event2);
    },
    onRowKeyDown(event2, rowData, rowIndex) {
      this.$emit("row-keydown", { originalEvent: event2, data: rowData, index: rowIndex });
    },
    onRowMouseDown(event2) {
      this.$emit("row-mousedown", event2);
    },
    onRowDragStart(event2, rowIndex) {
      this.$emit("row-dragstart", { originalEvent: event2, index: rowIndex });
    },
    onRowDragOver(event2, rowIndex) {
      this.$emit("row-dragover", { originalEvent: event2, index: rowIndex });
    },
    onRowDragLeave(event2) {
      this.$emit("row-dragleave", event2);
    },
    onRowDragEnd(event2) {
      this.$emit("row-dragend", event2);
    },
    onRowDrop(event2) {
      this.$emit("row-drop", event2);
    },
    onRowToggle(event2) {
      this.$emit("row-toggle", event2);
    },
    onRadioChange(event2) {
      this.$emit("radio-change", event2);
    },
    onCheckboxChange(event2) {
      this.$emit("checkbox-change", event2);
    },
    onCellEditInit(event2) {
      this.$emit("cell-edit-init", event2);
    },
    onCellEditComplete(event2) {
      this.$emit("cell-edit-complete", event2);
    },
    onCellEditCancel(event2) {
      this.$emit("cell-edit-cancel", event2);
    },
    onRowEditInit(event2) {
      this.$emit("row-edit-init", event2);
    },
    onRowEditSave(event2) {
      this.$emit("row-edit-save", event2);
    },
    onRowEditCancel(event2) {
      this.$emit("row-edit-cancel", event2);
    },
    onEditingMetaChange(event2) {
      this.$emit("editing-meta-change", event2);
    },
    updateFrozenRowStickyPosition() {
      this.$el.style.top = DomHandler.getOuterHeight(this.$el.previousElementSibling) + "px";
    },
    updateFrozenRowGroupHeaderStickyPosition() {
      let tableHeaderHeight = DomHandler.getOuterHeight(this.$el.previousElementSibling);
      this.rowGroupHeaderStyleObject.top = tableHeaderHeight + "px";
    },
    getVirtualScrollerProp(option, options) {
      options = options || this.virtualScrollerContentProps;
      return options ? options[option] : null;
    },
    bodyRef(el) {
      const contentRef = this.getVirtualScrollerProp("contentRef");
      contentRef && contentRef(el);
    },
    setRowTabindex(index) {
      if (this.selection === null && (this.selectionMode === "single" || this.selectionMode === "multiple")) {
        return index === 0 ? 0 : -1;
      }
      return -1;
    }
  },
  computed: {
    columnsLength() {
      let hiddenColLength = 0;
      this.columns.forEach((column) => {
        if (this.columnProp(column, "selectionMode") === "single")
          hiddenColLength--;
        if (this.columnProp(column, "hidden"))
          hiddenColLength++;
      });
      return this.columns ? this.columns.length - hiddenColLength : 0;
    },
    rowGroupHeaderStyle() {
      if (this.scrollable) {
        return { top: this.rowGroupHeaderStyleObject.top };
      }
      return null;
    },
    bodyStyle() {
      return this.getVirtualScrollerProp("contentStyle");
    },
    expandedRowId() {
      return UniqueComponentId();
    },
    nameAttributeSelector() {
      return UniqueComponentId();
    }
  },
  components: {
    DTBodyCell: script$8$1,
    ChevronDownIcon: script$S,
    ChevronRightIcon: script$L
  }
};
const _hoisted_1$4$1 = ["colspan"];
const _hoisted_2$1$1 = ["onClick"];
const _hoisted_3$1$1 = ["tabindex", "aria-selected", "onClick", "onDblclick", "onContextmenu", "onKeydown", "onDragstart", "onDragover"];
const _hoisted_4$2 = ["id"];
const _hoisted_5 = ["colspan"];
const _hoisted_6 = ["colspan"];
const _hoisted_7 = ["colspan"];
function render$7$1(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_ChevronDownIcon = resolveComponent("ChevronDownIcon");
  const _component_ChevronRightIcon = resolveComponent("ChevronRightIcon");
  const _component_DTBodyCell = resolveComponent("DTBodyCell");
  return openBlock(), createElementBlock("tbody", mergeProps({
    ref: $options.bodyRef,
    class: "p-datatable-tbody",
    role: "rowgroup",
    style: $options.bodyStyle
  }, _ctx.ptm("tbody")), [
    !$props.empty ? (openBlock(true), createElementBlock(Fragment, { key: 0 }, renderList($props.value, (rowData, index) => {
      return openBlock(), createElementBlock(Fragment, null, [
        $props.templates["groupheader"] && $props.rowGroupMode === "subheader" && $options.shouldRenderRowGroupHeader($props.value, rowData, $options.getRowIndex(index)) ? (openBlock(), createElementBlock("tr", mergeProps({
          key: $options.getRowKey(rowData, $options.getRowIndex(index)) + "_subheader",
          class: "p-rowgroup-header",
          style: $options.rowGroupHeaderStyle,
          role: "row"
        }, _ctx.ptm("rowgroupHeader")), [
          createElementVNode("td", mergeProps({
            colspan: $options.columnsLength - 1
          }, { ...$options.getColumnPTOptions("root"), ...$options.getColumnPTOptions("bodyCell") }), [
            $props.expandableRowGroups ? (openBlock(), createElementBlock("button", mergeProps({
              key: 0,
              class: "p-row-toggler p-link",
              onClick: ($event) => $options.onRowGroupToggle($event, rowData),
              type: "button"
            }, $options.getColumnPTOptions("rowGroupToggler")), [
              $props.templates["rowgrouptogglericon"] ? (openBlock(), createBlock(resolveDynamicComponent($props.templates["rowgrouptogglericon"]), {
                key: 0,
                expanded: $options.isRowGroupExpanded(rowData)
              }, null, 8, ["expanded"])) : (openBlock(), createElementBlock(Fragment, { key: 1 }, [
                $options.isRowGroupExpanded(rowData) && $props.expandedRowIcon ? (openBlock(), createElementBlock("span", {
                  key: 0,
                  class: normalizeClass(["p-row-toggler-icon", $props.expandedRowIcon])
                }, null, 2)) : $options.isRowGroupExpanded(rowData) && !$props.expandedRowIcon ? (openBlock(), createBlock(_component_ChevronDownIcon, mergeProps({
                  key: 1,
                  class: "p-row-toggler-icon"
                }, $options.getColumnPTOptions("rowGroupTogglerIcon")), null, 16)) : !$options.isRowGroupExpanded(rowData) && $props.collapsedRowIcon ? (openBlock(), createElementBlock("span", {
                  key: 2,
                  class: normalizeClass(["p-row-toggler-icon", $props.collapsedRowIcon])
                }, null, 2)) : !$options.isRowGroupExpanded(rowData) && !$props.collapsedRowIcon ? (openBlock(), createBlock(_component_ChevronRightIcon, mergeProps({
                  key: 3,
                  class: "p-row-toggler-icon"
                }, $options.getColumnPTOptions("rowGroupTogglerIcon")), null, 16)) : createCommentVNode("", true)
              ], 64))
            ], 16, _hoisted_2$1$1)) : createCommentVNode("", true),
            (openBlock(), createBlock(resolveDynamicComponent($props.templates["groupheader"]), {
              data: rowData,
              index: $options.getRowIndex(index)
            }, null, 8, ["data", "index"]))
          ], 16, _hoisted_1$4$1)
        ], 16)) : createCommentVNode("", true),
        ($props.expandableRowGroups ? $options.isRowGroupExpanded(rowData) : true) ? (openBlock(), createElementBlock("tr", mergeProps({
          key: $options.getRowKey(rowData, $options.getRowIndex(index)),
          class: $options.getRowClass(rowData),
          style: $options.getRowStyle(rowData),
          tabindex: $options.setRowTabindex(index),
          role: "row",
          "aria-selected": $props.selectionMode ? $options.isSelected(rowData) : null,
          onClick: ($event) => $options.onRowClick($event, rowData, $options.getRowIndex(index)),
          onDblclick: ($event) => $options.onRowDblClick($event, rowData, $options.getRowIndex(index)),
          onContextmenu: ($event) => $options.onRowRightClick($event, rowData, $options.getRowIndex(index)),
          onTouchend: _cache[9] || (_cache[9] = ($event) => $options.onRowTouchEnd($event)),
          onKeydown: ($event) => $options.onRowKeyDown($event, rowData, $options.getRowIndex(index)),
          onMousedown: _cache[10] || (_cache[10] = ($event) => $options.onRowMouseDown($event)),
          onDragstart: ($event) => $options.onRowDragStart($event, $options.getRowIndex(index)),
          onDragover: ($event) => $options.onRowDragOver($event, $options.getRowIndex(index)),
          onDragleave: _cache[11] || (_cache[11] = ($event) => $options.onRowDragLeave($event)),
          onDragend: _cache[12] || (_cache[12] = ($event) => $options.onRowDragEnd($event)),
          onDrop: _cache[13] || (_cache[13] = ($event) => $options.onRowDrop($event))
        }, _ctx.ptm("row")), [
          (openBlock(true), createElementBlock(Fragment, null, renderList($props.columns, (col, i) => {
            return openBlock(), createElementBlock(Fragment, null, [
              $options.shouldRenderBodyCell($props.value, col, $options.getRowIndex(index)) ? (openBlock(), createBlock(_component_DTBodyCell, {
                key: $options.columnProp(col, "columnKey") || $options.columnProp(col, "field") || i,
                rowData,
                column: col,
                rowIndex: $options.getRowIndex(index),
                index: i,
                selected: $options.isSelected(rowData),
                frozenRow: $props.frozenRow,
                rowspan: $props.rowGroupMode === "rowspan" ? $options.calculateRowGroupSize($props.value, col, $options.getRowIndex(index)) : null,
                editMode: $props.editMode,
                editing: $props.editMode === "row" && $options.isRowEditing(rowData),
                editingMeta: $props.editingMeta,
                responsiveLayout: $props.responsiveLayout,
                virtualScrollerContentProps: $props.virtualScrollerContentProps,
                ariaControls: $options.expandedRowId + "_" + index + "_expansion",
                name: $options.nameAttributeSelector,
                isRowExpanded: $options.isRowExpanded(rowData),
                expandedRowIcon: $props.expandedRowIcon,
                collapsedRowIcon: $props.collapsedRowIcon,
                onRadioChange: _cache[0] || (_cache[0] = ($event) => $options.onRadioChange($event)),
                onCheckboxChange: _cache[1] || (_cache[1] = ($event) => $options.onCheckboxChange($event)),
                onRowToggle: _cache[2] || (_cache[2] = ($event) => $options.onRowToggle($event)),
                onCellEditInit: _cache[3] || (_cache[3] = ($event) => $options.onCellEditInit($event)),
                onCellEditComplete: _cache[4] || (_cache[4] = ($event) => $options.onCellEditComplete($event)),
                onCellEditCancel: _cache[5] || (_cache[5] = ($event) => $options.onCellEditCancel($event)),
                onRowEditInit: _cache[6] || (_cache[6] = ($event) => $options.onRowEditInit($event)),
                onRowEditSave: _cache[7] || (_cache[7] = ($event) => $options.onRowEditSave($event)),
                onRowEditCancel: _cache[8] || (_cache[8] = ($event) => $options.onRowEditCancel($event)),
                onEditingMetaChange: $options.onEditingMetaChange,
                pt: _ctx.pt
              }, null, 8, ["rowData", "column", "rowIndex", "index", "selected", "frozenRow", "rowspan", "editMode", "editing", "editingMeta", "responsiveLayout", "virtualScrollerContentProps", "ariaControls", "name", "isRowExpanded", "expandedRowIcon", "collapsedRowIcon", "onEditingMetaChange", "pt"])) : createCommentVNode("", true)
            ], 64);
          }), 256))
        ], 16, _hoisted_3$1$1)) : createCommentVNode("", true),
        $props.templates["expansion"] && $props.expandedRows && $options.isRowExpanded(rowData) ? (openBlock(), createElementBlock("tr", mergeProps({
          key: $options.getRowKey(rowData, $options.getRowIndex(index)) + "_expansion",
          id: $options.expandedRowId + "_" + index + "_expansion",
          class: "p-datatable-row-expansion",
          role: "row"
        }, _ctx.ptm("rowExpansion")), [
          createElementVNode("td", mergeProps({ colspan: $options.columnsLength }, { ...$options.getColumnPTOptions("root"), ...$options.getColumnPTOptions("bodyCell") }), [
            (openBlock(), createBlock(resolveDynamicComponent($props.templates["expansion"]), {
              data: rowData,
              index: $options.getRowIndex(index)
            }, null, 8, ["data", "index"]))
          ], 16, _hoisted_5)
        ], 16, _hoisted_4$2)) : createCommentVNode("", true),
        $props.templates["groupfooter"] && $props.rowGroupMode === "subheader" && $options.shouldRenderRowGroupFooter($props.value, rowData, $options.getRowIndex(index)) ? (openBlock(), createElementBlock("tr", mergeProps({
          key: $options.getRowKey(rowData, $options.getRowIndex(index)) + "_subfooter",
          class: "p-rowgroup-footer",
          role: "row"
        }, _ctx.ptm("rowgroupFooter")), [
          createElementVNode("td", mergeProps({
            colspan: $options.columnsLength - 1
          }, { ...$options.getColumnPTOptions("root"), ...$options.getColumnPTOptions("bodyCell") }), [
            (openBlock(), createBlock(resolveDynamicComponent($props.templates["groupfooter"]), {
              data: rowData,
              index: $options.getRowIndex(index)
            }, null, 8, ["data", "index"]))
          ], 16, _hoisted_6)
        ], 16)) : createCommentVNode("", true)
      ], 64);
    }), 256)) : (openBlock(), createElementBlock("tr", mergeProps({
      key: 1,
      class: "p-datatable-emptymessage",
      role: "row"
    }, _ctx.ptm("emptyMessage")), [
      createElementVNode("td", mergeProps({ colspan: $options.columnsLength }, { ...$options.getColumnPTOptions("root"), ...$options.getColumnPTOptions("bodyCell") }), [
        $props.templates.empty ? (openBlock(), createBlock(resolveDynamicComponent($props.templates.empty), { key: 0 })) : createCommentVNode("", true)
      ], 16, _hoisted_7)
    ], 16))
  ], 16);
}
script$7$1.render = render$7$1;
var script$6$1 = {
  name: "FooterCell",
  extends: script$W,
  props: {
    column: {
      type: Object,
      default: null
    }
  },
  data() {
    return {
      styleObject: {}
    };
  },
  mounted() {
    if (this.columnProp("frozen")) {
      this.updateStickyPosition();
    }
  },
  updated() {
    if (this.columnProp("frozen")) {
      this.updateStickyPosition();
    }
  },
  methods: {
    columnProp(prop) {
      return ObjectUtils.getVNodeProp(this.column, prop);
    },
    getColumnPTOptions(key) {
      return this.ptmo(this.getColumnProp(), key, {
        props: this.column.props,
        parent: {
          props: this.$props,
          state: this.$data
        }
      });
    },
    getColumnProp() {
      return this.column.props && this.column.props.pt ? this.column.props.pt : void 0;
    },
    updateStickyPosition() {
      if (this.columnProp("frozen")) {
        let align = this.columnProp("alignFrozen");
        if (align === "right") {
          let right = 0;
          let next = this.$el.nextElementSibling;
          if (next) {
            right = DomHandler.getOuterWidth(next) + parseFloat(next.style.right || 0);
          }
          this.styleObject.right = right + "px";
        } else {
          let left = 0;
          let prev = this.$el.previousElementSibling;
          if (prev) {
            left = DomHandler.getOuterWidth(prev) + parseFloat(prev.style.left || 0);
          }
          this.styleObject.left = left + "px";
        }
      }
    }
  },
  computed: {
    containerClass() {
      return [
        this.columnProp("footerClass"),
        this.columnProp("class"),
        {
          "p-frozen-column": this.columnProp("frozen")
        }
      ];
    },
    containerStyle() {
      let bodyStyle = this.columnProp("footerStyle");
      let columnStyle = this.columnProp("style");
      return this.columnProp("frozen") ? [columnStyle, bodyStyle, this.styleObject] : [columnStyle, bodyStyle];
    }
  }
};
const _hoisted_1$3$1 = ["colspan", "rowspan"];
function render$6$1(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("td", mergeProps({
    style: $options.containerStyle,
    class: $options.containerClass,
    role: "cell",
    colspan: $options.columnProp("colspan"),
    rowspan: $options.columnProp("rowspan")
  }, { ...$options.getColumnPTOptions("root"), ...$options.getColumnPTOptions("footerCell") }), [
    $props.column.children && $props.column.children.footer ? (openBlock(), createBlock(resolveDynamicComponent($props.column.children.footer), {
      key: 0,
      column: $props.column
    }, null, 8, ["column"])) : createCommentVNode("", true),
    createTextVNode(" " + toDisplayString($options.columnProp("footer")), 1)
  ], 16, _hoisted_1$3$1);
}
script$6$1.render = render$6$1;
var script$5$1 = {
  name: "TableFooter",
  extends: script$W,
  props: {
    columnGroup: {
      type: null,
      default: null
    },
    columns: {
      type: Object,
      default: null
    }
  },
  methods: {
    columnProp(col, prop) {
      return ObjectUtils.getVNodeProp(col, prop);
    },
    getColumnGroupPTOptions(key) {
      return this.ptmo(this.getColumnGroupProps(), key, {
        props: this.getColumnGroupProps(),
        parent: {
          props: this.$props,
          state: this.$data
        }
      });
    },
    getColumnGroupProps() {
      return this.columnGroup && this.columnGroup.props && this.columnGroup.props.pt ? this.columnGroup.props.pt : void 0;
    },
    getRowPTOptions(row, key) {
      return this.ptmo(this.getRowProp(row), key, {
        props: row.props,
        parent: {
          props: this.$props,
          state: this.$data
        }
      });
    },
    getRowProp(row) {
      return row.props && row.props.pt ? row.props.pt : void 0;
    },
    getFooterRows() {
      let rows = [];
      let columnGroup = this.columnGroup;
      if (columnGroup.children && columnGroup.children.default) {
        for (let child of columnGroup.children.default()) {
          if (child.type.name === "Row") {
            rows.push(child);
          } else if (child.children && child.children instanceof Array) {
            rows = child.children;
          }
        }
        return rows;
      }
    },
    getFooterColumns(row) {
      let cols = [];
      if (row.children && row.children.default) {
        row.children.default().forEach((child) => {
          if (child.children && child.children instanceof Array)
            cols = [...cols, ...child.children];
          else if (child.type.name === "Column")
            cols.push(child);
        });
        return cols;
      }
    }
  },
  computed: {
    hasFooter() {
      let hasFooter = false;
      if (this.columnGroup) {
        hasFooter = true;
      } else if (this.columns) {
        for (let col of this.columns) {
          if (this.columnProp(col, "footer") || col.children && col.children.footer) {
            hasFooter = true;
            break;
          }
        }
      }
      return hasFooter;
    }
  },
  components: {
    DTFooterCell: script$6$1
  }
};
function render$5$1(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_DTFooterCell = resolveComponent("DTFooterCell");
  return $options.hasFooter ? (openBlock(), createElementBlock("tfoot", mergeProps({
    key: 0,
    class: "p-datatable-tfoot",
    role: "rowgroup"
  }, { ..._ctx.ptm("tfoot"), ...$options.getColumnGroupPTOptions("root") }), [
    !$props.columnGroup ? (openBlock(), createElementBlock("tr", mergeProps({
      key: 0,
      role: "row"
    }, _ctx.ptm("footerRow")), [
      (openBlock(true), createElementBlock(Fragment, null, renderList($props.columns, (col, i) => {
        return openBlock(), createElementBlock(Fragment, {
          key: $options.columnProp(col, "columnKey") || $options.columnProp(col, "field") || i
        }, [
          !$options.columnProp(col, "hidden") ? (openBlock(), createBlock(_component_DTFooterCell, {
            key: 0,
            column: col,
            pt: _ctx.pt
          }, null, 8, ["column", "pt"])) : createCommentVNode("", true)
        ], 64);
      }), 128))
    ], 16)) : (openBlock(true), createElementBlock(Fragment, { key: 1 }, renderList($options.getFooterRows(), (row, i) => {
      return openBlock(), createElementBlock("tr", mergeProps({
        key: i,
        role: "row"
      }, $options.getRowPTOptions(row, "root")), [
        (openBlock(true), createElementBlock(Fragment, null, renderList($options.getFooterColumns(row), (col, j) => {
          return openBlock(), createElementBlock(Fragment, {
            key: $options.columnProp(col, "columnKey") || $options.columnProp(col, "field") || j
          }, [
            !$options.columnProp(col, "hidden") ? (openBlock(), createBlock(_component_DTFooterCell, {
              key: 0,
              column: col,
              pt: _ctx.pt
            }, null, 8, ["column", "pt"])) : createCommentVNode("", true)
          ], 64);
        }), 128))
      ], 16);
    }), 128))
  ], 16)) : createCommentVNode("", true);
}
script$5$1.render = render$5$1;
var script$4$1 = {
  name: "ColumnFilter",
  extends: script$W,
  emits: ["filter-change", "filter-apply", "operator-change", "matchmode-change", "constraint-add", "constraint-remove", "filter-clear", "apply-click"],
  props: {
    field: {
      type: String,
      default: null
    },
    type: {
      type: String,
      default: "text"
    },
    display: {
      type: String,
      default: null
    },
    showMenu: {
      type: Boolean,
      default: true
    },
    matchMode: {
      type: String,
      default: null
    },
    showOperator: {
      type: Boolean,
      default: true
    },
    showClearButton: {
      type: Boolean,
      default: true
    },
    showApplyButton: {
      type: Boolean,
      default: true
    },
    showMatchModes: {
      type: Boolean,
      default: true
    },
    showAddButton: {
      type: Boolean,
      default: true
    },
    matchModeOptions: {
      type: Array,
      default: null
    },
    maxConstraints: {
      type: Number,
      default: 2
    },
    filterElement: {
      type: Function,
      default: null
    },
    filterHeaderTemplate: {
      type: Function,
      default: null
    },
    filterFooterTemplate: {
      type: Function,
      default: null
    },
    filterClearTemplate: {
      type: Function,
      default: null
    },
    filterApplyTemplate: {
      type: Function,
      default: null
    },
    filterIconTemplate: {
      type: Function,
      default: null
    },
    filterAddIconTemplate: {
      type: Function,
      default: null
    },
    filterRemoveIconTemplate: {
      type: Function,
      default: null
    },
    filterClearIconTemplate: {
      type: Function,
      default: null
    },
    filters: {
      type: Object,
      default: null
    },
    filtersStore: {
      type: Object,
      default: null
    },
    filterMenuClass: {
      type: String,
      default: null
    },
    filterMenuStyle: {
      type: null,
      default: null
    },
    filterInputProps: {
      type: null,
      default: null
    },
    column: null
  },
  data() {
    return {
      overlayVisible: false,
      defaultMatchMode: null,
      defaultOperator: null
    };
  },
  overlay: null,
  selfClick: false,
  overlayEventListener: null,
  beforeUnmount() {
    if (this.overlayEventListener) {
      OverlayEventBus.off("overlay-click", this.overlayEventListener);
      this.overlayEventListener = null;
    }
    if (this.overlay) {
      ZIndexUtils.clear(this.overlay);
      this.onOverlayHide();
    }
  },
  mounted() {
    if (this.filters && this.filters[this.field]) {
      let fieldFilters = this.filters[this.field];
      if (fieldFilters.operator) {
        this.defaultMatchMode = fieldFilters.constraints[0].matchMode;
        this.defaultOperator = fieldFilters.operator;
      } else {
        this.defaultMatchMode = this.filters[this.field].matchMode;
      }
    }
  },
  methods: {
    getColumnPTOptions(key) {
      return this.ptmo(this.getColumnProp(), key, {
        props: this.column.props,
        parent: {
          props: this.$props,
          state: this.$data
        }
      });
    },
    getColumnProp() {
      return this.column.props && this.column.props.pt ? this.column.props.pt : void 0;
    },
    clearFilter() {
      let _filters = { ...this.filters };
      if (_filters[this.field].operator) {
        _filters[this.field].constraints.splice(1);
        _filters[this.field].operator = this.defaultOperator;
        _filters[this.field].constraints[0] = { value: null, matchMode: this.defaultMatchMode };
      } else {
        _filters[this.field].value = null;
        _filters[this.field].matchMode = this.defaultMatchMode;
      }
      this.$emit("filter-clear");
      this.$emit("filter-change", _filters);
      this.$emit("filter-apply");
      this.hide();
    },
    applyFilter() {
      this.$emit("apply-click", { field: this.field, constraints: this.filters[this.field] });
      this.$emit("filter-apply");
      this.hide();
    },
    hasFilter() {
      if (this.filtersStore) {
        let fieldFilter = this.filtersStore[this.field];
        if (fieldFilter) {
          if (fieldFilter.operator)
            return !this.isFilterBlank(fieldFilter.constraints[0].value);
          else
            return !this.isFilterBlank(fieldFilter.value);
        }
      }
      return false;
    },
    hasRowFilter() {
      return this.filters[this.field] && !this.isFilterBlank(this.filters[this.field].value);
    },
    isFilterBlank(filter) {
      if (filter !== null && filter !== void 0) {
        if (typeof filter === "string" && filter.trim().length == 0 || filter instanceof Array && filter.length == 0)
          return true;
        else
          return false;
      }
      return true;
    },
    toggleMenu() {
      this.overlayVisible = !this.overlayVisible;
    },
    onToggleButtonKeyDown(event2) {
      switch (event2.code) {
        case "Enter":
        case "Space":
          this.toggleMenu();
          event2.preventDefault();
          break;
        case "Escape":
          this.overlayVisible = false;
          break;
      }
    },
    onRowMatchModeChange(matchMode) {
      let _filters = { ...this.filters };
      _filters[this.field].matchMode = matchMode;
      this.$emit("matchmode-change", { field: this.field, matchMode });
      this.$emit("filter-change", _filters);
      this.$emit("filter-apply");
      this.hide();
    },
    onRowMatchModeKeyDown(event2) {
      let item = event2.target;
      switch (event2.code) {
        case "ArrowDown":
          var nextItem = this.findNextItem(item);
          if (nextItem) {
            item.removeAttribute("tabindex");
            nextItem.tabIndex = "0";
            nextItem.focus();
          }
          event2.preventDefault();
          break;
        case "ArrowUp":
          var prevItem = this.findPrevItem(item);
          if (prevItem) {
            item.removeAttribute("tabindex");
            prevItem.tabIndex = "0";
            prevItem.focus();
          }
          event2.preventDefault();
          break;
      }
    },
    isRowMatchModeSelected(matchMode) {
      return this.filters[this.field].matchMode === matchMode;
    },
    onOperatorChange(value) {
      let _filters = { ...this.filters };
      _filters[this.field].operator = value;
      this.$emit("filter-change", _filters);
      this.$emit("operator-change", { field: this.field, operator: value });
      if (!this.showApplyButton) {
        this.$emit("filter-apply");
      }
    },
    onMenuMatchModeChange(value, index) {
      let _filters = { ...this.filters };
      _filters[this.field].constraints[index].matchMode = value;
      this.$emit("matchmode-change", { field: this.field, matchMode: value, index });
      if (!this.showApplyButton) {
        this.$emit("filter-apply");
      }
    },
    addConstraint() {
      let _filters = { ...this.filters };
      let newConstraint = { value: null, matchMode: this.defaultMatchMode };
      _filters[this.field].constraints.push(newConstraint);
      this.$emit("constraint-add", { field: this.field, constraing: newConstraint });
      this.$emit("filter-change", _filters);
      if (!this.showApplyButton) {
        this.$emit("filter-apply");
      }
    },
    removeConstraint(index) {
      let _filters = { ...this.filters };
      let removedConstraint = _filters[this.field].constraints.splice(index, 1);
      this.$emit("constraint-remove", { field: this.field, constraing: removedConstraint });
      this.$emit("filter-change", _filters);
      if (!this.showApplyButton) {
        this.$emit("filter-apply");
      }
    },
    filterCallback() {
      this.$emit("filter-apply");
    },
    findNextItem(item) {
      let nextItem = item.nextElementSibling;
      if (nextItem)
        return DomHandler.hasClass(nextItem, "p-column-filter-separator") ? this.findNextItem(nextItem) : nextItem;
      else
        return item.parentElement.firstElementChild;
    },
    findPrevItem(item) {
      let prevItem = item.previousElementSibling;
      if (prevItem)
        return DomHandler.hasClass(prevItem, "p-column-filter-separator") ? this.findPrevItem(prevItem) : prevItem;
      else
        return item.parentElement.lastElementChild;
    },
    hide() {
      this.overlayVisible = false;
      DomHandler.focus(this.$refs.icon);
    },
    onContentClick(event2) {
      this.selfClick = true;
      OverlayEventBus.emit("overlay-click", {
        originalEvent: event2,
        target: this.overlay
      });
    },
    onContentMouseDown() {
      this.selfClick = true;
    },
    onOverlayEnter(el) {
      if (this.filterMenuStyle) {
        DomHandler.applyStyle(this.overlay, this.filterMenuStyle);
      }
      ZIndexUtils.set("overlay", el, this.$primevue.config.zIndex.overlay);
      DomHandler.absolutePosition(this.overlay, this.$refs.icon);
      this.bindOutsideClickListener();
      this.bindScrollListener();
      this.bindResizeListener();
      this.overlayEventListener = (e) => {
        if (!this.isOutsideClicked(e.target)) {
          this.selfClick = true;
        }
      };
      OverlayEventBus.on("overlay-click", this.overlayEventListener);
    },
    onOverlayLeave() {
      this.onOverlayHide();
    },
    onOverlayAfterLeave(el) {
      ZIndexUtils.clear(el);
    },
    onOverlayHide() {
      this.unbindOutsideClickListener();
      this.unbindResizeListener();
      this.unbindScrollListener();
      this.overlay = null;
      OverlayEventBus.off("overlay-click", this.overlayEventListener);
      this.overlayEventListener = null;
    },
    overlayRef(el) {
      this.overlay = el;
    },
    isOutsideClicked(target) {
      return !this.isTargetClicked(target) && this.overlay && !(this.overlay.isSameNode(target) || this.overlay.contains(target));
    },
    isTargetClicked(target) {
      return this.$refs.icon && (this.$refs.icon.isSameNode(target) || this.$refs.icon.contains(target));
    },
    bindOutsideClickListener() {
      if (!this.outsideClickListener) {
        this.outsideClickListener = (event2) => {
          if (this.overlayVisible && !this.selfClick && this.isOutsideClicked(event2.target)) {
            this.overlayVisible = false;
          }
          this.selfClick = false;
        };
        document.addEventListener("click", this.outsideClickListener);
      }
    },
    unbindOutsideClickListener() {
      if (this.outsideClickListener) {
        document.removeEventListener("click", this.outsideClickListener);
        this.outsideClickListener = null;
        this.selfClick = false;
      }
    },
    bindScrollListener() {
      if (!this.scrollHandler) {
        this.scrollHandler = new ConnectedOverlayScrollHandler(this.$refs.icon, () => {
          if (this.overlayVisible) {
            this.hide();
          }
        });
      }
      this.scrollHandler.bindScrollListener();
    },
    unbindScrollListener() {
      if (this.scrollHandler) {
        this.scrollHandler.unbindScrollListener();
      }
    },
    bindResizeListener() {
      if (!this.resizeListener) {
        this.resizeListener = () => {
          if (this.overlayVisible && !DomHandler.isTouchDevice()) {
            this.hide();
          }
        };
        window.addEventListener("resize", this.resizeListener);
      }
    },
    unbindResizeListener() {
      if (this.resizeListener) {
        window.removeEventListener("resize", this.resizeListener);
        this.resizeListener = null;
      }
    }
  },
  computed: {
    containerClass() {
      return [
        "p-column-filter p-fluid",
        {
          "p-column-filter-row": this.display === "row",
          "p-column-filter-menu": this.display === "menu"
        }
      ];
    },
    overlayClass() {
      return [
        this.filterMenuClass,
        {
          "p-column-filter-overlay p-component p-fluid": true,
          "p-column-filter-overlay-menu": this.display === "menu",
          "p-input-filled": this.$primevue.config.inputStyle === "filled",
          "p-ripple-disabled": this.$primevue.config.ripple === false
        }
      ];
    },
    showMenuButton() {
      return this.showMenu && (this.display === "row" ? this.type !== "boolean" : true);
    },
    overlayId() {
      return UniqueComponentId();
    },
    matchModes() {
      return this.matchModeOptions || this.$primevue.config.filterMatchModeOptions[this.type].map((key) => {
        return { label: this.$primevue.config.locale[key], value: key };
      });
    },
    isShowMatchModes() {
      return this.type !== "boolean" && this.showMatchModes && this.matchModes;
    },
    operatorOptions() {
      return [
        { label: this.$primevue.config.locale.matchAll, value: FilterOperator.AND },
        { label: this.$primevue.config.locale.matchAny, value: FilterOperator.OR }
      ];
    },
    noFilterLabel() {
      return this.$primevue.config.locale ? this.$primevue.config.locale.noFilter : void 0;
    },
    isShowOperator() {
      return this.showOperator && this.filters[this.field].operator;
    },
    operator() {
      return this.filters[this.field].operator;
    },
    fieldConstraints() {
      return this.filters[this.field].constraints || [this.filters[this.field]];
    },
    showRemoveIcon() {
      return this.fieldConstraints.length > 1;
    },
    removeRuleButtonLabel() {
      return this.$primevue.config.locale ? this.$primevue.config.locale.removeRule : void 0;
    },
    addRuleButtonLabel() {
      return this.$primevue.config.locale ? this.$primevue.config.locale.addRule : void 0;
    },
    isShowAddConstraint() {
      return this.showAddButton && this.filters[this.field].operator && this.fieldConstraints && this.fieldConstraints.length < this.maxConstraints;
    },
    clearButtonLabel() {
      return this.$primevue.config.locale ? this.$primevue.config.locale.clear : void 0;
    },
    applyButtonLabel() {
      return this.$primevue.config.locale ? this.$primevue.config.locale.apply : void 0;
    },
    filterMenuButtonAriaLabel() {
      return this.$primevue.config.locale ? this.overlayVisible ? this.$primevue.config.locale.showFilterMenu : this.$primevue.config.locale.hideFilterMenu : void 0;
    },
    filterOperatorAriaLabel() {
      return this.$primevue.config.locale ? this.$primevue.config.locale.filterOperator : void 0;
    },
    filterConstraintAriaLabel() {
      return this.$primevue.config.locale ? this.$primevue.config.locale.filterConstraint : void 0;
    }
  },
  components: {
    CFDropdown: script$A,
    CFButton: script$T,
    Portal: script$Q,
    FilterSlashIcon: script$g,
    FilterIcon: script$B,
    TrashIcon: script$f,
    PlusIcon: script$r
  },
  directives: {
    focustrap: FocusTrap
  }
};
const _hoisted_1$2$1 = ["aria-label", "aria-expanded", "aria-controls"];
const _hoisted_2$4 = ["id", "aria-modal"];
const _hoisted_3$3 = ["onClick", "onKeydown", "tabindex"];
function render$4$1(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_CFDropdown = resolveComponent("CFDropdown");
  const _component_CFButton = resolveComponent("CFButton");
  const _component_Portal = resolveComponent("Portal");
  const _directive_focustrap = resolveDirective("focustrap");
  return openBlock(), createElementBlock("div", mergeProps({ class: $options.containerClass }, $options.getColumnPTOptions("columnFilter")), [
    $props.display === "row" ? (openBlock(), createElementBlock("div", mergeProps({
      key: 0,
      class: "p-fluid p-column-filter-element"
    }, { ...$props.filterInputProps, ...$options.getColumnPTOptions("filterInput") }), [
      (openBlock(), createBlock(resolveDynamicComponent($props.filterElement), {
        field: $props.field,
        filterModel: $props.filters[$props.field],
        filterCallback: $options.filterCallback
      }, null, 8, ["field", "filterModel", "filterCallback"]))
    ], 16)) : createCommentVNode("", true),
    $options.showMenuButton ? (openBlock(), createElementBlock("button", mergeProps({
      key: 1,
      ref: "icon",
      type: "button",
      class: ["p-column-filter-menu-button p-link", { "p-column-filter-menu-button-open": $data.overlayVisible, "p-column-filter-menu-button-active": $options.hasFilter() }],
      "aria-label": $options.filterMenuButtonAriaLabel,
      "aria-haspopup": "true",
      "aria-expanded": $data.overlayVisible,
      "aria-controls": $options.overlayId,
      onClick: _cache[0] || (_cache[0] = ($event) => $options.toggleMenu()),
      onKeydown: _cache[1] || (_cache[1] = ($event) => $options.onToggleButtonKeyDown($event))
    }, $options.getColumnPTOptions("filterMenuButton")), [
      (openBlock(), createBlock(resolveDynamicComponent($props.filterIconTemplate || "FilterIcon")))
    ], 16, _hoisted_1$2$1)) : createCommentVNode("", true),
    $props.showClearButton && $props.display === "row" ? (openBlock(), createElementBlock("button", mergeProps({
      key: 2,
      class: [{ "p-hidden-space": !$options.hasRowFilter() }, "p-column-filter-clear-button p-link"],
      type: "button",
      onClick: _cache[2] || (_cache[2] = ($event) => $options.clearFilter())
    }, $options.getColumnPTOptions("headerFilterClearButton")), [
      (openBlock(), createBlock(resolveDynamicComponent($props.filterClearIconTemplate || "FilterSlashIcon"), normalizeProps(guardReactiveProps($options.getColumnPTOptions("filterClearIcon"))), null, 16))
    ], 16)) : createCommentVNode("", true),
    createVNode(_component_Portal, null, {
      default: withCtx(() => [
        createVNode(Transition, {
          name: "p-connected-overlay",
          onEnter: $options.onOverlayEnter,
          onLeave: $options.onOverlayLeave,
          onAfterLeave: $options.onOverlayAfterLeave
        }, {
          default: withCtx(() => [
            $data.overlayVisible ? withDirectives((openBlock(), createElementBlock("div", mergeProps({
              key: 0,
              ref: $options.overlayRef,
              id: $options.overlayId,
              "aria-modal": $data.overlayVisible,
              role: "dialog",
              class: $options.overlayClass,
              onKeydown: _cache[10] || (_cache[10] = withKeys((...args) => $options.hide && $options.hide(...args), ["escape"])),
              onClick: _cache[11] || (_cache[11] = (...args) => $options.onContentClick && $options.onContentClick(...args)),
              onMousedown: _cache[12] || (_cache[12] = (...args) => $options.onContentMouseDown && $options.onContentMouseDown(...args))
            }, $options.getColumnPTOptions("filterOverlay")), [
              (openBlock(), createBlock(resolveDynamicComponent($props.filterHeaderTemplate), {
                field: $props.field,
                filterModel: $props.filters[$props.field],
                filterCallback: $options.filterCallback
              }, null, 8, ["field", "filterModel", "filterCallback"])),
              $props.display === "row" ? (openBlock(), createElementBlock("ul", mergeProps({
                key: 0,
                class: "p-column-filter-row-items"
              }, $options.getColumnPTOptions("filterRowItems")), [
                (openBlock(true), createElementBlock(Fragment, null, renderList($options.matchModes, (matchMode, i) => {
                  return openBlock(), createElementBlock("li", mergeProps({
                    key: matchMode.label,
                    class: ["p-column-filter-row-item", { "p-highlight": $options.isRowMatchModeSelected(matchMode.value) }],
                    onClick: ($event) => $options.onRowMatchModeChange(matchMode.value),
                    onKeydown: [
                      _cache[3] || (_cache[3] = ($event) => $options.onRowMatchModeKeyDown($event)),
                      withKeys(withModifiers(($event) => $options.onRowMatchModeChange(matchMode.value), ["prevent"]), ["enter"])
                    ],
                    tabindex: i === 0 ? "0" : null
                  }, $options.getColumnPTOptions("filterRowItem")), toDisplayString(matchMode.label), 17, _hoisted_3$3);
                }), 128)),
                createElementVNode("li", mergeProps({ class: "p-column-filter-separator" }, $options.getColumnPTOptions("filterInput")), null, 16),
                createElementVNode("li", mergeProps({
                  class: "p-column-filter-row-item",
                  onClick: _cache[4] || (_cache[4] = ($event) => $options.clearFilter()),
                  onKeydown: [
                    _cache[5] || (_cache[5] = ($event) => $options.onRowMatchModeKeyDown($event)),
                    _cache[6] || (_cache[6] = withKeys(($event) => _ctx.onRowClearItemClick(), ["enter"]))
                  ]
                }, $options.getColumnPTOptions("filterRowItem")), toDisplayString($options.noFilterLabel), 17)
              ], 16)) : (openBlock(), createElementBlock(Fragment, { key: 1 }, [
                $options.isShowOperator ? (openBlock(), createElementBlock("div", mergeProps({
                  key: 0,
                  class: "p-column-filter-operator"
                }, $options.getColumnPTOptions("filterOperator")), [
                  createVNode(_component_CFDropdown, {
                    options: $options.operatorOptions,
                    modelValue: $options.operator,
                    "aria-label": $options.filterOperatorAriaLabel,
                    class: "p-column-filter-operator-dropdown",
                    optionLabel: "label",
                    optionValue: "value",
                    "onUpdate:modelValue": _cache[7] || (_cache[7] = ($event) => $options.onOperatorChange($event)),
                    pt: $options.getColumnPTOptions("filterOperatorDropdown")
                  }, null, 8, ["options", "modelValue", "aria-label", "pt"])
                ], 16)) : createCommentVNode("", true),
                createElementVNode("div", mergeProps({ class: "p-column-filter-constraints" }, $options.getColumnPTOptions("filterConstraints")), [
                  (openBlock(true), createElementBlock(Fragment, null, renderList($options.fieldConstraints, (fieldConstraint, i) => {
                    return openBlock(), createElementBlock("div", mergeProps({
                      key: i,
                      class: "p-column-filter-constraint"
                    }, $options.getColumnPTOptions("filterConstraint")), [
                      $options.isShowMatchModes ? (openBlock(), createBlock(_component_CFDropdown, {
                        key: 0,
                        options: $options.matchModes,
                        modelValue: fieldConstraint.matchMode,
                        class: "p-column-filter-matchmode-dropdown",
                        optionLabel: "label",
                        optionValue: "value",
                        "aria-label": $options.filterConstraintAriaLabel,
                        "onUpdate:modelValue": ($event) => $options.onMenuMatchModeChange($event, i),
                        pt: $options.getColumnPTOptions("filterMatchModeDropdown")
                      }, null, 8, ["options", "modelValue", "aria-label", "onUpdate:modelValue", "pt"])) : createCommentVNode("", true),
                      $props.display === "menu" ? (openBlock(), createBlock(resolveDynamicComponent($props.filterElement), {
                        key: 1,
                        field: $props.field,
                        filterModel: fieldConstraint,
                        filterCallback: $options.filterCallback
                      }, null, 8, ["field", "filterModel", "filterCallback"])) : createCommentVNode("", true),
                      createElementVNode("div", normalizeProps(guardReactiveProps($options.getColumnPTOptions("filterRemove"))), [
                        $options.showRemoveIcon ? (openBlock(), createBlock(_component_CFButton, {
                          key: 0,
                          type: "button",
                          class: "p-column-filter-remove-button p-button-text p-button-danger p-button-sm",
                          onClick: ($event) => $options.removeConstraint(i),
                          label: $options.removeRuleButtonLabel,
                          pt: $options.getColumnPTOptions("filterRemoveButton")
                        }, {
                          icon: withCtx((iconProps) => [
                            (openBlock(), createBlock(resolveDynamicComponent($props.filterRemoveIconTemplate || "TrashIcon"), mergeProps({
                              class: iconProps.class
                            }, $options.getColumnPTOptions("filterRemoveButton")["icon"]), null, 16, ["class"]))
                          ]),
                          _: 2
                        }, 1032, ["onClick", "label", "pt"])) : createCommentVNode("", true)
                      ], 16)
                    ], 16);
                  }), 128))
                ], 16),
                $options.isShowAddConstraint ? (openBlock(), createElementBlock("div", mergeProps({
                  key: 1,
                  class: "p-column-filter-add-rule"
                }, $options.getColumnPTOptions("filterAddRule")), [
                  createVNode(_component_CFButton, {
                    type: "button",
                    label: $options.addRuleButtonLabel,
                    iconPos: "left",
                    class: "p-column-filter-add-button p-button-text p-button-sm",
                    onClick: _cache[8] || (_cache[8] = ($event) => $options.addConstraint()),
                    pt: $options.getColumnPTOptions("filterAddRuleButton")
                  }, {
                    icon: withCtx((iconProps) => [
                      (openBlock(), createBlock(resolveDynamicComponent($props.filterAddIconTemplate || "PlusIcon"), mergeProps({
                        class: iconProps.class
                      }, $options.getColumnPTOptions("filterAddRuleButton")["icon"]), null, 16, ["class"]))
                    ]),
                    _: 1
                  }, 8, ["label", "pt"])
                ], 16)) : createCommentVNode("", true),
                createElementVNode("div", mergeProps({ class: "p-column-filter-buttonbar" }, $options.getColumnPTOptions("filterButtonbar")), [
                  !$props.filterClearTemplate && $props.showClearButton ? (openBlock(), createBlock(_component_CFButton, {
                    key: 0,
                    type: "button",
                    class: "p-button-outlined p-button-sm",
                    label: $options.clearButtonLabel,
                    onClick: $options.clearFilter,
                    pt: $options.getColumnPTOptions("filterClearButton")
                  }, null, 8, ["label", "onClick", "pt"])) : (openBlock(), createBlock(resolveDynamicComponent($props.filterClearTemplate), {
                    key: 1,
                    field: $props.field,
                    filterModel: $props.filters[$props.field],
                    filterCallback: $options.clearFilter
                  }, null, 8, ["field", "filterModel", "filterCallback"])),
                  $props.showApplyButton ? (openBlock(), createElementBlock(Fragment, { key: 2 }, [
                    !$props.filterApplyTemplate ? (openBlock(), createBlock(_component_CFButton, mergeProps({
                      key: 0,
                      type: "button",
                      class: "p-button-sm",
                      label: $options.applyButtonLabel,
                      onClick: _cache[9] || (_cache[9] = ($event) => $options.applyFilter())
                    }, $options.getColumnPTOptions("filterApplyButton")), null, 16, ["label"])) : (openBlock(), createBlock(resolveDynamicComponent($props.filterApplyTemplate), {
                      key: 1,
                      field: $props.field,
                      filterModel: $props.filters[$props.field],
                      filterCallback: $options.applyFilter
                    }, null, 8, ["field", "filterModel", "filterCallback"]))
                  ], 64)) : createCommentVNode("", true)
                ], 16)
              ], 64)),
              (openBlock(), createBlock(resolveDynamicComponent($props.filterFooterTemplate), {
                field: $props.field,
                filterModel: $props.filters[$props.field],
                filterCallback: $options.filterCallback
              }, null, 8, ["field", "filterModel", "filterCallback"]))
            ], 16, _hoisted_2$4)), [
              [_directive_focustrap, { autoFocus: true }]
            ]) : createCommentVNode("", true)
          ]),
          _: 1
        }, 8, ["onEnter", "onLeave", "onAfterLeave"])
      ]),
      _: 1
    })
  ], 16);
}
script$4$1.render = render$4$1;
var script$3$1 = {
  name: "HeaderCheckbox",
  extends: script$W,
  emits: ["change"],
  props: {
    checked: null,
    disabled: null,
    column: null,
    headerCheckboxIconTemplate: {
      type: Function,
      default: null
    }
  },
  data() {
    return {
      focused: false
    };
  },
  methods: {
    getColumnPTOptions(key) {
      return this.ptmo(this.getColumnProp(), key, {
        props: this.column.props,
        parent: {
          props: this.$props,
          state: this.$data
        },
        context: {
          checked: this.checked,
          focused: this.focused,
          disabled: this.disabled
        }
      });
    },
    getColumnProp() {
      return this.column.props && this.column.props.pt ? this.column.props.pt : void 0;
    },
    onClick(event2) {
      if (!this.disabled) {
        this.$emit("change", {
          originalEvent: event2,
          checked: !this.checked
        });
        DomHandler.focus(this.$refs.input);
      }
    },
    onFocus() {
      this.focused = true;
    },
    onBlur() {
      this.focused = false;
    }
  },
  computed: {
    headerCheckboxAriaLabel() {
      return this.$primevue.config.locale.aria ? this.checked ? this.$primevue.config.locale.aria.selectAll : this.$primevue.config.locale.aria.unselectAll : void 0;
    }
  },
  components: {
    CheckIcon: script$H
  }
};
const _hoisted_1$1$1 = ["checked", "disabled", "tabindex", "aria-label"];
function render$3$1(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_CheckIcon = resolveComponent("CheckIcon");
  return openBlock(), createElementBlock("div", mergeProps({
    class: ["p-checkbox p-component", { "p-checkbox-focused": $data.focused, "p-disabled": $props.disabled }],
    onClick: _cache[2] || (_cache[2] = (...args) => $options.onClick && $options.onClick(...args)),
    onKeydown: _cache[3] || (_cache[3] = withKeys(withModifiers((...args) => $options.onClick && $options.onClick(...args), ["prevent"]), ["space"]))
  }, $options.getColumnPTOptions("headerCheckboxWrapper")), [
    createElementVNode("div", mergeProps({ class: "p-hidden-accessible" }, $options.getColumnPTOptions("hiddenHeaderInputWrapper")), [
      createElementVNode("input", mergeProps({
        ref: "input",
        type: "checkbox",
        checked: $props.checked,
        disabled: $props.disabled,
        tabindex: $props.disabled ? null : "0",
        "aria-label": $options.headerCheckboxAriaLabel,
        onFocus: _cache[0] || (_cache[0] = ($event) => $options.onFocus($event)),
        onBlur: _cache[1] || (_cache[1] = ($event) => $options.onBlur($event))
      }, $options.getColumnPTOptions("hiddenHeaderInput")), null, 16, _hoisted_1$1$1)
    ], 16),
    createElementVNode("div", mergeProps({
      ref: "box",
      class: ["p-checkbox-box p-component", { "p-highlight": $props.checked, "p-disabled": $props.disabled, "p-focus": $data.focused }]
    }, $options.getColumnPTOptions("headerCheckbox")), [
      $props.headerCheckboxIconTemplate ? (openBlock(), createBlock(resolveDynamicComponent($props.headerCheckboxIconTemplate), {
        key: 0,
        checked: $props.checked,
        class: "p-checkbox-icon"
      }, null, 8, ["checked"])) : !$props.headerCheckboxIconTemplate && !!$props.checked ? (openBlock(), createBlock(_component_CheckIcon, mergeProps({
        key: 1,
        class: "p-checkbox-icon"
      }, $options.getColumnPTOptions("headerCheckboxIcon")), null, 16)) : createCommentVNode("", true)
    ], 16)
  ], 16);
}
script$3$1.render = render$3$1;
var script$2$1 = {
  name: "HeaderCell",
  extends: script$W,
  emits: [
    "column-click",
    "column-mousedown",
    "column-dragstart",
    "column-dragover",
    "column-dragleave",
    "column-drop",
    "column-resizestart",
    "checkbox-change",
    "filter-change",
    "filter-apply",
    "operator-change",
    "matchmode-change",
    "constraint-add",
    "constraint-remove",
    "filter-clear",
    "apply-click"
  ],
  props: {
    column: {
      type: Object,
      default: null
    },
    resizableColumns: {
      type: Boolean,
      default: false
    },
    groupRowsBy: {
      type: [Array, String, Function],
      default: null
    },
    sortMode: {
      type: String,
      default: "single"
    },
    groupRowSortField: {
      type: [String, Function],
      default: null
    },
    sortField: {
      type: [String, Function],
      default: null
    },
    sortOrder: {
      type: Number,
      default: null
    },
    multiSortMeta: {
      type: Array,
      default: null
    },
    allRowsSelected: {
      type: Boolean,
      default: false
    },
    empty: {
      type: Boolean,
      default: false
    },
    filterDisplay: {
      type: String,
      default: null
    },
    filters: {
      type: Object,
      default: null
    },
    filtersStore: {
      type: Object,
      default: null
    },
    filterColumn: {
      type: Boolean,
      default: false
    },
    reorderableColumns: {
      type: Boolean,
      default: false
    },
    filterInputProps: {
      type: null,
      default: null
    },
    headerCheckboxIconTemplate: {
      type: Function,
      default: null
    }
  },
  data() {
    return {
      styleObject: {}
    };
  },
  mounted() {
    if (this.columnProp("frozen")) {
      this.updateStickyPosition();
    }
  },
  updated() {
    if (this.columnProp("frozen")) {
      this.updateStickyPosition();
    }
  },
  methods: {
    columnProp(prop) {
      return ObjectUtils.getVNodeProp(this.column, prop);
    },
    getColumnPTOptions(key) {
      return this.ptmo(this.getColumnProp(), key, {
        props: this.column.props,
        parent: {
          props: this.$props,
          state: this.$data
        }
      });
    },
    getColumnProp() {
      return this.column.props && this.column.props.pt ? this.column.props.pt : void 0;
    },
    onClick(event2) {
      this.$emit("column-click", { originalEvent: event2, column: this.column });
    },
    onKeyDown(event2) {
      if ((event2.code === "Enter" || event2.code === "Space") && event2.currentTarget.nodeName === "TH" && DomHandler.hasClass(event2.currentTarget, "p-sortable-column")) {
        this.$emit("column-click", { originalEvent: event2, column: this.column });
        event2.preventDefault();
      }
    },
    onMouseDown(event2) {
      this.$emit("column-mousedown", { originalEvent: event2, column: this.column });
    },
    onDragStart(event2) {
      this.$emit("column-dragstart", event2);
    },
    onDragOver(event2) {
      this.$emit("column-dragover", event2);
    },
    onDragLeave(event2) {
      this.$emit("column-dragleave", event2);
    },
    onDrop(event2) {
      this.$emit("column-drop", event2);
    },
    onResizeStart(event2) {
      this.$emit("column-resizestart", event2);
    },
    getMultiSortMetaIndex() {
      return this.multiSortMeta.findIndex((meta) => meta.field === this.columnProp("field") || meta.field === this.columnProp("sortField"));
    },
    getBadgeValue() {
      let index = this.getMultiSortMetaIndex();
      return this.groupRowsBy && this.groupRowsBy === this.groupRowSortField && index > -1 ? index : index + 1;
    },
    isMultiSorted() {
      return this.sortMode === "multiple" && this.columnProp("sortable") && this.getMultiSortMetaIndex() > -1;
    },
    isColumnSorted() {
      return this.sortMode === "single" ? this.sortField && (this.sortField === this.columnProp("field") || this.sortField === this.columnProp("sortField")) : this.isMultiSorted();
    },
    updateStickyPosition() {
      if (this.columnProp("frozen")) {
        let align = this.columnProp("alignFrozen");
        if (align === "right") {
          let right = 0;
          let next = this.$el.nextElementSibling;
          if (next) {
            right = DomHandler.getOuterWidth(next) + parseFloat(next.style.right || 0);
          }
          this.styleObject.right = right + "px";
        } else {
          let left = 0;
          let prev = this.$el.previousElementSibling;
          if (prev) {
            left = DomHandler.getOuterWidth(prev) + parseFloat(prev.style.left || 0);
          }
          this.styleObject.left = left + "px";
        }
        let filterRow = this.$el.parentElement.nextElementSibling;
        if (filterRow) {
          let index = DomHandler.index(this.$el);
          filterRow.children[index].style.left = this.styleObject.left;
          filterRow.children[index].style.right = this.styleObject.right;
        }
      }
    },
    onHeaderCheckboxChange(event2) {
      this.$emit("checkbox-change", event2);
    }
  },
  computed: {
    containerClass() {
      return [
        this.filterColumn ? this.columnProp("filterHeaderClass") : this.columnProp("headerClass"),
        this.columnProp("class"),
        {
          "p-sortable-column": this.columnProp("sortable"),
          "p-resizable-column": this.resizableColumns,
          "p-highlight": this.isColumnSorted(),
          "p-filter-column": this.filterColumn,
          "p-frozen-column": this.columnProp("frozen"),
          "p-reorderable-column": this.reorderableColumns
        }
      ];
    },
    containerStyle() {
      let headerStyle = this.filterColumn ? this.columnProp("filterHeaderStyle") : this.columnProp("headerStyle");
      let columnStyle = this.columnProp("style");
      return this.columnProp("frozen") ? [columnStyle, headerStyle, this.styleObject] : [columnStyle, headerStyle];
    },
    sortState() {
      let sorted = false;
      let sortOrder = null;
      if (this.sortMode === "single") {
        sorted = this.sortField && (this.sortField === this.columnProp("field") || this.sortField === this.columnProp("sortField"));
        sortOrder = sorted ? this.sortOrder : 0;
      } else if (this.sortMode === "multiple") {
        let metaIndex = this.getMultiSortMetaIndex();
        if (metaIndex > -1) {
          sorted = true;
          sortOrder = this.multiSortMeta[metaIndex].order;
        }
      }
      return {
        sorted,
        sortOrder
      };
    },
    sortableColumnIcon() {
      const { sorted, sortOrder } = this.sortState;
      if (!sorted)
        return script$e;
      else if (sorted && sortOrder > 0)
        return script$c;
      else if (sorted && sortOrder < 0)
        return script$d;
      return null;
    },
    ariaSort() {
      if (this.columnProp("sortable")) {
        const { sorted, sortOrder } = this.sortState;
        if (sorted && sortOrder < 0)
          return "descending";
        else if (sorted && sortOrder > 0)
          return "ascending";
        else
          return "none";
      } else {
        return null;
      }
    }
  },
  components: {
    DTHeaderCheckbox: script$3$1,
    DTColumnFilter: script$4$1,
    SortAltIcon: script$e,
    SortAmountUpAltIcon: script$c,
    SortAmountDownIcon: script$d
  }
};
const _hoisted_1$8 = ["tabindex", "colspan", "rowspan", "aria-sort"];
function render$2$1(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_DTHeaderCheckbox = resolveComponent("DTHeaderCheckbox");
  const _component_DTColumnFilter = resolveComponent("DTColumnFilter");
  return openBlock(), createElementBlock("th", mergeProps({
    style: $options.containerStyle,
    class: $options.containerClass,
    tabindex: $options.columnProp("sortable") ? "0" : null,
    role: "columnheader",
    colspan: $options.columnProp("colspan"),
    rowspan: $options.columnProp("rowspan"),
    "aria-sort": $options.ariaSort,
    onClick: _cache[8] || (_cache[8] = (...args) => $options.onClick && $options.onClick(...args)),
    onKeydown: _cache[9] || (_cache[9] = (...args) => $options.onKeyDown && $options.onKeyDown(...args)),
    onMousedown: _cache[10] || (_cache[10] = (...args) => $options.onMouseDown && $options.onMouseDown(...args)),
    onDragstart: _cache[11] || (_cache[11] = (...args) => $options.onDragStart && $options.onDragStart(...args)),
    onDragover: _cache[12] || (_cache[12] = (...args) => $options.onDragOver && $options.onDragOver(...args)),
    onDragleave: _cache[13] || (_cache[13] = (...args) => $options.onDragLeave && $options.onDragLeave(...args)),
    onDrop: _cache[14] || (_cache[14] = (...args) => $options.onDrop && $options.onDrop(...args))
  }, { ...$options.getColumnPTOptions("root"), ...$options.getColumnPTOptions("headerCell") }), [
    $props.resizableColumns && !$options.columnProp("frozen") ? (openBlock(), createElementBlock("span", mergeProps({
      key: 0,
      class: "p-column-resizer",
      onMousedown: _cache[0] || (_cache[0] = (...args) => $options.onResizeStart && $options.onResizeStart(...args))
    }, $options.getColumnPTOptions("columnResizer")), null, 16)) : createCommentVNode("", true),
    createElementVNode("div", mergeProps({ class: "p-column-header-content" }, $options.getColumnPTOptions("headerContent")), [
      $props.column.children && $props.column.children.header ? (openBlock(), createBlock(resolveDynamicComponent($props.column.children.header), {
        key: 0,
        column: $props.column
      }, null, 8, ["column"])) : createCommentVNode("", true),
      $options.columnProp("header") ? (openBlock(), createElementBlock("span", mergeProps({
        key: 1,
        class: "p-column-title"
      }, $options.getColumnPTOptions("headerTitle")), toDisplayString($options.columnProp("header")), 17)) : createCommentVNode("", true),
      $options.columnProp("sortable") ? (openBlock(), createElementBlock("span", normalizeProps(mergeProps({ key: 2 }, $options.getColumnPTOptions("sort"))), [
        (openBlock(), createBlock(resolveDynamicComponent($props.column.children && $props.column.children.sorticon || $options.sortableColumnIcon), {
          sorted: $options.sortState.sorted,
          sortOrder: $options.sortState.sortOrder,
          class: "p-sortable-column-icon"
        }, null, 8, ["sorted", "sortOrder"]))
      ], 16)) : createCommentVNode("", true),
      $options.isMultiSorted() ? (openBlock(), createElementBlock("span", mergeProps({
        key: 3,
        class: "p-sortable-column-badge"
      }, $options.getColumnPTOptions("sortBadge")), toDisplayString($options.getBadgeValue()), 17)) : createCommentVNode("", true),
      $options.columnProp("selectionMode") === "multiple" && $props.filterDisplay !== "row" ? (openBlock(), createBlock(_component_DTHeaderCheckbox, {
        key: 4,
        checked: $props.allRowsSelected,
        onChange: $options.onHeaderCheckboxChange,
        disabled: $props.empty,
        headerCheckboxIconTemplate: $props.headerCheckboxIconTemplate,
        column: $props.column,
        pt: _ctx.pt
      }, null, 8, ["checked", "onChange", "disabled", "headerCheckboxIconTemplate", "column", "pt"])) : createCommentVNode("", true),
      $props.filterDisplay === "menu" && $props.column.children && $props.column.children.filter ? (openBlock(), createBlock(_component_DTColumnFilter, {
        key: 5,
        field: $options.columnProp("filterField") || $options.columnProp("field"),
        type: $options.columnProp("dataType"),
        display: "menu",
        showMenu: $options.columnProp("showFilterMenu"),
        filterElement: $props.column.children && $props.column.children.filter,
        filterHeaderTemplate: $props.column.children && $props.column.children.filterheader,
        filterFooterTemplate: $props.column.children && $props.column.children.filterfooter,
        filterClearTemplate: $props.column.children && $props.column.children.filterclear,
        filterApplyTemplate: $props.column.children && $props.column.children.filterapply,
        filterIconTemplate: $props.column.children && $props.column.children.filtericon,
        filterAddIconTemplate: $props.column.children && $props.column.children.filteraddicon,
        filterRemoveIconTemplate: $props.column.children && $props.column.children.filterremoveicon,
        filterClearIconTemplate: $props.column.children && $props.column.children.filterclearicon,
        filters: $props.filters,
        filtersStore: $props.filtersStore,
        filterInputProps: $props.filterInputProps,
        onFilterChange: _cache[1] || (_cache[1] = ($event) => _ctx.$emit("filter-change", $event)),
        onFilterApply: _cache[2] || (_cache[2] = ($event) => _ctx.$emit("filter-apply")),
        filterMenuStyle: $options.columnProp("filterMenuStyle"),
        filterMenuClass: $options.columnProp("filterMenuClass"),
        showOperator: $options.columnProp("showFilterOperator"),
        showClearButton: $options.columnProp("showClearButton"),
        showApplyButton: $options.columnProp("showApplyButton"),
        showMatchModes: $options.columnProp("showFilterMatchModes"),
        showAddButton: $options.columnProp("showAddButton"),
        matchModeOptions: $options.columnProp("filterMatchModeOptions"),
        maxConstraints: $options.columnProp("maxConstraints"),
        onOperatorChange: _cache[3] || (_cache[3] = ($event) => _ctx.$emit("operator-change", $event)),
        onMatchmodeChange: _cache[4] || (_cache[4] = ($event) => _ctx.$emit("matchmode-change", $event)),
        onConstraintAdd: _cache[5] || (_cache[5] = ($event) => _ctx.$emit("constraint-add", $event)),
        onConstraintRemove: _cache[6] || (_cache[6] = ($event) => _ctx.$emit("constraint-remove", $event)),
        onApplyClick: _cache[7] || (_cache[7] = ($event) => _ctx.$emit("apply-click", $event)),
        pt: _ctx.pt,
        column: $props.column
      }, null, 8, ["field", "type", "showMenu", "filterElement", "filterHeaderTemplate", "filterFooterTemplate", "filterClearTemplate", "filterApplyTemplate", "filterIconTemplate", "filterAddIconTemplate", "filterRemoveIconTemplate", "filterClearIconTemplate", "filters", "filtersStore", "filterInputProps", "filterMenuStyle", "filterMenuClass", "showOperator", "showClearButton", "showApplyButton", "showMatchModes", "showAddButton", "matchModeOptions", "maxConstraints", "pt", "column"])) : createCommentVNode("", true)
    ], 16)
  ], 16, _hoisted_1$8);
}
script$2$1.render = render$2$1;
var script$1$1 = {
  name: "TableHeader",
  extends: script$W,
  emits: [
    "column-click",
    "column-mousedown",
    "column-dragstart",
    "column-dragover",
    "column-dragleave",
    "column-drop",
    "column-resizestart",
    "checkbox-change",
    "filter-change",
    "filter-apply",
    "operator-change",
    "matchmode-change",
    "constraint-add",
    "constraint-remove",
    "filter-clear",
    "apply-click"
  ],
  props: {
    columnGroup: {
      type: null,
      default: null
    },
    columns: {
      type: null,
      default: null
    },
    rowGroupMode: {
      type: String,
      default: null
    },
    groupRowsBy: {
      type: [Array, String, Function],
      default: null
    },
    resizableColumns: {
      type: Boolean,
      default: false
    },
    allRowsSelected: {
      type: Boolean,
      default: false
    },
    empty: {
      type: Boolean,
      default: false
    },
    sortMode: {
      type: String,
      default: "single"
    },
    groupRowSortField: {
      type: [String, Function],
      default: null
    },
    sortField: {
      type: [String, Function],
      default: null
    },
    sortOrder: {
      type: Number,
      default: null
    },
    multiSortMeta: {
      type: Array,
      default: null
    },
    filterDisplay: {
      type: String,
      default: null
    },
    filters: {
      type: Object,
      default: null
    },
    filtersStore: {
      type: Object,
      default: null
    },
    reorderableColumns: {
      type: Boolean,
      default: false
    },
    filterInputProps: {
      type: null,
      default: null
    },
    headerCheckboxIconTemplate: {
      type: Function,
      default: null
    }
  },
  methods: {
    columnProp(col, prop) {
      return ObjectUtils.getVNodeProp(col, prop);
    },
    getColumnGroupPTOptions(key) {
      return this.ptmo(this.getColumnGroupProps(), key, {
        props: this.getColumnGroupProps(),
        parent: {
          props: this.$props,
          state: this.$data
        }
      });
    },
    getColumnGroupProps() {
      return this.columnGroup && this.columnGroup.props && this.columnGroup.props.pt ? this.columnGroup.props.pt : void 0;
    },
    getRowPTOptions(row, key) {
      return this.ptmo(this.getRowProp(row), key, {
        props: row.props,
        parent: {
          props: this.$props,
          state: this.$data
        }
      });
    },
    getRowProp(row) {
      return row.props && row.props.pt ? row.props.pt : void 0;
    },
    getColumnPTOptions(column, key) {
      return this.ptmo(this.getColumnProp(column), key, {
        props: column.props,
        parent: {
          props: this.$props,
          state: this.$data
        }
      });
    },
    getColumnProp(column) {
      return column.props && column.props.pt ? column.props.pt : void 0;
    },
    getFilterColumnHeaderClass(column) {
      return [
        "p-filter-column",
        this.columnProp(column, "filterHeaderClass"),
        this.columnProp(column, "class"),
        {
          "p-frozen-column": this.columnProp(column, "frozen")
        }
      ];
    },
    getFilterColumnHeaderStyle(column) {
      return [this.columnProp(column, "filterHeaderStyle"), this.columnProp(column, "style")];
    },
    getHeaderRows() {
      let rows = [];
      let columnGroup = this.columnGroup;
      if (columnGroup.children && columnGroup.children.default) {
        for (let child of columnGroup.children.default()) {
          if (child.type.name === "Row") {
            rows.push(child);
          } else if (child.children && child.children instanceof Array) {
            rows = child.children;
          }
        }
        return rows;
      }
    },
    getHeaderColumns(row) {
      let cols = [];
      if (row.children && row.children.default) {
        row.children.default().forEach((child) => {
          if (child.children && child.children instanceof Array)
            cols = [...cols, ...child.children];
          else if (child.type.name === "Column")
            cols.push(child);
        });
        return cols;
      }
    }
  },
  components: {
    DTHeaderCell: script$2$1,
    DTHeaderCheckbox: script$3$1,
    DTColumnFilter: script$4$1
  }
};
function render$1$1(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_DTHeaderCell = resolveComponent("DTHeaderCell");
  const _component_DTHeaderCheckbox = resolveComponent("DTHeaderCheckbox");
  const _component_DTColumnFilter = resolveComponent("DTColumnFilter");
  return openBlock(), createElementBlock("thead", mergeProps({
    class: "p-datatable-thead",
    role: "rowgroup"
  }, { ..._ctx.ptm("thead"), ...$options.getColumnGroupPTOptions("root") }), [
    !$props.columnGroup ? (openBlock(), createElementBlock(Fragment, { key: 0 }, [
      createElementVNode("tr", mergeProps({ role: "row" }, _ctx.ptm("headerRow")), [
        (openBlock(true), createElementBlock(Fragment, null, renderList($props.columns, (col, i) => {
          return openBlock(), createElementBlock(Fragment, {
            key: $options.columnProp(col, "columnKey") || $options.columnProp(col, "field") || i
          }, [
            !$options.columnProp(col, "hidden") && ($props.rowGroupMode !== "subheader" || $props.groupRowsBy !== $options.columnProp(col, "field")) ? (openBlock(), createBlock(_component_DTHeaderCell, {
              key: 0,
              column: col,
              onColumnClick: _cache[0] || (_cache[0] = ($event) => _ctx.$emit("column-click", $event)),
              onColumnMousedown: _cache[1] || (_cache[1] = ($event) => _ctx.$emit("column-mousedown", $event)),
              onColumnDragstart: _cache[2] || (_cache[2] = ($event) => _ctx.$emit("column-dragstart", $event)),
              onColumnDragover: _cache[3] || (_cache[3] = ($event) => _ctx.$emit("column-dragover", $event)),
              onColumnDragleave: _cache[4] || (_cache[4] = ($event) => _ctx.$emit("column-dragleave", $event)),
              onColumnDrop: _cache[5] || (_cache[5] = ($event) => _ctx.$emit("column-drop", $event)),
              groupRowsBy: $props.groupRowsBy,
              groupRowSortField: $props.groupRowSortField,
              reorderableColumns: $props.reorderableColumns,
              resizableColumns: $props.resizableColumns,
              onColumnResizestart: _cache[6] || (_cache[6] = ($event) => _ctx.$emit("column-resizestart", $event)),
              sortMode: $props.sortMode,
              sortField: $props.sortField,
              sortOrder: $props.sortOrder,
              multiSortMeta: $props.multiSortMeta,
              allRowsSelected: $props.allRowsSelected,
              empty: $props.empty,
              onCheckboxChange: _cache[7] || (_cache[7] = ($event) => _ctx.$emit("checkbox-change", $event)),
              filters: $props.filters,
              filterDisplay: $props.filterDisplay,
              filtersStore: $props.filtersStore,
              filterInputProps: $props.filterInputProps,
              onFilterChange: _cache[8] || (_cache[8] = ($event) => _ctx.$emit("filter-change", $event)),
              onFilterApply: _cache[9] || (_cache[9] = ($event) => _ctx.$emit("filter-apply")),
              onOperatorChange: _cache[10] || (_cache[10] = ($event) => _ctx.$emit("operator-change", $event)),
              onMatchmodeChange: _cache[11] || (_cache[11] = ($event) => _ctx.$emit("matchmode-change", $event)),
              onConstraintAdd: _cache[12] || (_cache[12] = ($event) => _ctx.$emit("constraint-add", $event)),
              onConstraintRemove: _cache[13] || (_cache[13] = ($event) => _ctx.$emit("constraint-remove", $event)),
              onApplyClick: _cache[14] || (_cache[14] = ($event) => _ctx.$emit("apply-click", $event)),
              headerCheckboxIconTemplate: $props.headerCheckboxIconTemplate,
              pt: _ctx.pt
            }, null, 8, ["column", "groupRowsBy", "groupRowSortField", "reorderableColumns", "resizableColumns", "sortMode", "sortField", "sortOrder", "multiSortMeta", "allRowsSelected", "empty", "filters", "filterDisplay", "filtersStore", "filterInputProps", "headerCheckboxIconTemplate", "pt"])) : createCommentVNode("", true)
          ], 64);
        }), 128))
      ], 16),
      $props.filterDisplay === "row" ? (openBlock(), createElementBlock("tr", mergeProps({
        key: 0,
        role: "row"
      }, _ctx.ptm("headerRow")), [
        (openBlock(true), createElementBlock(Fragment, null, renderList($props.columns, (col, i) => {
          return openBlock(), createElementBlock(Fragment, {
            key: $options.columnProp(col, "columnKey") || $options.columnProp(col, "field") || i
          }, [
            !$options.columnProp(col, "hidden") && ($props.rowGroupMode !== "subheader" || $props.groupRowsBy !== $options.columnProp(col, "field")) ? (openBlock(), createElementBlock("th", mergeProps({
              key: 0,
              style: $options.getFilterColumnHeaderStyle(col),
              class: $options.getFilterColumnHeaderClass(col)
            }, { ...$options.getColumnPTOptions(col, "root"), ...$options.getColumnPTOptions(col, "headerCell") }), [
              $options.columnProp(col, "selectionMode") === "multiple" ? (openBlock(), createBlock(_component_DTHeaderCheckbox, {
                key: 0,
                checked: $props.allRowsSelected,
                disabled: $props.empty,
                onChange: _cache[15] || (_cache[15] = ($event) => _ctx.$emit("checkbox-change", $event)),
                column: col,
                pt: _ctx.pt
              }, null, 8, ["checked", "disabled", "column", "pt"])) : createCommentVNode("", true),
              col.children && col.children.filter ? (openBlock(), createBlock(_component_DTColumnFilter, {
                key: 1,
                field: $options.columnProp(col, "filterField") || $options.columnProp(col, "field"),
                type: $options.columnProp(col, "dataType"),
                display: "row",
                showMenu: $options.columnProp(col, "showFilterMenu"),
                filterElement: col.children && col.children.filter,
                filterHeaderTemplate: col.children && col.children.filterheader,
                filterFooterTemplate: col.children && col.children.filterfooter,
                filterClearTemplate: col.children && col.children.filterclear,
                filterApplyTemplate: col.children && col.children.filterapply,
                filterIconTemplate: col.children && col.children.filtericon,
                filterAddIconTemplate: col.children && col.children.filteraddicon,
                filterRemoveIconTemplate: col.children && col.children.filterremoveicon,
                filterClearIconTemplate: col.children && col.children.filterclearicon,
                filters: $props.filters,
                filtersStore: $props.filtersStore,
                filterInputProps: $props.filterInputProps,
                onFilterChange: _cache[16] || (_cache[16] = ($event) => _ctx.$emit("filter-change", $event)),
                onFilterApply: _cache[17] || (_cache[17] = ($event) => _ctx.$emit("filter-apply")),
                filterMenuStyle: $options.columnProp(col, "filterMenuStyle"),
                filterMenuClass: $options.columnProp(col, "filterMenuClass"),
                showOperator: $options.columnProp(col, "showFilterOperator"),
                showClearButton: $options.columnProp(col, "showClearButton"),
                showApplyButton: $options.columnProp(col, "showApplyButton"),
                showMatchModes: $options.columnProp(col, "showFilterMatchModes"),
                showAddButton: $options.columnProp(col, "showAddButton"),
                matchModeOptions: $options.columnProp(col, "filterMatchModeOptions"),
                maxConstraints: $options.columnProp(col, "maxConstraints"),
                onOperatorChange: _cache[18] || (_cache[18] = ($event) => _ctx.$emit("operator-change", $event)),
                onMatchmodeChange: _cache[19] || (_cache[19] = ($event) => _ctx.$emit("matchmode-change", $event)),
                onConstraintAdd: _cache[20] || (_cache[20] = ($event) => _ctx.$emit("constraint-add", $event)),
                onConstraintRemove: _cache[21] || (_cache[21] = ($event) => _ctx.$emit("constraint-remove", $event)),
                onApplyClick: _cache[22] || (_cache[22] = ($event) => _ctx.$emit("apply-click", $event)),
                pt: _ctx.pt,
                column: col
              }, null, 8, ["field", "type", "showMenu", "filterElement", "filterHeaderTemplate", "filterFooterTemplate", "filterClearTemplate", "filterApplyTemplate", "filterIconTemplate", "filterAddIconTemplate", "filterRemoveIconTemplate", "filterClearIconTemplate", "filters", "filtersStore", "filterInputProps", "filterMenuStyle", "filterMenuClass", "showOperator", "showClearButton", "showApplyButton", "showMatchModes", "showAddButton", "matchModeOptions", "maxConstraints", "pt", "column"])) : createCommentVNode("", true)
            ], 16)) : createCommentVNode("", true)
          ], 64);
        }), 128))
      ], 16)) : createCommentVNode("", true)
    ], 64)) : (openBlock(true), createElementBlock(Fragment, { key: 1 }, renderList($options.getHeaderRows(), (row, i) => {
      return openBlock(), createElementBlock("tr", mergeProps({
        key: i,
        role: "row"
      }, $options.getRowPTOptions(row, "root")), [
        (openBlock(true), createElementBlock(Fragment, null, renderList($options.getHeaderColumns(row), (col, j) => {
          return openBlock(), createElementBlock(Fragment, {
            key: $options.columnProp(col, "columnKey") || $options.columnProp(col, "field") || j
          }, [
            !$options.columnProp(col, "hidden") && ($props.rowGroupMode !== "subheader" || $props.groupRowsBy !== $options.columnProp(col, "field")) && typeof col.children !== "string" ? (openBlock(), createBlock(_component_DTHeaderCell, {
              key: 0,
              column: col,
              onColumnClick: _cache[23] || (_cache[23] = ($event) => _ctx.$emit("column-click", $event)),
              onColumnMousedown: _cache[24] || (_cache[24] = ($event) => _ctx.$emit("column-mousedown", $event)),
              groupRowsBy: $props.groupRowsBy,
              groupRowSortField: $props.groupRowSortField,
              sortMode: $props.sortMode,
              sortField: $props.sortField,
              sortOrder: $props.sortOrder,
              multiSortMeta: $props.multiSortMeta,
              allRowsSelected: $props.allRowsSelected,
              empty: $props.empty,
              onCheckboxChange: _cache[25] || (_cache[25] = ($event) => _ctx.$emit("checkbox-change", $event)),
              filters: $props.filters,
              filterDisplay: $props.filterDisplay,
              filtersStore: $props.filtersStore,
              onFilterChange: _cache[26] || (_cache[26] = ($event) => _ctx.$emit("filter-change", $event)),
              onFilterApply: _cache[27] || (_cache[27] = ($event) => _ctx.$emit("filter-apply")),
              onOperatorChange: _cache[28] || (_cache[28] = ($event) => _ctx.$emit("operator-change", $event)),
              onMatchmodeChange: _cache[29] || (_cache[29] = ($event) => _ctx.$emit("matchmode-change", $event)),
              onConstraintAdd: _cache[30] || (_cache[30] = ($event) => _ctx.$emit("constraint-add", $event)),
              onConstraintRemove: _cache[31] || (_cache[31] = ($event) => _ctx.$emit("constraint-remove", $event)),
              onApplyClick: _cache[32] || (_cache[32] = ($event) => _ctx.$emit("apply-click", $event)),
              headerCheckboxIconTemplate: $props.headerCheckboxIconTemplate,
              pt: _ctx.pt
            }, null, 8, ["column", "groupRowsBy", "groupRowSortField", "sortMode", "sortField", "sortOrder", "multiSortMeta", "allRowsSelected", "empty", "filters", "filterDisplay", "filtersStore", "headerCheckboxIconTemplate", "pt"])) : createCommentVNode("", true)
          ], 64);
        }), 128))
      ], 16);
    }), 128))
  ], 16);
}
script$1$1.render = render$1$1;
var script$b = {
  name: "DataTable",
  extends: script$W,
  emits: [
    "value-change",
    "update:first",
    "update:rows",
    "page",
    "update:sortField",
    "update:sortOrder",
    "update:multiSortMeta",
    "sort",
    "filter",
    "row-click",
    "row-dblclick",
    "update:selection",
    "row-select",
    "row-unselect",
    "update:contextMenuSelection",
    "row-contextmenu",
    "row-unselect-all",
    "row-select-all",
    "select-all-change",
    "column-resize-end",
    "column-reorder",
    "row-reorder",
    "update:expandedRows",
    "row-collapse",
    "row-expand",
    "update:expandedRowGroups",
    "rowgroup-collapse",
    "rowgroup-expand",
    "update:filters",
    "state-restore",
    "state-save",
    "cell-edit-init",
    "cell-edit-complete",
    "cell-edit-cancel",
    "update:editingRows",
    "row-edit-init",
    "row-edit-save",
    "row-edit-cancel"
  ],
  props: {
    value: {
      type: Array,
      default: null
    },
    dataKey: {
      type: [String, Function],
      default: null
    },
    rows: {
      type: Number,
      default: 0
    },
    first: {
      type: Number,
      default: 0
    },
    totalRecords: {
      type: Number,
      default: 0
    },
    paginator: {
      type: Boolean,
      default: false
    },
    paginatorPosition: {
      type: String,
      default: "bottom"
    },
    alwaysShowPaginator: {
      type: Boolean,
      default: true
    },
    paginatorTemplate: {
      type: [Object, String],
      default: "FirstPageLink PrevPageLink PageLinks NextPageLink LastPageLink RowsPerPageDropdown"
    },
    pageLinkSize: {
      type: Number,
      default: 5
    },
    rowsPerPageOptions: {
      type: Array,
      default: null
    },
    currentPageReportTemplate: {
      type: String,
      default: "({currentPage} of {totalPages})"
    },
    lazy: {
      type: Boolean,
      default: false
    },
    loading: {
      type: Boolean,
      default: false
    },
    loadingIcon: {
      type: String,
      default: void 0
    },
    sortField: {
      type: [String, Function],
      default: null
    },
    sortOrder: {
      type: Number,
      default: null
    },
    defaultSortOrder: {
      type: Number,
      default: 1
    },
    multiSortMeta: {
      type: Array,
      default: null
    },
    sortMode: {
      type: String,
      default: "single"
    },
    removableSort: {
      type: Boolean,
      default: false
    },
    filters: {
      type: Object,
      default: null
    },
    filterDisplay: {
      type: String,
      default: null
    },
    globalFilterFields: {
      type: Array,
      default: null
    },
    filterLocale: {
      type: String,
      default: void 0
    },
    selection: {
      type: [Array, Object],
      default: null
    },
    selectionMode: {
      type: String,
      default: null
    },
    compareSelectionBy: {
      type: String,
      default: "deepEquals"
    },
    metaKeySelection: {
      type: Boolean,
      default: true
    },
    contextMenu: {
      type: Boolean,
      default: false
    },
    contextMenuSelection: {
      type: Object,
      default: null
    },
    selectAll: {
      type: Boolean,
      default: null
    },
    rowHover: {
      type: Boolean,
      default: false
    },
    csvSeparator: {
      type: String,
      default: ","
    },
    exportFilename: {
      type: String,
      default: "download"
    },
    exportFunction: {
      type: Function,
      default: null
    },
    resizableColumns: {
      type: Boolean,
      default: false
    },
    columnResizeMode: {
      type: String,
      default: "fit"
    },
    reorderableColumns: {
      type: Boolean,
      default: false
    },
    expandedRows: {
      type: Array,
      default: null
    },
    expandedRowIcon: {
      type: String,
      default: void 0
    },
    collapsedRowIcon: {
      type: String,
      default: void 0
    },
    rowGroupMode: {
      type: String,
      default: null
    },
    groupRowsBy: {
      type: [Array, String, Function],
      default: null
    },
    expandableRowGroups: {
      type: Boolean,
      default: false
    },
    expandedRowGroups: {
      type: Array,
      default: null
    },
    stateStorage: {
      type: String,
      default: "session"
    },
    stateKey: {
      type: String,
      default: null
    },
    editMode: {
      type: String,
      default: null
    },
    editingRows: {
      type: Array,
      default: null
    },
    rowClass: {
      type: null,
      default: null
    },
    rowStyle: {
      type: null,
      default: null
    },
    scrollable: {
      type: Boolean,
      default: false
    },
    virtualScrollerOptions: {
      type: Object,
      default: null
    },
    scrollHeight: {
      type: String,
      default: null
    },
    frozenValue: {
      type: Array,
      default: null
    },
    responsiveLayout: {
      type: String,
      default: "scroll"
    },
    breakpoint: {
      type: String,
      default: "960px"
    },
    showGridlines: {
      type: Boolean,
      default: false
    },
    stripedRows: {
      type: Boolean,
      default: false
    },
    tableStyle: {
      type: null,
      default: null
    },
    tableClass: {
      type: String,
      default: null
    },
    tableProps: {
      type: null,
      default: null
    },
    filterInputProps: {
      type: null,
      default: null
    }
  },
  data() {
    return {
      d_first: this.first,
      d_rows: this.rows,
      d_sortField: this.sortField,
      d_sortOrder: this.sortOrder,
      d_multiSortMeta: this.multiSortMeta ? [...this.multiSortMeta] : [],
      d_groupRowsSortMeta: null,
      d_selectionKeys: null,
      d_expandedRowKeys: null,
      d_columnOrder: null,
      d_editingRowKeys: null,
      d_editingMeta: {},
      d_filters: this.cloneFilters(this.filters)
    };
  },
  rowTouched: false,
  anchorRowIndex: null,
  rangeRowIndex: null,
  documentColumnResizeListener: null,
  documentColumnResizeEndListener: null,
  lastResizeHelperX: null,
  resizeColumnElement: null,
  columnResizing: false,
  colReorderIconWidth: null,
  colReorderIconHeight: null,
  draggedColumn: null,
  draggedRowIndex: null,
  droppedRowIndex: null,
  rowDragging: null,
  columnWidthsState: null,
  tableWidthState: null,
  columnWidthsRestored: false,
  watch: {
    first(newValue) {
      this.d_first = newValue;
    },
    rows(newValue) {
      this.d_rows = newValue;
    },
    sortField(newValue) {
      this.d_sortField = newValue;
    },
    sortOrder(newValue) {
      this.d_sortOrder = newValue;
    },
    multiSortMeta(newValue) {
      this.d_multiSortMeta = newValue;
    },
    selection: {
      immediate: true,
      handler(newValue) {
        if (this.dataKey) {
          this.updateSelectionKeys(newValue);
        }
      }
    },
    expandedRows(newValue) {
      if (this.dataKey) {
        this.updateExpandedRowKeys(newValue);
      }
    },
    editingRows(newValue) {
      if (this.dataKey) {
        this.updateEditingRowKeys(newValue);
      }
    },
    filters: {
      deep: true,
      handler: function(newValue) {
        this.d_filters = this.cloneFilters(newValue);
      }
    }
  },
  beforeMount() {
    if (this.isStateful()) {
      this.restoreState();
    }
  },
  mounted() {
    this.$el.setAttribute(this.attributeSelector, "");
    if (this.responsiveLayout === "stack" && !this.scrollable) {
      this.createResponsiveStyle();
    }
    if (this.isStateful() && this.resizableColumns) {
      this.restoreColumnWidths();
    }
    if (this.editMode === "row" && this.dataKey && !this.d_editingRowKeys) {
      this.updateEditingRowKeys(this.editingRows);
    }
  },
  beforeUnmount() {
    this.unbindColumnResizeEvents();
    this.destroyStyleElement();
    this.destroyResponsiveStyle();
  },
  updated() {
    if (this.isStateful()) {
      this.saveState();
    }
    if (this.editMode === "row" && this.dataKey && !this.d_editingRowKeys) {
      this.updateEditingRowKeys(this.editingRows);
    }
  },
  methods: {
    columnProp(col, prop) {
      return ObjectUtils.getVNodeProp(col, prop);
    },
    onPage(event2) {
      this.clearEditingMetaData();
      this.d_first = event2.first;
      this.d_rows = event2.rows;
      let pageEvent = this.createLazyLoadEvent(event2);
      pageEvent.pageCount = event2.pageCount;
      pageEvent.page = event2.page;
      this.$emit("update:first", this.d_first);
      this.$emit("update:rows", this.d_rows);
      this.$emit("page", pageEvent);
      this.$emit("value-change", this.processedData);
    },
    onColumnHeaderClick(e) {
      const event2 = e.originalEvent;
      const column = e.column;
      if (this.columnProp(column, "sortable")) {
        const targetNode = event2.target;
        const columnField = this.columnProp(column, "sortField") || this.columnProp(column, "field");
        if (DomHandler.hasClass(targetNode, "p-sortable-column") || DomHandler.hasClass(targetNode, "p-column-title") || DomHandler.hasClass(targetNode, "p-column-header-content") || DomHandler.hasClass(targetNode, "p-sortable-column-icon") || DomHandler.hasClass(targetNode.parentElement, "p-sortable-column-icon")) {
          DomHandler.clearSelection();
          if (this.sortMode === "single") {
            if (this.d_sortField === columnField) {
              if (this.removableSort && this.d_sortOrder * -1 === this.defaultSortOrder) {
                this.d_sortOrder = null;
                this.d_sortField = null;
              } else {
                this.d_sortOrder = this.d_sortOrder * -1;
              }
            } else {
              this.d_sortOrder = this.defaultSortOrder;
              this.d_sortField = columnField;
            }
            this.$emit("update:sortField", this.d_sortField);
            this.$emit("update:sortOrder", this.d_sortOrder);
            this.resetPage();
          } else if (this.sortMode === "multiple") {
            let metaKey = event2.metaKey || event2.ctrlKey;
            if (!metaKey) {
              this.d_multiSortMeta = this.d_multiSortMeta.filter((meta) => meta.field === columnField);
            }
            this.addMultiSortField(columnField);
            this.$emit("update:multiSortMeta", this.d_multiSortMeta);
          }
          this.$emit("sort", this.createLazyLoadEvent(event2));
          this.$emit("value-change", this.processedData);
        }
      }
    },
    sortSingle(value) {
      this.clearEditingMetaData();
      if (this.groupRowsBy && this.groupRowsBy === this.sortField) {
        this.d_multiSortMeta = [
          { field: this.sortField, order: this.sortOrder || this.defaultSortOrder },
          { field: this.d_sortField, order: this.d_sortOrder }
        ];
        return this.sortMultiple(value);
      }
      let data = [...value];
      data.sort((data1, data2) => {
        let value1 = ObjectUtils.resolveFieldData(data1, this.d_sortField);
        let value2 = ObjectUtils.resolveFieldData(data2, this.d_sortField);
        let result = null;
        if (value1 == null && value2 != null)
          result = -1;
        else if (value1 != null && value2 == null)
          result = 1;
        else if (value1 == null && value2 == null)
          result = 0;
        else if (typeof value1 === "string" && typeof value2 === "string")
          result = value1.localeCompare(value2, void 0, { numeric: true });
        else
          result = value1 < value2 ? -1 : value1 > value2 ? 1 : 0;
        return this.d_sortOrder * result;
      });
      return data;
    },
    sortMultiple(value) {
      this.clearEditingMetaData();
      if (this.groupRowsBy && (this.d_groupRowsSortMeta || this.d_multiSortMeta.length && this.groupRowsBy === this.d_multiSortMeta[0].field)) {
        const firstSortMeta = this.d_multiSortMeta[0];
        !this.d_groupRowsSortMeta && (this.d_groupRowsSortMeta = firstSortMeta);
        if (firstSortMeta.field !== this.d_groupRowsSortMeta.field) {
          this.d_multiSortMeta = [this.d_groupRowsSortMeta, ...this.d_multiSortMeta];
        }
      }
      let data = [...value];
      data.sort((data1, data2) => {
        return this.multisortField(data1, data2, 0);
      });
      return data;
    },
    multisortField(data1, data2, index) {
      const value1 = ObjectUtils.resolveFieldData(data1, this.d_multiSortMeta[index].field);
      const value2 = ObjectUtils.resolveFieldData(data2, this.d_multiSortMeta[index].field);
      let result = null;
      if (typeof value1 === "string" || value1 instanceof String) {
        if (value1.localeCompare && value1 !== value2) {
          return this.d_multiSortMeta[index].order * value1.localeCompare(value2, void 0, { numeric: true });
        }
      } else {
        result = value1 < value2 ? -1 : 1;
      }
      if (value1 === value2) {
        return this.d_multiSortMeta.length - 1 > index ? this.multisortField(data1, data2, index + 1) : 0;
      }
      return this.d_multiSortMeta[index].order * result;
    },
    addMultiSortField(field) {
      let index = this.d_multiSortMeta.findIndex((meta) => meta.field === field);
      if (index >= 0) {
        if (this.removableSort && this.d_multiSortMeta[index].order * -1 === this.defaultSortOrder)
          this.d_multiSortMeta.splice(index, 1);
        else
          this.d_multiSortMeta[index] = { field, order: this.d_multiSortMeta[index].order * -1 };
      } else {
        this.d_multiSortMeta.push({ field, order: this.defaultSortOrder });
      }
      this.d_multiSortMeta = [...this.d_multiSortMeta];
    },
    filter(data) {
      if (!data) {
        return;
      }
      this.clearEditingMetaData();
      let globalFilterFieldsArray;
      if (this.filters["global"]) {
        globalFilterFieldsArray = this.globalFilterFields || this.columns.map((col) => this.columnProp(col, "filterField") || this.columnProp(col, "field"));
      }
      let filteredValue = [];
      for (let i = 0; i < data.length; i++) {
        let localMatch = true;
        let globalMatch = false;
        let localFiltered = false;
        for (let prop in this.filters) {
          if (Object.prototype.hasOwnProperty.call(this.filters, prop) && prop !== "global") {
            localFiltered = true;
            let filterField = prop;
            let filterMeta = this.filters[filterField];
            if (filterMeta.operator) {
              for (let filterConstraint of filterMeta.constraints) {
                localMatch = this.executeLocalFilter(filterField, data[i], filterConstraint);
                if (filterMeta.operator === FilterOperator.OR && localMatch || filterMeta.operator === FilterOperator.AND && !localMatch) {
                  break;
                }
              }
            } else {
              localMatch = this.executeLocalFilter(filterField, data[i], filterMeta);
            }
            if (!localMatch) {
              break;
            }
          }
        }
        if (this.filters["global"] && !globalMatch && globalFilterFieldsArray) {
          for (let j = 0; j < globalFilterFieldsArray.length; j++) {
            let globalFilterField = globalFilterFieldsArray[j];
            globalMatch = FilterService.filters[this.filters["global"].matchMode || FilterMatchMode.CONTAINS](ObjectUtils.resolveFieldData(data[i], globalFilterField), this.filters["global"].value, this.filterLocale);
            if (globalMatch) {
              break;
            }
          }
        }
        let matches;
        if (this.filters["global"]) {
          matches = localFiltered ? localFiltered && localMatch && globalMatch : globalMatch;
        } else {
          matches = localFiltered && localMatch;
        }
        if (matches) {
          filteredValue.push(data[i]);
        }
      }
      if (filteredValue.length === this.value.length) {
        filteredValue = data;
      }
      let filterEvent = this.createLazyLoadEvent();
      filterEvent.filteredValue = filteredValue;
      this.$emit("filter", filterEvent);
      this.$emit("value-change", filteredValue);
      return filteredValue;
    },
    executeLocalFilter(field, rowData, filterMeta) {
      let filterValue = filterMeta.value;
      let filterMatchMode = filterMeta.matchMode || FilterMatchMode.STARTS_WITH;
      let dataFieldValue = ObjectUtils.resolveFieldData(rowData, field);
      let filterConstraint = FilterService.filters[filterMatchMode];
      return filterConstraint(dataFieldValue, filterValue, this.filterLocale);
    },
    onRowClick(e) {
      const event2 = e.originalEvent;
      const index = e.index;
      const body = this.$refs.bodyRef && this.$refs.bodyRef.$el;
      const focusedItem = DomHandler.findSingle(body, 'tr.p-selectable-row[tabindex="0"]');
      if (DomHandler.isClickable(event2.target)) {
        return;
      }
      this.$emit("row-click", e);
      if (this.selectionMode) {
        const rowData = e.data;
        const rowIndex = this.d_first + e.index;
        if (this.isMultipleSelectionMode() && event2.shiftKey && this.anchorRowIndex != null) {
          DomHandler.clearSelection();
          this.rangeRowIndex = rowIndex;
          this.selectRange(event2);
        } else {
          const selected = this.isSelected(rowData);
          const metaSelection = this.rowTouched ? false : this.metaKeySelection;
          this.anchorRowIndex = rowIndex;
          this.rangeRowIndex = rowIndex;
          if (metaSelection) {
            let metaKey = event2.metaKey || event2.ctrlKey;
            if (selected && metaKey) {
              if (this.isSingleSelectionMode()) {
                this.$emit("update:selection", null);
              } else {
                const selectionIndex = this.findIndexInSelection(rowData);
                const _selection = this.selection.filter((val, i) => i != selectionIndex);
                this.$emit("update:selection", _selection);
              }
              this.$emit("row-unselect", { originalEvent: event2, data: rowData, index: rowIndex, type: "row" });
            } else {
              if (this.isSingleSelectionMode()) {
                this.$emit("update:selection", rowData);
              } else if (this.isMultipleSelectionMode()) {
                let _selection = metaKey ? this.selection || [] : [];
                _selection = [..._selection, rowData];
                this.$emit("update:selection", _selection);
              }
              this.$emit("row-select", { originalEvent: event2, data: rowData, index: rowIndex, type: "row" });
            }
          } else {
            if (this.selectionMode === "single") {
              if (selected) {
                this.$emit("update:selection", null);
                this.$emit("row-unselect", { originalEvent: event2, data: rowData, index: rowIndex, type: "row" });
              } else {
                this.$emit("update:selection", rowData);
                this.$emit("row-select", { originalEvent: event2, data: rowData, index: rowIndex, type: "row" });
              }
            } else if (this.selectionMode === "multiple") {
              if (selected) {
                const selectionIndex = this.findIndexInSelection(rowData);
                const _selection = this.selection.filter((val, i) => i != selectionIndex);
                this.$emit("update:selection", _selection);
                this.$emit("row-unselect", { originalEvent: event2, data: rowData, index: rowIndex, type: "row" });
              } else {
                const _selection = this.selection ? [...this.selection, rowData] : [rowData];
                this.$emit("update:selection", _selection);
                this.$emit("row-select", { originalEvent: event2, data: rowData, index: rowIndex, type: "row" });
              }
            }
          }
        }
      }
      this.rowTouched = false;
      if (focusedItem) {
        focusedItem.tabIndex = "-1";
        DomHandler.find(body, "tr.p-selectable-row")[index].tabIndex = "0";
      }
    },
    onRowDblClick(e) {
      const event2 = e.originalEvent;
      if (DomHandler.isClickable(event2.target)) {
        return;
      }
      this.$emit("row-dblclick", e);
    },
    onRowRightClick(event2) {
      if (this.contextMenu) {
        DomHandler.clearSelection();
        event2.originalEvent.target.focus();
      }
      this.$emit("update:contextMenuSelection", event2.data);
      this.$emit("row-contextmenu", event2);
    },
    onRowTouchEnd() {
      this.rowTouched = true;
    },
    onRowKeyDown(e, slotProps) {
      const event2 = e.originalEvent;
      const rowData = e.data;
      const rowIndex = e.index;
      const metaKey = event2.metaKey || event2.ctrlKey;
      if (this.selectionMode) {
        const row = event2.target;
        switch (event2.code) {
          case "ArrowDown":
            this.onArrowDownKey(event2, row, rowIndex, slotProps);
            break;
          case "ArrowUp":
            this.onArrowUpKey(event2, row, rowIndex, slotProps);
            break;
          case "Home":
            this.onHomeKey(event2, row, rowIndex, slotProps);
            break;
          case "End":
            this.onEndKey(event2, row, rowIndex, slotProps);
            break;
          case "Enter":
            this.onEnterKey(event2, rowData, rowIndex);
            break;
          case "Space":
            this.onSpaceKey(event2, rowData, rowIndex, slotProps);
            break;
          case "Tab":
            this.onTabKey(event2, rowIndex);
            break;
          default:
            if (event2.code === "KeyA" && metaKey) {
              const data = this.dataToRender(slotProps.rows);
              this.$emit("update:selection", data);
            }
            break;
        }
      }
    },
    onArrowDownKey(event2, row, rowIndex, slotProps) {
      const nextRow = this.findNextSelectableRow(row);
      nextRow && this.focusRowChange(row, nextRow);
      if (event2.shiftKey) {
        const data = this.dataToRender(slotProps.rows);
        const nextRowIndex = rowIndex + 1 >= data.length ? data.length - 1 : rowIndex + 1;
        this.onRowClick({ originalEvent: event2, data: data[nextRowIndex], index: nextRowIndex });
      }
      event2.preventDefault();
    },
    onArrowUpKey(event2, row, rowIndex, slotProps) {
      const prevRow = this.findPrevSelectableRow(row);
      prevRow && this.focusRowChange(row, prevRow);
      if (event2.shiftKey) {
        const data = this.dataToRender(slotProps.rows);
        const prevRowIndex = rowIndex - 1 <= 0 ? 0 : rowIndex - 1;
        this.onRowClick({ originalEvent: event2, data: data[prevRowIndex], index: prevRowIndex });
      }
      event2.preventDefault();
    },
    onHomeKey(event2, row, rowIndex, slotProps) {
      const firstRow = this.findFirstSelectableRow();
      firstRow && this.focusRowChange(row, firstRow);
      if (event2.ctrlKey && event2.shiftKey) {
        const data = this.dataToRender(slotProps.rows);
        this.$emit("update:selection", data.slice(0, rowIndex + 1));
      }
      event2.preventDefault();
    },
    onEndKey(event2, row, rowIndex, slotProps) {
      const lastRow = this.findLastSelectableRow();
      lastRow && this.focusRowChange(row, lastRow);
      if (event2.ctrlKey && event2.shiftKey) {
        const data = this.dataToRender(slotProps.rows);
        this.$emit("update:selection", data.slice(rowIndex, data.length));
      }
      event2.preventDefault();
    },
    onEnterKey(event2, rowData, rowIndex) {
      this.onRowClick({ originalEvent: event2, data: rowData, index: rowIndex });
      event2.preventDefault();
    },
    onSpaceKey(event2, rowData, rowIndex, slotProps) {
      this.onEnterKey(event2, rowData, rowIndex);
      if (event2.shiftKey && this.selection !== null) {
        const data = this.dataToRender(slotProps.rows);
        let index;
        if (this.selection.length > 0) {
          let firstSelectedRowIndex, lastSelectedRowIndex;
          firstSelectedRowIndex = ObjectUtils.findIndexInList(this.selection[0], data);
          lastSelectedRowIndex = ObjectUtils.findIndexInList(this.selection[this.selection.length - 1], data);
          index = rowIndex <= firstSelectedRowIndex ? lastSelectedRowIndex : firstSelectedRowIndex;
        } else {
          index = ObjectUtils.findIndexInList(this.selection, data);
        }
        const _selection = index !== rowIndex ? data.slice(Math.min(index, rowIndex), Math.max(index, rowIndex) + 1) : rowData;
        this.$emit("update:selection", _selection);
      }
    },
    onTabKey(event2, rowIndex) {
      const body = this.$refs.bodyRef && this.$refs.bodyRef.$el;
      const rows = DomHandler.find(body, "tr.p-selectable-row");
      if (event2.code === "Tab" && rows && rows.length > 0) {
        const firstSelectedRow = DomHandler.findSingle(body, "tr.p-highlight");
        const focusedItem = DomHandler.findSingle(body, 'tr.p-selectable-row[tabindex="0"]');
        if (firstSelectedRow) {
          firstSelectedRow.tabIndex = "0";
          focusedItem && focusedItem !== firstSelectedRow && (focusedItem.tabIndex = "-1");
        } else {
          rows[0].tabIndex = "0";
          focusedItem !== rows[0] && (rows[rowIndex].tabIndex = "-1");
        }
      }
    },
    findNextSelectableRow(row) {
      let nextRow = row.nextElementSibling;
      if (nextRow) {
        if (DomHandler.hasClass(nextRow, "p-selectable-row"))
          return nextRow;
        else
          return this.findNextSelectableRow(nextRow);
      } else {
        return null;
      }
    },
    findPrevSelectableRow(row) {
      let prevRow = row.previousElementSibling;
      if (prevRow) {
        if (DomHandler.hasClass(prevRow, "p-selectable-row"))
          return prevRow;
        else
          return this.findPrevSelectableRow(prevRow);
      } else {
        return null;
      }
    },
    findFirstSelectableRow() {
      const firstRow = DomHandler.findSingle(this.$refs.table, ".p-selectable-row");
      return firstRow;
    },
    findLastSelectableRow() {
      const rows = DomHandler.find(this.$refs.table, ".p-selectable-row");
      return rows ? rows[rows.length - 1] : null;
    },
    focusRowChange(firstFocusableRow, currentFocusedRow) {
      firstFocusableRow.tabIndex = "-1";
      currentFocusedRow.tabIndex = "0";
      DomHandler.focus(currentFocusedRow);
    },
    toggleRowWithRadio(event2) {
      const rowData = event2.data;
      if (this.isSelected(rowData)) {
        this.$emit("update:selection", null);
        this.$emit("row-unselect", { originalEvent: event2.originalEvent, data: rowData, index: event2.index, type: "radiobutton" });
      } else {
        this.$emit("update:selection", rowData);
        this.$emit("row-select", { originalEvent: event2.originalEvent, data: rowData, index: event2.index, type: "radiobutton" });
      }
    },
    toggleRowWithCheckbox(event2) {
      const rowData = event2.data;
      if (this.isSelected(rowData)) {
        const selectionIndex = this.findIndexInSelection(rowData);
        const _selection = this.selection.filter((val, i) => i != selectionIndex);
        this.$emit("update:selection", _selection);
        this.$emit("row-unselect", { originalEvent: event2.originalEvent, data: rowData, index: event2.index, type: "checkbox" });
      } else {
        let _selection = this.selection ? [...this.selection] : [];
        _selection = [..._selection, rowData];
        this.$emit("update:selection", _selection);
        this.$emit("row-select", { originalEvent: event2.originalEvent, data: rowData, index: event2.index, type: "checkbox" });
      }
    },
    toggleRowsWithCheckbox(event2) {
      if (this.selectAll !== null) {
        this.$emit("select-all-change", event2);
      } else {
        const { originalEvent, checked } = event2;
        let _selection = [];
        if (checked) {
          _selection = this.frozenValue ? [...this.frozenValue, ...this.processedData] : this.processedData;
          this.$emit("row-select-all", { originalEvent, data: _selection });
        } else {
          this.$emit("row-unselect-all", { originalEvent });
        }
        this.$emit("update:selection", _selection);
      }
    },
    isSingleSelectionMode() {
      return this.selectionMode === "single";
    },
    isMultipleSelectionMode() {
      return this.selectionMode === "multiple";
    },
    isSelected(rowData) {
      if (rowData && this.selection) {
        if (this.dataKey) {
          return this.d_selectionKeys ? this.d_selectionKeys[ObjectUtils.resolveFieldData(rowData, this.dataKey)] !== void 0 : false;
        } else {
          if (this.selection instanceof Array)
            return this.findIndexInSelection(rowData) > -1;
          else
            return this.equals(rowData, this.selection);
        }
      }
      return false;
    },
    findIndexInSelection(rowData) {
      return this.findIndex(rowData, this.selection);
    },
    findIndex(rowData, collection) {
      let index = -1;
      if (collection && collection.length) {
        for (let i = 0; i < collection.length; i++) {
          if (this.equals(rowData, collection[i])) {
            index = i;
            break;
          }
        }
      }
      return index;
    },
    updateSelectionKeys(selection) {
      this.d_selectionKeys = {};
      if (Array.isArray(selection)) {
        for (let data of selection) {
          this.d_selectionKeys[String(ObjectUtils.resolveFieldData(data, this.dataKey))] = 1;
        }
      } else {
        this.d_selectionKeys[String(ObjectUtils.resolveFieldData(selection, this.dataKey))] = 1;
      }
    },
    updateExpandedRowKeys(expandedRows) {
      if (expandedRows && expandedRows.length) {
        this.d_expandedRowKeys = {};
        for (let data of expandedRows) {
          this.d_expandedRowKeys[String(ObjectUtils.resolveFieldData(data, this.dataKey))] = 1;
        }
      } else {
        this.d_expandedRowKeys = null;
      }
    },
    updateEditingRowKeys(editingRows) {
      if (editingRows && editingRows.length) {
        this.d_editingRowKeys = {};
        for (let data of editingRows) {
          this.d_editingRowKeys[String(ObjectUtils.resolveFieldData(data, this.dataKey))] = 1;
        }
      } else {
        this.d_editingRowKeys = null;
      }
    },
    equals(data1, data2) {
      return this.compareSelectionBy === "equals" ? data1 === data2 : ObjectUtils.equals(data1, data2, this.dataKey);
    },
    selectRange(event2) {
      let rangeStart, rangeEnd;
      if (this.rangeRowIndex > this.anchorRowIndex) {
        rangeStart = this.anchorRowIndex;
        rangeEnd = this.rangeRowIndex;
      } else if (this.rangeRowIndex < this.anchorRowIndex) {
        rangeStart = this.rangeRowIndex;
        rangeEnd = this.anchorRowIndex;
      } else {
        rangeStart = this.rangeRowIndex;
        rangeEnd = this.rangeRowIndex;
      }
      if (this.lazy && this.paginator) {
        rangeStart -= this.first;
        rangeEnd -= this.first;
      }
      const value = this.processedData;
      let _selection = [];
      for (let i = rangeStart; i <= rangeEnd; i++) {
        let rangeRowData = value[i];
        _selection.push(rangeRowData);
        this.$emit("row-select", { originalEvent: event2, data: rangeRowData, type: "row" });
      }
      this.$emit("update:selection", _selection);
    },
    exportCSV(options, data) {
      let csv = "\uFEFF";
      if (!data) {
        data = this.processedData;
        if (options && options.selectionOnly)
          data = this.selection || [];
        else if (this.frozenValue)
          data = data ? [...this.frozenValue, ...data] : this.frozenValue;
      }
      let headerInitiated = false;
      for (let i = 0; i < this.columns.length; i++) {
        let column = this.columns[i];
        if (this.columnProp(column, "exportable") !== false && this.columnProp(column, "field")) {
          if (headerInitiated)
            csv += this.csvSeparator;
          else
            headerInitiated = true;
          csv += '"' + (this.columnProp(column, "exportHeader") || this.columnProp(column, "header") || this.columnProp(column, "field")) + '"';
        }
      }
      if (data) {
        data.forEach((record) => {
          csv += "\n";
          let rowInitiated = false;
          for (let i = 0; i < this.columns.length; i++) {
            let column = this.columns[i];
            if (this.columnProp(column, "exportable") !== false && this.columnProp(column, "field")) {
              if (rowInitiated)
                csv += this.csvSeparator;
              else
                rowInitiated = true;
              let cellData = ObjectUtils.resolveFieldData(record, this.columnProp(column, "field"));
              if (cellData != null) {
                if (this.exportFunction) {
                  cellData = this.exportFunction({
                    data: cellData,
                    field: this.columnProp(column, "field")
                  });
                } else
                  cellData = String(cellData).replace(/"/g, '""');
              } else
                cellData = "";
              csv += '"' + cellData + '"';
            }
          }
        });
      }
      let footerInitiated = false;
      for (let i = 0; i < this.columns.length; i++) {
        let column = this.columns[i];
        if (i === 0)
          csv += "\n";
        if (this.columnProp(column, "exportable") !== false && this.columnProp(column, "exportFooter")) {
          if (footerInitiated)
            csv += this.csvSeparator;
          else
            footerInitiated = true;
          csv += '"' + (this.columnProp(column, "exportFooter") || this.columnProp(column, "footer") || this.columnProp(column, "field")) + '"';
        }
      }
      DomHandler.exportCSV(csv, this.exportFilename);
    },
    resetPage() {
      this.d_first = 0;
      this.$emit("update:first", this.d_first);
    },
    onColumnResizeStart(event2) {
      let containerLeft = DomHandler.getOffset(this.$el).left;
      this.resizeColumnElement = event2.target.parentElement;
      this.columnResizing = true;
      this.lastResizeHelperX = event2.pageX - containerLeft + this.$el.scrollLeft;
      this.bindColumnResizeEvents();
    },
    onColumnResize(event2) {
      let containerLeft = DomHandler.getOffset(this.$el).left;
      DomHandler.addClass(this.$el, "p-unselectable-text");
      this.$refs.resizeHelper.style.height = this.$el.offsetHeight + "px";
      this.$refs.resizeHelper.style.top = "0px";
      this.$refs.resizeHelper.style.left = event2.pageX - containerLeft + this.$el.scrollLeft + "px";
      this.$refs.resizeHelper.style.display = "block";
    },
    onColumnResizeEnd() {
      let delta = this.$refs.resizeHelper.offsetLeft - this.lastResizeHelperX;
      let columnWidth = this.resizeColumnElement.offsetWidth;
      let newColumnWidth = columnWidth + delta;
      let minWidth = this.resizeColumnElement.style.minWidth || 15;
      if (columnWidth + delta > parseInt(minWidth, 10)) {
        if (this.columnResizeMode === "fit") {
          let nextColumn = this.resizeColumnElement.nextElementSibling;
          let nextColumnWidth = nextColumn.offsetWidth - delta;
          if (newColumnWidth > 15 && nextColumnWidth > 15) {
            this.resizeTableCells(newColumnWidth, nextColumnWidth);
          }
        } else if (this.columnResizeMode === "expand") {
          const tableWidth = this.$refs.table.offsetWidth + delta + "px";
          const updateTableWidth = (el) => {
            !!el && (el.style.width = el.style.minWidth = tableWidth);
          };
          updateTableWidth(this.$refs.table);
          if (!this.virtualScrollerDisabled) {
            const body = this.$refs.bodyRef && this.$refs.bodyRef.$el;
            const frozenBody = this.$refs.frozenBodyRef && this.$refs.frozenBodyRef.$el;
            updateTableWidth(body);
            updateTableWidth(frozenBody);
          }
          this.resizeTableCells(newColumnWidth);
        }
        this.$emit("column-resize-end", {
          element: this.resizeColumnElement,
          delta
        });
      }
      this.$refs.resizeHelper.style.display = "none";
      this.resizeColumn = null;
      DomHandler.removeClass(this.$el, "p-unselectable-text");
      this.unbindColumnResizeEvents();
      if (this.isStateful()) {
        this.saveState();
      }
    },
    resizeTableCells(newColumnWidth, nextColumnWidth) {
      let colIndex = DomHandler.index(this.resizeColumnElement);
      let widths = [];
      let headers = DomHandler.find(this.$refs.table, ".p-datatable-thead > tr > th");
      headers.forEach((header) => widths.push(DomHandler.getOuterWidth(header)));
      this.destroyStyleElement();
      this.createStyleElement();
      let innerHTML = "";
      let selector = `.p-datatable[${this.attributeSelector}] > .p-datatable-wrapper ${this.virtualScrollerDisabled ? "" : "> .p-virtualscroller"} > .p-datatable-table`;
      widths.forEach((width, index) => {
        let colWidth = index === colIndex ? newColumnWidth : nextColumnWidth && index === colIndex + 1 ? nextColumnWidth : width;
        let style = `width: ${colWidth}px !important; max-width: ${colWidth}px !important`;
        innerHTML += `
                    ${selector} > .p-datatable-thead > tr > th:nth-child(${index + 1}),
                    ${selector} > .p-datatable-tbody > tr > td:nth-child(${index + 1}),
                    ${selector} > .p-datatable-tfoot > tr > td:nth-child(${index + 1}) {
                        ${style}
                    }
                `;
      });
      this.styleElement.innerHTML = innerHTML;
    },
    bindColumnResizeEvents() {
      if (!this.documentColumnResizeListener) {
        this.documentColumnResizeListener = document.addEventListener("mousemove", () => {
          if (this.columnResizing) {
            this.onColumnResize(event);
          }
        });
      }
      if (!this.documentColumnResizeEndListener) {
        this.documentColumnResizeEndListener = document.addEventListener("mouseup", () => {
          if (this.columnResizing) {
            this.columnResizing = false;
            this.onColumnResizeEnd();
          }
        });
      }
    },
    unbindColumnResizeEvents() {
      if (this.documentColumnResizeListener) {
        document.removeEventListener("document", this.documentColumnResizeListener);
        this.documentColumnResizeListener = null;
      }
      if (this.documentColumnResizeEndListener) {
        document.removeEventListener("document", this.documentColumnResizeEndListener);
        this.documentColumnResizeEndListener = null;
      }
    },
    onColumnHeaderMouseDown(e) {
      const event2 = e.originalEvent;
      const column = e.column;
      if (this.reorderableColumns && this.columnProp(column, "reorderableColumn") !== false) {
        if (event2.target.nodeName === "INPUT" || event2.target.nodeName === "TEXTAREA" || DomHandler.hasClass(event2.target, "p-column-resizer"))
          event2.currentTarget.draggable = false;
        else
          event2.currentTarget.draggable = true;
      }
    },
    onColumnHeaderDragStart(event2) {
      if (this.columnResizing) {
        event2.preventDefault();
        return;
      }
      this.colReorderIconWidth = DomHandler.getHiddenElementOuterWidth(this.$refs.reorderIndicatorUp);
      this.colReorderIconHeight = DomHandler.getHiddenElementOuterHeight(this.$refs.reorderIndicatorUp);
      this.draggedColumn = this.findParentHeader(event2.target);
      event2.dataTransfer.setData("text", "b");
    },
    onColumnHeaderDragOver(event2) {
      let dropHeader = this.findParentHeader(event2.target);
      if (this.reorderableColumns && this.draggedColumn && dropHeader) {
        event2.preventDefault();
        let containerOffset = DomHandler.getOffset(this.$el);
        let dropHeaderOffset = DomHandler.getOffset(dropHeader);
        if (this.draggedColumn !== dropHeader) {
          let targetLeft = dropHeaderOffset.left - containerOffset.left;
          let columnCenter = dropHeaderOffset.left + dropHeader.offsetWidth / 2;
          this.$refs.reorderIndicatorUp.style.top = dropHeaderOffset.top - containerOffset.top - (this.colReorderIconHeight - 1) + "px";
          this.$refs.reorderIndicatorDown.style.top = dropHeaderOffset.top - containerOffset.top + dropHeader.offsetHeight + "px";
          if (event2.pageX > columnCenter) {
            this.$refs.reorderIndicatorUp.style.left = targetLeft + dropHeader.offsetWidth - Math.ceil(this.colReorderIconWidth / 2) + "px";
            this.$refs.reorderIndicatorDown.style.left = targetLeft + dropHeader.offsetWidth - Math.ceil(this.colReorderIconWidth / 2) + "px";
            this.dropPosition = 1;
          } else {
            this.$refs.reorderIndicatorUp.style.left = targetLeft - Math.ceil(this.colReorderIconWidth / 2) + "px";
            this.$refs.reorderIndicatorDown.style.left = targetLeft - Math.ceil(this.colReorderIconWidth / 2) + "px";
            this.dropPosition = -1;
          }
          this.$refs.reorderIndicatorUp.style.display = "block";
          this.$refs.reorderIndicatorDown.style.display = "block";
        }
      }
    },
    onColumnHeaderDragLeave(event2) {
      if (this.reorderableColumns && this.draggedColumn) {
        event2.preventDefault();
        this.$refs.reorderIndicatorUp.style.display = "none";
        this.$refs.reorderIndicatorDown.style.display = "none";
      }
    },
    onColumnHeaderDrop(event2) {
      event2.preventDefault();
      if (this.draggedColumn) {
        let dragIndex = DomHandler.index(this.draggedColumn);
        let dropIndex = DomHandler.index(this.findParentHeader(event2.target));
        let allowDrop = dragIndex !== dropIndex;
        if (allowDrop && (dropIndex - dragIndex === 1 && this.dropPosition === -1 || dropIndex - dragIndex === -1 && this.dropPosition === 1)) {
          allowDrop = false;
        }
        if (allowDrop) {
          ObjectUtils.reorderArray(this.columns, dragIndex, dropIndex);
          this.updateReorderableColumns();
          this.$emit("column-reorder", {
            originalEvent: event2,
            dragIndex,
            dropIndex
          });
        }
        this.$refs.reorderIndicatorUp.style.display = "none";
        this.$refs.reorderIndicatorDown.style.display = "none";
        this.draggedColumn.draggable = false;
        this.draggedColumn = null;
        this.dropPosition = null;
      }
    },
    findParentHeader(element) {
      if (element.nodeName === "TH") {
        return element;
      } else {
        let parent = element.parentElement;
        while (parent.nodeName !== "TH") {
          parent = parent.parentElement;
          if (!parent)
            break;
        }
        return parent;
      }
    },
    findColumnByKey(columns, key) {
      if (columns && columns.length) {
        for (let i = 0; i < columns.length; i++) {
          let column = columns[i];
          if (this.columnProp(column, "columnKey") === key || this.columnProp(column, "field") === key) {
            return column;
          }
        }
      }
      return null;
    },
    onRowMouseDown(event2) {
      if (DomHandler.hasClass(event2.target, "p-datatable-reorderablerow-handle"))
        event2.currentTarget.draggable = true;
      else
        event2.currentTarget.draggable = false;
    },
    onRowDragStart(e) {
      const event2 = e.originalEvent;
      const index = e.index;
      this.rowDragging = true;
      this.draggedRowIndex = index;
      event2.dataTransfer.setData("text", "b");
    },
    onRowDragOver(e) {
      const event2 = e.originalEvent;
      const index = e.index;
      if (this.rowDragging && this.draggedRowIndex !== index) {
        let rowElement = event2.currentTarget;
        let rowY = DomHandler.getOffset(rowElement).top + DomHandler.getWindowScrollTop();
        let pageY = event2.pageY;
        let rowMidY = rowY + DomHandler.getOuterHeight(rowElement) / 2;
        let prevRowElement = rowElement.previousElementSibling;
        if (pageY < rowMidY) {
          DomHandler.removeClass(rowElement, "p-datatable-dragpoint-bottom");
          this.droppedRowIndex = index;
          if (prevRowElement)
            DomHandler.addClass(prevRowElement, "p-datatable-dragpoint-bottom");
          else
            DomHandler.addClass(rowElement, "p-datatable-dragpoint-top");
        } else {
          if (prevRowElement)
            DomHandler.removeClass(prevRowElement, "p-datatable-dragpoint-bottom");
          else
            DomHandler.addClass(rowElement, "p-datatable-dragpoint-top");
          this.droppedRowIndex = index + 1;
          DomHandler.addClass(rowElement, "p-datatable-dragpoint-bottom");
        }
        event2.preventDefault();
      }
    },
    onRowDragLeave(event2) {
      let rowElement = event2.currentTarget;
      let prevRowElement = rowElement.previousElementSibling;
      if (prevRowElement) {
        DomHandler.removeClass(prevRowElement, "p-datatable-dragpoint-bottom");
      }
      DomHandler.removeClass(rowElement, "p-datatable-dragpoint-bottom");
      DomHandler.removeClass(rowElement, "p-datatable-dragpoint-top");
    },
    onRowDragEnd(event2) {
      this.rowDragging = false;
      this.draggedRowIndex = null;
      this.droppedRowIndex = null;
      event2.currentTarget.draggable = false;
    },
    onRowDrop(event2) {
      if (this.droppedRowIndex != null) {
        let dropIndex = this.draggedRowIndex > this.droppedRowIndex ? this.droppedRowIndex : this.droppedRowIndex === 0 ? 0 : this.droppedRowIndex - 1;
        let processedData = [...this.processedData];
        ObjectUtils.reorderArray(processedData, this.draggedRowIndex + this.d_first, dropIndex + this.d_first);
        this.$emit("row-reorder", {
          originalEvent: event2,
          dragIndex: this.draggedRowIndex,
          dropIndex,
          value: processedData
        });
      }
      this.onRowDragLeave(event2);
      this.onRowDragEnd(event2);
      event2.preventDefault();
    },
    toggleRow(event2) {
      let rowData = event2.data;
      let expanded;
      let expandedRowIndex;
      let _expandedRows = this.expandedRows ? [...this.expandedRows] : [];
      if (this.dataKey) {
        expanded = this.d_expandedRowKeys ? this.d_expandedRowKeys[ObjectUtils.resolveFieldData(rowData, this.dataKey)] !== void 0 : false;
      } else {
        expandedRowIndex = this.findIndex(rowData, this.expandedRows);
        expanded = expandedRowIndex > -1;
      }
      if (expanded) {
        if (expandedRowIndex == null) {
          expandedRowIndex = this.findIndex(rowData, this.expandedRows);
        }
        _expandedRows.splice(expandedRowIndex, 1);
        this.$emit("update:expandedRows", _expandedRows);
        this.$emit("row-collapse", event2);
      } else {
        _expandedRows.push(rowData);
        this.$emit("update:expandedRows", _expandedRows);
        this.$emit("row-expand", event2);
      }
    },
    toggleRowGroup(e) {
      const event2 = e.originalEvent;
      const data = e.data;
      const groupFieldValue = ObjectUtils.resolveFieldData(data, this.groupRowsBy);
      let _expandedRowGroups = this.expandedRowGroups ? [...this.expandedRowGroups] : [];
      if (this.isRowGroupExpanded(data)) {
        _expandedRowGroups = _expandedRowGroups.filter((group) => group !== groupFieldValue);
        this.$emit("update:expandedRowGroups", _expandedRowGroups);
        this.$emit("rowgroup-collapse", { originalEvent: event2, data: groupFieldValue });
      } else {
        _expandedRowGroups.push(groupFieldValue);
        this.$emit("update:expandedRowGroups", _expandedRowGroups);
        this.$emit("rowgroup-expand", { originalEvent: event2, data: groupFieldValue });
      }
    },
    isRowGroupExpanded(rowData) {
      if (this.expandableRowGroups && this.expandedRowGroups) {
        let groupFieldValue = ObjectUtils.resolveFieldData(rowData, this.groupRowsBy);
        return this.expandedRowGroups.indexOf(groupFieldValue) > -1;
      }
      return false;
    },
    isStateful() {
      return this.stateKey != null;
    },
    getStorage() {
      switch (this.stateStorage) {
        case "local":
          return window.localStorage;
        case "session":
          return window.sessionStorage;
        default:
          throw new Error(this.stateStorage + ' is not a valid value for the state storage, supported values are "local" and "session".');
      }
    },
    saveState() {
      const storage = this.getStorage();
      let state = {};
      if (this.paginator) {
        state.first = this.d_first;
        state.rows = this.d_rows;
      }
      if (this.d_sortField) {
        state.sortField = this.d_sortField;
        state.sortOrder = this.d_sortOrder;
      }
      if (this.d_multiSortMeta) {
        state.multiSortMeta = this.d_multiSortMeta;
      }
      if (this.hasFilters) {
        state.filters = this.filters;
      }
      if (this.resizableColumns) {
        this.saveColumnWidths(state);
      }
      if (this.reorderableColumns) {
        state.columnOrder = this.d_columnOrder;
      }
      if (this.expandedRows) {
        state.expandedRows = this.expandedRows;
        state.expandedRowKeys = this.d_expandedRowKeys;
      }
      if (this.expandedRowGroups) {
        state.expandedRowGroups = this.expandedRowGroups;
      }
      if (this.selection) {
        state.selection = this.selection;
        state.selectionKeys = this.d_selectionKeys;
      }
      if (Object.keys(state).length) {
        storage.setItem(this.stateKey, JSON.stringify(state));
      }
      this.$emit("state-save", state);
    },
    restoreState() {
      const storage = this.getStorage();
      const stateString = storage.getItem(this.stateKey);
      const dateFormat = /\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}.\d{3}Z/;
      const reviver = function(key, value) {
        if (typeof value === "string" && dateFormat.test(value)) {
          return new Date(value);
        }
        return value;
      };
      if (stateString) {
        let restoredState = JSON.parse(stateString, reviver);
        if (this.paginator) {
          this.d_first = restoredState.first;
          this.d_rows = restoredState.rows;
        }
        if (restoredState.sortField) {
          this.d_sortField = restoredState.sortField;
          this.d_sortOrder = restoredState.sortOrder;
        }
        if (restoredState.multiSortMeta) {
          this.d_multiSortMeta = restoredState.multiSortMeta;
        }
        if (restoredState.filters) {
          this.$emit("update:filters", restoredState.filters);
        }
        if (this.resizableColumns) {
          this.columnWidthsState = restoredState.columnWidths;
          this.tableWidthState = restoredState.tableWidth;
        }
        if (this.reorderableColumns) {
          this.d_columnOrder = restoredState.columnOrder;
        }
        if (restoredState.expandedRows) {
          this.d_expandedRowKeys = restoredState.expandedRowKeys;
          this.$emit("update:expandedRows", restoredState.expandedRows);
        }
        if (restoredState.expandedRowGroups) {
          this.$emit("update:expandedRowGroups", restoredState.expandedRowGroups);
        }
        if (restoredState.selection) {
          this.d_selectionKeys = restoredState.d_selectionKeys;
          this.$emit("update:selection", restoredState.selection);
        }
        this.$emit("state-restore", restoredState);
      }
    },
    saveColumnWidths(state) {
      let widths = [];
      let headers = DomHandler.find(this.$el, ".p-datatable-thead > tr > th");
      headers.forEach((header) => widths.push(DomHandler.getOuterWidth(header)));
      state.columnWidths = widths.join(",");
      if (this.columnResizeMode === "expand") {
        state.tableWidth = DomHandler.getOuterWidth(this.$refs.table) + "px";
      }
    },
    restoreColumnWidths() {
      if (this.columnWidthsState) {
        let widths = this.columnWidthsState.split(",");
        if (this.columnResizeMode === "expand" && this.tableWidthState) {
          this.$refs.table.style.width = this.tableWidthState;
          this.$refs.table.style.minWidth = this.tableWidthState;
          this.$el.style.width = this.tableWidthState;
        }
        if (ObjectUtils.isNotEmpty(widths)) {
          this.createStyleElement();
          let innerHTML = "";
          let selector = `.p-datatable[${this.attributeSelector}] > .p-datatable-wrapper ${this.virtualScrollerDisabled ? "" : "> .p-virtualscroller"} > .p-datatable-table`;
          widths.forEach((width, index) => {
            let style = `width: ${width}px !important; max-width: ${width}px !important`;
            innerHTML += `
                            ${selector} > .p-datatable-thead > tr > th:nth-child(${index + 1}),
                            ${selector} > .p-datatable-tbody > tr > td:nth-child(${index + 1}),
                            ${selector} > .p-datatable-tfoot > tr > td:nth-child(${index + 1}) {
                                ${style}
                            }
                        `;
          });
          this.styleElement.innerHTML = innerHTML;
        }
      }
    },
    onCellEditInit(event2) {
      this.$emit("cell-edit-init", event2);
    },
    onCellEditComplete(event2) {
      this.$emit("cell-edit-complete", event2);
    },
    onCellEditCancel(event2) {
      this.$emit("cell-edit-cancel", event2);
    },
    onRowEditInit(event2) {
      let _editingRows = this.editingRows ? [...this.editingRows] : [];
      _editingRows.push(event2.data);
      this.$emit("update:editingRows", _editingRows);
      this.$emit("row-edit-init", event2);
    },
    onRowEditSave(event2) {
      let _editingRows = [...this.editingRows];
      _editingRows.splice(this.findIndex(event2.data, _editingRows), 1);
      this.$emit("update:editingRows", _editingRows);
      this.$emit("row-edit-save", event2);
    },
    onRowEditCancel(event2) {
      let _editingRows = [...this.editingRows];
      _editingRows.splice(this.findIndex(event2.data, _editingRows), 1);
      this.$emit("update:editingRows", _editingRows);
      this.$emit("row-edit-cancel", event2);
    },
    onEditingMetaChange(event2) {
      let { data, field, index, editing } = event2;
      let editingMeta = { ...this.d_editingMeta };
      let meta = editingMeta[index];
      if (editing) {
        !meta && (meta = editingMeta[index] = { data: { ...data }, fields: [] });
        meta["fields"].push(field);
      } else if (meta) {
        const fields = meta["fields"].filter((f) => f !== field);
        !fields.length ? delete editingMeta[index] : meta["fields"] = fields;
      }
      this.d_editingMeta = editingMeta;
    },
    clearEditingMetaData() {
      if (this.editMode) {
        this.d_editingMeta = {};
      }
    },
    createLazyLoadEvent(event2) {
      return {
        originalEvent: event2,
        first: this.d_first,
        rows: this.d_rows,
        sortField: this.d_sortField,
        sortOrder: this.d_sortOrder,
        multiSortMeta: this.d_multiSortMeta,
        filters: this.d_filters
      };
    },
    hasGlobalFilter() {
      return this.filters && Object.prototype.hasOwnProperty.call(this.filters, "global");
    },
    getChildren() {
      return this.$slots.default ? this.$slots.default() : null;
    },
    onFilterChange(filters) {
      this.d_filters = filters;
    },
    onFilterApply() {
      this.d_first = 0;
      this.$emit("update:first", this.d_first);
      this.$emit("update:filters", this.d_filters);
      if (this.lazy) {
        this.$emit("filter", this.createLazyLoadEvent());
      }
    },
    cloneFilters() {
      let cloned = {};
      if (this.filters) {
        Object.entries(this.filters).forEach(([prop, value]) => {
          cloned[prop] = value.operator ? {
            operator: value.operator,
            constraints: value.constraints.map((constraint) => {
              return { ...constraint };
            })
          } : { ...value };
        });
      }
      return cloned;
    },
    updateReorderableColumns() {
      let columnOrder = [];
      this.columns.forEach((col) => columnOrder.push(this.columnProp(col, "columnKey") || this.columnProp(col, "field")));
      this.d_columnOrder = columnOrder;
    },
    createStyleElement() {
      this.styleElement = document.createElement("style");
      this.styleElement.type = "text/css";
      document.head.appendChild(this.styleElement);
    },
    createResponsiveStyle() {
      if (!this.responsiveStyleElement) {
        this.responsiveStyleElement = document.createElement("style");
        this.responsiveStyleElement.type = "text/css";
        document.head.appendChild(this.responsiveStyleElement);
        let tableSelector = `.p-datatable-wrapper ${this.virtualScrollerDisabled ? "" : "> .p-virtualscroller"} > .p-datatable-table`;
        let selector = `.p-datatable[${this.attributeSelector}] > ${tableSelector}`;
        let gridLinesSelector = `.p-datatable[${this.attributeSelector}].p-datatable-gridlines > ${tableSelector}`;
        let innerHTML = `
@media screen and (max-width: ${this.breakpoint}) {
    ${selector} > .p-datatable-thead > tr > th,
    ${selector} > .p-datatable-tfoot > tr > td {
        display: none !important;
    }

    ${selector} > .p-datatable-tbody > tr > td {
        display: flex;
        width: 100% !important;
        align-items: center;
        justify-content: space-between;
    }

    ${selector} > .p-datatable-tbody > tr > td:not(:last-child) {
        border: 0 none;
    }

    ${gridLinesSelector} > .p-datatable-tbody > tr > td:last-child {
        border-top: 0;
        border-right: 0;
        border-left: 0;
    }

    ${selector} > .p-datatable-tbody > tr > td > .p-column-title {
        display: block;
    }
}
`;
        this.responsiveStyleElement.innerHTML = innerHTML;
      }
    },
    destroyResponsiveStyle() {
      if (this.responsiveStyleElement) {
        document.head.removeChild(this.responsiveStyleElement);
        this.responsiveStyleElement = null;
      }
    },
    destroyStyleElement() {
      if (this.styleElement) {
        document.head.removeChild(this.styleElement);
        this.styleElement = null;
      }
    },
    recursiveGetChildren(children, results) {
      if (!results) {
        results = [];
      }
      if (children && children.length) {
        children.forEach((child) => {
          if (child.children instanceof Array) {
            results.concat(this.recursiveGetChildren(child.children, results));
          } else if (child.type.name == "Column") {
            results.push(child);
          }
        });
      }
      return results;
    },
    dataToRender(data) {
      const _data = data || this.processedData;
      if (_data && this.paginator) {
        const first = this.lazy ? 0 : this.d_first;
        return _data.slice(first, first + this.d_rows);
      }
      return _data;
    },
    getVirtualScrollerRef() {
      return this.$refs.virtualScroller;
    },
    hasSpacerStyle(style) {
      return ObjectUtils.isNotEmpty(style);
    }
  },
  computed: {
    containerClass() {
      return [
        "p-datatable p-component",
        {
          "p-datatable-hoverable-rows": this.rowHover || this.selectionMode,
          "p-datatable-resizable": this.resizableColumns,
          "p-datatable-resizable-fit": this.resizableColumns && this.columnResizeMode === "fit",
          "p-datatable-scrollable": this.scrollable,
          "p-datatable-flex-scrollable": this.scrollable && this.scrollHeight === "flex",
          "p-datatable-responsive-stack": this.responsiveLayout === "stack",
          "p-datatable-responsive-scroll": this.responsiveLayout === "scroll",
          "p-datatable-striped": this.stripedRows,
          "p-datatable-gridlines": this.showGridlines,
          "p-datatable-grouped-header": this.headerColumnGroup != null,
          "p-datatable-grouped-footer": this.footerColumnGroup != null
        }
      ];
    },
    tableStyleClass() {
      return [
        "p-datatable-table",
        {
          "p-datatable-scrollable-table": this.scrollable,
          "p-datatable-resizable-table": this.resizableColumns,
          "p-datatable-resizable-table-fit": this.resizableColumns && this.columnResizeMode === "fit"
        },
        this.tableClass
      ];
    },
    columns() {
      let children = this.getChildren();
      if (!children) {
        return;
      }
      const cols = this.recursiveGetChildren(children, []);
      if (this.reorderableColumns && this.d_columnOrder) {
        let orderedColumns = [];
        for (let columnKey of this.d_columnOrder) {
          let column = this.findColumnByKey(cols, columnKey);
          if (column && !this.columnProp(column, "hidden")) {
            orderedColumns.push(column);
          }
        }
        return [...orderedColumns, ...cols.filter((item) => orderedColumns.indexOf(item) < 0)];
      }
      return cols;
    },
    headerColumnGroup() {
      const children = this.getChildren();
      if (children) {
        for (let child of children) {
          if (child.type.name === "ColumnGroup" && this.columnProp(child, "type") === "header") {
            return child;
          }
        }
      }
      return null;
    },
    footerColumnGroup() {
      const children = this.getChildren();
      if (children) {
        for (let child of children) {
          if (child.type.name === "ColumnGroup" && this.columnProp(child, "type") === "footer") {
            return child;
          }
        }
      }
      return null;
    },
    hasFilters() {
      return this.filters && Object.keys(this.filters).length > 0 && this.filters.constructor === Object;
    },
    processedData() {
      let data = this.value || [];
      if (!this.lazy) {
        if (data && data.length) {
          if (this.hasFilters) {
            data = this.filter(data);
          }
          if (this.sorted) {
            if (this.sortMode === "single")
              data = this.sortSingle(data);
            else if (this.sortMode === "multiple")
              data = this.sortMultiple(data);
          }
        }
      }
      return data;
    },
    totalRecordsLength() {
      if (this.lazy) {
        return this.totalRecords;
      } else {
        const data = this.processedData;
        return data ? data.length : 0;
      }
    },
    empty() {
      const data = this.processedData;
      return !data || data.length === 0;
    },
    paginatorTop() {
      return this.paginator && (this.paginatorPosition !== "bottom" || this.paginatorPosition === "both");
    },
    paginatorBottom() {
      return this.paginator && (this.paginatorPosition !== "top" || this.paginatorPosition === "both");
    },
    sorted() {
      return this.d_sortField || this.d_multiSortMeta && this.d_multiSortMeta.length > 0;
    },
    allRowsSelected() {
      if (this.selectAll !== null) {
        return this.selectAll;
      } else {
        const val = this.frozenValue ? [...this.frozenValue, ...this.processedData] : this.processedData;
        return ObjectUtils.isNotEmpty(val) && this.selection && Array.isArray(this.selection) && val.every((v) => this.selection.some((s) => this.equals(s, v)));
      }
    },
    attributeSelector() {
      return UniqueComponentId();
    },
    groupRowSortField() {
      return this.sortMode === "single" ? this.sortField : this.d_groupRowsSortMeta ? this.d_groupRowsSortMeta.field : null;
    },
    virtualScrollerDisabled() {
      return ObjectUtils.isEmpty(this.virtualScrollerOptions) || !this.scrollable;
    }
  },
  components: {
    DTPaginator: script$j,
    DTTableHeader: script$1$1,
    DTTableBody: script$7$1,
    DTTableFooter: script$5$1,
    DTVirtualScroller: script$P,
    ArrowDownIcon: script$p,
    ArrowUpIcon: script$o,
    SpinnerIcon: script$U
  }
};
function render$b(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_SpinnerIcon = resolveComponent("SpinnerIcon");
  const _component_DTPaginator = resolveComponent("DTPaginator");
  const _component_DTTableHeader = resolveComponent("DTTableHeader");
  const _component_DTTableBody = resolveComponent("DTTableBody");
  const _component_DTTableFooter = resolveComponent("DTTableFooter");
  const _component_DTVirtualScroller = resolveComponent("DTVirtualScroller");
  return openBlock(), createElementBlock("div", mergeProps({
    class: $options.containerClass,
    "data-scrollselectors": ".p-datatable-wrapper"
  }, _ctx.ptm("root")), [
    renderSlot(_ctx.$slots, "default"),
    $props.loading ? (openBlock(), createElementBlock("div", mergeProps({
      key: 0,
      class: "p-datatable-loading-overlay p-component-overlay"
    }, _ctx.ptm("loadingOverlay")), [
      _ctx.$slots.loading ? renderSlot(_ctx.$slots, "loading", { key: 0 }) : (openBlock(), createElementBlock(Fragment, { key: 1 }, [
        _ctx.$slots.loadingicon ? (openBlock(), createBlock(resolveDynamicComponent(_ctx.$slots.loadingicon), {
          key: 0,
          class: "p-datatable-loading-icon"
        })) : $props.loadingIcon ? (openBlock(), createElementBlock("i", mergeProps({
          key: 1,
          class: ["p-datatable-loading-icon pi-spin", $props.loadingIcon]
        }, _ctx.ptm("loadingIcon")), null, 16)) : (openBlock(), createBlock(_component_SpinnerIcon, mergeProps({
          key: 2,
          spin: "",
          class: "p-datatable-loading-icon"
        }, _ctx.ptm("loadingIcon")), null, 16))
      ], 64))
    ], 16)) : createCommentVNode("", true),
    _ctx.$slots.header ? (openBlock(), createElementBlock("div", mergeProps({
      key: 1,
      class: "p-datatable-header"
    }, _ctx.ptm("header")), [
      renderSlot(_ctx.$slots, "header")
    ], 16)) : createCommentVNode("", true),
    $options.paginatorTop ? (openBlock(), createBlock(_component_DTPaginator, {
      key: 2,
      rows: $data.d_rows,
      first: $data.d_first,
      totalRecords: $options.totalRecordsLength,
      pageLinkSize: $props.pageLinkSize,
      template: $props.paginatorTemplate,
      rowsPerPageOptions: $props.rowsPerPageOptions,
      currentPageReportTemplate: $props.currentPageReportTemplate,
      class: "p-paginator-top",
      onPage: _cache[0] || (_cache[0] = ($event) => $options.onPage($event)),
      alwaysShow: $props.alwaysShowPaginator,
      pt: _ctx.ptm("paginator")
    }, createSlots({ _: 2 }, [
      _ctx.$slots.paginatorstart ? {
        name: "start",
        fn: withCtx(() => [
          renderSlot(_ctx.$slots, "paginatorstart")
        ]),
        key: "0"
      } : void 0,
      _ctx.$slots.paginatorend ? {
        name: "end",
        fn: withCtx(() => [
          renderSlot(_ctx.$slots, "paginatorend")
        ]),
        key: "1"
      } : void 0,
      _ctx.$slots.paginatorfirstpagelinkicon ? {
        name: "firstpagelinkicon",
        fn: withCtx(() => [
          renderSlot(_ctx.$slots, "paginatorfirstpagelinkicon")
        ]),
        key: "2"
      } : void 0,
      _ctx.$slots.paginatorprevpagelinkicon ? {
        name: "prevpagelinkicon",
        fn: withCtx(() => [
          renderSlot(_ctx.$slots, "paginatorprevpagelinkicon")
        ]),
        key: "3"
      } : void 0,
      _ctx.$slots.paginatornextpagelinkicon ? {
        name: "nextpagelinkicon",
        fn: withCtx(() => [
          renderSlot(_ctx.$slots, "paginatornextpagelinkicon")
        ]),
        key: "4"
      } : void 0,
      _ctx.$slots.paginatorlastpagelinkicon ? {
        name: "lastpagelinkicon",
        fn: withCtx(() => [
          renderSlot(_ctx.$slots, "paginatorlastpagelinkicon")
        ]),
        key: "5"
      } : void 0
    ]), 1032, ["rows", "first", "totalRecords", "pageLinkSize", "template", "rowsPerPageOptions", "currentPageReportTemplate", "alwaysShow", "pt"])) : createCommentVNode("", true),
    createElementVNode("div", mergeProps({
      class: "p-datatable-wrapper",
      style: { maxHeight: $options.virtualScrollerDisabled ? $props.scrollHeight : "" }
    }, _ctx.ptm("wrapper")), [
      createVNode(_component_DTVirtualScroller, mergeProps({ ref: "virtualScroller" }, { ...$props.virtualScrollerOptions, ..._ctx.ptm("virtualScroller") }, {
        items: $options.processedData,
        columns: $options.columns,
        style: $props.scrollHeight !== "flex" ? { height: $props.scrollHeight } : void 0,
        scrollHeight: $props.scrollHeight !== "flex" ? void 0 : "100%",
        disabled: $options.virtualScrollerDisabled,
        loaderDisabled: "",
        inline: "",
        autoSize: "",
        showSpacer: false
      }), {
        content: withCtx((slotProps) => [
          createElementVNode("table", mergeProps({
            ref: "table",
            role: "table",
            class: $options.tableStyleClass,
            style: [$props.tableStyle, slotProps.spacerStyle]
          }, { ...$props.tableProps, ..._ctx.ptm("table") }), [
            createVNode(_component_DTTableHeader, {
              columnGroup: $options.headerColumnGroup,
              columns: slotProps.columns,
              rowGroupMode: $props.rowGroupMode,
              groupRowsBy: $props.groupRowsBy,
              groupRowSortField: $options.groupRowSortField,
              reorderableColumns: $props.reorderableColumns,
              resizableColumns: $props.resizableColumns,
              allRowsSelected: $options.allRowsSelected,
              empty: $options.empty,
              sortMode: $props.sortMode,
              sortField: $data.d_sortField,
              sortOrder: $data.d_sortOrder,
              multiSortMeta: $data.d_multiSortMeta,
              filters: $data.d_filters,
              filtersStore: $props.filters,
              filterDisplay: $props.filterDisplay,
              filterInputProps: $props.filterInputProps,
              headerCheckboxIconTemplate: _ctx.$slots.headercheckboxicon,
              onColumnClick: _cache[1] || (_cache[1] = ($event) => $options.onColumnHeaderClick($event)),
              onColumnMousedown: _cache[2] || (_cache[2] = ($event) => $options.onColumnHeaderMouseDown($event)),
              onFilterChange: $options.onFilterChange,
              onFilterApply: $options.onFilterApply,
              onColumnDragstart: _cache[3] || (_cache[3] = ($event) => $options.onColumnHeaderDragStart($event)),
              onColumnDragover: _cache[4] || (_cache[4] = ($event) => $options.onColumnHeaderDragOver($event)),
              onColumnDragleave: _cache[5] || (_cache[5] = ($event) => $options.onColumnHeaderDragLeave($event)),
              onColumnDrop: _cache[6] || (_cache[6] = ($event) => $options.onColumnHeaderDrop($event)),
              onColumnResizestart: _cache[7] || (_cache[7] = ($event) => $options.onColumnResizeStart($event)),
              onCheckboxChange: _cache[8] || (_cache[8] = ($event) => $options.toggleRowsWithCheckbox($event)),
              pt: _ctx.pt
            }, null, 8, ["columnGroup", "columns", "rowGroupMode", "groupRowsBy", "groupRowSortField", "reorderableColumns", "resizableColumns", "allRowsSelected", "empty", "sortMode", "sortField", "sortOrder", "multiSortMeta", "filters", "filtersStore", "filterDisplay", "filterInputProps", "headerCheckboxIconTemplate", "onFilterChange", "onFilterApply", "pt"]),
            $props.frozenValue ? (openBlock(), createBlock(_component_DTTableBody, {
              key: 0,
              ref: "frozenBodyRef",
              value: $props.frozenValue,
              frozenRow: true,
              class: "p-datatable-frozen-tbody",
              columns: slotProps.columns,
              first: $data.d_first,
              dataKey: $props.dataKey,
              selection: $props.selection,
              selectionKeys: $data.d_selectionKeys,
              selectionMode: $props.selectionMode,
              contextMenu: $props.contextMenu,
              contextMenuSelection: $props.contextMenuSelection,
              rowGroupMode: $props.rowGroupMode,
              groupRowsBy: $props.groupRowsBy,
              expandableRowGroups: $props.expandableRowGroups,
              rowClass: $props.rowClass,
              rowStyle: $props.rowStyle,
              editMode: $props.editMode,
              compareSelectionBy: $props.compareSelectionBy,
              scrollable: $props.scrollable,
              expandedRowIcon: $props.expandedRowIcon,
              collapsedRowIcon: $props.collapsedRowIcon,
              expandedRows: $props.expandedRows,
              expandedRowKeys: $data.d_expandedRowKeys,
              expandedRowGroups: $props.expandedRowGroups,
              editingRows: $props.editingRows,
              editingRowKeys: $data.d_editingRowKeys,
              templates: _ctx.$slots,
              responsiveLayout: $props.responsiveLayout,
              isVirtualScrollerDisabled: true,
              onRowgroupToggle: $options.toggleRowGroup,
              onRowClick: _cache[9] || (_cache[9] = ($event) => $options.onRowClick($event)),
              onRowDblclick: _cache[10] || (_cache[10] = ($event) => $options.onRowDblClick($event)),
              onRowRightclick: _cache[11] || (_cache[11] = ($event) => $options.onRowRightClick($event)),
              onRowTouchend: $options.onRowTouchEnd,
              onRowKeydown: $options.onRowKeyDown,
              onRowMousedown: $options.onRowMouseDown,
              onRowDragstart: _cache[12] || (_cache[12] = ($event) => $options.onRowDragStart($event)),
              onRowDragover: _cache[13] || (_cache[13] = ($event) => $options.onRowDragOver($event)),
              onRowDragleave: _cache[14] || (_cache[14] = ($event) => $options.onRowDragLeave($event)),
              onRowDragend: _cache[15] || (_cache[15] = ($event) => $options.onRowDragEnd($event)),
              onRowDrop: _cache[16] || (_cache[16] = ($event) => $options.onRowDrop($event)),
              onRowToggle: _cache[17] || (_cache[17] = ($event) => $options.toggleRow($event)),
              onRadioChange: _cache[18] || (_cache[18] = ($event) => $options.toggleRowWithRadio($event)),
              onCheckboxChange: _cache[19] || (_cache[19] = ($event) => $options.toggleRowWithCheckbox($event)),
              onCellEditInit: _cache[20] || (_cache[20] = ($event) => $options.onCellEditInit($event)),
              onCellEditComplete: _cache[21] || (_cache[21] = ($event) => $options.onCellEditComplete($event)),
              onCellEditCancel: _cache[22] || (_cache[22] = ($event) => $options.onCellEditCancel($event)),
              onRowEditInit: _cache[23] || (_cache[23] = ($event) => $options.onRowEditInit($event)),
              onRowEditSave: _cache[24] || (_cache[24] = ($event) => $options.onRowEditSave($event)),
              onRowEditCancel: _cache[25] || (_cache[25] = ($event) => $options.onRowEditCancel($event)),
              editingMeta: $data.d_editingMeta,
              onEditingMetaChange: $options.onEditingMetaChange
            }, null, 8, ["value", "columns", "first", "dataKey", "selection", "selectionKeys", "selectionMode", "contextMenu", "contextMenuSelection", "rowGroupMode", "groupRowsBy", "expandableRowGroups", "rowClass", "rowStyle", "editMode", "compareSelectionBy", "scrollable", "expandedRowIcon", "collapsedRowIcon", "expandedRows", "expandedRowKeys", "expandedRowGroups", "editingRows", "editingRowKeys", "templates", "responsiveLayout", "onRowgroupToggle", "onRowTouchend", "onRowKeydown", "onRowMousedown", "editingMeta", "onEditingMetaChange"])) : createCommentVNode("", true),
            createVNode(_component_DTTableBody, {
              ref: "bodyRef",
              value: $options.dataToRender(slotProps.rows),
              class: normalizeClass(slotProps.styleClass),
              columns: slotProps.columns,
              empty: $options.empty,
              first: $data.d_first,
              dataKey: $props.dataKey,
              selection: $props.selection,
              selectionKeys: $data.d_selectionKeys,
              selectionMode: $props.selectionMode,
              contextMenu: $props.contextMenu,
              contextMenuSelection: $props.contextMenuSelection,
              rowGroupMode: $props.rowGroupMode,
              groupRowsBy: $props.groupRowsBy,
              expandableRowGroups: $props.expandableRowGroups,
              rowClass: $props.rowClass,
              rowStyle: $props.rowStyle,
              editMode: $props.editMode,
              compareSelectionBy: $props.compareSelectionBy,
              scrollable: $props.scrollable,
              expandedRowIcon: $props.expandedRowIcon,
              collapsedRowIcon: $props.collapsedRowIcon,
              expandedRows: $props.expandedRows,
              expandedRowKeys: $data.d_expandedRowKeys,
              expandedRowGroups: $props.expandedRowGroups,
              editingRows: $props.editingRows,
              editingRowKeys: $data.d_editingRowKeys,
              templates: _ctx.$slots,
              responsiveLayout: $props.responsiveLayout,
              virtualScrollerContentProps: slotProps,
              isVirtualScrollerDisabled: $options.virtualScrollerDisabled,
              onRowgroupToggle: $options.toggleRowGroup,
              onRowClick: _cache[26] || (_cache[26] = ($event) => $options.onRowClick($event)),
              onRowDblclick: _cache[27] || (_cache[27] = ($event) => $options.onRowDblClick($event)),
              onRowRightclick: _cache[28] || (_cache[28] = ($event) => $options.onRowRightClick($event)),
              onRowTouchend: $options.onRowTouchEnd,
              onRowKeydown: ($event) => $options.onRowKeyDown($event, slotProps),
              onRowMousedown: $options.onRowMouseDown,
              onRowDragstart: _cache[29] || (_cache[29] = ($event) => $options.onRowDragStart($event)),
              onRowDragover: _cache[30] || (_cache[30] = ($event) => $options.onRowDragOver($event)),
              onRowDragleave: _cache[31] || (_cache[31] = ($event) => $options.onRowDragLeave($event)),
              onRowDragend: _cache[32] || (_cache[32] = ($event) => $options.onRowDragEnd($event)),
              onRowDrop: _cache[33] || (_cache[33] = ($event) => $options.onRowDrop($event)),
              onRowToggle: _cache[34] || (_cache[34] = ($event) => $options.toggleRow($event)),
              onRadioChange: _cache[35] || (_cache[35] = ($event) => $options.toggleRowWithRadio($event)),
              onCheckboxChange: _cache[36] || (_cache[36] = ($event) => $options.toggleRowWithCheckbox($event)),
              onCellEditInit: _cache[37] || (_cache[37] = ($event) => $options.onCellEditInit($event)),
              onCellEditComplete: _cache[38] || (_cache[38] = ($event) => $options.onCellEditComplete($event)),
              onCellEditCancel: _cache[39] || (_cache[39] = ($event) => $options.onCellEditCancel($event)),
              onRowEditInit: _cache[40] || (_cache[40] = ($event) => $options.onRowEditInit($event)),
              onRowEditSave: _cache[41] || (_cache[41] = ($event) => $options.onRowEditSave($event)),
              onRowEditCancel: _cache[42] || (_cache[42] = ($event) => $options.onRowEditCancel($event)),
              editingMeta: $data.d_editingMeta,
              onEditingMetaChange: $options.onEditingMetaChange,
              pt: _ctx.pt
            }, null, 8, ["value", "class", "columns", "empty", "first", "dataKey", "selection", "selectionKeys", "selectionMode", "contextMenu", "contextMenuSelection", "rowGroupMode", "groupRowsBy", "expandableRowGroups", "rowClass", "rowStyle", "editMode", "compareSelectionBy", "scrollable", "expandedRowIcon", "collapsedRowIcon", "expandedRows", "expandedRowKeys", "expandedRowGroups", "editingRows", "editingRowKeys", "templates", "responsiveLayout", "virtualScrollerContentProps", "isVirtualScrollerDisabled", "onRowgroupToggle", "onRowTouchend", "onRowKeydown", "onRowMousedown", "editingMeta", "onEditingMetaChange", "pt"]),
            $options.hasSpacerStyle(slotProps.spacerStyle) ? (openBlock(), createElementBlock("tbody", mergeProps({
              key: 1,
              style: { height: `calc(${slotProps.spacerStyle.height} - ${slotProps.rows.length * slotProps.itemSize}px)` },
              class: "p-datatable-virtualscroller-spacer"
            }, _ctx.ptm("virtualScrollerSpacer")), null, 16)) : createCommentVNode("", true),
            createVNode(_component_DTTableFooter, {
              columnGroup: $options.footerColumnGroup,
              columns: slotProps.columns,
              pt: _ctx.pt
            }, null, 8, ["columnGroup", "columns", "pt"])
          ], 16)
        ]),
        _: 1
      }, 16, ["items", "columns", "style", "scrollHeight", "disabled"])
    ], 16),
    _ctx.$slots.footer ? (openBlock(), createElementBlock("div", mergeProps({
      key: 3,
      class: "p-datatable-footer"
    }, _ctx.ptm("footer")), [
      renderSlot(_ctx.$slots, "footer")
    ], 16)) : createCommentVNode("", true),
    $options.paginatorBottom ? (openBlock(), createBlock(_component_DTPaginator, {
      key: 4,
      rows: $data.d_rows,
      first: $data.d_first,
      totalRecords: $options.totalRecordsLength,
      pageLinkSize: $props.pageLinkSize,
      template: $props.paginatorTemplate,
      rowsPerPageOptions: $props.rowsPerPageOptions,
      currentPageReportTemplate: $props.currentPageReportTemplate,
      class: "p-paginator-bottom",
      onPage: _cache[43] || (_cache[43] = ($event) => $options.onPage($event)),
      alwaysShow: $props.alwaysShowPaginator,
      pt: _ctx.ptm("paginator")
    }, createSlots({ _: 2 }, [
      _ctx.$slots.paginatorstart ? {
        name: "start",
        fn: withCtx(() => [
          renderSlot(_ctx.$slots, "paginatorstart")
        ]),
        key: "0"
      } : void 0,
      _ctx.$slots.paginatorend ? {
        name: "end",
        fn: withCtx(() => [
          renderSlot(_ctx.$slots, "paginatorend")
        ]),
        key: "1"
      } : void 0,
      _ctx.$slots.paginatorfirstpagelinkicon ? {
        name: "firstpagelinkicon",
        fn: withCtx(() => [
          renderSlot(_ctx.$slots, "paginatorfirstpagelinkicon")
        ]),
        key: "2"
      } : void 0,
      _ctx.$slots.paginatorprevpagelinkicon ? {
        name: "prevpagelinkicon",
        fn: withCtx(() => [
          renderSlot(_ctx.$slots, "paginatorprevpagelinkicon")
        ]),
        key: "3"
      } : void 0,
      _ctx.$slots.paginatornextpagelinkicon ? {
        name: "nextpagelinkicon",
        fn: withCtx(() => [
          renderSlot(_ctx.$slots, "paginatornextpagelinkicon")
        ]),
        key: "4"
      } : void 0,
      _ctx.$slots.paginatorlastpagelinkicon ? {
        name: "lastpagelinkicon",
        fn: withCtx(() => [
          renderSlot(_ctx.$slots, "paginatorlastpagelinkicon")
        ]),
        key: "5"
      } : void 0
    ]), 1032, ["rows", "first", "totalRecords", "pageLinkSize", "template", "rowsPerPageOptions", "currentPageReportTemplate", "alwaysShow", "pt"])) : createCommentVNode("", true),
    createElementVNode("div", mergeProps({
      ref: "resizeHelper",
      class: "p-column-resizer-helper",
      style: { "display": "none" }
    }, _ctx.ptm("resizeHelper")), null, 16),
    $props.reorderableColumns ? (openBlock(), createElementBlock("span", mergeProps({
      key: 5,
      ref: "reorderIndicatorUp",
      class: "p-datatable-reorder-indicator-up",
      style: { "position": "absolute", "display": "none" }
    }, _ctx.ptm("reorderIndicatorUp")), [
      (openBlock(), createBlock(resolveDynamicComponent(_ctx.$slots.reorderindicatorupicon || "ArrowDownIcon")))
    ], 16)) : createCommentVNode("", true),
    $props.reorderableColumns ? (openBlock(), createElementBlock("span", mergeProps({
      key: 6,
      ref: "reorderIndicatorDown",
      class: "p-datatable-reorder-indicator-down",
      style: { "position": "absolute", "display": "none" }
    }, _ctx.ptm("reorderIndicatorDown")), [
      (openBlock(), createBlock(resolveDynamicComponent(_ctx.$slots.reorderindicatordownicon || "ArrowUpIcon")))
    ], 16)) : createCommentVNode("", true)
  ], 16);
}
function styleInject$4(css, ref2) {
  if (ref2 === void 0)
    ref2 = {};
  var insertAt = ref2.insertAt;
  if (!css || true) {
    return;
  }
  var head = document.head || document.getElementsByTagName("head")[0];
  var style = document.createElement("style");
  style.type = "text/css";
  if (insertAt === "top") {
    if (head.firstChild) {
      head.insertBefore(style, head.firstChild);
    } else {
      head.appendChild(style);
    }
  } else {
    head.appendChild(style);
  }
  if (style.styleSheet) {
    style.styleSheet.cssText = css;
  } else {
    style.appendChild(document.createTextNode(css));
  }
}
var css_248z$4 = "\n.p-datatable {\n    position: relative;\n}\n.p-datatable > .p-datatable-wrapper {\n    overflow: auto;\n}\n.p-datatable-table {\n    border-spacing: 0px;\n    width: 100%;\n}\n.p-datatable .p-sortable-column {\n    cursor: pointer;\n    user-select: none;\n}\n.p-datatable .p-sortable-column .p-column-title,\n.p-datatable .p-sortable-column .p-sortable-column-icon,\n.p-datatable .p-sortable-column .p-sortable-column-badge {\n    vertical-align: middle;\n}\n.p-datatable .p-sortable-column .p-sortable-column-badge {\n    display: inline-flex;\n    align-items: center;\n    justify-content: center;\n}\n.p-datatable-hoverable-rows .p-selectable-row {\n    cursor: pointer;\n}\n\n/* Scrollable */\n.p-datatable-scrollable > .p-datatable-wrapper {\n    position: relative;\n}\n.p-datatable-scrollable-table > .p-datatable-thead {\n    position: sticky;\n    top: 0;\n    z-index: 1;\n}\n.p-datatable-scrollable-table > .p-datatable-frozen-tbody {\n    position: sticky;\n    z-index: 1;\n}\n.p-datatable-scrollable-table > .p-datatable-tfoot {\n    position: sticky;\n    bottom: 0;\n    z-index: 1;\n}\n.p-datatable-scrollable .p-frozen-column {\n    position: sticky;\n    background: inherit;\n}\n.p-datatable-scrollable th.p-frozen-column {\n    z-index: 1;\n}\n.p-datatable-flex-scrollable {\n    display: flex;\n    flex-direction: column;\n    height: 100%;\n}\n.p-datatable-flex-scrollable > .p-datatable-wrapper {\n    display: flex;\n    flex-direction: column;\n    flex: 1;\n    height: 100%;\n}\n.p-datatable-scrollable-table > .p-datatable-tbody > .p-rowgroup-header {\n    position: sticky;\n    z-index: 1;\n}\n\n/* Resizable */\n.p-datatable-resizable-table > .p-datatable-thead > tr > th,\n.p-datatable-resizable-table > .p-datatable-tfoot > tr > td,\n.p-datatable-resizable-table > .p-datatable-tbody > tr > td {\n    overflow: hidden;\n    white-space: nowrap;\n}\n.p-datatable-resizable-table > .p-datatable-thead > tr > th.p-resizable-column:not(.p-frozen-column) {\n    background-clip: padding-box;\n    position: relative;\n}\n.p-datatable-resizable-table-fit > .p-datatable-thead > tr > th.p-resizable-column:last-child .p-column-resizer {\n    display: none;\n}\n.p-datatable .p-column-resizer {\n    display: block;\n    position: absolute !important;\n    top: 0;\n    right: 0;\n    margin: 0;\n    width: 0.5rem;\n    height: 100%;\n    padding: 0px;\n    cursor: col-resize;\n    border: 1px solid transparent;\n}\n.p-datatable .p-column-header-content {\n    display: flex;\n    align-items: center;\n}\n.p-datatable .p-column-resizer-helper {\n    width: 1px;\n    position: absolute;\n    z-index: 10;\n    display: none;\n}\n.p-datatable .p-row-editor-init,\n.p-datatable .p-row-editor-save,\n.p-datatable .p-row-editor-cancel {\n    display: inline-flex;\n    align-items: center;\n    justify-content: center;\n    overflow: hidden;\n    position: relative;\n}\n\n/* Expand */\n.p-datatable .p-row-toggler {\n    display: inline-flex;\n    align-items: center;\n    justify-content: center;\n    overflow: hidden;\n    position: relative;\n}\n\n/* Reorder */\n.p-datatable-reorder-indicator-up,\n.p-datatable-reorder-indicator-down {\n    position: absolute;\n    display: none;\n}\n.p-reorderable-column,\n.p-datatable-reorderablerow-handle {\n    cursor: move;\n}\n\n/* Loader */\n.p-datatable .p-datatable-loading-overlay {\n    position: absolute;\n    display: flex;\n    align-items: center;\n    justify-content: center;\n    z-index: 2;\n}\n\n/* Filter */\n.p-column-filter-row {\n    display: flex;\n    align-items: center;\n    width: 100%;\n}\n.p-column-filter-menu {\n    display: inline-flex;\n    margin-left: auto;\n}\n.p-column-filter-row .p-column-filter-element {\n    flex: 1 1 auto;\n    width: 1%;\n}\n.p-column-filter-menu-button,\n.p-column-filter-clear-button {\n    display: inline-flex;\n    justify-content: center;\n    align-items: center;\n    cursor: pointer;\n    text-decoration: none;\n    overflow: hidden;\n    position: relative;\n}\n.p-column-filter-overlay {\n    position: absolute;\n    top: 0;\n    left: 0;\n}\n.p-column-filter-row-items {\n    margin: 0;\n    padding: 0;\n    list-style: none;\n}\n.p-column-filter-row-item {\n    cursor: pointer;\n}\n.p-column-filter-add-button,\n.p-column-filter-remove-button {\n    justify-content: center;\n}\n.p-column-filter-add-button .p-button-label,\n.p-column-filter-remove-button .p-button-label {\n    flex-grow: 0;\n}\n.p-column-filter-buttonbar {\n    display: flex;\n    align-items: center;\n    justify-content: space-between;\n}\n.p-column-filter-buttonbar .p-button:not(.p-button-icon-only) {\n    width: auto;\n}\n\n/* Responsive */\n.p-datatable .p-datatable-tbody > tr > td > .p-column-title {\n    display: none;\n}\n\n/* VirtualScroller */\n.p-datatable-virtualscroller-spacer {\n    display: flex;\n}\n.p-datatable .p-virtualscroller .p-virtualscroller-loading {\n    transform: none !important;\n    min-height: 0;\n    position: sticky;\n    top: 0;\n    left: 0;\n}\n";
styleInject$4(css_248z$4);
script$b.render = render$b;
var script$9 = {
  name: "Column",
  extends: script$W,
  props: {
    columnKey: {
      type: null,
      default: null
    },
    field: {
      type: [String, Function],
      default: null
    },
    sortField: {
      type: [String, Function],
      default: null
    },
    filterField: {
      type: [String, Function],
      default: null
    },
    dataType: {
      type: String,
      default: "text"
    },
    sortable: {
      type: Boolean,
      default: false
    },
    header: {
      type: null,
      default: null
    },
    footer: {
      type: null,
      default: null
    },
    style: {
      type: null,
      default: null
    },
    class: {
      type: String,
      default: null
    },
    headerStyle: {
      type: null,
      default: null
    },
    headerClass: {
      type: String,
      default: null
    },
    bodyStyle: {
      type: null,
      default: null
    },
    bodyClass: {
      type: String,
      default: null
    },
    footerStyle: {
      type: null,
      default: null
    },
    footerClass: {
      type: String,
      default: null
    },
    showFilterMenu: {
      type: Boolean,
      default: true
    },
    showFilterOperator: {
      type: Boolean,
      default: true
    },
    showClearButton: {
      type: Boolean,
      default: true
    },
    showApplyButton: {
      type: Boolean,
      default: true
    },
    showFilterMatchModes: {
      type: Boolean,
      default: true
    },
    showAddButton: {
      type: Boolean,
      default: true
    },
    filterMatchModeOptions: {
      type: Array,
      default: null
    },
    maxConstraints: {
      type: Number,
      default: 2
    },
    excludeGlobalFilter: {
      type: Boolean,
      default: false
    },
    filterHeaderClass: {
      type: String,
      default: null
    },
    filterHeaderStyle: {
      type: null,
      default: null
    },
    filterMenuClass: {
      type: String,
      default: null
    },
    filterMenuStyle: {
      type: null,
      default: null
    },
    selectionMode: {
      type: String,
      default: null
    },
    expander: {
      type: Boolean,
      default: false
    },
    colspan: {
      type: Number,
      default: null
    },
    rowspan: {
      type: Number,
      default: null
    },
    rowReorder: {
      type: Boolean,
      default: false
    },
    rowReorderIcon: {
      type: String,
      default: void 0
    },
    reorderableColumn: {
      type: Boolean,
      default: true
    },
    rowEditor: {
      type: Boolean,
      default: false
    },
    frozen: {
      type: Boolean,
      default: false
    },
    alignFrozen: {
      type: String,
      default: "left"
    },
    exportable: {
      type: Boolean,
      default: true
    },
    exportHeader: {
      type: String,
      default: null
    },
    exportFooter: {
      type: String,
      default: null
    },
    filterMatchMode: {
      type: String,
      default: null
    },
    hidden: {
      type: Boolean,
      default: false
    }
  },
  render() {
    return null;
  }
};
var script$8 = {
  name: "Badge",
  extends: script$W,
  props: {
    value: {
      type: [String, Number],
      default: null
    },
    severity: {
      type: String,
      default: null
    },
    size: {
      type: String,
      default: null
    }
  },
  computed: {
    containerClass() {
      return this.$slots.default ? "p-overlay-badge" : this.badgeClass;
    },
    badgeClass() {
      return [
        "p-badge p-component",
        {
          "p-badge-no-gutter": ObjectUtils.isNotEmpty(this.value) && String(this.value).length === 1,
          "p-badge-dot": ObjectUtils.isEmpty(this.value) && !this.$slots.default,
          "p-badge-lg": this.size === "large",
          "p-badge-xl": this.size === "xlarge",
          "p-badge-info": this.severity === "info",
          "p-badge-success": this.severity === "success",
          "p-badge-warning": this.severity === "warning",
          "p-badge-danger": this.severity === "danger"
        }
      ];
    }
  }
};
function render$8(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("span", mergeProps({ class: $options.badgeClass }, _ctx.ptm("root")), [
    renderSlot(_ctx.$slots, "default", {}, () => [
      createTextVNode(toDisplayString($props.value), 1)
    ])
  ], 16);
}
script$8.render = render$8;
const BadgeDirective = {
  mounted(el, options) {
    const id = UniqueComponentId() + "_badge";
    el.$_pbadgeId = id;
    let badge = document.createElement("span");
    badge.id = id;
    badge.className = "p-badge p-component";
    for (let modifier in options.modifiers) {
      DomHandler.addClass(badge, "p-badge-" + modifier);
    }
    if (options.value != null) {
      badge.appendChild(document.createTextNode(options.value));
      if (String(options.value).length === 1) {
        DomHandler.addClass(badge, "p-badge-no-gutter");
      }
    } else {
      DomHandler.addClass(badge, "p-badge-dot");
    }
    DomHandler.addClass(el, "p-overlay-badge");
    el.appendChild(badge);
  },
  updated(el, options) {
    DomHandler.addClass(el, "p-overlay-badge");
    if (options.oldValue !== options.value) {
      let badge = document.getElementById(el.$_pbadgeId);
      if (options.value) {
        if (DomHandler.hasClass(badge, "p-badge-dot")) {
          DomHandler.removeClass(badge, "p-badge-dot");
        }
        if (String(options.value).length === 1)
          DomHandler.addClass(badge, "p-badge-no-gutter");
        else
          DomHandler.removeClass(badge, "p-badge-no-gutter");
      } else if (!options.value && !DomHandler.hasClass(badge, "p-badge-dot")) {
        DomHandler.addClass(badge, "p-badge-dot");
      }
      badge.innerHTML = "";
      badge.appendChild(document.createTextNode(options.value));
    }
  }
};
var script$7 = {
  name: "WindowMaximizeIcon",
  extends: script$V
};
const _hoisted_1$4 = /* @__PURE__ */ createElementVNode("g", { "clip-path": "url(#clip0_414_20927)" }, [
  /* @__PURE__ */ createElementVNode("path", {
    "fill-rule": "evenodd",
    "clip-rule": "evenodd",
    d: "M7 14H11.8C12.3835 14 12.9431 13.7682 13.3556 13.3556C13.7682 12.9431 14 12.3835 14 11.8V2.2C14 1.61652 13.7682 1.05694 13.3556 0.644365C12.9431 0.231785 12.3835 0 11.8 0H2.2C1.61652 0 1.05694 0.231785 0.644365 0.644365C0.231785 1.05694 0 1.61652 0 2.2V7C0 7.15913 0.063214 7.31174 0.175736 7.42426C0.288258 7.53679 0.44087 7.6 0.6 7.6C0.75913 7.6 0.911742 7.53679 1.02426 7.42426C1.13679 7.31174 1.2 7.15913 1.2 7V2.2C1.2 1.93478 1.30536 1.68043 1.49289 1.49289C1.68043 1.30536 1.93478 1.2 2.2 1.2H11.8C12.0652 1.2 12.3196 1.30536 12.5071 1.49289C12.6946 1.68043 12.8 1.93478 12.8 2.2V11.8C12.8 12.0652 12.6946 12.3196 12.5071 12.5071C12.3196 12.6946 12.0652 12.8 11.8 12.8H7C6.84087 12.8 6.68826 12.8632 6.57574 12.9757C6.46321 13.0883 6.4 13.2409 6.4 13.4C6.4 13.5591 6.46321 13.7117 6.57574 13.8243C6.68826 13.9368 6.84087 14 7 14ZM9.77805 7.42192C9.89013 7.534 10.0415 7.59788 10.2 7.59995C10.3585 7.59788 10.5099 7.534 10.622 7.42192C10.7341 7.30985 10.798 7.15844 10.8 6.99995V3.94242C10.8066 3.90505 10.8096 3.86689 10.8089 3.82843C10.8079 3.77159 10.7988 3.7157 10.7824 3.6623C10.756 3.55552 10.701 3.45698 10.622 3.37798C10.5099 3.2659 10.3585 3.20202 10.2 3.19995H7.00002C6.84089 3.19995 6.68828 3.26317 6.57576 3.37569C6.46324 3.48821 6.40002 3.64082 6.40002 3.79995C6.40002 3.95908 6.46324 4.11169 6.57576 4.22422C6.68828 4.33674 6.84089 4.39995 7.00002 4.39995H8.80006L6.19997 7.00005C6.10158 7.11005 6.04718 7.25246 6.04718 7.40005C6.04718 7.54763 6.10158 7.69004 6.19997 7.80005C6.30202 7.91645 6.44561 7.98824 6.59997 8.00005C6.75432 7.98824 6.89791 7.91645 6.99997 7.80005L9.60002 5.26841V6.99995C9.6021 7.15844 9.66598 7.30985 9.77805 7.42192ZM1.4 14H3.8C4.17066 13.9979 4.52553 13.8498 4.78763 13.5877C5.04973 13.3256 5.1979 12.9707 5.2 12.6V10.2C5.1979 9.82939 5.04973 9.47452 4.78763 9.21242C4.52553 8.95032 4.17066 8.80215 3.8 8.80005H1.4C1.02934 8.80215 0.674468 8.95032 0.412371 9.21242C0.150274 9.47452 0.00210008 9.82939 0 10.2V12.6C0.00210008 12.9707 0.150274 13.3256 0.412371 13.5877C0.674468 13.8498 1.02934 13.9979 1.4 14ZM1.25858 10.0586C1.29609 10.0211 1.34696 10 1.4 10H3.8C3.85304 10 3.90391 10.0211 3.94142 10.0586C3.97893 10.0961 4 10.147 4 10.2V12.6C4 12.6531 3.97893 12.704 3.94142 12.7415C3.90391 12.779 3.85304 12.8 3.8 12.8H1.4C1.34696 12.8 1.29609 12.779 1.25858 12.7415C1.22107 12.704 1.2 12.6531 1.2 12.6V10.2C1.2 10.147 1.22107 10.0961 1.25858 10.0586Z",
    fill: "currentColor"
  })
], -1);
const _hoisted_2$3 = /* @__PURE__ */ createElementVNode("defs", null, [
  /* @__PURE__ */ createElementVNode("clipPath", { id: "clip0_414_20927" }, [
    /* @__PURE__ */ createElementVNode("rect", {
      width: "14",
      height: "14",
      fill: "white"
    })
  ])
], -1);
const _hoisted_3$2 = [
  _hoisted_1$4,
  _hoisted_2$3
];
function render$7(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("svg", mergeProps({
    width: "14",
    height: "14",
    viewBox: "0 0 14 14",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, _ctx.pti()), _hoisted_3$2, 16);
}
script$7.render = render$7;
var script$6 = {
  name: "WindowMinimizeIcon",
  extends: script$V
};
const _hoisted_1$3 = /* @__PURE__ */ createElementVNode("g", { "clip-path": "url(#clip0_414_20939)" }, [
  /* @__PURE__ */ createElementVNode("path", {
    "fill-rule": "evenodd",
    "clip-rule": "evenodd",
    d: "M11.8 0H2.2C1.61652 0 1.05694 0.231785 0.644365 0.644365C0.231785 1.05694 0 1.61652 0 2.2V7C0 7.15913 0.063214 7.31174 0.175736 7.42426C0.288258 7.53679 0.44087 7.6 0.6 7.6C0.75913 7.6 0.911742 7.53679 1.02426 7.42426C1.13679 7.31174 1.2 7.15913 1.2 7V2.2C1.2 1.93478 1.30536 1.68043 1.49289 1.49289C1.68043 1.30536 1.93478 1.2 2.2 1.2H11.8C12.0652 1.2 12.3196 1.30536 12.5071 1.49289C12.6946 1.68043 12.8 1.93478 12.8 2.2V11.8C12.8 12.0652 12.6946 12.3196 12.5071 12.5071C12.3196 12.6946 12.0652 12.8 11.8 12.8H7C6.84087 12.8 6.68826 12.8632 6.57574 12.9757C6.46321 13.0883 6.4 13.2409 6.4 13.4C6.4 13.5591 6.46321 13.7117 6.57574 13.8243C6.68826 13.9368 6.84087 14 7 14H11.8C12.3835 14 12.9431 13.7682 13.3556 13.3556C13.7682 12.9431 14 12.3835 14 11.8V2.2C14 1.61652 13.7682 1.05694 13.3556 0.644365C12.9431 0.231785 12.3835 0 11.8 0ZM6.368 7.952C6.44137 7.98326 6.52025 7.99958 6.6 8H9.8C9.95913 8 10.1117 7.93678 10.2243 7.82426C10.3368 7.71174 10.4 7.55913 10.4 7.4C10.4 7.24087 10.3368 7.08826 10.2243 6.97574C10.1117 6.86321 9.95913 6.8 9.8 6.8H8.048L10.624 4.224C10.73 4.11026 10.7877 3.95982 10.7849 3.80438C10.7822 3.64894 10.7192 3.50063 10.6093 3.3907C10.4994 3.28077 10.3511 3.2178 10.1956 3.21506C10.0402 3.21232 9.88974 3.27002 9.776 3.376L7.2 5.952V4.2C7.2 4.04087 7.13679 3.88826 7.02426 3.77574C6.91174 3.66321 6.75913 3.6 6.6 3.6C6.44087 3.6 6.28826 3.66321 6.17574 3.77574C6.06321 3.88826 6 4.04087 6 4.2V7.4C6.00042 7.47975 6.01674 7.55862 6.048 7.632C6.07656 7.70442 6.11971 7.7702 6.17475 7.82524C6.2298 7.88029 6.29558 7.92344 6.368 7.952ZM1.4 8.80005H3.8C4.17066 8.80215 4.52553 8.95032 4.78763 9.21242C5.04973 9.47452 5.1979 9.82939 5.2 10.2V12.6C5.1979 12.9707 5.04973 13.3256 4.78763 13.5877C4.52553 13.8498 4.17066 13.9979 3.8 14H1.4C1.02934 13.9979 0.674468 13.8498 0.412371 13.5877C0.150274 13.3256 0.00210008 12.9707 0 12.6V10.2C0.00210008 9.82939 0.150274 9.47452 0.412371 9.21242C0.674468 8.95032 1.02934 8.80215 1.4 8.80005ZM3.94142 12.7415C3.97893 12.704 4 12.6531 4 12.6V10.2C4 10.147 3.97893 10.0961 3.94142 10.0586C3.90391 10.0211 3.85304 10 3.8 10H1.4C1.34696 10 1.29609 10.0211 1.25858 10.0586C1.22107 10.0961 1.2 10.147 1.2 10.2V12.6C1.2 12.6531 1.22107 12.704 1.25858 12.7415C1.29609 12.779 1.34696 12.8 1.4 12.8H3.8C3.85304 12.8 3.90391 12.779 3.94142 12.7415Z",
    fill: "currentColor"
  })
], -1);
const _hoisted_2$2 = /* @__PURE__ */ createElementVNode("defs", null, [
  /* @__PURE__ */ createElementVNode("clipPath", { id: "clip0_414_20939" }, [
    /* @__PURE__ */ createElementVNode("rect", {
      width: "14",
      height: "14",
      fill: "white"
    })
  ])
], -1);
const _hoisted_3$1 = [
  _hoisted_1$3,
  _hoisted_2$2
];
function render$6(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("svg", mergeProps({
    width: "14",
    height: "14",
    viewBox: "0 0 14 14",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, _ctx.pti()), _hoisted_3$1, 16);
}
script$6.render = render$6;
var script$5 = {
  name: "Dialog",
  extends: script$W,
  inheritAttrs: false,
  emits: ["update:visible", "show", "hide", "after-hide", "maximize", "unmaximize", "dragend"],
  props: {
    header: {
      type: null,
      default: null
    },
    footer: {
      type: null,
      default: null
    },
    visible: {
      type: Boolean,
      default: false
    },
    modal: {
      type: Boolean,
      default: null
    },
    contentStyle: {
      type: null,
      default: null
    },
    contentClass: {
      type: String,
      default: null
    },
    contentProps: {
      type: null,
      default: null
    },
    rtl: {
      type: Boolean,
      default: null
    },
    maximizable: {
      type: Boolean,
      default: false
    },
    dismissableMask: {
      type: Boolean,
      default: false
    },
    closable: {
      type: Boolean,
      default: true
    },
    closeOnEscape: {
      type: Boolean,
      default: true
    },
    showHeader: {
      type: Boolean,
      default: true
    },
    baseZIndex: {
      type: Number,
      default: 0
    },
    autoZIndex: {
      type: Boolean,
      default: true
    },
    position: {
      type: String,
      default: "center"
    },
    breakpoints: {
      type: Object,
      default: null
    },
    draggable: {
      type: Boolean,
      default: true
    },
    keepInViewport: {
      type: Boolean,
      default: true
    },
    minX: {
      type: Number,
      default: 0
    },
    minY: {
      type: Number,
      default: 0
    },
    appendTo: {
      type: String,
      default: "body"
    },
    closeIcon: {
      type: String,
      default: void 0
    },
    maximizeIcon: {
      type: String,
      default: void 0
    },
    minimizeIcon: {
      type: String,
      default: void 0
    },
    closeButtonProps: {
      type: null,
      default: null
    },
    _instance: null
  },
  provide() {
    return {
      dialogRef: computed(() => this._instance)
    };
  },
  data() {
    return {
      containerVisible: this.visible,
      maximized: false,
      focusableMax: null,
      focusableClose: null
    };
  },
  documentKeydownListener: null,
  container: null,
  mask: null,
  content: null,
  headerContainer: null,
  footerContainer: null,
  maximizableButton: null,
  closeButton: null,
  styleElement: null,
  dragging: null,
  documentDragListener: null,
  documentDragEndListener: null,
  lastPageX: null,
  lastPageY: null,
  updated() {
    if (this.visible) {
      this.containerVisible = this.visible;
    }
  },
  beforeUnmount() {
    this.unbindDocumentState();
    this.unbindGlobalListeners();
    this.destroyStyle();
    if (this.mask && this.autoZIndex) {
      ZIndexUtils.clear(this.mask);
    }
    this.container = null;
    this.mask = null;
  },
  mounted() {
    if (this.breakpoints) {
      this.createStyle();
    }
  },
  methods: {
    close() {
      this.$emit("update:visible", false);
    },
    onBeforeEnter(el) {
      el.setAttribute(this.attributeSelector, "");
    },
    onEnter() {
      this.$emit("show");
      this.focus();
      this.enableDocumentSettings();
      this.bindGlobalListeners();
      if (this.autoZIndex) {
        ZIndexUtils.set("modal", this.mask, this.baseZIndex + this.$primevue.config.zIndex.modal);
      }
    },
    onBeforeLeave() {
      if (this.modal) {
        DomHandler.addClass(this.mask, "p-component-overlay-leave");
      }
    },
    onLeave() {
      this.$emit("hide");
      this.focusableClose = null;
      this.focusableMax = null;
    },
    onAfterLeave() {
      if (this.autoZIndex) {
        ZIndexUtils.clear(this.mask);
      }
      this.containerVisible = false;
      this.unbindDocumentState();
      this.unbindGlobalListeners();
      this.$emit("after-hide");
    },
    onMaskClick(event2) {
      if (this.dismissableMask && this.modal && this.mask === event2.target) {
        this.close();
      }
    },
    focus() {
      const findFocusableElement = (container) => {
        return container.querySelector("[autofocus]");
      };
      let focusTarget = this.$slots.footer && findFocusableElement(this.footerContainer);
      if (!focusTarget) {
        focusTarget = this.$slots.header && findFocusableElement(this.headerContainer);
        if (!focusTarget) {
          focusTarget = this.$slots.default && findFocusableElement(this.content);
          if (!focusTarget) {
            if (this.maximizable) {
              this.focusableMax = true;
              focusTarget = this.maximizableButton;
            } else {
              this.focusableClose = true;
              focusTarget = this.closeButton;
            }
          }
        }
      }
      if (focusTarget) {
        DomHandler.focus(focusTarget);
      }
    },
    maximize(event2) {
      if (this.maximized) {
        this.maximized = false;
        this.$emit("unmaximize", event2);
      } else {
        this.maximized = true;
        this.$emit("maximize", event2);
      }
      if (!this.modal) {
        if (this.maximized)
          DomHandler.addClass(document.body, "p-overflow-hidden");
        else
          DomHandler.removeClass(document.body, "p-overflow-hidden");
      }
    },
    enableDocumentSettings() {
      if (this.modal || this.maximizable && this.maximized) {
        DomHandler.addClass(document.body, "p-overflow-hidden");
      }
    },
    unbindDocumentState() {
      if (this.modal || this.maximizable && this.maximized) {
        DomHandler.removeClass(document.body, "p-overflow-hidden");
      }
    },
    onKeyDown(event2) {
      if (event2.code === "Escape" && this.closeOnEscape) {
        this.close();
      }
    },
    bindDocumentKeyDownListener() {
      if (!this.documentKeydownListener) {
        this.documentKeydownListener = this.onKeyDown.bind(this);
        window.document.addEventListener("keydown", this.documentKeydownListener);
      }
    },
    unbindDocumentKeyDownListener() {
      if (this.documentKeydownListener) {
        window.document.removeEventListener("keydown", this.documentKeydownListener);
        this.documentKeydownListener = null;
      }
    },
    getPositionClass() {
      const positions = ["left", "right", "top", "topleft", "topright", "bottom", "bottomleft", "bottomright"];
      const pos = positions.find((item) => item === this.position);
      return pos ? `p-dialog-${pos}` : "";
    },
    containerRef(el) {
      this.container = el;
    },
    maskRef(el) {
      this.mask = el;
    },
    contentRef(el) {
      this.content = el;
    },
    headerContainerRef(el) {
      this.headerContainer = el;
    },
    footerContainerRef(el) {
      this.footerContainer = el;
    },
    maximizableRef(el) {
      this.maximizableButton = el;
    },
    closeButtonRef(el) {
      this.closeButton = el;
    },
    createStyle() {
      if (!this.styleElement) {
        this.styleElement = document.createElement("style");
        this.styleElement.type = "text/css";
        document.head.appendChild(this.styleElement);
        let innerHTML = "";
        for (let breakpoint in this.breakpoints) {
          innerHTML += `
                        @media screen and (max-width: ${breakpoint}) {
                            .p-dialog[${this.attributeSelector}] {
                                width: ${this.breakpoints[breakpoint]} !important;
                            }
                        }
                    `;
        }
        this.styleElement.innerHTML = innerHTML;
      }
    },
    destroyStyle() {
      if (this.styleElement) {
        document.head.removeChild(this.styleElement);
        this.styleElement = null;
      }
    },
    initDrag(event2) {
      if (DomHandler.hasClass(event2.target, "p-dialog-header-icon") || DomHandler.hasClass(event2.target.parentElement, "p-dialog-header-icon")) {
        return;
      }
      if (this.draggable) {
        this.dragging = true;
        this.lastPageX = event2.pageX;
        this.lastPageY = event2.pageY;
        this.container.style.margin = "0";
        DomHandler.addClass(document.body, "p-unselectable-text");
      }
    },
    bindGlobalListeners() {
      if (this.draggable) {
        this.bindDocumentDragListener();
        this.bindDocumentDragEndListener();
      }
      if (this.closeOnEscape && this.closable) {
        this.bindDocumentKeyDownListener();
      }
    },
    unbindGlobalListeners() {
      this.unbindDocumentDragListener();
      this.unbindDocumentDragEndListener();
      this.unbindDocumentKeyDownListener();
    },
    bindDocumentDragListener() {
      this.documentDragListener = (event2) => {
        if (this.dragging) {
          let width = DomHandler.getOuterWidth(this.container);
          let height = DomHandler.getOuterHeight(this.container);
          let deltaX = event2.pageX - this.lastPageX;
          let deltaY = event2.pageY - this.lastPageY;
          let offset = this.container.getBoundingClientRect();
          let leftPos = offset.left + deltaX;
          let topPos = offset.top + deltaY;
          let viewport = DomHandler.getViewport();
          this.container.style.position = "fixed";
          if (this.keepInViewport) {
            if (leftPos >= this.minX && leftPos + width < viewport.width) {
              this.lastPageX = event2.pageX;
              this.container.style.left = leftPos + "px";
            }
            if (topPos >= this.minY && topPos + height < viewport.height) {
              this.lastPageY = event2.pageY;
              this.container.style.top = topPos + "px";
            }
          } else {
            this.lastPageX = event2.pageX;
            this.container.style.left = leftPos + "px";
            this.lastPageY = event2.pageY;
            this.container.style.top = topPos + "px";
          }
        }
      };
      window.document.addEventListener("mousemove", this.documentDragListener);
    },
    unbindDocumentDragListener() {
      if (this.documentDragListener) {
        window.document.removeEventListener("mousemove", this.documentDragListener);
        this.documentDragListener = null;
      }
    },
    bindDocumentDragEndListener() {
      this.documentDragEndListener = (event2) => {
        if (this.dragging) {
          this.dragging = false;
          DomHandler.removeClass(document.body, "p-unselectable-text");
          this.$emit("dragend", event2);
        }
      };
      window.document.addEventListener("mouseup", this.documentDragEndListener);
    },
    unbindDocumentDragEndListener() {
      if (this.documentDragEndListener) {
        window.document.removeEventListener("mouseup", this.documentDragEndListener);
        this.documentDragEndListener = null;
      }
    }
  },
  computed: {
    maskClass() {
      return ["p-dialog-mask", { "p-component-overlay p-component-overlay-enter": this.modal }, this.getPositionClass()];
    },
    dialogClass() {
      return [
        "p-dialog p-component",
        {
          "p-dialog-rtl": this.rtl,
          "p-dialog-maximized": this.maximizable && this.maximized,
          "p-input-filled": this.$primevue.config.inputStyle === "filled",
          "p-ripple-disabled": this.$primevue.config.ripple === false
        }
      ];
    },
    maximizeIconComponent() {
      return this.maximized ? this.minimizeIcon ? "span" : "WindowMinimizeIcon" : this.maximizeIcon ? "span" : "WindowMaximizeIcon";
    },
    maximizeIconClass() {
      const maximizeClasses = this.maximized ? this.minimizeIcon : this.maximizeIcon;
      return `p-dialog-header-maximize-icon ${maximizeClasses}`;
    },
    ariaId() {
      return UniqueComponentId();
    },
    ariaLabelledById() {
      return this.header != null || this.$attrs["aria-labelledby"] !== null ? this.ariaId + "_header" : null;
    },
    closeAriaLabel() {
      return this.$primevue.config.locale.aria ? this.$primevue.config.locale.aria.close : void 0;
    },
    attributeSelector() {
      return UniqueComponentId();
    },
    contentStyleClass() {
      return ["p-dialog-content", this.contentClass];
    }
  },
  directives: {
    ripple: Ripple,
    focustrap: FocusTrap
  },
  components: {
    Portal: script$Q,
    WindowMinimizeIcon: script$6,
    WindowMaximizeIcon: script$7,
    TimesIcon: script$E
  }
};
const _hoisted_1$2 = ["aria-labelledby", "aria-modal"];
const _hoisted_2$1 = ["id"];
const _hoisted_3 = ["autofocus", "tabindex"];
const _hoisted_4 = ["autofocus", "aria-label"];
function render$5(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_Portal = resolveComponent("Portal");
  const _directive_ripple = resolveDirective("ripple");
  const _directive_focustrap = resolveDirective("focustrap");
  return openBlock(), createBlock(_component_Portal, { appendTo: $props.appendTo }, {
    default: withCtx(() => [
      $data.containerVisible ? (openBlock(), createElementBlock("div", mergeProps({
        key: 0,
        ref: $options.maskRef,
        class: $options.maskClass,
        onClick: _cache[3] || (_cache[3] = (...args) => $options.onMaskClick && $options.onMaskClick(...args))
      }, _ctx.ptm("mask")), [
        createVNode(Transition, {
          name: "p-dialog",
          onBeforeEnter: $options.onBeforeEnter,
          onEnter: $options.onEnter,
          onBeforeLeave: $options.onBeforeLeave,
          onLeave: $options.onLeave,
          onAfterLeave: $options.onAfterLeave,
          appear: ""
        }, {
          default: withCtx(() => [
            $props.visible ? withDirectives((openBlock(), createElementBlock("div", mergeProps({
              key: 0,
              ref: $options.containerRef,
              class: $options.dialogClass,
              role: "dialog",
              "aria-labelledby": $options.ariaLabelledById,
              "aria-modal": $props.modal
            }, { ..._ctx.$attrs, ..._ctx.ptm("root") }), [
              $props.showHeader ? (openBlock(), createElementBlock("div", mergeProps({
                key: 0,
                ref: $options.headerContainerRef,
                class: "p-dialog-header",
                onMousedown: _cache[2] || (_cache[2] = (...args) => $options.initDrag && $options.initDrag(...args))
              }, _ctx.ptm("header")), [
                renderSlot(_ctx.$slots, "header", {}, () => [
                  $props.header ? (openBlock(), createElementBlock("span", mergeProps({
                    key: 0,
                    id: $options.ariaLabelledById,
                    class: "p-dialog-title"
                  }, _ctx.ptm("headerTitle")), toDisplayString($props.header), 17, _hoisted_2$1)) : createCommentVNode("", true)
                ]),
                createElementVNode("div", mergeProps({ class: "p-dialog-header-icons" }, _ctx.ptm("headerIcons")), [
                  $props.maximizable ? withDirectives((openBlock(), createElementBlock("button", mergeProps({
                    key: 0,
                    ref: $options.maximizableRef,
                    autofocus: $data.focusableMax,
                    class: "p-dialog-header-icon p-dialog-header-maximize p-link",
                    onClick: _cache[0] || (_cache[0] = (...args) => $options.maximize && $options.maximize(...args)),
                    type: "button",
                    tabindex: $props.maximizable ? "0" : "-1"
                  }, _ctx.ptm("maximizableButton")), [
                    renderSlot(_ctx.$slots, "maximizeicon", { maximized: $data.maximized }, () => [
                      (openBlock(), createBlock(resolveDynamicComponent($options.maximizeIconComponent), mergeProps({ class: $options.maximizeIconClass }, _ctx.ptm("maximizableIcon")), null, 16, ["class"]))
                    ])
                  ], 16, _hoisted_3)), [
                    [_directive_ripple]
                  ]) : createCommentVNode("", true),
                  $props.closable ? withDirectives((openBlock(), createElementBlock("button", mergeProps({
                    key: 1,
                    ref: $options.closeButtonRef,
                    autofocus: $data.focusableClose,
                    class: "p-dialog-header-icon p-dialog-header-close p-link",
                    onClick: _cache[1] || (_cache[1] = (...args) => $options.close && $options.close(...args)),
                    "aria-label": $options.closeAriaLabel,
                    type: "button"
                  }, { ...$props.closeButtonProps, ..._ctx.ptm("closeButton") }), [
                    renderSlot(_ctx.$slots, "closeicon", {}, () => [
                      (openBlock(), createBlock(resolveDynamicComponent($props.closeIcon ? "span" : "TimesIcon"), mergeProps({
                        class: ["p-dialog-header-close-icon", $props.closeIcon]
                      }, _ctx.ptm("closeButtonIcon")), null, 16, ["class"]))
                    ])
                  ], 16, _hoisted_4)), [
                    [_directive_ripple]
                  ]) : createCommentVNode("", true)
                ], 16)
              ], 16)) : createCommentVNode("", true),
              createElementVNode("div", mergeProps({
                ref: $options.contentRef,
                class: $options.contentStyleClass,
                style: $props.contentStyle
              }, { ...$props.contentProps, ..._ctx.ptm("content") }), [
                renderSlot(_ctx.$slots, "default")
              ], 16),
              $props.footer || _ctx.$slots.footer ? (openBlock(), createElementBlock("div", mergeProps({
                key: 1,
                ref: $options.footerContainerRef,
                class: "p-dialog-footer"
              }, _ctx.ptm("footer")), [
                renderSlot(_ctx.$slots, "footer", {}, () => [
                  createTextVNode(toDisplayString($props.footer), 1)
                ])
              ], 16)) : createCommentVNode("", true)
            ], 16, _hoisted_1$2)), [
              [_directive_focustrap, { disabled: !$props.modal }]
            ]) : createCommentVNode("", true)
          ]),
          _: 3
        }, 8, ["onBeforeEnter", "onEnter", "onBeforeLeave", "onLeave", "onAfterLeave"])
      ], 16)) : createCommentVNode("", true)
    ]),
    _: 3
  }, 8, ["appendTo"]);
}
function styleInject$3(css, ref2) {
  if (ref2 === void 0)
    ref2 = {};
  var insertAt = ref2.insertAt;
  if (!css || true) {
    return;
  }
  var head = document.head || document.getElementsByTagName("head")[0];
  var style = document.createElement("style");
  style.type = "text/css";
  if (insertAt === "top") {
    if (head.firstChild) {
      head.insertBefore(style, head.firstChild);
    } else {
      head.appendChild(style);
    }
  } else {
    head.appendChild(style);
  }
  if (style.styleSheet) {
    style.styleSheet.cssText = css;
  } else {
    style.appendChild(document.createTextNode(css));
  }
}
var css_248z$3 = "\n.p-dialog-mask {\n    position: fixed;\n    top: 0;\n    left: 0;\n    width: 100%;\n    height: 100%;\n    display: flex;\n    justify-content: center;\n    align-items: center;\n    pointer-events: none;\n}\n.p-dialog-mask.p-component-overlay {\n    pointer-events: auto;\n}\n.p-dialog {\n    display: flex;\n    flex-direction: column;\n    pointer-events: auto;\n    max-height: 90%;\n    transform: scale(1);\n}\n.p-dialog-content {\n    overflow-y: auto;\n}\n.p-dialog-header {\n    display: flex;\n    align-items: center;\n    justify-content: space-between;\n    flex-shrink: 0;\n}\n.p-dialog-footer {\n    flex-shrink: 0;\n}\n.p-dialog .p-dialog-header-icons {\n    display: flex;\n    align-items: center;\n}\n.p-dialog .p-dialog-header-icon {\n    display: flex;\n    align-items: center;\n    justify-content: center;\n    overflow: hidden;\n    position: relative;\n}\n\n/* Fluid */\n.p-fluid .p-dialog-footer .p-button {\n    width: auto;\n}\n\n/* Animation */\n/* Center */\n.p-dialog-enter-active {\n    transition: all 150ms cubic-bezier(0, 0, 0.2, 1);\n}\n.p-dialog-leave-active {\n    transition: all 150ms cubic-bezier(0.4, 0, 0.2, 1);\n}\n.p-dialog-enter-from,\n.p-dialog-leave-to {\n    opacity: 0;\n    transform: scale(0.7);\n}\n\n/* Top, Bottom, Left, Right, Top* and Bottom* */\n.p-dialog-top .p-dialog,\n.p-dialog-bottom .p-dialog,\n.p-dialog-left .p-dialog,\n.p-dialog-right .p-dialog,\n.p-dialog-topleft .p-dialog,\n.p-dialog-topright .p-dialog,\n.p-dialog-bottomleft .p-dialog,\n.p-dialog-bottomright .p-dialog {\n    margin: 0.75rem;\n    transform: translate3d(0px, 0px, 0px);\n}\n.p-dialog-top .p-dialog-enter-active,\n.p-dialog-top .p-dialog-leave-active,\n.p-dialog-bottom .p-dialog-enter-active,\n.p-dialog-bottom .p-dialog-leave-active,\n.p-dialog-left .p-dialog-enter-active,\n.p-dialog-left .p-dialog-leave-active,\n.p-dialog-right .p-dialog-enter-active,\n.p-dialog-right .p-dialog-leave-active,\n.p-dialog-topleft .p-dialog-enter-active,\n.p-dialog-topleft .p-dialog-leave-active,\n.p-dialog-topright .p-dialog-enter-active,\n.p-dialog-topright .p-dialog-leave-active,\n.p-dialog-bottomleft .p-dialog-enter-active,\n.p-dialog-bottomleft .p-dialog-leave-active,\n.p-dialog-bottomright .p-dialog-enter-active,\n.p-dialog-bottomright .p-dialog-leave-active {\n    transition: all 0.3s ease-out;\n}\n.p-dialog-top .p-dialog-enter-from,\n.p-dialog-top .p-dialog-leave-to {\n    transform: translate3d(0px, -100%, 0px);\n}\n.p-dialog-bottom .p-dialog-enter-from,\n.p-dialog-bottom .p-dialog-leave-to {\n    transform: translate3d(0px, 100%, 0px);\n}\n.p-dialog-left .p-dialog-enter-from,\n.p-dialog-left .p-dialog-leave-to,\n.p-dialog-topleft .p-dialog-enter-from,\n.p-dialog-topleft .p-dialog-leave-to,\n.p-dialog-bottomleft .p-dialog-enter-from,\n.p-dialog-bottomleft .p-dialog-leave-to {\n    transform: translate3d(-100%, 0px, 0px);\n}\n.p-dialog-right .p-dialog-enter-from,\n.p-dialog-right .p-dialog-leave-to,\n.p-dialog-topright .p-dialog-enter-from,\n.p-dialog-topright .p-dialog-leave-to,\n.p-dialog-bottomright .p-dialog-enter-from,\n.p-dialog-bottomright .p-dialog-leave-to {\n    transform: translate3d(100%, 0px, 0px);\n}\n\n/* Maximize */\n.p-dialog-maximized {\n    -webkit-transition: none;\n    transition: none;\n    transform: none;\n    width: 100vw !important;\n    height: 100vh !important;\n    top: 0px !important;\n    left: 0px !important;\n    max-height: 100%;\n    height: 100%;\n}\n.p-dialog-maximized .p-dialog-content {\n    flex-grow: 1;\n}\n\n/* Position */\n.p-dialog-left {\n    justify-content: flex-start;\n}\n.p-dialog-right {\n    justify-content: flex-end;\n}\n.p-dialog-top {\n    align-items: flex-start;\n}\n.p-dialog-topleft {\n    justify-content: flex-start;\n    align-items: flex-start;\n}\n.p-dialog-topright {\n    justify-content: flex-end;\n    align-items: flex-start;\n}\n.p-dialog-bottom {\n    align-items: flex-end;\n}\n.p-dialog-bottomleft {\n    justify-content: flex-start;\n    align-items: flex-end;\n}\n.p-dialog-bottomright {\n    justify-content: flex-end;\n    align-items: flex-end;\n}\n.p-confirm-dialog .p-dialog-content {\n    display: flex;\n    align-items: center;\n}\n";
styleInject$3(css_248z$3);
script$5.render = render$5;
var script$4 = {
  name: "Chip",
  extends: script$W,
  emits: ["remove"],
  props: {
    label: {
      type: String,
      default: null
    },
    icon: {
      type: String,
      default: null
    },
    image: {
      type: String,
      default: null
    },
    removable: {
      type: Boolean,
      default: false
    },
    removeIcon: {
      type: String,
      default: void 0
    }
  },
  data() {
    return {
      visible: true
    };
  },
  methods: {
    onKeydown(event2) {
      if (event2.key === "Enter" || event2.key === "Backspace") {
        this.close(event2);
      }
    },
    close(event2) {
      this.visible = false;
      this.$emit("remove", event2);
    }
  },
  computed: {
    containerClass() {
      return [
        "p-chip p-component",
        {
          "p-chip-image": this.image != null
        }
      ];
    }
  },
  components: {
    TimesCircleIcon: script$R
  }
};
const _hoisted_1$1 = ["aria-label"];
const _hoisted_2 = ["src"];
function render$4(_ctx, _cache, $props, $setup, $data, $options) {
  return $data.visible ? (openBlock(), createElementBlock("div", mergeProps({
    key: 0,
    class: $options.containerClass,
    "aria-label": $props.label
  }, _ctx.ptm("root")), [
    renderSlot(_ctx.$slots, "default", {}, () => [
      $props.image ? (openBlock(), createElementBlock("img", mergeProps({
        key: 0,
        src: $props.image
      }, _ctx.ptm("image")), null, 16, _hoisted_2)) : _ctx.$slots.icon ? (openBlock(), createBlock(resolveDynamicComponent(_ctx.$slots.icon), mergeProps({
        key: 1,
        class: "p-chip-icon"
      }, _ctx.ptm("icon")), null, 16)) : $props.icon ? (openBlock(), createElementBlock("span", mergeProps({
        key: 2,
        class: ["p-chip-icon", $props.icon]
      }, _ctx.ptm("icon")), null, 16)) : createCommentVNode("", true),
      $props.label ? (openBlock(), createElementBlock("div", mergeProps({
        key: 3,
        class: "p-chip-text"
      }, _ctx.ptm("label")), toDisplayString($props.label), 17)) : createCommentVNode("", true)
    ]),
    $props.removable ? renderSlot(_ctx.$slots, "removeicon", {
      key: 0,
      onClick: $options.close,
      onKeydown: $options.onKeydown
    }, () => [
      (openBlock(), createBlock(resolveDynamicComponent($props.removeIcon ? "span" : "TimesCircleIcon"), mergeProps({
        tabindex: "0",
        class: ["p-chip-remove-icon", $props.removeIcon],
        onClick: $options.close,
        onKeydown: $options.onKeydown
      }, _ctx.ptm("removeIcon")), null, 16, ["class", "onClick", "onKeydown"]))
    ]) : createCommentVNode("", true)
  ], 16, _hoisted_1$1)) : createCommentVNode("", true);
}
function styleInject$2(css, ref2) {
  if (ref2 === void 0)
    ref2 = {};
  var insertAt = ref2.insertAt;
  if (!css || true) {
    return;
  }
  var head = document.head || document.getElementsByTagName("head")[0];
  var style = document.createElement("style");
  style.type = "text/css";
  if (insertAt === "top") {
    if (head.firstChild) {
      head.insertBefore(style, head.firstChild);
    } else {
      head.appendChild(style);
    }
  } else {
    head.appendChild(style);
  }
  if (style.styleSheet) {
    style.styleSheet.cssText = css;
  } else {
    style.appendChild(document.createTextNode(css));
  }
}
var css_248z$2 = "\n.p-chip {\n    display: inline-flex;\n    align-items: center;\n}\n.p-chip-text {\n    line-height: 1.5;\n}\n.p-chip-icon.pi {\n    line-height: 1.5;\n}\n.p-chip-remove-icon {\n    line-height: 1.5;\n    cursor: pointer;\n}\n.p-chip img {\n    border-radius: 50%;\n}\n";
styleInject$2(css_248z$2);
script$4.render = render$4;
var script$3 = {
  name: "Tag",
  extends: script$W,
  props: {
    value: null,
    severity: null,
    rounded: Boolean,
    icon: String
  },
  computed: {
    containerClass() {
      return [
        "p-tag p-component",
        {
          "p-tag-info": this.severity === "info",
          "p-tag-success": this.severity === "success",
          "p-tag-warning": this.severity === "warning",
          "p-tag-danger": this.severity === "danger",
          "p-tag-rounded": this.rounded
        }
      ];
    },
    iconClass() {
      return ["p-tag-icon", this.icon];
    }
  }
};
function render$3(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("span", mergeProps({ class: $options.containerClass }, _ctx.ptm("root")), [
    _ctx.$slots.icon ? (openBlock(), createBlock(resolveDynamicComponent(_ctx.$slots.icon), mergeProps({
      key: 0,
      class: "p-tag-icon"
    }, _ctx.ptm("icon")), null, 16)) : $props.icon ? (openBlock(), createElementBlock("span", mergeProps({
      key: 1,
      class: $options.iconClass
    }, _ctx.ptm("icon")), null, 16)) : createCommentVNode("", true),
    renderSlot(_ctx.$slots, "default", {}, () => [
      createElementVNode("span", mergeProps({ class: "p-tag-value" }, _ctx.ptm("value")), toDisplayString($props.value), 17)
    ])
  ], 16);
}
function styleInject$1(css, ref2) {
  if (ref2 === void 0)
    ref2 = {};
  var insertAt = ref2.insertAt;
  if (!css || true) {
    return;
  }
  var head = document.head || document.getElementsByTagName("head")[0];
  var style = document.createElement("style");
  style.type = "text/css";
  if (insertAt === "top") {
    if (head.firstChild) {
      head.insertBefore(style, head.firstChild);
    } else {
      head.appendChild(style);
    }
  } else {
    head.appendChild(style);
  }
  if (style.styleSheet) {
    style.styleSheet.cssText = css;
  } else {
    style.appendChild(document.createTextNode(css));
  }
}
var css_248z$1 = "\n.p-tag {\n    display: inline-flex;\n    align-items: center;\n    justify-content: center;\n}\n.p-tag-icon,\n.p-tag-value,\n.p-tag-icon.pi {\n    line-height: 1.5;\n}\n.p-tag.p-tag-rounded {\n    border-radius: 10rem;\n}\n";
styleInject$1(css_248z$1);
script$3.render = render$3;
var script$2 = {
  name: "Skeleton",
  extends: script$W,
  props: {
    shape: {
      type: String,
      default: "rectangle"
    },
    size: {
      type: String,
      default: null
    },
    width: {
      type: String,
      default: "100%"
    },
    height: {
      type: String,
      default: "1rem"
    },
    borderRadius: {
      type: String,
      default: null
    },
    animation: {
      type: String,
      default: "wave"
    }
  },
  computed: {
    containerClass() {
      return [
        "p-skeleton p-component",
        {
          "p-skeleton-circle": this.shape === "circle",
          "p-skeleton-none": this.animation === "none"
        }
      ];
    },
    containerStyle() {
      if (this.size)
        return { width: this.size, height: this.size, borderRadius: this.borderRadius };
      else
        return { width: this.width, height: this.height, borderRadius: this.borderRadius };
    }
  }
};
function render$2(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("div", mergeProps({
    style: $options.containerStyle,
    class: $options.containerClass,
    "aria-hidden": "true"
  }, _ctx.ptm("root")), null, 16);
}
function styleInject(css, ref2) {
  if (ref2 === void 0)
    ref2 = {};
  var insertAt = ref2.insertAt;
  if (!css || true) {
    return;
  }
  var head = document.head || document.getElementsByTagName("head")[0];
  var style = document.createElement("style");
  style.type = "text/css";
  if (insertAt === "top") {
    if (head.firstChild) {
      head.insertBefore(style, head.firstChild);
    } else {
      head.appendChild(style);
    }
  } else {
    head.appendChild(style);
  }
  if (style.styleSheet) {
    style.styleSheet.cssText = css;
  } else {
    style.appendChild(document.createTextNode(css));
  }
}
var css_248z = "\n.p-skeleton {\n    position: relative;\n    overflow: hidden;\n}\n.p-skeleton::after {\n    content: '';\n    animation: p-skeleton-animation 1.2s infinite;\n    height: 100%;\n    left: 0;\n    position: absolute;\n    right: 0;\n    top: 0;\n    transform: translateX(-100%);\n    z-index: 1;\n}\n.p-skeleton.p-skeleton-circle {\n    border-radius: 50%;\n}\n.p-skeleton-none::after {\n    animation: none;\n}\n@keyframes p-skeleton-animation {\nfrom {\n        transform: translateX(-100%);\n}\nto {\n        transform: translateX(100%);\n}\n}\n";
styleInject(css_248z);
script$2.render = render$2;
var script$1 = {
  name: "RadioButton",
  extends: script$W,
  emits: ["click", "update:modelValue", "change", "focus", "blur"],
  props: {
    value: null,
    modelValue: null,
    name: {
      type: String,
      default: null
    },
    disabled: {
      type: Boolean,
      default: false
    },
    inputId: {
      type: String,
      default: null
    },
    inputClass: {
      type: [String, Object],
      default: null
    },
    inputStyle: {
      type: Object,
      default: null
    },
    inputProps: {
      type: null,
      default: null
    },
    "aria-labelledby": {
      type: String,
      default: null
    },
    "aria-label": {
      type: String,
      default: null
    }
  },
  data() {
    return {
      focused: false
    };
  },
  methods: {
    onClick(event2) {
      if (!this.disabled) {
        this.$emit("click", event2);
        this.$emit("update:modelValue", this.value);
        this.$refs.input.focus();
        if (!this.checked) {
          this.$emit("change", event2);
        }
      }
    },
    onFocus(event2) {
      this.focused = true;
      this.$emit("focus", event2);
    },
    onBlur(event2) {
      this.focused = false;
      this.$emit("blur", event2);
    }
  },
  computed: {
    checked() {
      return this.modelValue != null && ObjectUtils.equals(this.modelValue, this.value);
    },
    containerClass() {
      return [
        "p-radiobutton p-component",
        {
          "p-radiobutton-checked": this.checked,
          "p-radiobutton-disabled": this.disabled,
          "p-radiobutton-focused": this.focused
        }
      ];
    }
  }
};
const _hoisted_1 = ["id", "name", "checked", "disabled", "value", "aria-labelledby", "aria-label"];
function render$1(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("div", mergeProps({
    class: $options.containerClass,
    onClick: _cache[2] || (_cache[2] = ($event) => $options.onClick($event))
  }, _ctx.ptm("root")), [
    createElementVNode("div", mergeProps({ class: "p-hidden-accessible" }, _ctx.ptm("hiddenInputWrapper")), [
      createElementVNode("input", mergeProps({
        ref: "input",
        id: $props.inputId,
        type: "radio",
        class: $props.inputClass,
        style: $props.inputStyle,
        name: $props.name,
        checked: $options.checked,
        disabled: $props.disabled,
        value: $props.value,
        "aria-labelledby": _ctx.ariaLabelledby,
        "aria-label": _ctx.ariaLabel,
        onFocus: _cache[0] || (_cache[0] = (...args) => $options.onFocus && $options.onFocus(...args)),
        onBlur: _cache[1] || (_cache[1] = (...args) => $options.onBlur && $options.onBlur(...args))
      }, _ctx.ptm("hiddenInput")), null, 16, _hoisted_1)
    ], 16),
    createElementVNode("div", mergeProps({
      ref: "box",
      class: ["p-radiobutton-box", { "p-highlight": $options.checked, "p-disabled": $props.disabled, "p-focus": $data.focused }]
    }, { ...$props.inputProps, ..._ctx.ptm("input") }), [
      createElementVNode("div", mergeProps({ class: "p-radiobutton-icon" }, _ctx.ptm("icon")), null, 16)
    ], 16)
  ], 16);
}
script$1.render = render$1;
var ConfirmationEventBus = primebus();
var script = {
  name: "ConfirmDialog",
  extends: script$W,
  props: {
    group: String,
    breakpoints: {
      type: Object,
      default: null
    },
    draggable: {
      type: Boolean,
      default: true
    }
  },
  confirmListener: null,
  closeListener: null,
  data() {
    return {
      visible: false,
      confirmation: null
    };
  },
  mounted() {
    this.confirmListener = (options) => {
      if (!options) {
        return;
      }
      if (options.group === this.group) {
        this.confirmation = options;
        if (this.confirmation.onShow) {
          this.confirmation.onShow();
        }
        this.visible = true;
      }
    };
    this.closeListener = () => {
      this.visible = false;
      this.confirmation = null;
    };
    ConfirmationEventBus.on("confirm", this.confirmListener);
    ConfirmationEventBus.on("close", this.closeListener);
  },
  beforeUnmount() {
    ConfirmationEventBus.off("confirm", this.confirmListener);
    ConfirmationEventBus.off("close", this.closeListener);
  },
  methods: {
    accept() {
      if (this.confirmation.accept) {
        this.confirmation.accept();
      }
      this.visible = false;
    },
    reject() {
      if (this.confirmation.reject) {
        this.confirmation.reject();
      }
      this.visible = false;
    },
    onHide() {
      if (this.confirmation.onHide) {
        this.confirmation.onHide();
      }
      this.visible = false;
    }
  },
  computed: {
    header() {
      return this.confirmation ? this.confirmation.header : null;
    },
    message() {
      return this.confirmation ? this.confirmation.message : null;
    },
    blockScroll() {
      return this.confirmation ? this.confirmation.blockScroll : true;
    },
    position() {
      return this.confirmation ? this.confirmation.position : null;
    },
    iconClass() {
      return ["p-confirm-dialog-icon", this.confirmation ? this.confirmation.icon : null];
    },
    acceptLabel() {
      return this.confirmation ? this.confirmation.acceptLabel || this.$primevue.config.locale.accept : null;
    },
    rejectLabel() {
      return this.confirmation ? this.confirmation.rejectLabel || this.$primevue.config.locale.reject : null;
    },
    acceptIcon() {
      return this.confirmation ? this.confirmation.acceptIcon : null;
    },
    rejectIcon() {
      return this.confirmation ? this.confirmation.rejectIcon : null;
    },
    acceptClass() {
      return ["p-confirm-dialog-accept", this.confirmation ? this.confirmation.acceptClass : null];
    },
    rejectClass() {
      return ["p-confirm-dialog-reject", this.confirmation ? this.confirmation.rejectClass || "p-button-text" : null];
    },
    autoFocusAccept() {
      return this.confirmation.defaultFocus === void 0 || this.confirmation.defaultFocus === "accept" ? true : false;
    },
    autoFocusReject() {
      return this.confirmation.defaultFocus === "reject" ? true : false;
    },
    closeOnEscape() {
      return this.confirmation ? this.confirmation.closeOnEscape : true;
    }
  },
  components: {
    CDialog: script$5,
    CDButton: script$T
  }
};
function render(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_CDButton = resolveComponent("CDButton");
  const _component_CDialog = resolveComponent("CDialog");
  return openBlock(), createBlock(_component_CDialog, {
    visible: $data.visible,
    "onUpdate:visible": [
      _cache[2] || (_cache[2] = ($event) => $data.visible = $event),
      $options.onHide
    ],
    role: "alertdialog",
    class: "p-confirm-dialog",
    modal: true,
    header: $options.header,
    blockScroll: $options.blockScroll,
    position: $options.position,
    breakpoints: $props.breakpoints,
    closeOnEscape: $options.closeOnEscape,
    draggable: $props.draggable,
    pt: _ctx.pt
  }, {
    footer: withCtx(() => [
      createVNode(_component_CDButton, {
        label: $options.rejectLabel,
        class: normalizeClass($options.rejectClass),
        iconPos: "left",
        onClick: _cache[0] || (_cache[0] = ($event) => $options.reject()),
        autofocus: $options.autoFocusReject,
        pt: _ctx.ptm("rejectButton")
      }, {
        icon: withCtx((iconProps) => [
          renderSlot(_ctx.$slots, "rejecticon", {}, () => [
            createElementVNode("span", mergeProps({
              class: [$options.rejectIcon, iconProps.class]
            }, _ctx.ptm("rejectButton")["icon"]), null, 16)
          ])
        ]),
        _: 3
      }, 8, ["label", "class", "autofocus", "pt"]),
      createVNode(_component_CDButton, {
        label: $options.acceptLabel,
        class: normalizeClass($options.acceptClass),
        iconPos: "left",
        onClick: _cache[1] || (_cache[1] = ($event) => $options.accept()),
        autofocus: $options.autoFocusAccept,
        pt: _ctx.ptm("acceptButton")
      }, {
        icon: withCtx((iconProps) => [
          renderSlot(_ctx.$slots, "accepticon", {}, () => [
            createElementVNode("span", mergeProps({
              class: [$options.acceptIcon, iconProps.class]
            }, _ctx.ptm("acceptButton")["icon"]), null, 16)
          ])
        ]),
        _: 3
      }, 8, ["label", "class", "autofocus", "pt"])
    ]),
    default: withCtx(() => [
      !_ctx.$slots.message ? (openBlock(), createElementBlock(Fragment, { key: 0 }, [
        renderSlot(_ctx.$slots, "icon", { class: "p-confirm-dialog-icon" }, () => [
          _ctx.$slots.icon ? (openBlock(), createBlock(resolveDynamicComponent(_ctx.$slots.icon), {
            key: 0,
            class: "p-confirm-dialog-icon"
          })) : $data.confirmation.icon ? (openBlock(), createElementBlock("span", mergeProps({
            key: 1,
            class: $options.iconClass
          }, _ctx.ptm("icon")), null, 16)) : createCommentVNode("", true)
        ]),
        createElementVNode("span", mergeProps({ class: "p-confirm-dialog-message" }, _ctx.ptm("message")), toDisplayString($options.message), 17)
      ], 64)) : (openBlock(), createBlock(resolveDynamicComponent(_ctx.$slots.message), {
        key: 1,
        message: $data.confirmation
      }, null, 8, ["message"]))
    ]),
    _: 3
  }, 8, ["visible", "header", "blockScroll", "position", "breakpoints", "closeOnEscape", "draggable", "onUpdate:visible", "pt"]);
}
script.render = render;
const PrimeVueConfirmSymbol = Symbol();
function useConfirm() {
  const PrimeVueConfirm = inject(PrimeVueConfirmSymbol);
  if (!PrimeVueConfirm) {
    throw new Error("No PrimeVue Confirmation provided!");
  }
  return PrimeVueConfirm;
}
var ConfirmationService = {
  install: (app) => {
    const ConfirmationService2 = {
      require: (options) => {
        ConfirmationEventBus.emit("confirm", options);
      },
      close: () => {
        ConfirmationEventBus.emit("close");
      }
    };
    app.config.globalProperties.$confirm = ConfirmationService2;
    app.provide(PrimeVueConfirmSymbol, ConfirmationService2);
  }
};
const primevue_TdXjRgL1MA = /* @__PURE__ */ defineNuxtPlugin((nuxtApp) => {
  nuxtApp.vueApp.use(PrimeVue, {
    ripple: true,
    locale: {
      dayNames: [
        "Dimanche",
        "Lundi",
        "Mardi",
        "Mercredi",
        "Jeudi",
        "Vendredi",
        "Samedi"
      ],
      dayNamesShort: ["Dim", "Lun", "Mar", "Mer", "Jeu", "Ven", "Sam"],
      dayNamesMin: ["Di", "Lu", "Ma", "Me", "Je", "Ve", "Sa"],
      monthNames: [
        "Janvier",
        "Février",
        "Mars",
        "Avril",
        "Mai",
        "Juin",
        "Juillet",
        "Août",
        "Septembre",
        "Octobre",
        "Novembre",
        "Décembre"
      ],
      monthNamesShort: [
        "Jan",
        "Fév",
        "Mar",
        "Avr",
        "Mai",
        "Jui",
        "Jui",
        "Aoû",
        "Sep",
        "Oct",
        "Nov",
        "Déc"
      ]
    }
  });
  nuxtApp.vueApp.component("AutoComplete", script$O);
  nuxtApp.vueApp.component("Calendar", script$J);
  nuxtApp.vueApp.component("InputText", script$I);
  nuxtApp.vueApp.component("Message", script$D);
  nuxtApp.vueApp.component("ProgressSpinner", script$C);
  nuxtApp.vueApp.component("Dropdown", script$A);
  nuxtApp.vueApp.component("ProgressBar", script$z);
  nuxtApp.vueApp.component("Slider", script$y);
  nuxtApp.vueApp.component("InputSwitch", script$x);
  nuxtApp.vueApp.component("InputNumber", script$u);
  nuxtApp.vueApp.component("InputMask", script$t);
  nuxtApp.vueApp.component("Panel", script$q);
  nuxtApp.vueApp.component("DataTable", script$b);
  nuxtApp.vueApp.component("Column", script$9);
  nuxtApp.vueApp.component("Badge", script$8);
  nuxtApp.vueApp.directive("badge", BadgeDirective);
  nuxtApp.vueApp.component("Dialog", script$5);
  nuxtApp.vueApp.component("Button", script$T);
  nuxtApp.vueApp.component("Chip", script$4);
  nuxtApp.vueApp.component("Tag", script$3);
  nuxtApp.vueApp.component("Skeleton", script$2);
  nuxtApp.vueApp.component("RadioButton", script$1);
  nuxtApp.vueApp.component("ConfirmDialog", script);
  nuxtApp.vueApp.use(ConfirmationService);
});
const plugins = [
  plugin$1,
  plugin,
  revive_payload_server_eJ33V7gbc6,
  components_plugin_KR1HBZs4kY,
  unhead_KgADcZ0jPj,
  plugin_8SbxDRbG6Y,
  headless_ui_sXgzlVd9r2,
  i18n_sVHQBgnb3t,
  popper_KwS8fMgSzV,
  primevue_TdXjRgL1MA
];
const _export_sfc = (sfc, props) => {
  const target = sfc.__vccOpts || sfc;
  for (const [key, val] of props) {
    target[key] = val;
  }
  return target;
};
const _sfc_main$3 = {};
function _sfc_ssrRender(_ctx, _push, _parent, _attrs) {
  _push(`<div${ssrRenderAttrs(mergeProps({ class: "bg-secondary fixed bottom-0 left-0 right-0 top-0 z-[1000] flex h-full w-full items-center justify-center" }, _attrs))}><div class="inline-block h-32 w-32 animate-spin rounded-full border-4 border-solid border-white border-r-transparent align-[-0.125em] motion-reduce:animate-[spin_1.5s_linear_infinite]" role="status"><span class="!absolute !-m-px !h-px !w-px !overflow-hidden !whitespace-nowrap !border-0 !p-0 ![clip:rect(0,0,0,0)]">Loading...</span></div></div>`);
}
const _sfc_setup$3 = _sfc_main$3.setup;
_sfc_main$3.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/layout/SiteSpinner.vue");
  return _sfc_setup$3 ? _sfc_setup$3(props, ctx) : void 0;
};
const __nuxt_component_0 = /* @__PURE__ */ _export_sfc(_sfc_main$3, [["ssrRender", _sfc_ssrRender]]);
const _wrapIf = (component, props, slots) => {
  props = props === true ? {} : props;
  return { default: () => {
    var _a;
    return props ? h(component, props, slots) : (_a = slots.default) == null ? void 0 : _a.call(slots);
  } };
};
const layouts = {
  main: /* @__PURE__ */ defineAsyncComponent(() => import('./_nuxt/main-3ab2190b.mjs').then((m) => m.default || m))
};
const LayoutMetaSymbol = Symbol("layout-meta");
const __nuxt_component_1 = /* @__PURE__ */ defineComponent({
  name: "NuxtLayout",
  inheritAttrs: false,
  props: {
    name: {
      type: [String, Boolean, Object],
      default: null
    }
  },
  setup(props, context) {
    const nuxtApp = useNuxtApp();
    const injectedRoute = inject("_route");
    const route = injectedRoute === useRoute() ? useRoute$1() : injectedRoute;
    const layout = computed(() => unref(props.name) ?? route.meta.layout ?? "default");
    const layoutRef = ref();
    context.expose({ layoutRef });
    return () => {
      const done = nuxtApp.deferHydration();
      const hasLayout = layout.value && layout.value in layouts;
      const transitionProps = route.meta.layoutTransition ?? appLayoutTransition;
      return _wrapIf(Transition, hasLayout && transitionProps, {
        default: () => h(Suspense, { suspensible: true, onResolve: () => {
          nextTick(done);
        } }, {
          default: () => _wrapIf(LayoutProvider, hasLayout && {
            layoutProps: mergeProps(context.attrs, { ref: layoutRef }),
            key: layout.value,
            name: layout.value,
            shouldProvide: !props.name,
            hasTransition: !!transitionProps
          }, context.slots).default()
        })
      }).default();
    };
  }
});
const LayoutProvider = /* @__PURE__ */ defineComponent({
  name: "NuxtLayoutProvider",
  inheritAttrs: false,
  props: {
    name: {
      type: String
    },
    layoutProps: {
      type: Object
    },
    hasTransition: {
      type: Boolean
    },
    shouldProvide: {
      type: Boolean
    }
  },
  setup(props, context) {
    if (props.shouldProvide) {
      const name = props.name;
      provide(LayoutMetaSymbol, {
        isCurrent: (route) => name === (route.meta.layout ?? "default")
      });
    }
    return () => {
      return h(layouts[props.name], props.layoutProps, context.slots);
    };
  }
});
const interpolatePath = (route, match) => {
  return match.path.replace(/(:\w+)\([^)]+\)/g, "$1").replace(/(:\w+)[?+*]/g, "$1").replace(/:\w+/g, (r) => {
    var _a;
    return ((_a = route.params[r.slice(1)]) == null ? void 0 : _a.toString()) || "";
  });
};
const generateRouteKey = (routeProps, override) => {
  const matchedRoute = routeProps.route.matched.find((m) => {
    var _a;
    return ((_a = m.components) == null ? void 0 : _a.default) === routeProps.Component.type;
  });
  const source = override ?? (matchedRoute == null ? void 0 : matchedRoute.meta.key) ?? (matchedRoute && interpolatePath(routeProps.route, matchedRoute));
  return typeof source === "function" ? source(routeProps.route) : source;
};
const wrapInKeepAlive = (props, children) => {
  return { default: () => children };
};
const __nuxt_component_2 = /* @__PURE__ */ defineComponent({
  name: "NuxtPage",
  inheritAttrs: false,
  props: {
    name: {
      type: String
    },
    transition: {
      type: [Boolean, Object],
      default: void 0
    },
    keepalive: {
      type: [Boolean, Object],
      default: void 0
    },
    route: {
      type: Object
    },
    pageKey: {
      type: [Function, String],
      default: null
    }
  },
  setup(props, { attrs, expose }) {
    const nuxtApp = useNuxtApp();
    const pageRef = ref();
    expose({ pageRef });
    const _layoutMeta = inject(LayoutMetaSymbol, null);
    let vnode;
    return () => {
      return h(RouterView, { name: props.name, route: props.route, ...attrs }, {
        default: (routeProps) => {
          if (!routeProps.Component) {
            return;
          }
          if (vnode && _layoutMeta && !_layoutMeta.isCurrent(routeProps.route)) {
            return vnode;
          }
          const key = generateRouteKey(routeProps, props.pageKey);
          const done = nuxtApp.deferHydration();
          const hasTransition = !!(props.transition ?? routeProps.route.meta.pageTransition ?? appPageTransition);
          const transitionProps = hasTransition && _mergeTransitionProps([
            props.transition,
            routeProps.route.meta.pageTransition,
            appPageTransition,
            { onAfterLeave: () => {
              nuxtApp.callHook("page:transition:finish", routeProps.Component);
            } }
          ].filter(Boolean));
          vnode = _wrapIf(
            Transition,
            hasTransition && transitionProps,
            wrapInKeepAlive(
              props.keepalive ?? routeProps.route.meta.keepalive ?? appKeepalive,
              h(Suspense, {
                suspensible: true,
                onPending: () => nuxtApp.callHook("page:start", routeProps.Component),
                onResolve: () => {
                  nextTick(() => nuxtApp.callHook("page:finish", routeProps.Component).finally(done));
                }
              }, { default: () => h(RouteProvider, { key, routeProps, pageKey: key, hasTransition, pageRef }) })
            )
          ).default();
          return vnode;
        }
      });
    };
  }
});
function _toArray(val) {
  return Array.isArray(val) ? val : val ? [val] : [];
}
function _mergeTransitionProps(routeProps) {
  const _props = routeProps.map((prop) => ({
    ...prop,
    onAfterLeave: _toArray(prop.onAfterLeave)
  }));
  return defu(..._props);
}
const RouteProvider = /* @__PURE__ */ defineComponent({
  name: "RouteProvider",
  // TODO: Type props
  // eslint-disable-next-line vue/require-prop-types
  props: ["routeProps", "pageKey", "hasTransition", "pageRef"],
  setup(props) {
    const previousKey = props.pageKey;
    const previousRoute = props.routeProps.route;
    const route = {};
    for (const key in props.routeProps.route) {
      route[key] = computed(() => previousKey === props.pageKey ? props.routeProps.route[key] : previousRoute[key]);
    }
    provide("_route", reactive(route));
    return () => {
      return h(props.routeProps.Component, { ref: props.pageRef });
    };
  }
});
function resolveTags(options) {
  const tags = [...options.tags].filter(Boolean).map((i) => typeof i === "string" ? { id: i } : i);
  if (options.id)
    tags.unshift({ id: options.id, config: options.config });
  return tags;
}
function useGtag() {
  const options = useRuntimeConfig().public.gtag;
  resolveTags(options);
  let _gtag;
  _gtag = () => {
  };
  const setConsent = ({
    id,
    hasConsent = true
  }) => {
  };
  const grantConsent = (id) => {
  };
  const revokeConsent = (id) => {
  };
  return {
    gtag: _gtag,
    setConsent,
    grantConsent,
    revokeConsent
  };
}
const __default__ = {
  data() {
    return {
      loading: true
    };
  },
  beforeMount() {
    this.loading = true;
  },
  mounted() {
    this.loading = false;
  }
};
const _sfc_main$2 = /* @__PURE__ */ Object.assign(__default__, {
  __name: "app",
  __ssrInlineRender: true,
  setup(__props) {
    useGtag();
    return (_ctx, _push, _parent, _attrs) => {
      const _component_site_spinner = __nuxt_component_0;
      const _component_NuxtLayout = __nuxt_component_1;
      const _component_NuxtPage = __nuxt_component_2;
      _push(`<!--[-->`);
      if (_ctx.loading) {
        _push(ssrRenderComponent(_component_site_spinner, null, null, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(ssrRenderComponent(_component_NuxtLayout, { name: "main" }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(ssrRenderComponent(_component_NuxtPage, null, null, _parent2, _scopeId));
          } else {
            return [
              createVNode(_component_NuxtPage)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`<!--]-->`);
    };
  }
});
const _sfc_setup$2 = _sfc_main$2.setup;
_sfc_main$2.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("app.vue");
  return _sfc_setup$2 ? _sfc_setup$2(props, ctx) : void 0;
};
const AppComponent = _sfc_main$2;
const _sfc_main$1 = {
  __name: "nuxt-error-page",
  __ssrInlineRender: true,
  props: {
    error: Object
  },
  setup(__props) {
    const props = __props;
    const _error = props.error;
    (_error.stack || "").split("\n").splice(1).map((line) => {
      const text = line.replace("webpack:/", "").replace(".vue", ".js").trim();
      return {
        text,
        internal: line.includes("node_modules") && !line.includes(".cache") || line.includes("internal") || line.includes("new Promise")
      };
    }).map((i) => `<span class="stack${i.internal ? " internal" : ""}">${i.text}</span>`).join("\n");
    const statusCode = Number(_error.statusCode || 500);
    const is404 = statusCode === 404;
    const statusMessage = _error.statusMessage ?? (is404 ? "Page Not Found" : "Internal Server Error");
    const description = _error.message || _error.toString();
    const stack = void 0;
    const _Error404 = /* @__PURE__ */ defineAsyncComponent(() => import('./_nuxt/error-404-2c5771b5.mjs').then((r) => r.default || r));
    const _Error = /* @__PURE__ */ defineAsyncComponent(() => import('./_nuxt/error-500-beb79278.mjs').then((r) => r.default || r));
    const ErrorTemplate = is404 ? _Error404 : _Error;
    return (_ctx, _push, _parent, _attrs) => {
      _push(ssrRenderComponent(unref(ErrorTemplate), mergeProps({ statusCode: unref(statusCode), statusMessage: unref(statusMessage), description: unref(description), stack: unref(stack) }, _attrs), null, _parent));
    };
  }
};
const _sfc_setup$1 = _sfc_main$1.setup;
_sfc_main$1.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("node_modules/nuxt/dist/app/components/nuxt-error-page.vue");
  return _sfc_setup$1 ? _sfc_setup$1(props, ctx) : void 0;
};
const ErrorComponent = _sfc_main$1;
const _sfc_main = {
  __name: "nuxt-root",
  __ssrInlineRender: true,
  setup(__props) {
    const IslandRenderer = /* @__PURE__ */ defineAsyncComponent(() => import('./_nuxt/island-renderer-de7014f9.mjs').then((r) => r.default || r));
    const nuxtApp = useNuxtApp();
    nuxtApp.deferHydration();
    nuxtApp.ssrContext.url;
    const SingleRenderer = false;
    provide("_route", useRoute());
    nuxtApp.hooks.callHookWith((hooks) => hooks.map((hook) => hook()), "vue:setup");
    const error = useError();
    onErrorCaptured((err, target, info) => {
      nuxtApp.hooks.callHook("vue:error", err, target, info).catch((hookError) => console.error("[nuxt] Error in `vue:error` hook", hookError));
      {
        const p = nuxtApp.runWithContext(() => showError(err));
        onServerPrefetch(() => p);
        return false;
      }
    });
    const { islandContext } = nuxtApp.ssrContext;
    return (_ctx, _push, _parent, _attrs) => {
      ssrRenderSuspense(_push, {
        default: () => {
          if (unref(error)) {
            _push(ssrRenderComponent(unref(ErrorComponent), { error: unref(error) }, null, _parent));
          } else if (unref(islandContext)) {
            _push(ssrRenderComponent(unref(IslandRenderer), { context: unref(islandContext) }, null, _parent));
          } else if (unref(SingleRenderer)) {
            ssrRenderVNode(_push, createVNode(resolveDynamicComponent(unref(SingleRenderer)), null, null), _parent);
          } else {
            _push(ssrRenderComponent(unref(AppComponent), null, null, _parent));
          }
        },
        _: 1
      });
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("node_modules/nuxt/dist/app/components/nuxt-root.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
const RootComponent = _sfc_main;
if (!globalThis.$fetch) {
  globalThis.$fetch = $fetch.create({
    baseURL: baseURL()
  });
}
let entry;
{
  entry = async function createNuxtAppServer(ssrContext) {
    const vueApp = createApp(RootComponent);
    const nuxt = createNuxtApp({ vueApp, ssrContext });
    try {
      await applyPlugins(nuxt, plugins);
      await nuxt.hooks.callHook("app:created", vueApp);
    } catch (err) {
      await nuxt.hooks.callHook("app:error", err);
      nuxt.payload.error = nuxt.payload.error || err;
    }
    if (ssrContext == null ? void 0 : ssrContext._renderResponse) {
      throw new Error("skipping render");
    }
    return vueApp;
  };
}
const entry$1 = (ctx) => entry(ctx);

export { DomHandler as D, ObjectUtils as O, Ripple as R, _export_sfc as _, useNuxtApp as a, script$5 as b, createError as c, useConfirm as d, entry$1 as default, script$x as e, script$V as f, script$W as g, script$T as h, script$z as i, script$D as j, script$r as k, script$E as l, script$8 as m, useRouter as n, navigateTo as o, defineStore as p, script$H as q, defineNuxtRouteMiddleware as r, script$J as s, useHead as u };
//# sourceMappingURL=server.mjs.map
