import { _ as __nuxt_component_0$1 } from './SmallPageHeader-c7029e3a.mjs';
import { _ as __nuxt_component_0$2, a as __nuxt_component_1 } from './SectionContainer-5a7aa7e3.mjs';
import { _ as __nuxt_component_3 } from './SectionLayer-8e9d6e6a.mjs';
import { _ as __nuxt_component_3$1 } from './Icon-7157bd57.mjs';
import { ref, watch, computed, resolveComponent, withCtx, createVNode, createTextVNode, unref, openBlock, createBlock, toDisplayString, createCommentVNode, Transition, withDirectives, vModelCheckbox, useSSRContext, mergeProps } from 'vue';
import { ssrRenderAttrs, ssrRenderComponent, ssrRenderClass, ssrInterpolate, ssrIncludeBooleanAttr, ssrLooseContain, ssrRenderAttr } from 'vue/server-renderer';
import { s as script$J, a as useNuxtApp, _ as _export_sfc } from '../server.mjs';
import { _ as __nuxt_component_5$1 } from './FormField-14acbd69.mjs';
import { _ as __nuxt_component_8$1 } from './RoundedButton-a0ea68b9.mjs';
import { u as useConfigStore } from './config-f619f9d4.mjs';
import { _ as __nuxt_component_0$3 } from './nuxt-link-801c5f56.mjs';
import { u as useDayjs } from './dayjs-9d0b29d3.mjs';
import { s as script } from './fileupload.esm-d9f386d4.mjs';
import { C as CitySelectField } from './CitySelectField-385f4d0e.mjs';
import 'ofetch';
import 'hookable';
import 'unctx';
import 'vue-router';
import 'h3';
import 'ufo';
import '@unhead/ssr';
import 'unhead';
import '@unhead/shared';
import 'dayjs';
import 'dayjs/plugin/relativeTime.js';
import 'dayjs/plugin/utc.js';
import 'dayjs/plugin/timezone.js';
import '@headlessui/vue';
import 'vue-i18n';
import 'defu';
import '../../nitro/node-server.mjs';
import 'node-fetch-native/polyfill';
import 'node:http';
import 'node:https';
import 'destr';
import 'unenv/runtime/fetch/index';
import 'scule';
import 'klona';
import 'ohash';
import 'unstorage';
import 'radix3';
import 'node:fs';
import 'node:url';
import 'pathe';
import 'http-graceful-shutdown';
import 'lodash';

const _sfc_main$3 = {
  props: {
    number: {
      type: String,
      default: "01",
      required: true
    },
    progress: {
      type: Number,
      default: 0,
      required: true
    }
  }
};
function _sfc_ssrRender$1(_ctx, _push, _parent, _attrs, $props, $setup, $data, $options) {
  _push(`<div${ssrRenderAttrs(mergeProps({ class: "flex items-center justify-center" }, _attrs))}><svg class="h-16 w-16" viewBox="0 0 36 36"><path class="stroke-current text-gray-300" stroke-width="2" d="M18 2.0845
          a 15.9155 15.9155 0 0 1 0 31.831
          a 15.9155 15.9155 0 0 1 0 -31.831" fill="none"></path><path class="text-ternary stroke-current" stroke-width="2"${ssrRenderAttr("stroke-dasharray", `${this.progress},${100 - this.progress}`)} d="M18 2.0845
          a 15.9155 15.9155 0 0 1 0 31.831
          a 15.9155 15.9155 0 0 1 0 -31.831" fill="none"></path><text class="text-ternary" x="18" y="20" text-anchor="middle" dy=".3em">${ssrInterpolate($props.number)}</text></svg></div>`);
}
const _sfc_setup$3 = _sfc_main$3.setup;
_sfc_main$3.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/NumberProgressCircle.vue");
  return _sfc_setup$3 ? _sfc_setup$3(props, ctx) : void 0;
};
const __nuxt_component_0 = /* @__PURE__ */ _export_sfc(_sfc_main$3, [["ssrRender", _sfc_ssrRender$1]]);
const _sfc_main$2 = {
  props: {
    number: {
      type: String,
      default: "primary",
      required: true
    },
    progress: {
      type: Number,
      default: 0,
      required: true
    },
    title: {
      type: String,
      default: "Title",
      required: true
    }
  }
};
function _sfc_ssrRender(_ctx, _push, _parent, _attrs, $props, $setup, $data, $options) {
  const _component_number_progress_circle = __nuxt_component_0;
  _push(`<div${ssrRenderAttrs(mergeProps({ class: "flex items-center" }, _attrs))}><div class="text-primary">`);
  _push(ssrRenderComponent(_component_number_progress_circle, {
    number: $props.number,
    progress: $props.progress,
    class: "mr-5"
  }, null, _parent));
  _push(`</div><div class="text-primary text-[1.75rem]">${ssrInterpolate($props.title)}</div></div>`);
}
const _sfc_setup$2 = _sfc_main$2.setup;
_sfc_main$2.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/form/Register/RegisterSectionTitle.vue");
  return _sfc_setup$2 ? _sfc_setup$2(props, ctx) : void 0;
};
const __nuxt_component_5 = /* @__PURE__ */ _export_sfc(_sfc_main$2, [["ssrRender", _sfc_ssrRender]]);
const _sfc_main$1 = {
  __name: "AddPaymentMethod",
  __ssrInlineRender: true,
  props: {
    price: {
      type: Number,
      default: 0
    },
    annualy: {
      type: Boolean,
      default: false
    }
  },
  emits: ["update:promo-code-id"],
  setup(__props, { expose: __expose, emit }) {
    const { price, annualy } = __props;
    const { $stripe, $api, $toast } = useNuxtApp();
    ref(null);
    const card = ref(null);
    ref(false);
    useConfigStore();
    const loading = ref(false);
    const cardHolderName = ref("");
    const validationErrors = ref({});
    const promoCode = ref("");
    const error = ref(null);
    const promoCodeObject = ref(null);
    watch(
      () => cardHolderName.value,
      (value) => {
        validateCardHolderName();
      }
    );
    watch(
      () => promoCode.value,
      (value) => {
        if (value.length === 0) {
          promoCodeObject.value = null;
        }
      }
    );
    watch(
      () => promoCodeObject.value,
      (value) => {
        if (value) {
          emit("update:promoCodeId", value.id);
        } else {
          emit("update:promoCodeId", null);
        }
      }
    );
    const validateCardHolderName = () => {
      if (!cardHolderName.value) {
        validationErrors.value.cardHolderName = [
          "Veuillez entrer le nom sur la carte"
        ];
        return false;
      } else {
        validationErrors.value.cardHolderName = null;
        return true;
      }
    };
    const validateForm = async () => {
      validationErrors.value = {};
      if (validateCardHolderName()) {
        return await savePaymentMethod();
      }
    };
    const savePaymentMethod = async () => {
      loading.value = true;
      error.value = null;
      return await $stripe.createPaymentMethod({
        type: "card",
        card: card.value,
        billing_details: {
          name: cardHolderName.value
        }
      }).then((result) => {
        if (result.error) {
          validationErrors.value.card = [result.error.message];
        } else {
          return result;
        }
      }).finally(() => {
        loading.value = false;
      });
    };
    const removePromoCode = () => {
      promoCodeObject.value = null;
      promoCode.value = "";
    };
    computed(() => {
      if (promoCodeObject.value) {
        if (promoCodeObject.value.coupon.percent_off) {
          return price - price * promoCodeObject.value.coupon.percent_off / 100;
        } else if (promoCodeObject.value.coupon.amount_off) {
          return price - promoCodeObject.value.coupon.amount_off / 100;
        }
      }
      return price;
    });
    __expose({
      savePaymentMethod,
      validateForm
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_Message = resolveComponent("Message");
      const _component_FormField = __nuxt_component_5$1;
      const _component_InputText = resolveComponent("InputText");
      _push(`<div${ssrRenderAttrs(_attrs)}><p class="mb-5"> Vous devez maintenant nous fournir un moyen de paiement afin que nous puissions pr\xE9lever les frais associ\xE9s \xE0 vos futurs r\xE9servations de trajets. </p><p>Vous ne serez pas d\xE9bit\xE9 tant que vous n&#39;aurez pas r\xE9serv\xE9 un trajet.</p><br>`);
      if (promoCodeObject.value) {
        _push(ssrRenderComponent(_component_Message, {
          title: "sdfsd",
          severity: "success",
          onClose: removePromoCode
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(promoCodeObject.value.code)} (`);
              if (promoCodeObject.value.coupon.percent_off) {
                _push2(`<span${_scopeId}>-${ssrInterpolate(promoCodeObject.value.coupon.percent_off)}%</span>`);
              } else {
                _push2(`<!---->`);
              }
              if (promoCodeObject.value.coupon.amount_off) {
                _push2(`<span${_scopeId}> -${ssrInterpolate(_ctx.$n(promoCodeObject.value.coupon.amount_off / 100, {
                  style: "currency",
                  currency: "EUR",
                  minimumFractionDigits: 2,
                  maximumFractionDigits: 2
                }))}</span>`);
              } else {
                _push2(`<!---->`);
              }
              _push2(`) `);
            } else {
              return [
                createTextVNode(toDisplayString(promoCodeObject.value.code) + " (", 1),
                promoCodeObject.value.coupon.percent_off ? (openBlock(), createBlock("span", { key: 0 }, "-" + toDisplayString(promoCodeObject.value.coupon.percent_off) + "%", 1)) : createCommentVNode("", true),
                promoCodeObject.value.coupon.amount_off ? (openBlock(), createBlock("span", { key: 1 }, " -" + toDisplayString(_ctx.$n(promoCodeObject.value.coupon.amount_off / 100, {
                  style: "currency",
                  currency: "EUR",
                  minimumFractionDigits: 2,
                  maximumFractionDigits: 2
                })), 1)) : createCommentVNode("", true),
                createTextVNode(") ")
              ];
            }
          }),
          _: 1
        }, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(ssrRenderComponent(_component_FormField, {
        class: "mb-4",
        name: "cardHolderName",
        label: "Nom sur la carte",
        errors: validationErrors.value,
        required: "true"
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(ssrRenderComponent(_component_InputText, {
              modelValue: cardHolderName.value,
              "onUpdate:modelValue": ($event) => cardHolderName.value = $event,
              name: "cardHolderName",
              type: "text",
              placeholder: "Nom sur la carte",
              disabled: loading.value,
              class: `w-full ${validationErrors.value.cardHolderName ? "p-invalid" : ""}`
            }, null, _parent2, _scopeId));
          } else {
            return [
              createVNode(_component_InputText, {
                modelValue: cardHolderName.value,
                "onUpdate:modelValue": ($event) => cardHolderName.value = $event,
                name: "cardHolderName",
                type: "text",
                placeholder: "Nom sur la carte",
                disabled: loading.value,
                class: `w-full ${validationErrors.value.cardHolderName ? "p-invalid" : ""}`
              }, null, 8, ["modelValue", "onUpdate:modelValue", "disabled", "class"])
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(ssrRenderComponent(_component_FormField, {
        class: "mb-4",
        name: "card",
        label: "Carte",
        errors: validationErrors.value,
        required: "true"
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<div id="card-input" class="${ssrRenderClass(`p-inputtext p-component w-full ${validationErrors.value.cardHolderName ? "p-invalid" : ""}`)}"${_scopeId}></div>`);
          } else {
            return [
              createVNode("div", {
                id: "card-input",
                class: `p-inputtext p-component w-full ${validationErrors.value.cardHolderName ? "p-invalid" : ""}`
              }, null, 2)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div>`);
    };
  }
};
const _sfc_setup$1 = _sfc_main$1.setup;
_sfc_main$1.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/AddPaymentMethod.vue");
  return _sfc_setup$1 ? _sfc_setup$1(props, ctx) : void 0;
};
const __nuxt_component_8 = _sfc_main$1;
const _sfc_main = {
  __name: "register",
  __ssrInlineRender: true,
  setup(__props) {
    const { $api, $toast } = useNuxtApp();
    const { pricing } = useConfigStore();
    const dayjs = useDayjs();
    const validationErrors = ref({});
    const step = ref(1);
    const registered = ref(false);
    const intent = ref(null);
    const createdCompany = ref(null);
    const paymentMethodId = ref(null);
    const loading = ref(false);
    const addPayment = ref(null);
    const errorsOnSubmitStepOne = ref(false);
    const errorsOnSubmitStepTwo = ref(false);
    const error = ref(null);
    const promocodeId = ref(null);
    const cgu = ref(false);
    const registerData = ref({
      name: "",
      first_name: "",
      last_name: "",
      siret: "",
      address: "",
      city: null,
      email: "",
      password: "",
      password_confirmation: "",
      kbis: null,
      clearance: null,
      phone: "",
      mobile: "",
      clearance_expires_at: null,
      annual_billing: false
    });
    watch(
      () => registerData.value,
      (value) => {
        if (errorsOnSubmitStepOne.value) {
          validateForm(1);
        }
        if (errorsOnSubmitStepTwo.value) {
          validateForm(2);
        }
      },
      { deep: true }
    );
    const hasValidationError = computed(() => {
      return Object.keys(validationErrors.value).length > 0;
    });
    const isValidSIRET = (siret) => {
      if (siret.length !== 14) {
        return false;
      }
      let somme = 0;
      let tmp;
      for (let cpt = 0; cpt < siret.length; cpt++) {
        if (cpt % 2 === 0) {
          tmp = siret.charAt(cpt) * 2;
          if (tmp > 9) {
            tmp -= 9;
          }
        } else {
          tmp = siret.charAt(cpt);
        }
        somme += parseInt(tmp, 10);
      }
      return somme % 10 === 0;
    };
    const validateForm = async (step2) => {
      validationErrors.value = {};
      const emailPattern = /^[a-zA-Z0-9._-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,4}$/;
      if (step2 === 1) {
        if (!registerData.value.name) {
          validationErrors.value.name = ["Le nom de l'entreprise est requis"];
        }
        if (!registerData.value.first_name) {
          validationErrors.value.first_name = ["Le pr\xE9nom est requis"];
        }
        if (!registerData.value.last_name) {
          validationErrors.value.last_name = ["Le nom est requis"];
        }
        if (!registerData.value.email) {
          validationErrors.value.email = ["L'adresse e-mail est requis."];
        }
        if (!emailPattern.test(registerData.value.email)) {
          validationErrors.value.email = ["L'adresse e-mail est invalide."];
        } else {
          await isEmailAleadyRegisted(registerData.value.email);
        }
        const passwordValidation = registerData.value.password.length >= 8;
        const passwordConfirmationValidation = registerData.value.password_confirmation.length >= 8;
        if (!passwordValidation) {
          validationErrors.value.password = [
            "Le mot de passe doit contenir au moins 8 caract\xE8res"
          ];
        }
        if (!passwordConfirmationValidation) {
          validationErrors.value.password_confirmation = [
            "Le mot de passe doit contenir au moins 8 caract\xE8res"
          ];
        }
        if (passwordValidation && passwordConfirmationValidation) {
          if (registerData.value.password !== registerData.value.password_confirmation) {
            validationErrors.value.password_confirmation = [
              "Les mots de passe ne correspondent pas"
            ];
          }
        }
      } else if (step2 === 2) {
        if (!registerData.value.siret) {
          validationErrors.value.siret = ["Le num\xE9ro SIRET est requis"];
        } else {
          registerData.value.siret = registerData.value.siret.replace(/\s/g, "");
          if (!isValidSIRET(registerData.value.siret)) {
            validationErrors.value.siret = ["Le num\xE9ro SIRET est invalide"];
          } else {
            await isSiretAleadyRegisted(registerData.value.siret);
          }
        }
        if (!registerData.value.kbis) {
          validationErrors.value.kbis = ["L'extrait Kbis est requis"];
        }
        if (!registerData.value.address) {
          validationErrors.value.address = ["L'adresse est requise"];
        }
        if (!registerData.value.city) {
          validationErrors.value.city = ["La ville est requise"];
        }
        if (!registerData.value.phone) {
          validationErrors.value.phone = ["Le t\xE9l\xE9phone fixe est requis"];
        }
        if (!registerData.value.mobile) {
          validationErrors.value.mobile = ["Le t\xE9l\xE9phone mobile est requis"];
        }
        if (!registerData.value.clearance) {
          validationErrors.value.clearance = ["L'habilitation est requise"];
        }
        if (!registerData.value.clearance_expires_at) {
          validationErrors.value.clearance_expires_at = [
            "La date de fin de validit\xE9 de l'habilitation est requise"
          ];
        } else if (dayjs(registerData.value.clearance_expires_at).isBefore(dayjs())) {
          validationErrors.value.clearance_expires_at = [
            "La date de fin de validit\xE9 de l'habilitation doit \xEAtre sup\xE9rieure \xE0 la date du jour"
          ];
        }
      }
    };
    const sendForm = () => {
      loading.value = true;
      validationErrors.value = {};
      error.value = null;
      const formData = new FormData();
      formData.append("name", registerData.value.name);
      formData.append("first_name", registerData.value.first_name);
      formData.append("last_name", registerData.value.last_name);
      formData.append("address", registerData.value.address);
      formData.append("city", registerData.value.city);
      formData.append("siret", registerData.value.siret);
      formData.append("email", registerData.value.email);
      formData.append("password", registerData.value.password);
      formData.append(
        "password_confirmation",
        registerData.value.password_confirmation
      );
      const clearance_expires_at = dayjs(registerData.value.clearance_expires_at).startOf("day").format("YYYY-MM-DDTHH:mm:ss");
      formData.append("kbis", registerData.value.kbis);
      formData.append("clearance", registerData.value.clearance);
      formData.append("phone", registerData.value.phone);
      formData.append("mobile", registerData.value.mobile);
      formData.append("clearance_expires_at", clearance_expires_at);
      formData.append("annual_billing", registerData.value.annual_billing ? 1 : 0);
      formData.append("payment_method_id", paymentMethodId.value);
      if (promocodeId.value) {
        formData.append("promocode_id", promocodeId.value);
      }
      return $api.call("post", $api.route("auth.register"), formData).then((data) => {
        intent.value = data.intent;
        createdCompany.value = data.company;
        $toast.success(
          "Votre compte a bien \xE9t\xE9 cr\xE9\xE9. Nous vous enverrons un mail une fois les donn\xE9es v\xE9rifi\xE9es.",
          {
            timeout: 2e4
          }
        );
      }).catch((e) => {
        if (e.response) {
          if (e.response.status == 422) {
            if (e.response.data.errors) {
              $toast.error("Un ou plusieurs champs sont invalides");
              error.value = "Un ou plusieurs champs sont invalides";
              validationErrors.value = e.response.data.errors;
            }
          } else {
            if (e.response.data.error) {
              $toast.error(e.response.data.error);
              error.value = e.response.data.error;
            } else if (e.response.data.message) {
              $toast.error(e.response.data.message);
              error.value = e.response.data.message;
            } else {
              $toast.error("Une erreur est survenue");
              error.value = "Une erreur est survenue";
            }
          }
        } else {
          error.value = e.message;
        }
        throw e;
      }).finally(() => {
        loading.value = false;
      });
    };
    const submit = async (method) => {
      if (loading.value)
        return;
      if (cgu.value === false)
        return;
      loading.value = true;
      try {
        paymentMethodId.value = method.paymentMethod.id;
        await sendForm();
        registered.value = true;
      } catch (e) {
      } finally {
        loading.value = false;
      }
    };
    const back = () => {
      errorsOnSubmitStepOne.value = false;
      errorsOnSubmitStepTwo.value = false;
      step.value--;
    };
    const isEmailAleadyRegisted = async (email) => {
      var _a, _b, _c;
      try {
        await $api.call("post", $api.route("auth.validation"), {
          email
        });
      } catch (e) {
        if ((_c = (_b = (_a = e == null ? void 0 : e.response) == null ? void 0 : _a.data) == null ? void 0 : _b.errors) == null ? void 0 : _c.email) {
          validationErrors.value.email = [e.response.data.errors.email[0]];
        }
      }
    };
    const isSiretAleadyRegisted = async (siret) => {
      var _a, _b, _c;
      try {
        await $api.call("post", $api.route("auth.validation"), {
          siret
        });
      } catch (e) {
        if ((_c = (_b = (_a = e == null ? void 0 : e.response) == null ? void 0 : _a.data) == null ? void 0 : _b.errors) == null ? void 0 : _c.siret) {
          validationErrors.value.siret = [e.response.data.errors.siret[0]];
        }
      }
    };
    const stepValidation = async (number) => {
      if (number === 1) {
        await validateForm(1);
        if (hasValidationError.value) {
          errorsOnSubmitStepOne.value = true;
        } else {
          step.value++;
        }
      } else if (number === 2) {
        await validateForm(2);
        if (hasValidationError.value) {
          errorsOnSubmitStepTwo.value = true;
        } else {
          step.value++;
        }
      } else if (number === 3) {
        step.value++;
      } else if (number === 4) {
        const method = await addPayment.value.validateForm();
        if (method) {
          await submit(method);
        }
      }
    };
    const price = computed(() => {
      if (registerData.value.annual_billing) {
        return pricing.yearly.amount / 100;
      } else {
        return pricing.monthly.amount / 100;
      }
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_small_page_header = __nuxt_component_0$1;
      const _component_section_wrapper = __nuxt_component_0$2;
      const _component_section_layer = __nuxt_component_3;
      const _component_section_container = __nuxt_component_1;
      const _component_icon = __nuxt_component_3$1;
      const _component_register_section_title = __nuxt_component_5;
      const _component_FormField = __nuxt_component_5$1;
      const _component_InputText = resolveComponent("InputText");
      const _component_rounded_button = __nuxt_component_8$1;
      const _component_Message = resolveComponent("Message");
      const _component_InputMask = resolveComponent("InputMask");
      const _component_AddPaymentMethod = __nuxt_component_8;
      const _component_NuxtLink = __nuxt_component_0$3;
      _push(`<div${ssrRenderAttrs(_attrs)}>`);
      _push(ssrRenderComponent(_component_small_page_header, {
        design: "ternary",
        title: "Rejoignez la plateforme Funargos ",
        subtitle: "et optimisez tous vos trajets"
      }, null, _parent));
      _push(ssrRenderComponent(_component_section_wrapper, { class: "relative bg-white" }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(ssrRenderComponent(_component_section_layer, {
              class: "bg-no-repeat max-[1735px]:hidden",
              style: { "background-position": "right 0 bottom 0" },
              background: "/images/ROND + PIN.png"
            }, null, _parent2, _scopeId));
            _push2(`<div class="max-w-container relative z-[1] mx-auto max-xl:hidden"${_scopeId}><svg id="Isolation_Mode" class="text-ternary-lightest absolute -right-[135rem] -top-[12rem] -mb-[2.3rem] hidden h-[39rem] bg-transparent opacity-40 lg:block" data-name="Isolation Mode" xmlns="http://www.w3.org/2000/svg" viewBox="-2.699 -0.454 840.874 96.2841"${_scopeId}><path id="Path_3622" data-name="Path 3622" class="${ssrRenderClass(`text-${_ctx.design}`)}" fill="currentColor" d="M 837.934 0.988 L 838.175 54.941 L 300.126 54.941 L 300.126 51.441 C 300.126 50.635 299.571 49.998 298.893 49.986 C 298.585 49.986 298.287 50.118 298.061 50.359 L 289.029 59.859 C 287.58 61.386 287.457 63.996 288.762 65.703 C 288.844 65.812 288.936 65.92 289.029 66.016 L 298.061 75.516 C 298.574 76.046 299.355 75.997 299.807 75.408 C 300.013 75.144 300.126 74.795 300.126 74.446 C 300.126 74.446 300.126 72.318 300.136 72.318 L 300.136 69.732 C 300.136 69.191 300.506 68.746 300.968 68.746 C 301.174 68.746 301.379 68.83 301.534 68.999 L 304.678 72.318 L 304.955 72.606 L 311.922 79.942 C 313.031 81.108 313.113 83.093 312.127 84.391 C 312.065 84.476 311.994 84.548 311.922 84.632 L 304.955 91.968 L 304.472 92.473 L 301.523 95.575 C 301.184 95.936 300.65 95.912 300.342 95.515 C 300.198 95.335 300.126 95.094 300.126 94.854 L 300.126 90.897 L -2.699 90.897 L -2.699 -0.454"${_scopeId}></path></svg></div>`);
            if (registered.value) {
              _push2(ssrRenderComponent(_component_section_container, {
                "mobile-padding": "",
                class: "max-w-container relative z-10 py-[15rem]"
              }, {
                default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    _push3(`<div class="h-75 flex items-center justify-center"${_scopeId2}><div class="align-content-center flex flex-col items-center justify-center"${_scopeId2}>`);
                    _push3(ssrRenderComponent(_component_icon, {
                      icon: "check",
                      class: "text-secondary border-secondary mb-10 h-[15rem] w-[15rem] rounded-full border-[1rem] p-10"
                    }, null, _parent3, _scopeId2));
                    _push3(`<h2 class="text-secondary mb-8 text-center text-3xl font-bold"${_scopeId2}> Votre compte a \xE9t\xE9 cr\xE9\xE9 avec succ\xE8s ! </h2><p class="text-primary-lighter text-center text-[2rem]"${_scopeId2}> Il ne nous reste plus qu&#39;\xE0 v\xE9rifier vos informations. Nous vous enverrons un email d\xE8s que votre compte sera valid\xE9.<br${_scopeId2}> Merci et \xE0 tr\xE8s bient\xF4t ! </p></div></div>`);
                  } else {
                    return [
                      createVNode("div", { class: "h-75 flex items-center justify-center" }, [
                        createVNode("div", { class: "align-content-center flex flex-col items-center justify-center" }, [
                          createVNode(_component_icon, {
                            icon: "check",
                            class: "text-secondary border-secondary mb-10 h-[15rem] w-[15rem] rounded-full border-[1rem] p-10"
                          }),
                          createVNode("h2", { class: "text-secondary mb-8 text-center text-3xl font-bold" }, " Votre compte a \xE9t\xE9 cr\xE9\xE9 avec succ\xE8s ! "),
                          createVNode("p", { class: "text-primary-lighter text-center text-[2rem]" }, [
                            createTextVNode(" Il ne nous reste plus qu'\xE0 v\xE9rifier vos informations. Nous vous enverrons un email d\xE8s que votre compte sera valid\xE9."),
                            createVNode("br"),
                            createTextVNode(" Merci et \xE0 tr\xE8s bient\xF4t ! ")
                          ])
                        ])
                      ])
                    ];
                  }
                }),
                _: 1
              }, _parent2, _scopeId));
            } else {
              _push2(ssrRenderComponent(_component_section_container, {
                "mobile-padding": "",
                class: "max-w-container relative z-10 py-20"
              }, {
                default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    _push3(``);
                    if (step.value === 1) {
                      _push3(`<div${_scopeId2}><div class="justify-center md:flex"${_scopeId2}><div class="w-1/2"${_scopeId2}><div class="col-span-6"${_scopeId2}>`);
                      _push3(ssrRenderComponent(_component_register_section_title, {
                        title: "Cr\xE9ation de compte",
                        number: "01",
                        class: "mb-12",
                        progress: "33"
                      }, null, _parent3, _scopeId2));
                      _push3(`<div${_scopeId2}>`);
                      _push3(ssrRenderComponent(_component_FormField, {
                        class: "mb-4",
                        name: "name",
                        label: "Nom de l'entreprise",
                        errors: validationErrors.value,
                        required: "required"
                      }, {
                        default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                          if (_push4) {
                            _push4(ssrRenderComponent(_component_InputText, {
                              modelValue: registerData.value.name,
                              "onUpdate:modelValue": ($event) => registerData.value.name = $event,
                              type: "text",
                              placeholder: "Nom de l'entreprise",
                              class: `w-full ${validationErrors.value.name ? "p-invalid" : ""}`,
                              disabled: loading.value
                            }, null, _parent4, _scopeId3));
                          } else {
                            return [
                              createVNode(_component_InputText, {
                                modelValue: registerData.value.name,
                                "onUpdate:modelValue": ($event) => registerData.value.name = $event,
                                type: "text",
                                placeholder: "Nom de l'entreprise",
                                class: `w-full ${validationErrors.value.name ? "p-invalid" : ""}`,
                                disabled: loading.value
                              }, null, 8, ["modelValue", "onUpdate:modelValue", "class", "disabled"])
                            ];
                          }
                        }),
                        _: 1
                      }, _parent3, _scopeId2));
                      _push3(ssrRenderComponent(_component_FormField, {
                        class: "mb-4",
                        name: "first_name",
                        label: "Pr\xE9nom",
                        errors: validationErrors.value,
                        required: "required"
                      }, {
                        default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                          if (_push4) {
                            _push4(ssrRenderComponent(_component_InputText, {
                              modelValue: registerData.value.first_name,
                              "onUpdate:modelValue": ($event) => registerData.value.first_name = $event,
                              type: "text",
                              placeholder: "Pr\xE9nom",
                              class: `w-full ${validationErrors.value.first_name ? "p-invalid" : ""}`,
                              disabled: loading.value
                            }, null, _parent4, _scopeId3));
                          } else {
                            return [
                              createVNode(_component_InputText, {
                                modelValue: registerData.value.first_name,
                                "onUpdate:modelValue": ($event) => registerData.value.first_name = $event,
                                type: "text",
                                placeholder: "Pr\xE9nom",
                                class: `w-full ${validationErrors.value.first_name ? "p-invalid" : ""}`,
                                disabled: loading.value
                              }, null, 8, ["modelValue", "onUpdate:modelValue", "class", "disabled"])
                            ];
                          }
                        }),
                        _: 1
                      }, _parent3, _scopeId2));
                      _push3(ssrRenderComponent(_component_FormField, {
                        class: "mb-4",
                        name: "last_name",
                        label: "Nom",
                        errors: validationErrors.value,
                        required: "required"
                      }, {
                        default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                          if (_push4) {
                            _push4(ssrRenderComponent(_component_InputText, {
                              modelValue: registerData.value.last_name,
                              "onUpdate:modelValue": ($event) => registerData.value.last_name = $event,
                              type: "text",
                              placeholder: "Nom",
                              class: `w-full ${validationErrors.value.last_name ? "p-invalid" : ""}`,
                              disabled: loading.value
                            }, null, _parent4, _scopeId3));
                          } else {
                            return [
                              createVNode(_component_InputText, {
                                modelValue: registerData.value.last_name,
                                "onUpdate:modelValue": ($event) => registerData.value.last_name = $event,
                                type: "text",
                                placeholder: "Nom",
                                class: `w-full ${validationErrors.value.last_name ? "p-invalid" : ""}`,
                                disabled: loading.value
                              }, null, 8, ["modelValue", "onUpdate:modelValue", "class", "disabled"])
                            ];
                          }
                        }),
                        _: 1
                      }, _parent3, _scopeId2));
                      _push3(ssrRenderComponent(_component_FormField, {
                        class: "mb-4",
                        name: "email",
                        label: "Email",
                        errors: validationErrors.value,
                        required: "required"
                      }, {
                        default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                          if (_push4) {
                            _push4(ssrRenderComponent(_component_InputText, {
                              modelValue: registerData.value.email,
                              "onUpdate:modelValue": ($event) => registerData.value.email = $event,
                              type: "email",
                              placeholder: "Email",
                              class: `w-full ${validationErrors.value.email ? "p-invalid" : ""}`,
                              disabled: loading.value
                            }, null, _parent4, _scopeId3));
                          } else {
                            return [
                              createVNode(_component_InputText, {
                                modelValue: registerData.value.email,
                                "onUpdate:modelValue": ($event) => registerData.value.email = $event,
                                type: "email",
                                placeholder: "Email",
                                class: `w-full ${validationErrors.value.email ? "p-invalid" : ""}`,
                                disabled: loading.value
                              }, null, 8, ["modelValue", "onUpdate:modelValue", "class", "disabled"])
                            ];
                          }
                        }),
                        _: 1
                      }, _parent3, _scopeId2));
                      _push3(ssrRenderComponent(_component_FormField, {
                        class: "mb-4",
                        name: "password",
                        label: "Mot de passe",
                        errors: validationErrors.value,
                        required: "required"
                      }, {
                        default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                          if (_push4) {
                            _push4(ssrRenderComponent(_component_InputText, {
                              modelValue: registerData.value.password,
                              "onUpdate:modelValue": ($event) => registerData.value.password = $event,
                              type: "password",
                              placeholder: "Mot de passe",
                              class: `w-full ${validationErrors.value.password ? "p-invalid" : ""}`,
                              disabled: loading.value
                            }, null, _parent4, _scopeId3));
                          } else {
                            return [
                              createVNode(_component_InputText, {
                                modelValue: registerData.value.password,
                                "onUpdate:modelValue": ($event) => registerData.value.password = $event,
                                type: "password",
                                placeholder: "Mot de passe",
                                class: `w-full ${validationErrors.value.password ? "p-invalid" : ""}`,
                                disabled: loading.value
                              }, null, 8, ["modelValue", "onUpdate:modelValue", "class", "disabled"])
                            ];
                          }
                        }),
                        _: 1
                      }, _parent3, _scopeId2));
                      _push3(ssrRenderComponent(_component_FormField, {
                        name: "password_confirmation",
                        label: "Confirmez votre mot de passe",
                        errors: validationErrors.value,
                        required: "required"
                      }, {
                        default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                          if (_push4) {
                            _push4(ssrRenderComponent(_component_InputText, {
                              modelValue: registerData.value.password_confirmation,
                              "onUpdate:modelValue": ($event) => registerData.value.password_confirmation = $event,
                              type: "password",
                              placeholder: "Confirmez votre mot de passe",
                              class: `w-full ${validationErrors.value.password_confirmation ? "p-invalid" : ""}`,
                              disabled: loading.value
                            }, null, _parent4, _scopeId3));
                          } else {
                            return [
                              createVNode(_component_InputText, {
                                modelValue: registerData.value.password_confirmation,
                                "onUpdate:modelValue": ($event) => registerData.value.password_confirmation = $event,
                                type: "password",
                                placeholder: "Confirmez votre mot de passe",
                                class: `w-full ${validationErrors.value.password_confirmation ? "p-invalid" : ""}`,
                                disabled: loading.value
                              }, null, 8, ["modelValue", "onUpdate:modelValue", "class", "disabled"])
                            ];
                          }
                        }),
                        _: 1
                      }, _parent3, _scopeId2));
                      _push3(`</div><div class="flex gap-5"${_scopeId2}>`);
                      _push3(ssrRenderComponent(_component_rounded_button, {
                        design: "3",
                        class: "mt-12",
                        onClick: ($event) => stepValidation(1),
                        disabled: unref(hasValidationError)
                      }, {
                        default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                          if (_push4) {
                            _push4(` SUIVANT `);
                          } else {
                            return [
                              createTextVNode(" SUIVANT ")
                            ];
                          }
                        }),
                        _: 1
                      }, _parent3, _scopeId2));
                      _push3(`</div></div></div></div></div>`);
                    } else if (step.value === 2) {
                      _push3(`<div${_scopeId2}><div class="justify-center md:flex"${_scopeId2}><div class="w-1/2"${_scopeId2}>`);
                      _push3(ssrRenderComponent(_component_register_section_title, {
                        title: "Information administrative",
                        number: "02",
                        progress: "66",
                        class: "mb-12"
                      }, null, _parent3, _scopeId2));
                      _push3(ssrRenderComponent(_component_Message, { severity: "info" }, {
                        default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                          if (_push4) {
                            _push4(` Afin de nous conformer \xE0 la norme <a class="underline" href="https://www.signicat.com/fr/blog/kyc-requirements-banks"${_scopeId3}>KYC (Know Your Customer)</a>, nous avons besoin de quelques informations suppl\xE9mentaires. `);
                          } else {
                            return [
                              createTextVNode(" Afin de nous conformer \xE0 la norme "),
                              createVNode("a", {
                                class: "underline",
                                href: "https://www.signicat.com/fr/blog/kyc-requirements-banks"
                              }, "KYC (Know Your Customer)"),
                              createTextVNode(", nous avons besoin de quelques informations suppl\xE9mentaires. ")
                            ];
                          }
                        }),
                        _: 1
                      }, _parent3, _scopeId2));
                      _push3(`<div${_scopeId2}>`);
                      _push3(ssrRenderComponent(_component_FormField, {
                        class: "mb-4",
                        name: "siret",
                        label: "Num\xE9ro SIRET",
                        errors: validationErrors.value,
                        required: "required"
                      }, {
                        default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                          if (_push4) {
                            _push4(ssrRenderComponent(_component_InputText, {
                              modelValue: registerData.value.siret,
                              "onUpdate:modelValue": ($event) => registerData.value.siret = $event,
                              placeholder: "Num\xE9ro SIRET",
                              class: `w-full ${validationErrors.value.siret ? "p-invalid" : ""}`,
                              disabled: loading.value
                            }, null, _parent4, _scopeId3));
                          } else {
                            return [
                              createVNode(_component_InputText, {
                                modelValue: registerData.value.siret,
                                "onUpdate:modelValue": ($event) => registerData.value.siret = $event,
                                placeholder: "Num\xE9ro SIRET",
                                class: `w-full ${validationErrors.value.siret ? "p-invalid" : ""}`,
                                disabled: loading.value
                              }, null, 8, ["modelValue", "onUpdate:modelValue", "class", "disabled"])
                            ];
                          }
                        }),
                        _: 1
                      }, _parent3, _scopeId2));
                      _push3(ssrRenderComponent(_component_FormField, {
                        class: "mb-4",
                        name: "kbis",
                        label: "Extrait Kbis",
                        errors: validationErrors.value,
                        required: "required"
                      }, {
                        default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                          if (_push4) {
                            if (registerData.value.kbis) {
                              _push4(`<div class="bg-ternary-lightest text-primary flex items-center justify-between gap-3 rounded p-3"${_scopeId3}><span class="font-normal"${_scopeId3}>${ssrInterpolate(registerData.value.kbis.name)}</span><span class="cursor-pointer font-normal"${_scopeId3}>Supprimer</span></div>`);
                            } else {
                              _push4(`<!---->`);
                            }
                            if (!registerData.value.kbis) {
                              _push4(ssrRenderComponent(unref(script), {
                                onUploader: (e) => {
                                  registerData.value.kbis = e.files[0];
                                },
                                accept: "application/pdf",
                                name: "kbis",
                                auto: "",
                                mode: "basic",
                                modelValue: registerData.value.kbis,
                                "onUpdate:modelValue": ($event) => registerData.value.kbis = $event,
                                "choose-label": "S\xE9lectionner l'Extrait Kbis",
                                customUpload: true,
                                disabled: loading.value,
                                pt: {
                                  chooseButton: { style: "background-color: #96B938 " }
                                }
                              }, null, _parent4, _scopeId3));
                            } else {
                              _push4(`<!---->`);
                            }
                          } else {
                            return [
                              registerData.value.kbis ? (openBlock(), createBlock("div", {
                                key: 0,
                                class: "bg-ternary-lightest text-primary flex items-center justify-between gap-3 rounded p-3"
                              }, [
                                createVNode("span", { class: "font-normal" }, toDisplayString(registerData.value.kbis.name), 1),
                                createVNode("span", {
                                  onClick: ($event) => registerData.value.kbis = null,
                                  class: "cursor-pointer font-normal"
                                }, "Supprimer", 8, ["onClick"])
                              ])) : createCommentVNode("", true),
                              !registerData.value.kbis ? (openBlock(), createBlock(unref(script), {
                                key: 1,
                                onUploader: (e) => {
                                  registerData.value.kbis = e.files[0];
                                },
                                accept: "application/pdf",
                                name: "kbis",
                                auto: "",
                                mode: "basic",
                                modelValue: registerData.value.kbis,
                                "onUpdate:modelValue": ($event) => registerData.value.kbis = $event,
                                "choose-label": "S\xE9lectionner l'Extrait Kbis",
                                customUpload: true,
                                disabled: loading.value,
                                pt: {
                                  chooseButton: { style: "background-color: #96B938 " }
                                }
                              }, null, 8, ["onUploader", "modelValue", "onUpdate:modelValue", "disabled"])) : createCommentVNode("", true)
                            ];
                          }
                        }),
                        _: 1
                      }, _parent3, _scopeId2));
                      _push3(ssrRenderComponent(_component_FormField, {
                        class: "mb-4",
                        name: "address",
                        label: "Adresse",
                        errors: validationErrors.value,
                        required: "required"
                      }, {
                        default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                          if (_push4) {
                            _push4(ssrRenderComponent(_component_InputText, {
                              modelValue: registerData.value.address,
                              "onUpdate:modelValue": ($event) => registerData.value.address = $event,
                              type: "text",
                              placeholder: "Adresse",
                              class: `w-full ${validationErrors.value.address ? "p-invalid" : ""}`,
                              disabled: loading.value
                            }, null, _parent4, _scopeId3));
                          } else {
                            return [
                              createVNode(_component_InputText, {
                                modelValue: registerData.value.address,
                                "onUpdate:modelValue": ($event) => registerData.value.address = $event,
                                type: "text",
                                placeholder: "Adresse",
                                class: `w-full ${validationErrors.value.address ? "p-invalid" : ""}`,
                                disabled: loading.value
                              }, null, 8, ["modelValue", "onUpdate:modelValue", "class", "disabled"])
                            ];
                          }
                        }),
                        _: 1
                      }, _parent3, _scopeId2));
                      _push3(ssrRenderComponent(_component_FormField, {
                        class: "mb-4",
                        name: "city",
                        label: "Ville",
                        errors: validationErrors.value,
                        required: "required"
                      }, {
                        default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                          if (_push4) {
                            _push4(ssrRenderComponent(CitySelectField, {
                              placeholder: "Ville",
                              modelValue: registerData.value.city,
                              "onUpdate:modelValue": ($event) => registerData.value.city = $event,
                              disabled: loading.value,
                              class: `w-full ${validationErrors.value.city ? "p-invalid" : ""}`
                            }, null, _parent4, _scopeId3));
                          } else {
                            return [
                              createVNode(CitySelectField, {
                                placeholder: "Ville",
                                modelValue: registerData.value.city,
                                "onUpdate:modelValue": ($event) => registerData.value.city = $event,
                                disabled: loading.value,
                                class: `w-full ${validationErrors.value.city ? "p-invalid" : ""}`
                              }, null, 8, ["modelValue", "onUpdate:modelValue", "disabled", "class"])
                            ];
                          }
                        }),
                        _: 1
                      }, _parent3, _scopeId2));
                      _push3(ssrRenderComponent(_component_FormField, {
                        name: "phone",
                        label: "T\xE9l\xE9phone fixe",
                        class: "mb-4",
                        errors: validationErrors.value,
                        required: "required"
                      }, {
                        default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                          if (_push4) {
                            _push4(ssrRenderComponent(_component_InputMask, {
                              placeholder: "T\xE9l\xE9phone fixe",
                              mask: "99 99 99 99 99",
                              disabled: loading.value,
                              unmask: "",
                              modelValue: registerData.value.phone,
                              "onUpdate:modelValue": ($event) => registerData.value.phone = $event,
                              class: `w-full ${validationErrors.value.phone ? "p-invalid" : ""}`
                            }, null, _parent4, _scopeId3));
                          } else {
                            return [
                              createVNode(_component_InputMask, {
                                placeholder: "T\xE9l\xE9phone fixe",
                                mask: "99 99 99 99 99",
                                disabled: loading.value,
                                unmask: "",
                                modelValue: registerData.value.phone,
                                "onUpdate:modelValue": ($event) => registerData.value.phone = $event,
                                class: `w-full ${validationErrors.value.phone ? "p-invalid" : ""}`
                              }, null, 8, ["disabled", "modelValue", "onUpdate:modelValue", "class"])
                            ];
                          }
                        }),
                        _: 1
                      }, _parent3, _scopeId2));
                      _push3(ssrRenderComponent(_component_FormField, {
                        name: "mobile",
                        label: "T\xE9l\xE9phone mobile",
                        class: "mb-4",
                        errors: validationErrors.value,
                        required: "required"
                      }, {
                        default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                          if (_push4) {
                            _push4(ssrRenderComponent(_component_InputMask, {
                              placeholder: "T\xE9l\xE9phone mobile",
                              mask: "+33 (9)9 99 99 99 99",
                              unmask: "",
                              modelValue: registerData.value.mobile,
                              "onUpdate:modelValue": ($event) => registerData.value.mobile = $event,
                              class: `w-full ${validationErrors.value.mobile ? "p-invalid" : ""}`,
                              disabled: loading.value
                            }, null, _parent4, _scopeId3));
                          } else {
                            return [
                              createVNode(_component_InputMask, {
                                placeholder: "T\xE9l\xE9phone mobile",
                                mask: "+33 (9)9 99 99 99 99",
                                unmask: "",
                                modelValue: registerData.value.mobile,
                                "onUpdate:modelValue": ($event) => registerData.value.mobile = $event,
                                class: `w-full ${validationErrors.value.mobile ? "p-invalid" : ""}`,
                                disabled: loading.value
                              }, null, 8, ["modelValue", "onUpdate:modelValue", "class", "disabled"])
                            ];
                          }
                        }),
                        _: 1
                      }, _parent3, _scopeId2));
                      _push3(ssrRenderComponent(_component_FormField, {
                        class: "mb-4",
                        name: "clearance",
                        label: "Habilitation",
                        errors: validationErrors.value,
                        required: "required"
                      }, {
                        default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                          if (_push4) {
                            if (registerData.value.clearance) {
                              _push4(`<div class="bg-ternary-lightest text-primary flex items-center justify-between gap-3 rounded p-3"${_scopeId3}><span class="font-normal"${_scopeId3}>${ssrInterpolate(registerData.value.clearance.name)}</span><span class="cursor-pointer font-normal"${_scopeId3}>Supprimer</span></div>`);
                            } else {
                              _push4(`<!---->`);
                            }
                            if (!registerData.value.clearance) {
                              _push4(ssrRenderComponent(unref(script), {
                                onUploader: (e) => {
                                  registerData.value.clearance = e.files[0];
                                },
                                accept: "application/pdf",
                                name: "clearance",
                                auto: "",
                                mode: "basic",
                                modelValue: registerData.value.clearance,
                                "onUpdate:modelValue": ($event) => registerData.value.clearance = $event,
                                "choose-label": "Habilitation",
                                customUpload: true,
                                pt: {
                                  chooseButton: { style: "background-color: #96B938 " }
                                },
                                disabled: loading.value
                              }, null, _parent4, _scopeId3));
                            } else {
                              _push4(`<!---->`);
                            }
                          } else {
                            return [
                              registerData.value.clearance ? (openBlock(), createBlock("div", {
                                key: 0,
                                class: "bg-ternary-lightest text-primary flex items-center justify-between gap-3 rounded p-3"
                              }, [
                                createVNode("span", { class: "font-normal" }, toDisplayString(registerData.value.clearance.name), 1),
                                createVNode("span", {
                                  onClick: ($event) => registerData.value.clearance = null,
                                  class: "cursor-pointer font-normal"
                                }, "Supprimer", 8, ["onClick"])
                              ])) : createCommentVNode("", true),
                              !registerData.value.clearance ? (openBlock(), createBlock(unref(script), {
                                key: 1,
                                onUploader: (e) => {
                                  registerData.value.clearance = e.files[0];
                                },
                                accept: "application/pdf",
                                name: "clearance",
                                auto: "",
                                mode: "basic",
                                modelValue: registerData.value.clearance,
                                "onUpdate:modelValue": ($event) => registerData.value.clearance = $event,
                                "choose-label": "Habilitation",
                                customUpload: true,
                                pt: {
                                  chooseButton: { style: "background-color: #96B938 " }
                                },
                                disabled: loading.value
                              }, null, 8, ["onUploader", "modelValue", "onUpdate:modelValue", "disabled"])) : createCommentVNode("", true)
                            ];
                          }
                        }),
                        _: 1
                      }, _parent3, _scopeId2));
                      _push3(ssrRenderComponent(_component_FormField, {
                        class: "mb-4",
                        name: "clearance_expires_at",
                        required: "required",
                        label: "Date de fin de validit\xE9 de l'habilitation",
                        errors: validationErrors.value
                      }, {
                        default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                          if (_push4) {
                            _push4(`<div class="p-input-icon-right"${_scopeId3}><i class="pi pi-pencil"${_scopeId3}></i>`);
                            _push4(ssrRenderComponent(unref(script$J), {
                              disabled: loading.value,
                              dateFormat: "dd/mm/yy",
                              "hour-format": "24",
                              showIcon: "",
                              modelValue: registerData.value.clearance_expires_at,
                              "onUpdate:modelValue": ($event) => registerData.value.clearance_expires_at = $event,
                              "min-date": unref(dayjs)().toDate(),
                              placeholder: "Date de fin de validit\xE9 de l'habilitation",
                              class: `w-full ${validationErrors.value.clearance_expires_at ? "p-invalid" : ""}`
                            }, null, _parent4, _scopeId3));
                            _push4(`</div>`);
                          } else {
                            return [
                              createVNode("div", { class: "p-input-icon-right" }, [
                                createVNode("i", { class: "pi pi-pencil" }),
                                createVNode(unref(script$J), {
                                  disabled: loading.value,
                                  dateFormat: "dd/mm/yy",
                                  "hour-format": "24",
                                  showIcon: "",
                                  modelValue: registerData.value.clearance_expires_at,
                                  "onUpdate:modelValue": ($event) => registerData.value.clearance_expires_at = $event,
                                  "min-date": unref(dayjs)().toDate(),
                                  placeholder: "Date de fin de validit\xE9 de l'habilitation",
                                  class: `w-full ${validationErrors.value.clearance_expires_at ? "p-invalid" : ""}`
                                }, null, 8, ["disabled", "modelValue", "onUpdate:modelValue", "min-date", "class"])
                              ])
                            ];
                          }
                        }),
                        _: 1
                      }, _parent3, _scopeId2));
                      _push3(`</div><div class="flex gap-5"${_scopeId2}>`);
                      if (step.value > 1) {
                        _push3(ssrRenderComponent(_component_rounded_button, {
                          design: "3",
                          class: "mt-12",
                          onClick: back
                        }, {
                          default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                            if (_push4) {
                              _push4(` RETOUR `);
                            } else {
                              return [
                                createTextVNode(" RETOUR ")
                              ];
                            }
                          }),
                          _: 1
                        }, _parent3, _scopeId2));
                      } else {
                        _push3(`<!---->`);
                      }
                      _push3(ssrRenderComponent(_component_rounded_button, {
                        design: "3",
                        class: "mt-12",
                        onClick: ($event) => stepValidation(2),
                        disabled: unref(hasValidationError)
                      }, {
                        default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                          if (_push4) {
                            _push4(` SUIVANT `);
                          } else {
                            return [
                              createTextVNode(" SUIVANT ")
                            ];
                          }
                        }),
                        _: 1
                      }, _parent3, _scopeId2));
                      _push3(`</div></div></div></div>`);
                    } else if (step.value === 3) {
                      _push3(`<div${_scopeId2}><div class="justify-center md:flex"${_scopeId2}><div class="w-1/2"${_scopeId2}>`);
                      _push3(ssrRenderComponent(_component_register_section_title, {
                        title: "Moyen de paiement",
                        number: "03",
                        progress: "100",
                        class: "mb-12"
                      }, null, _parent3, _scopeId2));
                      _push3(`<div${_scopeId2}>`);
                      _push3(ssrRenderComponent(_component_AddPaymentMethod, {
                        annualy: registerData.value.annual_billing,
                        price: unref(price),
                        ref_key: "addPayment",
                        ref: addPayment,
                        class: "mb-12",
                        "onUpdate:promoCodeId": ($event) => promocodeId.value = $event
                      }, null, _parent3, _scopeId2));
                      _push3(`<div class="flex items-center"${_scopeId2}><input id="cgv" type="checkbox"${ssrIncludeBooleanAttr(Array.isArray(cgu.value) ? ssrLooseContain(cgu.value, null) : cgu.value) ? " checked" : ""} class="mr-2"${_scopeId2}><label for="cgv" class="text-primary"${_scopeId2}>J&#39;ai lu et j&#39;accepte les `);
                      _push3(ssrRenderComponent(_component_NuxtLink, {
                        class: "text-secondary underline",
                        target: "_blank",
                        to: "/cgu"
                      }, {
                        default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                          if (_push4) {
                            _push4(`conditions g\xE9n\xE9rales de ventes`);
                          } else {
                            return [
                              createTextVNode("conditions g\xE9n\xE9rales de ventes")
                            ];
                          }
                        }),
                        _: 1
                      }, _parent3, _scopeId2));
                      _push3(`</label></div><div class="flex gap-5"${_scopeId2}>`);
                      if (step.value > 1) {
                        _push3(ssrRenderComponent(_component_rounded_button, {
                          design: "3",
                          class: "mt-12",
                          onClick: back
                        }, {
                          default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                            if (_push4) {
                              _push4(` RETOUR `);
                            } else {
                              return [
                                createTextVNode(" RETOUR ")
                              ];
                            }
                          }),
                          _: 1
                        }, _parent3, _scopeId2));
                      } else {
                        _push3(`<!---->`);
                      }
                      _push3(ssrRenderComponent(_component_rounded_button, {
                        design: "3",
                        class: "mt-12",
                        onClick: ($event) => stepValidation(4),
                        disabled: !cgu.value,
                        loading: loading.value
                      }, {
                        default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                          if (_push4) {
                            _push4(` Cr\xE9er mon compte `);
                          } else {
                            return [
                              createTextVNode(" Cr\xE9er mon compte ")
                            ];
                          }
                        }),
                        _: 1
                      }, _parent3, _scopeId2));
                      _push3(`</div></div></div></div></div>`);
                    } else {
                      _push3(`<!---->`);
                    }
                  } else {
                    return [
                      createVNode(Transition, {
                        name: "fade",
                        mode: "out-in",
                        "enter-active-class": "transition-opacity ease-in duration-700",
                        "enter-class": "opacity-0",
                        "enter-to-class": "opacity-100",
                        "leave-class": "opacity-0",
                        "leave-to-class": "opacity-0"
                      }, {
                        default: withCtx(() => [
                          step.value === 1 ? (openBlock(), createBlock("div", { key: "step1" }, [
                            createVNode("div", { class: "justify-center md:flex" }, [
                              createVNode("div", { class: "w-1/2" }, [
                                createVNode("div", { class: "col-span-6" }, [
                                  createVNode(_component_register_section_title, {
                                    title: "Cr\xE9ation de compte",
                                    number: "01",
                                    class: "mb-12",
                                    progress: "33"
                                  }),
                                  createVNode("div", null, [
                                    createVNode(_component_FormField, {
                                      class: "mb-4",
                                      name: "name",
                                      label: "Nom de l'entreprise",
                                      errors: validationErrors.value,
                                      required: "required"
                                    }, {
                                      default: withCtx(() => [
                                        createVNode(_component_InputText, {
                                          modelValue: registerData.value.name,
                                          "onUpdate:modelValue": ($event) => registerData.value.name = $event,
                                          type: "text",
                                          placeholder: "Nom de l'entreprise",
                                          class: `w-full ${validationErrors.value.name ? "p-invalid" : ""}`,
                                          disabled: loading.value
                                        }, null, 8, ["modelValue", "onUpdate:modelValue", "class", "disabled"])
                                      ]),
                                      _: 1
                                    }, 8, ["errors"]),
                                    createVNode(_component_FormField, {
                                      class: "mb-4",
                                      name: "first_name",
                                      label: "Pr\xE9nom",
                                      errors: validationErrors.value,
                                      required: "required"
                                    }, {
                                      default: withCtx(() => [
                                        createVNode(_component_InputText, {
                                          modelValue: registerData.value.first_name,
                                          "onUpdate:modelValue": ($event) => registerData.value.first_name = $event,
                                          type: "text",
                                          placeholder: "Pr\xE9nom",
                                          class: `w-full ${validationErrors.value.first_name ? "p-invalid" : ""}`,
                                          disabled: loading.value
                                        }, null, 8, ["modelValue", "onUpdate:modelValue", "class", "disabled"])
                                      ]),
                                      _: 1
                                    }, 8, ["errors"]),
                                    createVNode(_component_FormField, {
                                      class: "mb-4",
                                      name: "last_name",
                                      label: "Nom",
                                      errors: validationErrors.value,
                                      required: "required"
                                    }, {
                                      default: withCtx(() => [
                                        createVNode(_component_InputText, {
                                          modelValue: registerData.value.last_name,
                                          "onUpdate:modelValue": ($event) => registerData.value.last_name = $event,
                                          type: "text",
                                          placeholder: "Nom",
                                          class: `w-full ${validationErrors.value.last_name ? "p-invalid" : ""}`,
                                          disabled: loading.value
                                        }, null, 8, ["modelValue", "onUpdate:modelValue", "class", "disabled"])
                                      ]),
                                      _: 1
                                    }, 8, ["errors"]),
                                    createVNode(_component_FormField, {
                                      class: "mb-4",
                                      name: "email",
                                      label: "Email",
                                      errors: validationErrors.value,
                                      required: "required"
                                    }, {
                                      default: withCtx(() => [
                                        createVNode(_component_InputText, {
                                          modelValue: registerData.value.email,
                                          "onUpdate:modelValue": ($event) => registerData.value.email = $event,
                                          type: "email",
                                          placeholder: "Email",
                                          class: `w-full ${validationErrors.value.email ? "p-invalid" : ""}`,
                                          disabled: loading.value
                                        }, null, 8, ["modelValue", "onUpdate:modelValue", "class", "disabled"])
                                      ]),
                                      _: 1
                                    }, 8, ["errors"]),
                                    createVNode(_component_FormField, {
                                      class: "mb-4",
                                      name: "password",
                                      label: "Mot de passe",
                                      errors: validationErrors.value,
                                      required: "required"
                                    }, {
                                      default: withCtx(() => [
                                        createVNode(_component_InputText, {
                                          modelValue: registerData.value.password,
                                          "onUpdate:modelValue": ($event) => registerData.value.password = $event,
                                          type: "password",
                                          placeholder: "Mot de passe",
                                          class: `w-full ${validationErrors.value.password ? "p-invalid" : ""}`,
                                          disabled: loading.value
                                        }, null, 8, ["modelValue", "onUpdate:modelValue", "class", "disabled"])
                                      ]),
                                      _: 1
                                    }, 8, ["errors"]),
                                    createVNode(_component_FormField, {
                                      name: "password_confirmation",
                                      label: "Confirmez votre mot de passe",
                                      errors: validationErrors.value,
                                      required: "required"
                                    }, {
                                      default: withCtx(() => [
                                        createVNode(_component_InputText, {
                                          modelValue: registerData.value.password_confirmation,
                                          "onUpdate:modelValue": ($event) => registerData.value.password_confirmation = $event,
                                          type: "password",
                                          placeholder: "Confirmez votre mot de passe",
                                          class: `w-full ${validationErrors.value.password_confirmation ? "p-invalid" : ""}`,
                                          disabled: loading.value
                                        }, null, 8, ["modelValue", "onUpdate:modelValue", "class", "disabled"])
                                      ]),
                                      _: 1
                                    }, 8, ["errors"])
                                  ]),
                                  createVNode("div", { class: "flex gap-5" }, [
                                    createVNode(_component_rounded_button, {
                                      design: "3",
                                      class: "mt-12",
                                      onClick: ($event) => stepValidation(1),
                                      disabled: unref(hasValidationError)
                                    }, {
                                      default: withCtx(() => [
                                        createTextVNode(" SUIVANT ")
                                      ]),
                                      _: 1
                                    }, 8, ["onClick", "disabled"])
                                  ])
                                ])
                              ])
                            ])
                          ])) : step.value === 2 ? (openBlock(), createBlock("div", { key: "step2" }, [
                            createVNode("div", { class: "justify-center md:flex" }, [
                              createVNode("div", { class: "w-1/2" }, [
                                createVNode(_component_register_section_title, {
                                  title: "Information administrative",
                                  number: "02",
                                  progress: "66",
                                  class: "mb-12"
                                }),
                                createVNode(_component_Message, { severity: "info" }, {
                                  default: withCtx(() => [
                                    createTextVNode(" Afin de nous conformer \xE0 la norme "),
                                    createVNode("a", {
                                      class: "underline",
                                      href: "https://www.signicat.com/fr/blog/kyc-requirements-banks"
                                    }, "KYC (Know Your Customer)"),
                                    createTextVNode(", nous avons besoin de quelques informations suppl\xE9mentaires. ")
                                  ]),
                                  _: 1
                                }),
                                createVNode("div", null, [
                                  createVNode(_component_FormField, {
                                    class: "mb-4",
                                    name: "siret",
                                    label: "Num\xE9ro SIRET",
                                    errors: validationErrors.value,
                                    required: "required"
                                  }, {
                                    default: withCtx(() => [
                                      createVNode(_component_InputText, {
                                        modelValue: registerData.value.siret,
                                        "onUpdate:modelValue": ($event) => registerData.value.siret = $event,
                                        placeholder: "Num\xE9ro SIRET",
                                        class: `w-full ${validationErrors.value.siret ? "p-invalid" : ""}`,
                                        disabled: loading.value
                                      }, null, 8, ["modelValue", "onUpdate:modelValue", "class", "disabled"])
                                    ]),
                                    _: 1
                                  }, 8, ["errors"]),
                                  createVNode(_component_FormField, {
                                    class: "mb-4",
                                    name: "kbis",
                                    label: "Extrait Kbis",
                                    errors: validationErrors.value,
                                    required: "required"
                                  }, {
                                    default: withCtx(() => [
                                      registerData.value.kbis ? (openBlock(), createBlock("div", {
                                        key: 0,
                                        class: "bg-ternary-lightest text-primary flex items-center justify-between gap-3 rounded p-3"
                                      }, [
                                        createVNode("span", { class: "font-normal" }, toDisplayString(registerData.value.kbis.name), 1),
                                        createVNode("span", {
                                          onClick: ($event) => registerData.value.kbis = null,
                                          class: "cursor-pointer font-normal"
                                        }, "Supprimer", 8, ["onClick"])
                                      ])) : createCommentVNode("", true),
                                      !registerData.value.kbis ? (openBlock(), createBlock(unref(script), {
                                        key: 1,
                                        onUploader: (e) => {
                                          registerData.value.kbis = e.files[0];
                                        },
                                        accept: "application/pdf",
                                        name: "kbis",
                                        auto: "",
                                        mode: "basic",
                                        modelValue: registerData.value.kbis,
                                        "onUpdate:modelValue": ($event) => registerData.value.kbis = $event,
                                        "choose-label": "S\xE9lectionner l'Extrait Kbis",
                                        customUpload: true,
                                        disabled: loading.value,
                                        pt: {
                                          chooseButton: { style: "background-color: #96B938 " }
                                        }
                                      }, null, 8, ["onUploader", "modelValue", "onUpdate:modelValue", "disabled"])) : createCommentVNode("", true)
                                    ]),
                                    _: 1
                                  }, 8, ["errors"]),
                                  createVNode(_component_FormField, {
                                    class: "mb-4",
                                    name: "address",
                                    label: "Adresse",
                                    errors: validationErrors.value,
                                    required: "required"
                                  }, {
                                    default: withCtx(() => [
                                      createVNode(_component_InputText, {
                                        modelValue: registerData.value.address,
                                        "onUpdate:modelValue": ($event) => registerData.value.address = $event,
                                        type: "text",
                                        placeholder: "Adresse",
                                        class: `w-full ${validationErrors.value.address ? "p-invalid" : ""}`,
                                        disabled: loading.value
                                      }, null, 8, ["modelValue", "onUpdate:modelValue", "class", "disabled"])
                                    ]),
                                    _: 1
                                  }, 8, ["errors"]),
                                  createVNode(_component_FormField, {
                                    class: "mb-4",
                                    name: "city",
                                    label: "Ville",
                                    errors: validationErrors.value,
                                    required: "required"
                                  }, {
                                    default: withCtx(() => [
                                      createVNode(CitySelectField, {
                                        placeholder: "Ville",
                                        modelValue: registerData.value.city,
                                        "onUpdate:modelValue": ($event) => registerData.value.city = $event,
                                        disabled: loading.value,
                                        class: `w-full ${validationErrors.value.city ? "p-invalid" : ""}`
                                      }, null, 8, ["modelValue", "onUpdate:modelValue", "disabled", "class"])
                                    ]),
                                    _: 1
                                  }, 8, ["errors"]),
                                  createVNode(_component_FormField, {
                                    name: "phone",
                                    label: "T\xE9l\xE9phone fixe",
                                    class: "mb-4",
                                    errors: validationErrors.value,
                                    required: "required"
                                  }, {
                                    default: withCtx(() => [
                                      createVNode(_component_InputMask, {
                                        placeholder: "T\xE9l\xE9phone fixe",
                                        mask: "99 99 99 99 99",
                                        disabled: loading.value,
                                        unmask: "",
                                        modelValue: registerData.value.phone,
                                        "onUpdate:modelValue": ($event) => registerData.value.phone = $event,
                                        class: `w-full ${validationErrors.value.phone ? "p-invalid" : ""}`
                                      }, null, 8, ["disabled", "modelValue", "onUpdate:modelValue", "class"])
                                    ]),
                                    _: 1
                                  }, 8, ["errors"]),
                                  createVNode(_component_FormField, {
                                    name: "mobile",
                                    label: "T\xE9l\xE9phone mobile",
                                    class: "mb-4",
                                    errors: validationErrors.value,
                                    required: "required"
                                  }, {
                                    default: withCtx(() => [
                                      createVNode(_component_InputMask, {
                                        placeholder: "T\xE9l\xE9phone mobile",
                                        mask: "+33 (9)9 99 99 99 99",
                                        unmask: "",
                                        modelValue: registerData.value.mobile,
                                        "onUpdate:modelValue": ($event) => registerData.value.mobile = $event,
                                        class: `w-full ${validationErrors.value.mobile ? "p-invalid" : ""}`,
                                        disabled: loading.value
                                      }, null, 8, ["modelValue", "onUpdate:modelValue", "class", "disabled"])
                                    ]),
                                    _: 1
                                  }, 8, ["errors"]),
                                  createVNode(_component_FormField, {
                                    class: "mb-4",
                                    name: "clearance",
                                    label: "Habilitation",
                                    errors: validationErrors.value,
                                    required: "required"
                                  }, {
                                    default: withCtx(() => [
                                      registerData.value.clearance ? (openBlock(), createBlock("div", {
                                        key: 0,
                                        class: "bg-ternary-lightest text-primary flex items-center justify-between gap-3 rounded p-3"
                                      }, [
                                        createVNode("span", { class: "font-normal" }, toDisplayString(registerData.value.clearance.name), 1),
                                        createVNode("span", {
                                          onClick: ($event) => registerData.value.clearance = null,
                                          class: "cursor-pointer font-normal"
                                        }, "Supprimer", 8, ["onClick"])
                                      ])) : createCommentVNode("", true),
                                      !registerData.value.clearance ? (openBlock(), createBlock(unref(script), {
                                        key: 1,
                                        onUploader: (e) => {
                                          registerData.value.clearance = e.files[0];
                                        },
                                        accept: "application/pdf",
                                        name: "clearance",
                                        auto: "",
                                        mode: "basic",
                                        modelValue: registerData.value.clearance,
                                        "onUpdate:modelValue": ($event) => registerData.value.clearance = $event,
                                        "choose-label": "Habilitation",
                                        customUpload: true,
                                        pt: {
                                          chooseButton: { style: "background-color: #96B938 " }
                                        },
                                        disabled: loading.value
                                      }, null, 8, ["onUploader", "modelValue", "onUpdate:modelValue", "disabled"])) : createCommentVNode("", true)
                                    ]),
                                    _: 1
                                  }, 8, ["errors"]),
                                  createVNode(_component_FormField, {
                                    class: "mb-4",
                                    name: "clearance_expires_at",
                                    required: "required",
                                    label: "Date de fin de validit\xE9 de l'habilitation",
                                    errors: validationErrors.value
                                  }, {
                                    default: withCtx(() => [
                                      createVNode("div", { class: "p-input-icon-right" }, [
                                        createVNode("i", { class: "pi pi-pencil" }),
                                        createVNode(unref(script$J), {
                                          disabled: loading.value,
                                          dateFormat: "dd/mm/yy",
                                          "hour-format": "24",
                                          showIcon: "",
                                          modelValue: registerData.value.clearance_expires_at,
                                          "onUpdate:modelValue": ($event) => registerData.value.clearance_expires_at = $event,
                                          "min-date": unref(dayjs)().toDate(),
                                          placeholder: "Date de fin de validit\xE9 de l'habilitation",
                                          class: `w-full ${validationErrors.value.clearance_expires_at ? "p-invalid" : ""}`
                                        }, null, 8, ["disabled", "modelValue", "onUpdate:modelValue", "min-date", "class"])
                                      ])
                                    ]),
                                    _: 1
                                  }, 8, ["errors"])
                                ]),
                                createVNode("div", { class: "flex gap-5" }, [
                                  step.value > 1 ? (openBlock(), createBlock(_component_rounded_button, {
                                    key: 0,
                                    design: "3",
                                    class: "mt-12",
                                    onClick: back
                                  }, {
                                    default: withCtx(() => [
                                      createTextVNode(" RETOUR ")
                                    ]),
                                    _: 1
                                  })) : createCommentVNode("", true),
                                  createVNode(_component_rounded_button, {
                                    design: "3",
                                    class: "mt-12",
                                    onClick: ($event) => stepValidation(2),
                                    disabled: unref(hasValidationError)
                                  }, {
                                    default: withCtx(() => [
                                      createTextVNode(" SUIVANT ")
                                    ]),
                                    _: 1
                                  }, 8, ["onClick", "disabled"])
                                ])
                              ])
                            ])
                          ])) : step.value === 3 ? (openBlock(), createBlock("div", { key: "step4" }, [
                            createVNode("div", { class: "justify-center md:flex" }, [
                              createVNode("div", { class: "w-1/2" }, [
                                createVNode(_component_register_section_title, {
                                  title: "Moyen de paiement",
                                  number: "03",
                                  progress: "100",
                                  class: "mb-12"
                                }),
                                createVNode("div", null, [
                                  createVNode(_component_AddPaymentMethod, {
                                    annualy: registerData.value.annual_billing,
                                    price: unref(price),
                                    ref_key: "addPayment",
                                    ref: addPayment,
                                    class: "mb-12",
                                    "onUpdate:promoCodeId": ($event) => promocodeId.value = $event
                                  }, null, 8, ["annualy", "price", "onUpdate:promoCodeId"]),
                                  createVNode("div", { class: "flex items-center" }, [
                                    withDirectives(createVNode("input", {
                                      id: "cgv",
                                      type: "checkbox",
                                      "onUpdate:modelValue": ($event) => cgu.value = $event,
                                      class: "mr-2"
                                    }, null, 8, ["onUpdate:modelValue"]), [
                                      [vModelCheckbox, cgu.value]
                                    ]),
                                    createVNode("label", {
                                      for: "cgv",
                                      class: "text-primary"
                                    }, [
                                      createTextVNode("J'ai lu et j'accepte les "),
                                      createVNode(_component_NuxtLink, {
                                        class: "text-secondary underline",
                                        target: "_blank",
                                        to: "/cgu"
                                      }, {
                                        default: withCtx(() => [
                                          createTextVNode("conditions g\xE9n\xE9rales de ventes")
                                        ]),
                                        _: 1
                                      })
                                    ])
                                  ]),
                                  createVNode("div", { class: "flex gap-5" }, [
                                    step.value > 1 ? (openBlock(), createBlock(_component_rounded_button, {
                                      key: 0,
                                      design: "3",
                                      class: "mt-12",
                                      onClick: back
                                    }, {
                                      default: withCtx(() => [
                                        createTextVNode(" RETOUR ")
                                      ]),
                                      _: 1
                                    })) : createCommentVNode("", true),
                                    createVNode(_component_rounded_button, {
                                      design: "3",
                                      class: "mt-12",
                                      onClick: ($event) => stepValidation(4),
                                      disabled: !cgu.value,
                                      loading: loading.value
                                    }, {
                                      default: withCtx(() => [
                                        createTextVNode(" Cr\xE9er mon compte ")
                                      ]),
                                      _: 1
                                    }, 8, ["onClick", "disabled", "loading"])
                                  ])
                                ])
                              ])
                            ])
                          ])) : createCommentVNode("", true)
                        ]),
                        _: 1
                      })
                    ];
                  }
                }),
                _: 1
              }, _parent2, _scopeId));
            }
          } else {
            return [
              createVNode(_component_section_layer, {
                class: "bg-no-repeat max-[1735px]:hidden",
                style: { "background-position": "right 0 bottom 0" },
                background: "/images/ROND + PIN.png"
              }),
              createVNode("div", { class: "max-w-container relative z-[1] mx-auto max-xl:hidden" }, [
                (openBlock(), createBlock("svg", {
                  id: "Isolation_Mode",
                  class: "text-ternary-lightest absolute -right-[135rem] -top-[12rem] -mb-[2.3rem] hidden h-[39rem] bg-transparent opacity-40 lg:block",
                  "data-name": "Isolation Mode",
                  xmlns: "http://www.w3.org/2000/svg",
                  viewBox: "-2.699 -0.454 840.874 96.2841"
                }, [
                  createVNode("path", {
                    id: "Path_3622",
                    "data-name": "Path 3622",
                    class: `text-${_ctx.design}`,
                    fill: "currentColor",
                    d: "M 837.934 0.988 L 838.175 54.941 L 300.126 54.941 L 300.126 51.441 C 300.126 50.635 299.571 49.998 298.893 49.986 C 298.585 49.986 298.287 50.118 298.061 50.359 L 289.029 59.859 C 287.58 61.386 287.457 63.996 288.762 65.703 C 288.844 65.812 288.936 65.92 289.029 66.016 L 298.061 75.516 C 298.574 76.046 299.355 75.997 299.807 75.408 C 300.013 75.144 300.126 74.795 300.126 74.446 C 300.126 74.446 300.126 72.318 300.136 72.318 L 300.136 69.732 C 300.136 69.191 300.506 68.746 300.968 68.746 C 301.174 68.746 301.379 68.83 301.534 68.999 L 304.678 72.318 L 304.955 72.606 L 311.922 79.942 C 313.031 81.108 313.113 83.093 312.127 84.391 C 312.065 84.476 311.994 84.548 311.922 84.632 L 304.955 91.968 L 304.472 92.473 L 301.523 95.575 C 301.184 95.936 300.65 95.912 300.342 95.515 C 300.198 95.335 300.126 95.094 300.126 94.854 L 300.126 90.897 L -2.699 90.897 L -2.699 -0.454"
                  }, null, 2)
                ]))
              ]),
              registered.value ? (openBlock(), createBlock(_component_section_container, {
                key: 0,
                "mobile-padding": "",
                class: "max-w-container relative z-10 py-[15rem]"
              }, {
                default: withCtx(() => [
                  createVNode("div", { class: "h-75 flex items-center justify-center" }, [
                    createVNode("div", { class: "align-content-center flex flex-col items-center justify-center" }, [
                      createVNode(_component_icon, {
                        icon: "check",
                        class: "text-secondary border-secondary mb-10 h-[15rem] w-[15rem] rounded-full border-[1rem] p-10"
                      }),
                      createVNode("h2", { class: "text-secondary mb-8 text-center text-3xl font-bold" }, " Votre compte a \xE9t\xE9 cr\xE9\xE9 avec succ\xE8s ! "),
                      createVNode("p", { class: "text-primary-lighter text-center text-[2rem]" }, [
                        createTextVNode(" Il ne nous reste plus qu'\xE0 v\xE9rifier vos informations. Nous vous enverrons un email d\xE8s que votre compte sera valid\xE9."),
                        createVNode("br"),
                        createTextVNode(" Merci et \xE0 tr\xE8s bient\xF4t ! ")
                      ])
                    ])
                  ])
                ]),
                _: 1
              })) : (openBlock(), createBlock(_component_section_container, {
                key: 1,
                "mobile-padding": "",
                class: "max-w-container relative z-10 py-20"
              }, {
                default: withCtx(() => [
                  createVNode(Transition, {
                    name: "fade",
                    mode: "out-in",
                    "enter-active-class": "transition-opacity ease-in duration-700",
                    "enter-class": "opacity-0",
                    "enter-to-class": "opacity-100",
                    "leave-class": "opacity-0",
                    "leave-to-class": "opacity-0"
                  }, {
                    default: withCtx(() => [
                      step.value === 1 ? (openBlock(), createBlock("div", { key: "step1" }, [
                        createVNode("div", { class: "justify-center md:flex" }, [
                          createVNode("div", { class: "w-1/2" }, [
                            createVNode("div", { class: "col-span-6" }, [
                              createVNode(_component_register_section_title, {
                                title: "Cr\xE9ation de compte",
                                number: "01",
                                class: "mb-12",
                                progress: "33"
                              }),
                              createVNode("div", null, [
                                createVNode(_component_FormField, {
                                  class: "mb-4",
                                  name: "name",
                                  label: "Nom de l'entreprise",
                                  errors: validationErrors.value,
                                  required: "required"
                                }, {
                                  default: withCtx(() => [
                                    createVNode(_component_InputText, {
                                      modelValue: registerData.value.name,
                                      "onUpdate:modelValue": ($event) => registerData.value.name = $event,
                                      type: "text",
                                      placeholder: "Nom de l'entreprise",
                                      class: `w-full ${validationErrors.value.name ? "p-invalid" : ""}`,
                                      disabled: loading.value
                                    }, null, 8, ["modelValue", "onUpdate:modelValue", "class", "disabled"])
                                  ]),
                                  _: 1
                                }, 8, ["errors"]),
                                createVNode(_component_FormField, {
                                  class: "mb-4",
                                  name: "first_name",
                                  label: "Pr\xE9nom",
                                  errors: validationErrors.value,
                                  required: "required"
                                }, {
                                  default: withCtx(() => [
                                    createVNode(_component_InputText, {
                                      modelValue: registerData.value.first_name,
                                      "onUpdate:modelValue": ($event) => registerData.value.first_name = $event,
                                      type: "text",
                                      placeholder: "Pr\xE9nom",
                                      class: `w-full ${validationErrors.value.first_name ? "p-invalid" : ""}`,
                                      disabled: loading.value
                                    }, null, 8, ["modelValue", "onUpdate:modelValue", "class", "disabled"])
                                  ]),
                                  _: 1
                                }, 8, ["errors"]),
                                createVNode(_component_FormField, {
                                  class: "mb-4",
                                  name: "last_name",
                                  label: "Nom",
                                  errors: validationErrors.value,
                                  required: "required"
                                }, {
                                  default: withCtx(() => [
                                    createVNode(_component_InputText, {
                                      modelValue: registerData.value.last_name,
                                      "onUpdate:modelValue": ($event) => registerData.value.last_name = $event,
                                      type: "text",
                                      placeholder: "Nom",
                                      class: `w-full ${validationErrors.value.last_name ? "p-invalid" : ""}`,
                                      disabled: loading.value
                                    }, null, 8, ["modelValue", "onUpdate:modelValue", "class", "disabled"])
                                  ]),
                                  _: 1
                                }, 8, ["errors"]),
                                createVNode(_component_FormField, {
                                  class: "mb-4",
                                  name: "email",
                                  label: "Email",
                                  errors: validationErrors.value,
                                  required: "required"
                                }, {
                                  default: withCtx(() => [
                                    createVNode(_component_InputText, {
                                      modelValue: registerData.value.email,
                                      "onUpdate:modelValue": ($event) => registerData.value.email = $event,
                                      type: "email",
                                      placeholder: "Email",
                                      class: `w-full ${validationErrors.value.email ? "p-invalid" : ""}`,
                                      disabled: loading.value
                                    }, null, 8, ["modelValue", "onUpdate:modelValue", "class", "disabled"])
                                  ]),
                                  _: 1
                                }, 8, ["errors"]),
                                createVNode(_component_FormField, {
                                  class: "mb-4",
                                  name: "password",
                                  label: "Mot de passe",
                                  errors: validationErrors.value,
                                  required: "required"
                                }, {
                                  default: withCtx(() => [
                                    createVNode(_component_InputText, {
                                      modelValue: registerData.value.password,
                                      "onUpdate:modelValue": ($event) => registerData.value.password = $event,
                                      type: "password",
                                      placeholder: "Mot de passe",
                                      class: `w-full ${validationErrors.value.password ? "p-invalid" : ""}`,
                                      disabled: loading.value
                                    }, null, 8, ["modelValue", "onUpdate:modelValue", "class", "disabled"])
                                  ]),
                                  _: 1
                                }, 8, ["errors"]),
                                createVNode(_component_FormField, {
                                  name: "password_confirmation",
                                  label: "Confirmez votre mot de passe",
                                  errors: validationErrors.value,
                                  required: "required"
                                }, {
                                  default: withCtx(() => [
                                    createVNode(_component_InputText, {
                                      modelValue: registerData.value.password_confirmation,
                                      "onUpdate:modelValue": ($event) => registerData.value.password_confirmation = $event,
                                      type: "password",
                                      placeholder: "Confirmez votre mot de passe",
                                      class: `w-full ${validationErrors.value.password_confirmation ? "p-invalid" : ""}`,
                                      disabled: loading.value
                                    }, null, 8, ["modelValue", "onUpdate:modelValue", "class", "disabled"])
                                  ]),
                                  _: 1
                                }, 8, ["errors"])
                              ]),
                              createVNode("div", { class: "flex gap-5" }, [
                                createVNode(_component_rounded_button, {
                                  design: "3",
                                  class: "mt-12",
                                  onClick: ($event) => stepValidation(1),
                                  disabled: unref(hasValidationError)
                                }, {
                                  default: withCtx(() => [
                                    createTextVNode(" SUIVANT ")
                                  ]),
                                  _: 1
                                }, 8, ["onClick", "disabled"])
                              ])
                            ])
                          ])
                        ])
                      ])) : step.value === 2 ? (openBlock(), createBlock("div", { key: "step2" }, [
                        createVNode("div", { class: "justify-center md:flex" }, [
                          createVNode("div", { class: "w-1/2" }, [
                            createVNode(_component_register_section_title, {
                              title: "Information administrative",
                              number: "02",
                              progress: "66",
                              class: "mb-12"
                            }),
                            createVNode(_component_Message, { severity: "info" }, {
                              default: withCtx(() => [
                                createTextVNode(" Afin de nous conformer \xE0 la norme "),
                                createVNode("a", {
                                  class: "underline",
                                  href: "https://www.signicat.com/fr/blog/kyc-requirements-banks"
                                }, "KYC (Know Your Customer)"),
                                createTextVNode(", nous avons besoin de quelques informations suppl\xE9mentaires. ")
                              ]),
                              _: 1
                            }),
                            createVNode("div", null, [
                              createVNode(_component_FormField, {
                                class: "mb-4",
                                name: "siret",
                                label: "Num\xE9ro SIRET",
                                errors: validationErrors.value,
                                required: "required"
                              }, {
                                default: withCtx(() => [
                                  createVNode(_component_InputText, {
                                    modelValue: registerData.value.siret,
                                    "onUpdate:modelValue": ($event) => registerData.value.siret = $event,
                                    placeholder: "Num\xE9ro SIRET",
                                    class: `w-full ${validationErrors.value.siret ? "p-invalid" : ""}`,
                                    disabled: loading.value
                                  }, null, 8, ["modelValue", "onUpdate:modelValue", "class", "disabled"])
                                ]),
                                _: 1
                              }, 8, ["errors"]),
                              createVNode(_component_FormField, {
                                class: "mb-4",
                                name: "kbis",
                                label: "Extrait Kbis",
                                errors: validationErrors.value,
                                required: "required"
                              }, {
                                default: withCtx(() => [
                                  registerData.value.kbis ? (openBlock(), createBlock("div", {
                                    key: 0,
                                    class: "bg-ternary-lightest text-primary flex items-center justify-between gap-3 rounded p-3"
                                  }, [
                                    createVNode("span", { class: "font-normal" }, toDisplayString(registerData.value.kbis.name), 1),
                                    createVNode("span", {
                                      onClick: ($event) => registerData.value.kbis = null,
                                      class: "cursor-pointer font-normal"
                                    }, "Supprimer", 8, ["onClick"])
                                  ])) : createCommentVNode("", true),
                                  !registerData.value.kbis ? (openBlock(), createBlock(unref(script), {
                                    key: 1,
                                    onUploader: (e) => {
                                      registerData.value.kbis = e.files[0];
                                    },
                                    accept: "application/pdf",
                                    name: "kbis",
                                    auto: "",
                                    mode: "basic",
                                    modelValue: registerData.value.kbis,
                                    "onUpdate:modelValue": ($event) => registerData.value.kbis = $event,
                                    "choose-label": "S\xE9lectionner l'Extrait Kbis",
                                    customUpload: true,
                                    disabled: loading.value,
                                    pt: {
                                      chooseButton: { style: "background-color: #96B938 " }
                                    }
                                  }, null, 8, ["onUploader", "modelValue", "onUpdate:modelValue", "disabled"])) : createCommentVNode("", true)
                                ]),
                                _: 1
                              }, 8, ["errors"]),
                              createVNode(_component_FormField, {
                                class: "mb-4",
                                name: "address",
                                label: "Adresse",
                                errors: validationErrors.value,
                                required: "required"
                              }, {
                                default: withCtx(() => [
                                  createVNode(_component_InputText, {
                                    modelValue: registerData.value.address,
                                    "onUpdate:modelValue": ($event) => registerData.value.address = $event,
                                    type: "text",
                                    placeholder: "Adresse",
                                    class: `w-full ${validationErrors.value.address ? "p-invalid" : ""}`,
                                    disabled: loading.value
                                  }, null, 8, ["modelValue", "onUpdate:modelValue", "class", "disabled"])
                                ]),
                                _: 1
                              }, 8, ["errors"]),
                              createVNode(_component_FormField, {
                                class: "mb-4",
                                name: "city",
                                label: "Ville",
                                errors: validationErrors.value,
                                required: "required"
                              }, {
                                default: withCtx(() => [
                                  createVNode(CitySelectField, {
                                    placeholder: "Ville",
                                    modelValue: registerData.value.city,
                                    "onUpdate:modelValue": ($event) => registerData.value.city = $event,
                                    disabled: loading.value,
                                    class: `w-full ${validationErrors.value.city ? "p-invalid" : ""}`
                                  }, null, 8, ["modelValue", "onUpdate:modelValue", "disabled", "class"])
                                ]),
                                _: 1
                              }, 8, ["errors"]),
                              createVNode(_component_FormField, {
                                name: "phone",
                                label: "T\xE9l\xE9phone fixe",
                                class: "mb-4",
                                errors: validationErrors.value,
                                required: "required"
                              }, {
                                default: withCtx(() => [
                                  createVNode(_component_InputMask, {
                                    placeholder: "T\xE9l\xE9phone fixe",
                                    mask: "99 99 99 99 99",
                                    disabled: loading.value,
                                    unmask: "",
                                    modelValue: registerData.value.phone,
                                    "onUpdate:modelValue": ($event) => registerData.value.phone = $event,
                                    class: `w-full ${validationErrors.value.phone ? "p-invalid" : ""}`
                                  }, null, 8, ["disabled", "modelValue", "onUpdate:modelValue", "class"])
                                ]),
                                _: 1
                              }, 8, ["errors"]),
                              createVNode(_component_FormField, {
                                name: "mobile",
                                label: "T\xE9l\xE9phone mobile",
                                class: "mb-4",
                                errors: validationErrors.value,
                                required: "required"
                              }, {
                                default: withCtx(() => [
                                  createVNode(_component_InputMask, {
                                    placeholder: "T\xE9l\xE9phone mobile",
                                    mask: "+33 (9)9 99 99 99 99",
                                    unmask: "",
                                    modelValue: registerData.value.mobile,
                                    "onUpdate:modelValue": ($event) => registerData.value.mobile = $event,
                                    class: `w-full ${validationErrors.value.mobile ? "p-invalid" : ""}`,
                                    disabled: loading.value
                                  }, null, 8, ["modelValue", "onUpdate:modelValue", "class", "disabled"])
                                ]),
                                _: 1
                              }, 8, ["errors"]),
                              createVNode(_component_FormField, {
                                class: "mb-4",
                                name: "clearance",
                                label: "Habilitation",
                                errors: validationErrors.value,
                                required: "required"
                              }, {
                                default: withCtx(() => [
                                  registerData.value.clearance ? (openBlock(), createBlock("div", {
                                    key: 0,
                                    class: "bg-ternary-lightest text-primary flex items-center justify-between gap-3 rounded p-3"
                                  }, [
                                    createVNode("span", { class: "font-normal" }, toDisplayString(registerData.value.clearance.name), 1),
                                    createVNode("span", {
                                      onClick: ($event) => registerData.value.clearance = null,
                                      class: "cursor-pointer font-normal"
                                    }, "Supprimer", 8, ["onClick"])
                                  ])) : createCommentVNode("", true),
                                  !registerData.value.clearance ? (openBlock(), createBlock(unref(script), {
                                    key: 1,
                                    onUploader: (e) => {
                                      registerData.value.clearance = e.files[0];
                                    },
                                    accept: "application/pdf",
                                    name: "clearance",
                                    auto: "",
                                    mode: "basic",
                                    modelValue: registerData.value.clearance,
                                    "onUpdate:modelValue": ($event) => registerData.value.clearance = $event,
                                    "choose-label": "Habilitation",
                                    customUpload: true,
                                    pt: {
                                      chooseButton: { style: "background-color: #96B938 " }
                                    },
                                    disabled: loading.value
                                  }, null, 8, ["onUploader", "modelValue", "onUpdate:modelValue", "disabled"])) : createCommentVNode("", true)
                                ]),
                                _: 1
                              }, 8, ["errors"]),
                              createVNode(_component_FormField, {
                                class: "mb-4",
                                name: "clearance_expires_at",
                                required: "required",
                                label: "Date de fin de validit\xE9 de l'habilitation",
                                errors: validationErrors.value
                              }, {
                                default: withCtx(() => [
                                  createVNode("div", { class: "p-input-icon-right" }, [
                                    createVNode("i", { class: "pi pi-pencil" }),
                                    createVNode(unref(script$J), {
                                      disabled: loading.value,
                                      dateFormat: "dd/mm/yy",
                                      "hour-format": "24",
                                      showIcon: "",
                                      modelValue: registerData.value.clearance_expires_at,
                                      "onUpdate:modelValue": ($event) => registerData.value.clearance_expires_at = $event,
                                      "min-date": unref(dayjs)().toDate(),
                                      placeholder: "Date de fin de validit\xE9 de l'habilitation",
                                      class: `w-full ${validationErrors.value.clearance_expires_at ? "p-invalid" : ""}`
                                    }, null, 8, ["disabled", "modelValue", "onUpdate:modelValue", "min-date", "class"])
                                  ])
                                ]),
                                _: 1
                              }, 8, ["errors"])
                            ]),
                            createVNode("div", { class: "flex gap-5" }, [
                              step.value > 1 ? (openBlock(), createBlock(_component_rounded_button, {
                                key: 0,
                                design: "3",
                                class: "mt-12",
                                onClick: back
                              }, {
                                default: withCtx(() => [
                                  createTextVNode(" RETOUR ")
                                ]),
                                _: 1
                              })) : createCommentVNode("", true),
                              createVNode(_component_rounded_button, {
                                design: "3",
                                class: "mt-12",
                                onClick: ($event) => stepValidation(2),
                                disabled: unref(hasValidationError)
                              }, {
                                default: withCtx(() => [
                                  createTextVNode(" SUIVANT ")
                                ]),
                                _: 1
                              }, 8, ["onClick", "disabled"])
                            ])
                          ])
                        ])
                      ])) : step.value === 3 ? (openBlock(), createBlock("div", { key: "step4" }, [
                        createVNode("div", { class: "justify-center md:flex" }, [
                          createVNode("div", { class: "w-1/2" }, [
                            createVNode(_component_register_section_title, {
                              title: "Moyen de paiement",
                              number: "03",
                              progress: "100",
                              class: "mb-12"
                            }),
                            createVNode("div", null, [
                              createVNode(_component_AddPaymentMethod, {
                                annualy: registerData.value.annual_billing,
                                price: unref(price),
                                ref_key: "addPayment",
                                ref: addPayment,
                                class: "mb-12",
                                "onUpdate:promoCodeId": ($event) => promocodeId.value = $event
                              }, null, 8, ["annualy", "price", "onUpdate:promoCodeId"]),
                              createVNode("div", { class: "flex items-center" }, [
                                withDirectives(createVNode("input", {
                                  id: "cgv",
                                  type: "checkbox",
                                  "onUpdate:modelValue": ($event) => cgu.value = $event,
                                  class: "mr-2"
                                }, null, 8, ["onUpdate:modelValue"]), [
                                  [vModelCheckbox, cgu.value]
                                ]),
                                createVNode("label", {
                                  for: "cgv",
                                  class: "text-primary"
                                }, [
                                  createTextVNode("J'ai lu et j'accepte les "),
                                  createVNode(_component_NuxtLink, {
                                    class: "text-secondary underline",
                                    target: "_blank",
                                    to: "/cgu"
                                  }, {
                                    default: withCtx(() => [
                                      createTextVNode("conditions g\xE9n\xE9rales de ventes")
                                    ]),
                                    _: 1
                                  })
                                ])
                              ]),
                              createVNode("div", { class: "flex gap-5" }, [
                                step.value > 1 ? (openBlock(), createBlock(_component_rounded_button, {
                                  key: 0,
                                  design: "3",
                                  class: "mt-12",
                                  onClick: back
                                }, {
                                  default: withCtx(() => [
                                    createTextVNode(" RETOUR ")
                                  ]),
                                  _: 1
                                })) : createCommentVNode("", true),
                                createVNode(_component_rounded_button, {
                                  design: "3",
                                  class: "mt-12",
                                  onClick: ($event) => stepValidation(4),
                                  disabled: !cgu.value,
                                  loading: loading.value
                                }, {
                                  default: withCtx(() => [
                                    createTextVNode(" Cr\xE9er mon compte ")
                                  ]),
                                  _: 1
                                }, 8, ["onClick", "disabled", "loading"])
                              ])
                            ])
                          ])
                        ])
                      ])) : createCommentVNode("", true)
                    ]),
                    _: 1
                  })
                ]),
                _: 1
              }))
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div>`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("pages/auth/register.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as default };
//# sourceMappingURL=register-7070a2d6.mjs.map
