import { _ as __nuxt_component_0, a as __nuxt_component_1 } from './SectionContainer-5a7aa7e3.mjs';
import { _ as __nuxt_component_4$2 } from './FormTitle-afe32d73.mjs';
import { _ as __nuxt_component_3 } from './Spinner-653832cb.mjs';
import { _ as __nuxt_component_0$1, a as __nuxt_component_3$2 } from './Price-aaf3d10e.mjs';
import { _ as __nuxt_component_3$1 } from './Icon-7157bd57.mjs';
import { _ as __nuxt_component_8 } from './RoundedButton-a0ea68b9.mjs';
import { _ as __nuxt_component_0$2 } from './SectionTitle-2692cd9d.mjs';
import { d as useConfirm, b as script$5, a as useNuxtApp } from '../server.mjs';
import { ref, computed, withCtx, unref, createVNode, toDisplayString, createTextVNode, openBlock, createBlock, Fragment, renderList, useSSRContext, resolveComponent, mergeProps, createCommentVNode } from 'vue';
import { ssrRenderComponent, ssrRenderClass, ssrInterpolate, ssrRenderList, ssrRenderAttr } from 'vue/server-renderer';
import { s as script } from './checkbox.esm-59d1629e.mjs';
import { u as useAuthStore } from './auth-6d0727c5.mjs';
import './dayjs-9d0b29d3.mjs';
import './config-f619f9d4.mjs';
import 'ofetch';
import 'hookable';
import 'unctx';
import 'vue-router';
import 'h3';
import 'ufo';
import '@unhead/ssr';
import 'unhead';
import '@unhead/shared';
import 'dayjs';
import 'dayjs/plugin/relativeTime.js';
import 'dayjs/plugin/utc.js';
import 'dayjs/plugin/timezone.js';
import '@headlessui/vue';
import 'vue-i18n';
import 'defu';
import '../../nitro/node-server.mjs';
import 'node-fetch-native/polyfill';
import 'node:http';
import 'node:https';
import 'destr';
import 'unenv/runtime/fetch/index';
import 'scule';
import 'klona';
import 'ohash';
import 'unstorage';
import 'radix3';
import 'node:fs';
import 'node:url';
import 'pathe';
import 'http-graceful-shutdown';

const _sfc_main$2 = {
  __name: "ConfirmCompletedRouteClientModal",
  __ssrInlineRender: true,
  props: {
    opened: {
      type: Boolean,
      default: false
    },
    reservation: {
      type: Object,
      required: true
    }
  },
  emits: ["confirm", "close"],
  setup(__props, { emit }) {
    const props = __props;
    const checked = ref();
    const { $api, $event, $toast } = useNuxtApp();
    const error = ref(null);
    const loading = ref(false);
    const markReservationAsCompleted = async () => {
      loading.value = true;
      try {
        await $api.call(
          "post",
          $api.route("reservation.completed", {
            reservation: props.reservation.id
          })
        );
        $toast.success("Le trajet a bien \xE9t\xE9 marqu\xE9 comme termin\xE9");
        $event("reservation.completed");
        emit("close");
      } catch (e) {
        $toast.error("Une erreur est survenue");
        error.value = e.response.data.message;
      } finally {
        loading.value = false;
      }
    };
    return (_ctx, _push, _parent, _attrs) => {
      const _component_section_title = __nuxt_component_0$2;
      const _component_Message = resolveComponent("Message");
      const _component_rounded_button = __nuxt_component_8;
      _push(ssrRenderComponent(unref(script$5), mergeProps({
        "dismissable-mask": "",
        visible: __props.opened,
        modal: "",
        class: "max-md:w-full",
        pt: {
          header: { style: " display:none" },
          content: { style: "padding: 0 !important;border-radius: 10px " },
          root: {
            style: "padding: 20px"
          }
        }
      }, _attrs), {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<div class="flex h-full flex-col justify-between p-10"${_scopeId}><div class="flex justify-end"${_scopeId}><button class="bg-background-3 text-primary flex h-8 w-8 items-center justify-center rounded-full"${_scopeId}><span class="font-bold"${_scopeId}>X</span></button></div><div class="mb-5 flex justify-center"${_scopeId}>`);
            _push2(ssrRenderComponent(_component_section_title, { class: "justify-center" }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`Terminer le trajet`);
                } else {
                  return [
                    createTextVNode("Terminer le trajet")
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
            _push2(`</div>`);
            if (error.value) {
              _push2(ssrRenderComponent(_component_Message, { severity: "error" }, {
                default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    _push3(`${ssrInterpolate(error.value)}`);
                  } else {
                    return [
                      createTextVNode(toDisplayString(error.value), 1)
                    ];
                  }
                }),
                _: 1
              }, _parent2, _scopeId));
            } else {
              _push2(`<!---->`);
            }
            _push2(`<div${_scopeId}> Veuillez confirmer que votre trajet s&#39;est d\xE9roul\xE9 conform\xE9ment \xE0 vos attentes.<br${_scopeId}><br${_scopeId}> En confirmant, vous attestez de la satisfaction du transport et autorisez<br${_scopeId}> le d\xE9clenchement du processus de paiement.<br${_scopeId}><br${_scopeId}> Cette action est irr\xE9versible.<br${_scopeId}><br${_scopeId}> La facture correspondante sera disponible d\xE8s que le transporteur l&#39;aura mise en ligne. </div><div class="align-items-center my-10 flex"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(script), {
              modelValue: checked.value,
              "onUpdate:modelValue": ($event2) => checked.value = $event2,
              name: "checked",
              inputId: "checked",
              binary: true,
              class: "mr-2"
            }, null, _parent2, _scopeId));
            _push2(`<label for="checked"${_scopeId}>J&#39;atteste que le trajet s&#39;est d\xE9roul\xE9 conform\xE9ment \xE0 mes attentes</label></div>`);
            _push2(ssrRenderComponent(_component_rounded_button, {
              onClick: markReservationAsCompleted,
              loading: loading.value,
              class: "max-md:px-24",
              design: "4",
              icon: "check",
              disabled: !checked.value
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(` Terminer ce trajet `);
                } else {
                  return [
                    createTextVNode(" Terminer ce trajet ")
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
            _push2(`</div>`);
          } else {
            return [
              createVNode("div", { class: "flex h-full flex-col justify-between p-10" }, [
                createVNode("div", { class: "flex justify-end" }, [
                  createVNode("button", {
                    class: "bg-background-3 text-primary flex h-8 w-8 items-center justify-center rounded-full",
                    onClick: ($event2) => _ctx.$emit("close")
                  }, [
                    createVNode("span", { class: "font-bold" }, "X")
                  ], 8, ["onClick"])
                ]),
                createVNode("div", { class: "mb-5 flex justify-center" }, [
                  createVNode(_component_section_title, { class: "justify-center" }, {
                    default: withCtx(() => [
                      createTextVNode("Terminer le trajet")
                    ]),
                    _: 1
                  })
                ]),
                error.value ? (openBlock(), createBlock(_component_Message, {
                  key: 0,
                  severity: "error"
                }, {
                  default: withCtx(() => [
                    createTextVNode(toDisplayString(error.value), 1)
                  ]),
                  _: 1
                })) : createCommentVNode("", true),
                createVNode("div", null, [
                  createTextVNode(" Veuillez confirmer que votre trajet s'est d\xE9roul\xE9 conform\xE9ment \xE0 vos attentes."),
                  createVNode("br"),
                  createVNode("br"),
                  createTextVNode(" En confirmant, vous attestez de la satisfaction du transport et autorisez"),
                  createVNode("br"),
                  createTextVNode(" le d\xE9clenchement du processus de paiement."),
                  createVNode("br"),
                  createVNode("br"),
                  createTextVNode(" Cette action est irr\xE9versible."),
                  createVNode("br"),
                  createVNode("br"),
                  createTextVNode(" La facture correspondante sera disponible d\xE8s que le transporteur l'aura mise en ligne. ")
                ]),
                createVNode("div", { class: "align-items-center my-10 flex" }, [
                  createVNode(unref(script), {
                    modelValue: checked.value,
                    "onUpdate:modelValue": ($event2) => checked.value = $event2,
                    name: "checked",
                    inputId: "checked",
                    binary: true,
                    class: "mr-2"
                  }, null, 8, ["modelValue", "onUpdate:modelValue"]),
                  createVNode("label", { for: "checked" }, "J'atteste que le trajet s'est d\xE9roul\xE9 conform\xE9ment \xE0 mes attentes")
                ]),
                createVNode(_component_rounded_button, {
                  onClick: markReservationAsCompleted,
                  loading: loading.value,
                  class: "max-md:px-24",
                  design: "4",
                  icon: "check",
                  disabled: !checked.value
                }, {
                  default: withCtx(() => [
                    createTextVNode(" Terminer ce trajet ")
                  ]),
                  _: 1
                }, 8, ["loading", "disabled"])
              ])
            ];
          }
        }),
        _: 1
      }, _parent));
    };
  }
};
const _sfc_setup$2 = _sfc_main$2.setup;
_sfc_main$2.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/modals/ConfirmCompletedRouteClientModal.vue");
  return _sfc_setup$2 ? _sfc_setup$2(props, ctx) : void 0;
};
const __nuxt_component_4$1 = _sfc_main$2;
const _sfc_main$1 = {
  __name: "ReservationCard",
  __ssrInlineRender: true,
  props: {
    reservation: {
      type: Object,
      required: true
    }
  },
  setup(__props) {
    const props = __props;
    const { $api, $event, $toast, $stripe } = useNuxtApp();
    const cancelling = ref(false);
    const confirm = useConfirm();
    ref(false);
    const cancelReservation = async () => {
      confirm.require({
        group: "confirmation",
        message: "\xCAtes-vous s\xFBr de vouloir annuler cette r\xE9servation ?",
        header: "Annulation",
        icon: "pi pi-trash text-red-500",
        acceptClass: "p-button-danger p-button-text",
        acceptLabel: "Oui",
        acceptIcon: "pi pi-trash",
        rejectClass: "p-button-text",
        rejectLabel: "Non",
        rejectIcon: "pi pi-times",
        accept: async () => {
          cancelling.value = true;
          try {
            await $api.call(
              "post",
              $api.route("reservation.cancel", {
                reservation: props.reservation.id
              })
            );
            $toast.success("La r\xE9servation a bien \xE9t\xE9 annul\xE9e");
          } catch (e) {
            $toast.error("Une erreur est survenue");
          } finally {
            cancelling.value = false;
          }
          $event("reservation.cancelled", props.reservation);
        },
        reject() {
        }
      });
    };
    const modalIsOpen = ref(false);
    return (_ctx, _push, _parent, _attrs) => {
      const _component_base_route_card = __nuxt_component_0$1;
      const _component_icon = __nuxt_component_3$1;
      const _component_Button = resolveComponent("Button");
      const _component_price = __nuxt_component_3$2;
      const _component_rounded_button = __nuxt_component_8;
      const _component_confirm_completed_route_client_modal = __nuxt_component_4$1;
      _push(ssrRenderComponent(_component_base_route_card, mergeProps({ route: __props.reservation }, _attrs), {
        main: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<div class="flex"${_scopeId}><div class="flex max-h-full text-[1.1rem] lg:mr-20"${_scopeId}>`);
            if (__props.reservation.status === "pending") {
              _push2(`<div class="flex flex-col"${_scopeId}><div class="mb-5"${_scopeId}>`);
              _push2(ssrRenderComponent(_component_icon, {
                icon: "vos-conditions ",
                class: "text-fire mr-2 h-5 w-5"
              }, null, _parent2, _scopeId));
              _push2(`<span${_scopeId}>En attente de validation</span></div>`);
              _push2(ssrRenderComponent(_component_Button, {
                severity: "danger",
                type: "button",
                onClick: cancelReservation,
                outlined: "",
                label: "Annuler ma r\xE9servation",
                icon: "pi pi-trash"
              }, null, _parent2, _scopeId));
              _push2(`</div>`);
            } else if (__props.reservation.status === "accepted") {
              _push2(`<div class="align-items-center flex"${_scopeId}>`);
              _push2(ssrRenderComponent(_component_icon, {
                icon: "check",
                class: "mr-2 h-5 w-5 text-green-500"
              }, null, _parent2, _scopeId));
              _push2(`<span${_scopeId}>R\xE9servation valid\xE9e</span></div>`);
            } else if (__props.reservation.status === "refused") {
              _push2(`<div class="flex items-center"${_scopeId}>`);
              _push2(ssrRenderComponent(_component_icon, {
                icon: "remove",
                class: "mr-2 h-5 w-5 text-red-500"
              }, null, _parent2, _scopeId));
              _push2(`<span${_scopeId}>R\xE9servation refus\xE9e</span></div>`);
            } else if (__props.reservation.status === "cancelled") {
              _push2(`<div class="flex items-center"${_scopeId}>`);
              _push2(ssrRenderComponent(_component_icon, {
                icon: "close",
                class: "mr-2 h-5 w-5 text-red-500"
              }, null, _parent2, _scopeId));
              _push2(`<span${_scopeId}>R\xE9servation annul\xE9e</span></div>`);
            } else if (__props.reservation.status === "completed") {
              _push2(`<div class="align-items-center flex-col"${_scopeId}><div class="mb-5 flex items-center"${_scopeId}>`);
              _push2(ssrRenderComponent(_component_icon, {
                icon: "check",
                class: "mr-4 h-5 w-5 text-green-500"
              }, null, _parent2, _scopeId));
              _push2(`<span${_scopeId}>Trajet termin\xE9</span></div>`);
              if (__props.reservation.invoice) {
                _push2(`<div${_scopeId}><a class="bg-secondary mb-2 flex items-center justify-between gap-3 rounded p-3 px-5 font-bold text-white" target="_blank"${ssrRenderAttr("href", __props.reservation.invoice)}${_scopeId}><i class="pi pi-eye"${_scopeId}></i><span class="grow text-center"${_scopeId}>Voir la facture</span></a></div>`);
              } else {
                _push2(`<!---->`);
              }
              _push2(`</div>`);
            } else if (__props.reservation.status === "expired") {
              _push2(`<div class="flex items-center"${_scopeId}>`);
              _push2(ssrRenderComponent(_component_icon, {
                icon: "close",
                class: "mr-2 h-5 w-5 text-red-500"
              }, null, _parent2, _scopeId));
              _push2(`<span${_scopeId}>R\xE9servation expir\xE9e</span></div>`);
            } else {
              _push2(`<!---->`);
            }
            _push2(`</div><div class="flex"${_scopeId}>`);
            _push2(ssrRenderComponent(_component_price, {
              pricing: __props.reservation.pricing
            }, null, _parent2, _scopeId));
            _push2(`</div></div>`);
          } else {
            return [
              createVNode("div", { class: "flex" }, [
                createVNode("div", { class: "flex max-h-full text-[1.1rem] lg:mr-20" }, [
                  __props.reservation.status === "pending" ? (openBlock(), createBlock("div", {
                    key: 0,
                    class: "flex flex-col"
                  }, [
                    createVNode("div", { class: "mb-5" }, [
                      createVNode(_component_icon, {
                        icon: "vos-conditions ",
                        class: "text-fire mr-2 h-5 w-5"
                      }),
                      createVNode("span", null, "En attente de validation")
                    ]),
                    createVNode(_component_Button, {
                      severity: "danger",
                      type: "button",
                      onClick: cancelReservation,
                      outlined: "",
                      label: "Annuler ma r\xE9servation",
                      icon: "pi pi-trash"
                    })
                  ])) : __props.reservation.status === "accepted" ? (openBlock(), createBlock("div", {
                    key: 1,
                    class: "align-items-center flex"
                  }, [
                    createVNode(_component_icon, {
                      icon: "check",
                      class: "mr-2 h-5 w-5 text-green-500"
                    }),
                    createVNode("span", null, "R\xE9servation valid\xE9e")
                  ])) : __props.reservation.status === "refused" ? (openBlock(), createBlock("div", {
                    key: 2,
                    class: "flex items-center"
                  }, [
                    createVNode(_component_icon, {
                      icon: "remove",
                      class: "mr-2 h-5 w-5 text-red-500"
                    }),
                    createVNode("span", null, "R\xE9servation refus\xE9e")
                  ])) : __props.reservation.status === "cancelled" ? (openBlock(), createBlock("div", {
                    key: 3,
                    class: "flex items-center"
                  }, [
                    createVNode(_component_icon, {
                      icon: "close",
                      class: "mr-2 h-5 w-5 text-red-500"
                    }),
                    createVNode("span", null, "R\xE9servation annul\xE9e")
                  ])) : __props.reservation.status === "completed" ? (openBlock(), createBlock("div", {
                    key: 4,
                    class: "align-items-center flex-col"
                  }, [
                    createVNode("div", { class: "mb-5 flex items-center" }, [
                      createVNode(_component_icon, {
                        icon: "check",
                        class: "mr-4 h-5 w-5 text-green-500"
                      }),
                      createVNode("span", null, "Trajet termin\xE9")
                    ]),
                    __props.reservation.invoice ? (openBlock(), createBlock("div", { key: 0 }, [
                      createVNode("a", {
                        class: "bg-secondary mb-2 flex items-center justify-between gap-3 rounded p-3 px-5 font-bold text-white",
                        target: "_blank",
                        href: __props.reservation.invoice
                      }, [
                        createVNode("i", { class: "pi pi-eye" }),
                        createVNode("span", { class: "grow text-center" }, "Voir la facture")
                      ], 8, ["href"])
                    ])) : createCommentVNode("", true)
                  ])) : __props.reservation.status === "expired" ? (openBlock(), createBlock("div", {
                    key: 5,
                    class: "flex items-center"
                  }, [
                    createVNode(_component_icon, {
                      icon: "close",
                      class: "mr-2 h-5 w-5 text-red-500"
                    }),
                    createVNode("span", null, "R\xE9servation expir\xE9e")
                  ])) : createCommentVNode("", true)
                ]),
                createVNode("div", { class: "flex" }, [
                  createVNode(_component_price, {
                    pricing: __props.reservation.pricing
                  }, null, 8, ["pricing"])
                ])
              ])
            ];
          }
        }),
        footer: withCtx((_, _push2, _parent2, _scopeId) => {
          var _a, _b, _c, _d, _e, _f, _g, _h, _i, _j, _k, _l, _m, _n, _o, _p, _q, _r, _s, _t;
          if (_push2) {
            _push2(`<div class="mb-5 flex gap-5 border-b-2 border-dotted pb-5"${_scopeId}><div class="flex max-md:mb-5"${_scopeId}>`);
            _push2(ssrRenderComponent(_component_icon, {
              icon: "lit",
              class: "text-primary-light mr-3 h-6 w-6"
            }, null, _parent2, _scopeId));
            if (__props.reservation.vehicle.type === "before_coffin") {
              _push2(`<span${_scopeId}> Transport avant et apr\xE8s mise en bi\xE8re</span>`);
            } else {
              _push2(`<!---->`);
            }
            if (__props.reservation.vehicle.type === "after_coffin") {
              _push2(`<span${_scopeId}> Transport apr\xE8s mise en bi\xE8re</span>`);
            } else {
              _push2(`<!---->`);
            }
            _push2(`</div><div class="flex max-md:mb-5"${_scopeId}>`);
            _push2(ssrRenderComponent(_component_icon, {
              icon: "dimensions",
              class: "text-primary-light mr-3 h-6 w-6"
            }, null, _parent2, _scopeId));
            if (__props.reservation.vehicle.is_standard_size) {
              _push2(`<span${_scopeId}> Supporte des tailles standards uniquement (&lt; ou = \xE0 195cm x 60cm)</span>`);
            } else {
              _push2(`<span${_scopeId}>Supporte des tailles hors normes (&gt; \xE0 195cm x l60cm)</span>`);
            }
            _push2(`</div></div>`);
            if (__props.reservation.status == "accepted" || __props.reservation.status == "completed") {
              _push2(`<div${_scopeId}><div class="text-neutral-lighter flex justify-between"${_scopeId}><div${_scopeId}><div class="col-span-6 mb-2 flex gap-1"${_scopeId}>`);
              _push2(ssrRenderComponent(_component_icon, {
                icon: "voiture",
                class: "text-primary-light mr-3 h-6 w-6"
              }, null, _parent2, _scopeId));
              _push2(`<b${_scopeId}>V\xE9hicule pr\xE9vu :</b> ${ssrInterpolate((_a = __props.reservation.vehicle) == null ? void 0 : _a.name)}</div><div class="col-span-6 mb-2 flex gap-1"${_scopeId}>`);
              _push2(ssrRenderComponent(_component_icon, {
                icon: "voiture",
                class: "text-primary-light mr-3 h-6 w-6"
              }, null, _parent2, _scopeId));
              _push2(`<b${_scopeId}>Immatriculation :</b> ${ssrInterpolate((_b = __props.reservation.vehicle) == null ? void 0 : _b.license_plate)}</div><div class="mb-2 flex gap-1"${_scopeId}>`);
              _push2(ssrRenderComponent(_component_icon, {
                icon: "profil",
                class: "text-primary-light mr-3 h-6 w-6"
              }, null, _parent2, _scopeId));
              _push2(`<b${_scopeId}>Chauffeur pr\xE9vu :</b> ${ssrInterpolate((_c = __props.reservation.operator) == null ? void 0 : _c.identifier)}</div><div class="mb-2 flex gap-1"${_scopeId}>`);
              _push2(ssrRenderComponent(_component_icon, {
                icon: "telephone",
                class: "text-primary-light mr-3 h-6 w-6"
              }, null, _parent2, _scopeId));
              _push2(`<b${_scopeId}>T\xE9l\xE9phone du chauffeur :</b> ${ssrInterpolate((_d = __props.reservation.operator) == null ? void 0 : _d.phone)}</div><div class="mb-2 flex"${_scopeId}>`);
              _push2(ssrRenderComponent(_component_icon, {
                icon: "telephone-fixe",
                class: "text-primary-light mr-3 h-6 w-6"
              }, null, _parent2, _scopeId));
              _push2(`<b${_scopeId}>T\xE9l\xE9phone fixe :</b> ${ssrInterpolate(__props.reservation.creator.phone)}</div></div><div${_scopeId}><div class="mb-2 flex gap-1"${_scopeId}>`);
              _push2(ssrRenderComponent(_component_icon, {
                icon: "profil",
                class: "text-primary-light mr-3 h-6 w-6"
              }, null, _parent2, _scopeId));
              _push2(`<b${_scopeId}>R\xE9f\xE9rence :</b> ${ssrInterpolate(__props.reservation.reference)}</div><div class="mb-2 flex gap-1"${_scopeId}>`);
              _push2(ssrRenderComponent(_component_icon, {
                icon: "telephone",
                class: "text-primary-light mr-3 h-6 w-6"
              }, null, _parent2, _scopeId));
              _push2(`<b${_scopeId}>T\xE9l\xE9phone mobile :</b> ${ssrInterpolate(__props.reservation.creator.mobile)}</div><div class="mb-2 flex gap-1"${_scopeId}>`);
              _push2(ssrRenderComponent(_component_icon, {
                icon: "profil",
                class: "text-primary-light mr-3 h-6 w-6"
              }, null, _parent2, _scopeId));
              _push2(`<b${_scopeId}>Soci\xE9t\xE9 :</b> ${ssrInterpolate(__props.reservation.creator.name)}</div><div class="col-span-12 md:col-span-6"${_scopeId}><div class="mb-2.5 flex"${_scopeId}><div${_scopeId}>`);
              _push2(ssrRenderComponent(_component_icon, {
                icon: "info",
                class: "text-primary-light mr-3 h-6 w-6"
              }, null, _parent2, _scopeId));
              _push2(`</div><div${_scopeId}><span${_scopeId}><b${_scopeId}>Adresse soci\xE9t\xE9: </b>${ssrInterpolate(__props.reservation.creator.address)} ${ssrInterpolate(__props.reservation.creator.city.zip_code)} ${ssrInterpolate(__props.reservation.creator.city.name)}</span></div></div></div></div><div class="max-md:align-center col-span-12 md:col-span-6"${_scopeId}>`);
              if ((_f = (_e = __props.reservation.route) == null ? void 0 : _e.company) == null ? void 0 : _f.name) {
                _push2(`<div class="mb-2 flex gap-1"${_scopeId}>`);
                _push2(ssrRenderComponent(_component_icon, {
                  icon: "profil",
                  class: "text-primary-light mr-3 h-6 w-6"
                }, null, _parent2, _scopeId));
                _push2(`<span class="font-bold"${_scopeId}>Soc\xE9t\xE9:</span> ${ssrInterpolate(__props.reservation.route.company.name)}</div>`);
              } else {
                _push2(`<!---->`);
              }
              if ((_h = (_g = __props.reservation.route) == null ? void 0 : _g.company) == null ? void 0 : _h.phone) {
                _push2(`<div class="mb-2 flex gap-1"${_scopeId}>`);
                _push2(ssrRenderComponent(_component_icon, {
                  icon: "profil",
                  class: "text-primary-light mr-3 h-6 w-6"
                }, null, _parent2, _scopeId));
                _push2(`<span class="font-bold"${_scopeId}>T\xE9l : </span>${ssrInterpolate(__props.reservation.route.company.phone)}</div>`);
              } else {
                _push2(`<!---->`);
              }
              if ((_j = (_i = __props.reservation.route) == null ? void 0 : _i.company) == null ? void 0 : _j.mobile) {
                _push2(`<div class="mb-2 flex gap-1"${_scopeId}>`);
                _push2(ssrRenderComponent(_component_icon, {
                  icon: "profil",
                  class: "text-primary-light mr-3 h-6 w-6"
                }, null, _parent2, _scopeId));
                _push2(`<span class="font-bold"${_scopeId}>Mobile :</span>${ssrInterpolate(__props.reservation.route.company.mobile)}</div>`);
              } else {
                _push2(`<!---->`);
              }
              _push2(`</div></div>`);
              if (__props.reservation.status == "accepted") {
                _push2(`<div class="align-item-center mt-5 flex justify-center"${_scopeId}>`);
                if (!__props.reservation.requester_end_confirmed) {
                  _push2(ssrRenderComponent(_component_Button, {
                    onClick: ($event2) => modalIsOpen.value = true,
                    loading: _ctx.completeLoading,
                    disabled: _ctx.completeLoading,
                    severity: "success",
                    icon: "pi pi-check",
                    label: "Terminer ce trajet",
                    outlined: ""
                  }, null, _parent2, _scopeId));
                } else if (!__props.reservation.driver_end_confirmed) {
                  _push2(`<div${_scopeId}>`);
                  _push2(ssrRenderComponent(_component_rounded_button, {
                    class: "max-md:px-24",
                    design: "4",
                    disabled: ""
                  }, {
                    default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                      if (_push3) {
                        _push3(` En attente de confirmation du transporteur `);
                      } else {
                        return [
                          createTextVNode(" En attente de confirmation du transporteur ")
                        ];
                      }
                    }),
                    _: 1
                  }, _parent2, _scopeId));
                  _push2(`</div>`);
                } else {
                  _push2(`<!---->`);
                }
                _push2(`</div>`);
              } else {
                _push2(`<!---->`);
              }
              _push2(ssrRenderComponent(_component_confirm_completed_route_client_modal, {
                reservation: __props.reservation,
                opened: unref(modalIsOpen),
                onClose: ($event2) => modalIsOpen.value = false
              }, null, _parent2, _scopeId));
              _push2(`</div>`);
            } else if (__props.reservation.status == "pending") {
              _push2(`<div${_scopeId}> Vous pourrez voir les coordonn\xE9es du transporteur une fois votre r\xE9servation accept\xE9e. </div>`);
            } else if (__props.reservation.status == "expired") {
              _push2(`<div${_scopeId}><div class="text-red-500"${_scopeId}>R\xE9servation expir\xE9e</div></div>`);
            } else {
              _push2(`<!---->`);
            }
          } else {
            return [
              createVNode("div", { class: "mb-5 flex gap-5 border-b-2 border-dotted pb-5" }, [
                createVNode("div", { class: "flex max-md:mb-5" }, [
                  createVNode(_component_icon, {
                    icon: "lit",
                    class: "text-primary-light mr-3 h-6 w-6"
                  }),
                  __props.reservation.vehicle.type === "before_coffin" ? (openBlock(), createBlock("span", { key: 0 }, " Transport avant et apr\xE8s mise en bi\xE8re")) : createCommentVNode("", true),
                  __props.reservation.vehicle.type === "after_coffin" ? (openBlock(), createBlock("span", { key: 1 }, " Transport apr\xE8s mise en bi\xE8re")) : createCommentVNode("", true)
                ]),
                createVNode("div", { class: "flex max-md:mb-5" }, [
                  createVNode(_component_icon, {
                    icon: "dimensions",
                    class: "text-primary-light mr-3 h-6 w-6"
                  }),
                  __props.reservation.vehicle.is_standard_size ? (openBlock(), createBlock("span", { key: 0 }, " Supporte des tailles standards uniquement (< ou = \xE0 195cm x 60cm)")) : (openBlock(), createBlock("span", { key: 1 }, "Supporte des tailles hors normes (> \xE0 195cm x l60cm)"))
                ])
              ]),
              __props.reservation.status == "accepted" || __props.reservation.status == "completed" ? (openBlock(), createBlock("div", { key: 0 }, [
                createVNode("div", { class: "text-neutral-lighter flex justify-between" }, [
                  createVNode("div", null, [
                    createVNode("div", { class: "col-span-6 mb-2 flex gap-1" }, [
                      createVNode(_component_icon, {
                        icon: "voiture",
                        class: "text-primary-light mr-3 h-6 w-6"
                      }),
                      createVNode("b", null, "V\xE9hicule pr\xE9vu :"),
                      createTextVNode(" " + toDisplayString((_k = __props.reservation.vehicle) == null ? void 0 : _k.name), 1)
                    ]),
                    createVNode("div", { class: "col-span-6 mb-2 flex gap-1" }, [
                      createVNode(_component_icon, {
                        icon: "voiture",
                        class: "text-primary-light mr-3 h-6 w-6"
                      }),
                      createVNode("b", null, "Immatriculation :"),
                      createTextVNode(" " + toDisplayString((_l = __props.reservation.vehicle) == null ? void 0 : _l.license_plate), 1)
                    ]),
                    createVNode("div", { class: "mb-2 flex gap-1" }, [
                      createVNode(_component_icon, {
                        icon: "profil",
                        class: "text-primary-light mr-3 h-6 w-6"
                      }),
                      createVNode("b", null, "Chauffeur pr\xE9vu :"),
                      createTextVNode(" " + toDisplayString((_m = __props.reservation.operator) == null ? void 0 : _m.identifier), 1)
                    ]),
                    createVNode("div", { class: "mb-2 flex gap-1" }, [
                      createVNode(_component_icon, {
                        icon: "telephone",
                        class: "text-primary-light mr-3 h-6 w-6"
                      }),
                      createVNode("b", null, "T\xE9l\xE9phone du chauffeur :"),
                      createTextVNode(" " + toDisplayString((_n = __props.reservation.operator) == null ? void 0 : _n.phone), 1)
                    ]),
                    createVNode("div", { class: "mb-2 flex" }, [
                      createVNode(_component_icon, {
                        icon: "telephone-fixe",
                        class: "text-primary-light mr-3 h-6 w-6"
                      }),
                      createVNode("b", null, "T\xE9l\xE9phone fixe :"),
                      createTextVNode(" " + toDisplayString(__props.reservation.creator.phone), 1)
                    ])
                  ]),
                  createVNode("div", null, [
                    createVNode("div", { class: "mb-2 flex gap-1" }, [
                      createVNode(_component_icon, {
                        icon: "profil",
                        class: "text-primary-light mr-3 h-6 w-6"
                      }),
                      createVNode("b", null, "R\xE9f\xE9rence :"),
                      createTextVNode(" " + toDisplayString(__props.reservation.reference), 1)
                    ]),
                    createVNode("div", { class: "mb-2 flex gap-1" }, [
                      createVNode(_component_icon, {
                        icon: "telephone",
                        class: "text-primary-light mr-3 h-6 w-6"
                      }),
                      createVNode("b", null, "T\xE9l\xE9phone mobile :"),
                      createTextVNode(" " + toDisplayString(__props.reservation.creator.mobile), 1)
                    ]),
                    createVNode("div", { class: "mb-2 flex gap-1" }, [
                      createVNode(_component_icon, {
                        icon: "profil",
                        class: "text-primary-light mr-3 h-6 w-6"
                      }),
                      createVNode("b", null, "Soci\xE9t\xE9 :"),
                      createTextVNode(" " + toDisplayString(__props.reservation.creator.name), 1)
                    ]),
                    createVNode("div", { class: "col-span-12 md:col-span-6" }, [
                      createVNode("div", { class: "mb-2.5 flex" }, [
                        createVNode("div", null, [
                          createVNode(_component_icon, {
                            icon: "info",
                            class: "text-primary-light mr-3 h-6 w-6"
                          })
                        ]),
                        createVNode("div", null, [
                          createVNode("span", null, [
                            createVNode("b", null, "Adresse soci\xE9t\xE9: "),
                            createTextVNode(toDisplayString(__props.reservation.creator.address) + " " + toDisplayString(__props.reservation.creator.city.zip_code) + " " + toDisplayString(__props.reservation.creator.city.name), 1)
                          ])
                        ])
                      ])
                    ])
                  ]),
                  createVNode("div", { class: "max-md:align-center col-span-12 md:col-span-6" }, [
                    ((_p = (_o = __props.reservation.route) == null ? void 0 : _o.company) == null ? void 0 : _p.name) ? (openBlock(), createBlock("div", {
                      key: 0,
                      class: "mb-2 flex gap-1"
                    }, [
                      createVNode(_component_icon, {
                        icon: "profil",
                        class: "text-primary-light mr-3 h-6 w-6"
                      }),
                      createVNode("span", { class: "font-bold" }, "Soc\xE9t\xE9:"),
                      createTextVNode(" " + toDisplayString(__props.reservation.route.company.name), 1)
                    ])) : createCommentVNode("", true),
                    ((_r = (_q = __props.reservation.route) == null ? void 0 : _q.company) == null ? void 0 : _r.phone) ? (openBlock(), createBlock("div", {
                      key: 1,
                      class: "mb-2 flex gap-1"
                    }, [
                      createVNode(_component_icon, {
                        icon: "profil",
                        class: "text-primary-light mr-3 h-6 w-6"
                      }),
                      createVNode("span", { class: "font-bold" }, "T\xE9l : "),
                      createTextVNode(toDisplayString(__props.reservation.route.company.phone), 1)
                    ])) : createCommentVNode("", true),
                    ((_t = (_s = __props.reservation.route) == null ? void 0 : _s.company) == null ? void 0 : _t.mobile) ? (openBlock(), createBlock("div", {
                      key: 2,
                      class: "mb-2 flex gap-1"
                    }, [
                      createVNode(_component_icon, {
                        icon: "profil",
                        class: "text-primary-light mr-3 h-6 w-6"
                      }),
                      createVNode("span", { class: "font-bold" }, "Mobile :"),
                      createTextVNode(toDisplayString(__props.reservation.route.company.mobile), 1)
                    ])) : createCommentVNode("", true)
                  ])
                ]),
                __props.reservation.status == "accepted" ? (openBlock(), createBlock("div", {
                  key: 0,
                  class: "align-item-center mt-5 flex justify-center"
                }, [
                  !__props.reservation.requester_end_confirmed ? (openBlock(), createBlock(_component_Button, {
                    key: 0,
                    onClick: ($event2) => modalIsOpen.value = true,
                    loading: _ctx.completeLoading,
                    disabled: _ctx.completeLoading,
                    severity: "success",
                    icon: "pi pi-check",
                    label: "Terminer ce trajet",
                    outlined: ""
                  }, null, 8, ["onClick", "loading", "disabled"])) : !__props.reservation.driver_end_confirmed ? (openBlock(), createBlock("div", { key: 1 }, [
                    createVNode(_component_rounded_button, {
                      class: "max-md:px-24",
                      design: "4",
                      disabled: ""
                    }, {
                      default: withCtx(() => [
                        createTextVNode(" En attente de confirmation du transporteur ")
                      ]),
                      _: 1
                    })
                  ])) : createCommentVNode("", true)
                ])) : createCommentVNode("", true),
                createVNode(_component_confirm_completed_route_client_modal, {
                  reservation: __props.reservation,
                  opened: unref(modalIsOpen),
                  onClose: ($event2) => modalIsOpen.value = false
                }, null, 8, ["reservation", "opened", "onClose"])
              ])) : __props.reservation.status == "pending" ? (openBlock(), createBlock("div", { key: 1 }, " Vous pourrez voir les coordonn\xE9es du transporteur une fois votre r\xE9servation accept\xE9e. ")) : __props.reservation.status == "expired" ? (openBlock(), createBlock("div", { key: 2 }, [
                createVNode("div", { class: "text-red-500" }, "R\xE9servation expir\xE9e")
              ])) : createCommentVNode("", true)
            ];
          }
        }),
        _: 1
      }, _parent));
    };
  }
};
const _sfc_setup$1 = _sfc_main$1.setup;
_sfc_main$1.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/ReservationCard.vue");
  return _sfc_setup$1 ? _sfc_setup$1(props, ctx) : void 0;
};
const __nuxt_component_4 = _sfc_main$1;
const _sfc_main = {
  __name: "mes-demandes-de-trajets",
  __ssrInlineRender: true,
  setup(__props) {
    useAuthStore();
    const tab = ref("pending");
    const reservations = ref([]);
    const loading = ref(false);
    const computedPendingRouteRequest = computed(() => {
      return reservations.value.filter((routeRequest) => ["pending"].includes(routeRequest.status)).sort((a, b) => new Date(b.created_at) - new Date(a.created_at));
    });
    const computedInProgressRouteRequest = computed(() => {
      return reservations.value.filter((routeRequest) => ["accepted"].includes(routeRequest.status)).sort((a, b) => new Date(b.created_at) - new Date(a.created_at));
    });
    const computedCancelledOrRefusedRouteRequest = computed(() => {
      return reservations.value.filter(
        (routeRequest) => ["cancelled", "refused"].includes(routeRequest.status)
      ).sort((a, b) => new Date(b.created_at) - new Date(a.created_at));
    });
    const computedCompleteRouteRequest = computed(() => {
      return reservations.value.filter((routeRequest) => ["completed"].includes(routeRequest.status)).sort((a, b) => new Date(b.created_at) - new Date(a.created_at));
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_section_wrapper = __nuxt_component_0;
      const _component_section_container = __nuxt_component_1;
      const _component_form_title = __nuxt_component_4$2;
      const _component_spinner = __nuxt_component_3;
      const _component_reservation_card = __nuxt_component_4;
      _push(`<!--[-->`);
      _push(ssrRenderComponent(_component_section_wrapper, { class: "bg-background-1" }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(ssrRenderComponent(_component_section_container, {
              "mobile-padding": "",
              class: "max-w-container relative z-10 rounded-2xl bg-white px-24 py-10"
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`<div class="flex items-center justify-center gap-5 max-md:flex-wrap"${_scopeId2}><div class="${ssrRenderClass([{
                    "bg-primary text-white": unref(tab) === "pending",
                    "hover:bg-primary-lightest": unref(tab) !== "pending"
                  }, "border-primary text-primary w-1/3 cursor-pointer rounded-xl border-2 p-3 text-center max-md:w-full"])}"${_scopeId2}> En attente (${ssrInterpolate(unref(computedPendingRouteRequest).length)}) </div><div class="${ssrRenderClass([{
                    "bg-primary text-white": unref(tab) === "progress",
                    "hover:bg-primary-lightest": unref(tab) !== "progress"
                  }, "border-primary text-primary w-1/3 cursor-pointer rounded-xl border-2 p-3 text-center max-md:w-full"])}"${_scopeId2}> Accept\xE9es (${ssrInterpolate(unref(computedInProgressRouteRequest).length)}) </div><div class="${ssrRenderClass([{
                    "bg-primary text-white": unref(tab) === "cancelled",
                    "hover:bg-primary-lightest": unref(tab) !== "cancelled"
                  }, "border-primary text-primary w-1/3 cursor-pointer rounded-xl border-2 p-3 text-center max-md:w-full"])}"${_scopeId2}> Annul\xE9es/Refus\xE9es (${ssrInterpolate(unref(computedCancelledOrRefusedRouteRequest).length)}) </div><div class="${ssrRenderClass([{
                    "bg-primary text-white": unref(tab) === "completed",
                    "hover:bg-primary-lightest": unref(tab) !== "completed"
                  }, "border-primary text-primary w-1/3 cursor-pointer rounded-xl border-2 p-3 text-center max-md:w-full"])}"${_scopeId2}> Termin\xE9e (${ssrInterpolate(unref(computedCompleteRouteRequest).length)}) </div></div>`);
                } else {
                  return [
                    createVNode("div", { class: "flex items-center justify-center gap-5 max-md:flex-wrap" }, [
                      createVNode("div", {
                        class: ["border-primary text-primary w-1/3 cursor-pointer rounded-xl border-2 p-3 text-center max-md:w-full", {
                          "bg-primary text-white": unref(tab) === "pending",
                          "hover:bg-primary-lightest": unref(tab) !== "pending"
                        }],
                        onClick: ($event) => tab.value = "pending"
                      }, " En attente (" + toDisplayString(unref(computedPendingRouteRequest).length) + ") ", 11, ["onClick"]),
                      createVNode("div", {
                        class: ["border-primary text-primary w-1/3 cursor-pointer rounded-xl border-2 p-3 text-center max-md:w-full", {
                          "bg-primary text-white": unref(tab) === "progress",
                          "hover:bg-primary-lightest": unref(tab) !== "progress"
                        }],
                        onClick: ($event) => tab.value = "progress"
                      }, " Accept\xE9es (" + toDisplayString(unref(computedInProgressRouteRequest).length) + ") ", 11, ["onClick"]),
                      createVNode("div", {
                        class: ["border-primary text-primary w-1/3 cursor-pointer rounded-xl border-2 p-3 text-center max-md:w-full", {
                          "bg-primary text-white": unref(tab) === "cancelled",
                          "hover:bg-primary-lightest": unref(tab) !== "cancelled"
                        }],
                        onClick: ($event) => tab.value = "cancelled"
                      }, " Annul\xE9es/Refus\xE9es (" + toDisplayString(unref(computedCancelledOrRefusedRouteRequest).length) + ") ", 11, ["onClick"]),
                      createVNode("div", {
                        class: ["border-primary text-primary w-1/3 cursor-pointer rounded-xl border-2 p-3 text-center max-md:w-full", {
                          "bg-primary text-white": unref(tab) === "completed",
                          "hover:bg-primary-lightest": unref(tab) !== "completed"
                        }],
                        onClick: ($event) => tab.value = "completed"
                      }, " Termin\xE9e (" + toDisplayString(unref(computedCompleteRouteRequest).length) + ") ", 11, ["onClick"])
                    ])
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
          } else {
            return [
              createVNode(_component_section_container, {
                "mobile-padding": "",
                class: "max-w-container relative z-10 rounded-2xl bg-white px-24 py-10"
              }, {
                default: withCtx(() => [
                  createVNode("div", { class: "flex items-center justify-center gap-5 max-md:flex-wrap" }, [
                    createVNode("div", {
                      class: ["border-primary text-primary w-1/3 cursor-pointer rounded-xl border-2 p-3 text-center max-md:w-full", {
                        "bg-primary text-white": unref(tab) === "pending",
                        "hover:bg-primary-lightest": unref(tab) !== "pending"
                      }],
                      onClick: ($event) => tab.value = "pending"
                    }, " En attente (" + toDisplayString(unref(computedPendingRouteRequest).length) + ") ", 11, ["onClick"]),
                    createVNode("div", {
                      class: ["border-primary text-primary w-1/3 cursor-pointer rounded-xl border-2 p-3 text-center max-md:w-full", {
                        "bg-primary text-white": unref(tab) === "progress",
                        "hover:bg-primary-lightest": unref(tab) !== "progress"
                      }],
                      onClick: ($event) => tab.value = "progress"
                    }, " Accept\xE9es (" + toDisplayString(unref(computedInProgressRouteRequest).length) + ") ", 11, ["onClick"]),
                    createVNode("div", {
                      class: ["border-primary text-primary w-1/3 cursor-pointer rounded-xl border-2 p-3 text-center max-md:w-full", {
                        "bg-primary text-white": unref(tab) === "cancelled",
                        "hover:bg-primary-lightest": unref(tab) !== "cancelled"
                      }],
                      onClick: ($event) => tab.value = "cancelled"
                    }, " Annul\xE9es/Refus\xE9es (" + toDisplayString(unref(computedCancelledOrRefusedRouteRequest).length) + ") ", 11, ["onClick"]),
                    createVNode("div", {
                      class: ["border-primary text-primary w-1/3 cursor-pointer rounded-xl border-2 p-3 text-center max-md:w-full", {
                        "bg-primary text-white": unref(tab) === "completed",
                        "hover:bg-primary-lightest": unref(tab) !== "completed"
                      }],
                      onClick: ($event) => tab.value = "completed"
                    }, " Termin\xE9e (" + toDisplayString(unref(computedCompleteRouteRequest).length) + ") ", 11, ["onClick"])
                  ])
                ]),
                _: 1
              })
            ];
          }
        }),
        _: 1
      }, _parent));
      if (unref(tab) === "pending") {
        _push(ssrRenderComponent(_component_section_wrapper, { class: "bg-background-1 py-10" }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(ssrRenderComponent(_component_section_container, {
                "mobile-padding": "",
                class: "max-w-container relative z-10 rounded-2xl bg-white px-24 py-16"
              }, {
                default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    _push3(ssrRenderComponent(_component_form_title, { number: "" }, {
                      default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                        if (_push4) {
                          _push4(`Mes demandes en attente`);
                        } else {
                          return [
                            createTextVNode("Mes demandes en attente")
                          ];
                        }
                      }),
                      _: 1
                    }, _parent3, _scopeId2));
                    if (unref(loading)) {
                      _push3(ssrRenderComponent(_component_spinner, { class: "mx-auto" }, null, _parent3, _scopeId2));
                    } else if (!unref(loading) && unref(computedPendingRouteRequest).length === 0) {
                      _push3(`<div class="text-primary-lightest flex h-[20rem] items-center justify-center text-4xl font-bold uppercase"${_scopeId2}> Aucune demande en attente </div>`);
                    } else {
                      _push3(`<div class="flex flex-col gap-6"${_scopeId2}><!--[-->`);
                      ssrRenderList(unref(computedPendingRouteRequest), (reservation) => {
                        _push3(ssrRenderComponent(_component_reservation_card, { reservation }, null, _parent3, _scopeId2));
                      });
                      _push3(`<!--]--></div>`);
                    }
                  } else {
                    return [
                      createVNode(_component_form_title, { number: "" }, {
                        default: withCtx(() => [
                          createTextVNode("Mes demandes en attente")
                        ]),
                        _: 1
                      }),
                      unref(loading) ? (openBlock(), createBlock(_component_spinner, {
                        key: 0,
                        class: "mx-auto"
                      })) : !unref(loading) && unref(computedPendingRouteRequest).length === 0 ? (openBlock(), createBlock("div", {
                        key: 1,
                        class: "text-primary-lightest flex h-[20rem] items-center justify-center text-4xl font-bold uppercase"
                      }, " Aucune demande en attente ")) : (openBlock(), createBlock("div", {
                        key: 2,
                        class: "flex flex-col gap-6"
                      }, [
                        (openBlock(true), createBlock(Fragment, null, renderList(unref(computedPendingRouteRequest), (reservation) => {
                          return openBlock(), createBlock(_component_reservation_card, { reservation }, null, 8, ["reservation"]);
                        }), 256))
                      ]))
                    ];
                  }
                }),
                _: 1
              }, _parent2, _scopeId));
            } else {
              return [
                createVNode(_component_section_container, {
                  "mobile-padding": "",
                  class: "max-w-container relative z-10 rounded-2xl bg-white px-24 py-16"
                }, {
                  default: withCtx(() => [
                    createVNode(_component_form_title, { number: "" }, {
                      default: withCtx(() => [
                        createTextVNode("Mes demandes en attente")
                      ]),
                      _: 1
                    }),
                    unref(loading) ? (openBlock(), createBlock(_component_spinner, {
                      key: 0,
                      class: "mx-auto"
                    })) : !unref(loading) && unref(computedPendingRouteRequest).length === 0 ? (openBlock(), createBlock("div", {
                      key: 1,
                      class: "text-primary-lightest flex h-[20rem] items-center justify-center text-4xl font-bold uppercase"
                    }, " Aucune demande en attente ")) : (openBlock(), createBlock("div", {
                      key: 2,
                      class: "flex flex-col gap-6"
                    }, [
                      (openBlock(true), createBlock(Fragment, null, renderList(unref(computedPendingRouteRequest), (reservation) => {
                        return openBlock(), createBlock(_component_reservation_card, { reservation }, null, 8, ["reservation"]);
                      }), 256))
                    ]))
                  ]),
                  _: 1
                })
              ];
            }
          }),
          _: 1
        }, _parent));
      } else {
        _push(`<!---->`);
      }
      if (unref(tab) === "progress") {
        _push(ssrRenderComponent(_component_section_wrapper, { class: "bg-background-1 py-10" }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(ssrRenderComponent(_component_section_container, {
                "mobile-padding": "",
                class: "max-w-container relative z-10 rounded-2xl bg-white px-24 py-16"
              }, {
                default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    _push3(ssrRenderComponent(_component_form_title, { number: "" }, {
                      default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                        if (_push4) {
                          _push4(`Mes demandes accept\xE9es (en cours)`);
                        } else {
                          return [
                            createTextVNode("Mes demandes accept\xE9es (en cours)")
                          ];
                        }
                      }),
                      _: 1
                    }, _parent3, _scopeId2));
                    if (unref(loading)) {
                      _push3(ssrRenderComponent(_component_spinner, { class: "mx-auto" }, null, _parent3, _scopeId2));
                    } else if (!unref(loading) && unref(computedInProgressRouteRequest).length === 0) {
                      _push3(`<div class="text-primary-lightest flex h-[20rem] items-center justify-center text-4xl font-bold uppercase"${_scopeId2}> Aucune demande en cours </div>`);
                    } else {
                      _push3(`<div class="flex flex-col gap-6"${_scopeId2}><!--[-->`);
                      ssrRenderList(unref(computedInProgressRouteRequest), (reservation) => {
                        _push3(ssrRenderComponent(_component_reservation_card, { reservation }, null, _parent3, _scopeId2));
                      });
                      _push3(`<!--]--></div>`);
                    }
                  } else {
                    return [
                      createVNode(_component_form_title, { number: "" }, {
                        default: withCtx(() => [
                          createTextVNode("Mes demandes accept\xE9es (en cours)")
                        ]),
                        _: 1
                      }),
                      unref(loading) ? (openBlock(), createBlock(_component_spinner, {
                        key: 0,
                        class: "mx-auto"
                      })) : !unref(loading) && unref(computedInProgressRouteRequest).length === 0 ? (openBlock(), createBlock("div", {
                        key: 1,
                        class: "text-primary-lightest flex h-[20rem] items-center justify-center text-4xl font-bold uppercase"
                      }, " Aucune demande en cours ")) : (openBlock(), createBlock("div", {
                        key: 2,
                        class: "flex flex-col gap-6"
                      }, [
                        (openBlock(true), createBlock(Fragment, null, renderList(unref(computedInProgressRouteRequest), (reservation) => {
                          return openBlock(), createBlock(_component_reservation_card, { reservation }, null, 8, ["reservation"]);
                        }), 256))
                      ]))
                    ];
                  }
                }),
                _: 1
              }, _parent2, _scopeId));
            } else {
              return [
                createVNode(_component_section_container, {
                  "mobile-padding": "",
                  class: "max-w-container relative z-10 rounded-2xl bg-white px-24 py-16"
                }, {
                  default: withCtx(() => [
                    createVNode(_component_form_title, { number: "" }, {
                      default: withCtx(() => [
                        createTextVNode("Mes demandes accept\xE9es (en cours)")
                      ]),
                      _: 1
                    }),
                    unref(loading) ? (openBlock(), createBlock(_component_spinner, {
                      key: 0,
                      class: "mx-auto"
                    })) : !unref(loading) && unref(computedInProgressRouteRequest).length === 0 ? (openBlock(), createBlock("div", {
                      key: 1,
                      class: "text-primary-lightest flex h-[20rem] items-center justify-center text-4xl font-bold uppercase"
                    }, " Aucune demande en cours ")) : (openBlock(), createBlock("div", {
                      key: 2,
                      class: "flex flex-col gap-6"
                    }, [
                      (openBlock(true), createBlock(Fragment, null, renderList(unref(computedInProgressRouteRequest), (reservation) => {
                        return openBlock(), createBlock(_component_reservation_card, { reservation }, null, 8, ["reservation"]);
                      }), 256))
                    ]))
                  ]),
                  _: 1
                })
              ];
            }
          }),
          _: 1
        }, _parent));
      } else {
        _push(`<!---->`);
      }
      if (unref(tab) === "completed") {
        _push(ssrRenderComponent(_component_section_wrapper, { class: "bg-background-1 py-10" }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(ssrRenderComponent(_component_section_container, {
                "mobile-padding": "",
                class: "max-w-container relative z-10 rounded-2xl bg-white px-24 py-16"
              }, {
                default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    _push3(ssrRenderComponent(_component_form_title, { number: "" }, {
                      default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                        if (_push4) {
                          _push4(`Trajets termin\xE9s`);
                        } else {
                          return [
                            createTextVNode("Trajets termin\xE9s")
                          ];
                        }
                      }),
                      _: 1
                    }, _parent3, _scopeId2));
                    if (unref(loading)) {
                      _push3(ssrRenderComponent(_component_spinner, { class: "mx-auto" }, null, _parent3, _scopeId2));
                    } else if (!unref(loading) && unref(computedCompleteRouteRequest).length === 0) {
                      _push3(`<div class="text-primary-lightest flex h-[20rem] items-center justify-center text-4xl font-bold uppercase"${_scopeId2}> Aucune demande termin\xE9e </div>`);
                    } else {
                      _push3(`<div class="flex flex-col gap-6"${_scopeId2}><!--[-->`);
                      ssrRenderList(unref(computedCompleteRouteRequest), (reservation) => {
                        _push3(ssrRenderComponent(_component_reservation_card, { reservation }, null, _parent3, _scopeId2));
                      });
                      _push3(`<!--]--></div>`);
                    }
                  } else {
                    return [
                      createVNode(_component_form_title, { number: "" }, {
                        default: withCtx(() => [
                          createTextVNode("Trajets termin\xE9s")
                        ]),
                        _: 1
                      }),
                      unref(loading) ? (openBlock(), createBlock(_component_spinner, {
                        key: 0,
                        class: "mx-auto"
                      })) : !unref(loading) && unref(computedCompleteRouteRequest).length === 0 ? (openBlock(), createBlock("div", {
                        key: 1,
                        class: "text-primary-lightest flex h-[20rem] items-center justify-center text-4xl font-bold uppercase"
                      }, " Aucune demande termin\xE9e ")) : (openBlock(), createBlock("div", {
                        key: 2,
                        class: "flex flex-col gap-6"
                      }, [
                        (openBlock(true), createBlock(Fragment, null, renderList(unref(computedCompleteRouteRequest), (reservation) => {
                          return openBlock(), createBlock(_component_reservation_card, { reservation }, null, 8, ["reservation"]);
                        }), 256))
                      ]))
                    ];
                  }
                }),
                _: 1
              }, _parent2, _scopeId));
            } else {
              return [
                createVNode(_component_section_container, {
                  "mobile-padding": "",
                  class: "max-w-container relative z-10 rounded-2xl bg-white px-24 py-16"
                }, {
                  default: withCtx(() => [
                    createVNode(_component_form_title, { number: "" }, {
                      default: withCtx(() => [
                        createTextVNode("Trajets termin\xE9s")
                      ]),
                      _: 1
                    }),
                    unref(loading) ? (openBlock(), createBlock(_component_spinner, {
                      key: 0,
                      class: "mx-auto"
                    })) : !unref(loading) && unref(computedCompleteRouteRequest).length === 0 ? (openBlock(), createBlock("div", {
                      key: 1,
                      class: "text-primary-lightest flex h-[20rem] items-center justify-center text-4xl font-bold uppercase"
                    }, " Aucune demande termin\xE9e ")) : (openBlock(), createBlock("div", {
                      key: 2,
                      class: "flex flex-col gap-6"
                    }, [
                      (openBlock(true), createBlock(Fragment, null, renderList(unref(computedCompleteRouteRequest), (reservation) => {
                        return openBlock(), createBlock(_component_reservation_card, { reservation }, null, 8, ["reservation"]);
                      }), 256))
                    ]))
                  ]),
                  _: 1
                })
              ];
            }
          }),
          _: 1
        }, _parent));
      } else {
        _push(`<!---->`);
      }
      if (unref(tab) === "cancelled") {
        _push(ssrRenderComponent(_component_section_wrapper, { class: "bg-background-1 py-10" }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(ssrRenderComponent(_component_section_container, {
                "mobile-padding": "",
                class: "max-w-container relative z-10 rounded-2xl bg-white px-24 py-16"
              }, {
                default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    _push3(ssrRenderComponent(_component_form_title, { number: "" }, {
                      default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                        if (_push4) {
                          _push4(`Demandes annul\xE9es/refus\xE9es`);
                        } else {
                          return [
                            createTextVNode("Demandes annul\xE9es/refus\xE9es")
                          ];
                        }
                      }),
                      _: 1
                    }, _parent3, _scopeId2));
                    if (unref(loading)) {
                      _push3(ssrRenderComponent(_component_spinner, { class: "mx-auto" }, null, _parent3, _scopeId2));
                    } else if (!unref(loading) && unref(computedCancelledOrRefusedRouteRequest).length === 0) {
                      _push3(`<div class="text-primary-lightest flex h-[20rem] items-center justify-center text-4xl font-bold uppercase"${_scopeId2}> Aucune demande annul\xE9e/refus\xE9e </div>`);
                    } else {
                      _push3(`<div class="flex flex-col gap-6"${_scopeId2}><!--[-->`);
                      ssrRenderList(unref(computedCancelledOrRefusedRouteRequest), (reservation) => {
                        _push3(ssrRenderComponent(_component_reservation_card, { reservation }, null, _parent3, _scopeId2));
                      });
                      _push3(`<!--]--></div>`);
                    }
                  } else {
                    return [
                      createVNode(_component_form_title, { number: "" }, {
                        default: withCtx(() => [
                          createTextVNode("Demandes annul\xE9es/refus\xE9es")
                        ]),
                        _: 1
                      }),
                      unref(loading) ? (openBlock(), createBlock(_component_spinner, {
                        key: 0,
                        class: "mx-auto"
                      })) : !unref(loading) && unref(computedCancelledOrRefusedRouteRequest).length === 0 ? (openBlock(), createBlock("div", {
                        key: 1,
                        class: "text-primary-lightest flex h-[20rem] items-center justify-center text-4xl font-bold uppercase"
                      }, " Aucune demande annul\xE9e/refus\xE9e ")) : (openBlock(), createBlock("div", {
                        key: 2,
                        class: "flex flex-col gap-6"
                      }, [
                        (openBlock(true), createBlock(Fragment, null, renderList(unref(computedCancelledOrRefusedRouteRequest), (reservation) => {
                          return openBlock(), createBlock(_component_reservation_card, { reservation }, null, 8, ["reservation"]);
                        }), 256))
                      ]))
                    ];
                  }
                }),
                _: 1
              }, _parent2, _scopeId));
            } else {
              return [
                createVNode(_component_section_container, {
                  "mobile-padding": "",
                  class: "max-w-container relative z-10 rounded-2xl bg-white px-24 py-16"
                }, {
                  default: withCtx(() => [
                    createVNode(_component_form_title, { number: "" }, {
                      default: withCtx(() => [
                        createTextVNode("Demandes annul\xE9es/refus\xE9es")
                      ]),
                      _: 1
                    }),
                    unref(loading) ? (openBlock(), createBlock(_component_spinner, {
                      key: 0,
                      class: "mx-auto"
                    })) : !unref(loading) && unref(computedCancelledOrRefusedRouteRequest).length === 0 ? (openBlock(), createBlock("div", {
                      key: 1,
                      class: "text-primary-lightest flex h-[20rem] items-center justify-center text-4xl font-bold uppercase"
                    }, " Aucune demande annul\xE9e/refus\xE9e ")) : (openBlock(), createBlock("div", {
                      key: 2,
                      class: "flex flex-col gap-6"
                    }, [
                      (openBlock(true), createBlock(Fragment, null, renderList(unref(computedCancelledOrRefusedRouteRequest), (reservation) => {
                        return openBlock(), createBlock(_component_reservation_card, { reservation }, null, 8, ["reservation"]);
                      }), 256))
                    ]))
                  ]),
                  _: 1
                })
              ];
            }
          }),
          _: 1
        }, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`<!--]-->`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("pages/dashboard/mes-demandes-de-trajets.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as default };
//# sourceMappingURL=mes-demandes-de-trajets-aae8bc6f.mjs.map
