import { _ as __nuxt_component_0, a as __nuxt_component_1 } from './SectionContainer-5a7aa7e3.mjs';
import { _ as __nuxt_component_4 } from './FormTitle-afe32d73.mjs';
import { _ as __nuxt_component_8 } from './RoundedButton-a0ea68b9.mjs';
import { _ as __nuxt_component_3 } from './Spinner-653832cb.mjs';
import { _ as __nuxt_component_0$1 } from './Price-aaf3d10e.mjs';
import { _ as __nuxt_component_1$1 } from './AvailableRouteCard-3afeb6c6.mjs';
import { a as useNuxtApp } from '../server.mjs';
import { ref, computed, resolveComponent, mergeProps, withCtx, createTextVNode, createVNode, unref, toDisplayString, openBlock, createBlock, createCommentVNode, Fragment, renderList, useSSRContext } from 'vue';
import { u as useDayjs } from './dayjs-9d0b29d3.mjs';
import { ssrRenderComponent, ssrInterpolate, ssrRenderList } from 'vue/server-renderer';
import { u as useAuthStore } from './auth-6d0727c5.mjs';
import './Icon-7157bd57.mjs';
import './config-f619f9d4.mjs';
import 'ofetch';
import 'hookable';
import 'unctx';
import 'vue-router';
import 'h3';
import 'ufo';
import '@unhead/ssr';
import 'unhead';
import '@unhead/shared';
import 'dayjs';
import 'dayjs/plugin/relativeTime.js';
import 'dayjs/plugin/utc.js';
import 'dayjs/plugin/timezone.js';
import '@headlessui/vue';
import 'vue-i18n';
import 'defu';
import '../../nitro/node-server.mjs';
import 'node-fetch-native/polyfill';
import 'node:http';
import 'node:https';
import 'destr';
import 'unenv/runtime/fetch/index';
import 'scule';
import 'klona';
import 'ohash';
import 'unstorage';
import 'radix3';
import 'node:fs';
import 'node:url';
import 'pathe';
import 'http-graceful-shutdown';

const _sfc_main$1 = {
  __name: "AlertCard",
  __ssrInlineRender: true,
  props: {
    alert: {
      type: Object,
      required: true,
      default: () => ({})
    }
  },
  emits: ["update"],
  setup(__props, { emit }) {
    const props = __props;
    const { $api, $event, $toast } = useNuxtApp();
    const loading = ref(false);
    const dayjs = useDayjs();
    const expand = ref(false);
    const reserve = (route) => {
      $event("booking.requested", route);
    };
    const removeAlert = () => {
      loading.value = true;
      $api.call("delete", $api.route("me.alerts.destroy", { alert: props.alert.id })).then((data) => {
        $toast.success("Alerte supprim\xE9 avec succ\xE8s");
        emit("update");
      }).catch((e) => {
        if (e.response) {
          $toast.error(e.response.data.message);
        } else {
          $toast.error("Une erreur est survenue");
        }
      }).finally(() => {
        loading.value = false;
      });
    };
    return (_ctx, _push, _parent, _attrs) => {
      const _component_base_route_card = __nuxt_component_0$1;
      const _component_rounded_button = __nuxt_component_8;
      const _component_available_route_card = __nuxt_component_1$1;
      _push(ssrRenderComponent(_component_base_route_card, mergeProps({ route: __props.alert }, _attrs), {
        main: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<div class="flex justify-end gap-2"${_scopeId}>`);
            if (!__props.alert.archive) {
              _push2(ssrRenderComponent(_component_rounded_button, {
                design: 1,
                size: _ctx.sm,
                icon: "trash",
                onClick: removeAlert,
                loading: unref(loading)
              }, {
                default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    _push3(` Supprimer l&#39;alerte `);
                  } else {
                    return [
                      createTextVNode(" Supprimer l'alerte ")
                    ];
                  }
                }),
                _: 1
              }, _parent2, _scopeId));
            } else {
              _push2(`<!---->`);
            }
            _push2(`</div>`);
          } else {
            return [
              createVNode("div", { class: "flex justify-end gap-2" }, [
                !__props.alert.archive ? (openBlock(), createBlock(_component_rounded_button, {
                  key: 0,
                  design: 1,
                  size: _ctx.sm,
                  icon: "trash",
                  onClick: removeAlert,
                  loading: unref(loading)
                }, {
                  default: withCtx(() => [
                    createTextVNode(" Supprimer l'alerte ")
                  ]),
                  _: 1
                }, 8, ["size", "loading"])) : createCommentVNode("", true)
              ])
            ];
          }
        }),
        footer: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<div class="mb-2 flex"${_scopeId}><span class="font-bold"${_scopeId}>Date souhait\xE9e: \xA0</span> ${ssrInterpolate(unref(dayjs)(__props.alert.date).format("DD/MM/YYYY"))}</div>`);
            if (__props.alert.matched_routes.length > 0) {
              _push2(`<div class="mb-5 flex justify-center"${_scopeId}>`);
              _push2(ssrRenderComponent(_component_rounded_button, {
                design: 4,
                size: _ctx.sm,
                onClick: ($event2) => expand.value = !unref(expand)
              }, {
                default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    if (unref(expand)) {
                      _push3(`<span${_scopeId2}> Cacher les trajets trouv\xE9s </span>`);
                    } else {
                      _push3(`<span${_scopeId2}> Voir les trajets trouv\xE9s (${ssrInterpolate(__props.alert.matched_routes.length)}) </span>`);
                    }
                  } else {
                    return [
                      unref(expand) ? (openBlock(), createBlock("span", { key: 0 }, " Cacher les trajets trouv\xE9s ")) : (openBlock(), createBlock("span", { key: 1 }, " Voir les trajets trouv\xE9s (" + toDisplayString(__props.alert.matched_routes.length) + ") ", 1))
                    ];
                  }
                }),
                _: 1
              }, _parent2, _scopeId));
              _push2(`</div>`);
            } else {
              _push2(`<div class="text-primary-lightest flex h-[5rem] items-center justify-center text-2xl font-bold uppercase"${_scopeId}> Aucune trajet trouv\xE9 pour le moment </div>`);
            }
            if (unref(expand)) {
              _push2(`<div${_scopeId}><!--[-->`);
              ssrRenderList(__props.alert.matched_routes, (route) => {
                _push2(ssrRenderComponent(_component_available_route_card, {
                  class: "mb-5",
                  route,
                  onBook: ($event2) => reserve(route)
                }, null, _parent2, _scopeId));
              });
              _push2(`<!--]--></div>`);
            } else {
              _push2(`<!---->`);
            }
          } else {
            return [
              createVNode("div", { class: "mb-2 flex" }, [
                createVNode("span", { class: "font-bold" }, "Date souhait\xE9e: \xA0"),
                createTextVNode(" " + toDisplayString(unref(dayjs)(__props.alert.date).format("DD/MM/YYYY")), 1)
              ]),
              __props.alert.matched_routes.length > 0 ? (openBlock(), createBlock("div", {
                key: 0,
                class: "mb-5 flex justify-center"
              }, [
                createVNode(_component_rounded_button, {
                  design: 4,
                  size: _ctx.sm,
                  onClick: ($event2) => expand.value = !unref(expand)
                }, {
                  default: withCtx(() => [
                    unref(expand) ? (openBlock(), createBlock("span", { key: 0 }, " Cacher les trajets trouv\xE9s ")) : (openBlock(), createBlock("span", { key: 1 }, " Voir les trajets trouv\xE9s (" + toDisplayString(__props.alert.matched_routes.length) + ") ", 1))
                  ]),
                  _: 1
                }, 8, ["size", "onClick"])
              ])) : (openBlock(), createBlock("div", {
                key: 1,
                class: "text-primary-lightest flex h-[5rem] items-center justify-center text-2xl font-bold uppercase"
              }, " Aucune trajet trouv\xE9 pour le moment ")),
              unref(expand) ? (openBlock(), createBlock("div", { key: 2 }, [
                (openBlock(true), createBlock(Fragment, null, renderList(__props.alert.matched_routes, (route) => {
                  return openBlock(), createBlock(_component_available_route_card, {
                    class: "mb-5",
                    route,
                    onBook: ($event2) => reserve(route)
                  }, null, 8, ["route", "onBook"]);
                }), 256))
              ])) : createCommentVNode("", true)
            ];
          }
        }),
        _: 1
      }, _parent));
    };
  }
};
const _sfc_setup$1 = _sfc_main$1.setup;
_sfc_main$1.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/cards/routes/AlertCard.vue");
  return _sfc_setup$1 ? _sfc_setup$1(props, ctx) : void 0;
};
const __nuxt_component_5 = _sfc_main$1;
const _sfc_main = {
  __name: "mes-alertes",
  __ssrInlineRender: true,
  emits: ["store"],
  setup(__props, { emit }) {
    useAuthStore();
    const { $api, $listen, $event, $toast } = useNuxtApp();
    const alerts = ref([]);
    const error = ref(null);
    const loading = ref(false);
    const openCreateAlert = () => {
      $event("open-create-alert");
    };
    const filterInProgressAlerts = computed(() => {
      return alerts.value.filter((alert) => !alert.archive);
    });
    computed(() => {
      return alerts.value.filter((alert) => alert.archive);
    });
    const fetchAlerts = async () => {
      loading.value = true;
      error.value = null;
      $api.call("get", $api.route("me.alerts.index")).then((data) => {
        alerts.value = data;
      }).catch((e) => {
        if (e.response) {
          $toast.error(e.response.data.message);
          error.value = e.response.data.message;
        }
      }).finally(() => {
        loading.value = false;
      });
    };
    return (_ctx, _push, _parent, _attrs) => {
      const _component_section_wrapper = __nuxt_component_0;
      const _component_section_container = __nuxt_component_1;
      const _component_form_title = __nuxt_component_4;
      const _component_rounded_button = __nuxt_component_8;
      const _component_Message = resolveComponent("Message");
      const _component_spinner = __nuxt_component_3;
      const _component_alert_card = __nuxt_component_5;
      _push(ssrRenderComponent(_component_section_wrapper, mergeProps({ class: "bg-background-1 py-10" }, _attrs), {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(ssrRenderComponent(_component_section_container, {
              "mobile-padding": "",
              class: "max-w-container relative z-10 rounded-2xl bg-white px-24 py-16"
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(ssrRenderComponent(_component_form_title, { number: "" }, {
                    actions: withCtx((_3, _push4, _parent4, _scopeId3) => {
                      if (_push4) {
                        _push4(ssrRenderComponent(_component_rounded_button, {
                          design: "1",
                          icon: "plus",
                          class: "ml-5 w-[40rem]",
                          onClick: openCreateAlert
                        }, {
                          default: withCtx((_4, _push5, _parent5, _scopeId4) => {
                            if (_push5) {
                              _push5(` AJOUTER UNE ALERTE `);
                            } else {
                              return [
                                createTextVNode(" AJOUTER UNE ALERTE ")
                              ];
                            }
                          }),
                          _: 1
                        }, _parent4, _scopeId3));
                      } else {
                        return [
                          createVNode(_component_rounded_button, {
                            design: "1",
                            icon: "plus",
                            class: "ml-5 w-[40rem]",
                            onClick: openCreateAlert
                          }, {
                            default: withCtx(() => [
                              createTextVNode(" AJOUTER UNE ALERTE ")
                            ]),
                            _: 1
                          })
                        ];
                      }
                    }),
                    default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                      if (_push4) {
                        _push4(`Mes alertes en cours `);
                      } else {
                        return [
                          createTextVNode("Mes alertes en cours ")
                        ];
                      }
                    }),
                    _: 1
                  }, _parent3, _scopeId2));
                  _push3(`<div class="mb-5"${_scopeId2}> Les alertes sont automatiquement supprim\xE9es une fois la date souhait\xE9e de d\xE9part d\xE9pass\xE9e. </div>`);
                  if (unref(error)) {
                    _push3(ssrRenderComponent(_component_Message, { severity: "error" }, {
                      default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                        if (_push4) {
                          _push4(`${ssrInterpolate(unref(error))}`);
                        } else {
                          return [
                            createTextVNode(toDisplayString(unref(error)), 1)
                          ];
                        }
                      }),
                      _: 1
                    }, _parent3, _scopeId2));
                  } else {
                    _push3(`<!---->`);
                  }
                  if (unref(loading)) {
                    _push3(ssrRenderComponent(_component_spinner, { class: "mx-auto" }, null, _parent3, _scopeId2));
                  } else if (!unref(loading) && unref(filterInProgressAlerts).length === 0) {
                    _push3(`<div class="text-primary-lightest flex h-[20rem] items-center justify-center text-4xl font-bold uppercase"${_scopeId2}> Aucune alerte en cours </div>`);
                  } else {
                    _push3(`<div class="flex flex-col gap-6"${_scopeId2}><!--[-->`);
                    ssrRenderList(unref(filterInProgressAlerts), (alert) => {
                      _push3(ssrRenderComponent(_component_alert_card, {
                        alert,
                        onUpdate: fetchAlerts
                      }, null, _parent3, _scopeId2));
                    });
                    _push3(`<!--]--></div>`);
                  }
                } else {
                  return [
                    createVNode(_component_form_title, { number: "" }, {
                      actions: withCtx(() => [
                        createVNode(_component_rounded_button, {
                          design: "1",
                          icon: "plus",
                          class: "ml-5 w-[40rem]",
                          onClick: openCreateAlert
                        }, {
                          default: withCtx(() => [
                            createTextVNode(" AJOUTER UNE ALERTE ")
                          ]),
                          _: 1
                        })
                      ]),
                      default: withCtx(() => [
                        createTextVNode("Mes alertes en cours ")
                      ]),
                      _: 1
                    }),
                    createVNode("div", { class: "mb-5" }, " Les alertes sont automatiquement supprim\xE9es une fois la date souhait\xE9e de d\xE9part d\xE9pass\xE9e. "),
                    unref(error) ? (openBlock(), createBlock(_component_Message, {
                      key: 0,
                      severity: "error"
                    }, {
                      default: withCtx(() => [
                        createTextVNode(toDisplayString(unref(error)), 1)
                      ]),
                      _: 1
                    })) : createCommentVNode("", true),
                    unref(loading) ? (openBlock(), createBlock(_component_spinner, {
                      key: 1,
                      class: "mx-auto"
                    })) : !unref(loading) && unref(filterInProgressAlerts).length === 0 ? (openBlock(), createBlock("div", {
                      key: 2,
                      class: "text-primary-lightest flex h-[20rem] items-center justify-center text-4xl font-bold uppercase"
                    }, " Aucune alerte en cours ")) : (openBlock(), createBlock("div", {
                      key: 3,
                      class: "flex flex-col gap-6"
                    }, [
                      (openBlock(true), createBlock(Fragment, null, renderList(unref(filterInProgressAlerts), (alert) => {
                        return openBlock(), createBlock(_component_alert_card, {
                          alert,
                          onUpdate: fetchAlerts
                        }, null, 8, ["alert"]);
                      }), 256))
                    ]))
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
          } else {
            return [
              createVNode(_component_section_container, {
                "mobile-padding": "",
                class: "max-w-container relative z-10 rounded-2xl bg-white px-24 py-16"
              }, {
                default: withCtx(() => [
                  createVNode(_component_form_title, { number: "" }, {
                    actions: withCtx(() => [
                      createVNode(_component_rounded_button, {
                        design: "1",
                        icon: "plus",
                        class: "ml-5 w-[40rem]",
                        onClick: openCreateAlert
                      }, {
                        default: withCtx(() => [
                          createTextVNode(" AJOUTER UNE ALERTE ")
                        ]),
                        _: 1
                      })
                    ]),
                    default: withCtx(() => [
                      createTextVNode("Mes alertes en cours ")
                    ]),
                    _: 1
                  }),
                  createVNode("div", { class: "mb-5" }, " Les alertes sont automatiquement supprim\xE9es une fois la date souhait\xE9e de d\xE9part d\xE9pass\xE9e. "),
                  unref(error) ? (openBlock(), createBlock(_component_Message, {
                    key: 0,
                    severity: "error"
                  }, {
                    default: withCtx(() => [
                      createTextVNode(toDisplayString(unref(error)), 1)
                    ]),
                    _: 1
                  })) : createCommentVNode("", true),
                  unref(loading) ? (openBlock(), createBlock(_component_spinner, {
                    key: 1,
                    class: "mx-auto"
                  })) : !unref(loading) && unref(filterInProgressAlerts).length === 0 ? (openBlock(), createBlock("div", {
                    key: 2,
                    class: "text-primary-lightest flex h-[20rem] items-center justify-center text-4xl font-bold uppercase"
                  }, " Aucune alerte en cours ")) : (openBlock(), createBlock("div", {
                    key: 3,
                    class: "flex flex-col gap-6"
                  }, [
                    (openBlock(true), createBlock(Fragment, null, renderList(unref(filterInProgressAlerts), (alert) => {
                      return openBlock(), createBlock(_component_alert_card, {
                        alert,
                        onUpdate: fetchAlerts
                      }, null, 8, ["alert"]);
                    }), 256))
                  ]))
                ]),
                _: 1
              })
            ];
          }
        }),
        _: 1
      }, _parent));
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("pages/dashboard/mes-alertes.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as default };
//# sourceMappingURL=mes-alertes-a6f9480d.mjs.map
