import { _ as __nuxt_component_0$1, a as __nuxt_component_1 } from './SectionContainer-5a7aa7e3.mjs';
import { _ as __nuxt_component_3 } from './SectionLayer-8e9d6e6a.mjs';
import { _ as __nuxt_component_8 } from './RoundedButton-a0ea68b9.mjs';
import { ref, resolveComponent, withCtx, createTextVNode, toDisplayString, unref, createVNode, withModifiers, openBlock, createBlock, createCommentVNode, useSSRContext } from 'vue';
import { ssrRenderAttrs, ssrRenderComponent, ssrInterpolate } from 'vue/server-renderer';
import { a as useNuxtApp } from '../server.mjs';
import { u as useAuthStore } from './auth-6d0727c5.mjs';
import { _ as __nuxt_component_0 } from './SmallPageHeader-c7029e3a.mjs';
import './Icon-7157bd57.mjs';
import 'ofetch';
import 'hookable';
import 'unctx';
import 'vue-router';
import 'h3';
import 'ufo';
import '@unhead/ssr';
import 'unhead';
import '@unhead/shared';
import 'dayjs';
import 'dayjs/plugin/relativeTime.js';
import 'dayjs/plugin/utc.js';
import 'dayjs/plugin/timezone.js';
import '@headlessui/vue';
import 'vue-i18n';
import 'defu';
import '../../nitro/node-server.mjs';
import 'node-fetch-native/polyfill';
import 'node:http';
import 'node:https';
import 'destr';
import 'unenv/runtime/fetch/index';
import 'scule';
import 'klona';
import 'ohash';
import 'unstorage';
import 'radix3';
import 'node:fs';
import 'node:url';
import 'pathe';
import 'http-graceful-shutdown';

const _sfc_main = {
  __name: "login",
  __ssrInlineRender: true,
  setup(__props) {
    const authStore = useAuthStore();
    const email = ref("");
    const password = ref("");
    const loading = ref(false);
    const error = ref(null);
    const { $api, $router, $toast } = useNuxtApp();
    const login = () => {
      loading.value = true;
      error.value = null;
      $api.call("post", $api.route("auth.login"), {
        email: email.value,
        password: password.value
      }).then((data) => {
        localStorage.setItem("token", data.access_token);
        return authStore.initSession().then((me) => {
          $toast.success(
            `Bonjour ${me.firstname} ${me.lastname} ! Vous voil\xE0 connect\xE9.`
          );
          $router.push("/dashboard");
        });
      }).catch((err) => {
        if (err.response && err.response.data.error) {
          error.value = err.response.data.error;
        } else {
          error.value = err.message;
        }
      }).finally(() => {
        loading.value = false;
        password.value = "";
      });
    };
    return (_ctx, _push, _parent, _attrs) => {
      const _component_section_wrapper = __nuxt_component_0$1;
      const _component_section_layer = __nuxt_component_3;
      const _component_section_container = __nuxt_component_1;
      const _component_Message = resolveComponent("Message");
      const _component_InputText = resolveComponent("InputText");
      const _component_rounded_button = __nuxt_component_8;
      _push(`<div${ssrRenderAttrs(_attrs)}>`);
      _push(ssrRenderComponent(__nuxt_component_0, {
        design: "primary",
        title: "Se connecter \xE0 votre espace"
      }, null, _parent));
      _push(ssrRenderComponent(_component_section_wrapper, { class: "relative bg-white" }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(ssrRenderComponent(_component_section_layer, {
              class: "bg-no-repeat max-[1735px]:hidden",
              style: { "background-position": "right 0 bottom 0" },
              background: "/images/ROND + PIN.png"
            }, null, _parent2, _scopeId));
            _push2(ssrRenderComponent(_component_section_container, {
              "mobile-padding": "",
              class: "max-w-container relative py-20"
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`<form class="mx-auto max-w-[30rem]"${_scopeId2}><div class="mb-10"${_scopeId2}><h2 class="text-primary mb-3 text-[1.75rem] font-semibold"${_scopeId2}> Connexion </h2>`);
                  if (error.value) {
                    _push3(ssrRenderComponent(_component_Message, { severity: "error" }, {
                      default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                        if (_push4) {
                          _push4(`${ssrInterpolate(error.value)}`);
                        } else {
                          return [
                            createTextVNode(toDisplayString(error.value), 1)
                          ];
                        }
                      }),
                      _: 1
                    }, _parent3, _scopeId2));
                  } else {
                    _push3(`<!---->`);
                  }
                  _push3(`<div class="mb-5"${_scopeId2}><label class="text-primary-lighter mb-2 block text-[0.75rem]"${_scopeId2}>Email</label>`);
                  _push3(ssrRenderComponent(_component_InputText, {
                    modelValue: email.value,
                    "onUpdate:modelValue": ($event) => email.value = $event,
                    type: "email",
                    placeholder: "Votre adresse email",
                    class: "w-full",
                    disabled: loading.value
                  }, null, _parent3, _scopeId2));
                  _push3(`</div><div class="mb-5"${_scopeId2}><label class="text-primary-lighter mb-2 block text-[0.75rem]"${_scopeId2}>Mot de passe</label>`);
                  _push3(ssrRenderComponent(_component_InputText, {
                    modelValue: password.value,
                    "onUpdate:modelValue": ($event) => password.value = $event,
                    type: "password",
                    placeholder: "Votre mot de passe",
                    class: "w-full",
                    disabled: loading.value
                  }, null, _parent3, _scopeId2));
                  _push3(`</div></div><div class="flex flex-col items-center justify-center gap-5"${_scopeId2}><div class="flex justify-center"${_scopeId2}>`);
                  _push3(ssrRenderComponent(_component_rounded_button, {
                    loading: loading.value,
                    type: "submit",
                    design: "4"
                  }, {
                    default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                      if (_push4) {
                        _push4(` Se connecter `);
                      } else {
                        return [
                          createTextVNode(" Se connecter ")
                        ];
                      }
                    }),
                    _: 1
                  }, _parent3, _scopeId2));
                  _push3(`</div><div class="flex justify-center"${_scopeId2}>`);
                  _push3(ssrRenderComponent(_component_rounded_button, {
                    to: "/auth/register",
                    design: "1",
                    onClick: ($event) => unref($router).push("/auth/register")
                  }, {
                    default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                      if (_push4) {
                        _push4(` Je n&#39;ai pas encore de compte, je m&#39;inscris `);
                      } else {
                        return [
                          createTextVNode(" Je n'ai pas encore de compte, je m'inscris ")
                        ];
                      }
                    }),
                    _: 1
                  }, _parent3, _scopeId2));
                  _push3(`</div><div class="flex justify-center"${_scopeId2}>`);
                  _push3(ssrRenderComponent(_component_rounded_button, {
                    design: "1",
                    onClick: ($event) => unref($router).push("/auth/forgot-password")
                  }, {
                    default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                      if (_push4) {
                        _push4(` J&#39;ai oubli\xE9 mon mot de passe `);
                      } else {
                        return [
                          createTextVNode(" J'ai oubli\xE9 mon mot de passe ")
                        ];
                      }
                    }),
                    _: 1
                  }, _parent3, _scopeId2));
                  _push3(`</div></div></form>`);
                } else {
                  return [
                    createVNode("form", {
                      onSubmit: withModifiers(login, ["prevent"]),
                      class: "mx-auto max-w-[30rem]"
                    }, [
                      createVNode("div", { class: "mb-10" }, [
                        createVNode("h2", { class: "text-primary mb-3 text-[1.75rem] font-semibold" }, " Connexion "),
                        error.value ? (openBlock(), createBlock(_component_Message, {
                          key: 0,
                          severity: "error"
                        }, {
                          default: withCtx(() => [
                            createTextVNode(toDisplayString(error.value), 1)
                          ]),
                          _: 1
                        })) : createCommentVNode("", true),
                        createVNode("div", { class: "mb-5" }, [
                          createVNode("label", { class: "text-primary-lighter mb-2 block text-[0.75rem]" }, "Email"),
                          createVNode(_component_InputText, {
                            modelValue: email.value,
                            "onUpdate:modelValue": ($event) => email.value = $event,
                            type: "email",
                            placeholder: "Votre adresse email",
                            class: "w-full",
                            disabled: loading.value
                          }, null, 8, ["modelValue", "onUpdate:modelValue", "disabled"])
                        ]),
                        createVNode("div", { class: "mb-5" }, [
                          createVNode("label", { class: "text-primary-lighter mb-2 block text-[0.75rem]" }, "Mot de passe"),
                          createVNode(_component_InputText, {
                            modelValue: password.value,
                            "onUpdate:modelValue": ($event) => password.value = $event,
                            type: "password",
                            placeholder: "Votre mot de passe",
                            class: "w-full",
                            disabled: loading.value
                          }, null, 8, ["modelValue", "onUpdate:modelValue", "disabled"])
                        ])
                      ]),
                      createVNode("div", { class: "flex flex-col items-center justify-center gap-5" }, [
                        createVNode("div", { class: "flex justify-center" }, [
                          createVNode(_component_rounded_button, {
                            loading: loading.value,
                            type: "submit",
                            design: "4"
                          }, {
                            default: withCtx(() => [
                              createTextVNode(" Se connecter ")
                            ]),
                            _: 1
                          }, 8, ["loading"])
                        ]),
                        createVNode("div", { class: "flex justify-center" }, [
                          createVNode(_component_rounded_button, {
                            to: "/auth/register",
                            design: "1",
                            onClick: ($event) => unref($router).push("/auth/register")
                          }, {
                            default: withCtx(() => [
                              createTextVNode(" Je n'ai pas encore de compte, je m'inscris ")
                            ]),
                            _: 1
                          }, 8, ["onClick"])
                        ]),
                        createVNode("div", { class: "flex justify-center" }, [
                          createVNode(_component_rounded_button, {
                            design: "1",
                            onClick: ($event) => unref($router).push("/auth/forgot-password")
                          }, {
                            default: withCtx(() => [
                              createTextVNode(" J'ai oubli\xE9 mon mot de passe ")
                            ]),
                            _: 1
                          }, 8, ["onClick"])
                        ])
                      ])
                    ], 40, ["onSubmit"])
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
          } else {
            return [
              createVNode(_component_section_layer, {
                class: "bg-no-repeat max-[1735px]:hidden",
                style: { "background-position": "right 0 bottom 0" },
                background: "/images/ROND + PIN.png"
              }),
              createVNode(_component_section_container, {
                "mobile-padding": "",
                class: "max-w-container relative py-20"
              }, {
                default: withCtx(() => [
                  createVNode("form", {
                    onSubmit: withModifiers(login, ["prevent"]),
                    class: "mx-auto max-w-[30rem]"
                  }, [
                    createVNode("div", { class: "mb-10" }, [
                      createVNode("h2", { class: "text-primary mb-3 text-[1.75rem] font-semibold" }, " Connexion "),
                      error.value ? (openBlock(), createBlock(_component_Message, {
                        key: 0,
                        severity: "error"
                      }, {
                        default: withCtx(() => [
                          createTextVNode(toDisplayString(error.value), 1)
                        ]),
                        _: 1
                      })) : createCommentVNode("", true),
                      createVNode("div", { class: "mb-5" }, [
                        createVNode("label", { class: "text-primary-lighter mb-2 block text-[0.75rem]" }, "Email"),
                        createVNode(_component_InputText, {
                          modelValue: email.value,
                          "onUpdate:modelValue": ($event) => email.value = $event,
                          type: "email",
                          placeholder: "Votre adresse email",
                          class: "w-full",
                          disabled: loading.value
                        }, null, 8, ["modelValue", "onUpdate:modelValue", "disabled"])
                      ]),
                      createVNode("div", { class: "mb-5" }, [
                        createVNode("label", { class: "text-primary-lighter mb-2 block text-[0.75rem]" }, "Mot de passe"),
                        createVNode(_component_InputText, {
                          modelValue: password.value,
                          "onUpdate:modelValue": ($event) => password.value = $event,
                          type: "password",
                          placeholder: "Votre mot de passe",
                          class: "w-full",
                          disabled: loading.value
                        }, null, 8, ["modelValue", "onUpdate:modelValue", "disabled"])
                      ])
                    ]),
                    createVNode("div", { class: "flex flex-col items-center justify-center gap-5" }, [
                      createVNode("div", { class: "flex justify-center" }, [
                        createVNode(_component_rounded_button, {
                          loading: loading.value,
                          type: "submit",
                          design: "4"
                        }, {
                          default: withCtx(() => [
                            createTextVNode(" Se connecter ")
                          ]),
                          _: 1
                        }, 8, ["loading"])
                      ]),
                      createVNode("div", { class: "flex justify-center" }, [
                        createVNode(_component_rounded_button, {
                          to: "/auth/register",
                          design: "1",
                          onClick: ($event) => unref($router).push("/auth/register")
                        }, {
                          default: withCtx(() => [
                            createTextVNode(" Je n'ai pas encore de compte, je m'inscris ")
                          ]),
                          _: 1
                        }, 8, ["onClick"])
                      ]),
                      createVNode("div", { class: "flex justify-center" }, [
                        createVNode(_component_rounded_button, {
                          design: "1",
                          onClick: ($event) => unref($router).push("/auth/forgot-password")
                        }, {
                          default: withCtx(() => [
                            createTextVNode(" J'ai oubli\xE9 mon mot de passe ")
                          ]),
                          _: 1
                        }, 8, ["onClick"])
                      ])
                    ])
                  ], 40, ["onSubmit"])
                ]),
                _: 1
              })
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div>`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("pages/auth/login.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as default };
//# sourceMappingURL=login-99d5a6f6.mjs.map
