import { _ as __nuxt_component_0 } from './SmallPageHeader-c7029e3a.mjs';
import { _ as __nuxt_component_0$1, a as __nuxt_component_1 } from './SectionContainer-5a7aa7e3.mjs';
import { _ as __nuxt_component_3 } from './SectionLayer-8e9d6e6a.mjs';
import { _ as __nuxt_component_5 } from './FormField-14acbd69.mjs';
import { _ as __nuxt_component_8 } from './RoundedButton-a0ea68b9.mjs';
import { ref, resolveComponent, withCtx, createTextVNode, toDisplayString, createVNode, unref, withModifiers, openBlock, createBlock, createCommentVNode, useSSRContext } from 'vue';
import { ssrRenderAttrs, ssrRenderComponent, ssrInterpolate } from 'vue/server-renderer';
import { a as useNuxtApp } from '../server.mjs';
import { u as useAuthStore } from './auth-6d0727c5.mjs';
import './Icon-7157bd57.mjs';
import 'ofetch';
import 'hookable';
import 'unctx';
import 'vue-router';
import 'h3';
import 'ufo';
import '@unhead/ssr';
import 'unhead';
import '@unhead/shared';
import 'dayjs';
import 'dayjs/plugin/relativeTime.js';
import 'dayjs/plugin/utc.js';
import 'dayjs/plugin/timezone.js';
import '@headlessui/vue';
import 'vue-i18n';
import 'defu';
import '../../nitro/node-server.mjs';
import 'node-fetch-native/polyfill';
import 'node:http';
import 'node:https';
import 'destr';
import 'unenv/runtime/fetch/index';
import 'scule';
import 'klona';
import 'ohash';
import 'unstorage';
import 'radix3';
import 'node:fs';
import 'node:url';
import 'pathe';
import 'http-graceful-shutdown';

const _sfc_main = {
  __name: "forgot-password",
  __ssrInlineRender: true,
  setup(__props) {
    useAuthStore();
    const email = ref("");
    const sendCodeLoading = ref(false);
    const resetLoading = ref(false);
    const error = ref(null);
    const { $api, $router, $toast } = useNuxtApp();
    const codeSent = ref(false);
    const code = ref("");
    const password = ref("");
    const confirmPassword = ref("");
    const validationErrors = ref({});
    const sendCode = async () => {
      sendCodeLoading.value = true;
      error.value = null;
      validationErrors.value = {};
      try {
        await $api.call("post", $api.route("auth.password-recovery"), {
          email: email.value
        });
        $toast.success(
          "Un code de r\xE9initialisation vous a \xE9t\xE9 envoy\xE9 par email (si l'adresse email est valide)"
        );
        codeSent.value = true;
      } catch (e) {
        if (e.response) {
          if (e.response.status === 422) {
            validationErrors.value = e.response.data.errors;
            error.value = "Veuillez corriger les erreurs dans le formulaire";
          } else {
            error.value = e.response.data.message;
          }
        } else {
          error.value = e.message;
        }
      } finally {
        sendCodeLoading.value = false;
      }
    };
    const resetPassword = async () => {
      resetLoading.value = true;
      error.value = null;
      validationErrors.value = {};
      try {
        await $api.call("post", $api.route("auth.reset-password"), {
          email: email.value,
          code: code.value,
          password: password.value,
          password_confirmation: confirmPassword.value
        });
        $toast.success("Votre mot de passe a \xE9t\xE9 r\xE9initialis\xE9 avec succ\xE8s");
        $router.push("/auth/login");
      } catch (e) {
        if (e.response) {
          if (e.response.status === 422) {
            validationErrors.value = e.response.data.errors;
            error.value = "Veuillez corriger les erreurs dans le formulaire";
          } else {
            error.value = e.response.data.message;
          }
        } else {
          error.value = e.message;
        }
      } finally {
        resetLoading.value = false;
      }
    };
    return (_ctx, _push, _parent, _attrs) => {
      const _component_small_page_header = __nuxt_component_0;
      const _component_section_wrapper = __nuxt_component_0$1;
      const _component_section_layer = __nuxt_component_3;
      const _component_section_container = __nuxt_component_1;
      const _component_Message = resolveComponent("Message");
      const _component_FormField = __nuxt_component_5;
      const _component_InputText = resolveComponent("InputText");
      const _component_rounded_button = __nuxt_component_8;
      _push(`<div${ssrRenderAttrs(_attrs)}>`);
      _push(ssrRenderComponent(_component_small_page_header, {
        design: "primary",
        title: "R\xE9initialiser votre mot de passe"
      }, null, _parent));
      _push(ssrRenderComponent(_component_section_wrapper, { class: "relative bg-white" }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(ssrRenderComponent(_component_section_layer, {
              class: "bg-no-repeat max-[1735px]:hidden",
              style: { "background-position": "right 0 bottom 0" },
              background: "/images/ROND + PIN.png"
            }, null, _parent2, _scopeId));
            if (!codeSent.value) {
              _push2(ssrRenderComponent(_component_section_container, {
                "mobile-padding": "",
                class: "max-w-container relative py-20"
              }, {
                default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    _push3(`<form class="mx-auto max-w-[50rem]"${_scopeId2}><div class="mb-10"${_scopeId2}><h2 class="text-primary mb-3 text-[1.75rem] font-semibold"${_scopeId2}> Entrez votre adresse email </h2><div class="mb-5"${_scopeId2}> Vous recevrez un code de r\xE9initialisation par email </div>`);
                    if (error.value) {
                      _push3(ssrRenderComponent(_component_Message, { severity: "error" }, {
                        default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                          if (_push4) {
                            _push4(`${ssrInterpolate(error.value)}`);
                          } else {
                            return [
                              createTextVNode(toDisplayString(error.value), 1)
                            ];
                          }
                        }),
                        _: 1
                      }, _parent3, _scopeId2));
                    } else {
                      _push3(`<!---->`);
                    }
                    _push3(ssrRenderComponent(_component_FormField, {
                      class: "mb-2",
                      name: "email",
                      errors: validationErrors.value
                    }, {
                      default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                        if (_push4) {
                          _push4(ssrRenderComponent(_component_InputText, {
                            modelValue: email.value,
                            "onUpdate:modelValue": ($event) => email.value = $event,
                            type: "email",
                            placeholder: "Votre adresse email",
                            class: ["w-full", `w-full ${validationErrors.value.email ? "p-invalid" : ""}`],
                            disabled: sendCodeLoading.value
                          }, null, _parent4, _scopeId3));
                        } else {
                          return [
                            createVNode(_component_InputText, {
                              modelValue: email.value,
                              "onUpdate:modelValue": ($event) => email.value = $event,
                              type: "email",
                              placeholder: "Votre adresse email",
                              class: ["w-full", `w-full ${validationErrors.value.email ? "p-invalid" : ""}`],
                              disabled: sendCodeLoading.value
                            }, null, 8, ["modelValue", "onUpdate:modelValue", "disabled", "class"])
                          ];
                        }
                      }),
                      _: 1
                    }, _parent3, _scopeId2));
                    _push3(`<div class="flex items-center justify-end gap-5"${_scopeId2}>`);
                    _push3(ssrRenderComponent(_component_rounded_button, {
                      type: "button",
                      design: "1",
                      onClick: ($event) => unref($router).push("/auth/login")
                    }, {
                      default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                        if (_push4) {
                          _push4(` Retour \xE0 la page de connexion `);
                        } else {
                          return [
                            createTextVNode(" Retour \xE0 la page de connexion ")
                          ];
                        }
                      }),
                      _: 1
                    }, _parent3, _scopeId2));
                    _push3(ssrRenderComponent(_component_rounded_button, {
                      loading: sendCodeLoading.value,
                      type: "submit",
                      design: "4"
                    }, {
                      default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                        if (_push4) {
                          _push4(` Envoyer moi un code de r\xE9initialisation par email `);
                        } else {
                          return [
                            createTextVNode(" Envoyer moi un code de r\xE9initialisation par email ")
                          ];
                        }
                      }),
                      _: 1
                    }, _parent3, _scopeId2));
                    _push3(`</div></div></form><p class="text-[0.8em]"${_scopeId2}> Vos donn\xE9es \xE0 caract\xE8re personnel sont trait\xE9es par FUNERE SAS afin de r\xE9initialiser votre mot de passe. Pour plus de renseignements, vous pouvez consulter notre <a href="/politique-de-confidentialite"${_scopeId2}><u${_scopeId2}>politique de confidentialit\xE9</u></a></p>`);
                  } else {
                    return [
                      createVNode("form", {
                        onSubmit: withModifiers(sendCode, ["prevent"]),
                        class: "mx-auto max-w-[50rem]"
                      }, [
                        createVNode("div", { class: "mb-10" }, [
                          createVNode("h2", { class: "text-primary mb-3 text-[1.75rem] font-semibold" }, " Entrez votre adresse email "),
                          createVNode("div", { class: "mb-5" }, " Vous recevrez un code de r\xE9initialisation par email "),
                          error.value ? (openBlock(), createBlock(_component_Message, {
                            key: 0,
                            severity: "error"
                          }, {
                            default: withCtx(() => [
                              createTextVNode(toDisplayString(error.value), 1)
                            ]),
                            _: 1
                          })) : createCommentVNode("", true),
                          createVNode(_component_FormField, {
                            class: "mb-2",
                            name: "email",
                            errors: validationErrors.value
                          }, {
                            default: withCtx(() => [
                              createVNode(_component_InputText, {
                                modelValue: email.value,
                                "onUpdate:modelValue": ($event) => email.value = $event,
                                type: "email",
                                placeholder: "Votre adresse email",
                                class: ["w-full", `w-full ${validationErrors.value.email ? "p-invalid" : ""}`],
                                disabled: sendCodeLoading.value
                              }, null, 8, ["modelValue", "onUpdate:modelValue", "disabled", "class"])
                            ]),
                            _: 1
                          }, 8, ["errors"]),
                          createVNode("div", { class: "flex items-center justify-end gap-5" }, [
                            createVNode(_component_rounded_button, {
                              type: "button",
                              design: "1",
                              onClick: ($event) => unref($router).push("/auth/login")
                            }, {
                              default: withCtx(() => [
                                createTextVNode(" Retour \xE0 la page de connexion ")
                              ]),
                              _: 1
                            }, 8, ["onClick"]),
                            createVNode(_component_rounded_button, {
                              loading: sendCodeLoading.value,
                              type: "submit",
                              design: "4"
                            }, {
                              default: withCtx(() => [
                                createTextVNode(" Envoyer moi un code de r\xE9initialisation par email ")
                              ]),
                              _: 1
                            }, 8, ["loading"])
                          ])
                        ])
                      ], 40, ["onSubmit"]),
                      createVNode("p", { class: "text-[0.8em]" }, [
                        createTextVNode(" Vos donn\xE9es \xE0 caract\xE8re personnel sont trait\xE9es par FUNERE SAS afin de r\xE9initialiser votre mot de passe. Pour plus de renseignements, vous pouvez consulter notre "),
                        createVNode("a", { href: "/politique-de-confidentialite" }, [
                          createVNode("u", null, "politique de confidentialit\xE9")
                        ])
                      ])
                    ];
                  }
                }),
                _: 1
              }, _parent2, _scopeId));
            } else {
              _push2(ssrRenderComponent(_component_section_container, {
                "mobile-padding": "",
                class: "max-w-container relative py-20"
              }, {
                default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    _push3(`<form class="mx-auto max-w-[50rem]"${_scopeId2}><div class="mb-10"${_scopeId2}><h2 class="text-primary mb-3 text-[1.75rem] font-semibold"${_scopeId2}> R\xE9initialiser votre mot de passe </h2><div class="mb-5"${_scopeId2}> D\xE9finissez un nouveau mot de passe pour votre compte </div>`);
                    if (error.value) {
                      _push3(ssrRenderComponent(_component_Message, { severity: "error" }, {
                        default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                          if (_push4) {
                            _push4(`${ssrInterpolate(error.value)}`);
                          } else {
                            return [
                              createTextVNode(toDisplayString(error.value), 1)
                            ];
                          }
                        }),
                        _: 1
                      }, _parent3, _scopeId2));
                    } else {
                      _push3(`<!---->`);
                    }
                    _push3(ssrRenderComponent(_component_FormField, {
                      class: "mb-2",
                      name: "code",
                      label: "Code de r\xE9initialisation",
                      errors: validationErrors.value
                    }, {
                      default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                        if (_push4) {
                          _push4(ssrRenderComponent(_component_InputText, {
                            modelValue: code.value,
                            "onUpdate:modelValue": ($event) => code.value = $event,
                            error: validationErrors.value.code,
                            type: "text",
                            placeholder: "Code de r\xE9initialisation re\xE7u par email",
                            class: ["w-full", `w-full ${validationErrors.value.code ? "p-invalid" : ""}`],
                            disabled: resetLoading.value
                          }, null, _parent4, _scopeId3));
                          _push4(`<small${_scopeId3}>Attention, le code de r\xE9initialisation est valable 15 minutes</small>`);
                        } else {
                          return [
                            createVNode(_component_InputText, {
                              modelValue: code.value,
                              "onUpdate:modelValue": ($event) => code.value = $event,
                              error: validationErrors.value.code,
                              type: "text",
                              placeholder: "Code de r\xE9initialisation re\xE7u par email",
                              class: ["w-full", `w-full ${validationErrors.value.code ? "p-invalid" : ""}`],
                              disabled: resetLoading.value
                            }, null, 8, ["modelValue", "onUpdate:modelValue", "error", "disabled", "class"]),
                            createVNode("small", null, "Attention, le code de r\xE9initialisation est valable 15 minutes")
                          ];
                        }
                      }),
                      _: 1
                    }, _parent3, _scopeId2));
                    _push3(ssrRenderComponent(_component_FormField, {
                      class: "mb-2",
                      name: "password",
                      label: "Nouveau mot de passe",
                      errors: validationErrors.value
                    }, {
                      default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                        if (_push4) {
                          _push4(ssrRenderComponent(_component_InputText, {
                            modelValue: password.value,
                            "onUpdate:modelValue": ($event) => password.value = $event,
                            error: validationErrors.value.password,
                            type: "password",
                            placeholder: "Nouveau mot de passe",
                            class: ["w-full", `w-full ${validationErrors.value.password ? "p-invalid" : ""}`],
                            disabled: resetLoading.value
                          }, null, _parent4, _scopeId3));
                        } else {
                          return [
                            createVNode(_component_InputText, {
                              modelValue: password.value,
                              "onUpdate:modelValue": ($event) => password.value = $event,
                              error: validationErrors.value.password,
                              type: "password",
                              placeholder: "Nouveau mot de passe",
                              class: ["w-full", `w-full ${validationErrors.value.password ? "p-invalid" : ""}`],
                              disabled: resetLoading.value
                            }, null, 8, ["modelValue", "onUpdate:modelValue", "error", "disabled", "class"])
                          ];
                        }
                      }),
                      _: 1
                    }, _parent3, _scopeId2));
                    _push3(ssrRenderComponent(_component_FormField, {
                      class: "mb-10",
                      name: "password_confirmation",
                      label: "Confirmation mot de passe",
                      errors: validationErrors.value
                    }, {
                      default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                        if (_push4) {
                          _push4(ssrRenderComponent(_component_InputText, {
                            modelValue: confirmPassword.value,
                            "onUpdate:modelValue": ($event) => confirmPassword.value = $event,
                            error: validationErrors.value.password_confirmation,
                            type: "password",
                            placeholder: "Confirmer le nouveau mot de passe",
                            class: "w-full",
                            disabled: resetLoading.value
                          }, null, _parent4, _scopeId3));
                        } else {
                          return [
                            createVNode(_component_InputText, {
                              modelValue: confirmPassword.value,
                              "onUpdate:modelValue": ($event) => confirmPassword.value = $event,
                              error: validationErrors.value.password_confirmation,
                              type: "password",
                              placeholder: "Confirmer le nouveau mot de passe",
                              class: "w-full",
                              disabled: resetLoading.value
                            }, null, 8, ["modelValue", "onUpdate:modelValue", "error", "disabled"])
                          ];
                        }
                      }),
                      _: 1
                    }, _parent3, _scopeId2));
                    _push3(`<div class="flex items-center justify-end gap-5"${_scopeId2}>`);
                    _push3(ssrRenderComponent(_component_rounded_button, {
                      design: "1",
                      type: "button",
                      onClick: ($event) => unref($router).push("/auth/login")
                    }, {
                      default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                        if (_push4) {
                          _push4(` Retour \xE0 la page de connexion `);
                        } else {
                          return [
                            createTextVNode(" Retour \xE0 la page de connexion ")
                          ];
                        }
                      }),
                      _: 1
                    }, _parent3, _scopeId2));
                    _push3(ssrRenderComponent(_component_rounded_button, {
                      loading: resetLoading.value,
                      type: "submit",
                      design: "4"
                    }, {
                      default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                        if (_push4) {
                          _push4(` R\xE9initialiser mon mot de passe `);
                        } else {
                          return [
                            createTextVNode(" R\xE9initialiser mon mot de passe ")
                          ];
                        }
                      }),
                      _: 1
                    }, _parent3, _scopeId2));
                    _push3(`</div></div></form>`);
                  } else {
                    return [
                      createVNode("form", {
                        onSubmit: withModifiers(resetPassword, ["prevent"]),
                        class: "mx-auto max-w-[50rem]"
                      }, [
                        createVNode("div", { class: "mb-10" }, [
                          createVNode("h2", { class: "text-primary mb-3 text-[1.75rem] font-semibold" }, " R\xE9initialiser votre mot de passe "),
                          createVNode("div", { class: "mb-5" }, " D\xE9finissez un nouveau mot de passe pour votre compte "),
                          error.value ? (openBlock(), createBlock(_component_Message, {
                            key: 0,
                            severity: "error"
                          }, {
                            default: withCtx(() => [
                              createTextVNode(toDisplayString(error.value), 1)
                            ]),
                            _: 1
                          })) : createCommentVNode("", true),
                          createVNode(_component_FormField, {
                            class: "mb-2",
                            name: "code",
                            label: "Code de r\xE9initialisation",
                            errors: validationErrors.value
                          }, {
                            default: withCtx(() => [
                              createVNode(_component_InputText, {
                                modelValue: code.value,
                                "onUpdate:modelValue": ($event) => code.value = $event,
                                error: validationErrors.value.code,
                                type: "text",
                                placeholder: "Code de r\xE9initialisation re\xE7u par email",
                                class: ["w-full", `w-full ${validationErrors.value.code ? "p-invalid" : ""}`],
                                disabled: resetLoading.value
                              }, null, 8, ["modelValue", "onUpdate:modelValue", "error", "disabled", "class"]),
                              createVNode("small", null, "Attention, le code de r\xE9initialisation est valable 15 minutes")
                            ]),
                            _: 1
                          }, 8, ["errors"]),
                          createVNode(_component_FormField, {
                            class: "mb-2",
                            name: "password",
                            label: "Nouveau mot de passe",
                            errors: validationErrors.value
                          }, {
                            default: withCtx(() => [
                              createVNode(_component_InputText, {
                                modelValue: password.value,
                                "onUpdate:modelValue": ($event) => password.value = $event,
                                error: validationErrors.value.password,
                                type: "password",
                                placeholder: "Nouveau mot de passe",
                                class: ["w-full", `w-full ${validationErrors.value.password ? "p-invalid" : ""}`],
                                disabled: resetLoading.value
                              }, null, 8, ["modelValue", "onUpdate:modelValue", "error", "disabled", "class"])
                            ]),
                            _: 1
                          }, 8, ["errors"]),
                          createVNode(_component_FormField, {
                            class: "mb-10",
                            name: "password_confirmation",
                            label: "Confirmation mot de passe",
                            errors: validationErrors.value
                          }, {
                            default: withCtx(() => [
                              createVNode(_component_InputText, {
                                modelValue: confirmPassword.value,
                                "onUpdate:modelValue": ($event) => confirmPassword.value = $event,
                                error: validationErrors.value.password_confirmation,
                                type: "password",
                                placeholder: "Confirmer le nouveau mot de passe",
                                class: "w-full",
                                disabled: resetLoading.value
                              }, null, 8, ["modelValue", "onUpdate:modelValue", "error", "disabled"])
                            ]),
                            _: 1
                          }, 8, ["errors"]),
                          createVNode("div", { class: "flex items-center justify-end gap-5" }, [
                            createVNode(_component_rounded_button, {
                              design: "1",
                              type: "button",
                              onClick: ($event) => unref($router).push("/auth/login")
                            }, {
                              default: withCtx(() => [
                                createTextVNode(" Retour \xE0 la page de connexion ")
                              ]),
                              _: 1
                            }, 8, ["onClick"]),
                            createVNode(_component_rounded_button, {
                              loading: resetLoading.value,
                              type: "submit",
                              design: "4"
                            }, {
                              default: withCtx(() => [
                                createTextVNode(" R\xE9initialiser mon mot de passe ")
                              ]),
                              _: 1
                            }, 8, ["loading"])
                          ])
                        ])
                      ], 40, ["onSubmit"])
                    ];
                  }
                }),
                _: 1
              }, _parent2, _scopeId));
            }
          } else {
            return [
              createVNode(_component_section_layer, {
                class: "bg-no-repeat max-[1735px]:hidden",
                style: { "background-position": "right 0 bottom 0" },
                background: "/images/ROND + PIN.png"
              }),
              !codeSent.value ? (openBlock(), createBlock(_component_section_container, {
                key: 0,
                "mobile-padding": "",
                class: "max-w-container relative py-20"
              }, {
                default: withCtx(() => [
                  createVNode("form", {
                    onSubmit: withModifiers(sendCode, ["prevent"]),
                    class: "mx-auto max-w-[50rem]"
                  }, [
                    createVNode("div", { class: "mb-10" }, [
                      createVNode("h2", { class: "text-primary mb-3 text-[1.75rem] font-semibold" }, " Entrez votre adresse email "),
                      createVNode("div", { class: "mb-5" }, " Vous recevrez un code de r\xE9initialisation par email "),
                      error.value ? (openBlock(), createBlock(_component_Message, {
                        key: 0,
                        severity: "error"
                      }, {
                        default: withCtx(() => [
                          createTextVNode(toDisplayString(error.value), 1)
                        ]),
                        _: 1
                      })) : createCommentVNode("", true),
                      createVNode(_component_FormField, {
                        class: "mb-2",
                        name: "email",
                        errors: validationErrors.value
                      }, {
                        default: withCtx(() => [
                          createVNode(_component_InputText, {
                            modelValue: email.value,
                            "onUpdate:modelValue": ($event) => email.value = $event,
                            type: "email",
                            placeholder: "Votre adresse email",
                            class: ["w-full", `w-full ${validationErrors.value.email ? "p-invalid" : ""}`],
                            disabled: sendCodeLoading.value
                          }, null, 8, ["modelValue", "onUpdate:modelValue", "disabled", "class"])
                        ]),
                        _: 1
                      }, 8, ["errors"]),
                      createVNode("div", { class: "flex items-center justify-end gap-5" }, [
                        createVNode(_component_rounded_button, {
                          type: "button",
                          design: "1",
                          onClick: ($event) => unref($router).push("/auth/login")
                        }, {
                          default: withCtx(() => [
                            createTextVNode(" Retour \xE0 la page de connexion ")
                          ]),
                          _: 1
                        }, 8, ["onClick"]),
                        createVNode(_component_rounded_button, {
                          loading: sendCodeLoading.value,
                          type: "submit",
                          design: "4"
                        }, {
                          default: withCtx(() => [
                            createTextVNode(" Envoyer moi un code de r\xE9initialisation par email ")
                          ]),
                          _: 1
                        }, 8, ["loading"])
                      ])
                    ])
                  ], 40, ["onSubmit"]),
                  createVNode("p", { class: "text-[0.8em]" }, [
                    createTextVNode(" Vos donn\xE9es \xE0 caract\xE8re personnel sont trait\xE9es par FUNERE SAS afin de r\xE9initialiser votre mot de passe. Pour plus de renseignements, vous pouvez consulter notre "),
                    createVNode("a", { href: "/politique-de-confidentialite" }, [
                      createVNode("u", null, "politique de confidentialit\xE9")
                    ])
                  ])
                ]),
                _: 1
              })) : (openBlock(), createBlock(_component_section_container, {
                key: 1,
                "mobile-padding": "",
                class: "max-w-container relative py-20"
              }, {
                default: withCtx(() => [
                  createVNode("form", {
                    onSubmit: withModifiers(resetPassword, ["prevent"]),
                    class: "mx-auto max-w-[50rem]"
                  }, [
                    createVNode("div", { class: "mb-10" }, [
                      createVNode("h2", { class: "text-primary mb-3 text-[1.75rem] font-semibold" }, " R\xE9initialiser votre mot de passe "),
                      createVNode("div", { class: "mb-5" }, " D\xE9finissez un nouveau mot de passe pour votre compte "),
                      error.value ? (openBlock(), createBlock(_component_Message, {
                        key: 0,
                        severity: "error"
                      }, {
                        default: withCtx(() => [
                          createTextVNode(toDisplayString(error.value), 1)
                        ]),
                        _: 1
                      })) : createCommentVNode("", true),
                      createVNode(_component_FormField, {
                        class: "mb-2",
                        name: "code",
                        label: "Code de r\xE9initialisation",
                        errors: validationErrors.value
                      }, {
                        default: withCtx(() => [
                          createVNode(_component_InputText, {
                            modelValue: code.value,
                            "onUpdate:modelValue": ($event) => code.value = $event,
                            error: validationErrors.value.code,
                            type: "text",
                            placeholder: "Code de r\xE9initialisation re\xE7u par email",
                            class: ["w-full", `w-full ${validationErrors.value.code ? "p-invalid" : ""}`],
                            disabled: resetLoading.value
                          }, null, 8, ["modelValue", "onUpdate:modelValue", "error", "disabled", "class"]),
                          createVNode("small", null, "Attention, le code de r\xE9initialisation est valable 15 minutes")
                        ]),
                        _: 1
                      }, 8, ["errors"]),
                      createVNode(_component_FormField, {
                        class: "mb-2",
                        name: "password",
                        label: "Nouveau mot de passe",
                        errors: validationErrors.value
                      }, {
                        default: withCtx(() => [
                          createVNode(_component_InputText, {
                            modelValue: password.value,
                            "onUpdate:modelValue": ($event) => password.value = $event,
                            error: validationErrors.value.password,
                            type: "password",
                            placeholder: "Nouveau mot de passe",
                            class: ["w-full", `w-full ${validationErrors.value.password ? "p-invalid" : ""}`],
                            disabled: resetLoading.value
                          }, null, 8, ["modelValue", "onUpdate:modelValue", "error", "disabled", "class"])
                        ]),
                        _: 1
                      }, 8, ["errors"]),
                      createVNode(_component_FormField, {
                        class: "mb-10",
                        name: "password_confirmation",
                        label: "Confirmation mot de passe",
                        errors: validationErrors.value
                      }, {
                        default: withCtx(() => [
                          createVNode(_component_InputText, {
                            modelValue: confirmPassword.value,
                            "onUpdate:modelValue": ($event) => confirmPassword.value = $event,
                            error: validationErrors.value.password_confirmation,
                            type: "password",
                            placeholder: "Confirmer le nouveau mot de passe",
                            class: "w-full",
                            disabled: resetLoading.value
                          }, null, 8, ["modelValue", "onUpdate:modelValue", "error", "disabled"])
                        ]),
                        _: 1
                      }, 8, ["errors"]),
                      createVNode("div", { class: "flex items-center justify-end gap-5" }, [
                        createVNode(_component_rounded_button, {
                          design: "1",
                          type: "button",
                          onClick: ($event) => unref($router).push("/auth/login")
                        }, {
                          default: withCtx(() => [
                            createTextVNode(" Retour \xE0 la page de connexion ")
                          ]),
                          _: 1
                        }, 8, ["onClick"]),
                        createVNode(_component_rounded_button, {
                          loading: resetLoading.value,
                          type: "submit",
                          design: "4"
                        }, {
                          default: withCtx(() => [
                            createTextVNode(" R\xE9initialiser mon mot de passe ")
                          ]),
                          _: 1
                        }, 8, ["loading"])
                      ])
                    ])
                  ], 40, ["onSubmit"])
                ]),
                _: 1
              }))
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div>`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("pages/auth/forgot-password.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as default };
//# sourceMappingURL=forgot-password-fee4c139.mjs.map
