import { _ as __nuxt_component_3$1 } from './Icon-7157bd57.mjs';
import { u as useDayjs } from './dayjs-9d0b29d3.mjs';
import { useSSRContext, ref, computed, mergeProps } from 'vue';
import { ssrRenderAttrs, ssrRenderComponent, ssrInterpolate, ssrRenderSlot } from 'vue/server-renderer';
import { u as useConfigStore } from './config-f619f9d4.mjs';

const _sfc_main$1 = {
  __name: "BaseRouteCard",
  __ssrInlineRender: true,
  props: {
    route: {
      type: Object,
      required: true
    }
  },
  setup(__props) {
    const dayjs = useDayjs();
    ref(false);
    computed(() => {
      return route.value.distance / 1e3;
    });
    const formattedDate = (departureDate, departureTimeOfDay) => {
      departureTimeOfDay = departureTimeOfDay === "morning" ? "au matin (00h00 \xE0 11h59)" : "apr\xE8s-midi (12h00 \xE0 23h59)";
      return "D\xE9part le " + dayjs(departureDate).format("DD/MM/YYYY") + " " + departureTimeOfDay;
    };
    return (_ctx, _push, _parent, _attrs) => {
      var _a;
      const _component_icon = __nuxt_component_3$1;
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "border-primary-lightest max:md:justify-start w-full rounded-2xl border-2 p-7 transition-colors md:px-16 md:py-14" }, _attrs))}>`);
      if ((_a = __props.route) == null ? void 0 : _a.departure_date) {
        _push(`<div class="text-primary mb-5 flex items-center justify-between uppercase"><div>`);
        _push(ssrRenderComponent(_component_icon, {
          icon: "calendrier",
          class: "mr-2 h-6 w-6"
        }, null, _parent));
        _push(`<span>${ssrInterpolate(formattedDate(__props.route.departure_date, __props.route.departure_time_of_day))}</span></div><div class="flex items-center">`);
        ssrRenderSlot(_ctx.$slots, "actions", {}, null, _push, _parent);
        _push(`</div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="flex flex-col justify-between gap-3 border-b-2 border-dotted pb-5 lg:flex-row"><div class="text-primary flex flex-col"><div class="flex min-h-[4rem]"><div class="mr-3 flex flex-col items-center py-2"><div class="bg-secondary h-4 w-4 rounded-full"></div><div class="border-primary-lighter grow border-l-4 border-dotted border-opacity-60"></div><div class="bg-ternary h-4 w-4 rounded-full"></div></div><div class="flex flex-col justify-between whitespace-nowrap text-[1.5rem] font-semibold leading-[1.5rem]"><div>`);
      ssrRenderSlot(_ctx.$slots, "origin-name", {}, () => {
        var _a2, _b;
        _push(`${ssrInterpolate((_b = (_a2 = __props.route) == null ? void 0 : _a2.origin_city) == null ? void 0 : _b.name)}`);
      }, _push, _parent);
      _push(`</div><div>`);
      ssrRenderSlot(_ctx.$slots, "destination-name", {}, () => {
        var _a2, _b;
        _push(`${ssrInterpolate((_b = (_a2 = __props.route) == null ? void 0 : _a2.destination_city) == null ? void 0 : _b.name)}`);
      }, _push, _parent);
      _push(`</div></div></div></div><div class="max-md:py-3">`);
      ssrRenderSlot(_ctx.$slots, "main", {}, null, _push, _parent);
      _push(`</div></div><div class="pt-4">`);
      ssrRenderSlot(_ctx.$slots, "footer", {}, null, _push, _parent);
      _push(`</div></div>`);
    };
  }
};
const _sfc_setup$1 = _sfc_main$1.setup;
_sfc_main$1.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/cards/routes/BaseRouteCard.vue");
  return _sfc_setup$1 ? _sfc_setup$1(props, ctx) : void 0;
};
const __nuxt_component_0 = _sfc_main$1;
const _sfc_main = {
  __name: "Price",
  __ssrInlineRender: true,
  props: {
    pricing: {
      type: Object,
      required: true
    }
  },
  setup(__props) {
    useConfigStore();
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "flex" }, _attrs))}><div class="max-md:flex max-md:justify-center max-sm:flex max-sm:flex-col md:ml-auto md:text-right"><div class="text-primary flex flex items-start text-[2.5rem] font-bold max-md:mr-10 sm:justify-center md:justify-end">${ssrInterpolate(_ctx.$n(__props.pricing.total_ttc, "decimal"))} <span class="text-[1.8rem]">\u20AC <sup class="text-[12px]">TTC</sup></span></div><div class="max-sm:flex max-sm:flex-col"><div class="text-primary font-medium text-[0.75]">D\xE9tail du prix</div><div class="text-neutral-lighter"><div> Prise en charge <span class="font-bold">${ssrInterpolate(_ctx.$n(__props.pricing.pickup_fee, "currency"))}</span></div><div> Prix kilom\xE9trique <span class="font-bold">${ssrInterpolate(_ctx.$n(__props.pricing.km_price, "currency"))}</span></div><div> Commission Furnargos <span class="font-bold">${ssrInterpolate(_ctx.$n(__props.pricing.funargos_commission, "currency"))}</span></div></div></div></div></div>`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/Price.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
const __nuxt_component_3 = _sfc_main;

export { __nuxt_component_0 as _, __nuxt_component_3 as a };
//# sourceMappingURL=Price-aaf3d10e.mjs.map
