import { _ as __nuxt_component_3 } from './Icon-7157bd57.mjs';
import { mergeProps, useSSRContext, resolveComponent } from 'vue';
import { ssrRenderAttrs, ssrRenderClass, ssrRenderComponent, ssrRenderSlot, ssrRenderStyle, ssrInterpolate } from 'vue/server-renderer';
import { _ as _export_sfc } from '../server.mjs';

const _sfc_main$1 = {
  props: {
    icon: {
      type: String,
      required: true,
      default: "info"
    },
    design: {
      type: String,
      required: true,
      default: "1"
    }
  },
  data() {
    return {};
  },
  computed: {
    classes() {
      const styleClasses = {
        1: "bg-primary-light hover:bg-primary hover:text-white-light text-[#4C6287] text-white active:bg-primary-lighter active:text-white-light",
        2: "bg-secondary-light hover:bg-secondary hover:text-white-light text-[#4C6287] text-white active:bg-secondary-lighter active:text-white-light",
        3: "bg-ternary-light hover:bg-ternary hover:text-white-light text-[#4C6287] text-white active:bg-ternary-lighter active:text-white-light"
      };
      return `${styleClasses[this.design]}`;
    }
  }
};
function _sfc_ssrRender$1(_ctx, _push, _parent, _attrs, $props, $setup, $data, $options) {
  const _component_Icon = __nuxt_component_3;
  _push(`<a${ssrRenderAttrs(mergeProps({ href: "#" }, _attrs))}><div class="${ssrRenderClass(`${$options.classes} group overflow-hidden rounded-3xl px-10 pb-14 pt-16 transition-colors`)}">`);
  _push(ssrRenderComponent(_component_Icon, {
    icon: $props.icon,
    class: "mb-8 h-[2.5rem] w-[2.5rem]"
  }, null, _parent));
  _push(`<div class="flex flex-col justify-between"><h2 class="mb-10 min-h-[7rem] text-3xl font-bold">`);
  ssrRenderSlot(_ctx.$slots, "default", {}, null, _push, _parent);
  _push(`</h2><div class="justify-end"><p class="tiny mb-2 font-medium">EN SAVOIR +</p><div class="h-0.5 w-24 rounded-full bg-white/40"><div class="transition-width transition-slowest ease h-0.5 w-0 rounded-full bg-white group-hover:w-full"></div></div></div></div></div></a>`);
}
const _sfc_setup$1 = _sfc_main$1.setup;
_sfc_main$1.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/cards/CtaCard.vue");
  return _sfc_setup$1 ? _sfc_setup$1(props, ctx) : void 0;
};
const __nuxt_component_9 = /* @__PURE__ */ _export_sfc(_sfc_main$1, [["ssrRender", _sfc_ssrRender$1]]);
const _sfc_main = {
  props: {
    number: {
      type: Number,
      required: true,
      default: 0
    },
    loading: {
      type: Boolean,
      required: false,
      default: false
    }
  },
  computed: {
    isNumber() {
      return typeof this.number === "number";
    }
  }
};
function _sfc_ssrRender(_ctx, _push, _parent, _attrs, $props, $setup, $data, $options) {
  const _component_Skeleton = resolveComponent("Skeleton");
  _push(`<div${ssrRenderAttrs(_attrs)}>`);
  if ($props.loading) {
    _push(ssrRenderComponent(_component_Skeleton, {
      shape: "circle",
      size: "9rem"
    }, null, _parent));
  } else {
    _push(`<div class="text-primary flex h-[9rem] w-[9rem] items-center justify-center bg-contain bg-no-repeat text-[2.5rem] font-bold" style="${ssrRenderStyle({ "background-image": "url('/images/BACKGROUND CHIFFRES.png')" })}">${ssrInterpolate(!$options.isNumber ? "?" : _ctx.$n($props.number, { minimumFractionDigits: 0, maximumFractionDigits: 0 }))}</div>`);
  }
  _push(`</div>`);
}
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/CircleNumber.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
const __nuxt_component_6 = /* @__PURE__ */ _export_sfc(_sfc_main, [["ssrRender", _sfc_ssrRender]]);

export { __nuxt_component_9 as _, __nuxt_component_6 as a };
//# sourceMappingURL=CircleNumber-b5fd293b.mjs.map
