import { _ as __nuxt_component_0$1, a as __nuxt_component_1$1 } from "./PageHeaderButton-fe814fea.js";
import { _ as __nuxt_component_0$2, a as __nuxt_component_1$2 } from "./SectionContainer-5a7aa7e3.js";
import { _ as __nuxt_component_4 } from "./FormTitle-afe32d73.js";
import { _ as __nuxt_component_5 } from "./FormField-14acbd69.js";
import { cloneDeep } from "lodash";
import { resolveComponent, mergeProps, withCtx, createTextVNode, toDisplayString, useSSRContext, ref, unref, createVNode, openBlock, createBlock, createCommentVNode, computed, watch } from "vue";
import { ssrRenderComponent, ssrInterpolate, ssrRenderStyle } from "vue/server-renderer";
import { _ as _export_sfc, b as script, n as useRouter, a as useNuxtApp } from "../server.mjs";
import { _ as __nuxt_component_0$3 } from "./nuxt-link-801c5f56.js";
import { _ as __nuxt_component_8 } from "./RoundedButton-a0ea68b9.js";
import { _ as __nuxt_component_0 } from "./SectionTitle-2692cd9d.js";
import { _ as __nuxt_component_1 } from "./AvailableRouteCard-3afeb6c6.js";
import { s as script$1 } from "./checkbox.esm-59d1629e.js";
import "vue-router";
import "destr";
import "devalue";
import "klona";
import { u as useDayjs } from "./dayjs-9d0b29d3.js";
import { C as CitySelectField } from "./CitySelectField-385f4d0e.js";
import "./PageHeaderTitle-dc315c2d.js";
import "./Icon-7157bd57.js";
import "ofetch";
import "#internal/nitro";
import "hookable";
import "unctx";
import "h3";
import "ufo";
import "@vue/devtools-api";
import "@unhead/ssr";
import "unhead";
import "@unhead/shared";
import "dayjs";
import "dayjs/locale/fr.js";
import "dayjs/plugin/relativeTime.js";
import "dayjs/plugin/utc.js";
import "dayjs/plugin/timezone.js";
import "@headlessui/vue";
import "vue-i18n";
import "vue3-popper";
import "defu";
import "./Price-aaf3d10e.js";
import "./config-f619f9d4.js";
const _sfc_main$3 = {
  props: {
    placeholder: {
      type: String,
      default: ""
    },
    modelValue: {
      type: Number,
      default: ""
    },
    disabled: {
      type: Boolean,
      default: false
    }
  },
  watch: {
    internalValue(val) {
      this.$emit("update:modelValue", val);
    }
  },
  data() {
    return {
      internalValue: null,
      loading: false,
      options: []
    };
  },
  mounted: function() {
    this.getVehicles();
  },
  methods: {
    select(e) {
      if (e.value) {
        this.$emit("update:modelValue", e.value);
      }
    },
    getVehicles() {
      this.loading = true;
      return this.$api.call("get", this.$api.route("me.operators.index")).then((payload) => {
        this.options = payload.map((operator) => ({
          label: `${operator.identifier}`,
          value: operator.id
        }));
      }).finally(() => {
        this.loading = false;
      });
    }
  }
};
function _sfc_ssrRender$1(_ctx, _push, _parent, _attrs, $props, $setup, $data, $options) {
  const _component_Dropdown = resolveComponent("Dropdown");
  _push(ssrRenderComponent(_component_Dropdown, mergeProps({
    modelValue: $data.internalValue,
    "onUpdate:modelValue": ($event) => $data.internalValue = $event,
    options: $data.options,
    optionValue: "value",
    optionLabel: "label",
    placeholder: "Choisir un chauffeur",
    disabled: $data.loading || $props.disabled,
    class: `w-full`
  }, _attrs), {
    option: withCtx((slotProps, _push2, _parent2, _scopeId) => {
      if (_push2) {
        _push2(`${ssrInterpolate(slotProps.option.label)}`);
      } else {
        return [
          createTextVNode(toDisplayString(slotProps.option.label), 1)
        ];
      }
    }),
    _: 1
  }, _parent));
}
const _sfc_setup$3 = _sfc_main$3.setup;
_sfc_main$3.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/form/OperatorSelect.vue");
  return _sfc_setup$3 ? _sfc_setup$3(props, ctx) : void 0;
};
const __nuxt_component_6 = /* @__PURE__ */ _export_sfc(_sfc_main$3, [["ssrRender", _sfc_ssrRender$1]]);
const _sfc_main$2 = {
  __name: "PublishRouteModal",
  __ssrInlineRender: true,
  props: {
    route: {
      type: Object,
      default: null
    },
    loading: {
      type: Boolean,
      default: false
    },
    opened: {
      type: Boolean,
      default: false
    }
  },
  emits: ["close", "publish"],
  setup(__props, { emit }) {
    const checked = ref();
    const error = ref(null);
    const close = () => {
      emit("close");
    };
    const publish = () => {
      emit("publish");
    };
    return (_ctx, _push, _parent, _attrs) => {
      const _component_section_title = __nuxt_component_0;
      const _component_available_route_card = __nuxt_component_1;
      const _component_Message = resolveComponent("Message");
      const _component_rounded_button = __nuxt_component_8;
      _push(ssrRenderComponent(unref(script), mergeProps({
        visible: __props.opened,
        "dismissable-mask": "",
        "onUpdate:visible": (value) => {
          if (!value) {
            close();
          }
        },
        modal: "",
        pt: {
          header: { style: " display:none" },
          content: { style: "padding: 0 !important;border-radius: 10px " }
        }
      }, _attrs), {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<div class="flex h-full flex-col justify-between p-10"${_scopeId}><div class="mb-5 flex items-center justify-end"${_scopeId}><button class="bg-background-3 text-primary flex h-8 w-8 items-center justify-center rounded-full"${_scopeId}><span class="font-bold"${_scopeId}>X</span></button></div><div class="mb-5 flex items-center justify-center"${_scopeId}>`);
            _push2(ssrRenderComponent(_component_section_title, null, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`Confirmation de publication de trajet`);
                } else {
                  return [
                    createTextVNode("Confirmation de publication de trajet")
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
            _push2(`</div><div class="mx-auto flex w-4/5"${_scopeId}>`);
            _push2(ssrRenderComponent(_component_available_route_card, {
              route: __props.route,
              "hide-booking": ""
            }, null, _parent2, _scopeId));
            _push2(`</div>`);
            if (error.value) {
              _push2(ssrRenderComponent(_component_Message, { severity: "error" }, {
                default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    _push3(`${ssrInterpolate(error.value)}`);
                  } else {
                    return [
                      createTextVNode(toDisplayString(error.value), 1)
                    ];
                  }
                }),
                _: 1
              }, _parent2, _scopeId));
            } else {
              _push2(`<!---->`);
            }
            _push2(`<div class="my-10"${_scopeId}> En validant cette étape, vous confirmez la mise en ligne de votre annonce de trajet.<br${_scopeId}> Vous serez alerté par SMS et e-mail dès qu&#39;une demande de réservation sera effectuée.<br${_scopeId}> Les demandes de trajet correspondant à vos paramètres d&#39;intervention et se trouvant sur votre itinéraire vous seront proposées.<br${_scopeId}> Le prix du trajet sera ajusté en fonction de la distance parcourue.<br${_scopeId}></div><div class="my-10 flex items-center"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(script$1), {
              required: "",
              name: "checked",
              inputId: "check-route-confirm",
              binary: true,
              class: "mr-2",
              modelValue: checked.value,
              "onUpdate:modelValue": ($event) => checked.value = $event
            }, null, _parent2, _scopeId));
            _push2(`<label for="check-route-confirm" class="text-primary cursor-pointer"${_scopeId}>Je confirme la mise en ligne de mon trajet ? </label></div>`);
            _push2(ssrRenderComponent(_component_rounded_button, {
              disabled: !checked.value,
              class: "mx-auto w-[20rem] px-5",
              design: "3",
              type: "submit",
              loading: __props.loading,
              size: "lg",
              onClick: publish
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`${ssrInterpolate(__props.loading ? "Publication en cours..." : "PUBLIER")}`);
                } else {
                  return [
                    createTextVNode(toDisplayString(__props.loading ? "Publication en cours..." : "PUBLIER"), 1)
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
            _push2(`</div>`);
          } else {
            return [
              createVNode("div", { class: "flex h-full flex-col justify-between p-10" }, [
                createVNode("div", { class: "mb-5 flex items-center justify-end" }, [
                  createVNode("button", {
                    class: "bg-background-3 text-primary flex h-8 w-8 items-center justify-center rounded-full",
                    onClick: close
                  }, [
                    createVNode("span", { class: "font-bold" }, "X")
                  ])
                ]),
                createVNode("div", { class: "mb-5 flex items-center justify-center" }, [
                  createVNode(_component_section_title, null, {
                    default: withCtx(() => [
                      createTextVNode("Confirmation de publication de trajet")
                    ]),
                    _: 1
                  })
                ]),
                createVNode("div", { class: "mx-auto flex w-4/5" }, [
                  createVNode(_component_available_route_card, {
                    route: __props.route,
                    "hide-booking": ""
                  }, null, 8, ["route"])
                ]),
                error.value ? (openBlock(), createBlock(_component_Message, {
                  key: 0,
                  severity: "error"
                }, {
                  default: withCtx(() => [
                    createTextVNode(toDisplayString(error.value), 1)
                  ]),
                  _: 1
                })) : createCommentVNode("", true),
                createVNode("div", { class: "my-10" }, [
                  createTextVNode(" En validant cette étape, vous confirmez la mise en ligne de votre annonce de trajet."),
                  createVNode("br"),
                  createTextVNode(" Vous serez alerté par SMS et e-mail dès qu'une demande de réservation sera effectuée."),
                  createVNode("br"),
                  createTextVNode(" Les demandes de trajet correspondant à vos paramètres d'intervention et se trouvant sur votre itinéraire vous seront proposées."),
                  createVNode("br"),
                  createTextVNode(" Le prix du trajet sera ajusté en fonction de la distance parcourue."),
                  createVNode("br")
                ]),
                createVNode("div", { class: "my-10 flex items-center" }, [
                  createVNode(unref(script$1), {
                    required: "",
                    name: "checked",
                    inputId: "check-route-confirm",
                    binary: true,
                    class: "mr-2",
                    modelValue: checked.value,
                    "onUpdate:modelValue": ($event) => checked.value = $event
                  }, null, 8, ["modelValue", "onUpdate:modelValue"]),
                  createVNode("label", {
                    for: "check-route-confirm",
                    class: "text-primary cursor-pointer"
                  }, "Je confirme la mise en ligne de mon trajet ? ")
                ]),
                createVNode(_component_rounded_button, {
                  disabled: !checked.value,
                  class: "mx-auto w-[20rem] px-5",
                  design: "3",
                  type: "submit",
                  loading: __props.loading,
                  size: "lg",
                  onClick: publish
                }, {
                  default: withCtx(() => [
                    createTextVNode(toDisplayString(__props.loading ? "Publication en cours..." : "PUBLIER"), 1)
                  ]),
                  _: 1
                }, 8, ["disabled", "loading"])
              ])
            ];
          }
        }),
        _: 1
      }, _parent));
    };
  }
};
const _sfc_setup$2 = _sfc_main$2.setup;
_sfc_main$2.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/modals/PublishRouteModal.vue");
  return _sfc_setup$2 ? _sfc_setup$2(props, ctx) : void 0;
};
const __nuxt_component_9 = _sfc_main$2;
const _sfc_main$1 = {
  props: {
    placeholder: {
      type: String,
      default: ""
    },
    modelValue: {
      type: Number,
      default: ""
    },
    disabled: {
      type: Boolean,
      default: false
    }
  },
  watch: {
    internalValue(val) {
      this.$emit("update:modelValue", val);
    }
  },
  data() {
    return {
      internalValue: null,
      loading: false,
      options: []
    };
  },
  mounted: function() {
    this.getVehicles();
  },
  methods: {
    select(e) {
      if (e.value) {
        this.$emit("update:modelValue", e.value);
      }
    },
    getVehicles() {
      this.loading = true;
      return this.$api.call("get", this.$api.route("me.vehicles.index")).then((payload) => {
        this.options = payload.map((vehicle) => ({
          label: `${vehicle.name} (${vehicle.license_plate})`,
          value: vehicle.id
        }));
      }).finally(() => {
        this.loading = false;
      });
    }
  }
};
function _sfc_ssrRender(_ctx, _push, _parent, _attrs, $props, $setup, $data, $options) {
  const _component_Dropdown = resolveComponent("Dropdown");
  _push(ssrRenderComponent(_component_Dropdown, mergeProps({
    modelValue: $data.internalValue,
    "onUpdate:modelValue": ($event) => $data.internalValue = $event,
    options: $data.options,
    optionValue: "value",
    optionLabel: "label",
    placeholder: "Choisir un véhicule",
    disabled: $data.loading || $props.disabled,
    class: `w-full`
  }, _attrs), {
    option: withCtx((slotProps, _push2, _parent2, _scopeId) => {
      if (_push2) {
        _push2(`${ssrInterpolate(slotProps.option.label)}`);
      } else {
        return [
          createTextVNode(toDisplayString(slotProps.option.label), 1)
        ];
      }
    }),
    _: 1
  }, _parent));
}
const _sfc_setup$1 = _sfc_main$1.setup;
_sfc_main$1.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/form/VehicleSelect.vue");
  return _sfc_setup$1 ? _sfc_setup$1(props, ctx) : void 0;
};
const VehicleSelect = /* @__PURE__ */ _export_sfc(_sfc_main$1, [["ssrRender", _sfc_ssrRender]]);
const _sfc_main = {
  __name: "publier-un-trajet",
  __ssrInlineRender: true,
  setup(__props) {
    const router = useRouter();
    const { $api, $toast } = useNuxtApp();
    const dayjs = useDayjs();
    const error = ref(null);
    const loading = ref(false);
    const success = ref(null);
    const simulatedRoute = ref(null);
    const validationErrors = ref({});
    const accept = ref(false);
    const showConfirmationModal = ref(false);
    const axeWidth = computed(() => {
      return 24 + routeData.value.axe_radius / 200 * 240;
    });
    const originScale = computed(() => {
      return 1 + routeData.value.origin_radius / 200 * 10;
    });
    const destinationScale = computed(() => {
      return 1 + routeData.value.destination_radius / 200 * 10;
    });
    const routeData = ref({
      departure_date: /* @__PURE__ */ new Date(),
      departure_time_of_day: "morning",
      origin: null,
      origin_radius: 50,
      destination: null,
      destination_radius: 50,
      axe_radius: 100,
      km_price: 0,
      pickup_fee: 0,
      vehicle_id: null,
      operator_id: null,
      type: null
    });
    const hasBeenSubmitted = ref(false);
    watch(
      () => routeData.value,
      (value) => {
        if (hasBeenSubmitted.value) {
          validate();
        }
      },
      { deep: true }
    );
    const validate = () => {
      validationErrors.value = {};
      if (!routeData.value.origin) {
        validationErrors.value.origin = ["La ville de départ est obligatoire"];
      }
      if (!routeData.value.destination) {
        validationErrors.value.destination = ["La ville d'arrivée est obligatoire"];
      }
      if (routeData.value.origin && routeData.value.destination) {
        if (routeData.value.origin.id == routeData.value.destination.id) {
          validationErrors.value.origin = [
            "La ville de départ et la ville d'arrivée doivent être différentes"
          ];
        }
      }
      if (!routeData.value.operator_id) {
        validationErrors.value.operator_id = [
          "Le choix du chauffeur est obligatoire"
        ];
      }
      if (!routeData.value.vehicle_id) {
        validationErrors.value.vehicle_id = [
          "Le choix du véhicule est obligatoire"
        ];
      }
    };
    const hasValidationErrors = computed(() => {
      return Object.keys(validationErrors.value).length > 0;
    });
    const createRoute = (dry = false) => {
      const payload = cloneDeep(routeData.value);
      payload.origin = payload.origin.id;
      payload.destination = payload.destination.id;
      console.log(payload.departure_date);
      payload.departure_date = dayjs(payload.departure_date).format("YYYY-MM-DD");
      loading.value = true;
      return $api.call("post", $api.route("routes.store"), payload, {
        dry
      }).then((data) => {
        if (dry) {
          return data;
        }
        $toast.success("Trajet publié avec succès");
        success.value = "Trajet publié avec succès";
        router.push({
          path: "/dashboard/mes-trajets-publies"
        });
      }).catch((e) => {
        if (e.response) {
          if (e.response.data.message) {
            $toast.error(e.response.data.message);
            error.value = e.response.data.message;
          }
          if (e.response.status == 422) {
            if (e.response.data.errors) {
              $toast.error("Un ou plusieurs champs sont invalides");
              error.value = "Un ou plusieurs champs sont invalides";
              validationErrors.value = e.response.data.errors;
            }
          } else {
            if (e.response.data.error) {
              $toast.error(e.response.data.error);
              error.value = e.response.data.error;
            }
          }
        } else {
          error.value = e.message;
        }
        throw e;
      }).finally(() => {
        loading.value = false;
      });
    };
    return (_ctx, _push, _parent, _attrs) => {
      const _component_page_header = __nuxt_component_0$1;
      const _component_page_header_button = __nuxt_component_1$1;
      const _component_section_wrapper = __nuxt_component_0$2;
      const _component_section_container = __nuxt_component_1$2;
      const _component_form_title = __nuxt_component_4;
      const _component_FormField = __nuxt_component_5;
      const _component_Calendar = resolveComponent("Calendar");
      const _component_RadioButton = resolveComponent("RadioButton");
      const _component_Slider = resolveComponent("Slider");
      const _component_OperatorSelect = __nuxt_component_6;
      const _component_InputNumber = resolveComponent("InputNumber");
      const _component_Message = resolveComponent("Message");
      const _component_NuxtLink = __nuxt_component_0$3;
      const _component_rounded_button = __nuxt_component_8;
      const _component_publish_route_modal = __nuxt_component_9;
      _push(`<!--[-->`);
      _push(ssrRenderComponent(_component_page_header, {
        title: "Publier un trajet",
        description: "Publiez votre trajet et optimisez vos déplacements",
        design: "secondary"
      }, {
        buttons: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(ssrRenderComponent(_component_page_header_button, {
              design: "secondary",
              icon: "pin",
              to: "#trajet"
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`Votre trajet `);
                } else {
                  return [
                    createTextVNode("Votre trajet ")
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
            _push2(ssrRenderComponent(_component_page_header_button, {
              design: "secondary",
              icon: "vos-conditions",
              to: "#conditions"
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`Vos conditions `);
                } else {
                  return [
                    createTextVNode("Vos conditions ")
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
            _push2(ssrRenderComponent(_component_page_header_button, {
              design: "secondary",
              icon: "check",
              to: "#publish"
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`Publier `);
                } else {
                  return [
                    createTextVNode("Publier ")
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
          } else {
            return [
              createVNode(_component_page_header_button, {
                design: "secondary",
                icon: "pin",
                to: "#trajet"
              }, {
                default: withCtx(() => [
                  createTextVNode("Votre trajet ")
                ]),
                _: 1
              }),
              createVNode(_component_page_header_button, {
                design: "secondary",
                icon: "vos-conditions",
                to: "#conditions"
              }, {
                default: withCtx(() => [
                  createTextVNode("Vos conditions ")
                ]),
                _: 1
              }),
              createVNode(_component_page_header_button, {
                design: "secondary",
                icon: "check",
                to: "#publish"
              }, {
                default: withCtx(() => [
                  createTextVNode("Publier ")
                ]),
                _: 1
              })
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`<form>`);
      _push(ssrRenderComponent(_component_section_wrapper, {
        class: "bg-background-1 py-10",
        id: "trajet"
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(ssrRenderComponent(_component_section_container, {
              "mobile-padding": "",
              class: "max-w-container relative z-10 rounded-2xl bg-white px-24 py-16"
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(ssrRenderComponent(_component_form_title, { number: "01" }, {
                    default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                      if (_push4) {
                        _push4(`Votre trajet`);
                      } else {
                        return [
                          createTextVNode("Votre trajet")
                        ];
                      }
                    }),
                    _: 1
                  }, _parent3, _scopeId2));
                  _push3(`<div class="grid-cols-2 lg:grid"${_scopeId2}><div class="bg-background-1 l w-full rounded-2xl p-16"${_scopeId2}>`);
                  _push3(ssrRenderComponent(_component_FormField, {
                    class: "mb-5 w-full",
                    name: "departure_date",
                    label: "Date de départ",
                    errors: validationErrors.value
                  }, {
                    default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                      if (_push4) {
                        _push4(`<div class="p-input-icon-right"${_scopeId3}><i class="pi pi-pencil"${_scopeId3}></i>`);
                        _push4(ssrRenderComponent(_component_Calendar, {
                          "date-format": "dd/mm/yy",
                          showIcon: "",
                          "min-date": unref(dayjs)().toDate(),
                          "max-date": unref(dayjs)().add(30, "day").toDate(),
                          modelValue: routeData.value.departure_date,
                          "onUpdate:modelValue": ($event) => routeData.value.departure_date = $event,
                          placeholder: "Date de départ",
                          class: `w-full ${validationErrors.value.departure_date ? "p-invalid" : ""}`,
                          disabled: loading.value
                        }, null, _parent4, _scopeId3));
                        _push4(`</div>`);
                      } else {
                        return [
                          createVNode("div", { class: "p-input-icon-right" }, [
                            createVNode("i", { class: "pi pi-pencil" }),
                            createVNode(_component_Calendar, {
                              "date-format": "dd/mm/yy",
                              showIcon: "",
                              "min-date": unref(dayjs)().toDate(),
                              "max-date": unref(dayjs)().add(30, "day").toDate(),
                              modelValue: routeData.value.departure_date,
                              "onUpdate:modelValue": ($event) => routeData.value.departure_date = $event,
                              placeholder: "Date de départ",
                              class: `w-full ${validationErrors.value.departure_date ? "p-invalid" : ""}`,
                              disabled: loading.value
                            }, null, 8, ["min-date", "max-date", "modelValue", "onUpdate:modelValue", "class", "disabled"])
                          ])
                        ];
                      }
                    }),
                    _: 1
                  }, _parent3, _scopeId2));
                  _push3(`<div class="mb-5 flex-col flex-wrap gap-x-3 gap-y-2"${_scopeId2}><div class="align-items-center mb-2 flex"${_scopeId2}>`);
                  _push3(ssrRenderComponent(_component_RadioButton, {
                    modelValue: routeData.value.departure_time_of_day,
                    "onUpdate:modelValue": ($event) => routeData.value.departure_time_of_day = $event,
                    inputId: "morning",
                    name: "morning",
                    value: "morning",
                    class: `w-full ${validationErrors.value.departure_time_of_day ? "p-invalid" : ""}`
                  }, null, _parent3, _scopeId2));
                  _push3(`<label for="morning" class="text-primary ml-2 cursor-pointer font-normal"${_scopeId2}>Matin (de 00h00 à 11h59)</label></div><div class="align-items-center mb-2 flex"${_scopeId2}>`);
                  _push3(ssrRenderComponent(_component_RadioButton, {
                    modelValue: routeData.value.departure_time_of_day,
                    "onUpdate:modelValue": ($event) => routeData.value.departure_time_of_day = $event,
                    inputId: "afternoon",
                    name: "afternoon",
                    value: "afternoon",
                    class: `w-full ${validationErrors.value.departure_time_of_day ? "p-invalid" : ""}`
                  }, null, _parent3, _scopeId2));
                  _push3(`<label for="afternoon" class="text-primary ml-2 cursor-pointer font-normal"${_scopeId2}>Après-midi (de 12h00 à 23h59)</label></div></div>`);
                  _push3(ssrRenderComponent(_component_FormField, {
                    class: "mb-5 w-full",
                    "label-class": "text-secondary",
                    name: "origin",
                    label: "Ville de départ",
                    errors: validationErrors.value
                  }, {
                    default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                      if (_push4) {
                        _push4(ssrRenderComponent(CitySelectField, {
                          placeholder: "Entrez la ville de départ",
                          "return-object": "",
                          modelValue: routeData.value.origin,
                          "onUpdate:modelValue": ($event) => routeData.value.origin = $event,
                          disabled: loading.value,
                          class: `w-full ${validationErrors.value.origin ? "p-invalid" : ""}`
                        }, null, _parent4, _scopeId3));
                      } else {
                        return [
                          createVNode(CitySelectField, {
                            placeholder: "Entrez la ville de départ",
                            "return-object": "",
                            modelValue: routeData.value.origin,
                            "onUpdate:modelValue": ($event) => routeData.value.origin = $event,
                            disabled: loading.value,
                            class: `w-full ${validationErrors.value.origin ? "p-invalid" : ""}`
                          }, null, 8, ["modelValue", "onUpdate:modelValue", "disabled", "class"])
                        ];
                      }
                    }),
                    _: 1
                  }, _parent3, _scopeId2));
                  _push3(ssrRenderComponent(_component_FormField, {
                    class: "mb-10 w-full",
                    "label-class": "text-secondary",
                    name: "origin_radius",
                    label: `Rayon d'intervention départ (${routeData.value.origin_radius} km)`,
                    errors: validationErrors.value
                  }, {
                    default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                      if (_push4) {
                        _push4(ssrRenderComponent(_component_Slider, {
                          max: 200,
                          min: 0,
                          disabled: loading.value,
                          modelValue: routeData.value.origin_radius,
                          "onUpdate:modelValue": ($event) => routeData.value.origin_radius = $event,
                          step: 10,
                          class: "mb-2",
                          pt: {
                            root: { class: "w-14rem" },
                            handle: {
                              style: "background-color: #96B938; border:none"
                            },
                            range: { style: "background-color: #96B938; " }
                          }
                        }, null, _parent4, _scopeId3));
                      } else {
                        return [
                          createVNode(_component_Slider, {
                            max: 200,
                            min: 0,
                            disabled: loading.value,
                            modelValue: routeData.value.origin_radius,
                            "onUpdate:modelValue": ($event) => routeData.value.origin_radius = $event,
                            step: 10,
                            class: "mb-2",
                            pt: {
                              root: { class: "w-14rem" },
                              handle: {
                                style: "background-color: #96B938; border:none"
                              },
                              range: { style: "background-color: #96B938; " }
                            }
                          }, null, 8, ["disabled", "modelValue", "onUpdate:modelValue"])
                        ];
                      }
                    }),
                    _: 1
                  }, _parent3, _scopeId2));
                  _push3(ssrRenderComponent(_component_FormField, {
                    class: "mb-5 w-full",
                    name: "destination",
                    label: "Ville d'arrivée",
                    "label-class": "text-ternary",
                    errors: validationErrors.value
                  }, {
                    default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                      if (_push4) {
                        _push4(ssrRenderComponent(CitySelectField, {
                          placeholder: "Entrez la ville d'arrivée",
                          modelValue: routeData.value.destination,
                          "onUpdate:modelValue": ($event) => routeData.value.destination = $event,
                          "return-object": "",
                          disabled: loading.value,
                          class: `w-full ${validationErrors.value.destination ? "p-invalid" : ""}`
                        }, null, _parent4, _scopeId3));
                      } else {
                        return [
                          createVNode(CitySelectField, {
                            placeholder: "Entrez la ville d'arrivée",
                            modelValue: routeData.value.destination,
                            "onUpdate:modelValue": ($event) => routeData.value.destination = $event,
                            "return-object": "",
                            disabled: loading.value,
                            class: `w-full ${validationErrors.value.destination ? "p-invalid" : ""}`
                          }, null, 8, ["modelValue", "onUpdate:modelValue", "disabled", "class"])
                        ];
                      }
                    }),
                    _: 1
                  }, _parent3, _scopeId2));
                  _push3(ssrRenderComponent(_component_FormField, {
                    class: "mb-10 w-full",
                    name: "destination_radius",
                    "label-class": "text-ternary",
                    label: `Rayon d'intervention d'arrivée (${routeData.value.destination_radius} km)`,
                    errors: validationErrors.value
                  }, {
                    default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                      if (_push4) {
                        _push4(ssrRenderComponent(_component_Slider, {
                          max: 200,
                          min: 0,
                          modelValue: routeData.value.destination_radius,
                          "onUpdate:modelValue": ($event) => routeData.value.destination_radius = $event,
                          step: 10,
                          class: "mb-2",
                          pt: {
                            root: { class: "w-14rem" },
                            handle: {
                              style: "background-color: #00A2B3; border:none"
                            },
                            range: { style: "background-color: #00A2B3; " }
                          }
                        }, null, _parent4, _scopeId3));
                      } else {
                        return [
                          createVNode(_component_Slider, {
                            max: 200,
                            min: 0,
                            modelValue: routeData.value.destination_radius,
                            "onUpdate:modelValue": ($event) => routeData.value.destination_radius = $event,
                            step: 10,
                            class: "mb-2",
                            pt: {
                              root: { class: "w-14rem" },
                              handle: {
                                style: "background-color: #00A2B3; border:none"
                              },
                              range: { style: "background-color: #00A2B3; " }
                            }
                          }, null, 8, ["modelValue", "onUpdate:modelValue"])
                        ];
                      }
                    }),
                    _: 1
                  }, _parent3, _scopeId2));
                  _push3(ssrRenderComponent(_component_FormField, {
                    class: "mb-5 w-full",
                    name: "axe_radius",
                    "label-class": "text-fire",
                    label: `Rayon sur l'axe de votre trajet (${routeData.value.axe_radius} km)`,
                    errors: validationErrors.value
                  }, {
                    default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                      if (_push4) {
                        _push4(ssrRenderComponent(_component_Slider, {
                          max: 200,
                          min: 0,
                          modelValue: routeData.value.axe_radius,
                          "onUpdate:modelValue": ($event) => routeData.value.axe_radius = $event,
                          class: "mb-2",
                          step: "10",
                          pt: {
                            root: { class: "w-14rem" },
                            handle: {
                              style: "background-color: #DBA511; border:none"
                            },
                            range: { style: "background-color: #DBA511; " }
                          }
                        }, null, _parent4, _scopeId3));
                      } else {
                        return [
                          createVNode(_component_Slider, {
                            max: 200,
                            min: 0,
                            modelValue: routeData.value.axe_radius,
                            "onUpdate:modelValue": ($event) => routeData.value.axe_radius = $event,
                            class: "mb-2",
                            step: "10",
                            pt: {
                              root: { class: "w-14rem" },
                              handle: {
                                style: "background-color: #DBA511; border:none"
                              },
                              range: { style: "background-color: #DBA511; " }
                            }
                          }, null, 8, ["modelValue", "onUpdate:modelValue"])
                        ];
                      }
                    }),
                    _: 1
                  }, _parent3, _scopeId2));
                  _push3(`</div><div class="flex h-full w-full flex-col items-center justify-center max-lg:hidden"${_scopeId2}><div style="${ssrRenderStyle({ width: unref(axeWidth) + "px" })}" class="border-x-fire flex w-full flex-col items-center border-x-4 border-dotted"${_scopeId2}><div class="bg-secondary z-2 relative h-6 w-6 rounded-full"${_scopeId2}><div style="${ssrRenderStyle(`transform: scale(${unref(originScale)})`)}" class="bg-secondary z-1 absolute h-6 w-6 rounded-full opacity-30"${_scopeId2}></div></div><div class="border-neutral-lighter h-[30rem] border-l-4 border-dotted"${_scopeId2}></div><div class="bg-ternary z-2 relative h-6 w-6 rounded-full"${_scopeId2}><div style="${ssrRenderStyle(`transform: scale(${unref(destinationScale)})`)}" class="bg-ternary z-1 absolute h-6 w-6 rounded-full opacity-30"${_scopeId2}></div></div></div></div></div>`);
                } else {
                  return [
                    createVNode(_component_form_title, { number: "01" }, {
                      default: withCtx(() => [
                        createTextVNode("Votre trajet")
                      ]),
                      _: 1
                    }),
                    createVNode("div", { class: "grid-cols-2 lg:grid" }, [
                      createVNode("div", { class: "bg-background-1 l w-full rounded-2xl p-16" }, [
                        createVNode(_component_FormField, {
                          class: "mb-5 w-full",
                          name: "departure_date",
                          label: "Date de départ",
                          errors: validationErrors.value
                        }, {
                          default: withCtx(() => [
                            createVNode("div", { class: "p-input-icon-right" }, [
                              createVNode("i", { class: "pi pi-pencil" }),
                              createVNode(_component_Calendar, {
                                "date-format": "dd/mm/yy",
                                showIcon: "",
                                "min-date": unref(dayjs)().toDate(),
                                "max-date": unref(dayjs)().add(30, "day").toDate(),
                                modelValue: routeData.value.departure_date,
                                "onUpdate:modelValue": ($event) => routeData.value.departure_date = $event,
                                placeholder: "Date de départ",
                                class: `w-full ${validationErrors.value.departure_date ? "p-invalid" : ""}`,
                                disabled: loading.value
                              }, null, 8, ["min-date", "max-date", "modelValue", "onUpdate:modelValue", "class", "disabled"])
                            ])
                          ]),
                          _: 1
                        }, 8, ["errors"]),
                        createVNode("div", { class: "mb-5 flex-col flex-wrap gap-x-3 gap-y-2" }, [
                          createVNode("div", { class: "align-items-center mb-2 flex" }, [
                            createVNode(_component_RadioButton, {
                              modelValue: routeData.value.departure_time_of_day,
                              "onUpdate:modelValue": ($event) => routeData.value.departure_time_of_day = $event,
                              inputId: "morning",
                              name: "morning",
                              value: "morning",
                              class: `w-full ${validationErrors.value.departure_time_of_day ? "p-invalid" : ""}`
                            }, null, 8, ["modelValue", "onUpdate:modelValue", "class"]),
                            createVNode("label", {
                              for: "morning",
                              class: "text-primary ml-2 cursor-pointer font-normal"
                            }, "Matin (de 00h00 à 11h59)")
                          ]),
                          createVNode("div", { class: "align-items-center mb-2 flex" }, [
                            createVNode(_component_RadioButton, {
                              modelValue: routeData.value.departure_time_of_day,
                              "onUpdate:modelValue": ($event) => routeData.value.departure_time_of_day = $event,
                              inputId: "afternoon",
                              name: "afternoon",
                              value: "afternoon",
                              class: `w-full ${validationErrors.value.departure_time_of_day ? "p-invalid" : ""}`
                            }, null, 8, ["modelValue", "onUpdate:modelValue", "class"]),
                            createVNode("label", {
                              for: "afternoon",
                              class: "text-primary ml-2 cursor-pointer font-normal"
                            }, "Après-midi (de 12h00 à 23h59)")
                          ])
                        ]),
                        createVNode(_component_FormField, {
                          class: "mb-5 w-full",
                          "label-class": "text-secondary",
                          name: "origin",
                          label: "Ville de départ",
                          errors: validationErrors.value
                        }, {
                          default: withCtx(() => [
                            createVNode(CitySelectField, {
                              placeholder: "Entrez la ville de départ",
                              "return-object": "",
                              modelValue: routeData.value.origin,
                              "onUpdate:modelValue": ($event) => routeData.value.origin = $event,
                              disabled: loading.value,
                              class: `w-full ${validationErrors.value.origin ? "p-invalid" : ""}`
                            }, null, 8, ["modelValue", "onUpdate:modelValue", "disabled", "class"])
                          ]),
                          _: 1
                        }, 8, ["errors"]),
                        createVNode(_component_FormField, {
                          class: "mb-10 w-full",
                          "label-class": "text-secondary",
                          name: "origin_radius",
                          label: `Rayon d'intervention départ (${routeData.value.origin_radius} km)`,
                          errors: validationErrors.value
                        }, {
                          default: withCtx(() => [
                            createVNode(_component_Slider, {
                              max: 200,
                              min: 0,
                              disabled: loading.value,
                              modelValue: routeData.value.origin_radius,
                              "onUpdate:modelValue": ($event) => routeData.value.origin_radius = $event,
                              step: 10,
                              class: "mb-2",
                              pt: {
                                root: { class: "w-14rem" },
                                handle: {
                                  style: "background-color: #96B938; border:none"
                                },
                                range: { style: "background-color: #96B938; " }
                              }
                            }, null, 8, ["disabled", "modelValue", "onUpdate:modelValue"])
                          ]),
                          _: 1
                        }, 8, ["label", "errors"]),
                        createVNode(_component_FormField, {
                          class: "mb-5 w-full",
                          name: "destination",
                          label: "Ville d'arrivée",
                          "label-class": "text-ternary",
                          errors: validationErrors.value
                        }, {
                          default: withCtx(() => [
                            createVNode(CitySelectField, {
                              placeholder: "Entrez la ville d'arrivée",
                              modelValue: routeData.value.destination,
                              "onUpdate:modelValue": ($event) => routeData.value.destination = $event,
                              "return-object": "",
                              disabled: loading.value,
                              class: `w-full ${validationErrors.value.destination ? "p-invalid" : ""}`
                            }, null, 8, ["modelValue", "onUpdate:modelValue", "disabled", "class"])
                          ]),
                          _: 1
                        }, 8, ["errors"]),
                        createVNode(_component_FormField, {
                          class: "mb-10 w-full",
                          name: "destination_radius",
                          "label-class": "text-ternary",
                          label: `Rayon d'intervention d'arrivée (${routeData.value.destination_radius} km)`,
                          errors: validationErrors.value
                        }, {
                          default: withCtx(() => [
                            createVNode(_component_Slider, {
                              max: 200,
                              min: 0,
                              modelValue: routeData.value.destination_radius,
                              "onUpdate:modelValue": ($event) => routeData.value.destination_radius = $event,
                              step: 10,
                              class: "mb-2",
                              pt: {
                                root: { class: "w-14rem" },
                                handle: {
                                  style: "background-color: #00A2B3; border:none"
                                },
                                range: { style: "background-color: #00A2B3; " }
                              }
                            }, null, 8, ["modelValue", "onUpdate:modelValue"])
                          ]),
                          _: 1
                        }, 8, ["label", "errors"]),
                        createVNode(_component_FormField, {
                          class: "mb-5 w-full",
                          name: "axe_radius",
                          "label-class": "text-fire",
                          label: `Rayon sur l'axe de votre trajet (${routeData.value.axe_radius} km)`,
                          errors: validationErrors.value
                        }, {
                          default: withCtx(() => [
                            createVNode(_component_Slider, {
                              max: 200,
                              min: 0,
                              modelValue: routeData.value.axe_radius,
                              "onUpdate:modelValue": ($event) => routeData.value.axe_radius = $event,
                              class: "mb-2",
                              step: "10",
                              pt: {
                                root: { class: "w-14rem" },
                                handle: {
                                  style: "background-color: #DBA511; border:none"
                                },
                                range: { style: "background-color: #DBA511; " }
                              }
                            }, null, 8, ["modelValue", "onUpdate:modelValue"])
                          ]),
                          _: 1
                        }, 8, ["label", "errors"])
                      ]),
                      createVNode("div", { class: "flex h-full w-full flex-col items-center justify-center max-lg:hidden" }, [
                        createVNode("div", {
                          style: { width: unref(axeWidth) + "px" },
                          class: "border-x-fire flex w-full flex-col items-center border-x-4 border-dotted"
                        }, [
                          createVNode("div", { class: "bg-secondary z-2 relative h-6 w-6 rounded-full" }, [
                            createVNode("div", {
                              style: `transform: scale(${unref(originScale)})`,
                              class: "bg-secondary z-1 absolute h-6 w-6 rounded-full opacity-30"
                            }, null, 4)
                          ]),
                          createVNode("div", { class: "border-neutral-lighter h-[30rem] border-l-4 border-dotted" }),
                          createVNode("div", { class: "bg-ternary z-2 relative h-6 w-6 rounded-full" }, [
                            createVNode("div", {
                              style: `transform: scale(${unref(destinationScale)})`,
                              class: "bg-ternary z-1 absolute h-6 w-6 rounded-full opacity-30"
                            }, null, 4)
                          ])
                        ], 4)
                      ])
                    ])
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
          } else {
            return [
              createVNode(_component_section_container, {
                "mobile-padding": "",
                class: "max-w-container relative z-10 rounded-2xl bg-white px-24 py-16"
              }, {
                default: withCtx(() => [
                  createVNode(_component_form_title, { number: "01" }, {
                    default: withCtx(() => [
                      createTextVNode("Votre trajet")
                    ]),
                    _: 1
                  }),
                  createVNode("div", { class: "grid-cols-2 lg:grid" }, [
                    createVNode("div", { class: "bg-background-1 l w-full rounded-2xl p-16" }, [
                      createVNode(_component_FormField, {
                        class: "mb-5 w-full",
                        name: "departure_date",
                        label: "Date de départ",
                        errors: validationErrors.value
                      }, {
                        default: withCtx(() => [
                          createVNode("div", { class: "p-input-icon-right" }, [
                            createVNode("i", { class: "pi pi-pencil" }),
                            createVNode(_component_Calendar, {
                              "date-format": "dd/mm/yy",
                              showIcon: "",
                              "min-date": unref(dayjs)().toDate(),
                              "max-date": unref(dayjs)().add(30, "day").toDate(),
                              modelValue: routeData.value.departure_date,
                              "onUpdate:modelValue": ($event) => routeData.value.departure_date = $event,
                              placeholder: "Date de départ",
                              class: `w-full ${validationErrors.value.departure_date ? "p-invalid" : ""}`,
                              disabled: loading.value
                            }, null, 8, ["min-date", "max-date", "modelValue", "onUpdate:modelValue", "class", "disabled"])
                          ])
                        ]),
                        _: 1
                      }, 8, ["errors"]),
                      createVNode("div", { class: "mb-5 flex-col flex-wrap gap-x-3 gap-y-2" }, [
                        createVNode("div", { class: "align-items-center mb-2 flex" }, [
                          createVNode(_component_RadioButton, {
                            modelValue: routeData.value.departure_time_of_day,
                            "onUpdate:modelValue": ($event) => routeData.value.departure_time_of_day = $event,
                            inputId: "morning",
                            name: "morning",
                            value: "morning",
                            class: `w-full ${validationErrors.value.departure_time_of_day ? "p-invalid" : ""}`
                          }, null, 8, ["modelValue", "onUpdate:modelValue", "class"]),
                          createVNode("label", {
                            for: "morning",
                            class: "text-primary ml-2 cursor-pointer font-normal"
                          }, "Matin (de 00h00 à 11h59)")
                        ]),
                        createVNode("div", { class: "align-items-center mb-2 flex" }, [
                          createVNode(_component_RadioButton, {
                            modelValue: routeData.value.departure_time_of_day,
                            "onUpdate:modelValue": ($event) => routeData.value.departure_time_of_day = $event,
                            inputId: "afternoon",
                            name: "afternoon",
                            value: "afternoon",
                            class: `w-full ${validationErrors.value.departure_time_of_day ? "p-invalid" : ""}`
                          }, null, 8, ["modelValue", "onUpdate:modelValue", "class"]),
                          createVNode("label", {
                            for: "afternoon",
                            class: "text-primary ml-2 cursor-pointer font-normal"
                          }, "Après-midi (de 12h00 à 23h59)")
                        ])
                      ]),
                      createVNode(_component_FormField, {
                        class: "mb-5 w-full",
                        "label-class": "text-secondary",
                        name: "origin",
                        label: "Ville de départ",
                        errors: validationErrors.value
                      }, {
                        default: withCtx(() => [
                          createVNode(CitySelectField, {
                            placeholder: "Entrez la ville de départ",
                            "return-object": "",
                            modelValue: routeData.value.origin,
                            "onUpdate:modelValue": ($event) => routeData.value.origin = $event,
                            disabled: loading.value,
                            class: `w-full ${validationErrors.value.origin ? "p-invalid" : ""}`
                          }, null, 8, ["modelValue", "onUpdate:modelValue", "disabled", "class"])
                        ]),
                        _: 1
                      }, 8, ["errors"]),
                      createVNode(_component_FormField, {
                        class: "mb-10 w-full",
                        "label-class": "text-secondary",
                        name: "origin_radius",
                        label: `Rayon d'intervention départ (${routeData.value.origin_radius} km)`,
                        errors: validationErrors.value
                      }, {
                        default: withCtx(() => [
                          createVNode(_component_Slider, {
                            max: 200,
                            min: 0,
                            disabled: loading.value,
                            modelValue: routeData.value.origin_radius,
                            "onUpdate:modelValue": ($event) => routeData.value.origin_radius = $event,
                            step: 10,
                            class: "mb-2",
                            pt: {
                              root: { class: "w-14rem" },
                              handle: {
                                style: "background-color: #96B938; border:none"
                              },
                              range: { style: "background-color: #96B938; " }
                            }
                          }, null, 8, ["disabled", "modelValue", "onUpdate:modelValue"])
                        ]),
                        _: 1
                      }, 8, ["label", "errors"]),
                      createVNode(_component_FormField, {
                        class: "mb-5 w-full",
                        name: "destination",
                        label: "Ville d'arrivée",
                        "label-class": "text-ternary",
                        errors: validationErrors.value
                      }, {
                        default: withCtx(() => [
                          createVNode(CitySelectField, {
                            placeholder: "Entrez la ville d'arrivée",
                            modelValue: routeData.value.destination,
                            "onUpdate:modelValue": ($event) => routeData.value.destination = $event,
                            "return-object": "",
                            disabled: loading.value,
                            class: `w-full ${validationErrors.value.destination ? "p-invalid" : ""}`
                          }, null, 8, ["modelValue", "onUpdate:modelValue", "disabled", "class"])
                        ]),
                        _: 1
                      }, 8, ["errors"]),
                      createVNode(_component_FormField, {
                        class: "mb-10 w-full",
                        name: "destination_radius",
                        "label-class": "text-ternary",
                        label: `Rayon d'intervention d'arrivée (${routeData.value.destination_radius} km)`,
                        errors: validationErrors.value
                      }, {
                        default: withCtx(() => [
                          createVNode(_component_Slider, {
                            max: 200,
                            min: 0,
                            modelValue: routeData.value.destination_radius,
                            "onUpdate:modelValue": ($event) => routeData.value.destination_radius = $event,
                            step: 10,
                            class: "mb-2",
                            pt: {
                              root: { class: "w-14rem" },
                              handle: {
                                style: "background-color: #00A2B3; border:none"
                              },
                              range: { style: "background-color: #00A2B3; " }
                            }
                          }, null, 8, ["modelValue", "onUpdate:modelValue"])
                        ]),
                        _: 1
                      }, 8, ["label", "errors"]),
                      createVNode(_component_FormField, {
                        class: "mb-5 w-full",
                        name: "axe_radius",
                        "label-class": "text-fire",
                        label: `Rayon sur l'axe de votre trajet (${routeData.value.axe_radius} km)`,
                        errors: validationErrors.value
                      }, {
                        default: withCtx(() => [
                          createVNode(_component_Slider, {
                            max: 200,
                            min: 0,
                            modelValue: routeData.value.axe_radius,
                            "onUpdate:modelValue": ($event) => routeData.value.axe_radius = $event,
                            class: "mb-2",
                            step: "10",
                            pt: {
                              root: { class: "w-14rem" },
                              handle: {
                                style: "background-color: #DBA511; border:none"
                              },
                              range: { style: "background-color: #DBA511; " }
                            }
                          }, null, 8, ["modelValue", "onUpdate:modelValue"])
                        ]),
                        _: 1
                      }, 8, ["label", "errors"])
                    ]),
                    createVNode("div", { class: "flex h-full w-full flex-col items-center justify-center max-lg:hidden" }, [
                      createVNode("div", {
                        style: { width: unref(axeWidth) + "px" },
                        class: "border-x-fire flex w-full flex-col items-center border-x-4 border-dotted"
                      }, [
                        createVNode("div", { class: "bg-secondary z-2 relative h-6 w-6 rounded-full" }, [
                          createVNode("div", {
                            style: `transform: scale(${unref(originScale)})`,
                            class: "bg-secondary z-1 absolute h-6 w-6 rounded-full opacity-30"
                          }, null, 4)
                        ]),
                        createVNode("div", { class: "border-neutral-lighter h-[30rem] border-l-4 border-dotted" }),
                        createVNode("div", { class: "bg-ternary z-2 relative h-6 w-6 rounded-full" }, [
                          createVNode("div", {
                            style: `transform: scale(${unref(destinationScale)})`,
                            class: "bg-ternary z-1 absolute h-6 w-6 rounded-full opacity-30"
                          }, null, 4)
                        ])
                      ], 4)
                    ])
                  ])
                ]),
                _: 1
              })
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(ssrRenderComponent(_component_section_wrapper, {
        class: "bg-background-1 py-10",
        id: "conditions"
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(ssrRenderComponent(_component_section_container, {
              "mobile-padding": "",
              class: "max-w-container relative z-10 rounded-2xl bg-white px-24 py-16"
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(ssrRenderComponent(_component_form_title, {
                    class: "flex lg:block",
                    number: "02"
                  }, {
                    default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                      if (_push4) {
                        _push4(`Vos conditions `);
                      } else {
                        return [
                          createTextVNode("Vos conditions ")
                        ];
                      }
                    }),
                    _: 1
                  }, _parent3, _scopeId2));
                  _push3(`<div class="bg-background-1 rounded-2xl p-12"${_scopeId2}>`);
                  _push3(ssrRenderComponent(_component_FormField, {
                    class: "mb-5 w-full",
                    name: "vehicle_id",
                    label: "Véhicule utilisé pour le trajet",
                    errors: validationErrors.value
                  }, {
                    default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                      if (_push4) {
                        _push4(ssrRenderComponent(VehicleSelect, {
                          placeholder: "Choisir le véhicule",
                          modelValue: routeData.value.vehicle_id,
                          "onUpdate:modelValue": ($event) => routeData.value.vehicle_id = $event,
                          disabled: loading.value,
                          class: `w-full ${validationErrors.value.vehicle_id ? "p-invalid" : ""}`
                        }, null, _parent4, _scopeId3));
                      } else {
                        return [
                          createVNode(VehicleSelect, {
                            placeholder: "Choisir le véhicule",
                            modelValue: routeData.value.vehicle_id,
                            "onUpdate:modelValue": ($event) => routeData.value.vehicle_id = $event,
                            disabled: loading.value,
                            class: `w-full ${validationErrors.value.vehicle_id ? "p-invalid" : ""}`
                          }, null, 8, ["modelValue", "onUpdate:modelValue", "disabled", "class"])
                        ];
                      }
                    }),
                    _: 1
                  }, _parent3, _scopeId2));
                  _push3(ssrRenderComponent(_component_FormField, {
                    class: "mb-5 w-full",
                    name: "operator_id",
                    label: "Chauffeur en charge du trajet",
                    errors: validationErrors.value
                  }, {
                    default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                      if (_push4) {
                        _push4(ssrRenderComponent(_component_OperatorSelect, {
                          placeholder: "Choisir le chauffeur",
                          modelValue: routeData.value.operator_id,
                          "onUpdate:modelValue": ($event) => routeData.value.operator_id = $event,
                          disabled: loading.value,
                          class: `w-full ${validationErrors.value.operator_id ? "p-invalid" : ""}`
                        }, null, _parent4, _scopeId3));
                      } else {
                        return [
                          createVNode(_component_OperatorSelect, {
                            placeholder: "Choisir le chauffeur",
                            modelValue: routeData.value.operator_id,
                            "onUpdate:modelValue": ($event) => routeData.value.operator_id = $event,
                            disabled: loading.value,
                            class: `w-full ${validationErrors.value.operator_id ? "p-invalid" : ""}`
                          }, null, 8, ["modelValue", "onUpdate:modelValue", "disabled", "class"])
                        ];
                      }
                    }),
                    _: 1
                  }, _parent3, _scopeId2));
                  _push3(ssrRenderComponent(_component_FormField, {
                    class: "mb-2",
                    name: "pickup_fee",
                    label: "Tarif de prise en charge (TTC 10%)",
                    errors: validationErrors.value
                  }, {
                    default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                      if (_push4) {
                        _push4(ssrRenderComponent(_component_InputNumber, {
                          modelValue: routeData.value.pickup_fee,
                          "onUpdate:modelValue": ($event) => routeData.value.pickup_fee = $event,
                          placeholder: "Tarif de prise en charge (TTC 10%)",
                          class: `w-full ${validationErrors.value.pickup_fee ? "p-invalid" : ""}`,
                          locale: "fr-FR",
                          disabled: loading.value,
                          currency: "EUR",
                          mode: "currency",
                          max: 99999
                        }, null, _parent4, _scopeId3));
                      } else {
                        return [
                          createVNode(_component_InputNumber, {
                            modelValue: routeData.value.pickup_fee,
                            "onUpdate:modelValue": ($event) => routeData.value.pickup_fee = $event,
                            placeholder: "Tarif de prise en charge (TTC 10%)",
                            class: `w-full ${validationErrors.value.pickup_fee ? "p-invalid" : ""}`,
                            locale: "fr-FR",
                            disabled: loading.value,
                            currency: "EUR",
                            mode: "currency",
                            max: 99999
                          }, null, 8, ["modelValue", "onUpdate:modelValue", "class", "disabled"])
                        ];
                      }
                    }),
                    _: 1
                  }, _parent3, _scopeId2));
                  _push3(ssrRenderComponent(_component_FormField, {
                    class: "mb-2",
                    name: "km_price",
                    label: "Prix au kilomètre (TTC 10%)",
                    errors: validationErrors.value
                  }, {
                    default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                      if (_push4) {
                        _push4(ssrRenderComponent(_component_InputNumber, {
                          currency: "EUR",
                          locale: "fr-FR",
                          mode: "currency",
                          max: 99,
                          modelValue: routeData.value.km_price,
                          "onUpdate:modelValue": ($event) => routeData.value.km_price = $event,
                          placeholder: "Prix au kilomètre (TTC 10%)",
                          class: `w-full ${validationErrors.value.km_price ? "p-invalid" : ""}`,
                          disabled: loading.value
                        }, null, _parent4, _scopeId3));
                      } else {
                        return [
                          createVNode(_component_InputNumber, {
                            currency: "EUR",
                            locale: "fr-FR",
                            mode: "currency",
                            max: 99,
                            modelValue: routeData.value.km_price,
                            "onUpdate:modelValue": ($event) => routeData.value.km_price = $event,
                            placeholder: "Prix au kilomètre (TTC 10%)",
                            class: `w-full ${validationErrors.value.km_price ? "p-invalid" : ""}`,
                            disabled: loading.value
                          }, null, 8, ["modelValue", "onUpdate:modelValue", "class", "disabled"])
                        ];
                      }
                    }),
                    _: 1
                  }, _parent3, _scopeId2));
                  _push3(`</div>`);
                } else {
                  return [
                    createVNode(_component_form_title, {
                      class: "flex lg:block",
                      number: "02"
                    }, {
                      default: withCtx(() => [
                        createTextVNode("Vos conditions ")
                      ]),
                      _: 1
                    }),
                    createVNode("div", { class: "bg-background-1 rounded-2xl p-12" }, [
                      createVNode(_component_FormField, {
                        class: "mb-5 w-full",
                        name: "vehicle_id",
                        label: "Véhicule utilisé pour le trajet",
                        errors: validationErrors.value
                      }, {
                        default: withCtx(() => [
                          createVNode(VehicleSelect, {
                            placeholder: "Choisir le véhicule",
                            modelValue: routeData.value.vehicle_id,
                            "onUpdate:modelValue": ($event) => routeData.value.vehicle_id = $event,
                            disabled: loading.value,
                            class: `w-full ${validationErrors.value.vehicle_id ? "p-invalid" : ""}`
                          }, null, 8, ["modelValue", "onUpdate:modelValue", "disabled", "class"])
                        ]),
                        _: 1
                      }, 8, ["errors"]),
                      createVNode(_component_FormField, {
                        class: "mb-5 w-full",
                        name: "operator_id",
                        label: "Chauffeur en charge du trajet",
                        errors: validationErrors.value
                      }, {
                        default: withCtx(() => [
                          createVNode(_component_OperatorSelect, {
                            placeholder: "Choisir le chauffeur",
                            modelValue: routeData.value.operator_id,
                            "onUpdate:modelValue": ($event) => routeData.value.operator_id = $event,
                            disabled: loading.value,
                            class: `w-full ${validationErrors.value.operator_id ? "p-invalid" : ""}`
                          }, null, 8, ["modelValue", "onUpdate:modelValue", "disabled", "class"])
                        ]),
                        _: 1
                      }, 8, ["errors"]),
                      createVNode(_component_FormField, {
                        class: "mb-2",
                        name: "pickup_fee",
                        label: "Tarif de prise en charge (TTC 10%)",
                        errors: validationErrors.value
                      }, {
                        default: withCtx(() => [
                          createVNode(_component_InputNumber, {
                            modelValue: routeData.value.pickup_fee,
                            "onUpdate:modelValue": ($event) => routeData.value.pickup_fee = $event,
                            placeholder: "Tarif de prise en charge (TTC 10%)",
                            class: `w-full ${validationErrors.value.pickup_fee ? "p-invalid" : ""}`,
                            locale: "fr-FR",
                            disabled: loading.value,
                            currency: "EUR",
                            mode: "currency",
                            max: 99999
                          }, null, 8, ["modelValue", "onUpdate:modelValue", "class", "disabled"])
                        ]),
                        _: 1
                      }, 8, ["errors"]),
                      createVNode(_component_FormField, {
                        class: "mb-2",
                        name: "km_price",
                        label: "Prix au kilomètre (TTC 10%)",
                        errors: validationErrors.value
                      }, {
                        default: withCtx(() => [
                          createVNode(_component_InputNumber, {
                            currency: "EUR",
                            locale: "fr-FR",
                            mode: "currency",
                            max: 99,
                            modelValue: routeData.value.km_price,
                            "onUpdate:modelValue": ($event) => routeData.value.km_price = $event,
                            placeholder: "Prix au kilomètre (TTC 10%)",
                            class: `w-full ${validationErrors.value.km_price ? "p-invalid" : ""}`,
                            disabled: loading.value
                          }, null, 8, ["modelValue", "onUpdate:modelValue", "class", "disabled"])
                        ]),
                        _: 1
                      }, 8, ["errors"])
                    ])
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
          } else {
            return [
              createVNode(_component_section_container, {
                "mobile-padding": "",
                class: "max-w-container relative z-10 rounded-2xl bg-white px-24 py-16"
              }, {
                default: withCtx(() => [
                  createVNode(_component_form_title, {
                    class: "flex lg:block",
                    number: "02"
                  }, {
                    default: withCtx(() => [
                      createTextVNode("Vos conditions ")
                    ]),
                    _: 1
                  }),
                  createVNode("div", { class: "bg-background-1 rounded-2xl p-12" }, [
                    createVNode(_component_FormField, {
                      class: "mb-5 w-full",
                      name: "vehicle_id",
                      label: "Véhicule utilisé pour le trajet",
                      errors: validationErrors.value
                    }, {
                      default: withCtx(() => [
                        createVNode(VehicleSelect, {
                          placeholder: "Choisir le véhicule",
                          modelValue: routeData.value.vehicle_id,
                          "onUpdate:modelValue": ($event) => routeData.value.vehicle_id = $event,
                          disabled: loading.value,
                          class: `w-full ${validationErrors.value.vehicle_id ? "p-invalid" : ""}`
                        }, null, 8, ["modelValue", "onUpdate:modelValue", "disabled", "class"])
                      ]),
                      _: 1
                    }, 8, ["errors"]),
                    createVNode(_component_FormField, {
                      class: "mb-5 w-full",
                      name: "operator_id",
                      label: "Chauffeur en charge du trajet",
                      errors: validationErrors.value
                    }, {
                      default: withCtx(() => [
                        createVNode(_component_OperatorSelect, {
                          placeholder: "Choisir le chauffeur",
                          modelValue: routeData.value.operator_id,
                          "onUpdate:modelValue": ($event) => routeData.value.operator_id = $event,
                          disabled: loading.value,
                          class: `w-full ${validationErrors.value.operator_id ? "p-invalid" : ""}`
                        }, null, 8, ["modelValue", "onUpdate:modelValue", "disabled", "class"])
                      ]),
                      _: 1
                    }, 8, ["errors"]),
                    createVNode(_component_FormField, {
                      class: "mb-2",
                      name: "pickup_fee",
                      label: "Tarif de prise en charge (TTC 10%)",
                      errors: validationErrors.value
                    }, {
                      default: withCtx(() => [
                        createVNode(_component_InputNumber, {
                          modelValue: routeData.value.pickup_fee,
                          "onUpdate:modelValue": ($event) => routeData.value.pickup_fee = $event,
                          placeholder: "Tarif de prise en charge (TTC 10%)",
                          class: `w-full ${validationErrors.value.pickup_fee ? "p-invalid" : ""}`,
                          locale: "fr-FR",
                          disabled: loading.value,
                          currency: "EUR",
                          mode: "currency",
                          max: 99999
                        }, null, 8, ["modelValue", "onUpdate:modelValue", "class", "disabled"])
                      ]),
                      _: 1
                    }, 8, ["errors"]),
                    createVNode(_component_FormField, {
                      class: "mb-2",
                      name: "km_price",
                      label: "Prix au kilomètre (TTC 10%)",
                      errors: validationErrors.value
                    }, {
                      default: withCtx(() => [
                        createVNode(_component_InputNumber, {
                          currency: "EUR",
                          locale: "fr-FR",
                          mode: "currency",
                          max: 99,
                          modelValue: routeData.value.km_price,
                          "onUpdate:modelValue": ($event) => routeData.value.km_price = $event,
                          placeholder: "Prix au kilomètre (TTC 10%)",
                          class: `w-full ${validationErrors.value.km_price ? "p-invalid" : ""}`,
                          disabled: loading.value
                        }, null, 8, ["modelValue", "onUpdate:modelValue", "class", "disabled"])
                      ]),
                      _: 1
                    }, 8, ["errors"])
                  ])
                ]),
                _: 1
              })
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(ssrRenderComponent(_component_section_wrapper, {
        class: "bg-background-1 py-10",
        id: "publish"
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(ssrRenderComponent(_component_section_container, {
              "mobile-padding": "",
              class: "max-w-container relative z-10 rounded-2xl bg-white px-24 py-16"
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(ssrRenderComponent(_component_form_title, { number: "03" }, {
                    default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                      if (_push4) {
                        _push4(`Publier`);
                      } else {
                        return [
                          createTextVNode("Publier")
                        ];
                      }
                    }),
                    _: 1
                  }, _parent3, _scopeId2));
                  if (error.value) {
                    _push3(ssrRenderComponent(_component_Message, { severity: "error" }, {
                      default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                        if (_push4) {
                          _push4(`${ssrInterpolate(error.value)}`);
                        } else {
                          return [
                            createTextVNode(toDisplayString(error.value), 1)
                          ];
                        }
                      }),
                      _: 1
                    }, _parent3, _scopeId2));
                  } else {
                    _push3(`<!---->`);
                  }
                  if (success.value) {
                    _push3(ssrRenderComponent(_component_Message, {
                      sticky: false,
                      life: "3000",
                      severity: "success"
                    }, {
                      default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                        if (_push4) {
                          _push4(`${ssrInterpolate(success.value)}`);
                        } else {
                          return [
                            createTextVNode(toDisplayString(success.value), 1)
                          ];
                        }
                      }),
                      _: 1
                    }, _parent3, _scopeId2));
                  } else {
                    _push3(`<!---->`);
                  }
                  _push3(`<div class="flex items-center justify-between"${_scopeId2}><div class="my-10 flex items-center"${_scopeId2}>`);
                  _push3(ssrRenderComponent(unref(script$1), {
                    required: "",
                    name: "checked",
                    inputId: "check-accept",
                    binary: true,
                    class: "mr-2",
                    modelValue: accept.value,
                    "onUpdate:modelValue": ($event) => accept.value = $event
                  }, null, _parent3, _scopeId2));
                  _push3(`<label for="check-accept" class="text-primary cursor-pointer"${_scopeId2}>J&#39;ai lu et j&#39;accepte les `);
                  _push3(ssrRenderComponent(_component_NuxtLink, {
                    class: "text-secondary underline",
                    target: "_blank",
                    to: "/cgu"
                  }, {
                    default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                      if (_push4) {
                        _push4(`conditions générales de ventes`);
                      } else {
                        return [
                          createTextVNode("conditions générales de ventes")
                        ];
                      }
                    }),
                    _: 1
                  }, _parent3, _scopeId2));
                  _push3(`</label></div><div${_scopeId2}>`);
                  _push3(ssrRenderComponent(_component_rounded_button, {
                    design: "4",
                    size: "md",
                    type: "submit",
                    loading: loading.value,
                    disabled: unref(hasValidationErrors) || !accept.value
                  }, {
                    default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                      if (_push4) {
                        _push4(`${ssrInterpolate(loading.value ? "Publication en cours..." : "Publier mon trajet")}`);
                      } else {
                        return [
                          createTextVNode(toDisplayString(loading.value ? "Publication en cours..." : "Publier mon trajet"), 1)
                        ];
                      }
                    }),
                    _: 1
                  }, _parent3, _scopeId2));
                  _push3(`</div></div>`);
                  _push3(ssrRenderComponent(_component_publish_route_modal, {
                    opened: showConfirmationModal.value,
                    route: simulatedRoute.value,
                    loading: loading.value,
                    onClose: ($event) => showConfirmationModal.value = false,
                    onPublish: createRoute
                  }, null, _parent3, _scopeId2));
                } else {
                  return [
                    createVNode(_component_form_title, { number: "03" }, {
                      default: withCtx(() => [
                        createTextVNode("Publier")
                      ]),
                      _: 1
                    }),
                    error.value ? (openBlock(), createBlock(_component_Message, {
                      key: 0,
                      severity: "error"
                    }, {
                      default: withCtx(() => [
                        createTextVNode(toDisplayString(error.value), 1)
                      ]),
                      _: 1
                    })) : createCommentVNode("", true),
                    success.value ? (openBlock(), createBlock(_component_Message, {
                      key: 1,
                      sticky: false,
                      life: "3000",
                      severity: "success"
                    }, {
                      default: withCtx(() => [
                        createTextVNode(toDisplayString(success.value), 1)
                      ]),
                      _: 1
                    })) : createCommentVNode("", true),
                    createVNode("div", { class: "flex items-center justify-between" }, [
                      createVNode("div", { class: "my-10 flex items-center" }, [
                        createVNode(unref(script$1), {
                          required: "",
                          name: "checked",
                          inputId: "check-accept",
                          binary: true,
                          class: "mr-2",
                          modelValue: accept.value,
                          "onUpdate:modelValue": ($event) => accept.value = $event
                        }, null, 8, ["modelValue", "onUpdate:modelValue"]),
                        createVNode("label", {
                          for: "check-accept",
                          class: "text-primary cursor-pointer"
                        }, [
                          createTextVNode("J'ai lu et j'accepte les "),
                          createVNode(_component_NuxtLink, {
                            class: "text-secondary underline",
                            target: "_blank",
                            to: "/cgu"
                          }, {
                            default: withCtx(() => [
                              createTextVNode("conditions générales de ventes")
                            ]),
                            _: 1
                          })
                        ])
                      ]),
                      createVNode("div", null, [
                        createVNode(_component_rounded_button, {
                          design: "4",
                          size: "md",
                          type: "submit",
                          loading: loading.value,
                          disabled: unref(hasValidationErrors) || !accept.value
                        }, {
                          default: withCtx(() => [
                            createTextVNode(toDisplayString(loading.value ? "Publication en cours..." : "Publier mon trajet"), 1)
                          ]),
                          _: 1
                        }, 8, ["loading", "disabled"])
                      ])
                    ]),
                    createVNode(_component_publish_route_modal, {
                      opened: showConfirmationModal.value,
                      route: simulatedRoute.value,
                      loading: loading.value,
                      onClose: ($event) => showConfirmationModal.value = false,
                      onPublish: createRoute
                    }, null, 8, ["opened", "route", "loading", "onClose"])
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
          } else {
            return [
              createVNode(_component_section_container, {
                "mobile-padding": "",
                class: "max-w-container relative z-10 rounded-2xl bg-white px-24 py-16"
              }, {
                default: withCtx(() => [
                  createVNode(_component_form_title, { number: "03" }, {
                    default: withCtx(() => [
                      createTextVNode("Publier")
                    ]),
                    _: 1
                  }),
                  error.value ? (openBlock(), createBlock(_component_Message, {
                    key: 0,
                    severity: "error"
                  }, {
                    default: withCtx(() => [
                      createTextVNode(toDisplayString(error.value), 1)
                    ]),
                    _: 1
                  })) : createCommentVNode("", true),
                  success.value ? (openBlock(), createBlock(_component_Message, {
                    key: 1,
                    sticky: false,
                    life: "3000",
                    severity: "success"
                  }, {
                    default: withCtx(() => [
                      createTextVNode(toDisplayString(success.value), 1)
                    ]),
                    _: 1
                  })) : createCommentVNode("", true),
                  createVNode("div", { class: "flex items-center justify-between" }, [
                    createVNode("div", { class: "my-10 flex items-center" }, [
                      createVNode(unref(script$1), {
                        required: "",
                        name: "checked",
                        inputId: "check-accept",
                        binary: true,
                        class: "mr-2",
                        modelValue: accept.value,
                        "onUpdate:modelValue": ($event) => accept.value = $event
                      }, null, 8, ["modelValue", "onUpdate:modelValue"]),
                      createVNode("label", {
                        for: "check-accept",
                        class: "text-primary cursor-pointer"
                      }, [
                        createTextVNode("J'ai lu et j'accepte les "),
                        createVNode(_component_NuxtLink, {
                          class: "text-secondary underline",
                          target: "_blank",
                          to: "/cgu"
                        }, {
                          default: withCtx(() => [
                            createTextVNode("conditions générales de ventes")
                          ]),
                          _: 1
                        })
                      ])
                    ]),
                    createVNode("div", null, [
                      createVNode(_component_rounded_button, {
                        design: "4",
                        size: "md",
                        type: "submit",
                        loading: loading.value,
                        disabled: unref(hasValidationErrors) || !accept.value
                      }, {
                        default: withCtx(() => [
                          createTextVNode(toDisplayString(loading.value ? "Publication en cours..." : "Publier mon trajet"), 1)
                        ]),
                        _: 1
                      }, 8, ["loading", "disabled"])
                    ])
                  ]),
                  createVNode(_component_publish_route_modal, {
                    opened: showConfirmationModal.value,
                    route: simulatedRoute.value,
                    loading: loading.value,
                    onClose: ($event) => showConfirmationModal.value = false,
                    onPublish: createRoute
                  }, null, 8, ["opened", "route", "loading", "onClose"])
                ]),
                _: 1
              })
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</form><!--]-->`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("pages/publier-un-trajet.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
//# sourceMappingURL=publier-un-trajet-dd220349.js.map
