import { _ as __nuxt_component_0$3, a as __nuxt_component_1$2 } from "./SectionContainer-5a7aa7e3.js";
import { _ as __nuxt_component_4$2 } from "./FormTitle-afe32d73.js";
import { _ as __nuxt_component_3$3 } from "./Spinner-653832cb.js";
import { _ as __nuxt_component_0$1, a as __nuxt_component_3$2 } from "./Price-aaf3d10e.js";
import { _ as __nuxt_component_3$1 } from "./Icon-7157bd57.js";
import { useSSRContext, resolveComponent, mergeProps, withCtx, createTextVNode, toDisplayString, createVNode, openBlock, createBlock, createCommentVNode, ref, unref, computed, isRef, Fragment, renderList } from "vue";
import { ssrRenderAttrs, ssrRenderComponent, ssrInterpolate, ssrIncludeBooleanAttr, ssrLooseContain, ssrRenderList, ssrRenderAttr, ssrRenderClass } from "vue/server-renderer";
import { _ as __nuxt_component_0$2 } from "./SectionTitle-2692cd9d.js";
import { _ as __nuxt_component_8 } from "./RoundedButton-a0ea68b9.js";
import "hookable";
import "destr";
import "devalue";
import "klona";
import { d as useConfirm, b as script, a as useNuxtApp, e as script$1 } from "../server.mjs";
import { u as useAuthStore } from "./auth-6d0727c5.js";
import { s as script$2 } from "./checkbox.esm-59d1629e.js";
import "vue-router";
import { s as script$3 } from "./fileupload.esm-d9f386d4.js";
import "./dayjs-9d0b29d3.js";
import "./config-f619f9d4.js";
import "ofetch";
import "#internal/nitro";
import "unctx";
import "h3";
import "ufo";
import "@vue/devtools-api";
import "@unhead/ssr";
import "unhead";
import "@unhead/shared";
import "dayjs";
import "dayjs/locale/fr.js";
import "dayjs/plugin/relativeTime.js";
import "dayjs/plugin/utc.js";
import "dayjs/plugin/timezone.js";
import "@headlessui/vue";
import "vue-i18n";
import "vue3-popper";
import "defu";
const _sfc_main$a = {
  __name: "RouteCardFooterInfo",
  __ssrInlineRender: true,
  props: {
    route: {
      type: Object,
      required: true,
      default: () => ({})
    }
  },
  setup(__props) {
    return (_ctx, _push, _parent, _attrs) => {
      const _component_icon = __nuxt_component_3$1;
      _push(`<div${ssrRenderAttrs(_attrs)}><div class="mb-5 flex gap-5 border-b-2 border-dotted pb-5"><div class="mb-2 flex">`);
      _push(ssrRenderComponent(_component_icon, {
        icon: "lit",
        class: "text-primary-light mr-3 h-6 w-6"
      }, null, _parent));
      if (__props.route.vehicle.type === "before_coffin") {
        _push(`<span> Transport avant et après mise en bière</span>`);
      } else {
        _push(`<!---->`);
      }
      if (__props.route.vehicle.type === "after_coffin") {
        _push(`<span> Transport après mise en bière</span>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div><div class="mb-2 flex">`);
      _push(ssrRenderComponent(_component_icon, {
        icon: "dimensions",
        class: "text-primary-light mr-3 h-6 w-6"
      }, null, _parent));
      if (__props.route.vehicle.is_standard_size) {
        _push(`<span> Supporte des tailles standards uniquement (&lt; ou = à 195cm x 60cm)</span>`);
      } else {
        _push(`<span> Supporte des tailles hors normes (&gt; à 195cm x l60cm)</span>`);
      }
      _push(`</div></div><div class="text-neutral-lighter flex"><div><div class="mb-2 flex">`);
      _push(ssrRenderComponent(_component_icon, {
        icon: "voiture",
        class: "text-primary-light mr-3 h-6 w-6"
      }, null, _parent));
      _push(` Véhicule prévu : ${ssrInterpolate(__props.route.vehicle.name)} (${ssrInterpolate(__props.route.vehicle.license_plate)}) </div><div class="mb-2 flex">`);
      _push(ssrRenderComponent(_component_icon, {
        icon: "profil",
        class: "text-primary-light mr-3 h-6 w-6"
      }, null, _parent));
      _push(` Chauffeur prévu : ${ssrInterpolate(__props.route.operator.identifier)}</div><div class="mb-2 flex">`);
      _push(ssrRenderComponent(_component_icon, {
        icon: "oeil",
        class: "text-primary-light mr-3 h-6 w-6"
      }, null, _parent));
      _push(`<span class="text-primary mr-1 font-bold">${ssrInterpolate(__props.route.views)}</span> Apparition(s) dans les résultats de recherche </div></div></div></div>`);
    };
  }
};
const _sfc_setup$a = _sfc_main$a.setup;
_sfc_main$a.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/RouteCardFooterInfo.vue");
  return _sfc_setup$a ? _sfc_setup$a(props, ctx) : void 0;
};
const __nuxt_component_2 = _sfc_main$a;
const _sfc_main$9 = {
  __name: "IncomingReservationCard",
  __ssrInlineRender: true,
  props: {
    reservation: {
      type: Object,
      required: true
    },
    route: {
      type: Object,
      required: false
    }
  },
  emits: ["accept", "refuse"],
  setup(__props, { emit }) {
    const accept = (reservation) => {
      emit("accept", reservation);
    };
    const refuse = (reservation) => {
      emit("refuse", reservation);
    };
    return (_ctx, _push, _parent, _attrs) => {
      const _component_base_route_card = __nuxt_component_0$1;
      const _component_price = __nuxt_component_3$2;
      const _component_Button = resolveComponent("Button");
      const _component_Message = resolveComponent("Message");
      _push(ssrRenderComponent(_component_base_route_card, mergeProps({
        route: __props.reservation,
        class: "mb-5"
      }, _attrs), {
        "origin-name": withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(__props.reservation.origin_city.name)}`);
          } else {
            return [
              createTextVNode(toDisplayString(__props.reservation.origin_city.name), 1)
            ];
          }
        }),
        "destination-name": withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(__props.reservation.destination_city.name)}`);
          } else {
            return [
              createTextVNode(toDisplayString(__props.reservation.destination_city.name), 1)
            ];
          }
        }),
        main: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<div class="flex justify-between"${_scopeId}><div class="mr-12"${_scopeId}><div class="text-primary text-2xl font-medium"${_scopeId}>${ssrInterpolate(__props.reservation.distance)} km </div><div${_scopeId}>Distance</div></div><div${_scopeId}><div class="text-primary font-medium"${_scopeId}>`);
            _push2(ssrRenderComponent(_component_price, {
              pricing: __props.reservation.pricing
            }, null, _parent2, _scopeId));
            _push2(`</div></div></div>`);
          } else {
            return [
              createVNode("div", { class: "flex justify-between" }, [
                createVNode("div", { class: "mr-12" }, [
                  createVNode("div", { class: "text-primary text-2xl font-medium" }, toDisplayString(__props.reservation.distance) + " km ", 1),
                  createVNode("div", null, "Distance")
                ]),
                createVNode("div", null, [
                  createVNode("div", { class: "text-primary font-medium" }, [
                    createVNode(_component_price, {
                      pricing: __props.reservation.pricing
                    }, null, 8, ["pricing"])
                  ])
                ])
              ])
            ];
          }
        }),
        footer: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            if (__props.reservation.status == "pending") {
              _push2(`<div class="flex justify-center gap-3"${_scopeId}>`);
              _push2(ssrRenderComponent(_component_Button, {
                severity: "danger",
                type: "button",
                outlined: "",
                label: "Refuser la demande",
                icon: "pi pi-times",
                onClick: ($event) => refuse(__props.reservation)
              }, null, _parent2, _scopeId));
              _push2(ssrRenderComponent(_component_Button, {
                onClick: ($event) => accept(__props.reservation),
                severity: "success",
                type: "button",
                outlined: "",
                label: "Accepter la demande",
                icon: "pi pi-check"
              }, null, _parent2, _scopeId));
              _push2(`</div>`);
            } else {
              _push2(`<div${_scopeId}>`);
              if (__props.reservation.status === "refused") {
                _push2(ssrRenderComponent(_component_Message, {
                  severity: "error",
                  closable: false
                }, {
                  default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                    if (_push3) {
                      _push3(` Réservation refusée `);
                    } else {
                      return [
                        createTextVNode(" Réservation refusée ")
                      ];
                    }
                  }),
                  _: 1
                }, _parent2, _scopeId));
              } else if (__props.reservation.status === "accepted") {
                _push2(ssrRenderComponent(_component_Message, {
                  severity: "success",
                  closable: false
                }, {
                  default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                    if (_push3) {
                      _push3(` Réservation acceptée `);
                    } else {
                      return [
                        createTextVNode(" Réservation acceptée ")
                      ];
                    }
                  }),
                  _: 1
                }, _parent2, _scopeId));
              } else if (__props.reservation.status === "expired") {
                _push2(ssrRenderComponent(_component_Message, {
                  severity: "error",
                  closable: false
                }, {
                  default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                    if (_push3) {
                      _push3(` Réservation expirée `);
                    } else {
                      return [
                        createTextVNode(" Réservation expirée ")
                      ];
                    }
                  }),
                  _: 1
                }, _parent2, _scopeId));
              } else {
                _push2(`<!---->`);
              }
              _push2(`</div>`);
            }
          } else {
            return [
              __props.reservation.status == "pending" ? (openBlock(), createBlock("div", {
                key: 0,
                class: "flex justify-center gap-3"
              }, [
                createVNode(_component_Button, {
                  severity: "danger",
                  type: "button",
                  outlined: "",
                  label: "Refuser la demande",
                  icon: "pi pi-times",
                  onClick: ($event) => refuse(__props.reservation)
                }, null, 8, ["onClick"]),
                createVNode(_component_Button, {
                  onClick: ($event) => accept(__props.reservation),
                  severity: "success",
                  type: "button",
                  outlined: "",
                  label: "Accepter la demande",
                  icon: "pi pi-check"
                }, null, 8, ["onClick"])
              ])) : (openBlock(), createBlock("div", { key: 1 }, [
                __props.reservation.status === "refused" ? (openBlock(), createBlock(_component_Message, {
                  key: 0,
                  severity: "error",
                  closable: false
                }, {
                  default: withCtx(() => [
                    createTextVNode(" Réservation refusée ")
                  ]),
                  _: 1
                })) : __props.reservation.status === "accepted" ? (openBlock(), createBlock(_component_Message, {
                  key: 1,
                  severity: "success",
                  closable: false
                }, {
                  default: withCtx(() => [
                    createTextVNode(" Réservation acceptée ")
                  ]),
                  _: 1
                })) : __props.reservation.status === "expired" ? (openBlock(), createBlock(_component_Message, {
                  key: 2,
                  severity: "error",
                  closable: false
                }, {
                  default: withCtx(() => [
                    createTextVNode(" Réservation expirée ")
                  ]),
                  _: 1
                })) : createCommentVNode("", true)
              ]))
            ];
          }
        }),
        _: 1
      }, _parent));
    };
  }
};
const _sfc_setup$9 = _sfc_main$9.setup;
_sfc_main$9.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/IncomingReservationCard.vue");
  return _sfc_setup$9 ? _sfc_setup$9(props, ctx) : void 0;
};
const __nuxt_component_0 = _sfc_main$9;
const _sfc_main$8 = {
  __name: "ConfirmValidateRequestModal",
  __ssrInlineRender: true,
  props: {
    reservation: {
      type: Object,
      required: true
    },
    accepting: {
      type: Boolean,
      required: false,
      default: false
    }
  },
  emits: ["confirm", "close"],
  setup(__props, { emit }) {
    const checked = ref();
    return (_ctx, _push, _parent, _attrs) => {
      const _component_section_title = __nuxt_component_0$2;
      const _component_rounded_button = __nuxt_component_8;
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "flex h-full flex-col justify-between p-10" }, _attrs))}><div class="mb-5 flex items-center justify-end"><button class="bg-background-3 text-primary flex h-8 w-8 items-center justify-center rounded-full"><span class="font-bold">X</span></button></div><div class="mb-5 flex items-center justify-center">`);
      _push(ssrRenderComponent(_component_section_title, null, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`Confirmation de réservation`);
          } else {
            return [
              createTextVNode("Confirmation de réservation")
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div><div> En acceptant cette demande, vous vous engagez à réserver une place pour le demandeur sur votre trajet.<br> Cette action confirmera le trajet et engagera les deux parties. <br><br><span class="font-bold">Une fois la réservation approuvée :</span><br><br> - Le demandeur sera immédiatement informé de l&#39;acceptation de sa demande.<br> - Si plusieurs demandes de réservations sont lié à ce trajet, elles seront automatiquement archivé.<br> - Un SMS et un e-mail de confirmation lui seront envoyés avec les détails nécessaires pour le trajet.<br> - Les détails du trajet seront verrouillés et les préparatifs pour le départ pourront commencer.<br><br></div><div class="align-items-center mb-10 flex"><input type="checkbox"${ssrIncludeBooleanAttr(Array.isArray(checked.value) ? ssrLooseContain(checked.value, null) : checked.value) ? " checked" : ""} name="checked" id="checked"><label for="checked" class="ml-2">Je confirme la validation de cette réservation</label></div>`);
      _push(ssrRenderComponent(_component_rounded_button, {
        disabled: !checked.value || __props.accepting,
        class: "mx-auto",
        design: "3",
        type: "submit",
        loading: __props.accepting,
        size: "lg",
        onClick: ($event) => _ctx.$emit("confirm", __props.reservation)
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(__props.accepting ? "Confirmation en cours..." : "CONFIRMER")}`);
          } else {
            return [
              createTextVNode(toDisplayString(__props.accepting ? "Confirmation en cours..." : "CONFIRMER"), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div>`);
    };
  }
};
const _sfc_setup$8 = _sfc_main$8.setup;
_sfc_main$8.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/modals/ConfirmValidateRequestModal.vue");
  return _sfc_setup$8 ? _sfc_setup$8(props, ctx) : void 0;
};
const __nuxt_component_1$1 = _sfc_main$8;
const _sfc_main$7 = {
  __name: "IncomingReservationsList",
  __ssrInlineRender: true,
  props: {
    reservations: {
      type: Array,
      required: true
    }
  },
  emits: ["store", "close"],
  setup(__props, { emit }) {
    const confirm = useConfirm();
    const visible = ref(false);
    const accepting = ref(false);
    const { $api, $event, $toast } = useNuxtApp();
    const selectedReservation = ref(null);
    const openConfirmModal = (reservation) => {
      selectedReservation.value = reservation;
      visible.value = true;
    };
    const closeConfirmModal = () => {
      selectedReservation.value = null;
      visible.value = false;
    };
    const refuse = (reservation) => {
      confirm.require({
        group: "confirmation",
        message: "Êtes-vous sûr de vouloir refuser cette réservation ?",
        header: "Refuser une réservation",
        acceptClass: "p-button-danger p-button-text",
        acceptLabel: "Oui",
        acceptIcon: "pi pi-check",
        rejectClass: "p-button-text",
        rejectLabel: "Non",
        rejectIcon: "pi pi-times",
        accept: async () => {
          try {
            await $api.call(
              "post",
              $api.route("reservation.refuse", {
                reservation: reservation.id
              })
            );
            $event("reservation-refused");
          } catch (e) {
            if (e.response) {
              if (e.response.data.message) {
                $toast.error(e.response.data.message);
              } else {
                if (e.response.data.error) {
                  $toast.error(e.response.data.error);
                }
              }
            } else {
              $toast.error("Une erreur est survenue");
            }
          }
        }
      });
    };
    const acceptReservation = async (reservation) => {
      accepting.value = true;
      $api.call(
        "post",
        $api.route("reservation.accept", { reservation: reservation.id })
      ).then(() => {
        closeConfirmModal();
        $event("reservation-confirmed");
      }).catch((e) => {
        if (e.response) {
          if (e.response.data.message) {
            $toast.error(e.response.data.message);
            error.value = e.response.data.message;
          } else {
            if (e.response.data.error) {
              $toast.error(e.response.data.error);
              error.value = e.response.data.error;
            }
          }
        } else {
          $toast.error("Une erreur est survenue");
          error.value = "Une erreur est survenue";
        }
      }).finally(() => {
        accepting.value = false;
      });
    };
    return (_ctx, _push, _parent, _attrs) => {
      const _component_incoming_reservation_card = __nuxt_component_0;
      const _component_confirm_validate_request_modal = __nuxt_component_1$1;
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "flex h-full flex-col justify-between p-10" }, _attrs))}><div class="text-primary mb-5 whitespace-nowrap text-[1.5rem] font-bold"> Sur votre trajet: </div><!--[-->`);
      ssrRenderList(__props.reservations, (reservation) => {
        _push(ssrRenderComponent(_component_incoming_reservation_card, {
          key: reservation.id,
          reservation,
          onAccept: ($event2) => openConfirmModal(reservation),
          onRefuse: ($event2) => refuse(reservation)
        }, null, _parent));
      });
      _push(`<!--]-->`);
      _push(ssrRenderComponent(unref(script), {
        "dismissable-mask": "",
        visible: visible.value,
        "onUpdate:visible": ($event2) => visible.value = $event2,
        modal: "",
        class: "max-md:w-full",
        pt: {
          header: { style: " display:none" },
          content: { style: "padding: 0 !important;border-radius: 10px " },
          root: {
            style: "padding: 20px"
          }
        }
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(ssrRenderComponent(_component_confirm_validate_request_modal, {
              reservation: selectedReservation.value,
              onConfirm: acceptReservation,
              onClose: closeConfirmModal,
              accepting: accepting.value
            }, null, _parent2, _scopeId));
          } else {
            return [
              createVNode(_component_confirm_validate_request_modal, {
                reservation: selectedReservation.value,
                onConfirm: acceptReservation,
                onClose: closeConfirmModal,
                accepting: accepting.value
              }, null, 8, ["reservation", "accepting"])
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div>`);
    };
  }
};
const _sfc_setup$7 = _sfc_main$7.setup;
_sfc_main$7.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/IncomingReservationsList.vue");
  return _sfc_setup$7 ? _sfc_setup$7(props, ctx) : void 0;
};
const __nuxt_component_3 = _sfc_main$7;
const _sfc_main$6 = {
  __name: "PublishCard",
  __ssrInlineRender: true,
  props: {
    route: {
      type: Object,
      required: true,
      default: () => ({})
    }
  },
  setup(__props) {
    const props = __props;
    const { $api, $toast } = useNuxtApp();
    const checked = ref(false);
    const authStore = useAuthStore();
    const company = authStore.company;
    const toggleReservations = ref(false);
    computed(() => {
      if (company == null ? void 0 : company.pending_reservations) {
        return (company == null ? void 0 : company.pending_reservations.filter(
          (reservation) => reservation.route_id === props.route.id
        )) ?? [];
      }
      return [];
    });
    const toggleEnable = async () => {
      let routeData = {
        ...props.route,
        enabled: checked.value
      };
      await $api.call(
        "put",
        $api.route("me.routes.update", { route: props.route.id }),
        routeData
      ).then((data) => {
        $toast.success("Votre trajet a été mis à jour");
        success.value = "Votre trajet a été mis à jour";
        routes.value = data.data;
      }).catch((e) => {
        if (e.response) {
          if (e.response.data.message) {
            $toast.error(e.response.data.message);
            error.value = e.response.data.message;
          } else {
            if (e.response.data.error) {
              $toast.error(e.response.data.error);
              error.value = e.response.data.error;
            }
          }
        }
      }).finally(() => {
      });
    };
    return (_ctx, _push, _parent, _attrs) => {
      const _component_base_route_card = __nuxt_component_0$1;
      const _component_price = __nuxt_component_3$2;
      const _component_route_card_footer_info = __nuxt_component_2;
      const _component_Button = resolveComponent("Button");
      const _component_incoming_reservations_list = __nuxt_component_3;
      _push(ssrRenderComponent(_component_base_route_card, mergeProps({ route: __props.route }, _attrs), {
        actions: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<div class="flex justify-end"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(script$1), {
              modelValue: unref(checked),
              "onUpdate:modelValue": ($event) => isRef(checked) ? checked.value = $event : null,
              onChange: toggleEnable
            }, null, _parent2, _scopeId));
            _push2(`</div>`);
          } else {
            return [
              createVNode("div", { class: "flex justify-end" }, [
                createVNode(unref(script$1), {
                  modelValue: unref(checked),
                  "onUpdate:modelValue": ($event) => isRef(checked) ? checked.value = $event : null,
                  onChange: toggleEnable
                }, null, 8, ["modelValue", "onUpdate:modelValue"])
              ])
            ];
          }
        }),
        main: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<div class="flex justify-between"${_scopeId}><div class="mr-12"${_scopeId}><div class="text-primary text-2xl font-medium"${_scopeId}>${ssrInterpolate(__props.route.distance)} km </div><div${_scopeId}>Distance</div></div><div${_scopeId}>`);
            _push2(ssrRenderComponent(_component_price, {
              pricing: __props.route.pricing
            }, null, _parent2, _scopeId));
            _push2(`</div></div>`);
          } else {
            return [
              createVNode("div", { class: "flex justify-between" }, [
                createVNode("div", { class: "mr-12" }, [
                  createVNode("div", { class: "text-primary text-2xl font-medium" }, toDisplayString(__props.route.distance) + " km ", 1),
                  createVNode("div", null, "Distance")
                ]),
                createVNode("div", null, [
                  createVNode(_component_price, {
                    pricing: __props.route.pricing
                  }, null, 8, ["pricing"])
                ])
              ])
            ];
          }
        }),
        footer: withCtx((_, _push2, _parent2, _scopeId) => {
          var _a, _b;
          if (_push2) {
            _push2(ssrRenderComponent(_component_route_card_footer_info, { route: __props.route }, null, _parent2, _scopeId));
            if (((_a = __props.route.reservations) == null ? void 0 : _a.length) > 0) {
              _push2(`<div${_scopeId}><div class="align-item-center mt-5 flex justify-center"${_scopeId}>`);
              _push2(ssrRenderComponent(_component_Button, {
                onClick: ($event) => toggleReservations.value = !unref(toggleReservations),
                class: "flex",
                type: "button",
                label: "Demande(s) de réservation(s)",
                badge: __props.route.reservations.length,
                badgeClass: "p-badge-danger",
                outlined: ""
              }, null, _parent2, _scopeId));
              _push2(`</div>`);
              if (unref(toggleReservations)) {
                _push2(ssrRenderComponent(_component_incoming_reservations_list, {
                  reservations: __props.route.reservations
                }, null, _parent2, _scopeId));
              } else {
                _push2(`<!---->`);
              }
              _push2(`</div>`);
            } else {
              _push2(`<!---->`);
            }
          } else {
            return [
              createVNode(_component_route_card_footer_info, { route: __props.route }, null, 8, ["route"]),
              ((_b = __props.route.reservations) == null ? void 0 : _b.length) > 0 ? (openBlock(), createBlock("div", { key: 0 }, [
                createVNode("div", { class: "align-item-center mt-5 flex justify-center" }, [
                  createVNode(_component_Button, {
                    onClick: ($event) => toggleReservations.value = !unref(toggleReservations),
                    class: "flex",
                    type: "button",
                    label: "Demande(s) de réservation(s)",
                    badge: __props.route.reservations.length,
                    badgeClass: "p-badge-danger",
                    outlined: ""
                  }, null, 8, ["onClick", "badge"])
                ]),
                unref(toggleReservations) ? (openBlock(), createBlock(_component_incoming_reservations_list, {
                  key: 0,
                  reservations: __props.route.reservations
                }, null, 8, ["reservations"])) : createCommentVNode("", true)
              ])) : createCommentVNode("", true)
            ];
          }
        }),
        _: 1
      }, _parent));
    };
  }
};
const _sfc_setup$6 = _sfc_main$6.setup;
_sfc_main$6.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/cards/routes/PublishCard.vue");
  return _sfc_setup$6 ? _sfc_setup$6(props, ctx) : void 0;
};
const __nuxt_component_4$1 = _sfc_main$6;
const _sfc_main$5 = {
  __name: "RouteCardRequesterFooterInfo",
  __ssrInlineRender: true,
  props: {
    requester: {
      type: Object,
      required: true,
      default: () => ({})
    },
    reference: {
      type: String,
      required: false,
      default: ""
    }
  },
  setup(__props) {
    return (_ctx, _push, _parent, _attrs) => {
      const _component_icon = __nuxt_component_3$1;
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "text-neutral-lighter grid grid-cols-12" }, _attrs))}><div class="col-span-12 md:col-span-6"><div class="mb-2.5 flex">`);
      _push(ssrRenderComponent(_component_icon, {
        icon: "tel",
        class: "text-primary-light mr-3 h-6 w-6"
      }, null, _parent));
      _push(`<span><b>Téléphone:</b> ${ssrInterpolate(__props.requester.phone)}</span></div></div><div class="col-span-12 md:col-span-6"><div class="mb-2.5 flex">`);
      _push(ssrRenderComponent(_component_icon, {
        icon: "tel",
        class: "text-primary-light mr-3 h-6 w-6"
      }, null, _parent));
      _push(`<span><b>Téléphone:</b> ${ssrInterpolate(__props.requester.phone)}</span></div></div><div class="col-span-12 md:col-span-6"><div class="mb-2.5 flex">`);
      _push(ssrRenderComponent(_component_icon, {
        icon: "info",
        class: "text-primary-light mr-3 h-6 w-6"
      }, null, _parent));
      _push(`<span><b>Référence: </b> ${ssrInterpolate(__props.reference)}</span></div></div><div class="col-span-12 md:col-span-6"><div class="mb-2.5 flex">`);
      _push(ssrRenderComponent(_component_icon, {
        icon: "info",
        class: "text-primary-light mr-3 h-6 w-6"
      }, null, _parent));
      _push(`<span><b>Société:</b> ${ssrInterpolate(__props.requester.name)}</span></div></div><div class="col-span-12 md:col-span-6"><div class="mb-2.5 flex">`);
      _push(ssrRenderComponent(_component_icon, {
        icon: "telephone",
        class: "text-primary-light mr-3 h-6 w-6"
      }, null, _parent));
      _push(`<span><b>Mobile:</b> ${ssrInterpolate(__props.requester.mobile)}</span></div></div><div class="col-span-12 md:col-span-6"><div class="mb-2.5 flex"><div>`);
      _push(ssrRenderComponent(_component_icon, {
        icon: "info",
        class: "text-primary-light mr-3 h-6 w-6"
      }, null, _parent));
      _push(`</div><div><span><b>Adresse société: </b> ${ssrInterpolate(__props.requester.address)} ${ssrInterpolate(__props.requester.city.zip_code)} ${ssrInterpolate(__props.requester.city.name)}</span></div></div></div></div>`);
    };
  }
};
const _sfc_setup$5 = _sfc_main$5.setup;
_sfc_main$5.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/RouteCardRequesterFooterInfo.vue");
  return _sfc_setup$5 ? _sfc_setup$5(props, ctx) : void 0;
};
const __nuxt_component_4 = _sfc_main$5;
const _sfc_main$4 = {
  __name: "ConfirmCompletedRouteDriverModal",
  __ssrInlineRender: true,
  props: {
    opened: {
      type: Boolean,
      default: false
    },
    reservation: {
      type: Object,
      required: true
    }
  },
  emits: ["confirm", "close"],
  setup(__props, { emit }) {
    const props = __props;
    const { $api, $event, $toast } = useNuxtApp();
    const checked = ref();
    const loading = ref(false);
    const error2 = ref(null);
    const markReservationAsCompleted = async () => {
      loading.value = true;
      try {
        await $api.call(
          "post",
          $api.route("reservation.completed", {
            reservation: props.reservation.id
          })
        );
        $toast.success("Le trajet a bien été marqué comme terminé");
        $event("reservation-completed");
        emit("close");
      } catch (e) {
        $toast.error("Une erreur est survenue");
        error2.value = e.response.data.message;
      } finally {
        loading.value = false;
      }
    };
    return (_ctx, _push, _parent, _attrs) => {
      const _component_section_title = __nuxt_component_0$2;
      const _component_Message = resolveComponent("Message");
      const _component_rounded_button = __nuxt_component_8;
      _push(ssrRenderComponent(unref(script), mergeProps({
        "dismissable-mask": "",
        visible: __props.opened,
        modal: "",
        class: "max-md:w-full",
        pt: {
          header: { style: " display:none" },
          content: { style: "padding: 0 !important;border-radius: 10px " },
          root: {
            style: "padding: 20px"
          }
        }
      }, _attrs), {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<div class="flex h-full flex-col justify-between p-10"${_scopeId}><div class="flex justify-end"${_scopeId}><button class="bg-background-3 text-primary flex h-8 w-8 items-center justify-center rounded-full"${_scopeId}><span class="font-bold"${_scopeId}>X</span></button></div><div class="mb-5 flex justify-center"${_scopeId}>`);
            _push2(ssrRenderComponent(_component_section_title, { class: "justify-center" }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`Terminer le trajet`);
                } else {
                  return [
                    createTextVNode("Terminer le trajet")
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
            _push2(`</div>`);
            if (error2.value) {
              _push2(ssrRenderComponent(_component_Message, { severity: "error" }, {
                default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    _push3(`${ssrInterpolate(error2.value)}`);
                  } else {
                    return [
                      createTextVNode(toDisplayString(error2.value), 1)
                    ];
                  }
                }),
                _: 1
              }, _parent2, _scopeId));
            } else {
              _push2(`<!---->`);
            }
            _push2(`<div${_scopeId}> En confirmant, vous attestez de la conformité du transport et autorisez<br${_scopeId}> le déclenchement du processus de paiement.<br${_scopeId}><br${_scopeId}> Cette action est irréversible.<br${_scopeId}><br${_scopeId}> Vous serez ensuite invité à mettre en ligne votre facture. </div><div class="align-items-center my-10 flex"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(script$2), {
              modelValue: checked.value,
              "onUpdate:modelValue": ($event2) => checked.value = $event2,
              name: "checked",
              inputId: "check-complete",
              binary: true,
              class: "mr-2"
            }, null, _parent2, _scopeId));
            _push2(`<label for="check-complete"${_scopeId}> J&#39;atteste que le trajet s&#39;est déroulé conformément.</label></div>`);
            _push2(ssrRenderComponent(_component_rounded_button, {
              onClick: markReservationAsCompleted,
              loading: loading.value,
              class: "max-md:px-24",
              design: "4",
              icon: "check",
              disabled: !checked.value
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(` Terminer ce trajet `);
                } else {
                  return [
                    createTextVNode(" Terminer ce trajet ")
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
            _push2(`</div>`);
          } else {
            return [
              createVNode("div", { class: "flex h-full flex-col justify-between p-10" }, [
                createVNode("div", { class: "flex justify-end" }, [
                  createVNode("button", {
                    class: "bg-background-3 text-primary flex h-8 w-8 items-center justify-center rounded-full",
                    onClick: ($event2) => _ctx.$emit("close")
                  }, [
                    createVNode("span", { class: "font-bold" }, "X")
                  ], 8, ["onClick"])
                ]),
                createVNode("div", { class: "mb-5 flex justify-center" }, [
                  createVNode(_component_section_title, { class: "justify-center" }, {
                    default: withCtx(() => [
                      createTextVNode("Terminer le trajet")
                    ]),
                    _: 1
                  })
                ]),
                error2.value ? (openBlock(), createBlock(_component_Message, {
                  key: 0,
                  severity: "error"
                }, {
                  default: withCtx(() => [
                    createTextVNode(toDisplayString(error2.value), 1)
                  ]),
                  _: 1
                })) : createCommentVNode("", true),
                createVNode("div", null, [
                  createTextVNode(" En confirmant, vous attestez de la conformité du transport et autorisez"),
                  createVNode("br"),
                  createTextVNode(" le déclenchement du processus de paiement."),
                  createVNode("br"),
                  createVNode("br"),
                  createTextVNode(" Cette action est irréversible."),
                  createVNode("br"),
                  createVNode("br"),
                  createTextVNode(" Vous serez ensuite invité à mettre en ligne votre facture. ")
                ]),
                createVNode("div", { class: "align-items-center my-10 flex" }, [
                  createVNode(unref(script$2), {
                    modelValue: checked.value,
                    "onUpdate:modelValue": ($event2) => checked.value = $event2,
                    name: "checked",
                    inputId: "check-complete",
                    binary: true,
                    class: "mr-2"
                  }, null, 8, ["modelValue", "onUpdate:modelValue"]),
                  createVNode("label", { for: "check-complete" }, " J'atteste que le trajet s'est déroulé conformément.")
                ]),
                createVNode(_component_rounded_button, {
                  onClick: markReservationAsCompleted,
                  loading: loading.value,
                  class: "max-md:px-24",
                  design: "4",
                  icon: "check",
                  disabled: !checked.value
                }, {
                  default: withCtx(() => [
                    createTextVNode(" Terminer ce trajet ")
                  ]),
                  _: 1
                }, 8, ["loading", "disabled"])
              ])
            ];
          }
        }),
        _: 1
      }, _parent));
    };
  }
};
const _sfc_setup$4 = _sfc_main$4.setup;
_sfc_main$4.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/modals/ConfirmCompletedRouteDriverModal.vue");
  return _sfc_setup$4 ? _sfc_setup$4(props, ctx) : void 0;
};
const __nuxt_component_5$1 = _sfc_main$4;
const _sfc_main$3 = {
  __name: "PublishProgressCard",
  __ssrInlineRender: true,
  props: {
    route: {
      type: Object,
      required: true,
      default: () => ({})
    }
  },
  setup(__props) {
    const { route } = __props;
    const { $api, $event, $toast } = useNuxtApp();
    const modalIsOpen = ref(false);
    const loading = ref(false);
    const confirmOnBoard = async () => {
      loading.value = true;
      try {
        await $api.call(
          "post",
          $api.route("reservation.onboard", {
            reservation: route.reservation.id
          })
        );
        $toast.success("Le statut de la réservation a bien été mis à jour");
        $event("reservation-onboard");
      } catch (e) {
        $toast.error("Une erreur est survenue");
        console.error(e);
      } finally {
        loading.value = false;
      }
    };
    return (_ctx, _push, _parent, _attrs) => {
      const _component_base_route_card = __nuxt_component_0$1;
      const _component_route_card_footer_info = __nuxt_component_2;
      const _component_price = __nuxt_component_3$2;
      const _component_route_card_requester_footer_info = __nuxt_component_4;
      const _component_Button = resolveComponent("Button");
      const _component_rounded_button = __nuxt_component_8;
      const _component_confirm_completed_route_driver_modal = __nuxt_component_5$1;
      const _component_message = resolveComponent("message");
      _push(ssrRenderComponent(_component_base_route_card, mergeProps({ route: __props.route }, _attrs), {
        footer: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(ssrRenderComponent(_component_route_card_footer_info, {
              class: "mb-10",
              route: __props.route
            }, null, _parent2, _scopeId));
            if (__props.route.reservation) {
              _push2(ssrRenderComponent(_component_base_route_card, {
                route: __props.route.reservation
              }, {
                main: withCtx((_2, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    _push3(ssrRenderComponent(_component_price, {
                      pricing: __props.route.reservation.pricing
                    }, null, _parent3, _scopeId2));
                  } else {
                    return [
                      createVNode(_component_price, {
                        pricing: __props.route.reservation.pricing
                      }, null, 8, ["pricing"])
                    ];
                  }
                }),
                footer: withCtx((_2, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    _push3(ssrRenderComponent(_component_route_card_requester_footer_info, {
                      requester: __props.route.reservation.requester,
                      reference: __props.route.reservation.reference
                    }, null, _parent3, _scopeId2));
                    _push3(`<div class="flex w-full items-center justify-center p-5"${_scopeId2}>`);
                    if (!__props.route.reservation.on_board) {
                      _push3(ssrRenderComponent(_component_Button, {
                        onClick: confirmOnBoard,
                        severity: "success",
                        icon: "pi pi-check",
                        label: "Je confirme que le défunt est à bord du véhicule",
                        outlined: "",
                        loading: loading.value
                      }, null, _parent3, _scopeId2));
                    } else if (!__props.route.reservation.driver_end_confirmed) {
                      _push3(ssrRenderComponent(_component_Button, {
                        onClick: ($event2) => modalIsOpen.value = true,
                        severity: "success",
                        icon: "pi pi-check",
                        label: "J'ai terminé ce trajet",
                        outlined: ""
                      }, null, _parent3, _scopeId2));
                    } else if (!__props.route.reservation.requester_end_confirmed) {
                      _push3(`<div${_scopeId2}>`);
                      _push3(ssrRenderComponent(_component_rounded_button, {
                        class: "max-md:px-24",
                        design: "4",
                        disabled: ""
                      }, {
                        default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                          if (_push4) {
                            _push4(` En attente de confirmation du demandeur `);
                          } else {
                            return [
                              createTextVNode(" En attente de confirmation du demandeur ")
                            ];
                          }
                        }),
                        _: 1
                      }, _parent3, _scopeId2));
                      _push3(`</div>`);
                    } else {
                      _push3(`<!---->`);
                    }
                    _push3(`</div>`);
                    _push3(ssrRenderComponent(_component_confirm_completed_route_driver_modal, {
                      opened: modalIsOpen.value,
                      reservation: __props.route.reservation,
                      onClose: ($event2) => modalIsOpen.value = false
                    }, null, _parent3, _scopeId2));
                  } else {
                    return [
                      createVNode(_component_route_card_requester_footer_info, {
                        requester: __props.route.reservation.requester,
                        reference: __props.route.reservation.reference
                      }, null, 8, ["requester", "reference"]),
                      createVNode("div", { class: "flex w-full items-center justify-center p-5" }, [
                        !__props.route.reservation.on_board ? (openBlock(), createBlock(_component_Button, {
                          key: 0,
                          onClick: confirmOnBoard,
                          severity: "success",
                          icon: "pi pi-check",
                          label: "Je confirme que le défunt est à bord du véhicule",
                          outlined: "",
                          loading: loading.value
                        }, null, 8, ["loading"])) : !__props.route.reservation.driver_end_confirmed ? (openBlock(), createBlock(_component_Button, {
                          key: 1,
                          onClick: ($event2) => modalIsOpen.value = true,
                          severity: "success",
                          icon: "pi pi-check",
                          label: "J'ai terminé ce trajet",
                          outlined: ""
                        }, null, 8, ["onClick"])) : !__props.route.reservation.requester_end_confirmed ? (openBlock(), createBlock("div", { key: 2 }, [
                          createVNode(_component_rounded_button, {
                            class: "max-md:px-24",
                            design: "4",
                            disabled: ""
                          }, {
                            default: withCtx(() => [
                              createTextVNode(" En attente de confirmation du demandeur ")
                            ]),
                            _: 1
                          })
                        ])) : createCommentVNode("", true)
                      ]),
                      createVNode(_component_confirm_completed_route_driver_modal, {
                        opened: modalIsOpen.value,
                        reservation: __props.route.reservation,
                        onClose: ($event2) => modalIsOpen.value = false
                      }, null, 8, ["opened", "reservation", "onClose"])
                    ];
                  }
                }),
                _: 1
              }, _parent2, _scopeId));
            } else {
              _push2(ssrRenderComponent(_component_message, {
                severity: "error",
                closable: ""
              }, {
                default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    _push3(` La réservation de ce trajet est introuvable. Elle a peut-être été supprimée par un administrateur. `);
                  } else {
                    return [
                      createTextVNode(" La réservation de ce trajet est introuvable. Elle a peut-être été supprimée par un administrateur. ")
                    ];
                  }
                }),
                _: 1
              }, _parent2, _scopeId));
            }
          } else {
            return [
              createVNode(_component_route_card_footer_info, {
                class: "mb-10",
                route: __props.route
              }, null, 8, ["route"]),
              __props.route.reservation ? (openBlock(), createBlock(_component_base_route_card, {
                key: 0,
                route: __props.route.reservation
              }, {
                main: withCtx(() => [
                  createVNode(_component_price, {
                    pricing: __props.route.reservation.pricing
                  }, null, 8, ["pricing"])
                ]),
                footer: withCtx(() => [
                  createVNode(_component_route_card_requester_footer_info, {
                    requester: __props.route.reservation.requester,
                    reference: __props.route.reservation.reference
                  }, null, 8, ["requester", "reference"]),
                  createVNode("div", { class: "flex w-full items-center justify-center p-5" }, [
                    !__props.route.reservation.on_board ? (openBlock(), createBlock(_component_Button, {
                      key: 0,
                      onClick: confirmOnBoard,
                      severity: "success",
                      icon: "pi pi-check",
                      label: "Je confirme que le défunt est à bord du véhicule",
                      outlined: "",
                      loading: loading.value
                    }, null, 8, ["loading"])) : !__props.route.reservation.driver_end_confirmed ? (openBlock(), createBlock(_component_Button, {
                      key: 1,
                      onClick: ($event2) => modalIsOpen.value = true,
                      severity: "success",
                      icon: "pi pi-check",
                      label: "J'ai terminé ce trajet",
                      outlined: ""
                    }, null, 8, ["onClick"])) : !__props.route.reservation.requester_end_confirmed ? (openBlock(), createBlock("div", { key: 2 }, [
                      createVNode(_component_rounded_button, {
                        class: "max-md:px-24",
                        design: "4",
                        disabled: ""
                      }, {
                        default: withCtx(() => [
                          createTextVNode(" En attente de confirmation du demandeur ")
                        ]),
                        _: 1
                      })
                    ])) : createCommentVNode("", true)
                  ]),
                  createVNode(_component_confirm_completed_route_driver_modal, {
                    opened: modalIsOpen.value,
                    reservation: __props.route.reservation,
                    onClose: ($event2) => modalIsOpen.value = false
                  }, null, 8, ["opened", "reservation", "onClose"])
                ]),
                _: 1
              }, 8, ["route"])) : (openBlock(), createBlock(_component_message, {
                key: 1,
                severity: "error",
                closable: ""
              }, {
                default: withCtx(() => [
                  createTextVNode(" La réservation de ce trajet est introuvable. Elle a peut-être été supprimée par un administrateur. ")
                ]),
                _: 1
              }))
            ];
          }
        }),
        _: 1
      }, _parent));
    };
  }
};
const _sfc_setup$3 = _sfc_main$3.setup;
_sfc_main$3.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/cards/routes/PublishProgressCard.vue");
  return _sfc_setup$3 ? _sfc_setup$3(props, ctx) : void 0;
};
const __nuxt_component_5 = _sfc_main$3;
const _sfc_main$2 = {
  __name: "PublishCompleteMain",
  __ssrInlineRender: true,
  props: {
    route: {
      type: Object,
      required: true,
      default: () => ({})
    },
    showReservation: {
      type: Boolean,
      default: false
    }
  },
  setup(__props) {
    const props = __props;
    const { $api, $toast, $event } = useNuxtApp();
    const invoice = ref(null);
    const uploading = ref(false);
    ref(null);
    const submit = (event) => {
      const file = invoice.value;
      const formData = new FormData();
      formData.append("invoice", file);
      uploading.value = true;
      return $api.call(
        "post",
        $api.route("invoice.upload", { route: props.route.id }),
        formData
      ).then((data) => {
        invoice.value = null;
        $toast.success("Facture envoyé avec succès");
        $event("invoice-uploaded");
      }).catch((e) => {
        if (e.response) {
          if (e.response.data.message) {
            $toast.error(e.response.data.message);
          }
          if (e.response.status == 422) {
            if (e.response.data.errors) {
              $toast.error("Le format de fichier est invalide");
              validationErrors.value = e.response.data.errors;
            }
          } else {
            if (e.response.data.error) {
              $toast.error(e.response.data.error);
            }
          }
        } else {
          $toast.error("Une erreur est survenue ");
        }
      }).finally(() => {
        uploading.value = false;
      });
    };
    return (_ctx, _push, _parent, _attrs) => {
      const _component_rounded_button = __nuxt_component_8;
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "flex flex-col" }, _attrs))}><div class="mb-1">`);
      if (invoice.value) {
        _push(`<div class="bg-ternary-lightest text-primary flex items-center justify-between gap-3 rounded p-3"><span class="font-normal">${ssrInterpolate(invoice.value.name)}</span><span class="cursor-pointer font-normal">Supprimer</span></div>`);
      } else {
        _push(`<!---->`);
      }
      if (__props.route.reservation && !invoice.value) {
        _push(ssrRenderComponent(unref(script$3), {
          onUploader: (e) => {
            invoice.value = e.files[0];
          },
          accept: "application/pdf",
          name: "invoice",
          auto: "",
          mode: "basic",
          modelValue: invoice.value,
          "onUpdate:modelValue": ($event2) => invoice.value = $event2,
          class: "w-full",
          "choose-label": __props.route.reservation.invoice ? "Modifier la facture" : "Ajouter une facture",
          customUpload: true,
          pt: {
            chooseButton: { style: "background-color: #96B938 " }
          },
          disabled: uploading.value
        }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      if (invoice.value) {
        _push(ssrRenderComponent(_component_rounded_button, {
          loading: uploading.value,
          onClick: submit,
          design: "3",
          class: "mt-1 w-full rounded-none"
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(` Mettre à jour `);
            } else {
              return [
                createTextVNode(" Mettre à jour ")
              ];
            }
          }),
          _: 1
        }, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`</div>`);
      if (__props.route.reservation.invoice) {
        _push(`<div><a class="bg-secondary mb-2 flex items-center justify-between gap-3 rounded p-3 px-5 font-bold text-white" target="_blank"${ssrRenderAttr("href", __props.route.reservation.invoice)}><i class="pi pi-eye"></i><span class="grow text-center">Voir ma facture</span></a></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div>`);
    };
  }
};
const _sfc_setup$2 = _sfc_main$2.setup;
_sfc_main$2.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/cards/routes/PublishCompleteMain.vue");
  return _sfc_setup$2 ? _sfc_setup$2(props, ctx) : void 0;
};
const __nuxt_component_1 = _sfc_main$2;
const _sfc_main$1 = {
  __name: "PublishCompleteCard",
  __ssrInlineRender: true,
  props: {
    route: {
      type: Object,
      required: true,
      default: () => ({})
    },
    showReservation: {
      type: Boolean,
      default: false
    }
  },
  setup(__props) {
    return (_ctx, _push, _parent, _attrs) => {
      const _component_base_route_card = __nuxt_component_0$1;
      const _component_publish_complete_main = __nuxt_component_1;
      const _component_route_card_footer_info = __nuxt_component_2;
      const _component_price = __nuxt_component_3$2;
      const _component_route_card_requester_footer_info = __nuxt_component_4;
      _push(ssrRenderComponent(_component_base_route_card, mergeProps({ route: __props.route }, _attrs), {
        main: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(ssrRenderComponent(_component_publish_complete_main, { route: __props.route }, null, _parent2, _scopeId));
          } else {
            return [
              createVNode(_component_publish_complete_main, { route: __props.route }, null, 8, ["route"])
            ];
          }
        }),
        footer: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(ssrRenderComponent(_component_route_card_footer_info, {
              class: "mb-10",
              route: __props.route
            }, null, _parent2, _scopeId));
            _push2(`<div class="text-primary mb-5 whitespace-nowrap text-[1.5rem] font-bold"${_scopeId}> Sur votre trajet: </div>`);
            _push2(ssrRenderComponent(_component_base_route_card, {
              route: __props.route.reservation
            }, {
              main: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(ssrRenderComponent(_component_price, {
                    pricing: __props.route.reservation.pricing
                  }, null, _parent3, _scopeId2));
                } else {
                  return [
                    createVNode(_component_price, {
                      pricing: __props.route.reservation.pricing
                    }, null, 8, ["pricing"])
                  ];
                }
              }),
              footer: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(ssrRenderComponent(_component_route_card_requester_footer_info, {
                    requester: __props.route.reservation.requester
                  }, null, _parent3, _scopeId2));
                } else {
                  return [
                    createVNode(_component_route_card_requester_footer_info, {
                      requester: __props.route.reservation.requester
                    }, null, 8, ["requester"])
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
          } else {
            return [
              createVNode(_component_route_card_footer_info, {
                class: "mb-10",
                route: __props.route
              }, null, 8, ["route"]),
              createVNode("div", { class: "text-primary mb-5 whitespace-nowrap text-[1.5rem] font-bold" }, " Sur votre trajet: "),
              createVNode(_component_base_route_card, {
                route: __props.route.reservation
              }, {
                main: withCtx(() => [
                  createVNode(_component_price, {
                    pricing: __props.route.reservation.pricing
                  }, null, 8, ["pricing"])
                ]),
                footer: withCtx(() => [
                  createVNode(_component_route_card_requester_footer_info, {
                    requester: __props.route.reservation.requester
                  }, null, 8, ["requester"])
                ]),
                _: 1
              }, 8, ["route"])
            ];
          }
        }),
        _: 1
      }, _parent));
    };
  }
};
const _sfc_setup$1 = _sfc_main$1.setup;
_sfc_main$1.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/cards/routes/PublishCompleteCard.vue");
  return _sfc_setup$1 ? _sfc_setup$1(props, ctx) : void 0;
};
const PublishCompleteCard = _sfc_main$1;
const _sfc_main = {
  __name: "mes-trajets-publies",
  __ssrInlineRender: true,
  setup(__props) {
    const authStore = useAuthStore();
    const routes2 = ref([]);
    authStore.company;
    const loading = ref(false);
    const tab = ref("publish");
    const computedPublishRoute = computed(() => {
      return routes2.value.filter((route) => route.status === "available").sort((a, b) => new Date(b.created_at) - new Date(a.created_at));
    });
    const computedInProgressRoute = computed(() => {
      return routes2.value.filter((route) => ["planned"].includes(route.status)).sort((a, b) => new Date(b.created_at) - new Date(a.created_at));
    });
    const computedCompletedRoute = computed(() => {
      return routes2.value.filter((route) => route.status === "completed").sort((a, b) => new Date(b.created_at) - new Date(a.created_at));
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_section_wrapper = __nuxt_component_0$3;
      const _component_section_container = __nuxt_component_1$2;
      const _component_form_title = __nuxt_component_4$2;
      const _component_spinner = __nuxt_component_3$3;
      const _component_publish_card = __nuxt_component_4$1;
      const _component_publish_progress_card = __nuxt_component_5;
      _push(`<div${ssrRenderAttrs(_attrs)}>`);
      _push(ssrRenderComponent(_component_section_wrapper, { class: "bg-background-1" }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(ssrRenderComponent(_component_section_container, {
              "mobile-padding": "",
              class: "max-w-container relative z-10 rounded-2xl bg-white px-24 py-10"
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`<div class="flex items-center justify-center gap-5 max-md:flex-wrap"${_scopeId2}><div class="${ssrRenderClass([{
                    "bg-primary text-white": unref(tab) === "publish",
                    "hover:bg-primary-lightest": unref(tab) !== "publish"
                  }, "border-primary text-primary w-1/3 cursor-pointer rounded-xl border-2 p-3 text-center max-md:w-full"])}"${_scopeId2}> En attente (${ssrInterpolate(unref(computedPublishRoute).length)}) </div><div class="${ssrRenderClass([{
                    "bg-primary text-white": unref(tab) === "progress",
                    "hover:bg-primary-lightest": unref(tab) !== "progress"
                  }, "border-primary text-primary w-1/3 cursor-pointer rounded-xl border-2 p-3 text-center max-md:w-full"])}"${_scopeId2}> Planifiés (${ssrInterpolate(unref(computedInProgressRoute).length)}) </div><div class="${ssrRenderClass([{
                    "bg-primary text-white": unref(tab) === "completed",
                    "hover:bg-primary-lightest": unref(tab) !== "completed"
                  }, "border-primary text-primary w-1/3 cursor-pointer rounded-xl border-2 p-3 text-center max-md:w-full"])}"${_scopeId2}> Réalisés (${ssrInterpolate(unref(computedCompletedRoute).length)}) </div></div>`);
                } else {
                  return [
                    createVNode("div", { class: "flex items-center justify-center gap-5 max-md:flex-wrap" }, [
                      createVNode("div", {
                        class: ["border-primary text-primary w-1/3 cursor-pointer rounded-xl border-2 p-3 text-center max-md:w-full", {
                          "bg-primary text-white": unref(tab) === "publish",
                          "hover:bg-primary-lightest": unref(tab) !== "publish"
                        }],
                        onClick: ($event) => tab.value = "publish"
                      }, " En attente (" + toDisplayString(unref(computedPublishRoute).length) + ") ", 11, ["onClick"]),
                      createVNode("div", {
                        class: ["border-primary text-primary w-1/3 cursor-pointer rounded-xl border-2 p-3 text-center max-md:w-full", {
                          "bg-primary text-white": unref(tab) === "progress",
                          "hover:bg-primary-lightest": unref(tab) !== "progress"
                        }],
                        onClick: ($event) => tab.value = "progress"
                      }, " Planifiés (" + toDisplayString(unref(computedInProgressRoute).length) + ") ", 11, ["onClick"]),
                      createVNode("div", {
                        class: ["border-primary text-primary w-1/3 cursor-pointer rounded-xl border-2 p-3 text-center max-md:w-full", {
                          "bg-primary text-white": unref(tab) === "completed",
                          "hover:bg-primary-lightest": unref(tab) !== "completed"
                        }],
                        onClick: ($event) => tab.value = "completed"
                      }, " Réalisés (" + toDisplayString(unref(computedCompletedRoute).length) + ") ", 11, ["onClick"])
                    ])
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
          } else {
            return [
              createVNode(_component_section_container, {
                "mobile-padding": "",
                class: "max-w-container relative z-10 rounded-2xl bg-white px-24 py-10"
              }, {
                default: withCtx(() => [
                  createVNode("div", { class: "flex items-center justify-center gap-5 max-md:flex-wrap" }, [
                    createVNode("div", {
                      class: ["border-primary text-primary w-1/3 cursor-pointer rounded-xl border-2 p-3 text-center max-md:w-full", {
                        "bg-primary text-white": unref(tab) === "publish",
                        "hover:bg-primary-lightest": unref(tab) !== "publish"
                      }],
                      onClick: ($event) => tab.value = "publish"
                    }, " En attente (" + toDisplayString(unref(computedPublishRoute).length) + ") ", 11, ["onClick"]),
                    createVNode("div", {
                      class: ["border-primary text-primary w-1/3 cursor-pointer rounded-xl border-2 p-3 text-center max-md:w-full", {
                        "bg-primary text-white": unref(tab) === "progress",
                        "hover:bg-primary-lightest": unref(tab) !== "progress"
                      }],
                      onClick: ($event) => tab.value = "progress"
                    }, " Planifiés (" + toDisplayString(unref(computedInProgressRoute).length) + ") ", 11, ["onClick"]),
                    createVNode("div", {
                      class: ["border-primary text-primary w-1/3 cursor-pointer rounded-xl border-2 p-3 text-center max-md:w-full", {
                        "bg-primary text-white": unref(tab) === "completed",
                        "hover:bg-primary-lightest": unref(tab) !== "completed"
                      }],
                      onClick: ($event) => tab.value = "completed"
                    }, " Réalisés (" + toDisplayString(unref(computedCompletedRoute).length) + ") ", 11, ["onClick"])
                  ])
                ]),
                _: 1
              })
            ];
          }
        }),
        _: 1
      }, _parent));
      if (unref(tab) === "publish") {
        _push(ssrRenderComponent(_component_section_wrapper, { class: "bg-background-1" }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(ssrRenderComponent(_component_section_container, {
                "mobile-padding": "",
                class: "max-w-container relative z-10 rounded-2xl bg-white px-24 py-16"
              }, {
                default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    _push3(ssrRenderComponent(_component_form_title, { number: "" }, {
                      default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                        if (_push4) {
                          _push4(`Mes trajets en attente`);
                        } else {
                          return [
                            createTextVNode("Mes trajets en attente")
                          ];
                        }
                      }),
                      _: 1
                    }, _parent3, _scopeId2));
                    if (unref(loading)) {
                      _push3(ssrRenderComponent(_component_spinner, { class: "mx-auto" }, null, _parent3, _scopeId2));
                    } else if (!unref(loading) && unref(computedPublishRoute).length === 0) {
                      _push3(`<div class="text-primary-lightest flex h-[20rem] items-center justify-center text-4xl font-bold uppercase"${_scopeId2}> Aucun trajet publié </div>`);
                    } else {
                      _push3(`<div class="flex flex-col gap-6"${_scopeId2}><!--[-->`);
                      ssrRenderList(unref(computedPublishRoute), (route) => {
                        _push3(ssrRenderComponent(_component_publish_card, { route }, null, _parent3, _scopeId2));
                      });
                      _push3(`<!--]--></div>`);
                    }
                  } else {
                    return [
                      createVNode(_component_form_title, { number: "" }, {
                        default: withCtx(() => [
                          createTextVNode("Mes trajets en attente")
                        ]),
                        _: 1
                      }),
                      unref(loading) ? (openBlock(), createBlock(_component_spinner, {
                        key: 0,
                        class: "mx-auto"
                      })) : !unref(loading) && unref(computedPublishRoute).length === 0 ? (openBlock(), createBlock("div", {
                        key: 1,
                        class: "text-primary-lightest flex h-[20rem] items-center justify-center text-4xl font-bold uppercase"
                      }, " Aucun trajet publié ")) : (openBlock(), createBlock("div", {
                        key: 2,
                        class: "flex flex-col gap-6"
                      }, [
                        (openBlock(true), createBlock(Fragment, null, renderList(unref(computedPublishRoute), (route) => {
                          return openBlock(), createBlock(_component_publish_card, { route }, null, 8, ["route"]);
                        }), 256))
                      ]))
                    ];
                  }
                }),
                _: 1
              }, _parent2, _scopeId));
            } else {
              return [
                createVNode(_component_section_container, {
                  "mobile-padding": "",
                  class: "max-w-container relative z-10 rounded-2xl bg-white px-24 py-16"
                }, {
                  default: withCtx(() => [
                    createVNode(_component_form_title, { number: "" }, {
                      default: withCtx(() => [
                        createTextVNode("Mes trajets en attente")
                      ]),
                      _: 1
                    }),
                    unref(loading) ? (openBlock(), createBlock(_component_spinner, {
                      key: 0,
                      class: "mx-auto"
                    })) : !unref(loading) && unref(computedPublishRoute).length === 0 ? (openBlock(), createBlock("div", {
                      key: 1,
                      class: "text-primary-lightest flex h-[20rem] items-center justify-center text-4xl font-bold uppercase"
                    }, " Aucun trajet publié ")) : (openBlock(), createBlock("div", {
                      key: 2,
                      class: "flex flex-col gap-6"
                    }, [
                      (openBlock(true), createBlock(Fragment, null, renderList(unref(computedPublishRoute), (route) => {
                        return openBlock(), createBlock(_component_publish_card, { route }, null, 8, ["route"]);
                      }), 256))
                    ]))
                  ]),
                  _: 1
                })
              ];
            }
          }),
          _: 1
        }, _parent));
      } else {
        _push(`<!---->`);
      }
      if (unref(tab) === "progress") {
        _push(ssrRenderComponent(_component_section_wrapper, { class: "bg-background-1" }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(ssrRenderComponent(_component_section_container, {
                "mobile-padding": "",
                class: "max-w-container relative z-10 rounded-2xl bg-white px-24 py-16"
              }, {
                default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    _push3(ssrRenderComponent(_component_form_title, { number: "" }, {
                      default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                        if (_push4) {
                          _push4(`Mes trajets planifiés`);
                        } else {
                          return [
                            createTextVNode("Mes trajets planifiés")
                          ];
                        }
                      }),
                      _: 1
                    }, _parent3, _scopeId2));
                    if (unref(loading)) {
                      _push3(ssrRenderComponent(_component_spinner, { class: "mx-auto" }, null, _parent3, _scopeId2));
                    } else if (!unref(loading) && unref(computedInProgressRoute).length === 0) {
                      _push3(`<div class="text-primary-lightest flex h-[20rem] items-center justify-center text-4xl font-bold uppercase"${_scopeId2}> Aucun trajet en cours </div>`);
                    } else {
                      _push3(`<div class="flex flex-col gap-6"${_scopeId2}><!--[-->`);
                      ssrRenderList(unref(computedInProgressRoute), (route) => {
                        _push3(ssrRenderComponent(_component_publish_progress_card, {
                          route,
                          "show-reservation": ""
                        }, null, _parent3, _scopeId2));
                      });
                      _push3(`<!--]--></div>`);
                    }
                  } else {
                    return [
                      createVNode(_component_form_title, { number: "" }, {
                        default: withCtx(() => [
                          createTextVNode("Mes trajets planifiés")
                        ]),
                        _: 1
                      }),
                      unref(loading) ? (openBlock(), createBlock(_component_spinner, {
                        key: 0,
                        class: "mx-auto"
                      })) : !unref(loading) && unref(computedInProgressRoute).length === 0 ? (openBlock(), createBlock("div", {
                        key: 1,
                        class: "text-primary-lightest flex h-[20rem] items-center justify-center text-4xl font-bold uppercase"
                      }, " Aucun trajet en cours ")) : (openBlock(), createBlock("div", {
                        key: 2,
                        class: "flex flex-col gap-6"
                      }, [
                        (openBlock(true), createBlock(Fragment, null, renderList(unref(computedInProgressRoute), (route) => {
                          return openBlock(), createBlock(_component_publish_progress_card, {
                            route,
                            "show-reservation": ""
                          }, null, 8, ["route"]);
                        }), 256))
                      ]))
                    ];
                  }
                }),
                _: 1
              }, _parent2, _scopeId));
            } else {
              return [
                createVNode(_component_section_container, {
                  "mobile-padding": "",
                  class: "max-w-container relative z-10 rounded-2xl bg-white px-24 py-16"
                }, {
                  default: withCtx(() => [
                    createVNode(_component_form_title, { number: "" }, {
                      default: withCtx(() => [
                        createTextVNode("Mes trajets planifiés")
                      ]),
                      _: 1
                    }),
                    unref(loading) ? (openBlock(), createBlock(_component_spinner, {
                      key: 0,
                      class: "mx-auto"
                    })) : !unref(loading) && unref(computedInProgressRoute).length === 0 ? (openBlock(), createBlock("div", {
                      key: 1,
                      class: "text-primary-lightest flex h-[20rem] items-center justify-center text-4xl font-bold uppercase"
                    }, " Aucun trajet en cours ")) : (openBlock(), createBlock("div", {
                      key: 2,
                      class: "flex flex-col gap-6"
                    }, [
                      (openBlock(true), createBlock(Fragment, null, renderList(unref(computedInProgressRoute), (route) => {
                        return openBlock(), createBlock(_component_publish_progress_card, {
                          route,
                          "show-reservation": ""
                        }, null, 8, ["route"]);
                      }), 256))
                    ]))
                  ]),
                  _: 1
                })
              ];
            }
          }),
          _: 1
        }, _parent));
      } else {
        _push(`<!---->`);
      }
      if (unref(tab) === "completed") {
        _push(ssrRenderComponent(_component_section_wrapper, { class: "bg-background-1" }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(ssrRenderComponent(_component_section_container, {
                "mobile-padding": "",
                class: "max-w-container relative z-10 rounded-2xl bg-white px-24 py-16"
              }, {
                default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    _push3(ssrRenderComponent(_component_form_title, { number: "" }, {
                      default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                        if (_push4) {
                          _push4(`Mes trajets réalisés`);
                        } else {
                          return [
                            createTextVNode("Mes trajets réalisés")
                          ];
                        }
                      }),
                      _: 1
                    }, _parent3, _scopeId2));
                    if (unref(loading)) {
                      _push3(ssrRenderComponent(_component_spinner, { class: "mx-auto" }, null, _parent3, _scopeId2));
                    } else if (!unref(loading) && unref(computedCompletedRoute).length === 0) {
                      _push3(`<div class="text-primary-lightest flex h-[20rem] items-center justify-center text-4xl font-bold uppercase"${_scopeId2}> Aucun trajet réalisé </div>`);
                    } else {
                      _push3(`<div class="flex flex-col gap-6"${_scopeId2}><!--[-->`);
                      ssrRenderList(unref(computedCompletedRoute), (route) => {
                        _push3(ssrRenderComponent(PublishCompleteCard, {
                          route,
                          "show-reservation": ""
                        }, null, _parent3, _scopeId2));
                      });
                      _push3(`<!--]--></div>`);
                    }
                  } else {
                    return [
                      createVNode(_component_form_title, { number: "" }, {
                        default: withCtx(() => [
                          createTextVNode("Mes trajets réalisés")
                        ]),
                        _: 1
                      }),
                      unref(loading) ? (openBlock(), createBlock(_component_spinner, {
                        key: 0,
                        class: "mx-auto"
                      })) : !unref(loading) && unref(computedCompletedRoute).length === 0 ? (openBlock(), createBlock("div", {
                        key: 1,
                        class: "text-primary-lightest flex h-[20rem] items-center justify-center text-4xl font-bold uppercase"
                      }, " Aucun trajet réalisé ")) : (openBlock(), createBlock("div", {
                        key: 2,
                        class: "flex flex-col gap-6"
                      }, [
                        (openBlock(true), createBlock(Fragment, null, renderList(unref(computedCompletedRoute), (route) => {
                          return openBlock(), createBlock(PublishCompleteCard, {
                            route,
                            "show-reservation": ""
                          }, null, 8, ["route"]);
                        }), 256))
                      ]))
                    ];
                  }
                }),
                _: 1
              }, _parent2, _scopeId));
            } else {
              return [
                createVNode(_component_section_container, {
                  "mobile-padding": "",
                  class: "max-w-container relative z-10 rounded-2xl bg-white px-24 py-16"
                }, {
                  default: withCtx(() => [
                    createVNode(_component_form_title, { number: "" }, {
                      default: withCtx(() => [
                        createTextVNode("Mes trajets réalisés")
                      ]),
                      _: 1
                    }),
                    unref(loading) ? (openBlock(), createBlock(_component_spinner, {
                      key: 0,
                      class: "mx-auto"
                    })) : !unref(loading) && unref(computedCompletedRoute).length === 0 ? (openBlock(), createBlock("div", {
                      key: 1,
                      class: "text-primary-lightest flex h-[20rem] items-center justify-center text-4xl font-bold uppercase"
                    }, " Aucun trajet réalisé ")) : (openBlock(), createBlock("div", {
                      key: 2,
                      class: "flex flex-col gap-6"
                    }, [
                      (openBlock(true), createBlock(Fragment, null, renderList(unref(computedCompletedRoute), (route) => {
                        return openBlock(), createBlock(PublishCompleteCard, {
                          route,
                          "show-reservation": ""
                        }, null, 8, ["route"]);
                      }), 256))
                    ]))
                  ]),
                  _: 1
                })
              ];
            }
          }),
          _: 1
        }, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`</div>`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("pages/dashboard/mes-trajets-publies.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
//# sourceMappingURL=mes-trajets-publies-1610ee3e.js.map
